/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.inline.GrVariableInliner;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineLocalVarSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;

public class GroovyInlineLocalProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(GroovyInlineLocalProcessor.class);
    private final InlineLocalVarSettings mySettings;
    private final GrVariable myLocal;

    public GroovyInlineLocalProcessor(Project project, InlineLocalVarSettings settings, GrVariable local) {
        super(project);
        this.mySettings = settings;
        this.myLocal = local;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            GroovyInlineLocalProcessor.$$$reportNull$$$0(0);
        }
        return new BaseUsageViewDescriptor(new PsiElement[]{this.myLocal});
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usages;
        if (refUsages == null) {
            GroovyInlineLocalProcessor.$$$reportNull$$$0(1);
        }
        MultiMap conflicts = new MultiMap();
        for (UsageInfo usage : usages = (UsageInfo[])refUsages.get()) {
            this.collectConflicts(usage.getReference(), (MultiMap<PsiElement, String>)conflicts);
        }
        return this.showConflicts(conflicts, usages);
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            GroovyInlineLocalProcessor.$$$reportNull$$$0(2);
        }
        for (UsageInfo usage : usages) {
            if (!(usage instanceof ClosureUsage)) continue;
            return true;
        }
        return false;
    }

    private void collectConflicts(PsiReference reference, MultiMap<PsiElement, String> conflicts) {
        GrExpression expr = (GrExpression)reference.getElement();
        if (PsiUtil.isAccessedForWriting(expr)) {
            conflicts.putValue((Object)expr, (Object)GroovyRefactoringBundle.message("variable.is.accessed.for.writing", this.myLocal.getName()));
        }
    }

    protected UsageInfo @NotNull [] findUsages() {
        GroovyControlFlow controlFlow = this.mySettings.getFlow();
        List<BitSet> writes = ControlFlowUtils.inferWriteAccessMap(controlFlow, this.myLocal);
        ArrayList<UsageInfo> toInline = new ArrayList<UsageInfo>();
        GroovyInlineLocalProcessor.collectRefs(this.myLocal, controlFlow.getFlow(), writes, this.mySettings.getWriteInstructionNumber(), toInline);
        UsageInfo[] usageInfoArray = toInline.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            GroovyInlineLocalProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    private static void collectRefs(final GrVariable variable, Instruction[] flow, List<BitSet> writes, int writeInstructionNumber, final ArrayList<UsageInfo> toInline) {
        for (Instruction instruction : flow) {
            BitSet prev;
            PsiElement element = instruction.getElement();
            if (instruction instanceof ReadWriteVariableInstruction) {
                GrReferenceExpression ref2;
                if (((ReadWriteVariableInstruction)instruction).isWrite() || element instanceof GrVariable && element != variable || !(element instanceof GrReferenceExpression) || (ref2 = (GrReferenceExpression)element).isQualified() || ref2.resolve() != variable) continue;
                BitSet prev2 = writes.get(instruction.num());
                if (writeInstructionNumber >= 0 && prev2.cardinality() == 1 && prev2.get(writeInstructionNumber)) {
                    toInline.add(new UsageInfo((PsiQualifiedReferenceElement)ref2));
                    continue;
                }
                if (writeInstructionNumber != -1 || prev2.cardinality() != 0) continue;
                toInline.add(new ClosureUsage((PsiReference)ref2));
                continue;
            }
            if (element instanceof GrClosableBlock) {
                prev = writes.get(instruction.num());
                if ((writeInstructionNumber < 0 || prev.cardinality() != 1 || !prev.get(writeInstructionNumber)) && (writeInstructionNumber != -1 || prev.cardinality() != 0)) continue;
                GroovyControlFlow closureFlow = ControlFlowUtils.getGroovyControlFlow((GrClosableBlock)element);
                GroovyInlineLocalProcessor.collectRefs(variable, closureFlow.getFlow(), ControlFlowUtils.inferWriteAccessMap(closureFlow, variable), -1, toInline);
                continue;
            }
            if (!(element instanceof GrAnonymousClassDefinition)) continue;
            prev = writes.get(instruction.num());
            if ((writeInstructionNumber < 0 || prev.cardinality() != 1 || !prev.get(writeInstructionNumber)) && (writeInstructionNumber != -1 || prev.cardinality() != 0)) continue;
            ((GrAnonymousClassDefinition)element).acceptChildren(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitField(@NotNull GrField field2) {
                    GrExpression initializer;
                    if (field2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((initializer = field2.getInitializerGroovy()) != null) {
                        GroovyControlFlow flow = ControlFlowBuilder.buildControlFlow(initializer);
                        GroovyInlineLocalProcessor.collectRefs(variable, flow.getFlow(), ControlFlowUtils.inferWriteAccessMap(flow, variable), -1, toInline);
                    }
                }

                @Override
                public void visitMethod(@NotNull GrMethod method) {
                    GrOpenBlock block;
                    if (method == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if ((block = method.getBlock()) != null) {
                        GroovyControlFlow flow = ControlFlowUtils.getGroovyControlFlow(block);
                        GroovyInlineLocalProcessor.collectRefs(variable, flow.getFlow(), ControlFlowUtils.inferWriteAccessMap(flow, variable), -1, toInline);
                    }
                }

                @Override
                public void visitClassInitializer(@NotNull GrClassInitializer initializer) {
                    if (initializer == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    GrOpenBlock block = initializer.getBlock();
                    GroovyControlFlow flow = ControlFlowUtils.getGroovyControlFlow(block);
                    GroovyInlineLocalProcessor.collectRefs(variable, flow.getFlow(), ControlFlowUtils.inferWriteAccessMap(flow, variable), -1, toInline);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "field";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "method";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "initializer";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/inline/GroovyInlineLocalProcessor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitField";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethod";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitClassInitializer";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        Collection all;
        if (usages == null) {
            GroovyInlineLocalProcessor.$$$reportNull$$$0(4);
        }
        CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
        GrExpression initializer = this.mySettings.getInitializer();
        GrExpression initializerToUse = GrIntroduceHandlerBase.insertExplicitCastIfNeeded(this.myLocal, this.mySettings.getInitializer());
        for (UsageInfo usage : usages) {
            GrVariableInliner.inlineReference(usage, this.myLocal, initializerToUse);
        }
        PsiElement initializerParent = initializer.getParent();
        if (initializerParent instanceof GrAssignmentExpression) {
            initializerParent.delete();
            return;
        }
        if (initializerParent instanceof GrVariable && !(all = ReferencesSearch.search((PsiElement)this.myLocal).findAll()).isEmpty()) {
            initializer.delete();
            return;
        }
        PsiElement owner = this.myLocal.getParent().getParent();
        if (owner instanceof GrVariableDeclarationOwner) {
            ((GrVariableDeclarationOwner)owner).removeVariable(this.myLocal);
        } else {
            this.myLocal.delete();
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{this.myLocal.getName()});
        if (string == null) {
            GroovyInlineLocalProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/inline/GroovyInlineLocalProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/inline/GroovyInlineLocalProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    private static final class ClosureUsage
    extends UsageInfo {
        private ClosureUsage(@NotNull PsiReference reference) {
            if (reference == null) {
                ClosureUsage.$$$reportNull$$$0(0);
            }
            super(reference);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/groovy/refactoring/inline/GroovyInlineLocalProcessor$ClosureUsage", "<init>"));
        }
    }
}

