/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.impl;

import com.intellij.openapi.util.Pair;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;

@ApiStatus.Internal
public final class DependentJarsEvaluator {
    private final Set<JarInfo> jars = new LinkedHashSet<JarInfo>();

    public void addJarWithDependencies(@NotNull JarInfo jarInfo) {
        if (jarInfo == null) {
            DependentJarsEvaluator.$$$reportNull$$$0(0);
        }
        if (!this.jars.add(jarInfo)) {
            return;
        }
        DestinationInfo destination = jarInfo.getDestination();
        if (destination instanceof JarDestinationInfo) {
            this.addJarWithDependencies(((JarDestinationInfo)destination).getJarInfo());
        }
        for (Pair<String, Object> pair : jarInfo.getContent()) {
            if (!(pair.getSecond() instanceof JarInfo)) continue;
            this.addJarWithDependencies((JarInfo)pair.getSecond());
        }
    }

    public Set<JarInfo> getJars() {
        return this.jars;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarInfo", "org/jetbrains/jps/incremental/artifacts/impl/DependentJarsEvaluator", "addJarWithDependencies"));
    }
}

