/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.platform.recentFiles.frontend.SwitcherListItem;
import com.intellij.platform.recentFiles.frontend.SwitcherRenderingKt;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B.\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\r\u0010\b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0016J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c6\u0003J\u0010\u0010'\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\tH\u00c6\u0003J8\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000f\b\u0002\u0010\b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\tH\u00c6\u0001J\u0013\u0010)\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0019\u0010\u0013\u001a\u00070\u0005\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000fR\u0019\u0010\u0015\u001a\u00070\u0005\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u0019\u0010\u0017\u001a\u00070\u0005\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000fR\u001b\u0010\u0019\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u0014\u0010\u001b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011R\u0013\u0010\u001d\u001a\u00070\u0005\u00a2\u0006\u0002\b\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/platform/recentFiles/frontend/SwitcherToolWindow;", "Lcom/intellij/platform/recentFiles/frontend/SwitcherListItem;", "window", "Lcom/intellij/openapi/wm/ToolWindow;", "id", "", "shortcut", "", "mnemonic", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/openapi/wm/ToolWindow;Ljava/lang/String;ZLjava/lang/String;)V", "getWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "getId", "()Ljava/lang/String;", "getShortcut", "()Z", "getMnemonic", "mainText", "getMainText", "statusText", "getStatusText", "pathText", "getPathText", "shortcutText", "getShortcutText", "separatorAbove", "getSeparatorAbove", "actionId", "Lorg/jetbrains/annotations/NonNls;", "prepareMainRenderer", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "selected", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.platform.recentFiles.frontend"})
@ApiStatus.Internal
public final class SwitcherToolWindow
implements SwitcherListItem {
    @NotNull
    private final ToolWindow window;
    @NotNull
    private final String id;
    private final boolean shortcut;
    @Nullable
    private final String mnemonic;
    @NotNull
    private final String actionId;

    public SwitcherToolWindow(@NotNull ToolWindow window, @NotNull String id, boolean shortcut, @Nullable String mnemonic) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.window = window;
        this.id = id;
        this.shortcut = shortcut;
        this.mnemonic = mnemonic;
        String string = this.window.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        this.actionId = ActivateToolWindowAction.Manager.getActionIdForToolWindow((String)string);
    }

    @NotNull
    public final ToolWindow getWindow() {
        return this.window;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final boolean getShortcut() {
        return this.shortcut;
    }

    @Override
    @Nullable
    public String getMnemonic() {
        return this.mnemonic;
    }

    @Override
    @NotNull
    public String getMainText() {
        String string = this.window.getStripeTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStripeTitle(...)");
        return string;
    }

    @Override
    @NotNull
    public String getStatusText() {
        Object[] objectArray = new Object[]{this.getMainText()};
        String string = IdeBundle.message((String)"recent.files.accessible.show.tool.window", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getPathText() {
        return "";
    }

    @Override
    @Nullable
    public String getShortcutText() {
        return this.shortcut ? SwitcherRenderingKt.shortcutText(this.actionId) : null;
    }

    @Override
    public boolean getSeparatorAbove() {
        return false;
    }

    @Override
    public void prepareMainRenderer(@NotNull SimpleColoredComponent component, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Icon defaultIcon = ExperimentalUI.Companion.isNewUI() ? EmptyIcon.ICON_16 : EmptyIcon.ICON_13;
        component.setIconTextGap(JBUI.CurrentTheme.ActionsList.elementIconGap());
        Icon icon = ExperimentalUI.Companion.isNewUI() ? this.window.getIcon() : RenderingUtil.getIcon((Icon)this.window.getIcon(), (boolean)selected);
        Intrinsics.checkNotNull((Object)defaultIcon);
        component.setIcon(IconUtil.scaleByIconWidth((Icon)icon, null, (Icon)defaultIcon));
        component.append(this.getMainText());
    }

    @NotNull
    public final ToolWindow component1() {
        return this.window;
    }

    @NotNull
    public final String component2() {
        return this.id;
    }

    public final boolean component3() {
        return this.shortcut;
    }

    @Nullable
    public final String component4() {
        return this.mnemonic;
    }

    @NotNull
    public final SwitcherToolWindow copy(@NotNull ToolWindow window, @NotNull String id, boolean shortcut, @Nullable String mnemonic) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new SwitcherToolWindow(window, id, shortcut, mnemonic);
    }

    public static /* synthetic */ SwitcherToolWindow copy$default(SwitcherToolWindow switcherToolWindow, ToolWindow toolWindow, String string, boolean bl, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            toolWindow = switcherToolWindow.window;
        }
        if ((n & 2) != 0) {
            string = switcherToolWindow.id;
        }
        if ((n & 4) != 0) {
            bl = switcherToolWindow.shortcut;
        }
        if ((n & 8) != 0) {
            string2 = switcherToolWindow.mnemonic;
        }
        return switcherToolWindow.copy(toolWindow, string, bl, string2);
    }

    @NotNull
    public String toString() {
        return "SwitcherToolWindow(window=" + this.window + ", id=" + this.id + ", shortcut=" + this.shortcut + ", mnemonic=" + this.mnemonic + ")";
    }

    public int hashCode() {
        int result = this.window.hashCode();
        result = result * 31 + this.id.hashCode();
        result = result * 31 + Boolean.hashCode(this.shortcut);
        result = result * 31 + (this.mnemonic == null ? 0 : this.mnemonic.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwitcherToolWindow)) {
            return false;
        }
        SwitcherToolWindow switcherToolWindow = (SwitcherToolWindow)other;
        if (!Intrinsics.areEqual((Object)this.window, (Object)switcherToolWindow.window)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.id, (Object)switcherToolWindow.id)) {
            return false;
        }
        if (this.shortcut != switcherToolWindow.shortcut) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mnemonic, (Object)switcherToolWindow.mnemonic);
    }
}

