/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch.web;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.quicksearch.web.Item;

final class Result {
    private List<Item> items = new ArrayList<Item>(50);
    private boolean searchFinished = false;

    Result() {
    }

    public List<Item> getItems() {
        return this.items;
    }

    public boolean isSearchFinished() {
        return this.searchFinished;
    }

    void parse(String string, int n) {
        this.searchFinished = true;
        this.items.clear();
        string = new String(string.getBytes(), StandardCharsets.UTF_8);
        Pattern pattern = Pattern.compile("<a\\s+href\\s*=\\s*\"(.*?)\"[^>]*>(.*?)</a>", 10);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            if (string2.startsWith("/")) {
                int n2 = this.findSearchOffset(string2);
                if (n2 <= n) continue;
                this.searchFinished = false;
                continue;
            }
            if (string2.contains("google.com")) continue;
            string3 = "<html>" + string3;
            Item item = new Item(string2, string3, null);
            this.items.add(item);
        }
    }

    public void filterUrl(String[] stringArray) {
        if (null == stringArray || stringArray.length == 0) {
            return;
        }
        ArrayList<Item> arrayList = new ArrayList<Item>(this.items.size());
        block0: for (Item item : this.items) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() == 0 || !item.getUrl().toLowerCase(Locale.ENGLISH).matches(stringArray[i])) continue;
                arrayList.add(item);
                continue block0;
            }
        }
        this.items = arrayList;
    }

    private int findSearchOffset(String string) {
        int n = string.indexOf("&amp;start=");
        if (n < 0) {
            return -1;
        }
        int n2 = string.indexOf("&amp;", n + 1);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n2 < n) {
            return -1;
        }
        String string2 = string.substring(n, n2);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

