"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveEmbeddedCode = resolveEmbeddedCode;
const vscode_uri_1 = require("vscode-uri");
function resolveEmbeddedCode(context, uriStr) {
    const uri = vscode_uri_1.URI.parse(uriStr);
    const decoded = context.decodeEmbeddedDocumentUri(uri);
    if (!decoded) {
        return;
    }
    const sourceScript = context.language.scripts.get(decoded[0]);
    const code = sourceScript.generated.embeddedCodes.get(decoded[1]);
    return {
        script: sourceScript,
        code,
        root: sourceScript.generated.root,
    };
}
//# sourceMappingURL=utils.js.map