/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI;

import com.zeroc.Ice.Current;
import com.zeroc.IceGrid.RegistryInfo;
import com.zeroc.IceGrid.RegistryObserver;
import com.zeroc.IceGridGUI.Coordinator;
import javax.swing.SwingUtilities;

class RegistryObserverI
implements RegistryObserver {
    private final Coordinator _coordinator;
    private final boolean _trace;

    RegistryObserverI(Coordinator coordinator) {
        this._coordinator = coordinator;
        this._trace = this._coordinator.traceObservers();
    }

    @Override
    public void registryInit(RegistryInfo[] registryInfos, Current current) {
        if (this._trace) {
            if (registryInfos.length == 0) {
                this._coordinator.traceObserver("registryInit (no registry)");
            } else {
                String names = "";
                for (RegistryInfo info : registryInfos) {
                    names = names + " " + info.name;
                }
                this._coordinator.traceObserver("registryInit for registr" + (registryInfos.length == 1 ? "y" : "ies") + names);
            }
        }
        SwingUtilities.invokeLater(() -> {
            for (RegistryInfo info : registryInfos) {
                this._coordinator.registryUp(info);
            }
        });
    }

    @Override
    public void registryUp(RegistryInfo registryInfo, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("registryUp for registry " + registryInfo.name);
        }
        SwingUtilities.invokeLater(() -> this._coordinator.registryUp(registryInfo));
    }

    @Override
    public void registryDown(String registryName, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("registryDown for registry " + registryName);
        }
        SwingUtilities.invokeLater(() -> this._coordinator.registryDown(registryName));
    }
}

