﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/forecast/ForecastService_EXPORTS.h>
#include <aws/forecast/model/ForecastSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ForecastService {
namespace Model {
class ListForecastsResult {
 public:
  AWS_FORECASTSERVICE_API ListForecastsResult() = default;
  AWS_FORECASTSERVICE_API ListForecastsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_FORECASTSERVICE_API ListForecastsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of objects that summarize each forecast's properties.</p>
   */
  inline const Aws::Vector<ForecastSummary>& GetForecasts() const { return m_forecasts; }
  template <typename ForecastsT = Aws::Vector<ForecastSummary>>
  void SetForecasts(ForecastsT&& value) {
    m_forecastsHasBeenSet = true;
    m_forecasts = std::forward<ForecastsT>(value);
  }
  template <typename ForecastsT = Aws::Vector<ForecastSummary>>
  ListForecastsResult& WithForecasts(ForecastsT&& value) {
    SetForecasts(std::forward<ForecastsT>(value));
    return *this;
  }
  template <typename ForecastsT = ForecastSummary>
  ListForecastsResult& AddForecasts(ForecastsT&& value) {
    m_forecastsHasBeenSet = true;
    m_forecasts.emplace_back(std::forward<ForecastsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the response is truncated, Amazon Forecast returns this token. To retrieve
   * the next set of results, use the token in the next request.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListForecastsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListForecastsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ForecastSummary> m_forecasts;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_forecastsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ForecastService
}  // namespace Aws
