﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lightsail/Lightsail_EXPORTS.h>
#include <aws/lightsail/model/KeyPair.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Lightsail {
namespace Model {
class GetKeyPairsResult {
 public:
  AWS_LIGHTSAIL_API GetKeyPairsResult() = default;
  AWS_LIGHTSAIL_API GetKeyPairsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LIGHTSAIL_API GetKeyPairsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of key-value pairs containing information about the key pairs.</p>
   */
  inline const Aws::Vector<KeyPair>& GetKeyPairs() const { return m_keyPairs; }
  template <typename KeyPairsT = Aws::Vector<KeyPair>>
  void SetKeyPairs(KeyPairsT&& value) {
    m_keyPairsHasBeenSet = true;
    m_keyPairs = std::forward<KeyPairsT>(value);
  }
  template <typename KeyPairsT = Aws::Vector<KeyPair>>
  GetKeyPairsResult& WithKeyPairs(KeyPairsT&& value) {
    SetKeyPairs(std::forward<KeyPairsT>(value));
    return *this;
  }
  template <typename KeyPairsT = KeyPair>
  GetKeyPairsResult& AddKeyPairs(KeyPairsT&& value) {
    m_keyPairsHasBeenSet = true;
    m_keyPairs.emplace_back(std::forward<KeyPairsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to advance to the next page of results from your request.</p> <p>A
   * next page token is not returned if there are no more results to display.</p>
   * <p>To get the next page of results, perform another <code>GetKeyPairs</code>
   * request and specify the next page token using the <code>pageToken</code>
   * parameter.</p>
   */
  inline const Aws::String& GetNextPageToken() const { return m_nextPageToken; }
  template <typename NextPageTokenT = Aws::String>
  void SetNextPageToken(NextPageTokenT&& value) {
    m_nextPageTokenHasBeenSet = true;
    m_nextPageToken = std::forward<NextPageTokenT>(value);
  }
  template <typename NextPageTokenT = Aws::String>
  GetKeyPairsResult& WithNextPageToken(NextPageTokenT&& value) {
    SetNextPageToken(std::forward<NextPageTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetKeyPairsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<KeyPair> m_keyPairs;

  Aws::String m_nextPageToken;

  Aws::String m_requestId;
  bool m_keyPairsHasBeenSet = false;
  bool m_nextPageTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
