﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sns/SNS_EXPORTS.h>
#include <aws/sns/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace SNS {
namespace Model {
class GetSMSSandboxAccountStatusResult {
 public:
  AWS_SNS_API GetSMSSandboxAccountStatusResult() = default;
  AWS_SNS_API GetSMSSandboxAccountStatusResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_SNS_API GetSMSSandboxAccountStatusResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Indicates whether the calling Amazon Web Services account is in the SMS
   * sandbox.</p>
   */
  inline bool GetIsInSandbox() const { return m_isInSandbox; }
  inline void SetIsInSandbox(bool value) {
    m_isInSandboxHasBeenSet = true;
    m_isInSandbox = value;
  }
  inline GetSMSSandboxAccountStatusResult& WithIsInSandbox(bool value) {
    SetIsInSandbox(value);
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  GetSMSSandboxAccountStatusResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  bool m_isInSandbox{false};

  ResponseMetadata m_responseMetadata;
  bool m_isInSandboxHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace SNS
}  // namespace Aws
