/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.comparesegments;

import java.util.List;
import tim.prune.data.DataPoint;
import tim.prune.function.PointUtils;
import tim.prune.function.comparesegments.IntersectionResult;

class TimeCalculations {
    TimeCalculations() {
    }

    public static Double findSecondDistanceAtSameTime(List<IntersectionResult> list, long l) {
        TimeResult timeResult = TimeCalculations.findResultsAtSameTime(list, l);
        if (timeResult == null || timeResult._fraction < 0.0 || timeResult._fraction > 1.0) {
            return null;
        }
        double d = timeResult._resultBefore.getSecondDistanceRadians(timeResult._firstResult);
        double d2 = timeResult._resultAfter.getSecondDistanceRadians(timeResult._firstResult) - d;
        if (d2 < 0.0) {
            return null;
        }
        return d + timeResult._fraction;
    }

    public static DataPoint findSecondPointAtSameTime(List<IntersectionResult> list, long l) {
        TimeResult timeResult = TimeCalculations.findResultsAtSameTime(list, l);
        if (timeResult == null || timeResult._fraction < 0.0 || timeResult._fraction > 1.0) {
            return null;
        }
        DataPoint dataPoint = timeResult._resultBefore.getSecondPoint();
        DataPoint dataPoint2 = timeResult._resultAfter.getSecondPoint();
        return PointUtils.interpolate(dataPoint, dataPoint2, timeResult._fraction);
    }

    private static TimeResult findResultsAtSameTime(List<IntersectionResult> list, long l) {
        IntersectionResult intersectionResult = null;
        IntersectionResult intersectionResult2 = null;
        IntersectionResult intersectionResult3 = null;
        long l2 = 0L;
        long l3 = 0L;
        for (IntersectionResult intersectionResult4 : list) {
            long l4;
            if (intersectionResult == null) {
                intersectionResult = intersectionResult4;
                l4 = 0L;
            } else {
                l4 = intersectionResult4.getSecondDurationSeconds(intersectionResult);
            }
            if (l4 < l) {
                if (intersectionResult2 != null && l - l4 >= l2) continue;
                intersectionResult2 = intersectionResult4;
                l2 = l - l4;
                continue;
            }
            if (l4 == l) {
                return new TimeResult(intersectionResult, intersectionResult4, intersectionResult4, 0.0);
            }
            if (intersectionResult3 != null && l4 - l >= l3) continue;
            intersectionResult3 = intersectionResult4;
            l3 = l4 - l;
        }
        if (intersectionResult2 == null || intersectionResult3 == null) {
            return null;
        }
        double d = intersectionResult2.getSecondDistanceRadians(intersectionResult);
        double d2 = intersectionResult3.getSecondDistanceRadians(intersectionResult) - d;
        if (d2 < 0.0) {
            return null;
        }
        long l5 = intersectionResult3.getSecondDurationSeconds(intersectionResult2);
        return new TimeResult(intersectionResult, intersectionResult2, intersectionResult3, 1.0 * (double)l2 / (double)l5);
    }

    private static class TimeResult {
        private final IntersectionResult _firstResult;
        private final IntersectionResult _resultBefore;
        private final IntersectionResult _resultAfter;
        private final double _fraction;

        public TimeResult(IntersectionResult intersectionResult, IntersectionResult intersectionResult2, IntersectionResult intersectionResult3, double d) {
            this._firstResult = intersectionResult;
            this._resultBefore = intersectionResult2;
            this._resultAfter = intersectionResult3;
            this._fraction = d;
        }
    }
}

