/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.SimpleMethodHandle;
import java.util.Arrays;

abstract class DelegatingMethodHandle
extends MethodHandle {
    static final LambdaForm.NamedFunction NF_getTarget;

    protected DelegatingMethodHandle(MethodHandle methodHandle) {
        this(methodHandle.type(), methodHandle);
    }

    protected DelegatingMethodHandle(MethodType methodType, MethodHandle methodHandle) {
        super(methodType, DelegatingMethodHandle.chooseDelegatingForm(methodHandle));
    }

    protected DelegatingMethodHandle(MethodType methodType, LambdaForm lambdaForm) {
        super(methodType, lambdaForm);
    }

    protected abstract MethodHandle getTarget();

    @Override
    abstract MethodHandle asTypeUncached(MethodType var1);

    @Override
    MemberName internalMemberName() {
        return this.getTarget().internalMemberName();
    }

    @Override
    boolean isInvokeSpecial() {
        return this.getTarget().isInvokeSpecial();
    }

    @Override
    Class<?> internalCallerClass() {
        return this.getTarget().internalCallerClass();
    }

    @Override
    MethodHandle copyWith(MethodType methodType, LambdaForm lambdaForm) {
        throw MethodHandleStatics.newIllegalArgumentException("do not use this");
    }

    @Override
    String internalProperties() {
        return "\n& Class=" + this.getClass().getSimpleName() + "\n& Target=" + this.getTarget().debugString();
    }

    @Override
    BoundMethodHandle rebind() {
        return this.getTarget().rebind();
    }

    private static LambdaForm chooseDelegatingForm(MethodHandle methodHandle) {
        if (methodHandle instanceof SimpleMethodHandle) {
            return methodHandle.internalForm();
        }
        return DelegatingMethodHandle.makeReinvokerForm(methodHandle, 8, DelegatingMethodHandle.class, NF_getTarget);
    }

    static LambdaForm makeReinvokerForm(MethodHandle methodHandle, int n, Object object, LambdaForm.NamedFunction namedFunction) {
        String string;
        switch (n) {
            case 7: {
                string = "BMH.reinvoke";
                break;
            }
            case 8: {
                string = "MH.delegate";
                break;
            }
            default: {
                string = "MH.reinvoke";
            }
        }
        return DelegatingMethodHandle.makeReinvokerForm(methodHandle, n, object, string, true, namedFunction, null);
    }

    static LambdaForm makeReinvokerForm(MethodHandle methodHandle, int n, Object object, String string, boolean bl, LambdaForm.NamedFunction namedFunction, LambdaForm.NamedFunction namedFunction2) {
        int n2;
        LambdaForm lambdaForm;
        boolean bl2;
        MethodType methodType = methodHandle.type().basicType();
        boolean bl3 = n < 0 || methodType.parameterSlotCount() > 253;
        boolean bl4 = bl2 = namedFunction2 != null;
        if (!bl3 && (lambdaForm = methodType.form().cachedLambdaForm(n)) != null) {
            return lambdaForm;
        }
        int n3 = n2 = 1 + methodType.parameterCount();
        int n4 = bl2 ? n3++ : -1;
        int n5 = bl3 ? -1 : n3++;
        int n6 = n3++;
        LambdaForm.Name[] nameArray = LambdaForm.arguments(n3 - n2, methodType.invokerType());
        assert (nameArray.length == n3);
        nameArray[0] = nameArray[0].withConstraint(object);
        if (bl2) {
            nameArray[n4] = new LambdaForm.Name(namedFunction2, nameArray[0]);
        }
        if (bl3) {
            Object[] objectArray = Arrays.copyOfRange(nameArray, 1, n2, Object[].class);
            nameArray[n6] = new LambdaForm.Name(methodHandle, objectArray);
        } else {
            nameArray[n5] = new LambdaForm.Name(namedFunction, nameArray[0]);
            Object[] objectArray = Arrays.copyOfRange(nameArray, 0, n2, Object[].class);
            objectArray[0] = nameArray[n5];
            nameArray[n6] = new LambdaForm.Name(methodType, objectArray);
        }
        lambdaForm = new LambdaForm(string, n2, nameArray, bl);
        if (!bl3) {
            lambdaForm = methodType.form().setCachedLambdaForm(n, lambdaForm);
        }
        return lambdaForm;
    }

    static {
        try {
            NF_getTarget = new LambdaForm.NamedFunction(DelegatingMethodHandle.class.getDeclaredMethod("getTarget", new Class[0]));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError(reflectiveOperationException);
        }
    }
}

