function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = _getPrototypeOf(t); if (r) { var s = _getPrototypeOf(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return _possibleConstructorReturn(this, e); }; }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { prettyDuration, showPrettyDuration, commonDurationRanges } from './pretty_duration';
import { prettyInterval } from './pretty_interval';
import dateMath from '@opensearch/datemath';
import { EuiSuperUpdateButton } from './super_update_button';
import { EuiQuickSelectPopover } from './quick_select_popover/quick_select_popover';
import { EuiDatePopoverButton } from './date_popover/date_popover_button';
import { EuiDatePickerRange } from '../date_picker_range';
import { EuiFormControlLayout } from '../../form';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { AsyncInterval } from './async_interval';
import { EuiI18n } from '../../i18n';
import { EuiI18nConsumer } from '../../context';
// eslint-disable-line import/named

export { prettyDuration, commonDurationRanges };
function isRangeInvalid(start, end) {
  if (start === 'now' && end === 'now') {
    return true;
  }
  var startMoment = dateMath.parse(start);
  var endMoment = dateMath.parse(end, {
    roundUp: true
  });
  if (!startMoment || !endMoment || !startMoment.isValid() || !endMoment.isValid()) {
    return true;
  }
  if (startMoment.isAfter(endMoment)) {
    return true;
  }
  return false;
}
export var EuiSuperDatePicker = /*#__PURE__*/function (_Component) {
  _inherits(EuiSuperDatePicker, _Component);
  var _super = _createSuper(EuiSuperDatePicker);
  function EuiSuperDatePicker() {
    var _this;
    _classCallCheck(this, EuiSuperDatePicker);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "asyncInterval", void 0);
    _defineProperty(_assertThisInitialized(_this), "state", {
      prevProps: {
        start: _this.props.start,
        end: _this.props.end
      },
      start: _this.props.start,
      end: _this.props.end,
      isInvalid: isRangeInvalid(_this.props.start, _this.props.end),
      hasChanged: false,
      showPrettyDuration: showPrettyDuration(_this.props.start, _this.props.end, _this.props.commonlyUsedRanges),
      isStartDatePopoverOpen: false,
      isEndDatePopoverOpen: false
    });
    _defineProperty(_assertThisInitialized(_this), "setTime", function (_ref) {
      var end = _ref.end,
        start = _ref.start;
      var isInvalid = isRangeInvalid(start, end);
      _this.setState({
        start: start,
        end: end,
        isInvalid: isInvalid,
        hasChanged: !(_this.state.prevProps.start === start && _this.state.prevProps.end === end)
      });
      if (!_this.props.showUpdateButton) {
        _this.props.onTimeChange({
          start: start,
          end: end,
          isQuickSelection: false,
          isInvalid: isInvalid
        });
      }
    });
    _defineProperty(_assertThisInitialized(_this), "componentDidMount", function () {
      if (!_this.props.isPaused) {
        _this.startInterval(_this.props.refreshInterval);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "componentDidUpdate", function () {
      _this.stopInterval();
      if (!_this.props.isPaused) {
        _this.startInterval(_this.props.refreshInterval);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "componentWillUnmount", function () {
      _this.stopInterval();
    });
    _defineProperty(_assertThisInitialized(_this), "setStart", function (start) {
      _this.setTime({
        start: start,
        end: _this.state.end
      });
    });
    _defineProperty(_assertThisInitialized(_this), "setEnd", function (end) {
      _this.setTime({
        start: _this.state.start,
        end: end
      });
    });
    _defineProperty(_assertThisInitialized(_this), "applyTime", function () {
      _this.props.onTimeChange({
        start: _this.state.start,
        end: _this.state.end,
        isQuickSelection: false,
        isInvalid: false
      });
    });
    _defineProperty(_assertThisInitialized(_this), "applyQuickTime", function (_ref2) {
      var start = _ref2.start,
        end = _ref2.end;
      _this.setState({
        showPrettyDuration: showPrettyDuration(start, end, commonDurationRanges)
      });
      _this.props.onTimeChange({
        start: start,
        end: end,
        isQuickSelection: true,
        isInvalid: false
      });
    });
    _defineProperty(_assertThisInitialized(_this), "hidePrettyDuration", function () {
      _this.setState({
        showPrettyDuration: false,
        isStartDatePopoverOpen: true
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onStartDatePopoverToggle", function () {
      _this.setState(function (prevState) {
        return {
          isStartDatePopoverOpen: !prevState.isStartDatePopoverOpen
        };
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onStartDatePopoverClose", function () {
      _this.setState({
        isStartDatePopoverOpen: false
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onEndDatePopoverToggle", function () {
      _this.setState(function (prevState) {
        return {
          isEndDatePopoverOpen: !prevState.isEndDatePopoverOpen
        };
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onEndDatePopoverClose", function () {
      _this.setState({
        isEndDatePopoverOpen: false
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onRefreshChange", function (_ref3) {
      var refreshInterval = _ref3.refreshInterval,
        isPaused = _ref3.isPaused;
      _this.stopInterval();
      if (!isPaused) {
        _this.startInterval(refreshInterval);
      }
      if (_this.props.onRefreshChange) {
        _this.props.onRefreshChange({
          refreshInterval: refreshInterval,
          isPaused: isPaused
        });
      }
    });
    _defineProperty(_assertThisInitialized(_this), "stopInterval", function () {
      if (_this.asyncInterval) {
        _this.asyncInterval.stop();
      }
    });
    _defineProperty(_assertThisInitialized(_this), "startInterval", function (refreshInterval) {
      var onRefresh = _this.props.onRefresh;
      if (onRefresh) {
        var handler = function handler() {
          var _this$props = _this.props,
            start = _this$props.start,
            end = _this$props.end;
          onRefresh({
            start: start,
            end: end,
            refreshInterval: refreshInterval
          });
        };
        _this.asyncInterval = new AsyncInterval(handler, refreshInterval);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "renderDatePickerRange", function () {
      var _this$state = _this.state,
        end = _this$state.end,
        hasChanged = _this$state.hasChanged,
        isEndDatePopoverOpen = _this$state.isEndDatePopoverOpen,
        isInvalid = _this$state.isInvalid,
        isStartDatePopoverOpen = _this$state.isStartDatePopoverOpen,
        showPrettyDuration = _this$state.showPrettyDuration,
        start = _this$state.start;
      var _this$props2 = _this.props,
        commonlyUsedRanges = _this$props2.commonlyUsedRanges,
        dateFormat = _this$props2.dateFormat,
        isAutoRefreshOnly = _this$props2.isAutoRefreshOnly,
        isDisabled = _this$props2.isDisabled,
        isPaused = _this$props2.isPaused,
        locale = _this$props2.locale,
        refreshInterval = _this$props2.refreshInterval,
        timeFormat = _this$props2.timeFormat,
        utcOffset = _this$props2.utcOffset,
        compressed = _this$props2.compressed;
      if (isAutoRefreshOnly) {
        return /*#__PURE__*/React.createElement(EuiDatePickerRange, {
          className: "euiDatePickerRange--inGroup",
          iconType: false,
          isCustom: true,
          startDateControl: /*#__PURE__*/React.createElement("div", null),
          endDateControl: /*#__PURE__*/React.createElement("div", null),
          readOnly: true
        }, /*#__PURE__*/React.createElement("span", {
          className: "euiSuperDatePicker__prettyFormat"
        }, prettyInterval(Boolean(isPaused), refreshInterval)));
      }
      if (showPrettyDuration && !isStartDatePopoverOpen && !isEndDatePopoverOpen) {
        return /*#__PURE__*/React.createElement(EuiDatePickerRange, {
          className: "euiDatePickerRange--inGroup",
          iconType: false,
          isCustom: true,
          startDateControl: /*#__PURE__*/React.createElement("div", null),
          endDateControl: /*#__PURE__*/React.createElement("div", null)
        }, /*#__PURE__*/React.createElement("button", {
          className: classNames('euiSuperDatePicker__prettyFormat', {
            'euiSuperDatePicker__prettyFormat--disabled': isDisabled,
            'euiSuperDatePicker__prettyFormat--compressed': compressed
          }),
          "data-test-subj": "superDatePickerShowDatesButton",
          disabled: isDisabled,
          onClick: _this.hidePrettyDuration
        }, prettyDuration(start, end, commonlyUsedRanges, dateFormat), /*#__PURE__*/React.createElement("span", {
          className: "euiSuperDatePicker__prettyFormatLink"
        }, /*#__PURE__*/React.createElement(EuiI18n, {
          token: "euiSuperDatePicker.showDatesButtonLabel",
          default: "Show dates"
        }))));
      }
      return /*#__PURE__*/React.createElement(EuiI18nConsumer, null, function (_ref4) {
        var contextLocale = _ref4.locale;
        return /*#__PURE__*/React.createElement(EuiDatePickerRange, {
          className: "euiDatePickerRange--inGroup",
          iconType: false,
          isCustom: true,
          startDateControl: /*#__PURE__*/React.createElement(EuiDatePopoverButton, {
            className: classNames('euiSuperDatePicker__startPopoverButton', {
              'euiSuperDatePicker__startPopoverButton--compressed': compressed
            }),
            position: "start",
            needsUpdating: hasChanged,
            isInvalid: isInvalid,
            isDisabled: isDisabled,
            onChange: _this.setStart,
            value: start,
            dateFormat: dateFormat,
            utcOffset: utcOffset,
            timeFormat: timeFormat,
            locale: locale || contextLocale,
            isOpen: _this.state.isStartDatePopoverOpen,
            onPopoverToggle: _this.onStartDatePopoverToggle,
            onPopoverClose: _this.onStartDatePopoverClose,
            compressed: compressed
          }),
          endDateControl: /*#__PURE__*/React.createElement(EuiDatePopoverButton, {
            position: "end",
            needsUpdating: hasChanged,
            isInvalid: isInvalid,
            isDisabled: isDisabled,
            onChange: _this.setEnd,
            value: end,
            dateFormat: dateFormat,
            utcOffset: utcOffset,
            timeFormat: timeFormat,
            locale: locale || contextLocale,
            roundUp: true,
            isOpen: _this.state.isEndDatePopoverOpen,
            onPopoverToggle: _this.onEndDatePopoverToggle,
            onPopoverClose: _this.onEndDatePopoverClose,
            compressed: compressed
          })
        });
      });
    });
    _defineProperty(_assertThisInitialized(_this), "handleClickUpdateButton", function () {
      if (!_this.state.hasChanged && _this.props.onRefresh) {
        var _this$props3 = _this.props,
          start = _this$props3.start,
          end = _this$props3.end,
          refreshInterval = _this$props3.refreshInterval;
        _this.props.onRefresh({
          start: start,
          end: end,
          refreshInterval: refreshInterval
        });
      } else {
        _this.applyTime();
      }
    });
    _defineProperty(_assertThisInitialized(_this), "renderUpdateButton", function () {
      if (!_this.props.showUpdateButton || _this.props.isAutoRefreshOnly) {
        return;
      }
      return /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiSuperUpdateButton, _extends({
        needsUpdate: _this.state.hasChanged,
        showTooltip: !_this.state.isStartDatePopoverOpen && !_this.state.isEndDatePopoverOpen,
        compressed: _this.props.compressed,
        isLoading: _this.props.isLoading,
        isDisabled: _this.props.isDisabled || _this.state.isInvalid,
        onClick: _this.handleClickUpdateButton,
        "data-test-subj": "superDatePickerApplyTimeButton"
      }, _this.props.updateButtonProps)));
    });
    return _this;
  }
  _createClass(EuiSuperDatePicker, [{
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
        commonlyUsedRanges = _this$props4.commonlyUsedRanges,
        customQuickSelectPanels = _this$props4.customQuickSelectPanels,
        dateFormat = _this$props4.dateFormat,
        end = _this$props4.end,
        isAutoRefreshOnly = _this$props4.isAutoRefreshOnly,
        isDisabled = _this$props4.isDisabled,
        isPaused = _this$props4.isPaused,
        onRefreshChange = _this$props4.onRefreshChange,
        recentlyUsedRanges = _this$props4.recentlyUsedRanges,
        refreshInterval = _this$props4.refreshInterval,
        showUpdateButton = _this$props4.showUpdateButton,
        start = _this$props4.start,
        compressed = _this$props4.compressed;
      var quickSelect = /*#__PURE__*/React.createElement(EuiQuickSelectPopover, {
        applyRefreshInterval: onRefreshChange ? this.onRefreshChange : undefined,
        applyTime: this.applyQuickTime,
        commonlyUsedRanges: commonlyUsedRanges,
        customQuickSelectPanels: customQuickSelectPanels,
        dateFormat: dateFormat,
        end: end,
        isAutoRefreshOnly: isAutoRefreshOnly,
        isDisabled: isDisabled,
        isPaused: isPaused,
        recentlyUsedRanges: recentlyUsedRanges,
        refreshInterval: refreshInterval,
        start: start
      });
      var flexWrapperClasses = classNames('euiSuperDatePicker__flexWrapper', {
        'euiSuperDatePicker__flexWrapper--noUpdateButton': !showUpdateButton,
        'euiSuperDatePicker__flexWrapper--isAutoRefreshOnly': isAutoRefreshOnly
      });
      return /*#__PURE__*/React.createElement(EuiFlexGroup, {
        gutterSize: "s",
        responsive: false,
        className: flexWrapperClasses
      }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFormControlLayout, {
        className: "euiSuperDatePicker",
        isDisabled: isDisabled,
        prepend: quickSelect,
        compressed: compressed
      }, this.renderDatePickerRange())), this.renderUpdateButton());
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (nextProps.start !== prevState.prevProps.start || nextProps.end !== prevState.prevProps.end) {
        return {
          prevProps: {
            start: nextProps.start,
            end: nextProps.end
          },
          start: nextProps.start,
          end: nextProps.end,
          isInvalid: isRangeInvalid(nextProps.start, nextProps.end),
          hasChanged: false,
          showPrettyDuration: showPrettyDuration(nextProps.start, nextProps.end, nextProps.commonlyUsedRanges)
        };
      }
      return null;
    }
  }]);
  return EuiSuperDatePicker;
}(Component);

// @internal
_defineProperty(EuiSuperDatePicker, "defaultProps", {
  commonlyUsedRanges: commonDurationRanges,
  dateFormat: 'MMM D, YYYY @ HH:mm:ss.SSS',
  end: 'now',
  isAutoRefreshOnly: false,
  isDisabled: false,
  isPaused: true,
  recentlyUsedRanges: [],
  refreshInterval: 0,
  showUpdateButton: true,
  start: 'now-15m',
  timeFormat: 'HH:mm',
  compressed: false
});
EuiSuperDatePicker.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  commonlyUsedRanges: PropTypes.arrayOf(PropTypes.shape({
    end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
    label: PropTypes.string,
    start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
  }).isRequired).isRequired,
  customQuickSelectPanels: PropTypes.arrayOf(PropTypes.shape({
    title: PropTypes.string.isRequired,
    content: PropTypes.element.isRequired
  }).isRequired),
  /**
     * Specifies the formatted used when displaying dates and/or datetimes
     */
  dateFormat: PropTypes.string.isRequired,
  end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
  /**
     * Set isAutoRefreshOnly to true to limit the component to only display auto refresh content.
     */
  isAutoRefreshOnly: PropTypes.bool.isRequired,
  isDisabled: PropTypes.bool.isRequired,
  isLoading: PropTypes.bool,
  isPaused: PropTypes.bool.isRequired,
  /**
     * Used to localize e.g. month names, passed to `moment`
     */
  locale: PropTypes.any,
  /**
     * Callback for when the refresh interval is fired.
     * EuiSuperDatePicker will only manage a refresh interval timer when onRefresh callback is supplied
     * If a promise is returned, the next refresh interval will not start until the promise has resolved.
     * If the promise rejects the refresh interval will stop and the error thrown
     */
  onRefresh: PropTypes.func,
  /**
     * Callback for when the refresh interval changes.
     * Supply onRefreshChange to show refresh interval inputs in quick select popover
     */
  onRefreshChange: PropTypes.func,
  /**
     * Callback for when the time changes.
     */
  onTimeChange: PropTypes.func.isRequired,
  recentlyUsedRanges: PropTypes.arrayOf(PropTypes.shape({
    end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
    label: PropTypes.string,
    start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
  }).isRequired).isRequired,
  /**
     * Refresh interval in milliseconds
     */
  refreshInterval: PropTypes.number.isRequired,
  /**
     * Set showUpdateButton to false to immediately invoke onTimeChange for all start and end changes.
     */
  showUpdateButton: PropTypes.bool.isRequired,
  start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
  /**
     * Specifies the formatted used when displaying times
     */
  timeFormat: PropTypes.string.isRequired,
  utcOffset: PropTypes.number,
  /**
     * Props passed to the update button
     */
  updateButtonProps: PropTypes.any,
  /**
     * when `true` creates a shorter input
     */
  compressed: PropTypes.bool
};
// @internal
export var EuiCompressedSuperDatePicker = /*#__PURE__*/function (_EuiSuperDatePicker) {
  _inherits(EuiCompressedSuperDatePicker, _EuiSuperDatePicker);
  var _super2 = _createSuper(EuiCompressedSuperDatePicker);
  function EuiCompressedSuperDatePicker() {
    _classCallCheck(this, EuiCompressedSuperDatePicker);
    return _super2.apply(this, arguments);
  }
  return EuiCompressedSuperDatePicker;
}(EuiSuperDatePicker);
_defineProperty(EuiCompressedSuperDatePicker, "defaultProps", _objectSpread(_objectSpread({}, EuiSuperDatePicker.defaultProps), {}, {
  compressed: true
}));