"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PROCESS_POSIX_WORKING_DIR = exports.PROCESS_WORKING_DIR = void 0;
const path_1 = require("./path");
/**
 * The full pathname of the working directory of the process
 * @constant
 * @type {string}
 */
exports.PROCESS_WORKING_DIR = (0, path_1.resolveToFullPathSync)(process.cwd());
/**
 * The full pathname of the working directory of the process, in POSIX format
 * @constant
 * @type {string}
 */
exports.PROCESS_POSIX_WORKING_DIR = (0, path_1.standardize)(exports.PROCESS_WORKING_DIR);
