
package Shipment::UPS::WSDL::TrackElements::TrackRequest;
$Shipment::UPS::WSDL::TrackElements::TrackRequest::VERSION = '3.02';
use strict;
use warnings;

{    # BLOCK to scope variables

    sub get_xmlns {'http://www.ups.com/XMLSchema/XOLTWS/Track/v2.0'}

    __PACKAGE__->__set_name('TrackRequest');
    __PACKAGE__->__set_nillable();
    __PACKAGE__->__set_minOccurs();
    __PACKAGE__->__set_maxOccurs();
    __PACKAGE__->__set_ref();

    use base qw(
      SOAP::WSDL::XSD::Typelib::Element
      SOAP::WSDL::XSD::Typelib::ComplexType
    );

    our $XML_ATTRIBUTE_CLASS;
    undef $XML_ATTRIBUTE_CLASS;

    sub __get_attr_class {
        return $XML_ATTRIBUTE_CLASS;
    }

    use Class::Std::Fast::Storable constructor => 'none';
    use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

    Class::Std::initialize();

    {    # BLOCK to scope variables

        my %Request_of : ATTR(:get<Request>);
        my %InquiryNumber_of : ATTR(:get<InquiryNumber>);
        my %TrackingOption_of : ATTR(:get<TrackingOption>);
        my %CandidateBookmark_of : ATTR(:get<CandidateBookmark>);
        my %ShipperAccountInfo_of : ATTR(:get<ShipperAccountInfo>);

        __PACKAGE__->_factory(
            [   qw(        Request
                  InquiryNumber
                  TrackingOption
                  CandidateBookmark
                  ShipperAccountInfo

                  )
            ],
            {   'Request'            => \%Request_of,
                'InquiryNumber'      => \%InquiryNumber_of,
                'TrackingOption'     => \%TrackingOption_of,
                'CandidateBookmark'  => \%CandidateBookmark_of,
                'ShipperAccountInfo' => \%ShipperAccountInfo_of,
            },
            {   'Request' => 'Shipment::UPS::WSDL::TrackElements::Request',

                'InquiryNumber' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
                'TrackingOption' =>
                  'SOAP::WSDL::XSD::Typelib::Builtin::string',
                'CandidateBookmark' =>
                  'SOAP::WSDL::XSD::Typelib::Builtin::string',
                'ShipperAccountInfo' =>
                  'Shipment::UPS::WSDL::TrackTypes::ShipperAccountInfoType',
            },
            {

                'Request'            => '',
                'InquiryNumber'      => 'InquiryNumber',
                'TrackingOption'     => 'TrackingOption',
                'CandidateBookmark'  => 'CandidateBookmark',
                'ShipperAccountInfo' => 'ShipperAccountInfo',
            }
        );

    }    # end BLOCK


}    # end of BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::TrackElements::TrackRequest

=head1 VERSION

version 3.02

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
TrackRequest from the namespace http://www.ups.com/XMLSchema/XOLTWS/Track/v2.0.

=head1 NAME

Shipment::UPS::WSDL::TrackElements::TrackRequest

=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Request

 $element->set_Request($data);
 $element->get_Request();

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

=item * InquiryNumber

 $element->set_InquiryNumber($data);
 $element->get_InquiryNumber();

=item * TrackingOption

 $element->set_TrackingOption($data);
 $element->get_TrackingOption();

=item * CandidateBookmark

 $element->set_CandidateBookmark($data);
 $element->get_CandidateBookmark();

=item * ShipperAccountInfo

 $element->set_ShipperAccountInfo($data);
 $element->get_ShipperAccountInfo();

=back

=head1 METHODS

=head2 new

 my $element = Shipment::UPS::WSDL::TrackElements::TrackRequest->new($data);

Constructor. The following data structure may be passed to new():

 {
   Request =>  { # Shipment::UPS::WSDL::TrackTypes::RequestType
     RequestOption =>  $some_value, # string
     TransactionReference =>  { # Shipment::UPS::WSDL::TrackTypes::TransactionReferenceType
       CustomerContext =>  $some_value, # string
       TransactionIdentifier =>  $some_value, # string
     },
   },
   InquiryNumber =>  $some_value, # string
   TrackingOption =>  $some_value, # string
   CandidateBookmark =>  $some_value, # string
   ShipperAccountInfo =>  { # Shipment::UPS::WSDL::TrackTypes::ShipperAccountInfoType
     PostalCode =>  $some_value, # string
     CountryCode =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
