use strict;
use warnings;

=pod

Test if a DBConnect.pl provides us with a working database server

=cut

use Test::More;
use Scalar::Util qw/blessed/;
use DBI;

use lib  "../lib";
our $dbh;
do  "DBConnect.pl";


is (blessed $dbh, "DBI::db", "Connect.pl to test DB works");

# --- create brand new test table
$dbh->do("DROP TABLE IF EXISTS test_table;"); 
$dbh->do("CREATE TABLE test_table (f1,f2,f3);");

# --- populate test data
my $sth = $dbh->prepare("INSERT INTO test_table VALUES (?,?,?);");

for my $i (1,4,7) {
  $sth->execute($i..$i+2);
}

# --- read test data
my $table_a = $dbh->selectall_arrayref("SELECT * FROM test_table");

is_deeply ($table_a, [[1, 2, 3], [4, 5, 6], [7, 8, 9]], "SQL works");

done_testing();

