#! /usr/bin/env perl6

use v6.d;

use Grammar::TodoTxt;
use Test;

my $input = q:to/EOF/;
(A) Call Mom +Family +PeaceLoveAndHappiness @iphone @phone
Email SoAndSo at soandso@example.com
Learn how to add 2+2
EOF

plan $input.lines.elems;

my $todo = Grammar::TodoTxt.parse($input);

subtest 'Line 1', {
	plan 2;

	subtest 'Projects', {
		plan 4;

		my @projects = $todo<records>[0]<description><projects>.sort;

		ok @projects, 'There are projects';
		is @projects.elems, 2, 'There are 2 projects';
		is @projects[0], 'Family', 'Family project is included';
		is @projects[1], 'PeaceLoveAndHappiness', 'PeaceLoveAndHappiness project is included';
	}

	subtest 'Contexts', {
		plan 4;

		my @contexts = $todo<records>[0]<description><contexts>.sort;
		ok @contexts, 'There are contexts';
		is @contexts.elems, 2, 'There are 2 contexts';
		is @contexts[0], 'iphone', 'iphone context is included';
		is @contexts[1], 'phone', 'phone context is included';
	}
}

subtest 'Line 2', {
	plan 2;

	nok $todo<records>[1]<description><projects>, 'No projects in this record';
	nok $todo<records>[1]<description><contexts>, 'No contexts in this record';
}

subtest 'Line 3', {
	plan 2;

	nok $todo<records>[2]<description><projects>, 'No projects in this record';
	nok $todo<records>[2]<description><contexts>, 'No contexts in this record';
}

# vim: ft=perl6 noet
