#!perl

use Test::More;
use Test::NoWarnings;

use autodie;
plan 'tests' => 2;

use Pg::Explain;

my $plan_source = q{
Index Only Scan using sale_product_sale_id_seller_index on sale_product  (cost=0.56..771009.70 rows=440196 width=8) (actual time=1.752..9644.097 rows=438619 loops=1)
  Index Cond: (seller = 7)
  Heap Fetches: 0
  Buffers: shared read=216858
};

my $explain = Pg::Explain->new( 'source' => $plan_source );
$explain->parse_source;
isa_ok( $explain->top_node, 'Pg::Explain::Node' );

$explain->top_node->buffers->{ 'data' }->{ 'timings' } = {};

# This will generate warning in Pg::Explain < 2.10, so Test::NoWarnings will fail
my $x = $explain->top_node->buffers->as_text;

exit;
