# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p870 -iterations=1 -instruction-tables=full < %s | FileCheck %s

vsetvli zero, zero, e8, mf8, tu, mu
vandn.vv v4, v8, v12
vandn.vx v4, v8, a0
vbrev.v v4, v8
vbrev8.v v4, v8
vrev8.v v4, v8
vclz.v v4, v8
vctz.v v4, v8
vcpop.v v4, v8
vrol.vv v4, v8, v12
vrol.vx v4, v8, a0
vror.vv v4, v8, v12
vror.vx v4, v8, a0
vror.vi v4, v8, 8

vwsll.vv v4, v8, v12
vwsll.vx v4, v8, a0
vwsll.vi v4, v8, 8

vsetvli zero, zero, e16, mf4, tu, mu
vandn.vv v4, v8, v12
vandn.vx v4, v8, a0
vbrev.v v4, v8
vbrev8.v v4, v8
vrev8.v v4, v8
vclz.v v4, v8
vctz.v v4, v8
vcpop.v v4, v8
vrol.vv v4, v8, v12
vrol.vx v4, v8, a0
vror.vv v4, v8, v12
vror.vx v4, v8, a0
vror.vi v4, v8, 8

vwsll.vv v4, v8, v12
vwsll.vx v4, v8, a0
vwsll.vi v4, v8, 8

vsetvli zero, zero, e32, mf2, tu, mu
vandn.vv v4, v8, v12
vandn.vx v4, v8, a0
vbrev.v v4, v8
vbrev8.v v4, v8
vrev8.v v4, v8
vclz.v v4, v8
vctz.v v4, v8
vcpop.v v4, v8
vrol.vv v4, v8, v12
vrol.vx v4, v8, a0
vror.vv v4, v8, v12
vror.vx v4, v8, a0
vror.vi v4, v8, 8

vwsll.vv v4, v8, v12
vwsll.vx v4, v8, a0
vwsll.vi v4, v8, 8

vsetvli zero, zero, e32, m1, tu, mu
vandn.vv v4, v8, v12
vandn.vx v4, v8, a0
vbrev.v v4, v8
vbrev8.v v4, v8
vrev8.v v4, v8
vclz.v v4, v8
vctz.v v4, v8
vcpop.v v4, v8
vrol.vv v4, v8, v12
vrol.vx v4, v8, a0
vror.vv v4, v8, v12
vror.vx v4, v8, a0
vror.vi v4, v8, 8

vwsll.vv v4, v8, v12
vwsll.vx v4, v8, a0
vwsll.vi v4, v8, 8

vsetvli zero, zero, e32, m2, tu, mu
vandn.vv v4, v8, v12
vandn.vx v4, v8, a0
vbrev.v v4, v8
vbrev8.v v4, v8
vrev8.v v4, v8
vclz.v v4, v8
vctz.v v4, v8
vcpop.v v4, v8
vrol.vv v4, v8, v12
vrol.vx v4, v8, a0
vror.vv v4, v8, v12
vror.vx v4, v8, a0
vror.vi v4, v8, 8

vwsll.vv v4, v8, v12
vwsll.vx v4, v8, a0
vwsll.vi v4, v8, 8

vsetvli zero, zero, e32, m4, tu, mu
vandn.vv v4, v8, v12
vandn.vx v4, v8, a0
vbrev.v v4, v8
vbrev8.v v4, v8
vrev8.v v4, v8
vclz.v v4, v8
vctz.v v4, v8
vcpop.v v4, v8
vrol.vv v4, v8, v12
vrol.vx v4, v8, a0
vror.vv v4, v8, v12
vror.vx v4, v8, a0
vror.vi v4, v8, 8

vwsll.vv v8, v4, v12
vwsll.vx v8, v4, a0
vwsll.vi v8, v4, 8

vsetvli zero, zero, e32, m8, tu, mu
vandn.vv v8, v16, v24
vandn.vx v8, v16, a0
vbrev.v  v8, v16
vbrev8.v v8, v16
vrev8.v  v8, v16
vclz.v   v8, v16
vctz.v   v8, v16
vcpop.v  v8, v16
vrol.vv  v8, v16, v24
vrol.vx  v8, v16, a0
vror.vv  v8, v16, v24
vror.vx  v8, v16, a0
vror.vi  v8, v16, 8

# Show SEW does not matter
vsetvli zero, zero, e16, m4, tu, mu
vandn.vv v4, v8, v12
vandn.vx v4, v8, a0
vbrev.v  v4, v8
vbrev8.v v4, v8
vrev8.v  v4, v8
vclz.v   v4, v8
vctz.v   v4, v8
vcpop.v  v4, v8
vrol.vv  v4, v8, v12
vrol.vx  v4, v8, a0
vror.vv  v4, v8, v12
vror.vx  v4, v8, a0
vror.vi  v4, v8, 8
vwsll.vv v8, v4, v12
vwsll.vx v8, v4, a0
vwsll.vi v8, v4, 8

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP800Branch:2 SiFiveP800IEXQ4, SiFiveP800IEXQ5
# CHECK-NEXT: [1]   - SiFiveP800Div:1
# CHECK-NEXT: [2]   - SiFiveP800FEXQ0:1
# CHECK-NEXT: [3]   - SiFiveP800FEXQ1:1
# CHECK-NEXT: [4]   - SiFiveP800FloatArith:2 SiFiveP800FEXQ0, SiFiveP800FEXQ1
# CHECK-NEXT: [5]   - SiFiveP800FloatDiv:1
# CHECK-NEXT: [6]   - SiFiveP800IEXQ0:1
# CHECK-NEXT: [7]   - SiFiveP800IEXQ1:1
# CHECK-NEXT: [8]   - SiFiveP800IEXQ2:1
# CHECK-NEXT: [9]   - SiFiveP800IEXQ3:1
# CHECK-NEXT: [10]  - SiFiveP800IEXQ4:1
# CHECK-NEXT: [11]  - SiFiveP800IEXQ5:1
# CHECK-NEXT: [12]  - SiFiveP800IntArith:4 SiFiveP800IEXQ0, SiFiveP800IEXQ1, SiFiveP800IEXQ2, SiFiveP800IEXQ3
# CHECK-NEXT: [13]  - SiFiveP800LD:1
# CHECK-NEXT: [14]  - SiFiveP800LDST:2
# CHECK-NEXT: [15]  - SiFiveP800Load:3 SiFiveP800LDST, SiFiveP800LDST, SiFiveP800LD
# CHECK-NEXT: [16]  - SiFiveP800Mul:2 SiFiveP800IEXQ1, SiFiveP800IEXQ3
# CHECK-NEXT: [17]  - SiFiveP800VDiv:1
# CHECK-NEXT: [18]  - SiFiveP800VEXQ0:1
# CHECK-NEXT: [19]  - SiFiveP800VEXQ1:1
# CHECK-NEXT: [20]  - SiFiveP800VFloatDiv:1
# CHECK-NEXT: [21]  - SiFiveP800VLD:1
# CHECK-NEXT: [22]  - SiFiveP800VST:1
# CHECK-NEXT: [23]  - SiFiveP800VectorArith:2 SiFiveP800VEXQ0, SiFiveP800VEXQ1

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)
# CHECK-NEXT: [7]: Bypass Latency
# CHECK-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT: [9]: LLVM Opcode Name

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VANDN_VV                   vandn.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VANDN_VX                   vandn.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VBREV_V                    vbrev.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VBREV8_V                   vbrev8.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VREV8_V                    vrev8.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VCLZ_V                     vclz.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VCTZ_V                     vctz.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VCPOP_V                    vcpop.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROL_VV                    vrol.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROL_VX                    vrol.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROR_VV                    vror.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROR_VX                    vror.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROR_VI                    vror.vi	v4, v8, 8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VWSLL_VV                   vwsll.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VWSLL_VX                   vwsll.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VWSLL_VI                   vwsll.vi	v4, v8, 8
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VANDN_VV                   vandn.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VANDN_VX                   vandn.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VBREV_V                    vbrev.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VBREV8_V                   vbrev8.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VREV8_V                    vrev8.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VCLZ_V                     vclz.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VCTZ_V                     vctz.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VCPOP_V                    vcpop.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROL_VV                    vrol.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROL_VX                    vrol.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROR_VV                    vror.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROR_VX                    vror.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROR_VI                    vror.vi	v4, v8, 8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VWSLL_VV                   vwsll.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VWSLL_VX                   vwsll.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VWSLL_VI                   vwsll.vi	v4, v8, 8
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VANDN_VV                   vandn.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VANDN_VX                   vandn.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VBREV_V                    vbrev.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VBREV8_V                   vbrev8.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VREV8_V                    vrev8.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VCLZ_V                     vclz.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VCTZ_V                     vctz.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VCPOP_V                    vcpop.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROL_VV                    vrol.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROL_VX                    vrol.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROR_VV                    vror.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROR_VX                    vror.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROR_VI                    vror.vi	v4, v8, 8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VWSLL_VV                   vwsll.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VWSLL_VX                   vwsll.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VWSLL_VI                   vwsll.vi	v4, v8, 8
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VANDN_VV                   vandn.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VANDN_VX                   vandn.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VBREV_V                    vbrev.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VBREV8_V                   vbrev8.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VREV8_V                    vrev8.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VCLZ_V                     vclz.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VCTZ_V                     vctz.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VCPOP_V                    vcpop.v	v4, v8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROL_VV                    vrol.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROL_VX                    vrol.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROR_VV                    vror.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROR_VX                    vror.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VROR_VI                    vror.vi	v4, v8, 8
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VWSLL_VV                   vwsll.vv	v4, v8, v12
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VWSLL_VX                   vwsll.vx	v4, v8, a0
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VWSLL_VI                   vwsll.vi	v4, v8, 8
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VANDN_VV                   vandn.vv	v4, v8, v12
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VANDN_VX                   vandn.vx	v4, v8, a0
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VBREV_V                    vbrev.v	v4, v8
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VBREV8_V                   vbrev8.v	v4, v8
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VREV8_V                    vrev8.v	v4, v8
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VCLZ_V                     vclz.v	v4, v8
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VCTZ_V                     vctz.v	v4, v8
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VCPOP_V                    vcpop.v	v4, v8
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VROL_VV                    vrol.vv	v4, v8, v12
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VROL_VX                    vrol.vx	v4, v8, a0
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VROR_VV                    vror.vv	v4, v8, v12
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VROR_VX                    vror.vx	v4, v8, a0
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VROR_VI                    vror.vi	v4, v8, 8
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VWSLL_VV                   vwsll.vv	v4, v8, v12
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VWSLL_VX                   vwsll.vx	v4, v8, a0
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VectorArith[2]                   VWSLL_VI                   vwsll.vi	v4, v8, 8
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VANDN_VV                   vandn.vv	v4, v8, v12
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VANDN_VX                   vandn.vx	v4, v8, a0
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VBREV_V                    vbrev.v	v4, v8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VBREV8_V                   vbrev8.v	v4, v8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VREV8_V                    vrev8.v	v4, v8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VCLZ_V                     vclz.v	v4, v8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VCTZ_V                     vctz.v	v4, v8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VCPOP_V                    vcpop.v	v4, v8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VROL_VV                    vrol.vv	v4, v8, v12
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VROL_VX                    vrol.vx	v4, v8, a0
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VROR_VV                    vror.vv	v4, v8, v12
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VROR_VX                    vror.vx	v4, v8, a0
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VROR_VI                    vror.vi	v4, v8, 8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VWSLL_VV                   vwsll.vv	v8, v4, v12
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VWSLL_VX                   vwsll.vx	v8, v4, a0
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VWSLL_VI                   vwsll.vi	v8, v4, 8
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VANDN_VV                   vandn.vv	v8, v16, v24
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VANDN_VX                   vandn.vx	v8, v16, a0
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VBREV_V                    vbrev.v	v8, v16
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VBREV8_V                   vbrev8.v	v8, v16
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VREV8_V                    vrev8.v	v8, v16
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VCLZ_V                     vclz.v	v8, v16
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VCTZ_V                     vctz.v	v8, v16
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VCPOP_V                    vcpop.v	v8, v16
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VROL_VV                    vrol.vv	v8, v16, v24
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VROL_VX                    vrol.vx	v8, v16, a0
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VROR_VV                    vror.vv	v8, v16, v24
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VROR_VX                    vror.vx	v8, v16, a0
# CHECK-NEXT:  1      2     4.00                         2     SiFiveP800VectorArith[8]                   VROR_VI                    vror.vi	v8, v16, 8
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VANDN_VV                   vandn.vv	v4, v8, v12
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VANDN_VX                   vandn.vx	v4, v8, a0
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VBREV_V                    vbrev.v	v4, v8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VBREV8_V                   vbrev8.v	v4, v8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VREV8_V                    vrev8.v	v4, v8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VCLZ_V                     vclz.v	v4, v8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VCTZ_V                     vctz.v	v4, v8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VCPOP_V                    vcpop.v	v4, v8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VROL_VV                    vrol.vv	v4, v8, v12
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VROL_VX                    vrol.vx	v4, v8, a0
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VROR_VV                    vror.vv	v4, v8, v12
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VROR_VX                    vror.vx	v4, v8, a0
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VROR_VI                    vror.vi	v4, v8, 8
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VWSLL_VV                   vwsll.vv	v8, v4, v12
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VWSLL_VX                   vwsll.vx	v8, v4, a0
# CHECK-NEXT:  1      2     2.00                         2     SiFiveP800VectorArith[4]                   VWSLL_VI                   vwsll.vi	v8, v4, 8

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP800Div
# CHECK-NEXT: [1]   - SiFiveP800FEXQ0
# CHECK-NEXT: [2]   - SiFiveP800FEXQ1
# CHECK-NEXT: [3]   - SiFiveP800FloatDiv
# CHECK-NEXT: [4]   - SiFiveP800IEXQ0
# CHECK-NEXT: [5]   - SiFiveP800IEXQ1
# CHECK-NEXT: [6]   - SiFiveP800IEXQ2
# CHECK-NEXT: [7]   - SiFiveP800IEXQ3
# CHECK-NEXT: [8]   - SiFiveP800IEXQ4
# CHECK-NEXT: [9]   - SiFiveP800IEXQ5
# CHECK-NEXT: [10]  - SiFiveP800LD
# CHECK-NEXT: [11.0] - SiFiveP800LDST
# CHECK-NEXT: [11.1] - SiFiveP800LDST
# CHECK-NEXT: [12]  - SiFiveP800VDiv
# CHECK-NEXT: [13]  - SiFiveP800VEXQ0
# CHECK-NEXT: [14]  - SiFiveP800VEXQ1
# CHECK-NEXT: [15]  - SiFiveP800VFloatDiv
# CHECK-NEXT: [16]  - SiFiveP800VLD
# CHECK-NEXT: [17]  - SiFiveP800VST

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11.0] [11.1] [12]   [13]   [14]   [15]   [16]   [17]
# CHECK-NEXT:  -      -      -      -      -     8.00    -      -      -      -      -      -      -      -     164.00 164.00  -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11.0] [11.1] [12]   [13]   [14]   [15]   [16]   [17]   Instructions:
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vandn.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vandn.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vbrev.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vbrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vclz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vctz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vcpop.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrol.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrol.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vror.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vror.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vror.vi	v4, v8, 8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vwsll.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vwsll.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vwsll.vi	v4, v8, 8
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vandn.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vandn.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vbrev.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vbrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vclz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vctz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vcpop.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrol.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrol.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vror.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vror.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vror.vi	v4, v8, 8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vwsll.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vwsll.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vwsll.vi	v4, v8, 8
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vandn.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vandn.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vbrev.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vbrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vclz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vctz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vcpop.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrol.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrol.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vror.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vror.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vror.vi	v4, v8, 8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vwsll.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vwsll.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vwsll.vi	v4, v8, 8
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vandn.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vandn.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vbrev.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vbrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vclz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vctz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vcpop.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrol.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrol.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vror.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vror.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vror.vi	v4, v8, 8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vwsll.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vwsll.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vwsll.vi	v4, v8, 8
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vandn.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vandn.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vbrev.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vbrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vclz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vctz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vcpop.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vrol.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vrol.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vror.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vror.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vror.vi	v4, v8, 8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vwsll.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vwsll.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -     vwsll.vi	v4, v8, 8
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vandn.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vandn.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vbrev.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vbrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vclz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vctz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vcpop.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vrol.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vrol.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vror.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vror.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vror.vi	v4, v8, 8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vwsll.vv	v8, v4, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vwsll.vx	v8, v4, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vwsll.vi	v8, v4, 8
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vandn.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vandn.vx	v8, v16, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vbrev.v	v8, v16
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vbrev8.v	v8, v16
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vrev8.v	v8, v16
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vclz.v	v8, v16
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vctz.v	v8, v16
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vcpop.v	v8, v16
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vrol.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vrol.vx	v8, v16, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vror.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vror.vx	v8, v16, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00   4.00    -      -      -     vror.vi	v8, v16, 8
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vandn.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vandn.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vbrev.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vbrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vrev8.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vclz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vctz.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vcpop.v	v4, v8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vrol.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vrol.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vror.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vror.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vror.vi	v4, v8, 8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vwsll.vv	v8, v4, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vwsll.vx	v8, v4, a0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -      -     vwsll.vi	v8, v4, 8
