; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes=slp-vectorizer -S < %s -mtriple=riscv32 -mattr=+v \
; RUN:     -riscv-v-slp-max-vf=0 | FileCheck %s
; RUN: opt -passes=slp-vectorizer -S < %s -mtriple=riscv64 -mattr=+v \
; RUN:     -riscv-v-slp-max-vf=0 | FileCheck %s

; These shouldn't be vectorized as the cost of materializing the constants as
; vectors should outweigh the scalar cost

define void @f(ptr %p, i1 %c) {
; CHECK-LABEL: define void @f
; CHECK-SAME: (ptr [[P:%.*]], i1 [[C:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[P_0:%.*]] = getelementptr i8, ptr [[P]]
; CHECK-NEXT:    br i1 [[C]], label [[A:%.*]], label [[B:%.*]]
; CHECK:       a:
; CHECK-NEXT:    br label [[D:%.*]]
; CHECK:       b:
; CHECK-NEXT:    br label [[D]]
; CHECK:       d:
; CHECK-NEXT:    [[TMP1:%.*]] = phi <2 x i8> [ <i8 1, i8 -1>, [[A]] ], [ <i8 -1, i8 1>, [[B]] ]
; CHECK-NEXT:    store <2 x i8> [[TMP1]], ptr [[P_0]], align 1
; CHECK-NEXT:    ret void
;
  %p.0 = getelementptr i8, ptr %p
  %p.1 = getelementptr i8, ptr %p, i32 1
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi i8 [1, %a], [-1, %b]
  %y = phi i8 [-1, %a], [1, %b]
  store i8 %x, ptr %p.0
  store i8 %y, ptr %p.1
  ret void
}

define void @g(ptr %p, i1 %c) {
; CHECK-LABEL: define void @g
; CHECK-SAME: (ptr [[P:%.*]], i1 [[C:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[P_0:%.*]] = getelementptr i8, ptr [[P]]
; CHECK-NEXT:    br i1 [[C]], label [[A:%.*]], label [[B:%.*]]
; CHECK:       a:
; CHECK-NEXT:    br label [[D:%.*]]
; CHECK:       b:
; CHECK-NEXT:    br label [[D]]
; CHECK:       d:
; CHECK-NEXT:    [[TMP1:%.*]] = phi <2 x i8> [ <i8 1, i8 -1>, [[A]] ], [ <i8 -1, i8 1>, [[B]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = add <2 x i8> [[TMP1]], splat (i8 1)
; CHECK-NEXT:    store <2 x i8> [[TMP2]], ptr [[P_0]], align 1
; CHECK-NEXT:    ret void
;
  %p.0 = getelementptr i8, ptr %p
  %p.1 = getelementptr i8, ptr %p, i32 1
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi i8 [1, %a], [-1, %b]
  %y = phi i8 [-1, %a], [1, %b]
  %x.add = add i8 %x, 1
  %y.add = add i8 %y, 1
  store i8 %x.add, ptr %p.0
  store i8 %y.add, ptr %p.1
  ret void
}
