# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=spacemit-x60 -iterations=1 -instruction-tables=full < %s | FileCheck %s

# Floating-Point Load and Store Instructions
## Half-Precision
flh ft0, 0(a0)
fsh ft0, 0(a0)

## Single-Precision
flw ft0, 0(a0)
fsw ft0, 0(a0)

## Double-Precision
fld ft0, 0(a0)
fsd ft0, 0(a0)

# Floating-Point Computational Instructions
## Half-Precision
fadd.h f26, f27, f28
fsub.h f29, f30, f31
fmul.h ft0, ft1, ft2
fdiv.h ft3, ft4, ft5
fsqrt.h ft6, ft7
fmin.h fa5, fa6, fa7
fmax.h fs2, fs3, fs4
fmadd.h f10, f11, f12, f31
fmsub.h f14, f15, f16, f17
fnmsub.h f18, f19, f20, f21
fnmadd.h f22, f23, f24, f25

## Single-Precision
fadd.s f26, f27, f28
fsub.s f29, f30, f31
fmul.s ft0, ft1, ft2
fdiv.s ft3, ft4, ft5
fsqrt.s ft6, ft7
fmin.s fa5, fa6, fa7
fmax.s fs2, fs3, fs4
fmadd.s f10, f11, f12, f31
fmsub.s f14, f15, f16, f17
fnmsub.s f18, f19, f20, f21
fnmadd.s f22, f23, f24, f25

## Double-Precision
fadd.d f26, f27, f28
fsub.d f29, f30, f31
fmul.d ft0, ft1, ft2
fdiv.d ft3, ft4, ft5
fsqrt.d ft6, ft7
fmin.d fa5, fa6, fa7
fmax.d fs2, fs3, fs4
fmadd.d f10, f11, f12, f31
fmsub.d f14, f15, f16, f17
fnmsub.d f18, f19, f20, f21
fnmadd.d f22, f23, f24, f25

# Floating-Point Conversion and Move Instructions
## Half-Precision
fmv.x.h a2, fs7
fmv.h.x ft1, a6

fcvt.s.h fa0, ft0
fcvt.s.h fa0, ft0, rup

fcvt.h.s ft2, fa2
fcvt.d.h fa0, ft0

fcvt.d.h fa0, ft0, rup
fcvt.h.d ft2, fa2

## Single-Precision
fcvt.w.s a0, fs5
fcvt.wu.s a1, fs6
fcvt.s.w ft11, a4
fcvt.s.wu ft0, a5

fcvt.l.s a0, ft0
fcvt.lu.s a1, ft1
fcvt.s.l ft2, a2
fcvt.s.lu ft3, a3

fmv.x.w a2, fs7
fmv.w.x ft1, a6

fsgnj.s fs1, fa0, fa1
fsgnjn.s fa1, fa3, fa4

## Double-Precision
fcvt.wu.d a4, ft11
fcvt.w.d a4, ft11
fcvt.d.w ft0, a5
fcvt.d.wu ft1, a6

fcvt.s.d fs5, fs6
fcvt.d.s fs7, fs8

fcvt.l.d a0, ft0
fcvt.lu.d a1, ft1
fcvt.d.l ft3, a3
fcvt.d.lu ft4, a4

fmv.x.d a2, ft2
fmv.d.x ft5, a5

fsgnj.d fs1, fa0, fa1
fsgnjn.d fa1, fa3, fa4

# Floating-Point Compare Instructions
## Half-Precision
feq.h a1, fs8, fs9
flt.h a2, fs10, fs11
fle.h a3, ft8, ft9

## Single-Precision
feq.s a1, fs8, fs9
flt.s a2, fs10, fs11
fle.s a3, ft8, ft9

## Double-Precision
feq.d a1, fs8, fs9
flt.d a2, fs10, fs11
fle.d a3, ft8, ft9

# Floating-Point Classify Instruction
## Half-Precision
fclass.s a3, ft10
## Single-Precision
fclass.s a3, ft10
## Double-Precision
fclass.d a3, ft10

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SMX60_FP:1
# CHECK-NEXT: [1]   - SMX60_IEU:2 SMX60_IEUA, SMX60_IEUB
# CHECK-NEXT: [2]   - SMX60_IEUA:1
# CHECK-NEXT: [3]   - SMX60_IEUB:1
# CHECK-NEXT: [4]   - SMX60_LS:2

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)
# CHECK-NEXT: [7]: Bypass Latency
# CHECK-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT: [9]: LLVM Opcode Name

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:  1      4     0.50    *                    4     SMX60_LS                                   FLH                        flh	ft0, 0(a0)
# CHECK-NEXT:  1      4     0.50           *             4     SMX60_LS                                   FSH                        fsh	ft0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                    4     SMX60_LS                                   FLW                        flw	ft0, 0(a0)
# CHECK-NEXT:  1      4     0.50           *             4     SMX60_LS                                   FSW                        fsw	ft0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                    4     SMX60_LS                                   FLD                        fld	ft0, 0(a0)
# CHECK-NEXT:  1      4     0.50           *             4     SMX60_LS                                   FSD                        fsd	ft0, 0(a0)
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FADD_H                     fadd.h	fs10, fs11, ft8
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FSUB_H                     fsub.h	ft9, ft10, ft11
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FMUL_H                     fmul.h	ft0, ft1, ft2
# CHECK-NEXT:  1      12    12.00                        12    SMX60_FP[12]                               FDIV_H                     fdiv.h	ft3, ft4, ft5
# CHECK-NEXT:  1      12    12.00                        12    SMX60_FP[12]                               FSQRT_H                    fsqrt.h	ft6, ft7
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FMIN_H                     fmin.h	fa5, fa6, fa7
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FMAX_H                     fmax.h	fs2, fs3, fs4
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FMADD_H                    fmadd.h	fa0, fa1, fa2, ft11
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FMSUB_H                    fmsub.h	fa4, fa5, fa6, fa7
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FNMSUB_H                   fnmsub.h	fs2, fs3, fs4, fs5
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FNMADD_H                   fnmadd.h	fs6, fs7, fs8, fs9
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FADD_S                     fadd.s	fs10, fs11, ft8
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FSUB_S                     fsub.s	ft9, ft10, ft11
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FMUL_S                     fmul.s	ft0, ft1, ft2
# CHECK-NEXT:  1      15    15.00                        15    SMX60_FP[15]                               FDIV_S                     fdiv.s	ft3, ft4, ft5
# CHECK-NEXT:  1      15    15.00                        15    SMX60_FP[15]                               FSQRT_S                    fsqrt.s	ft6, ft7
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FMIN_S                     fmin.s	fa5, fa6, fa7
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FMAX_S                     fmax.s	fs2, fs3, fs4
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FMADD_S                    fmadd.s	fa0, fa1, fa2, ft11
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FMSUB_S                    fmsub.s	fa4, fa5, fa6, fa7
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FNMSUB_S                   fnmsub.s	fs2, fs3, fs4, fs5
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FNMADD_S                   fnmadd.s	fs6, fs7, fs8, fs9
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FADD_D                     fadd.d	fs10, fs11, ft8
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FSUB_D                     fsub.d	ft9, ft10, ft11
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FMUL_D                     fmul.d	ft0, ft1, ft2
# CHECK-NEXT:  1      22    22.00                        22    SMX60_FP[22]                               FDIV_D                     fdiv.d	ft3, ft4, ft5
# CHECK-NEXT:  1      22    22.00                        22    SMX60_FP[22]                               FSQRT_D                    fsqrt.d	ft6, ft7
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FMIN_D                     fmin.d	fa5, fa6, fa7
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FMAX_D                     fmax.d	fs2, fs3, fs4
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FMADD_D                    fmadd.d	fa0, fa1, fa2, ft11
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FMSUB_D                    fmsub.d	fa4, fa5, fa6, fa7
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FNMSUB_D                   fnmsub.d	fs2, fs3, fs4, fs5
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FNMADD_D                   fnmadd.d	fs6, fs7, fs8, fs9
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  FMV_X_H                    fmv.x.h	a2, fs7
# CHECK-NEXT:  1      4     0.50                         4     SMX60_IEU                                  FMV_H_X                    fmv.h.x	ft1, a6
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FCVT_S_H                   fcvt.s.h	fa0, ft0
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FCVT_S_H                   fcvt.s.h	fa0, ft0, rup
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FCVT_H_S                   fcvt.h.s	ft2, fa2
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FCVT_D_H                   fcvt.d.h	fa0, ft0
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FCVT_D_H                   fcvt.d.h	fa0, ft0, rup
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FCVT_H_D                   fcvt.h.d	ft2, fa2
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  FCVT_W_S                   fcvt.w.s	a0, fs5
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  FCVT_WU_S                  fcvt.wu.s	a1, fs6
# CHECK-NEXT:  1      4     0.50                         4     SMX60_IEU                                  FCVT_S_W                   fcvt.s.w	ft11, a4
# CHECK-NEXT:  1      4     0.50                         4     SMX60_IEU                                  FCVT_S_WU                  fcvt.s.wu	ft0, a5
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  FCVT_L_S                   fcvt.l.s	a0, ft0
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  FCVT_LU_S                  fcvt.lu.s	a1, ft1
# CHECK-NEXT:  1      4     0.50                         4     SMX60_IEU                                  FCVT_S_L                   fcvt.s.l	ft2, a2
# CHECK-NEXT:  1      4     0.50                         4     SMX60_IEU                                  FCVT_S_LU                  fcvt.s.lu	ft3, a3
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  FMV_X_W                    fmv.x.w	a2, fs7
# CHECK-NEXT:  1      4     0.50                         4     SMX60_IEU                                  FMV_W_X                    fmv.w.x	ft1, a6
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FSGNJ_S                    fsgnj.s	fs1, fa0, fa1
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FSGNJN_S                   fsgnjn.s	fa1, fa3, fa4
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  FCVT_WU_D                  fcvt.wu.d	a4, ft11
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  FCVT_W_D                   fcvt.w.d	a4, ft11
# CHECK-NEXT:  1      4     0.50                         4     SMX60_IEU                                  FCVT_D_W                   fcvt.d.w	ft0, a5
# CHECK-NEXT:  1      4     0.50                         4     SMX60_IEU                                  FCVT_D_WU                  fcvt.d.wu	ft1, a6
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FCVT_S_D                   fcvt.s.d	fs5, fs6
# CHECK-NEXT:  1      4     1.00                         4     SMX60_FP                                   FCVT_D_S                   fcvt.d.s	fs7, fs8
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  FCVT_L_D                   fcvt.l.d	a0, ft0
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  FCVT_LU_D                  fcvt.lu.d	a1, ft1
# CHECK-NEXT:  1      4     0.50                         4     SMX60_IEU                                  FCVT_D_L                   fcvt.d.l	ft3, a3
# CHECK-NEXT:  1      4     0.50                         4     SMX60_IEU                                  FCVT_D_LU                  fcvt.d.lu	ft4, a4
# CHECK-NEXT:  1      4     0.50                         4     SMX60_IEU                                  FMV_X_D                    fmv.x.d	a2, ft2
# CHECK-NEXT:  1      4     0.50                         4     SMX60_IEU                                  FMV_D_X                    fmv.d.x	ft5, a5
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FSGNJ_D                    fsgnj.d	fs1, fa0, fa1
# CHECK-NEXT:  1      5     1.00                         5     SMX60_FP                                   FSGNJN_D                   fsgnjn.d	fa1, fa3, fa4
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FEQ_H                      feq.h	a1, fs8, fs9
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FLT_H                      flt.h	a2, fs10, fs11
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FLE_H                      fle.h	a3, ft8, ft9
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FEQ_S                      feq.s	a1, fs8, fs9
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FLT_S                      flt.s	a2, fs10, fs11
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FLE_S                      fle.s	a3, ft8, ft9
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FEQ_D                      feq.d	a1, fs8, fs9
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FLT_D                      flt.d	a2, fs10, fs11
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FLE_D                      fle.d	a3, ft8, ft9
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FCLASS_S                   fclass.s	a3, ft10
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FCLASS_S                   fclass.s	a3, ft10
# CHECK-NEXT:  1      6     1.00                         6     SMX60_FP                                   FCLASS_D                   fclass.d	a3, ft10

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SMX60_FP
# CHECK-NEXT: [1]   - SMX60_IEUA
# CHECK-NEXT: [2]   - SMX60_IEUB
# CHECK-NEXT: [3.0] - SMX60_LS
# CHECK-NEXT: [3.1] - SMX60_LS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]
# CHECK-NEXT: 149.00 11.00  11.00  3.00   3.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  Instructions:
# CHECK-NEXT:  -      -      -     0.50   0.50   flh	ft0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   fsh	ft0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   flw	ft0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   fsw	ft0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   fld	ft0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   fsd	ft0, 0(a0)
# CHECK-NEXT: 1.00    -      -      -      -     fadd.h	fs10, fs11, ft8
# CHECK-NEXT: 1.00    -      -      -      -     fsub.h	ft9, ft10, ft11
# CHECK-NEXT: 1.00    -      -      -      -     fmul.h	ft0, ft1, ft2
# CHECK-NEXT: 12.00   -      -      -      -     fdiv.h	ft3, ft4, ft5
# CHECK-NEXT: 12.00   -      -      -      -     fsqrt.h	ft6, ft7
# CHECK-NEXT: 1.00    -      -      -      -     fmin.h	fa5, fa6, fa7
# CHECK-NEXT: 1.00    -      -      -      -     fmax.h	fs2, fs3, fs4
# CHECK-NEXT: 1.00    -      -      -      -     fmadd.h	fa0, fa1, fa2, ft11
# CHECK-NEXT: 1.00    -      -      -      -     fmsub.h	fa4, fa5, fa6, fa7
# CHECK-NEXT: 1.00    -      -      -      -     fnmsub.h	fs2, fs3, fs4, fs5
# CHECK-NEXT: 1.00    -      -      -      -     fnmadd.h	fs6, fs7, fs8, fs9
# CHECK-NEXT: 1.00    -      -      -      -     fadd.s	fs10, fs11, ft8
# CHECK-NEXT: 1.00    -      -      -      -     fsub.s	ft9, ft10, ft11
# CHECK-NEXT: 1.00    -      -      -      -     fmul.s	ft0, ft1, ft2
# CHECK-NEXT: 15.00   -      -      -      -     fdiv.s	ft3, ft4, ft5
# CHECK-NEXT: 15.00   -      -      -      -     fsqrt.s	ft6, ft7
# CHECK-NEXT: 1.00    -      -      -      -     fmin.s	fa5, fa6, fa7
# CHECK-NEXT: 1.00    -      -      -      -     fmax.s	fs2, fs3, fs4
# CHECK-NEXT: 1.00    -      -      -      -     fmadd.s	fa0, fa1, fa2, ft11
# CHECK-NEXT: 1.00    -      -      -      -     fmsub.s	fa4, fa5, fa6, fa7
# CHECK-NEXT: 1.00    -      -      -      -     fnmsub.s	fs2, fs3, fs4, fs5
# CHECK-NEXT: 1.00    -      -      -      -     fnmadd.s	fs6, fs7, fs8, fs9
# CHECK-NEXT: 1.00    -      -      -      -     fadd.d	fs10, fs11, ft8
# CHECK-NEXT: 1.00    -      -      -      -     fsub.d	ft9, ft10, ft11
# CHECK-NEXT: 1.00    -      -      -      -     fmul.d	ft0, ft1, ft2
# CHECK-NEXT: 22.00   -      -      -      -     fdiv.d	ft3, ft4, ft5
# CHECK-NEXT: 22.00   -      -      -      -     fsqrt.d	ft6, ft7
# CHECK-NEXT: 1.00    -      -      -      -     fmin.d	fa5, fa6, fa7
# CHECK-NEXT: 1.00    -      -      -      -     fmax.d	fs2, fs3, fs4
# CHECK-NEXT: 1.00    -      -      -      -     fmadd.d	fa0, fa1, fa2, ft11
# CHECK-NEXT: 1.00    -      -      -      -     fmsub.d	fa4, fa5, fa6, fa7
# CHECK-NEXT: 1.00    -      -      -      -     fnmsub.d	fs2, fs3, fs4, fs5
# CHECK-NEXT: 1.00    -      -      -      -     fnmadd.d	fs6, fs7, fs8, fs9
# CHECK-NEXT:  -     0.50   0.50    -      -     fmv.x.h	a2, fs7
# CHECK-NEXT:  -     0.50   0.50    -      -     fmv.h.x	ft1, a6
# CHECK-NEXT: 1.00    -      -      -      -     fcvt.s.h	fa0, ft0
# CHECK-NEXT: 1.00    -      -      -      -     fcvt.s.h	fa0, ft0, rup
# CHECK-NEXT: 1.00    -      -      -      -     fcvt.h.s	ft2, fa2
# CHECK-NEXT: 1.00    -      -      -      -     fcvt.d.h	fa0, ft0
# CHECK-NEXT: 1.00    -      -      -      -     fcvt.d.h	fa0, ft0, rup
# CHECK-NEXT: 1.00    -      -      -      -     fcvt.h.d	ft2, fa2
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.w.s	a0, fs5
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.wu.s	a1, fs6
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.s.w	ft11, a4
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.s.wu	ft0, a5
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.l.s	a0, ft0
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.lu.s	a1, ft1
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.s.l	ft2, a2
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.s.lu	ft3, a3
# CHECK-NEXT:  -     0.50   0.50    -      -     fmv.x.w	a2, fs7
# CHECK-NEXT:  -     0.50   0.50    -      -     fmv.w.x	ft1, a6
# CHECK-NEXT: 1.00    -      -      -      -     fsgnj.s	fs1, fa0, fa1
# CHECK-NEXT: 1.00    -      -      -      -     fsgnjn.s	fa1, fa3, fa4
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.wu.d	a4, ft11
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.w.d	a4, ft11
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.d.w	ft0, a5
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.d.wu	ft1, a6
# CHECK-NEXT: 1.00    -      -      -      -     fcvt.s.d	fs5, fs6
# CHECK-NEXT: 1.00    -      -      -      -     fcvt.d.s	fs7, fs8
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.l.d	a0, ft0
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.lu.d	a1, ft1
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.d.l	ft3, a3
# CHECK-NEXT:  -     0.50   0.50    -      -     fcvt.d.lu	ft4, a4
# CHECK-NEXT:  -     0.50   0.50    -      -     fmv.x.d	a2, ft2
# CHECK-NEXT:  -     0.50   0.50    -      -     fmv.d.x	ft5, a5
# CHECK-NEXT: 1.00    -      -      -      -     fsgnj.d	fs1, fa0, fa1
# CHECK-NEXT: 1.00    -      -      -      -     fsgnjn.d	fa1, fa3, fa4
# CHECK-NEXT: 1.00    -      -      -      -     feq.h	a1, fs8, fs9
# CHECK-NEXT: 1.00    -      -      -      -     flt.h	a2, fs10, fs11
# CHECK-NEXT: 1.00    -      -      -      -     fle.h	a3, ft8, ft9
# CHECK-NEXT: 1.00    -      -      -      -     feq.s	a1, fs8, fs9
# CHECK-NEXT: 1.00    -      -      -      -     flt.s	a2, fs10, fs11
# CHECK-NEXT: 1.00    -      -      -      -     fle.s	a3, ft8, ft9
# CHECK-NEXT: 1.00    -      -      -      -     feq.d	a1, fs8, fs9
# CHECK-NEXT: 1.00    -      -      -      -     flt.d	a2, fs10, fs11
# CHECK-NEXT: 1.00    -      -      -      -     fle.d	a3, ft8, ft9
# CHECK-NEXT: 1.00    -      -      -      -     fclass.s	a3, ft10
# CHECK-NEXT: 1.00    -      -      -      -     fclass.s	a3, ft10
# CHECK-NEXT: 1.00    -      -      -      -     fclass.d	a3, ft10
