/* armeb.v4a-linux.elf-entry.h
   created from armeb.v4a-linux.elf-entry.bin, 12981 (0x32b5) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_SIZE    12981
#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_ADLER32 0xb52e5b4b
#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_CRC32   0x2a7cf819

unsigned char stub_armeb_v4a_linux_elf_entry[12981] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 40,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 11, 44,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0, 17,  0, 14,231,240,  1,240,225,160,240, 14,227, 82,  0,  0,
/* 0x0040 */  10,  0,  0,  7,225,160, 64,  0,228,209, 48,  1,226, 66, 32,  1,
/* 0x0050 */ 228,192, 48,  1, 26,  0,  0,  3,225,160,  0,  4,225,160,240, 14,
/* 0x0060 */ 227, 82,  0,  0, 10,  0,  0, 15,225,160, 48,  0,228,192, 16,  1,
/* 0x0070 */ 226, 82, 32,  1, 26,  0,  0, 12,225,160,  0,  3,225,160,240, 14,
/* 0x0080 */ 227, 82,  0,  0, 10,  0,  0, 23,228,209, 48,  1,226, 82, 32,  1,
/* 0x0090 */ 228,192, 48,  1, 26,  0,  0, 19,225,160,240, 14,225,160,192,  7,
/* 0x00a0 */ 225,160,192,  7,227,160,112,129,227,135,124,  1,239,  0,  0,  0,
/* 0x00b0 */ 225,160,112, 12,225,160,112, 12,225,160,240, 14,225,160,192,  7,
/* 0x00c0 */ 227,160,112,  6,239,  0,  0,  0,225,160,112, 12,225,160,240, 14,
/* 0x00d0 */ 225,160,192,  7,227,160,112,  1,239,  0,  0,  0,225,160,112, 12,
/* 0x00e0 */ 225,160,240, 14,225,160,192,  7,227,160,112,148,239,  0,  0,  0,
/* 0x00f0 */ 225,160,112, 12,225,160,240, 14,225,160,192,  7,227,160,112,118,
/* 0x0100 */ 239,  0,  0,  0,225,160,112, 12,225,160,240, 14,225,160,192,  7,
/* 0x0110 */ 227,160,112, 93,239,  0,  0,  0,225,160,112, 12,225,160,240, 14,
/* 0x0120 */ 225,160,192,  7,227,160,112, 20,239,  0,  0,  0,225,160,112, 12,
/* 0x0130 */ 225,160,240, 14,225,160,192,  7,227,160,112, 19,239,  0,  0,  0,
/* 0x0140 */ 225,160,112, 12,225,160,240, 14,225,160,192,  7,227,160,112, 39,
/* 0x0150 */ 239,  0,  0,  0,225,160,112, 12,225,160,240, 14,225,160,192,  7,
/* 0x0160 */ 227,160,112,  5,239,  0,  0,  0,225,160,112, 12,225,160,240, 14,
/* 0x0170 */ 225,160,192,  7,227,160,112,  3,239,  0,  0,  0,225,160,112, 12,
/* 0x0180 */ 225,160,240, 14,225,160,192,  7,227,160,112,106,239,  0,  0,  0,
/* 0x0190 */ 225,160,112, 12,225,160,240, 14,225,160,192,  7,227,160,112,122,
/* 0x01a0 */ 239,  0,  0,  0,225,160,112, 12,225,160,240, 14,225,160,192,  7,
/* 0x01b0 */ 227,160,112, 10,239,  0,  0,  0,225,160,112, 12,225,160,240, 14,
/* 0x01c0 */ 225,160,192,  7,227,160,112,  4,239,  0,  0,  0,225,160,112, 12,
/* 0x01d0 */ 225,160,240, 14,227,160,112,  0,225,160,118,  7,225,199,112,  0,
/* 0x01e0 */ 224, 64,  0,  7,224,129, 16,  7,225,160,192,  7,227,160,112,144,
/* 0x01f0 */ 239,  0,  0,  0,225,160,112, 12,225,160,240, 14,231,240,  1,240,
/* 0x0200 */ 225,160,240, 14,233, 45, 64, 48,229,157, 80, 16,229,157, 64, 12,
/* 0x0210 */ 225,160, 86, 37,227,224,192,  0,225,160,198, 12,225,192,192, 12,
/* 0x0220 */ 224, 64,  0, 12,224,129, 16, 12,225,160,192,  7,227,160,112,192,
/* 0x0230 */ 239,  0,  0,  0,225,160,112, 12,232,189,128, 48,225,160,192, 14,
/* 0x0240 */ 225,160,224, 15,225,160,240, 12,  0,  0,  0,  0,234,255,255,254,
/* 0x0250 */ 234,255,255,254,226,  0, 32, 63,226,  0, 48, 31,227, 83,  0, 26,
/* 0x0260 */ 154,  0,  0,  5,227, 16,  0, 32, 18, 66, 32, 70,  2, 66, 32, 43,
/* 0x0270 */ 226,130,  0, 64,225, 47,255, 30,225,160,192,  2,234,  0,  0, 17,
/* 0x0280 */ 229,208, 32,  0,227,130, 32, 32,229,209, 48,  0,227,131, 48, 32,
/* 0x0290 */ 224, 82, 32,  3, 26,  0,  0, 21,226,128,  0,  1,226,129, 16,  1,
/* 0x02a0 */ 226, 76,192,  1,227,124,  0,  1, 26,  0,  0,  9,227,160, 32,  0,
/* 0x02b0 */ 225,160,  0,  2,225, 47,255, 30,233, 45, 64,112,226, 77,208, 64,
/* 0x02c0 */ 225,160, 80,  0,225,160, 96,  1,225,160,  0, 13,227,160, 16,255,
/* 0x02d0 */ 227,160, 32, 64,235,255,255,254,225,160,  0,  5,225,160, 16, 13,
/* 0x02e0 */ 235,255,255,254,226, 80, 64,  0,186,  0,  0, 41,225,221, 48,184,
/* 0x02f0 */ 226,  3, 58, 15,227, 83,  9,  1,  3,160, 64,  0,234,  0,  0, 53,
/* 0x0300 */ 227,116,  0,  2, 26,  0,  0, 47,225,160,  0,  5,227,160, 29,  7,
/* 0x0310 */ 235,255,255,254,225,160, 64,  0,226, 86, 48,  0, 19,160, 48,  1,
/* 0x0320 */ 224, 19, 63,164, 17,160,  0,  5, 17,160, 16,  4, 27,255,255,254,
/* 0x0330 */ 225,160,  0,  4,226,141,208, 64,232,189,128,112,233, 45, 65,240,
/* 0x0340 */ 225,160,112,  0,225,160, 96,  1,235,  0,  0, 63, 47,100, 97,116,
/* 0x0350 */  97, 47,100, 97,116, 97, 47,  0,225,160, 16, 14,227,160, 32, 11,
/* 0x0360 */ 235,255,255,254,227,160, 64,  0,229,192, 64,  0,225,160,  0,  7,
/* 0x0370 */ 227,160, 16,  1,235,  0,  0, 23,235,  0,  0, 77, 47,112,114,111,
/* 0x0380 */  99, 47,115,101,108,102, 47, 99,109,100,108,105,110,101,  0,  0,
/* 0x0390 */ 225,160,128, 14,225,160,  0,  8,225,160, 16,  4,225,160, 32,  4,
/* 0x03a0 */ 235,255,255,254,225,160, 64,  0,225,160, 16,  6,227,160, 46,255,
/* 0x03b0 */ 226,130, 32, 15,235,255,255,254,225,160, 80,  0,225,160,  0,  4,
/* 0x03c0 */ 235,255,255,254,227, 85,  0,  0,177,160,  0,  8,187,255,255,254,
/* 0x03d0 */ 227,160, 48,  0,231,198, 48,  5,229,214, 48,  0,227, 83,  0,  0,
/* 0x03e0 */   1,160, 16,  6, 10,  0,  0,139,225,160, 16,  6,229,241, 48,  1,
/* 0x03f0 */ 227, 83,  0,  0, 26,  0,  0,100,234,  0,  0,139,229,116, 48,  1,
/* 0x0400 */ 227, 83,  0, 47, 26,  0,  0,104,224,100,128,  1,226,135,  0, 10,
/* 0x0410 */ 225,160, 16,  4,225,160, 32,  8,235,255,255,254,225,160, 80,  0,
/* 0x0420 */ 227,160, 96,  0,229,192, 96,  0,225,160,  0,  7,225,160, 16,  6,
/* 0x0430 */ 235,  0,  0, 23,227,112,  0, 13, 26,  0,  0,141,235,  0,  0,126,
/* 0x0440 */  99,111,109, 46,116,101,114,109,117,120, 47,102,105,108,101,115,
/* 0x0450 */   0,  0,  0,  0,225,160, 16, 14,226,135,  0, 11,227,160, 32, 16,
/* 0x0460 */ 235,255,255,254,225,160, 16,  4,225,160, 32,  8,235,255,255,254,
/* 0x0470 */ 225,160, 80,  0,229,192, 96,  0,225,160,  0,  7,227,160, 16,  1,
/* 0x0480 */ 235,  0,  0, 23,234,  0,  0,141,225,160, 64,  1,234,  0,  0,104,
/* 0x0490 */ 235,  0,  0,144, 47, 99, 97, 99,104,101,  0,  0,225,160, 16, 14,
/* 0x04a0 */ 225,160,  0,  5,227,160, 32,  6,235,255,255,254,225,160, 64,  0,
/* 0x04b0 */ 227,160, 96,  0,229,192, 96,  0,225,160,  0,  7,227,160, 16,  1,
/* 0x04c0 */ 235,  0,  0, 23,235,  0,  0,157, 47,117,112,120,  0,  0,  0,  0,
/* 0x04d0 */ 225,160, 16, 14,225,160,  0,  4,227,160, 32,  4,235,255,255,254,
/* 0x04e0 */ 225,160, 64,  0,235,255,255,254,225,160, 80,  0,235,255,255,254,
/* 0x04f0 */ 229,196,  0,  0,225,160,  3, 37,235,255,255,254,229,196,  0,  1,
/* 0x0500 */ 225,160,  6, 37,235,255,255,254,229,196,  0,  2,229,196, 96,  3,
/* 0x0510 */ 225,160,  0,  6,232,189,129,240,233, 45, 65,240,226, 77,218,  1,
/* 0x0520 */ 226, 77,208, 12,225,160,112,  0,225,160,128,  1,225,160, 96,  2,
/* 0x0530 */ 235,  0,  0,183,117,112,120,  0,225,160, 64, 14,225,160,  0,  4,
/* 0x0540 */ 227,160, 16, 16,235,255,255,254,225,160, 80,  0,227,112,  0, 22,
/* 0x0550 */  26,  0,  0,194,225,160,  0,  4,227,160, 16,  0,235,255,255,254,
/* 0x0560 */ 225,160, 80,  0,227, 85,  0,  0,170,  0,  0,214,235,  0,  0,200,
/* 0x0570 */  47,100,101,118, 47,115,104,109,  0,  0,  0,  0,225,160,  0, 14,
/* 0x0580 */ 227,160, 24, 65,226,129, 16,  2,227,160, 45,  7,235,255,255,254,
/* 0x0590 */ 226, 80, 80,  0,170,  0,  0,214,235,  0,  0,212,109,101,109,102,
/* 0x05a0 */ 100, 95, 99,114,101, 97,116,101,  0,  0,  0,  0,225,160,  0, 14,
/* 0x05b0 */ 235,255,255,254,226,141, 64, 12,225,160,  0,  4,235,255,255,254,
/* 0x05c0 */ 235,  0,  0,219, 97,110,100,  0,225,160,  0, 14,225,160, 16,  4,
/* 0x05d0 */ 227,160, 32,  3,235,  0,  0,  7,227, 80,  0,  0, 10,  0,  0,237,
/* 0x05e0 */ 235,  0,  0,227, 76,105,110,  0,225,160,  0, 14,225,160, 16,  4,
/* 0x05f0 */ 227,160, 32,  3,235,  0,  0,  7,227, 80,  0,  0, 26,  0,  0,237,
/* 0x0600 */ 229,212, 48,130,227, 83,  0, 52,131,160, 64,  1,138,  0,  1, 15,
/* 0x0610 */ 227, 86,  0,  0, 26,  0,  0,246,235,255,255,254,226, 80, 96,  0,
/* 0x0620 */   3,160, 49,  2,  2,141, 42,  1,  2,130, 32, 12,  7,194,105,195,
/* 0x0630 */   2,141, 96, 12,227,117,  0, 38, 26,  0,  1, 14,227, 86,  0,  0,
/* 0x0640 */  10,  0,  1, 14,229,214, 48,  0,227, 83,  0,  0, 26,  0,  1,  3,
/* 0x0650 */ 225,160,  0,  6,226,141, 27,  2,226,129, 16, 12,235,  0,  0, 56,
/* 0x0660 */ 227, 80,  0,  0,186,  0,  1, 75,225,160,  0,  6,227,160, 16,194,
/* 0x0670 */ 227,160, 45,  7,235,255,255,254,226, 80, 80,  0,177,160,  0,  5,
/* 0x0680 */ 186,  0,  1, 75,225,160,  0,  6,235,255,255,254,227,160, 64,  0,
/* 0x0690 */ 234,  0,  1, 15,227,160, 64,  0,227, 87,  0,  0, 10,  0,  1, 22,
/* 0x06a0 */ 235,255,255,254,225,224,  0,  0,224,  0,  0,  7,224, 96,112,  7,
/* 0x06b0 */ 224,136,128,  0,227, 88,  0,  0, 10,  0,  1, 49,227, 84,  0,  0,
/* 0x06c0 */  10,  0,  1, 32,225,160,  0,  5,225,160, 16,  8,235,255,255,254,
/* 0x06d0 */ 227, 80,  0,  0,170,  0,  1, 49,234,  0,  1, 75,225,160,  0,  5,
/* 0x06e0 */ 226, 72, 16,  1,227,160, 32,  0,235,255,255,254,227,224, 26,  1,
/* 0x06f0 */ 227,160, 64,  0,226,141, 58,  1,226,131, 48, 12,231,195, 64,  1,
/* 0x0700 */ 225,160,  0,  5,224,131, 16,  1,227,160, 32,  1,235,255,255,254,
/* 0x0710 */ 225,160,  0,  5,225,160, 16,  4,225,160, 32,  4,235,255,255,254,
/* 0x0720 */ 227, 87,  0,  0,  3,160,192,  1, 10,  0,  1, 61,235,255,255,254,
/* 0x0730 */ 225,160, 32,  0,225,215, 48,  0, 10,  0,  1, 73,225,160,  0,  5,
/* 0x0740 */ 225,160, 16,  7,226, 98, 32,  0,235,255,255,254,234,  0,  1, 73,
/* 0x0750 */ 229,141, 80,  0,227,160, 48,  0,229,141, 48,  4,225,160,  0,  7,
/* 0x0760 */ 225,160, 16,  8,227,160, 32,  3,225,160, 48, 12,235,255,255,254,
/* 0x0770 */ 227,112, 10,  1,146,133, 48,  1,145,128,  0,  3,234,  0,  1, 75,
/* 0x0780 */ 227,160,192, 17,234,  0,  1, 61,226,141,208, 12,226,141,218,  1,
/* 0x0790 */ 232,189,129,240,233, 45, 64,240,226, 77,208,  8,225,160,112,  0,
/* 0x07a0 */ 225,160, 96,  1,235,  0,  0,  4,117,112,120,  0,225,160, 64, 14,
/* 0x07b0 */ 225,160,  0,  4,227,160, 16, 16,235,255,255,254,225,160, 80,  0,
/* 0x07c0 */ 227,112,  0, 22, 26,  0,  0, 15,225,160,  0,  4,227,160, 16,  0,
/* 0x07d0 */ 235,255,255,254,225,160, 80,  0,227, 85,  0,  0,170,  0,  0, 29,
/* 0x07e0 */ 235,  0,  0, 21, 47,100,101,118, 47,115,104,109,  0,  0,  0,  0,
/* 0x07f0 */ 225,160,  0, 14,227,160, 24, 65,226,129, 16,  2,227,160, 45,  7,
/* 0x0800 */ 235,255,255,254,226, 80, 80,  0,177,160, 64,  5,186,  0,  0, 50,
/* 0x0810 */ 225,160,  0,  5,225,160, 16,  6,235,255,255,254,227, 80,  0,  0,
/* 0x0820 */ 177,160, 64,  0,186,  0,  0, 50,229,141, 80,  0,227,160, 48,  0,
/* 0x0830 */ 229,141, 48,  4,225,160,  0,  7,225,160, 16,  6,227,160, 32,  3,
/* 0x0840 */ 225, 87,  0,  3,  3,160, 48,  1, 19,160, 48, 17,235,255,255,254,
/* 0x0850 */ 225,160, 64,  0,235,255,255,254,225, 80,  0,  4,130,132, 48,  1,
/* 0x0860 */ 128,133, 64,  3,225,160,  0,  4,226,141,208,  8,232,189,128,240,
/* 0x0870 */   0,  0,  0,  0,233, 45, 64,  3,226, 77,208, 20,226,141,  0, 36,
/* 0x0880 */ 235,  0,  0, 88,235,  0,  0, 88,232,176,  0,  6,227, 81,  0,  6,
/* 0x0890 */  10,  0,  0, 10,227, 81,  0,  0, 26,  0,  0,  4,227,160, 42,  1,
/* 0x08a0 */ 225,224, 32,  2,226,130, 32,  1,225,160,128,  2,229, 31, 16, 72,
/* 0x08b0 */ 226, 79,  0, 76,224, 64,  0,  1,229,141,  0,  8,225,160,144,  1,
/* 0x08c0 */ 229, 31,  0, 88,229,141,  0, 28,235,  0,  0,128,226,142,160,  4,
/* 0x08d0 */ 229,154,112,  0,227,160, 12,  1,226,128,  0, 45,224,135, 96,  0,
/* 0x08e0 */ 229,141, 96, 16,225,160,176, 13,224, 77,208,  0,227,205,208,  7,
/* 0x08f0 */ 227,160,  0,  0,225,160, 16, 13,232,161,  0,  1,225, 81,  0, 11,
/* 0x0900 */  58,  0,  0, 32,225,160, 32, 13,225,160, 16,  6,227,160,  0,  0,
/* 0x0910 */ 235,255,255,254,227, 16, 11,  2, 90,  0,  0, 42,231,240,  1,240,
/* 0x0920 */ 225,160, 22, 32,225,160, 22,  1,224, 64,  0,  1,226, 64,  0,  1,
/* 0x0930 */ 224,129, 32,  7,226,130, 32, 20,227,194, 32,  7,232,189,  0,  8,
/* 0x0940 */ 232,162,  0,  8,225, 93,  0, 11, 58,  0,  0, 49,229,141, 16, 12,
/* 0x0950 */ 225,160,176,  0,226,135, 64, 20,227,196, 64,  7,229,157, 48, 28,
/* 0x0960 */ 225,160, 32,  8,232,129,  0, 28,233, 45,  0,128,225,160, 48, 13,
/* 0x0970 */ 226,129, 32, 12,229,218,  0,  8,233, 45,  0,  1,229,154, 16,  4,
/* 0x0980 */ 226,138,  0, 12,235,  0,  0, 92,226,141,208,  8,227,160, 80,  0,
/* 0x0990 */ 225,160, 64, 11,227,160, 48, 18,227,160, 32,  5,229,157, 16, 16,
/* 0x09a0 */ 229,157,  0, 12,227,160,112,192,239,  0,  0,  0,225,160,  0, 11,
/* 0x09b0 */ 227,160,112,  6,239,  0,  0,  0,229,157,  0,  8,229, 26, 16,  4,
/* 0x09c0 */ 224,128, 64,  1,227,193, 16,  2,224, 73, 80,  1,232,141,  0, 48,
/* 0x09d0 */ 229,157,192, 12,226,140,240, 12,228,144, 16,  4,227, 81,  0,  0,
/* 0x09e0 */  26,  0,  0, 88,225,160,240, 14,224,129, 16,  0,233, 45, 64, 62,
/* 0x09f0 */ 227,224, 80,  0,227,160, 65,  2,234,  0,  0,117,232,189,  0, 26,
/* 0x0a00 */ 224, 64,  0,  1,224, 66, 32,  3,229,132, 32,  0,232,189,128, 48,
/* 0x0a10 */ 224,148, 64,  4, 17,160,240, 14,228,208, 64,  1,224,164, 64,  4,
/* 0x0a20 */ 225,176, 76,  4,225,160,240, 14,227,160, 16,  1,225,160,192, 14,
/* 0x0a30 */ 235,  0,  0,102,224,177, 16,  1,235,  0,  0,102, 58,  0,  0,110,
/* 0x0a40 */ 225,160,240, 12,228,208, 48,  1,228,194, 48,  1,235,  0,  0,102,
/* 0x0a50 */  42,  0,  0,115,235,  0,  0,108,226, 81, 48,  3,227,160, 16,  0,
/* 0x0a60 */  58,  0,  0,127,228,208, 80,  1,225,133, 84,  3,225,240, 80,  5,
/* 0x0a70 */  10,  0,  0, 97,235,  0,  0,102,224,177, 16,  1,235,  0,  0,102,
/* 0x0a80 */ 224,177, 16,  1, 26,  0,  0,134,235,  0,  0,108,226,129, 16,  2,
/* 0x0a90 */ 227,117, 12, 13, 50,129, 16,  1,231,210, 48,  5,226, 81, 16,  1,
/* 0x0aa0 */ 228,194, 48,  1, 42,  0,  0,136,234,  0,  0,117,227,224,  0,  0,
/* 0x0ab0 */ 225,160,  6,  0,225,160,240, 14,  0, 46,115,121,109,116, 97, 98,
/* 0x0ac0 */   0, 46,115,116,114,116, 97, 98,  0, 46,115,104,115,116,114,116,
/* 0x0ad0 */  97, 98,  0, 69, 76, 70, 77, 65, 73, 78, 89,  0, 46,114,101,108,
/* 0x0ae0 */  69, 76, 70, 77, 65, 73, 78, 90,  0, 46,114,101,108, 72, 85, 77,
/* 0x0af0 */  70, 95, 65,  0, 46,114,101,108, 72, 85, 77, 70, 95, 76,  0, 46,
/* 0x0b00 */ 114,101,108, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,  0, 46,
/* 0x0b10 */ 114,101,108, 85, 77, 70, 95, 76, 73, 78, 85, 88,  0, 46,114,101,
/* 0x0b20 */ 108, 69, 76, 70, 77, 65, 73, 78, 88,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b50 */   0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  1,  0,  0,  0,  6,
/* 0x0b60 */   0,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b70 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 40,
/* 0x0b80 */   0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0, 52,
/* 0x0b90 */   0,  0,  2, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
/* 0x0ba0 */   0,  0,  0,  0,  0,  0,  0, 36,  0,  0,  0,  9,  0,  0,  0,  0,
/* 0x0bb0 */   0,  0,  0,  0,  0,  0, 17,128,  0,  0,  0, 56,  0,  0,  0, 15,
/* 0x0bc0 */   0,  0,  0,  2,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 53,
/* 0x0bd0 */   0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  2, 76,
/* 0x0be0 */   0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
/* 0x0bf0 */   0,  0,  0,  0,  0,  0,  0, 49,  0,  0,  0,  9,  0,  0,  0,  0,
/* 0x0c00 */   0,  0,  0,  0,  0,  0, 17,184,  0,  0,  0,  8,  0,  0,  0, 15,
/* 0x0c10 */   0,  0,  0,  4,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 64,
/* 0x0c20 */   0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  2, 80,
/* 0x0c30 */   0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
/* 0x0c40 */   0,  0,  0,  0,  0,  0,  0, 60,  0,  0,  0,  9,  0,  0,  0,  0,
/* 0x0c50 */   0,  0,  0,  0,  0,  0, 17,192,  0,  0,  0,  8,  0,  0,  0, 15,
/* 0x0c60 */   0,  0,  0,  6,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 75,
/* 0x0c70 */   0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  2, 84,
/* 0x0c80 */   0,  0,  5, 64,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,
/* 0x0c90 */   0,  0,  0,  0,  0,  0,  0, 71,  0,  0,  0,  9,  0,  0,  0,  0,
/* 0x0ca0 */   0,  0,  0,  0,  0,  0, 17,200,  0,  0,  2,192,  0,  0,  0, 15,
/* 0x0cb0 */   0,  0,  0,  8,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 91,
/* 0x0cc0 */   0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  7,148,
/* 0x0cd0 */   0,  0,  0,220,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,
/* 0x0ce0 */   0,  0,  0,  0,  0,  0,  0, 87,  0,  0,  0,  9,  0,  0,  0,  0,
/* 0x0cf0 */   0,  0,  0,  0,  0,  0, 20,136,  0,  0,  0, 96,  0,  0,  0, 15,
/* 0x0d00 */   0,  0,  0, 10,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,105,
/* 0x0d10 */   0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  8,112,
/* 0x0d20 */   0,  0,  2, 72,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,
/* 0x0d30 */   0,  0,  0,  0,  0,  0,  0,101,  0,  0,  0,  9,  0,  0,  0,  0,
/* 0x0d40 */   0,  0,  0,  0,  0,  0, 20,232,  0,  0,  0,216,  0,  0,  0, 15,
/* 0x0d50 */   0,  0,  0, 12,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 17,
/* 0x0d60 */   0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 10,184,
/* 0x0d70 */   0,  0,  0,114,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
/* 0x0d80 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,  0,
/* 0x0d90 */   0,  0,  0,  0,  0,  0, 13,212,  0,  0,  2,128,  0,  0,  0, 16,
/* 0x0da0 */   0,  0,  0,  8,  0,  0,  0,  4,  0,  0,  0, 16,  0,  0,  0,  9,
/* 0x0db0 */   0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16, 84,
/* 0x0dc0 */   0,  0,  1, 43,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
/* 0x0dd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0de0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0df0 */   3,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e00 */   3,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e10 */   3,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e20 */   3,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e30 */   3,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e40 */   3,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e50 */   3,  0,  0,  6,  0,  0,  0,  1,  0,  0,  2, 60,  0,  0,  0,  0,
/* 0x0e60 */  16,  0,  0, 12,  0,  0,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e70 */  16,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,236,  0,  0,  0,  0,
/* 0x0e80 */  16,  0,  0,  2,  0,  0,  0, 27,  0,  0,  2, 72,  0,  0,  0,  0,
/* 0x0e90 */  16,  0,  0, 12,  0,  0,  0, 43,  0,  0,  0,  8,  0,  0,  0,  0,
/* 0x0ea0 */  16,  0,  0,  2,  0,  0,  0, 50,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0eb0 */  16,  0,  0,  0,  0,  0,  0, 58,  0,  0,  1,160,  0,  0,  0,  0,
/* 0x0ec0 */  16,  0,  0,  2,  0,  0,  0, 64,  0,  0,  0, 76,  0,  0,  0,  0,
/* 0x0ed0 */  16,  0,  0,  2,  0,  0,  0, 72,  0,  0,  0,216,  0,  0,  0,  0,
/* 0x0ee0 */  16,  0,  0,  2,  0,  0,  0, 82,  0,  0,  1,  0,  0,  0,  0,  0,
/* 0x0ef0 */  16,  0,  0,  2,  0,  0,  0, 88,  0,  0,  2,196,  0,  0,  2,124,
/* 0x0f00 */  18,  0,  0,  8,  0,  0,  0,112,  0,  0,  1,208,  0,  0,  0,  0,
/* 0x0f10 */  16,  0,  0,  2,  0,  0,  0,117,  0,  0,  0,  0,  0,  0,  0,220,
/* 0x0f20 */  18,  0,  0, 10,  0,  0,  0,139,  0,  0,  1,100,  0,  0,  0,  0,
/* 0x0f30 */  16,  0,  0,  2,  0,  0,  0,145,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f40 */  16,  0,  0,  1,  0,  0,  0,160,  0,  0,  1,140,  0,  0,  0,  0,
/* 0x0f50 */  16,  0,  0,  2,  0,  0,  0,166,  0,  0,  0,176,  0,  0,  0,  0,
/* 0x0f60 */  16,  0,  0,  2,  0,  0,  0,176,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f70 */  16,  0,  0,  2,  0,  0,  0,191,  0,  0,  0,104,  0,  0,  0,  0,
/* 0x0f80 */  16,  0,  0,  2,  0,  0,  0,204,  0,  0,  0,  4,  0,  0,  0,  0,
/* 0x0f90 */  16,  0,  0, 12,  0,  0,  0,211,  0,  0,  1, 60,  0,  0,  0,  0,
/* 0x0fa0 */  16,  0,  0,  2,  0,  0,  0,216,  0,  0,  1,120,  0,  0,  0,  0,
/* 0x0fb0 */  16,  0,  0,  2,  0,  0,  0,223,  0,  0,  0, 44,  0,  0,  0,  0,
/* 0x0fc0 */  16,  0,  0,  2,  0,  0,  0,230,  0,  0,  1,120,  0,  0,  0,196,
/* 0x0fd0 */  18,  0,  0, 12,  0,  0,  0,253,  0,  0,  1,200,  0,  0,  0,  0,
/* 0x0fe0 */  16,  0,  0,  2,  0,  0,  1,  5,  0,  0,  0,196,  0,  0,  0,  0,
/* 0x0ff0 */  16,  0,  0,  2,  0,  0,  1, 11,  0,  0,  1, 80,  0,  0,  0,  0,
/* 0x1000 */  16,  0,  0,  2,  0,  0,  1, 16,  0,  0,  2, 24,  0,  0,  0,  0,
/* 0x1010 */  16,  0,  0,  2,  0,  0,  1, 21,  0,  0,  0,156,  0,  0,  0,  0,
/* 0x1020 */  16,  0,  0,  2,  0,  0,  1, 26,  0,  0,  1, 40,  0,  0,  0,  0,
/* 0x1030 */  16,  0,  0,  2,  0,  0,  1, 31,  0,  0,  1, 20,  0,  0,  0,  0,
/* 0x1040 */  16,  0,  0,  2,  0,  0,  1, 37,  0,  0,  0,136,  0,  0,  0,  0,
/* 0x1050 */  16,  0,  0,  2,  0,103,101,116, 95,112, 97,103,101, 95,109, 97,
/* 0x1060 */ 115,107,  0, 77, 70, 76, 71,  0,103,101,116,112,105,100,  0,117,
/* 0x1070 */ 112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,  0,109,
/* 0x1080 */ 101,109, 99,112,121,  0, 79, 95, 66, 73, 78, 70, 79,  0, 80,115,
/* 0x1090 */ 121,110, 99,  0,109,101,109,112, 99,112,121,  0,102,116,114,117,
/* 0x10a0 */ 110, 99, 97,116,101,  0,108,115,101,101,107,  0,117,112,120, 95,
/* 0x10b0 */ 109,109, 97,112, 95, 97,110,100, 95,102,100, 95, 97,110,100,114,
/* 0x10c0 */ 111,105,100,  0,109,109, 97,112,  0,117,112,120, 95,109,109, 97,
/* 0x10d0 */ 112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120,  0,117,
/* 0x10e0 */ 110, 97,109,101,  0,101,110,100, 95,100,101, 99,111,109,112,114,
/* 0x10f0 */ 101,115,115,  0,119,114,105,116,101,  0,102,100, 97,116, 97,115,
/* 0x1100 */ 121,110, 99,  0,103,101,116, 95,117,112,120,102,110, 95,112, 97,
/* 0x1110 */ 116,104,  0,109,101,109,102,100, 95, 99,114,101, 97,116,101,  0,
/* 0x1120 */  95,115,116, 97,114,116,  0,114,101, 97,100,  0,117,110,108,105,
/* 0x1130 */ 110,107,  0,109,101,109,115,101,116,  0,117, 99,108, 95,110,114,
/* 0x1140 */ 118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,
/* 0x1150 */   0,109,121, 95, 98,107,112,116,  0,102,115,121,110, 99,  0,115,
/* 0x1160 */ 116, 97,116,  0, 99,112,114, 48,  0,101,120,105,116,  0,111,112,
/* 0x1170 */ 101,110,  0,109,107,100,105,114,  0, 99,108,111,115,101,  0,  0,
/* 0x1180 */   0,  0,  0, 12,  0,  0,  1,  1,  0,  0,  0, 32,  0,  0,  1,  1,
/* 0x1190 */   0,  0,  0, 48,  0,  0,  1,  1,  0,  0,  0, 64,  0,  0,  1,  1,
/* 0x11a0 */   0,  0,  0, 80,  0,  0,  1,  1,  0,  0,  0, 96,  0,  0,  1,  1,
/* 0x11b0 */   0,  0,  2, 20,  0,  0, 13,  2,  0,  0,  0,  0,  0,  0, 18,  1,
/* 0x11c0 */   0,  0,  0,  0,  0,  0, 20,  1,  0,  0,  0, 12,  0,  0,  2,  1,
/* 0x11d0 */   0,  0,  0, 40,  0,  0,  2,  1,  0,  0,  0, 64,  0,  0,  2,  1,
/* 0x11e0 */   0,  0,  0, 84,  0,  0,  2,  1,  0,  0,  0,128,  0,  0, 30,  1,
/* 0x11f0 */   0,  0,  0,140,  0,  0, 34,  1,  0,  0,  0,148,  0,  0,  2,  1,
/* 0x1200 */   0,  0,  0,168,  0,  0,  2,  1,  0,  0,  0,176,  0,  0,  2,  1,
/* 0x1210 */   0,  0,  0,188,  0,  0, 38,  1,  0,  0,  0,216,  0,  0, 32,  1,
/* 0x1220 */   0,  0,  0,244,  0,  0,  2,  1,  0,  0,  1, 12,  0,  0, 15,  1,
/* 0x1230 */   0,  0,  1, 32,  0,  0,  2,  1,  0,  0,  1, 36,  0,  0,  2,  1,
/* 0x1240 */   0,  0,  1, 76,  0,  0, 37,  1,  0,  0,  1, 96,  0,  0, 28,  1,
/* 0x1250 */   0,  0,  1,108,  0,  0, 39,  1,  0,  0,  1,120,  0,  0, 32,  1,
/* 0x1260 */   0,  0,  1,144,  0,  0,  2,  1,  0,  0,  1,160,  0,  0,  2,  1,
/* 0x1270 */   0,  0,  1,164,  0,  0,  2,  1,  0,  0,  1,176,  0,  0,  2,  1,
/* 0x1280 */   0,  0,  1,196,  0,  0, 15,  1,  0,  0,  1,220,  0,  0,  2,  1,
/* 0x1290 */   0,  0,  1,228,  0,  0,  2,  1,  0,  0,  1,232,  0,  0,  2,  1,
/* 0x12a0 */   0,  0,  2, 12,  0,  0, 15,  1,  0,  0,  2, 24,  0,  0, 15,  1,
/* 0x12b0 */   0,  0,  2, 44,  0,  0,  2,  1,  0,  0,  2, 48,  0,  0,  2,  1,
/* 0x12c0 */   0,  0,  2, 56,  0,  0,  2,  1,  0,  0,  2, 60,  0,  0,  2,  1,
/* 0x12d0 */   0,  0,  2, 84,  0,  0, 15,  1,  0,  0,  2,108,  0,  0,  2,  1,
/* 0x12e0 */   0,  0,  2,112,  0,  0,  2,  1,  0,  0,  2,136,  0,  0, 15,  1,
/* 0x12f0 */   0,  0,  2,144,  0,  0, 10,  1,  0,  0,  2,152,  0,  0,  2,  1,
/* 0x1300 */   0,  0,  2,164,  0,  0,  2,  1,  0,  0,  2,176,  0,  0,  2,  1,
/* 0x1310 */   0,  0,  2,220,  0,  0,  2,  1,  0,  0,  2,240,  0,  0, 26,  1,
/* 0x1320 */   0,  0,  2,252,  0,  0,  2,  1,  0,  0,  3,  8,  0,  0, 26,  1,
/* 0x1330 */   0,  0,  3, 20,  0,  0,  2,  1,  0,  0,  3, 24,  0,  0,  2,  1,
/* 0x1340 */   0,  0,  3, 56,  0,  0, 37,  1,  0,  0,  3, 64,  0,  0,  2,  1,
/* 0x1350 */   0,  0,  3, 68,  0,  0,  2,  1,  0,  0,  3, 92,  0,  0, 32,  1,
/* 0x1360 */   0,  0,  3,104,  0,  0, 21,  1,  0,  0,  3,108,  0,  0,  2,  1,
/* 0x1370 */   0,  0,  3,128,  0,  0,  2,  1,  0,  0,  3,136,  0,  0,  2,  1,
/* 0x1380 */   0,  0,  3,140,  0,  0,  2,  1,  0,  0,  3,160,  0,  0,  2,  1,
/* 0x1390 */   0,  0,  3,168,  0,  0,  2,  1,  0,  0,  3,184,  0,  0,  2,  1,
/* 0x13a0 */   0,  0,  3,192,  0,  0,  2,  1,  0,  0,  3,196,  0,  0, 25,  1,
/* 0x13b0 */   0,  0,  3,228,  0,  0,  2,  1,  0,  0,  3,236,  0,  0,  2,  1,
/* 0x13c0 */   0,  0,  3,248,  0,  0,  2,  1,  0,  0,  4,  8,  0,  0,  2,  1,
/* 0x13d0 */   0,  0,  4, 16,  0,  0,  2,  1,  0,  0,  4, 32,  0,  0, 37,  1,
/* 0x13e0 */   0,  0,  4, 44,  0,  0,  2,  1,  0,  0,  4, 52,  0,  0, 29,  1,
/* 0x13f0 */   0,  0,  4, 60,  0,  0,  2,  1,  0,  0,  4, 72,  0,  0,  2,  1,
/* 0x1400 */   0,  0,  4, 76,  0,  0,  8,  1,  0,  0,  4,100,  0,  0,  2,  1,
/* 0x1410 */   0,  0,  4,108,  0,  0,  2,  1,  0,  0,  4,120,  0,  0, 16,  1,
/* 0x1420 */   0,  0,  4,128,  0,  0,  2,  1,  0,  0,  4,132,  0,  0,  2,  1,
/* 0x1430 */   0,  0,  4,148,  0,  0, 17,  1,  0,  0,  4,184,  0,  0, 23,  1,
/* 0x1440 */   0,  0,  4,200,  0,  0, 17,  1,  0,  0,  4,212,  0,  0,  2,  1,
/* 0x1450 */   0,  0,  4,216,  0,  0,  8,  1,  0,  0,  4,228,  0,  0,  2,  1,
/* 0x1460 */   0,  0,  4,244,  0,  0, 23,  1,  0,  0,  4,248,  0,  0,  2,  1,
/* 0x1470 */   0,  0,  5, 24,  0,  0, 19,  1,  0,  0,  5, 40,  0,  0,  2,  1,
/* 0x1480 */   0,  0,  5, 48,  0,  0,  2,  1,  0,  0,  0, 16,  0,  0,  3,  1,
/* 0x1490 */   0,  0,  0, 36,  0,  0, 26,  1,  0,  0,  0, 48,  0,  0,  3,  1,
/* 0x14a0 */   0,  0,  0, 60,  0,  0, 26,  1,  0,  0,  0, 72,  0,  0,  3,  1,
/* 0x14b0 */   0,  0,  0, 76,  0,  0,  3,  1,  0,  0,  0,108,  0,  0, 37,  1,
/* 0x14c0 */   0,  0,  0,120,  0,  0,  3,  1,  0,  0,  0,132,  0,  0, 16,  1,
/* 0x14d0 */   0,  0,  0,144,  0,  0,  3,  1,  0,  0,  0,184,  0,  0, 19,  1,
/* 0x14e0 */   0,  0,  0,192,  0,  0,  8,  1,  0,  0,  0,  0,  0,  0,  9,  2,
/* 0x14f0 */   0,  0,  0, 16,  0,  0,  4,  1,  0,  0,  0, 20,  0,  0,  4,  1,
/* 0x1500 */   0,  0,  0, 32,  0,  0,  4,  1,  0,  0,  0, 40,  0,  0,  4,  1,
/* 0x1510 */   0,  0,  0, 88,  0,  0,  1,  1,  0,  0,  0,144,  0,  0,  4,  1,
/* 0x1520 */   0,  0,  0,160,  0,  0, 11,  1,  0,  0,  0,168,  0,  0,  4,  1,
/* 0x1530 */   0,  0,  0,216,  0,  0,  4,  1,  0,  0,  1, 20,  0,  0,  4,  1,
/* 0x1540 */   0,  0,  1,112,  0,  0,  4,  1,  0,  0,  1,136,  0,  0,  4,  1,
/* 0x1550 */   0,  0,  1,192,  0,  0,  4,  1,  0,  0,  1,200,  0,  0,  4,  1,
/* 0x1560 */   0,  0,  1,204,  0,  0,  4,  1,  0,  0,  1,220,  0,  0,  4,  1,
/* 0x1570 */   0,  0,  1,224,  0,  0,  4,  1,  0,  0,  1,228,  0,  0,  4,  1,
/* 0x1580 */   0,  0,  1,240,  0,  0,  4,  1,  0,  0,  2,  0,  0,  0,  4,  1,
/* 0x1590 */   0,  0,  2,  4,  0,  0,  4,  1,  0,  0,  2, 12,  0,  0,  4,  1,
/* 0x15a0 */   0,  0,  2, 20,  0,  0,  4,  1,  0,  0,  2, 24,  0,  0,  4,  1,
/* 0x15b0 */   0,  0,  2, 52,  0,  0,  4,  1,  0,  0,  2, 56,  0,  0,  4,  1,
/* 0x15c0 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 51,
/* 0x15d0 */  50, 45, 98,105,103, 97,114,109, 10, 10, 83,101, 99,116,105,111,
/* 0x15e0 */ 110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32,
/* 0x15f0 */  32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32,
/* 0x1600 */  86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32,
/* 0x1610 */  32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,
/* 0x1620 */ 103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 69, 76,
/* 0x1630 */  70, 77, 65, 73, 78, 89, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48,
/* 0x1640 */  32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1650 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 69, 76, 70,
/* 0x1660 */  77, 65, 73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 50, 49, 56, 32,
/* 0x1670 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48,
/* 0x1680 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 72,
/* 0x1690 */  85, 77, 70, 95, 65, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52, 32,
/* 0x16a0 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 52, 99, 32, 32, 50, 42, 42,
/* 0x16b0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32,
/* 0x16c0 */  72, 85, 77, 70, 95, 76, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52,
/* 0x16d0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 53, 48, 32, 32, 50, 42,
/* 0x16e0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52,
/* 0x16f0 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 32, 32, 32, 48,
/* 0x1700 */  53, 52, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 53, 52, 32,
/* 0x1710 */  32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1720 */  32, 32, 53, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 32, 32,
/* 0x1730 */  32, 32, 48,100, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 57,
/* 0x1740 */  52, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1750 */  83, 10, 32, 32, 54, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32,
/* 0x1760 */  32, 32, 32, 32, 48, 50, 52, 56, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1770 */  48, 56, 55, 48, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84,
/* 0x1780 */  69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76,
/* 0x1790 */  69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x17a0 */  32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 69,
/* 0x17b0 */  76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x17c0 */  32,108, 32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x17d0 */  82, 79, 73, 68, 32, 48, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x17e0 */  73, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x17f0 */  32,100, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48, 32,
/* 0x1800 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48,
/* 0x1810 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65,
/* 0x1820 */  73, 78, 88, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48,
/* 0x1830 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1840 */  69, 76, 70, 77, 65, 73, 78, 89, 32, 48, 32, 69, 76, 70, 77, 65,
/* 0x1850 */  73, 78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1860 */  32, 32,100, 32, 32, 72, 85, 77, 70, 95, 65, 32, 48, 32, 72, 85,
/* 0x1870 */  77, 70, 95, 65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1880 */  32, 32, 32,100, 32, 32, 72, 85, 77, 70, 95, 76, 32, 48, 32, 72,
/* 0x1890 */  85, 77, 70, 95, 76, 10, 48, 48, 48, 48, 48, 50, 51, 99, 32,103,
/* 0x18a0 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32,
/* 0x18b0 */  48, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10,
/* 0x18c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x18d0 */  32, 42, 85, 78, 68, 42, 32, 48, 32, 77, 70, 76, 71, 10, 48, 48,
/* 0x18e0 */  48, 48, 48, 48,101, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x18f0 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32,103,101,116,112,105,100,
/* 0x1900 */  10, 48, 48, 48, 48, 48, 50, 52, 56, 32,103, 32, 32, 32, 32, 32,
/* 0x1910 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32,117,112,120,
/* 0x1920 */  95,109,109, 97,112, 95, 97,110,100, 95,102,100, 10, 48, 48, 48,
/* 0x1930 */  48, 48, 48, 48, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1940 */  70, 77, 65, 73, 78, 90, 32, 48, 32,109,101,109, 99,112,121, 10,
/* 0x1950 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1960 */  32, 42, 85, 78, 68, 42, 32, 48, 32, 79, 95, 66, 73, 78, 70, 79,
/* 0x1970 */  10, 48, 48, 48, 48, 48, 49, 97, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x1980 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 80,115,121,
/* 0x1990 */ 110, 99, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32,103, 32, 32, 32,
/* 0x19a0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,
/* 0x19b0 */ 101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 48,100, 56, 32,
/* 0x19c0 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x19d0 */  32, 48, 32,102,116,114,117,110, 99, 97,116,101, 10, 48, 48, 48,
/* 0x19e0 */  48, 48, 49, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x19f0 */  70, 77, 65, 73, 78, 90, 32, 48, 32,108,115,101,101,107, 10, 48,
/* 0x1a00 */  48, 48, 48, 48, 50, 99, 52, 32,103, 32, 32, 32, 32, 32, 70, 32,
/* 0x1a10 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 32, 48, 50, 55, 99,
/* 0x1a20 */  32,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,
/* 0x1a30 */  95, 97,110,100,114,111,105,100, 10, 48, 48, 48, 48, 48, 49,100,
/* 0x1a40 */  48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1a50 */  78, 90, 32, 48, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48,
/* 0x1a60 */  48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 85, 77, 70, 95, 76,
/* 0x1a70 */  73, 78, 85, 88, 32, 48,100, 99, 32,117,112,120, 95,109,109, 97,
/* 0x1a80 */ 112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120, 10, 48,
/* 0x1a90 */  48, 48, 48, 48, 49, 54, 52, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1aa0 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,117,110, 97,109,101,
/* 0x1ab0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x1ac0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 48, 32,101,110,100,
/* 0x1ad0 */  95,100,101, 99,111,109,112,114,101,115,115, 10, 48, 48, 48, 48,
/* 0x1ae0 */  48, 49, 56, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x1af0 */  77, 65, 73, 78, 90, 32, 48, 32,119,114,105,116,101, 10, 48, 48,
/* 0x1b00 */  48, 48, 48, 48, 98, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x1b10 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32,102,100, 97,116, 97,115,
/* 0x1b20 */ 121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32,
/* 0x1b30 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,
/* 0x1b40 */ 103,101,116, 95,117,112,120,102,110, 95,112, 97,116,104, 10, 48,
/* 0x1b50 */  48, 48, 48, 48, 48, 54, 56, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b60 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,101,109,102,100,
/* 0x1b70 */  95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x1b80 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1b90 */  88, 32, 48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48,
/* 0x1ba0 */  49, 51, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x1bb0 */  65, 73, 78, 90, 32, 48, 32,114,101, 97,100, 10, 48, 48, 48, 48,
/* 0x1bc0 */  48, 49, 55, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x1bd0 */  77, 65, 73, 78, 90, 32, 48, 32,117,110,108,105,110,107, 10, 48,
/* 0x1be0 */  48, 48, 48, 48, 48, 50, 99, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1bf0 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,101,109,115,101,
/* 0x1c00 */ 116, 10, 48, 48, 48, 48, 48, 49, 55, 56, 32,103, 32, 32, 32, 32,
/* 0x1c10 */  32, 70, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 99, 52, 32,
/* 0x1c20 */ 117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,
/* 0x1c30 */ 114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 49, 99, 56, 32,
/* 0x1c40 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1c50 */  32, 48, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48,
/* 0x1c60 */  48, 99, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x1c70 */  65, 73, 78, 90, 32, 48, 32,102,115,121,110, 99, 10, 48, 48, 48,
/* 0x1c80 */  48, 48, 49, 53, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1c90 */  70, 77, 65, 73, 78, 90, 32, 48, 32,115,116, 97,116, 10, 48, 48,
/* 0x1ca0 */  48, 48, 48, 50, 49, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x1cb0 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 99,112,114, 48, 10, 48,
/* 0x1cc0 */  48, 48, 48, 48, 48, 57, 99, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1cd0 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,101,120,105,116, 10,
/* 0x1ce0 */  48, 48, 48, 48, 48, 49, 50, 56, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1cf0 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,111,112,101,110,
/* 0x1d00 */  10, 48, 48, 48, 48, 48, 49, 49, 52, 32,103, 32, 32, 32, 32, 32,
/* 0x1d10 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,107,100,
/* 0x1d20 */ 105,114, 10, 48, 48, 48, 48, 48, 48, 56, 56, 32,103, 32, 32, 32,
/* 0x1d30 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 99,
/* 0x1d40 */ 108,111,115,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x1d50 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76,
/* 0x1d60 */  70, 77, 65, 73, 78, 90, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x1d70 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d80 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1d90 */  48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1da0 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x1db0 */  48, 48, 48, 48, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1dc0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1dd0 */  90, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77,
/* 0x1de0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x1df0 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32, 82,
/* 0x1e00 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e10 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48,
/* 0x1e20 */  53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1e30 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x1e40 */  48, 48, 48, 48, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1e50 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1e60 */  90, 10, 48, 48, 48, 48, 48, 50, 49, 52, 32, 82, 95, 65, 82, 77,
/* 0x1e70 */  95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 79, 95, 66,
/* 0x1e80 */  73, 78, 70, 79, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x1e90 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 72, 85,
/* 0x1ea0 */  77, 70, 95, 65, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x1eb0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1ec0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ed0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1ee0 */  32, 32, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,
/* 0x1ef0 */ 102,100, 95, 97,110,100,114,111,105,100, 10, 10, 82, 69, 76, 79,
/* 0x1f00 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x1f10 */  79, 82, 32, 91, 72, 85, 77, 70, 95, 76, 93, 58, 10, 79, 70, 70,
/* 0x1f20 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x1f30 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x1f40 */  48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1f50 */  52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,
/* 0x1f60 */ 112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120, 10, 10,
/* 0x1f70 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x1f80 */  68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x1f90 */  79, 73, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x1fa0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1fb0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32,
/* 0x1fc0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1fd0 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x1fe0 */  48, 48, 48, 48, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1ff0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2000 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32, 82, 95,
/* 0x2010 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2020 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2030 */  48, 48, 53, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2040 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2050 */  73, 68, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82,
/* 0x2060 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,
/* 0x2070 */ 109,115,101,116, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82, 95,
/* 0x2080 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2090 */ 115,116, 97,116, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82, 95,
/* 0x20a0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x20b0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x20c0 */  48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x20d0 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x20e0 */  73, 68, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65, 82,
/* 0x20f0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2100 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x2110 */  98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2120 */  32, 32, 32, 32, 32,109,107,100,105,114, 10, 48, 48, 48, 48, 48,
/* 0x2130 */  48,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2140 */  32, 32, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 10, 48, 48,
/* 0x2150 */  48, 48, 48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2160 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2170 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32, 82, 95,
/* 0x2180 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2190 */ 109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 49, 50, 48,
/* 0x21a0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x21b0 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x21c0 */  48, 48, 48, 48, 49, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x21d0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x21e0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 52, 99, 32, 82,
/* 0x21f0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2200 */  32,111,112,101,110, 10, 48, 48, 48, 48, 48, 49, 54, 48, 32, 82,
/* 0x2210 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2220 */  32,114,101, 97,100, 10, 48, 48, 48, 48, 48, 49, 54, 99, 32, 82,
/* 0x2230 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2240 */  32, 99,108,111,115,101, 10, 48, 48, 48, 48, 48, 49, 55, 56, 32,
/* 0x2250 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2260 */  32, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 49,
/* 0x2270 */  57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2280 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2290 */  10, 48, 48, 48, 48, 48, 49, 97, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x22a0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x22b0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 97, 52,
/* 0x22c0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x22d0 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x22e0 */  48, 48, 48, 48, 49, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x22f0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2300 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 99, 52, 32, 82,
/* 0x2310 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2320 */  32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 49,100,
/* 0x2330 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2340 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2350 */  48, 48, 48, 48, 48, 49,101, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2360 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2370 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49,101, 56, 32,
/* 0x2380 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2390 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x23a0 */  48, 48, 48, 50, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x23b0 */  52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121,
/* 0x23c0 */  10, 48, 48, 48, 48, 48, 50, 49, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x23d0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112,
/* 0x23e0 */  99,112,121, 10, 48, 48, 48, 48, 48, 50, 50, 99, 32, 82, 95, 65,
/* 0x23f0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2400 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x2410 */  50, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2420 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x2430 */  68, 10, 48, 48, 48, 48, 48, 50, 51, 56, 32, 82, 95, 65, 82, 77,
/* 0x2440 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2450 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 51,
/* 0x2460 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2470 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2480 */  48, 48, 48, 48, 48, 50, 53, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2490 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,
/* 0x24a0 */ 112,121, 10, 48, 48, 48, 48, 48, 50, 54, 99, 32, 82, 95, 65, 82,
/* 0x24b0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x24c0 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50,
/* 0x24d0 */  55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x24e0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x24f0 */  10, 48, 48, 48, 48, 48, 50, 56, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2500 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112,
/* 0x2510 */  99,112,121, 10, 48, 48, 48, 48, 48, 50, 57, 48, 32, 82, 95, 65,
/* 0x2520 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,
/* 0x2530 */ 101,116,112,105,100, 10, 48, 48, 48, 48, 48, 50, 57, 56, 32, 82,
/* 0x2540 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2550 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2560 */  48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2570 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2580 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 98, 48, 32, 82, 95, 65,
/* 0x2590 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x25a0 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x25b0 */  50,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x25c0 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x25d0 */  68, 10, 48, 48, 48, 48, 48, 50,102, 48, 32, 82, 95, 65, 82, 77,
/* 0x25e0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,
/* 0x25f0 */ 102,100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 50,
/* 0x2600 */ 102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2610 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2620 */  10, 48, 48, 48, 48, 48, 51, 48, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2630 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,102,
/* 0x2640 */ 100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 51, 49,
/* 0x2650 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2660 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2670 */  48, 48, 48, 48, 48, 51, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2680 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2690 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 51, 56, 32,
/* 0x26a0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x26b0 */  32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 51, 52, 48, 32,
/* 0x26c0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x26d0 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x26e0 */  48, 48, 48, 51, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x26f0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2700 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 53, 99, 32, 82, 95,
/* 0x2710 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2720 */ 109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 51, 54, 56,
/* 0x2730 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2740 */  32, 32, 32,117,110, 97,109,101, 10, 48, 48, 48, 48, 48, 51, 54,
/* 0x2750 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2760 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2770 */  48, 48, 48, 48, 48, 51, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2780 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2790 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 56, 56, 32,
/* 0x27a0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x27b0 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x27c0 */  48, 48, 48, 51, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x27d0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x27e0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 97, 48, 32, 82, 95,
/* 0x27f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2800 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2810 */  48, 51, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2820 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2830 */  73, 68, 10, 48, 48, 48, 48, 48, 51, 98, 56, 32, 82, 95, 65, 82,
/* 0x2840 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2850 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,
/* 0x2860 */  99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2870 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2880 */  10, 48, 48, 48, 48, 48, 51, 99, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2890 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,
/* 0x28a0 */ 117,112,120,102,110, 95,112, 97,116,104, 10, 48, 48, 48, 48, 48,
/* 0x28b0 */  51,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x28c0 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x28d0 */  68, 10, 48, 48, 48, 48, 48, 51,101, 99, 32, 82, 95, 65, 82, 77,
/* 0x28e0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x28f0 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,102,
/* 0x2900 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2910 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2920 */  48, 48, 48, 48, 48, 52, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2930 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2940 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 49, 48, 32,
/* 0x2950 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2960 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2970 */  48, 48, 48, 52, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2980 */  52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48,
/* 0x2990 */  48, 48, 48, 52, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x29a0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x29b0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 51, 52, 32, 82, 95,
/* 0x29c0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x29d0 */ 117,110,108,105,110,107, 10, 48, 48, 48, 48, 48, 52, 51, 99, 32,
/* 0x29e0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x29f0 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2a00 */  48, 48, 48, 52, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2a10 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2a20 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 52, 99, 32, 82, 95,
/* 0x2a30 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2a40 */ 103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48,
/* 0x2a50 */  48, 48, 48, 52, 54, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2a60 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2a70 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 54, 99, 32, 82, 95,
/* 0x2a80 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2a90 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2aa0 */  48, 52, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2ab0 */  32, 32, 32, 32, 32, 32, 32,102,116,114,117,110, 99, 97,116,101,
/* 0x2ac0 */  10, 48, 48, 48, 48, 48, 52, 56, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x2ad0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2ae0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 56, 52,
/* 0x2af0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2b00 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2b10 */  48, 48, 48, 48, 52, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2b20 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,108,115,101,101,107, 10,
/* 0x2b30 */  48, 48, 48, 48, 48, 52, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2b40 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,101,
/* 0x2b50 */  10, 48, 48, 48, 48, 48, 52, 99, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2b60 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,108,115,101,101,
/* 0x2b70 */ 107, 10, 48, 48, 48, 48, 48, 52,100, 52, 32, 82, 95, 65, 82, 77,
/* 0x2b80 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2b90 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,100,
/* 0x2ba0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2bb0 */  32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,
/* 0x2bc0 */ 107, 10, 48, 48, 48, 48, 48, 52,101, 52, 32, 82, 95, 65, 82, 77,
/* 0x2bd0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2be0 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,102,
/* 0x2bf0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2c00 */  32, 32, 32, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 52,
/* 0x2c10 */ 102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2c20 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2c30 */  10, 48, 48, 48, 48, 48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2c40 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,112,
/* 0x2c50 */  10, 48, 48, 48, 48, 48, 53, 50, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2c60 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2c70 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 53, 51, 48,
/* 0x2c80 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2c90 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 10,
/* 0x2ca0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x2cb0 */  68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 76, 73, 78, 85,
/* 0x2cc0 */  88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x2cd0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x2ce0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95,
/* 0x2cf0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2d00 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48,
/* 0x2d10 */  50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2d20 */  32, 32, 32, 32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,
/* 0x2d30 */ 101, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77,
/* 0x2d40 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2d50 */  95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 51, 99, 32,
/* 0x2d60 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2d70 */  32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 10, 48,
/* 0x2d80 */  48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2d90 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73,
/* 0x2da0 */  78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 65,
/* 0x2db0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2dc0 */  77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 54,
/* 0x2dd0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2de0 */  32, 32, 32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 48, 55,
/* 0x2df0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2e00 */  32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48,
/* 0x2e10 */  48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2e20 */  52, 32, 32, 32, 32, 32, 32, 32, 32,102,116,114,117,110, 99, 97,
/* 0x2e30 */ 116,101, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82,
/* 0x2e40 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2e50 */  70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 98, 56,
/* 0x2e60 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2e70 */  32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 99, 48,
/* 0x2e80 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2e90 */  32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107,
/* 0x2ea0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x2eb0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73,
/* 0x2ec0 */  78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x2ed0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ee0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82,
/* 0x2ef0 */  95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x2f00 */  32, 77, 70, 76, 71, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82,
/* 0x2f10 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2f20 */  32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48,
/* 0x2f30 */  49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2f40 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48,
/* 0x2f50 */  48, 48, 48, 48, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2f60 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x2f70 */  88, 10, 48, 48, 48, 48, 48, 48, 50, 56, 32, 82, 95, 65, 82, 77,
/* 0x2f80 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x2f90 */  77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 53, 56, 32, 82,
/* 0x2fa0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2fb0 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48,
/* 0x2fc0 */  57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2fd0 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48,
/* 0x2fe0 */  48, 48, 48, 48, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2ff0 */  52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,
/* 0x3000 */ 112, 95, 97,110,100, 95,102,100, 10, 48, 48, 48, 48, 48, 48, 97,
/* 0x3010 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3020 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48,
/* 0x3030 */  48, 48, 48,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3040 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x3050 */  10, 48, 48, 48, 48, 48, 49, 49, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x3060 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x3070 */  65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 55, 48, 32, 82, 95,
/* 0x3080 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3090 */  69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 56,
/* 0x30a0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x30b0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48,
/* 0x30c0 */  48, 48, 49, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x30d0 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x30e0 */  10, 48, 48, 48, 48, 48, 49, 99, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x30f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x3100 */  65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95,
/* 0x3110 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3120 */  69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49,100,
/* 0x3130 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3140 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48,
/* 0x3150 */  48, 48, 49,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3160 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x3170 */  10, 48, 48, 48, 48, 48, 49,101, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x3180 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x3190 */  65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49,102, 48, 32, 82, 95,
/* 0x31a0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x31b0 */  69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 50, 48,
/* 0x31c0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x31d0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48,
/* 0x31e0 */  48, 48, 50, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x31f0 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x3200 */  10, 48, 48, 48, 48, 48, 50, 48, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x3210 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x3220 */  65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 50, 49, 52, 32, 82, 95,
/* 0x3230 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3240 */  69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 50, 49,
/* 0x3250 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3260 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48,
/* 0x3270 */  48, 48, 50, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3280 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x3290 */  10, 48, 48, 48, 48, 48, 50, 51, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x32a0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x32b0 */  65, 73, 78, 88, 10
};
