/*
 * Copyright 2014 Attila Szegedi, Daniel Dekany, Jonathan Revusky
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package freemarker.debug;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.EventListener;

/**
 * An interface for components that wish to receive debugging events.
 */
public interface DebuggerListener extends Remote, EventListener
{
    /**
     * Called whenever an environment gets suspended (ie hits a breakpoint).
     * @param e the event object
     */
    public void environmentSuspended(EnvironmentSuspendedEvent e)
    throws
        RemoteException;
}
