
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file BoxPlotWhiskerBoxAttributes.h
    \\brief Definition of BoxPlotWhiskerBox Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "BoxPlotWhiskerBoxAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

BoxPlotWhiskerBoxAttributes::BoxPlotWhiskerBoxAttributes():
	width_(ParameterManager::getDouble("boxplot_whisker_box_width"))
	,
	colour_(MagTranslator<string, Colour>().magics("boxplot_whisker_box_colour")),
	border_(MagTranslator<string, NoBoxPlotWhiskerBorder>().magics("boxplot_whisker_box_border"))
	 
{
} 


BoxPlotWhiskerBoxAttributes::~BoxPlotWhiskerBoxAttributes()
{
	
}

    
void BoxPlotWhiskerBoxAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(3);
	int i = 0;
	prefix[i++] = "boxplot";
	prefix[i++] = "boxplot_whisker";
	prefix[i++] = "boxplot_whisker_box";
	
	setAttribute(prefix, "boxplot_whisker_box_width", width_, params);
	
	setMember(prefix, "boxplot_whisker_box_colour", colour_, params);
	setMember(prefix, "boxplot_whisker_box_border", border_, params);
	
}

void BoxPlotWhiskerBoxAttributes::copy(const BoxPlotWhiskerBoxAttributes& other)
{
	width_ = other.width_;
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	border_ = unique_ptr<NoBoxPlotWhiskerBorder>(other.border_->clone());
	
} 


bool BoxPlotWhiskerBoxAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "whisker_box")  )
		return true;
	if ( acceptNode(node, border_) )
		return true;
	
	return false;
}

void BoxPlotWhiskerBoxAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "whisker_box")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), border_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), border_, *elt); 
		
	}
}

void BoxPlotWhiskerBoxAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " width = " <<  width_;
	out << " colour = " <<  *colour_;
	out << " border = " <<  *border_;
	
	out << "]" << "\n";
}

void BoxPlotWhiskerBoxAttributes::toxml(ostream& out)  const
{
	out <<  "\"whisker_box\""; 
	out << ", \"boxplot_whisker_box_width\":";
	niceprint(out,width_);
	out << ", \"boxplot_whisker_box_colour\":";
	niceprint(out, *colour_);
	out << ", \"boxplot_whisker_box_border\":";
	border_->toxml(out);
	
}

static MagicsParameter<double> boxplot_whisker_box_width("boxplot_whisker_box_width", 0.25, "");
static MagicsParameter<string> boxplot_whisker_box_colour("boxplot_whisker_box_colour", "sky", ""); 
static MagicsParameter<string> boxplot_whisker_box_border("boxplot_whisker_box_border", "on", ""); 
#include "BoxPlotItem.h"
#include "BoxPlotBasicItem.h"
static SimpleObjectMaker<BoxPlotWhiskerBorder , NoBoxPlotWhiskerBorder> border_BoxPlotWhiskerBorder("border");
static SimpleObjectMaker<BoxPlotWhiskerBorder , NoBoxPlotWhiskerBorder> on_BoxPlotWhiskerBorder("on");
static SimpleObjectMaker<NoBoxPlotWhiskerBorder , NoBoxPlotWhiskerBorder> noborder_NoBoxPlotWhiskerBorder("noborder");
static SimpleObjectMaker<NoBoxPlotWhiskerBorder , NoBoxPlotWhiskerBorder> off_NoBoxPlotWhiskerBorder("off");
