/* Copyright (c) 1997-2021
   Ewgenij Gawrilow, Michael Joswig, and the polymake team
   Technische Universität Berlin, Germany
   https://polymake.org

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version: http://www.gnu.org/licenses/gpl.txt.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
--------------------------------------------------------------------------------
*/

package de.tuberlin.polymake.common.ui;

import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

import javax.swing.JPanel;

public class ParameterPanel extends JPanel {

	/**	Autogenerated ID for serialization */
	private static final long serialVersionUID = 7620575335995242200L;
	
	/** Contains interactive sliders */
	protected HashMap sliderMap = new HashMap();

	public ParameterPanel(Properties params, Properties iparams,
			SliderListener sl) {
		super();
		setLayout(new GridLayout(iparams.size(), 1));

		for (Iterator it = iparams.keySet().iterator(); it.hasNext();) {
			String param = (String) it.next();
			String value = (String) (iparams.get(param));
			PolymakeSlider slider;
			if (value.equals("1")) {
				slider = new PolymakeSlider(param, 0, 100, 100*Double.parseDouble(params.getProperty(param)));
				slider.addSliderListener(sl);
			} else {
				slider = new PolymakeSlider(param, 0, 100, 100*Double.parseDouble(params.getProperty(param)));
			}
			add(slider.getComponent());
			sliderMap.put(param, slider);
		}
	}

	/**
	 * Update the sliders with a given set of properties. Unknown properties are
	 * ignored!
	 * 
	 * @param params
	 *            contains the new values for the sliders
	 */
	public void updateSliders(Properties params) {
		for (Iterator it = params.keySet().iterator(); it.hasNext();) {
			String prop = (String) it.next();
			if (!params.getProperty(prop).equals("null")) {
				setParameter(prop, params.getProperty(prop));
			}
		}
	}

	/**
	 * Set the value for a parameter. Value does not exist, it is ignored.
	 * 
	 * @param name
	 *            name of the parameter
	 * 
	 * @param value
	 *            value of the parameter
	 */
	public void setParameter(String name, String value) {
		PolymakeSlider slider = (PolymakeSlider) sliderMap.get(name);
		// TODO: more transparent handling? maybe an exception?
		if (slider != null) {
			slider.setDoubleValue(Double.parseDouble(value));
		}
	}

	public String getParameter(String prop) {
		PolymakeSlider slider = (PolymakeSlider) sliderMap.get(prop);
		return Double.toString(slider.getDoubleValue());
	}

	public Set getParameters() {
		return sliderMap.keySet();
	}

	 public void addSlider(String param, PolymakeSlider ps) {
		setLayout(new GridLayout(sliderMap.size()+1, 1));
		sliderMap.put(param, ps);
		this.validate();
	 }
}
