;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2014 Taylan Ulrich Bayirli/Kammer <taylanbayirli@gmail.com>
;;; Copyright © 2013-2023 Ludovic Courtès <ludo@gnu.org>
;;; Copyright © 2014, 2015, 2016, 2017, 2018 Mark H Weaver <mhw@netris.org>
;;; Copyright © 2014, 2015, 2016, 2017, 2018, 2019 Alex Kost <alezost@gmail.com>
;;; Copyright © 2015 Federico Beffa <beffa@fbengineering.ch>
;;; Copyright © 2015-2024 Ricardo Wurmus <rekado@elephly.net>
;;; Copyright © 2016, 2017, 2018, 2019 Chris Marusich <cmmarusich@gmail.com>
;;; Copyright © 2015, 2016, 2018, 2020 Christine Lemmer-Webber <cwebber@dustycloud.org>
;;; Copyright © 2016 Adriano Peluso <catonano@gmail.com>
;;; Copyright © 2016-2021, 2023 Efraim Flashner <efraim@flashner.co.il>
;;; Copyright © 2016 David Thompson <davet@gnu.org>
;;; Copyright © 2016 Matthew Jordan <matthewjordandevops@yandex.com>
;;; Copyright © 2016, 2017 Roel Janssen <roel@gnu.org>
;;; Copyright © 2016, 2017 Nikita <nikita@n0.is>
;;; Copyright © 2016, 2019 Alex Griffin <a@ajgrf.com>
;;; Copyright © 2016-2025 Nicolas Goaziou <mail@nicolasgoaziou.fr>
;;; Copyright © 2016, 2017, 2018 Alex Vong <alexvong1995@gmail.com>
;;; Copyright © 2016-2022, 2024–2025 Arun Isaac <arunisaac@systemreboot.net>
;;; Copyright © 2017 Christopher Baines <mail@cbaines.net>
;;; Copyright © 2017, 2018, 2019, 2020, 2022 Mathieu Othacehe <m.othacehe@gmail.com>
;;; Copyright © 2017, 2018, 2019, 2020, 2021, 2022 Clément Lassieur <clement@lassieur.org>
;;; Copyright © 2017 Vasile Dumitrascu <va511e@yahoo.com>
;;; Copyright © 2017, 2018, 2022 Kyle Meyer <kyle@kyleam.com>
;;; Copyright © 2017 Kei Kebreau <kkebreau@posteo.net>
;;; Copyright © 2017 George Clemmer <myglc2@gmail.com>
;;; Copyright © 2017, 2018 Feng Shu <tumashu@163.com>
;;; Copyright © 2017, 2020, 2023 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
;;; Copyright © 2017, 2018, 2019, 2020 Oleg Pykhalov <go.wigust@gmail.com>
;;; Copyright © 2017 Mekeor Melire <mekeor.melire@gmail.com>
;;; Copyright © 2017 Peter Mikkelsen <petermikkelsen10@gmail.com>
;;; Copyright © 2017–2021 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2017 Mike Gerwitz <mtg@gnu.org>
;;; Copyright © 2017-2025 Maxim Cournoyer <maxim@guixotic.coop>
;;; Copyright © 2018 Sohom Bhattacharjee <soham.bhattacharjee15@gmail.com>
;;; Copyright © 2018, 2019 Mathieu Lirzin <mthl@gnu.org>
;;; Copyright © 2018, 2019, 2020, 2021 Pierre Neidhardt <mail@ambrevar.xyz>
;;; Copyright © 2018, 2019, 2020 Tim Gesthuizen <tim.gesthuizen@yahoo.de>
;;; Copyright © 2018, 2019 Jack Hill <jackhill@jackhill.us>
;;; Copyright © 2018 Pierre-Antoine Rouby <pierre-antoine.rouby@inria.fr>
;;; Copyright © 2018 Alex Branham <alex.branham@gmail.com>
;;; Copyright © 2018 Thorsten Wilms <t_w_@freenet.de>
;;; Copyright © 2018, 2019, 2020, 2021 Pierre Langlois <pierre.langlois@gmx.com>
;;; Copyright © 2018, 2019, 2020, 2021 Brett Gilio <brettg@gnu.org>
;;; Copyright © 2019, 2020 Dimakakos Dimos <bendersteed@teknik.io>
;;; Copyright © 2019, 2020 Brian Leung <bkleung89@gmail.com>
;;; Copyright © 2019 mikadoZero <mikadozero@yandex.com>
;;; Copyright © 2019 Gabriel Hondet <gabrielhondet@gmail.com>
;;; Copyright © 2019, 2020, 2021 Joseph LaFreniere <joseph@lafreniere.xyz>
;;; Copyright © 2019 Todor Kondić <tk.code@protonmail.com>15669
;;; Copyright © 2019 Amar Singh <nly@disroot.org>
;;; Copyright © 2019, 2022, 2023 Baptiste Strazzulla <bstrazzull@hotmail.fr>
;;; Copyright © 2019 Giacomo Leidi <therewasa@fishinthecalculator.me>
;;; Copyright © 2019 Jens Mølgaard <jens@zete.tk>
;;; Copyright © 2019, 2020 Amin Bandali <bandali@gnu.org>
;;; Copyright © 2019 Jelle Licht <jlicht@fsfe.org>
;;; Copyright © 2019 Björn Höfling <bjoern.hoefling@bjoernhoefling.de>
;;; Copyright © 2019 Stephen Webber <montokapro@gmail.com>
;;; Copyright © 2019, 2021 Liliana Marie Prikler <liliana.prikler@gmail.com>
;;; Copyright © 2019 David Wilson <david@daviwil.com>
;;; Copyright © 2020 Paul Garlick <pgarlick@tourbillion-technology.com>
;;; Copyright © 2020 Robert Smith <robertsmith@posteo.net>
;;; Copyright © 2020 Evan Straw <evan.straw99@gmail.com>
;;; Copyright © 2020, 2021, 2022 Masaya Tojo <masaya@tojo.tokyo>
;;; Copyright © 2020, 2021 Martin Becze <mjbecze@riseup.net>
;;; Copyright © 2020, 2021, 2022 Michael Rohleder <mike@rohleder.de>
;;; Copyright © 2020 Brice Waegeneire <brice@waegenei.re>
;;; Copyright © 2020 6033fe7de85d <6033fe7de85d@airmail.cc>
;;; Copyright © 2020 John Soo <jsoo1@asu.edu>
;;; Copyright © 2020 Jérémy Korwin-Zmijowski <jeremy@korwin-zmijowski.fr>
;;; Copyright © 2020 Alberto Eleuterio Flores Guerrero <barbanegra+guix@posteo.mx>
;;; Copyright © 2020 Marius Bakke <mbakke@fastmail.com>
;;; Copyright © 2020, 2022, 2023, 2025 pinoaffe <pinoaffe@gmail.com>
;;; Copyright © 2020, 2021, 2022 Vinicius Monego <monego@posteo.net>
;;; Copyright © 2020 Ryan Desfosses <rdes@protonmail.com>
;;; Copyright © 2020 Marcin Karpezo <sirmacik@wioo.waw.pl>
;;; Copyright © 2020, 2022 Fredrik Salomonsson <plattfot@posteo.net>
;;; Copyright © 2020 Eric Bavier <bavier@posteo.net>
;;; Copyright © 2020, 2021 Morgan Smith <Morgan.J.Smith@outlook.com>
;;; Copyright © 2020 Peng Mei Yu <i@pengmeiyu.com>
;;; Copyright © 2020, 2021, 2022 Niklas Eklund <niklas.eklund@posteo.net>
;;; Copyright © 2020 Marco Grassi <marco.au.grassi98@protonmail.com>
;;; Copyright © 2020 Tomás Ortín Fernández <tomasortin@mailbox.org>
;;; Copyright © 2020-2022, 2025 Zhu Zihao <all_but_last@163.com>
;;; Copyright © 2020 Adam Kandur <rndd@tuta.io>
;;; Copyright © 2020 Tim Howes <timhowes@lavabit.com>
;;; Copyright © 2020 Noah Landis <noahlandis@posteo.net>
;;; Copyright © 2020, 2021 Nicolò Balzarotti <nicolo@nixo.xyz>
;;; Copyright © 2020, 2022 André A. Gomes <andremegafone@gmail.com>
;;; Copyright © 2020 Jonathan Rostran <rostranjj@gmail.com>
;;; Copyright © 2020, 2021 Noah Evans <noah@nevans.me>
;;; Copyright © 2020 Brit Butler <brit@kingcons.io>
;;; Copyright © 2021, 2022, 2024 Aleksandr Vityazev <avityazev@disroot>
;;; Copyright © 2021 Yurii Kholodkov <urist.mckorobochka@gmail.com>
;;; Copyright © 2021 Alexey Abramov <levenson@mmer.org>
;;; Copyright © 2021 Xinglu Chen <public@yoctocell.xyz>
;;; Copyright © 2021, 2022 Stefan Reichör <stefan@xsteve.at>
;;; Copyright © 2021, 2022, 2023 Simon Tournier <zimon.toutoune@gmail.com>
;;; Copyright © 2021 Eugene Klimov <lipklim@mailbox.org>
;;; Copyright © 2021, 2024 Zheng Junjie <873216071@qq.com>
;;; Copyright © 2021 David Dashyan <mail@davie.li>
;;; Copyright © 2021 Dhruvin Gandhi <contact@dhruvin.dev>
;;; Copyright © 2021 Matthew James Kraai <kraai@ftbfs.org>
;;; Copyright © 2021 Noisytoot <noisytoot@disroot.org>
;;; Copyright © 2021 Simon South <simon@simonsouth.net>
;;; Copyright © 2021 la snesne <lasnesne@lagunposprasihopre.org>
;;; Copyright © 2021 Brian Kubisiak <brian@kubisiak.com>
;;; Copyright © 2021, 2022 Taiju HIGASHI <higashi@taiju.info>
;;; Copyright © 2022 Brandon Lucas <br@ndon.dk>
;;; Copyright © 2022 Jai Vetrivelan <jaivetrivelan@gmail.com>
;;; Copyright © 2022, 2023, 2025 jgart <jgart@dismail.de>
;;; Copyright © 2022 Dominic Martinez <dom@dominicm.dev>
;;; Copyright © 2022 Peter Polidoro <peter@polidoro.io>
;;; Copyright © 2022 Luis Felipe López Acevedo <luis.felipe.la@protonmail.com>
;;; Copyright © 2022 Thomas Albers Raviola <thomas@thomaslabs.org>
;;; Copyright © 2022 Haider Mirza <haider@haider.gq>
;;; Copyright © 2022 Jose G Perez Taveras <josegpt27@gmail.com>
;;; Copyright © 2022 Hilton Chain <hako@ultrarare.space>
;;; Copyright © 2022, 2024, 2025 Nicolas Graves <ngraves@ngraves.fr>
;;; Copyright © 2022 Thiago Jung Bauermann <bauermann@kolabnow.com>
;;; Copyright © 2022 Joeke de Graaf <joeke@posteo.net>
;;; Copyright © 2023, 2025 Simon Streit <simon@netpanic.org>
;;; Copyright © 2023, 2025 John Kehayias <john.kehayias@protonmail.com>
;;; Copyright © 2023 Ivan Vilata-i-Balaguer <ivan@selidor.net>
;;; Copyright © 2022 Demis Balbach <db@minikn.xyz>
;;; Copyright © 2020, 2021, 2022, 2023 Andrew Tropin <andrew@trop.in>
;;; Copyright © 2023 Dominik Delgado Steuter <d@delgado.nrw>
;;; Copyright © 2023 Juliana Sims <juli@incana.org>
;;; Copyright © 2023, 2025 Evgeny Pisemsky <mail@pisemsky.site>
;;; Copyright © 2023 Gabriel Wicki <gabriel@erlikon.ch>
;;; Copyright © 2022-2023 Simon Josefsson <simon@josefsson.org>
;;; Copyright © 2023, 2025 Fabio Natali <me@fabionatali.com>
;;; Copyright © 2023 Arnaud Lechevallier <arnaud.lechevallier@free.fr>
;;; Copyright © 2023 Ahmad Draidi <a.r.draidi@redscript.org>
;;; Copyright © 2023 Sergiu Ivanov <sivanov@colimite.fr>
;;; Copyright © 2023 Camilo Q.S. (Distopico) <distopico@riseup.net>
;;; Copyright © 2023 Thanos Apollo <public@thanosapollo.com>
;;; Copyright © 2023 Ian Eure <ian@retrospec.tv>
;;; Copyright © 2024-2025 Suhail Singh <suhail@bayesians.ca>
;;; Copyright © 2024 dan <i@dan.games>
;;; Copyright © 2024 Ilya Chernyshov <ichernyshovvv@gmail.com>
;;; Copyright © 2024 Wilko Meyer <w@wmeyer.eu>
;;; Copyright © 2024 Noé Lopez <noelopez@free.fr>
;;; Copyright © 2024, 2025 gemmaro <gemmaro.dev@gmail.com>
;;; Copyright © 2024 Daniel Szmulewicz <daniel.szmulewicz@gmail.com>
;;; Copyright © 2024 Ashish SHUKLA <ashish.is@lostca.se>
;;; Copyright © 2024 Artyom V. Poptsov <poptsov.artyom@gmail.com>
;;; Copyright © 2024, 2025 Spencer King <spencer.king@wustl.edu>
;;; Copyright © 2024 emma thompson <bigbookofbug@proton.me>
;;; Copyright © 2024-2025 Liam Hupfer <liam@hpfr.net>
;;; Copyright © 2024-2025 Alvin Hsu <aurtzy@gmail.com>
;;; Copyright © 2024 Olivier Rojon <o.rojon@posteo.net>
;;; Copyright © 2024 Divya Ranjan Pattanaik <divya@subvertising.org>
;;; Copyright © 2025 Arjan Adriaanse <arjan@adriaan.se>
;;; Copyright © 2025 Remco van 't Veer <remco@remworks.net>
;;; Copyright © 2025 Skylar Hill <stellarskylark@posteo.net>
;;; Copyright © 2025 Cayetano Santos <csantosb@inventati.org>
;;; Copyright © 2025 Lee Thompson <lee.p.thomp@gmail.com>
;;; Copyright @ 2025 Amy Pillow <amypillow@lavache.com>
;;; Copyright © 2025 Kurome <hunt31999@gmail.org>
;;; Copyright © 2025 Anderson Torres <anderson.torres.8519@gmail.com>
;;; Copyright © 2025 Jake Forster <jakecameron.forster@gmail.com>
;;; Copyright @ 2025 Andrew Wong <wongandj@icloud.com>
;;; Copyright @ 2025 Nik Gaffney <nik@fo.am>
;;; Copyright © 2025 Untrusem <mysticmoksh@riseup.net>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (gnu packages emacs-xyz)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (guix packages)
  #:use-module (guix cvs-download)
  #:use-module (guix download)
  #:use-module (guix deprecation)
  #:use-module (guix bzr-download)
  #:use-module (guix gexp)
  #:use-module (guix i18n)
  #:use-module (guix git-download)
  #:use-module (guix hg-download)
  #:use-module (guix build-system gnu)
  #:use-module (guix build-system cmake)
  #:use-module (guix build-system copy)
  #:use-module (guix build-system emacs)
  #:use-module (guix build-system perl)
  #:use-module (guix build-system trivial)
  #:use-module (gnu packages)
  #:use-module (gnu packages admin)
  #:use-module (gnu packages aspell)
  #:use-module (gnu packages audio)
  #:use-module (gnu packages bash)
  #:use-module (gnu packages chez)
  #:use-module (gnu packages cmake)
  #:use-module (gnu packages code)
  #:use-module (gnu packages cpp)
  #:use-module (gnu packages curl)
  #:use-module (gnu packages databases)
  #:use-module (gnu packages dictionaries)
  #:use-module (gnu packages djvu)
  #:use-module (gnu packages ebook)
  #:use-module (gnu packages electronics)
  #:use-module (gnu packages emacs)
  #:use-module (gnu packages emacs-build)
  #:use-module (gnu packages enchant)
  #:use-module (gnu packages fonts)
  #:use-module (gnu packages freedesktop)
  #:use-module (gnu packages games)
  #:use-module (gnu packages gawk)
  #:use-module (gnu packages golang-apps)
  #:use-module (gnu packages guile)
  #:use-module (gnu packages gtk)
  #:use-module (gnu packages gnome)
  #:use-module (gnu packages graphviz)
  #:use-module (gnu packages haskell)
  #:use-module (gnu packages haskell-apps)
  #:use-module (gnu packages ibus)
  #:use-module (gnu packages idris)
  #:use-module (gnu packages java)
  #:use-module (gnu packages julia-xyz)
  #:use-module (gnu packages ncurses)
  #:use-module (gnu packages networking)
  #:use-module (gnu packages python)
  #:use-module (gnu packages python-xyz)
  #:use-module (gnu packages python-check)
  #:use-module (gnu packages telephony)
  #:use-module (gnu packages terminals)
  #:use-module (gnu packages tex)
  #:use-module (gnu packages texinfo)
  #:use-module (gnu packages tcl)
  #:use-module (gnu packages tls)
  #:use-module (gnu packages tree-sitter)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages xorg)
  #:use-module (gnu packages lesstif)
  #:use-module (gnu packages llvm)
  #:use-module (gnu packages image)
  #:use-module (gnu packages image-processing)
  #:use-module (gnu packages image-viewers)
  #:use-module (gnu packages libffi)
  #:use-module (gnu packages linux)
  #:use-module (gnu packages libevent)
  #:use-module (gnu packages lisp)
  #:use-module (gnu packages lisp-xyz)
  #:use-module (gnu packages lsof)
  #:use-module (gnu packages lua)
  #:use-module (gnu packages maths)
  #:use-module (gnu packages music)
  #:use-module (gnu packages version-control)
  #:use-module (gnu packages imagemagick)
  #:use-module (gnu packages w3m)
  #:use-module (gnu packages web)
  #:use-module (gnu packages wget)
  #:use-module (gnu packages autotools)
  #:use-module (gnu packages base)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages node)
  #:use-module (gnu packages xml)
  #:use-module (gnu packages glib)
  #:use-module (gnu packages acl)
  #:use-module (gnu packages mail)
  #:use-module (gnu packages messaging)
  #:use-module (gnu packages package-management)
  #:use-module (gnu packages perl)
  #:use-module (gnu packages perl6)
  #:use-module (gnu packages pdf)
  #:use-module (gnu packages racket)
  #:use-module (gnu packages ruby)
  #:use-module (gnu packages ruby-check)
  #:use-module (gnu packages ruby-xyz)
  #:use-module (gnu packages rust)
  #:use-module (gnu packages rust-apps)
  #:use-module (gnu packages scheme)
  #:use-module (gnu packages serialization)
  #:use-module (gnu packages speech)
  #:use-module (gnu packages xiph)
  #:use-module (gnu packages mp3)
  #:use-module (gnu packages gettext)
  #:use-module (gnu packages fribidi)
  #:use-module (gnu packages gd)
  #:use-module (gnu packages fontutils)
  #:use-module (gnu packages password-utils)
  #:use-module (gnu packages pulseaudio)
  #:use-module (gnu packages animation)
  #:use-module (gnu packages sphinx)
  #:use-module (gnu packages screen)
  #:use-module (gnu packages xdisorg)
  #:use-module (gnu packages shells)
  #:use-module (gnu packages shellutils)
  #:use-module (gnu packages sqlite)
  #:use-module (gnu packages ghostscript)
  #:use-module (gnu packages gnupg)
  #:use-module (gnu packages video)
  #:use-module (gnu packages haskell-xyz)
  #:use-module (gnu packages wordnet)
  #:use-module (gnu packages photo)
  #:use-module (gnu packages tor)
  #:use-module (gnu packages uml)
  #:use-module (gnu packages finance)
  #:use-module (gnu packages ocaml)
  #:use-module (gnu packages erlang)
  #:use-module (gnu packages search)
  #:use-module (gnu packages statistics)
  #:use-module (gnu packages libcanberra)
  #:use-module (gnu packages telegram)
  #:use-module (gnu packages texinfo)
  #:use-module (gnu packages text-editors)
  #:use-module (gnu packages virtualization)
  #:use-module (gnu packages web-browsers)
  #:use-module (gnu packages wget)
  #:use-module (guix utils)
  #:use-module (srfi srfi-1)
  #:use-module (ice-9 match))

(define-public emacs-0x0
  (let ((commit "04f95142b25d8bb701f239539176df6617dcd982")
        (revision "0"))
    (package
      (name "emacs-0x0")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://git.sr.ht/~willvaughn/emacs-0x0")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0vj9vrfkgm7plp5mvq22fm9sln11j9763g3wd2w6c82rlsk6dhva"))))
      (build-system emacs-build-system)
      (home-page "https://git.sr.ht/~willvaughn/emacs-0x0")
      (synopsis
       "Integration with @url{https://0x0.st} and self-hosted services
from Emacs")
      (description
       "Emacs 0x0 is a pastebin integration tool.  It can upload the current
buffer, a file on your disk, or a string from the kill ring.")
      (license license:gpl3+))))

(define-public emacs-ac-ispell
  (let ((commit "22bace7387e9012002a6a444922f75f9913077b0")
        (revision "1"))
    (package
      (name "emacs-ac-ispell")
      (version (git-version "0.07" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsorphanage/ac-ispell")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1cq73bdv3lkn8v3nx6aznygqaac9s5i7pvirl8wz9ib31hsgwpbk"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-auto-complete))
      (home-page "https://github.com/emacsorphanage/ac-ispell")
      (synopsis "Ispell and Aspell completion source for Auto Complete")
      (description
       "AC Ispell is an Ispell and Aspell completion source for Auto Complete.")
      (license license:gpl3+))))

(define-public emacs-elisp-autofmt
  (let ((commit "c2765641a9bd2b4c979e7055030fb7a145b6c118")
        (revision "1"))
    (package
      (name "emacs-elisp-autofmt")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/ideasman42/emacs-elisp-autofmt")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0hgmlbxabzhwc1kw59hxvi9xgk6fh0jar4k82sb8yn1zznzhr0lk"))
         (patches
          (search-patches "emacs-elisp-autofmt-fix-region-send.patch"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "make" "test")
        #:include #~(cons* "elisp-autofmt.py"
                           "elisp-autofmt-cmd.py"
                           "elisp-autofmt.overrides.json"
                           %default-include)
        #:phases
        #~(modify-phases %standard-phases
            ;; TODO Remove when fixed upstream. See:
            ;; <https://codeberg.org/ideasman42/emacs-elisp-autofmt/issues/36>.
            (add-before 'check 'fix-tests
              (lambda _
                (setenv "HOME" (getenv "TMPDIR"))
                (substitute* '("tests/full_compare_data/spell-fu.autofmt.data"
                               "tests/full_compare_data/simple.autofmt.data")
                (("error \"Expected cache-header to be list, not %S\"")
                 "error
          \"Expected cache-header to be list, not %S\"")
                (("error \"Require cache version %S, not %S\"")
                 "error
            \"Require cache version %S, not %S\"")
                (("error \"Expected cache to contain a hash-table, not %S\"")
                 "error
          \"Expected cache to contain a hash-table, not %S\"")
                (("error \"Don.t know how to handle action %S\"")
                 "error
                    \"Don't know how to handle action %S\"")
                (("error \"Cannot indirectly clone a buffer in %s mode\" mode-name")
                 "error \"Cxnnot indirectly clone a buffer in %s mode\" mode-name")
                (("error \"Cannot indirectly clone a buffer in %s mode\"")
                 "error
          \"Cannot indirectly clone a buffer in %s mode\"")
                (("error \"Cxnnot indirectly clone a buffer in %s mode\" mode-name")
                 "error \"Cannot indirectly clone a buffer in %s mode\" mode-name")))))))
      (inputs (list python-minimal-wrapper))
      (home-page "https://codeberg.org/ideasman42/emacs-elisp-autofmt")
      (synopsis "Auto-format Emacs lisp")
      (description "This is a package to auto-format Emacs lisp.")
      (license license:gpl3+))))

(define-public emacs-ac-php
  (package
    (name "emacs-ac-php")
    (version "2.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/xcwen/ac-php")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1yn5cc6cmj3hwqgmjj44dz847xn5k99kirj36qwc04q7vhl8z8k7"))))
    (build-system emacs-build-system)
    (inputs
     (list emacs-auto-complete
           emacs-company
           emacs-dash
           emacs-f
           emacs-helm
           emacs-php-mode
           emacs-popup
           emacs-s
           emacs-xcscope))
    (native-inputs
     (list emacs-ert-runner))
    (home-page "https://github.com/xcwen/ac-php")
    (synopsis "Emacs Auto Complete & Company mode for PHP")
    (description
     "This package provides Auto Complete and Company back-ends for PHP.")
    (license license:gpl3+)))

(define-public emacs-ace-jump-helm-line
  (let ((commit "1483055255df3f8ae349f7520f05b1e43ea3ed37")
        (revision "0"))
    (package
      (name "emacs-ace-jump-helm-line")
      (version (git-version "0.5.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cute-jumper/ace-jump-helm-line")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "191a2g1if1jliikbxkpwmvlp4v1sp541j71xrlymili8ygm0idq5"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-avy emacs-helm))
      (home-page "https://github.com/cute-jumper/ace-jump-helm-line")
      (synopsis "Ace-jump to a candidate in Helm window")
      (description
       "This package allows using Ace jump to a candidate in Helm window.")
      (license license:gpl3+))))

(define-public emacs-activities
  (package
    (name "emacs-activities")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://elpa.gnu.org/packages/activities-" version ".tar"))
       (sha256
        (base32 "1b6d77b5h2vikfxqjlb1jx5pnij5bif788nysvvn3wlzpwdi88s0"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-persist))
    (home-page "https://github.com/alphapapa/activities.el")
    (synopsis "Save/restore sets of windows, tabs/frames, and their buffers")
    (description
     "Inspired by Genera's and KDE's concepts of \"activities\", this library
allows the user to select an \"activity\", the loading of which restores a
window configuration into a @code{tab-bar} tab or frame, along with the
buffers shown in each window.  Saving an activity saves the state for later
restoration.  Switching away from an activity saves the last-used state for
later switching back to, while still allowing the activity's initial or
default state to be restored on demand.  Resuming an activity loads the
last-used state, or the initial/default state when a universal argument is
provided.  The implementation uses the bookmark system to save buffers
states–that is, any major mode that supports the bookmark system is
compatible.")
    (license license:gpl3+)))

(define-public emacs-helix
  (package
    (name "emacs-helix")
    (version "0.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mgmarlow/helix-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "12frkqmv0qbs4rqxdazki6xvhdb6ykr4xsrzk8ljlj19dniawhd8"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command
      #~(list "emacs"
              "-Q"
              "--batch"
              "-l"
              "helix-test.el"
              "-f"
              "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/mgmarlow/helix-mode")
    (synopsis "Helix keybindings in Emacs")
    (description
     "This package provides a minor mode emulating Helix keybindings.")
    (license license:gpl3+)))

(define-public emacs-openssl-cipher
  ;; Latest tagged release is from 2015-01-11.  Use a more recent commit
  ;; instead.
  (let ((commit "5e48a60e426d493ebb85566b304cf5c7bd3bfb61")
        (revision "0"))
    (package
      (name "emacs-openssl-cipher")
      (version (git-version "0.8.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/mhayashi1120/Emacs-openssl-cipher")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0ik1gyhyp77b34n2lh9ns28lx3fbfky0vp6q8136vm1vw2rf153q"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list openssl))
      (home-page "https://github.com/mhayashi1120/Emacs-openssl-cipher")
      (synopsis "Cipher utilities using OpenSSL")
      (description "This package provides a library to encrypt/decrypt a string
or file with @code{openssl} command.")
      (license license:gpl3+))))

(define-public emacs-kaesar
  (package
    (name "emacs-kaesar")
    (version "0.9.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/mhayashi1120/Emacs-kaesar")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0bxmzh2my94jph2ydfx4p777xihzisvkgk9vwsnrdmfng5hfs8vv"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list
                        "make" "check"
                        ;; Don't treat warnings as errors. Tests fail
                        ;; otherwise.
                        "EMACS_LINT_IGNORE=1")
      #:phases
      #~(modify-phases %standard-phases
          ;; XXX: Skip 2 failing tests (file and region encrypt/decrypt).
          (add-before 'check 'skip-failing-tests
            (lambda _
              (substitute* "kaesar-test.el"
                (("\\(ert-deftest kaesar-test--file-encrypt/decrypt .*" all)
                 (string-append all " (skip-unless nil)"))
                (("\\(ert-deftest kaesar-test--region-encrypt/decrypt .*" all)
                 (string-append all " (skip-unless nil)"))))))))
    (propagated-inputs
     (list emacs-openssl-cipher))
    (home-page "https://github.com/mhayashi1120/Emacs-kaesar")
    (synopsis "Password-based AES algorithm for encrypting/decrypting
strings")
    (description "This package provides an @acronym{AES, Advanced Encryption
Standard} algorithm for encrypting and decrypting strings in Emacs.  The
supported algorithm is chosen to ensure interoperability with
@code{openssl}.")
    (license license:gpl3+)))

(define-public emacs-elchacha
  (package
    (name "emacs-elchacha")
    (version "1.0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/KeyWeeUsr/elchacha")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1f2nvfh2cdbb34x0smf1xlnwf8nw7mw3jng70ghkyjy7881s1f3x"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "eldev" "--use-emacsloadpath" "-dtTC" "test")))
    (native-inputs
     (list
      emacs-eldev
      emacs-undercover))
    (home-page "https://github.com/KeyWeeUsr/elchacha")
    (synopsis "ChaCha20 implementation as per RFC7539")
    (description "An implementation of the ChaCha20 encryption algorithm in
Emacs Lisp.")
    (license license:gpl3)))

(define-public emacs-perl-doc
  (package
    (name "emacs-perl-doc")
    (version "0.82")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/perl-doc-" version
                           ".tar"))
       (sha256
        (base32 "1fj13361a9pgmlda8yix0p805r2gwzv1gxf43pq6y79a8hxbm8yn"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/HaraldJoerg/emacs-perl-doc")
    (synopsis "Read Perl documentation from Emacs")
    (description
     "This package contains a command to read Perl documentation in Emacs: @samp{M-x
perl-doc}.  It uses two external commands which come with Perl:
@command{perldoc} to locate the Perl documentation for the Perl modules
installed on your system, and @command{pod2html} to format the documentation
to HTML.  This HTML version is then displayed using the Emacs simple HTML
renderer, @code{shr}.")
    (license license:gpl3+)))

(define-public emacs-sops
  (package
    (name "emacs-sops")
    (version "0.1.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/djgoku/sops")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0vi7jw7zqj04ikajnssa68v6npd43bvaiw2afck25wxa9hnaja7f"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/djgoku/sops")
    (synopsis "SOPS encrypt and decrypt without leaving the editor")
    (description
     "This package provides a minor mode for editing @acronym{SOPS, Secret
OPerationS}-encrypted files.  To enable it automatically, set
@code{global-sops-mode}.  Users can decrypt with @code{sops-edit-file}, save
changes with @code{sops-save-file}, or discard them with @code{sops-cancel}.
The files are displayed in read-only mode to prevent accidental corruption,
which is useful for partly encrypted files with only one encrypted line.")
    (license license:gpl3+)))

(define-public emacs-age
  (package
    (name "emacs-age")
    (version "0.1.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/anticomputer/age.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "09rfk9aijjgacff7n8d1cmsg7yb6cc3fppjxzs07dm9vcakcdvbh"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f))                ;no tests
    (home-page "https://github.com/anticomputer/age.el")
    (synopsis "Age Encryption support for Emacs")
    (description
     "This package provides transparent Age file encryption and decryption
in Emacs.  It is based on the Emacs EasyPG code and offers similar Emacs file
handling for Age encrypted files: maintain @file{.org.age} encrypted Org
files, provide Age encrypted authentication information out of
@file{.authinfo.age}, open/edit/save Age encrypted files via Tramp...")
    (license license:gpl3+)))

(define-public emacs-bookmark-plus
  (package
    (name "emacs-bookmark-plus")
    (version "2022.11.05")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsmirror/bookmark-plus")
             (commit "3db369056a722c42b3eafd10a91831f87d056dfa")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0fnq24f597zfr8jj5h3vr87kdil5lhy11m81q6ayqc03qm0jymrf"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacsmirror/bookmark-plus")
    (synopsis "Extensions to the Bookmark library in Emacs")
    (description
     "Bookmarks are a powerful Emacs feature.  This package makes them even
more versatile.  You can bookmark many more kinds of data.  You can add tags.
There are many more ways to organize and display your bookmarks.  I recommend
reading the extensive documentation about BookmarkPlus on the Emacs Wiki.")
    (license license:gpl3+)))

(define-public emacs-bqn-mode
  (package
    (name "emacs-bqn-mode")
    ;; Upstream releases are tagged by date.
    (version "2025-07-06")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/museoa/bqn-mode/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1b25k66nn4qa4ryhm8mzc53qvsvhgjzdngisw28cpdh109627iz3"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f)) ;No tests found in source.
    (propagated-inputs (list emacs-compat emacs-eros))
    (synopsis "Emacs major mode for the BQN programming language")
    (description
     "This package provides a major mode for editing and executing BQN code.
It can be used to interactively evaluate BQN code in buffer or can be used to
launch BQN REPL sessions.  For evaluating BQN code or spawning interpreters an
executable implementation is required such as @code{cbqn} or @code{dbqn}.")
    (home-page "https://github.com/museoa/bqn-mode/")
    (license license:gpl3)))

(define-public emacs-cfrs
  (package
    (name "emacs-cfrs")
    (version "1.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Alexander-Miller/cfrs")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1bnfchv62zk9rapmiff6jcip9w6pp1x48l8qp26z9yb8clnvlz24"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-posframe emacs-s))
    (home-page "https://github.com/Alexander-Miller/cfrs")
    (synopsis "Child Frame Read String")
    (description
     "CFRS is a simple alternative to @code{read-string} that allows reading
input via a small child-frame spawned at the position of the cursor.")
    (license license:gpl3+)))

(define-public emacs-arei
  (package
    (name "emacs-arei")
    (version "0.9.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~abcdw/emacs-arei")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1m8ic5pcshz2y2maxvbgg70n4k2kgxvj98zisqal15j7djz0hzji"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs (list emacs-eros emacs-sesman emacs-queue))
    (home-page "https://git.sr.ht/~abcdw/emacs-arei")
    (synopsis "Asynchronous Reliable Extensible IDE")
    (description "Sleek Guile IDE for Emacs.")
    (license license:gpl3+)))

(define-public emacs-geiser
  (package
    (name "emacs-geiser")
    (version "0.32")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/emacs-geiser/geiser")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "09dqwxa2h471xcyk5zncxzaz19gf8d5r83yhi425blf2r1ir7b34"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f                      ;no tests
      #:lisp-directory "elisp"
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'make-info
            (lambda _
              (invoke "makeinfo" "--no-split"
                      "-o" "geiser.info" "../doc/geiser.texi"))))))
    (native-inputs
     (list texinfo))
    (home-page "https://www.nongnu.org/geiser/")
    (synopsis "Collection of Emacs modes for Scheme hacking")
    (description
     "Geiser is a collection of Emacs major and minor modes that conspire with
one or more Scheme implementations to keep the Lisp Machine Spirit alive.  The
continuously running Scheme interpreter takes the center of the stage in
Geiser.  A bundle of Elisp shims orchestrates the dialog between the Scheme
implementation, Emacs and, ultimately, the schemer, giving them access to live
metadata.

This package provides just the core of Geiser.  To effectively use it with your
favourite Scheme implementation, you also need the corresponding geiser package,
e.g. emacs-geiser-guile for Guile.")
    (license license:bsd-3)))

(define-public emacs-gptel
  (package
    (name "emacs-gptel")
    (version "0.9.9.3")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/karthink/gptel")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "080dk0101imvfkxcqlqhy8wf1wc8p2vqyp3cwdi48wn44y1csqy9"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "make" "-C" "test" "test")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'unpack-tests
            (lambda _
              (copy-recursively
               #$(this-package-native-input "emacs-gptel-test-files")
               "test")
              (invoke "chmod" "--recursive" "u+w" "test")))
          ;; gptel-pkg.el produces an error during the check phase.
          (add-before 'check 'rename-pkg
            (lambda _ (rename-file "gptel-pkg.el" "gptel-pkg.el_")))
          (add-after 'check 'rename-pkg-back
            (lambda _ (rename-file "gptel-pkg.el_" "gptel-pkg.el")))
          (add-after 'unpack 'use-appropriate-curl
            (lambda* (#:key inputs #:allow-other-keys)
              ;; These two alternatives error on the substitution.
              ;; (emacs-substitute-variables "gptel-openai.el"
              ;;   ("gptel-use-curl"
              ;;    (search-input-file inputs "/bin/curl")))
              ;; (emacs-substitute-sexps "gptel-openai.el"
              ;;   ("(defvar gptel-use-curl"
              ;;    (search-input-file inputs "/bin/curl")))
              (substitute* "gptel-openai.el"
                (("defvar gptel-use-curl")
                 (format #f "defvar gptel-use-curl \"~a\""
                         (search-input-file inputs "/bin/curl")))))))))
    (inputs (list curl))
    (propagated-inputs (list emacs-compat emacs-transient))
    (native-inputs
     (list
      (origin
        (method git-fetch)
        (uri (git-reference
               (url "https://github.com/karthink/gptel-test")
               (commit "5f5275c32ed240a03f38d9edef26d920d4535a41")))
        (file-name "emacs-gptel-test-files")
        (sha256
         (base32
          "0sd1y1m5abfqcm5v9x86xmnnx8ab82bfd0m3cgq9ycszxdf7gf3v")))))
    (home-page "https://github.com/karthink/gptel")
    (synopsis "GPTel is a simple ChatGPT client for Emacs")
    (description
     "GPTel is a simple ChatGPT asynchronous client for Emacs with no external
dependencies.  It can interact with ChatGPT from any Emacs buffer with ChatGPT
responses encoded in Markdown or Org markup.  It supports conversations, not
just one-off queries and multiple independent sessions.  It requires an OpenAI
API key.")
    (license license:gpl3+)))

(define-public emacs-gptel-prompts
  ;; No releases.
  (let ((commit "f1c29208c1f0b62918ac6682038da5db4184fc51")
        (revision "2"))
    (package
      (name "emacs-gptel-prompts")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (uri (git-reference
                (url "https://github.com/jwiegley/gptel-prompts/")
                (commit commit)))
         (method git-fetch)
         (sha256
          (base32 "1bw98biq7m1xigjmgm3w7dzac99vww619d0n24rq15kcrra7sg84"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ;no tests
      (propagated-inputs (list emacs-gptel))
      (home-page "https://github.com/jwiegley/gptel-prompts/")
      (synopsis "Alternative Gptel directives management")
      (description
       "This package offers an advanced way to manage Gptel directives, using
files rather than customizing the variable directly.")
      (license license:gpl2+))))

(define-public emacs-gptel-quick
  (let ((commit "495b5e0b5348dbced1448bd12cbf8847e30b5175")
        (revision "2"))
    (package
      (name "emacs-gptel-quick")
      (version (git-version "0.0.5" revision commit))
      (source
       (origin
         (uri (git-reference
               (url "https://github.com/karthink/gptel-quick")
               (commit commit)))
         (method git-fetch)
         (sha256
          (base32 "1k4n0qmaw4cbybw502wnn1mv2pr9giaickq830ly6bxrc5wz7jn4"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-gptel))
      (home-page "https://github.com/karthink/gptel-quick")
      (synopsis "Quick LLM lookups in Emacs")
      (description
       "This package provides a tiny everyday helper for easily looking up or
summarizing text using an LLM.")
      (license license:gpl3+))))

(define-public emacs-chatgpt-shell
  (package
    (name "emacs-chatgpt-shell")
    (version "2.30.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/xenodium/chatgpt-shell")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0jyhcy27g4dpcd49a2f23smmnxjsvbdzpa71207svillrgiafg8f"))))
    (build-system emacs-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               ;; This phase prevents build phase failure.
               (add-after 'unpack 'generate-empty-config-file
                 (lambda _
                   (setenv "HOME" (getcwd))
                   (mkdir-p ".emacs.d")
                   (call-with-output-file ".emacs.d/.chatgpt-shell.el"
                     (lambda (port)
                       (display "nil" port))))))
           #:test-command #~(list "emacs" "-Q" "--batch"
                                  "-l" "test_chatgpt-shell.el"
                                  "-l" "chatgpt-shell.el"
                                  "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs (list emacs-shell-maker))
    (home-page "https://github.com/xenodium/chatgpt-shell")
    (synopsis "Multi-llm Emacs shell")
    (description
     "@code{Chatgpt-shell} is a comint-based LLM shell for Emacs, with support
for multiple backends.")
    (license license:gpl3+)))

(define-public emacs-dall-e-shell
  (let ((commit "428125f9fa8578703a9ca85d173b2cc9a3eb16b9"))
    (package
      (name "emacs-dall-e-shell")
      (version "0.43.3")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/xenodium/dall-e-shell/")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0mhaa7b2ghyjkca3377a9129zfjxyg0m1inqlvqmsj812bvn90q8"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))      ;no tests
      (propagated-inputs (list emacs-shell-maker))
      (home-page "https://github.com/xenodium/dall-e-shell/")
      (synopsis "Emacs shell for Dall-e")
      (description
       "Dall-e Shell is a comint-based Dall-e shell for Emacs.")
      (license license:gpl3+))))

(define-public emacs-geiser-guile
  (package
    (name "emacs-geiser-guile")
    (version "0.28.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/emacs-geiser/guile")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0i6drqz7cnx97bs5kprvb0hsg2h4bwkfdi61ajv43dqgb368jbff"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons "^src/" %default-include)
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'make-info
            (lambda _
              (invoke "makeinfo" "--no-split" "geiser-guile.texi")))
          (add-after 'unpack 'patch-geiser-guile-binary
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "geiser-guile.el"
                (("\\(t \"guile\")")
                 (format #f "(t ~s)"
                         (search-input-file inputs "bin/guile"))))))
          (add-after 'make-autoloads 'patch-autoloads
            (lambda _
              (substitute* "geiser-guile-autoloads.el"
                ;; Activating implementations fails when Geiser is not yet
                ;; loaded, so let's defer that until it is.
                (("\\(geiser-activate-implementation .*\\)" all)
                 (string-append
                  "(eval-after-load 'geiser-impl '" all ")"))))))))
    (native-inputs (list texinfo))
    (inputs (list guile-3.0-latest))
    (propagated-inputs (list emacs-geiser))
    (home-page "https://www.nongnu.org/geiser/")
    (synopsis "Guile Scheme support for Geiser")
    (description
     "This package adds support for the Guile Scheme implementation to Geiser,
a generic Scheme interaction mode for the GNU Emacs editor.")
    (license license:bsd-3)))

(define-public emacs-ac-geiser
  (let ((commit "93818c936ee7e2f1ba1b315578bde363a7d43d05")
        (revision "0"))
    (package
      (name "emacs-ac-geiser")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (uri (git-reference
               (url "https://github.com/xiaohanyu/ac-geiser")
               (commit commit)))
         (method git-fetch)
         (sha256
          (base32 "00n2qa26yilaj837n1yp6lbqa4gf30nkkbvanl7m9ih7k48ssqmw"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-geiser emacs-auto-complete))
      (synopsis "Auto-complete backend for geiser")
      (description
       "This package provides an auto-complete source for Scheme projects
using geiser.")
      (license license:bsd-3)
      (home-page "https://github.com/xiaohanyu/ac-geiser"))))

(define-public emacs-geiser-gauche
  ;; The latest 0.14 release has an unbound variable (geiser-scheme-dir).
  (let ((commit "96fa06aaeef18cc1b3b519e83dbb7be09eeb0d07")
        (revision "0"))
    (package
      (name "emacs-geiser-gauche")
      (version (git-version "0.14" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/emacs-geiser/gauche.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1ppracwfl1snq0ifdlyxpdlv7fbn3pbxm1hd1ihgqivii5nbya9r"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:include '(cons "^geiser-gauche\\.scm$" %default-include)
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-geiser-gauche-binary
              (lambda* (#:key inputs #:allow-other-keys)
                (emacs-substitute-sexps "geiser-gauche.el"
                  ("geiser-custom--defcustom geiser-gauche-binary"
                   (search-input-file inputs "bin/gosh")))))
            (add-after 'make-autoloads 'patch-autoloads
              (lambda _
                (substitute* "geiser-gauche-autoloads.el"
                  ;; Activating implementations fails when Geiser is not yet
                  ;; loaded, so let's defer that until it is.
                  (("\\(geiser-activate-implementation .*\\)" all)
                   (string-append
                    "(eval-after-load 'geiser-impl '" all ")"))
                  (("\\(geiser-implementation-extension .*\\)" all)
                   (string-append
                    "(eval-after-load 'geiser-impl '" all ")"))))))))
      (inputs (list gauche))
      (propagated-inputs (list emacs-geiser))
      (home-page "https://gitlab.com/emacs-geiser/gauche")
      (synopsis "Gauche Scheme support for Geiser")
      (description
       "This package adds support for the Gauche Scheme implementation to Geiser,
a generic Scheme interaction mode for the GNU Emacs editor.")
      (license license:expat))))

(define-public emacs-geiser-racket
  (package
    (name "emacs-geiser-racket")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/emacs-geiser/racket")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "04gwd9qa0785zfr6m9a5443ilgvyz05l06cb1waicf83sgp8xl32"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons "^src/" %default-include)
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-geiser-racket-binary
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "geiser-racket.el"
                (("\\(t \"racket\")")
                 (format #f "(t ~s)"
                         (search-input-file inputs "bin/racket"))))))
          (add-after 'make-autoloads 'patch-autoloads
            (lambda _
              (substitute* "geiser-racket-autoloads.el"
                ;; Activating implementations fails when Geiser is not yet
                ;; loaded, so let's defer that until it is.
                (("\\(geiser-activate-implementation .*\\)" all)
                 (string-append
                  "(eval-after-load 'geiser-impl '" all ")"))
                (("\\(geiser-implementation-extension .*\\)" all)
                 (string-append
                  "(eval-after-load 'geiser-impl '" all ")"))))))))
    (inputs (list racket))
    (propagated-inputs (list emacs-geiser))
    (home-page "https://www.nongnu.org/geiser/")
    (synopsis "Racket support for Geiser")
    (description
     "This package adds support for the Racket implementation to Geiser,
a generic Scheme interaction mode for the GNU Emacs editor.")
    (license license:bsd-3)))

(define-public emacs-geiser-chez
  (package
    (name "emacs-geiser-chez")
    (version "0.18")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/emacs-geiser/chez")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "19yv5brhzf10hsazmm8s1b058d434hv60a52s08m3kxyrkwr5sca"))))
    (build-system emacs-build-system)
    (arguments
     '(#:include (cons "^src/" %default-include)
       #:phases
       (modify-phases %standard-phases
         (add-after 'make-autoloads 'patch-autoloads
           (lambda* (#:key outputs #:allow-other-keys)
             (substitute* "geiser-chez-autoloads.el"
               ;; Activating implementations fails when Geiser is not yet
               ;; loaded, so let's defer that until it is.
               ;; See <https://gitlab.com/emacs-geiser/chez/-/issues/7>.
               (("\\(geiser-activate-implementation .*\\)" all)
                (string-append
                 "(eval-after-load 'geiser-impl '" all ")"))
               (("\\(geiser-implementation-extension .*\\)" all)
                (string-append
                 "(eval-after-load 'geiser-impl '" all ")"))))))))
    (inputs
     (list chez-scheme))
    (propagated-inputs
     (list emacs-geiser))
    (home-page "https://nongnu.org/geiser/")
    (synopsis "Support for Chez Scheme in Geiser")
    (description
     "This package adds support for using Chez Scheme in Emacs with Geiser.")
    (license license:bsd-3)))

(define-public emacs-syncthing
  (package
    (name "emacs-syncthing")
    (version "3.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/KeyWeeUsr/emacs-syncthing.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1zbdv6gaklxi86f3ni5bhl8pnsx1jyi9zmb7rxkgjw46wdyi3c2d"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/KeyWeeUsr/emacs-syncthing")
    (synopsis "Emacs client for Syncthing")
    (description
     "Emacs-Syncthing is a client for the Syncthing file synchronization tool
which provides an Emacs interface to replace the built-in web UI.")
    (license license:gpl3+)))

(define-public emacs-vc-hgcmd
  (package
    (name "emacs-vc-hgcmd")
    (version "1.14.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/muffinmad/emacs-vc-hgcmd")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nlaicza4ds325827ks5gb7zn0nc536k2chq8jwbq34ybvxi93wj"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/muffinmad/emacs-vc-hgcmd")
    (synopsis "Version control (VC) backend for the Mercurial command server")
    (description
     "This package provides an Emacs VC backend to work with Mercurial
repositories through the
@uref{https://www.mercurial-scm.org/wiki/CommandServer,Mercurial command
server}.  The main advantage compared to @code{vc-hg} is speed.")
    (license license:gpl3+)))

(define-public emacs-telephone-line
  (package
    (name "emacs-telephone-line")
    (version "0.6")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/dbordak/telephone-line")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1pv6hlzks02bvxkfyg8m04l36clg39h5w7nq2k6ppi5bh4d4kmc8"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/dbordak/telephone-line")
    (synopsis "Implementation of Powerline for Emacs")
    (description
     "Telephone Line is a new implementation of Powerline for Emacs with
optional baked-in Evil support, antialiased separators, and an easy
configuration language which makes it trivial to write your own themes.")
    (license license:gpl3+)))

(define-public emacs-i-ching
  (package
    (name "emacs-i-ching")
    (version "20241113.1642")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://codeberg.org/zzkt/i-ching.git")
              (commit
               "e4339cb64a97e0d04a4cb8e7183aeec4e4ae6a29")))
       (sha256
        (base32
         "08827zq4jni4bxlmjq24nbj6k2q07ks6mb47xfs2bp8hjqb0m07f"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-request))
    (home-page "https://codeberg.org/zzkt/i-ching")
    (synopsis "The Book of Changes")
    (description
     "Cast hexagrams and consult the I Ching, or 'Book of Changes' from the
comfort of Emacs.  The I Ching can be used as a divination method, pattern
generator or fixed point for millennia of commentary & exegesis.  This package
provides methods for casting and describing hexagrams, querying the oracle,
and finding patterns in randomness.  The descriptions of hexagrams and their
classification have been drawn from public domain sources, tradition and
antiquity.")
    (license license:gpl3+)))

(define-public emacs-inspector
  (let ((commit "0c02fd712ff89006227838e18a4685678abd9ba8")
        (revision "1"))
    (package
      (name "emacs-inspector")
      (version (git-version "0.38" revision commit))
      (source
       (origin
         (uri (git-reference
               (url "https://github.com/mmontone/emacs-inspector")
               (commit commit)))
         (method git-fetch)
         (sha256
          (base32 "0fidzh8zwaxvkxdzj01rznixaqs00kl3w5xi1qylcjl5jvl6vrmg"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "emacs" "-Q" "--batch"
                               "-l" "inspector.el"
                               "-l" "inspector-tests.el"
                               "-f" "ert-run-tests-batch-and-exit")))
      (home-page "https://github.com/mmontone/emacs-inspector")
      (synopsis "Inspection tool for Emacs Lisp objects")
      (description
       "This package provides an introspection tool similar to those found in
Common Lisp or Smalltalk, but for Emacs Lisp.")
      (license license:gpl3+))))

(define-public emacs-inspirehep
  ;; No tags or releases.
  (let ((commit "9675ef63833d3f876e2f1dd8f7a8d91eef420aab")
        (revision "0"))
    (package
      (name "emacs-inspirehep")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
            (url "https://codeberg.org/rahguzar/inspirehep.el/")
            (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1rjclz658vca3mlwhil9kz4ffk382l1csrh7wr8ch63babmc7kzy"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ;no tests
      (propagated-inputs
       (list emacs-map emacs-pdf-tools emacs-companion-mode))
      (home-page "https://codeberg.org/rahguzar/inspirehep.el/")
      (synopsis "Search literature references for high energy physics")
      (description
       "This package provides an Emacs interface to the online service
@uref{https://inspirehep.net/, Inspirehep}")
      (license license:gpl3+))))

(define-public emacs-treebundel
  (package
    (name "emacs-treebundel")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purplg/treebundel")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0fpmm3jb95lksamxqz9850x2vcmcvq6bx29sn0fci6ny4cvpnq5k"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-compat))
    (home-page "https://github.com/purplg/treebundel")
    (synopsis "Bundle related git-worktrees together")
    (description
     "This package is used for bundling related git-worktrees from multiple
repositories together.  This helps switch quickly between repositories and
ensure you're on the correct branch.  When you're done with your changes, you
can use the repositories in the workspace and know which ones were modified to
simplify the process of getting the changes merged in together.  Additionally,
git metadata is shared between all projects.  You can stash, pop, and pull
changes in from the same repository in other workspaces thanks to the power of
git-worktrees.")
    (license license:expat)))

(define-public emacs-tree-inspector
  (let ((commit "bbb8d2dfe84fbf857fcc1579de5a1324b09a877e"))
    (package
      (name "emacs-tree-inspector")
      (version "0.4")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/mmontone/emacs-tree-inspector")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "01ad4r97hfr9nndbifyggscb5108y7h2qm95jsmh5b9qgzqm39nx"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "emacs" "-Q" "--batch"
                               "-L" "."
                               "-l" "tree-inspector-tests.el"
                               "-f" "ert-run-tests-batch-and-exit")
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'fix-library-loading
              ;; The library calls `hash-table-keys', which is not
              ;; auto-loaded.  Explicitly require `subr-x', where it is
              ;; defined.
              (lambda _
                (substitute* "tree-inspector.el"
                  (("\\(require 'cl-lib\\)" line)
                   (string-append line "(require 'subr-x)"))))))))
      (propagated-inputs (list emacs-treeview))
      (home-page "https://github.com/mmontone/emacs-tree-inspector")
      (synopsis "Inspection tool for Emacs Lisp objects that uses a tree view")
      (description
       "Tree Inspector is an inspection tool for Emacs Lisp objects that uses
a tree view.  It works together with Emacs Inspector when it is loaded; when
an object label is clicked on the tree, an inspector is opened on that
object.")
      (license license:gpl3+))))

(define-public emacs-terminal-here
  (package
    (name "emacs-terminal-here")
    (version "2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/davidshepherd7/terminal-here")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1iv1c2mbvhn00ha46c6f98j9syc71xhjpk8m5wa5p32sk4wcc9f4"))))
    (build-system emacs-build-system)
    (native-inputs (list emacs-el-mock emacs-ert-runner emacs-validate))
    (home-page "https://github.com/davidshepherd7/terminal-here")
    (synopsis "Open external terminals from Emacs")
    (description
     "This package provides commands to open external terminal emulators from
Emacs, whose initial working directories are determined in relation to the
current buffer.")
    (license license:gpl3+)))

(define-public emacs-treeview
  (package
    (name "emacs-treeview")
    (version "1.3.0")
    (source
     (origin
       (uri (git-reference
             (url "https://github.com/tilmanrassy/emacs-treeview")
             (commit (string-append "v" version))))
       (method git-fetch)
       (sha256
        (base32 "0blggaqzz7rwycpp6v0n0fig1d9prdp63w25cprnq59ymczr7w85"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tilmanrassy/emacs-treeview/")
    (synopsis "Emacs Lisp framework for tree navigation")
    (description
     "This package provides an abstract Emacs Lisp framework for tree
navigation.")
    (license license:gpl3+)))

(define-public emacs-hide-lines
  (package
    (name "emacs-hide-lines")
    (version "20210513.1636")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/vapniks/hide-lines.git")
                    (commit "f0828c15e50db5eddb905de783e7683b04d1eca3")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1pw0wp1pzy6snycvz12nj0q7jxxj07h3lqas184w44nhrira7qhj"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/vapniks/hide-lines")
    (synopsis "Commands for hiding lines based on a regexp")
    (description
     "This package provides commands to hide lines based on a regular
expression.")
    (license license:gpl3+)))

(define-public emacs-hgignore-mode
  ;; From 2021-03-14.
  ;; No releases available.
  (let ((commit "2c5aa4c238848f5b4f2955afcfb5f21ea513653b")
        (revision "0"))
    (package
      (name "emacs-hgignore-mode")
      ;; `Version:' header says 0.1.20150329
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/omajid/hgignore-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0jn9rzhrmmv4lf7rdapdjclk6623d1mir2lq3c46428skhzjlph7"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/omajid/hgignore-mode")
      (synopsis "Major mode for editing @file{hgignore} files")
      (description "This package provides a basic major mode for
editing @file{.hgignore} files used by the Mercurial version control
system.")
      (license license:gpl3+))))

(define-public emacs-hsluv
  (package
    (name "emacs-hsluv")
    (version "20181127.1206")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/hsluv/hsluv-emacs.git")
                    (commit "c3bc5228e30d66e7dee9ff1a0694c2b976862fc0")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "19q8qlq4s2kfydpadkq1zd92611dvq7dr8vlhlbd9gplzpx7dhfd"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "make" "test")))
    (home-page "https://github.com/hsluv/hsluv-emacs")
    (synopsis "HSLuv color space conversions")
    (description
     "This package provides an elisp implementation of the HSLUV colorspace
conversions documented on @url{http://www.hsluv.org/}.  HSLuv is a
human-friendly alternative to HSL.  CIELUV is a color space designed for
perceptual uniformity based on human experiments.  When accessed by polar
coordinates, it becomes functionally similar to HSL with a single problem: its
chroma component doesn't fit into a specific range.  HSLuv extends CIELUV with
a new saturation component that allows you to span all the available chroma as
a neat percentage.")
    (license license:expat)))

(define-public emacs-platformio-mode
  (package
    (name "emacs-platformio-mode")
    (version "0.3.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ZachMassia/PlatformIO-Mode")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0ian50v9vaz7kqzn20bhqadq50h0l3zhjkmniinpz4q9klh7drh9"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-async emacs-projectile))
    (home-page "https://github.com/zachmassia/platformio-mode")
    (synopsis "Minor mode for building and uploading PlatformIO projects")
    (description "This package provides an Emacs minor mode for building and
uploading PlatformIO projects.")
    (license license:gpl3+)))

(define-public emacs-hyperbole
  (package
    (name "emacs-hyperbole")
    (version "9.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "hyperbole-" version ".tar"))
       (sha256
        (base32 "0a7py2dvszh0rf2smbmm8msjrc8vbbvlqnsqw0m2l12v8vllmxnb"))))
    (build-system emacs-build-system)
    (arguments
     (list #:include #~(cons* "DEMO"
                              "DEMO-ROLO.otl"
                              "HY-ABOUT"
                              "HY-NEWS"
                              "man/hkey-help.txt"
                              "man/hyberbole.info"
                              "kotl/.*"
                              "\\.kotl$"
                              %default-include)
           ;; XXX: tests want to download requirements very badly
           #:tests? #f
           #:phases
           #~(modify-phases %standard-phases
               ;; Fix build issues about missing "domainname" and
               ;; "hpmap:dir-user" parent dir, and missing require in
               ;; "hgnus.el" (void-function: var-append).
               (add-after 'unpack 'fix-build
                 (lambda* (#:key inputs #:allow-other-keys)
                   (substitute* "hypb.el"
                     (("/bin/domainname")
                      (search-input-file inputs "bin/dnsdomainname")))
                   (substitute* "hyperbole.el"
                     (("\\(hyperb:check-dir-user\\)") ""))
                   (substitute* "hgnus.el"
                     (("hmail ") "hmail hvar "))))
               (add-after 'install 'install-doc
                 (lambda _
                   (install-file "man/hyperbole.info"
                                 (string-append #$output "/share/info"))
                   (install-file "man/hkey-help.txt"
                                 (string-append #$output "/share/doc/"
                                                #$name "-" #$version))))
               (add-after 'install 'install-images
                 (lambda _
                   (let ((dir (string-append #$output "/share/info/im")))
                     (for-each (lambda (file)
                                 (install-file file dir))
                               (find-files "man/im" "\\.png$"))))))))
    (inputs
     (list inetutils))
    (home-page "https://www.gnu.org/software/hyperbole/")
    (synopsis "The Everyday Hypertextual Information Manager")
    (description
     "GNU Hyperbole, or just Hyperbole, is a programmable hypertextual
information management system.  It offers rapid views and interlinking of all
kinds of textual information, utilizing Emacs for editing.  In particular,
Hyperbole lets you quickly create and activate hyperlink buttons, build
outlines, manage all your contacts, your windows and frames, and search across
buffers, directory trees, or the web.")
    (license license:gpl3+)))

(define-public emacs-vline
  (let ((commit "f5d7b5743dceca75b81c8c95287cd5b0341debf9")
        (revision "0"))
    (package
      (name "emacs-vline")
      (version (git-version "1.11" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/buzztaiki/vline")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "06qqpjaxsacslxb3f2bm790lwygbq6387n9ccn4v9vz9xlyn9dmi"))))
      (build-system emacs-build-system)
      (arguments
       ;; No tests
       (list #:tests? #f))
      (home-page "https://github.com/buzztaiki/vline")
      (synopsis "Column highlighting (vertical line displaying) mode")
      (description
       "@code{vline-mode} is a minor mode for highlighting column at cursor
position.  It enhances text editing by visually indicating the vertical
line.")
      (license license:gpl2+))))

(define-public emacs-xhair
  (let ((commit "c7bd7c501c3545aa99dadac386c882fe7c5edd9c")
        (revision "0"))
    (package
      (name "emacs-xhair")
      ;; No tag, version comes from source code
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Boruch-Baum/emacs-xhair")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "03m15lbspk73x59wvb77wgvnkrmrlq4w6kmnrr2i69jgafqh0421"))))
      (build-system emacs-build-system)
      (arguments
       ;; No tests
       (list #:tests? #f))
      (propagated-inputs (list emacs-vline))
      (home-page "https://github.com/Boruch-Baum/emacs-xhair")
      (synopsis "Highlight the current line and column")
      (description
       "This package simultaneously applies @code{vline-mode} and
@code{hl-line-mode}, with tweaks, to present @code{point} in highlighted
cross-hairs, reporting the value of @code{point} as a message in the echo
area.")
      (license license:gpl3+))))

(define-public emacs-vlf
  (package
    (name "emacs-vlf")
    (version "1.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "vlf-" version ".tar"))
       (sha256
        (base32 "0hpri19z6b7dqmrj5ckp8sf0m0l72lkgahqzvfmwhgpgv2p81bny"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/m00natic/vlfi/")
    (synopsis "View large files in Emacs")
    (description
"Vlf is an Emacs minor mode that allows viewing, editing, searching and
comparing large files in batches.")
    (license license:gpl2+)))

(define-public emacs-hg-histedit
  ;; From 2021-03-02.
  ;; No releases available.
  (let ((commit "a05149483b9c5f7848ece0ba6028c900595a6a25")
        (revision "0"))
    (package
      (name "emacs-hg-histedit")
      (version (git-version "0.0.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jojojames/hg-histedit")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "04zps0d4s99f5a8ahrpyf8b6qw0c1y7rd1bsaq9nc6m4qblsvwc8"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-with-editor))
      (home-page "https://github.com/jojojames/hg-histedit")
      (synopsis "Emacs interface to @command{hg histedit}")
      (description "This package provides an Emacs interface to
@command{hg histedit} for editing the commit history.")
      (license license:gpl3+))))

(define-public emacs-package-build
  (package
    (name "emacs-package-build")
    (version "4.0.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/melpa/package-build")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "165gbrc1h1yj764kn3qq2y1551y04lqnklfa0k87gqgd38q5v985"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f))  ; No tests.
    (home-page "https://github.com/melpa/package-build")
    (synopsis "Tools for assembling an Emacs package archive")
    (description "This package provides tools for assembling an @acronym{ELPA,
Emacs package archive}.")
    (license license:gpl3+)))

(define-public emacs-paredit
  (package
    (name "emacs-paredit")
    (version "26")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://paredit.org/paredit")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1hwl2jhv1fhsdrspfhprq77n763i4zsj350q024ajy0m2kaql6ws"))))
    (build-system emacs-build-system)
    (home-page "https://paredit.org/")
    (synopsis "Emacs minor mode for editing parentheses")
    (description
     "ParEdit (paredit.el) is a minor mode for performing structured editing
of S-expression data.  The typical example of this would be Lisp or Scheme
source code.

ParEdit helps keep parentheses balanced and adds many keys for moving
S-expressions and moving around in S-expressions.  Its behavior can be jarring
for those who may want transient periods of unbalanced parentheses, such as
when typing parentheses directly or commenting out code line by line.")
    (license license:gpl3+)))

(define-public emacs-puni
  ;; No tagged release upstream
  (let ((commit "f430f5b0a14c608176e3376058eb380ab0824621")
        (revision "3"))
    (package
      (name "emacs-puni")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/AmaiKinono/puni")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0kvxll2yx4lh5x04cigdizncp2kbva1iidz9fjnbi8qqfm6pq5qq"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ; no actual tests
      (propagated-inputs (list emacs-with-editor))
      (home-page "https://github.com/AmaiKinono/puni")
      (synopsis "Emacs minor mode for structured editing")
      (description
       "Puni is an Emacs minor mode for structured editing: soft deletion,
expression navigating and manipulating.  It supports many major modes
out of the box.")
      (license license:gpl3+))))

(define-public emacs-pug-mode
  (package
    (name "emacs-pug-mode")
    (version "1.0.8")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/hlissner/emacs-pug-mode")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1f6bhdr1a72x94dlz2i1fwwln8crc2mbpc2iq23hvsbsfmj7xfzp"))))
    (native-inputs (list emacs-ert-runner))
    (build-system emacs-build-system)
    (home-page "https://github.com/hlissner/emacs-pug-mode")
    (synopsis "Pug support for Emacs")
    (description "Pug mode offers Emacs support for Pug.  Unlike Jade mode, it
is based off of Slim mode.")
    (license license:gpl3+)))

(define-public emacs-show-font
  (package
    (name "emacs-show-font")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/protesilaos/show-font")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "03l92jacamd6vda51r9cw60bdyrv4ag8bk6qi6jpps6ljss5g6pl"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (native-inputs
     (list texinfo))
    (home-page "https://github.com/protesilaos/show-font")
    (synopsis "Show font features in a buffer")
    (description
     "Show Font lets you preview a font inside of Emacs.  It does so in three
ways: prompt for a font on the system and display it in a buffer, list all
known fonts in a buffer with a short preview for each, and provide a major
mode to preview a font whose file is among the installed ones.")
    (license license:gpl3+)))

(define-public emacs-sed-mode
  (package
    (name "emacs-sed-mode")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/sed-mode-" version
                           ".tar"))
       (sha256
        (base32 "0zhga0xsffdcinh10di046n6wbx35gi1zknnqzgm9wvnm2iqxlyn"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/sed-mode.html")
    (synopsis "Major mode to edit sed scripts")
    (description
     "The Sed major mode provides basic support for sed scripts.  The
functionalities supported are font-locking and auto-indentation.")
    (license license:gpl3+)))

(define-public emacs-spaceline-all-the-icons
  (package
    (name "emacs-spaceline-all-the-icons")
    (version "1.4.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/domtronn/spaceline-all-the-icons.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "186v71d8n1iy73drayyf57pyzlz973q74mazkyvb8w3fj8bb3llm"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-all-the-icons
           emacs-memoize
           emacs-spaceline))
    (home-page "https://github.com/domtronn/spaceline-all-the-icons.el")
    (synopsis
     "Theme for @code{emacs-spaceline} using @code{emacs-all-the-icons}")
    (description
     "This package is a theme for @code{emacs-spaceline} that recreates most
of the segments available in that package using icons from
@code{emacs-all-the-icons}.  Icon fonts allow for more tailored and detailed
information in the mode line.")
    (license license:expat)))

(define-public emacs-snow
  (let ((commit "be17977677fa29709a726715a1a1cba1bd299f68")
        (revision "1"))
     (package
      (name "emacs-snow")
      (version (git-version "0" revision commit))
       (source
        (origin
          (method git-fetch)
          (uri (git-reference
               (url "https://github.com/alphapapa/snow.el")
                (commit commit)))
          (file-name (git-file-name name version))
          (sha256
          (base32 "0fh1hmwpszm9frvnqr2b8rlfx33dy9jm5r82hldgxdbhlv8dq4d0"))))
       (build-system emacs-build-system)
      (home-page "https://github.com/alphapapa/snow.el/")
      (synopsis "Let it snow in Emacs")
      (description "This package adds a command @code{snow} that displays
a buffer in which it snows.  The storm varies in intensity, a gentle breeze
blows at times, and snow accumulates on the terrain in the scene.")
      (license license:gpl3+))))

(define-public emacs-spongebob
  (let ((commit "ae8ae6ba0dc57b7357ba87ff0609d27c4a0a5f51")
        (revision "0"))
     (package
      (name "emacs-spongebob")
      (version (git-version "0" revision commit))
       (source
        (origin
          (method git-fetch)
          (uri (git-reference
               (url "https://gitlab.com/dustyweb/spongebob.el")
                (commit commit)))
          (file-name (git-file-name name version))
          (sha256
          (base32 "1agqpp078ij2irn0kb8bgqk0nd47fi20yfd9szn8kbqypfqalvgc"))))
       (build-system emacs-build-system)
      (home-page "https://gitlab.com/dustyweb/gauche")
      (synopsis "Memetically mock a region of text")
      (description "This package transforms text using @code{studlify-region}
and inserts a SpongeBob SquarePants ASCII art figure in the current
buffer.")
      (license license:gpl3+))))

(define-public emacs-prism
  (let ((commit "6046a5cf793f65ff86fe0392e0edf29ffcd57567")) ;version bump
    (package
      (name "emacs-prism")
      (version "0.3.5")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/alphapapa/prism.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1p4vqyc4jm0pg4999i0k04pl0sa9nhrczxf4bng4id1r19sxm6dh"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-compat emacs-dash))
      (home-page "https://github.com/alphapapa/prism.el")
      (synopsis
       "Disperses bracket-bounded syntax into a spectrum of color by depth")
      (description
       "Prism is a Rainbow Blocks-like mode for Emacs.  It preserves non-color
face properties and allows configuration of faces and colors.")
      (license license:gpl3+))))

(define-public emacs-project
  (package
    (name "emacs-project")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/project-" version ".tar"))
       (sha256
        (base32 "1973d6z7nx9pp5gadqk8p71v6s5wqja40a0f8zjrn6rrnfarrcd0"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-xref))
    (home-page "https://elpa.gnu.org/packages/project.html")
    (synopsis "Operations on the current project")
    (description
     "This library contains generic infrastructure for dealing with projects,
some utility functions, and commands using that infrastructure.")
    (license license:gpl3+)))

(define-public emacs-flymake
  (package
    (name "emacs-flymake")
    (version "1.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "flymake-" version ".tar"))
       (sha256
        (base32 "0jg0lbj861smycmya626b54hy9lh4xfqpjwzf28i2vnf9wy6q840"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-eldoc emacs-project))
    (home-page "https://elpa.gnu.org/packages/flymake.html")
    (synopsis "Universal on-the-fly syntax checker")
    (description
     "Flymake collects diagnostic information for multiple sources,
called backends, and visually annotates the relevant portions in the buffer.")
    (license license:gpl3+)))

;; Package has no release.  Version is extracted from "Version:" keyword in
;; main file.
(define-public emacs-project-mode-line-tag
  (let ((commit "a8809cc1a50cfdedaf7bed2810249ae262884716")
        (revision "0"))
    (package
      (name "emacs-project-mode-line-tag")
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url
                       "https://github.com/fritzgrabo/project-mode-line-tag")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0bmx9a1g199axj9ypqisvfyf1517czw23zg96x1wdzqrpw3cb7cx"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/fritzgrabo/project-mode-line-tag")
      (synopsis "Display a buffer's project in its mode line")
      (description
       "Display information about a buffer's project (a \"project tag\") in
its mode line.")
      (license license:gpl3+))))

(define-public emacs-project-tab-groups
  (let ((commit "2658405d5f3c539fbd9ccf95297a016a2c91816a")
        (revision "1"))
    (package
      (name "emacs-project-tab-groups")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fritzgrabo/project-tab-groups.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1zg9kxyjz942ib9lii0in67hwqil2xlz78vjm1qqypw3zaivhh7p"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/fritzgrabo/project-tab-groups")
      (synopsis "Support a \"one tab group per project\" workflow")
      (description "This package provides a global minor mode that enhances the
Emacs built-in @code{project.el} library to support keeping projects isolated
in named tab groups.  This package automates the steps you’d otherwise need to
do manually if you wanted to keep the buffers of a project neatly isolated in
separate, named tab groups.")
      (license license:gpl3+))))

(define-public emacs-dicom
  (package
    (name "emacs-dicom")
    (version "1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/minad/dicom")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1inmzamm88zzq98x5xjc97c0kk9mgdmj9jw6vklmhiady2v8jy6y"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f                       ;no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-commands
            (lambda* (#:key inputs #:allow-other-keys)
              (make-file-writable "dicom.el")
              (let ((convert (search-input-file inputs "/bin/convert"))
                    (dcm2img (search-input-file inputs "/bin/dcm2img"))
                    (dcm2xml (search-input-file inputs "/bin/dcm2xml")))
                (substitute* "dicom.el"
                  (("(^|[^`])dcm2img" _ start)
                   (string-append start dcm2img))
                  (("\"dcm2xml")
                   (string-append "\"" dcm2xml))
                  ;; Guix has ImageMagick 6.
                  (("(^|[^`])magick" _ start)
                   (string-append start convert))))))
          (add-before 'install 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (native-inputs (list texinfo))
    (inputs (list dcmtk imagemagick))
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/minad/dicom")
    (synopsis
     "@acronym{DICOM, Digital Imaging and Communications in Medicine} viewer
for Emacs")
    (description
     "This package adds the ability to view @acronym{DICOM, Digital Imaging
and Communications in Medicine} files in Emacs.")
    (license license:gpl3+)))

(define-public emacs-discourse-mode
  (package
    (name "emacs-discourse-mode")
    (version "0.2.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/glenneth/discourse-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0j2f0vclj6zrmk1hxyrrhkcpk74vqvq42g9wjqrjw827yjh2wm65"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-compat
                             emacs-markdown-mode
                             emacs-request))
    (home-page "https://codeberg.org/glenneth/discourse-mode")
    (synopsis "Emacs package for interacting with Discourse forums")
    (description "This package lets you browse categories, view topics, read
posts, and participate in discussions on Discourse, directly from Emacs.")
    (license license:gpl3+)))

(define-public emacs-disproject
  (package
    (name "emacs-disproject")
    (version "2.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/aurtzy/disproject")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "17ffcfm4qxjvnmy95yczk18mngiy13pbq7avzrhrh44p3d53b5ss"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f                       ;no tests
      #:phases #~(modify-phases %standard-phases
                   (add-before 'install 'build-info-manual
                     (lambda _
                       (invoke "make" "info"))))))
    (native-inputs (list texinfo))
    (propagated-inputs (list emacs-transient))
    (home-page "https://github.com/aurtzy/disproject")
    (synopsis "Transient interface for managing and interacting with projects")
    (description
     "Disproject is a package for GNU Emacs that implements Transient menus
for dispatching project-related commands on top of the Project library.  It
aims to provide a more capable version of the @code{project-switch-project}
command, which it is inspired by.  Those who are familiar with Projectile may
also find similarities to @code{projectile-commander}.")
    (license license:gpl3+)))

(define-public emacs-golden-ratio
  (let ((commit "375c9f287dfad68829582c1e0a67d0c18119dab9")
        (revision "0"))
    (package
      (name "emacs-golden-ratio")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/roman/golden-ratio.el")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0a635a3h6jx0clgwmhwc48i14y3xy5q29y37lp2sjnbxx1hlmkli"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))      ;no tests
      (home-page "https://github.com/roman/golden-ratio.el")
      (synopsis "Automatic resizing of Emacs windows to the golden ratio")
      (description "This package provides an Emacs mode for automatically
resizing the window that has main focus to be more convenient for editing,
while the ones that are not being actively edited will be reduced to a smaller
size.")
      (license license:expat))))

(define-public emacs-zoom
    (package
      (name "emacs-zoom")
      (version "0.3.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/cyrus-and/zoom")
                (commit (string-append "v" version))))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1zzm8kchm5wwxras4bfl46flyfj44bf7qazc5yyahx9qr2ksfnhd"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))      ;no tests
      (home-page "https://github.com/cyrus-and/zoom")
      (synopsis "Fixed and automatic balanced window layout for Emacs")
      (description
       "This minor mode takes care of managing the window sizes by
enforcing a fixed and automatic balanced layout where the currently
selected window is resized according to @code{zoom-size} which can be
an absolute value in lines/columns, a ratio between the selected window
and frame size or even a custom callback.")
      (license license:expat)))

(define-public emacs-git-modes
  (package
    (name "emacs-git-modes")
    (version "1.4.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magit/git-modes")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0pjsxw5ni47c8mfd40l9x5fnpi1423djhxxr2ixvk81p7xcrcsyi"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs
     (list emacs-compat))
    (home-page "https://github.com/magit/git-modes")
    (synopsis "Emacs major modes for Git configuration files")
    (description
     "This package provides Emacs major modes for editing various Git
configuration files, such as @file{.gitattributes}, @file{.gitignore}, and
@file{.git/config}.")
    (license license:gpl3+)))

(define-deprecated/public-alias git-modes emacs-git-modes)

(define-public emacs-with-editor
  (package
    (name "emacs-with-editor")
    (version "3.4.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magit/with-editor")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0x4qw9yd0kzg2kkm8wjm9l0ikzb9aj9v5s753bjp3bajal94jw3q"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f                       ; no test suite
      #:lisp-directory "lisp"
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'make-info
            (lambda _
              (with-directory-excursion "../docs"
                (invoke "makeinfo" "--no-split"
                        "-o" "with-editor.info" "with-editor.texi")
                (install-file "with-editor.info" "../lisp")))))))
    (native-inputs
     (list texinfo))
    (propagated-inputs
     (list emacs-async emacs-compat))
    (home-page "https://github.com/magit/with-editor")
    (synopsis "Emacs library for using Emacsclient as EDITOR")
    (description
     "This package provides an Emacs library to use the Emacsclient as
@code{$EDITOR} of child processes, making sure they know how to call home.
For remote processes a substitute is provided, which communicates with Emacs
on stdout instead of using a socket as the Emacsclient does.")
    (license license:gpl3+)))

(define-public emacs-libgit
  (let ((commit "ab1a53a6a0120872e42582fc980e779d47de6d0e")
        (revision "1"))
    (package
      (name "emacs-libgit")
      (version (git-version "0.0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/magit/libegit2")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1fqqhc7mr9lyshqva8wqknk5kc9vr10rxdp9dkrqgwawr3lk1k5p"))
                (snippet
                 #~(begin
                     ;; bundled, use the one shipped with emacs instead
                     (delete-file "src/emacs-module.h")))))
      ;; Use the cmake-build-system as it provides support for cross builds.
      (build-system cmake-build-system)
      (arguments
       (list
        #:configure-flags #~(list "-DUSE_SYSTEM_LIBGIT2=x")
        ;; Add the emacs-build-system byte compilation and install phases.
        #:imported-modules `(,@%cmake-build-system-modules
                             (guix build emacs-build-system)
                             (guix build emacs-utils))
        #:modules '((guix build cmake-build-system)
                    ((guix build emacs-build-system) #:prefix emacs:)
                    (guix build emacs-utils)
                    (guix build utils))
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-source
              (lambda _
                ;; Use Emacs 28 unibyte strings.
                ;; XXX: This now breaks if linked against Emacs <= 26, probably
                ;; also 27.
                (substitute* "src/egit-blob.c"
                  (("make_string") "make_unibyte_string"))))
            (add-after 'unpack 'set-libgit--module-file
              (lambda _
                (emacs-substitute-variables "libgit.el"
                  ("libgit--module-file"
                   (string-append (emacs:elpa-directory #$output)
                                  "/libegit2.so")))))
            (add-after 'unpack 'skip-failing-tests
              ;; XXX: Skip 2 failing tests (out of 29).
              (lambda _
                (substitute* "test/submodule-test.el"
                  (("\\(ert-deftest (status|ids) .*" all)
                   (string-append all " (skip-unless nil)")))))
            (add-after 'unpack 'ert-number-tests
              (lambda _
                (ert-number-tests "test/repository-test.el"
                                  "repository-head-for-worktree")))
            (add-before 'install 'prepare-for-install
              (lambda _
                (let ((s "../source"))
                  (copy-file "libegit2.so" (string-append s "/libegit2.so"))
                  (chdir s))))
            (replace 'install
              (lambda* (#:key outputs #:allow-other-keys)
                (let ((install (assoc-ref emacs:%standard-phases 'install)))
                  (install #:outputs outputs
                           #:include (cons "\\.so$"
                                           emacs:%default-include)))))
            (add-after 'unpack 'emacs-add-install-to-native-load-path
              (assoc-ref emacs:%standard-phases 'add-install-to-native-load-path))
            (add-after 'unpack 'make-autoloads
              (assoc-ref emacs:%standard-phases 'make-autoloads))
            (add-after 'unpack 'patch-el-files
              (assoc-ref emacs:%standard-phases 'patch-el-files))
            (add-after 'install 'emacs-build
              (assoc-ref emacs:%standard-phases 'build))
            (add-after 'emacs-build 'validate-compiled-autoloads
              (assoc-ref emacs:%standard-phases 'validate-compiled-autoloads)))))
      (native-inputs
       (list emacs-no-x git-minimal pkg-config))
      (inputs
       (list libgit2))
      (home-page "https://github.com/magit/libegit2")
      (synopsis "Emacs bindings for libgit2")
      (description "This is an experimental module written in C providing
libgit2 bindings for Emacs, intended to boost the performance of Magit.")
      (license license:gpl2+))))

(define-public emacs-llama
  (package
    (name "emacs-llama")
    (version "1.0.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/tarsius/llama")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0qrbw3asmwbqjpqpws8swvcjcmip89hanjmfczwcqassi5qa0h85"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "emacs" "-Q" "--batch"
                                  "-l" "llama-tests.el"
                                  "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/tarsius/llama")
    (synopsis "Compact syntax for short lambda")
    (description
     "This package implements the macro @code{##}, which provides compact
syntax for short lambda.")
    (license license:gpl3+)))

(define-public emacs-llm
  (package
    (name "emacs-llm")
    (version "0.27.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ahyatt/llm")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1yf6gbl5360747zgcnl983gwghgad892arpb07k5yhpa61jw50aa"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "emacs" "--batch"
                             "-l" "llm-test.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs (list emacs-plz emacs-plz-event-source
                             emacs-plz-media-type))
    (home-page "https://github.com/ahyatt/llm")
    (synopsis "Emacs library abstracting Large Language Model capabilities")
    (description
     "This package provides interfaces to abstract various @acronym{LLM, large
language model}s out in the world.  To respect user freedom, it will warn you
before interacting with non-free LLMs.")
    (license license:gpl3+)))

(define-public emacs-llm-tool-collection
  (let ((commit "6d2765a16dc10af2e1d1911bcabf6d7f287e0434")
        (revision "0"))
    (package
      (name "emacs-llm-tool-collection")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/skissue/llm-tool-collection/")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1rddjhm5jrl5a32bzmhrjfyh54y6ibrsj5pb5hrp3h93iwp16vwk"))))
      (build-system emacs-build-system)
      (arguments
       (list #:emacs emacs                   ;for cl-lib
             #:tests? #f))                   ;no tests
      (home-page "https://github.com/skissue/llm-tool-collection/")
      (synopsis "Collection of Emacs Lisp LLM tools")
      (description
       "This package provides a collection of tools to be used by
@acronym{Large Language Models, LLM} clients in Emacs.")
      (license license:gpl3+))))

(define-public emacs-agitjo
  (package
    (name "emacs-agitjo")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://codeberg.org/halvin/agitjo")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1wbhi4lbqk0vf0di86a9wljvva3a9vhb2wvsn1s44h53xslhrj0n"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ;no tests
    (propagated-inputs (list emacs-magit emacs-markdown-mode emacs-transient))
    (home-page "https://codeberg.org/halvin/agitjo")
    (synopsis "Manage Forgejo PRs with AGit-Flow in Emacs")
    (description
     "AGitjo is a GNU Emacs package that extends Magit with a new menu for
AGit-Flow operations, to make them more convenient for users.  The AGit workflow
enables users to create and edit pull requests using just the @code{git push}
command.  This package is intended specifically for use with
Forgejo-based (e.g. Codeberg) repositories.")
    (license license:gpl3+)))

(define-public emacs-magit
  (package
    (name "emacs-magit")
    (version "4.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magit/magit")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0lsxldyjv2h69657pgrblhkxq8fvc0xdwlwpfmd09pb8zawygh2g"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:lisp-directory "lisp"
      #:test-command #~(list "make" "-C" ".." "test")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'build-info-manual
            (lambda _
              (invoke "make" "-C" ".." "info")
              ;; Copy info files to the lisp directory, which acts as
              ;; the root of the project for the emacs-build-system.
              (rename-file "../docs/magit.info" "../lisp/magit.info")))
          (add-after 'unpack 'patch-version-executables
            (lambda* (#:key inputs #:allow-other-keys)
              (emacs-substitute-variables "magit.el"
                ("magit-version" #$version))
              (emacs-substitute-variables "magit-git.el"
                ("magit-git-executable"
                 (search-input-file inputs "/bin/git")))
              (emacs-substitute-variables "magit-sequence.el"
                ("magit-perl-executable"
                 (search-input-file inputs "/bin/perl"))))))))
    (native-inputs
     (list texinfo))
    (inputs
     (list git perl))
    (propagated-inputs
     ;; Note: the 'git-commit' and 'magit-section' dependencies are part of
     ;; magit itself.
     (list emacs-compat
           emacs-cond-let
           emacs-llama
           emacs-transient
           emacs-with-editor))
    (home-page "https://magit.vc/")
    (synopsis "Emacs interface for the Git version control system")
    (description
     "With Magit, you can inspect and modify your Git repositories
with Emacs.  You can review and commit the changes you have made to
the tracked files, for example, and you can browse the history of past
changes.  There is support for cherry picking, reverting, merging,
rebasing, and other common Git operations.")
    (license license:gpl3+)))

(define-public emacs-magit-stgit
  (package
    (name "emacs-magit-stgit")
    (version "3.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/stacked-git/magit-stgit.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10ql7gi586w65vds6wsh8bw5nr444xqhgh87khzcpfaglnw2lyaf"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f)) ;no tests
    (propagated-inputs (list emacs-magit emacs-transient emacs-llama))
    (home-page "https://github.com/stacked-git/magit-stgit")
    (synopsis "StGit extension for Magit")
    (description
     "This package provides basic support for @code{stgit} in
@code{emacs-magit}.  When @code{magit-stgit-mode} is turned on, the
current patch series is displayed in the status buffer.  While point is on a
patch the changes it introduces can be shown using @code{RET}, it can be selected
as the current patch using @code{a}, and it can be discarded using @code{k}.  Other
@code{StGit} commands are available from the @code{StGit} transient on @code{/}.")
    (license license:gpl3+)))

(define-public emacs-magit-svn
  (package
    (name "emacs-magit-svn")
    (version "2.2.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/magit/magit-svn")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0x419qz80ir9ni94j3n08a5ygfq1265fpr13dsnxjjnlwjbq7sx7"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-dash emacs-with-editor emacs-magit))
    (home-page "https://github.com/magit/magit-svn")
    (synopsis "Git-SVN extension to Magit")
    (description
     "This package is an extension to Magit, the Git Emacs mode, providing
support for Git-SVN.")
    (license license:gpl3+)))

(define-public emacs-magit-popup
  (package
    (name "emacs-magit-popup")
    (version "2.13.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magit/magit-popup")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0znp6gx6vpcsybg774ab06mdgxb7sfk3gki1yp2qhkanav13i6q1"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #f    ; no tests
       #:phases
       (modify-phases %standard-phases
         (add-before 'install 'make-info
           (lambda _
             (invoke "make" "info"))))))
    (native-inputs
     (list texinfo))
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://github.com/magit/magit-popup")
    (synopsis "Define prefix-infix-suffix command combos")
    (description
     "This library implements a generic interface for toggling switches and
setting options and then invoking an Emacs command which does something with
these arguments.  The prototypical use is for the command to call an external
process, passing on the arguments as command line arguments.")
    (license license:gpl3+)))

(define-public emacs-magit-annex
  (package
    (name "emacs-magit-annex")
    (version "1.9.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magit/magit-annex")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0gbrn80xcwhfav962hjv6lhx444b81jknzj22zb8d5piqfpg8rvc"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f  ; tests rely on an older version of emacs-magit.
           #:test-command
           (let ((emacs-magit (this-package-input "emacs-magit")))
             #~(list "make" "test"
                     (string-append "MAGIT_DIR="
                                    #$emacs-magit
                                    "/share/emacs/site-lisp/magit-"
                                    #$(package-version emacs-magit))))))
    (propagated-inputs (list emacs-magit))
    (home-page "https://github.com/magit/magit-annex/")
    (synopsis "Git-annex support for Magit")
    (description
     "Magit-annex adds a few git-annex operations to the Magit interface.")
    (license license:gpl3+)))

(define-public emacs-magit-tbdiff
  (package
    (name "emacs-magit-tbdiff")
    (version "1.2.0")
    (home-page "https://github.com/magit/magit-tbdiff")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jh6wspb6ijmkqvyaswqj60ixpgjj2ijcf0b53q48pfs5dwc97p4"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs (list emacs-magit))
    (synopsis "Magit extension for range diffs")
    (description
     "Magit-tbdiff provides a Magit interface to @code{git-range-diff} (and its
third-party predecessor @code{git-tbdiff}), a Git subcommand for comparing two
versions of a topic branch.")
    (license license:gpl3+)))

(define-public emacs-magit-delta
  ;; No releases or tags.
  (let ((commit "5fc7dbddcfacfe46d3fd876172ad02a9ab6ac616")
        (revision "0"))
    (package
      (name "emacs-magit-delta")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/dandavison/magit-delta")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url home-page)
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1kph5r9dy21pgfknpcdzzqfn6rqig5nvp8ksh16y13k3axlzvkiw"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #f ;no tests
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-delta-executable
              (lambda* (#:key inputs #:allow-other-keys)
                (emacs-substitute-variables "magit-delta.el"
                  ("magit-delta-delta-executable"
                   (search-input-file inputs "/bin/delta"))))))))
      (propagated-inputs (list emacs-dash emacs-magit emacs-xterm-color))
      (inputs (list git-delta))
      (synopsis "Integration of @code{delta} with @code{emacs-magit}")
      (description "Magit-delta provides a minor mode which configures
@code{emacs-magit} to use @code{delta} for syntax highlighting when displaying
diffs.")
      (license license:expat))))

(define-public emacs-malyon
  (package
    (name "emacs-malyon")
    (version "20161204")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/speedenator/malyon/")
                    (commit "0d9882650720b4a791556f5e2d917388965d6fc0")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0an1yvp0p624rxd8n5phiwvznw35ripqhlwzwyv2bw7lc1rscllr"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/speedenator/malyon")
    (synopsis "Z-machine interpreter")
    (description
     "Malyon is a Z-machine interpreter for playing text-based adventure
games.  Malyon plays version 3 (.z3), version 5 (.z5), and version 8 (.z8) z
code files.")
    (license license:expat)))

(define-public emacs-mcp
  ;; No releases available.
  (let ((commit "4708c5849ce4ddb632016eca662a7405bfa642d4")
        (revision "0"))
    (package
      (name "emacs-mcp")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/lizqwerscott/mcp.el/")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "11x3jscm4iggyy926aidiv95lrbcncngbvivsybvzjvbhdxhb65h"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ;no tests
      (inputs (list emacs-jsonrpc))
      (home-page "https://github.com/lizqwerscott/mcp.el/")
      (synopsis "Emacs interface to MCP protocol")
      (description "@code{emacs-mcp} is an Emacs client providing structured
communication to @acronym{Model Context Protocol, MCP} servers, with Support
for filesystem and generic servers.")
      (license license:gpl3+))))

(define-public emacs-mct
  (package
    (name "emacs-mct")
    (version "1.1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://gitlab.com/protesilaos/mct")
                    (commit version)))
              (sha256
               (base32 "0k9g3305ba4m2bljq4k69jvrzd8h27mmkj17544182hfl6i64gs1"))
              (file-name (git-file-name name version))))
    (native-inputs (list texinfo))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (home-page "https://protesilaos.com/emacs/mct")
    (synopsis "Enhancement of the default Emacs minibuffer completion UI")
    (description "Minibuffer and Completions in Tandem, also known as MCT, or
mct.el, is an Emacs package that enhances the default minibuffer and
@samp{*Completions*} buffer so that they work together as part of a unified
framework.  The idea is to make the presentation and overall functionality be
consistent with other popular, vertically aligned completion UIs while
leveraging built-in functionality.")
    (license (list license:gpl3+
                   license:fdl1.3+)))) ; GFDLv1.3+ for the manual

(define-public emacs-meyvn
  (let ((commit "8d00ada6daa5617fa60f76e0be2cf2f5d1babcf9")) ;version bump
    (package
      (name "emacs-meyvn")
      (version "1.7")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/danielsz/meyvn-el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0ncilsn0ih01w6hjdn529jkapiv4nnkway07j2b5fndkrlgk2ry4"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-cider
                               emacs-dash
                               emacs-geiser
                               emacs-parseclj
                               emacs-parseedn
                               emacs-projectile
                               emacs-s))
      (home-page "https://github.com/danielsz/meyvn-el")
      (synopsis "Emacs client for the Meyvn build tool")
      (description
       "This package provides an Emacs client for the @url{https://meyvn.org, Meyvn} build tool.")
      (license license:gpl3+))))

(define-public emacs-affe
  (package
    (name "emacs-affe")
    (version "0.9")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/minad/affe")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "166v7d120hbk6vczj1iam85xivk6wwpvga8m0vxgcii19issh5b3"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs (list emacs-consult))
    (home-page "https://github.com/minad/affe")
    (synopsis "Asynchronous fuzzy finder for Emacs")
    (description "This package provides Affe, an asynchronous fuzzy finder for
GNU Emacs written in pure Emacs Lisp. It spawns an external producer process,
such as @command{find} or @command{grep}, and filters the output asynchronously.
The UI remains responsive, and results are shown via the Consult interface.
Affe is experimental and best suited for small to medium projects.")
    (license license:gpl3+)))

(define-public emacs-fzf
  (let ((commit "641aef33c88df3733f13d559bcb2acc548a4a0c3")
        (revision "1"))
    (package
      (name "emacs-fzf")
      (version (git-version "0.2" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/bling/fzf.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1nyvam5jg4gih0x2rvwr4jn97lyhaic3adpdxpdfx682ckj1k2vp"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #f                     ;no tests
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-fzf-executable
              (lambda* (#:key inputs #:allow-other-keys)
                (emacs-substitute-variables "fzf.el"
                  ("fzf/executable" (search-input-file inputs "/bin/fzf"))))))))
      (inputs (list fzf))
      (home-page "https://github.com/bling/fzf.el")
      (synopsis "Emacs front-end for Fzf finder")
      (description "This package provides an Emacs front-end for Fzf general
purpose finder.")
      (license license:gpl3+))))

(define-public emacs-ezf
  (let ((commit "038513f7bd335981430f5d3386d533272567cefd")
        (revision "0"))
    (package
      (name "emacs-ezf")
      (version (git-version "0.1.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/mickeynp/ezf")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0nrby8f3magyjwwyqk9bqyrgh04vlm8alajzng9x507n42pb7bn7"))))
      (build-system emacs-build-system)
      (arguments
       (list #:test-command #~(list "emacs" "--batch"
                                    "-l" "ezf.el" "-l" "ezf-test.el"
                                    "-f" "ert-run-tests-batch-and-exit")
             #:phases
             #~(modify-phases %standard-phases
                 (add-after 'install 'install-script
                   (lambda _
                     (install-file "ezf"
                                   (string-append #$output "/bin")))))))
      (propagated-inputs
       (list emacs-helm))
      (home-page "https://github.com/mickeynp/ezf")
      (synopsis "Emacs Fuzzy Finder")
      (description "Emacs Fuzzy Finder is like fzf, but it leverages the power
of your Emacs instance to filter and select candidates.  Use ezf as part of
piping and command substitutions to manually select and filter matches.")
      (license license:gpl3+))))

(define-public emacs-pacfiles-mode
  (package
    (name "emacs-pacfiles-mode")
    (version "1.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/UndeadKernel/pacfiles-mode")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1d61s846r9ncmyx97f44r8i3p1ikgi4bab8k7xk868lja96y2ij7"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/UndeadKernel/pacfiles-mode")
    (synopsis "ArchLinux's pacnew and pacsave merging tool")
    (description
     "This Emacs major mode helps manage @file{.pacnew} and @file{.pacsave}
files left by ArchLinux's pacman.")
    (license license:expat)))

(define-public emacs-palimpsest
  (package
    (name "emacs-palimpsest")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/danielsz/Palimpsest")
             (commit "f474b3ad706373d9953abdc401d683a2a023d28e")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0wzxl1zcbm3svspjpjzvx92is1k9sz7g0a99r8q066j2364la0zh"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/danielsz/Palimpsest")
    (synopsis "Remove text without permanently deleting it")
    (description
     "This minor mode for Emacs provides several strategies to remove text
without permanently deleting it.  Namely, it can send selected test to the
bottom, or top, of the buffer, or to a trash file.")
    (license license:gpl3+)))

(define-public emacs-minions
  (package
    (name "emacs-minions")
    (version "1.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tarsius/minions")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "06s2gd47q2lp4lj0ycrjihhn41ws9d3mh6ap9a7gz3b0blifpb4i"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command
           #~(list "make" "check-declare")))
    (propagated-inputs
     (list emacs-compat emacs-dash))
    (home-page "https://github.com/tarsius/minions")
    (synopsis "Minor-mode menu for the mode line")
    (description
     "This package implements a menu that lists enabled minor-modes, as well
as commonly but not currently enabled minor-modes.  It can be used to toggle
local and global minor-modes, to access mode-specific menus, and to get help
about modes.

This menu is intended as a replacement for the incomplete yet wide list of
enabled minor-modes that is displayed in the mode line by default.  To use the
menu like this, enable Minions mode.

Alternatively the menu can be bound globally, for example:
@code{(global-set-key [S-down-mouse-3] 'minions-minor-modes-menu)}.")
    (license license:gpl3+)))

(define-public emacs-nano-modeline
  (let ((commit "04676d57a1e602123a593836745a744d1b2028fb")) ;version bump
    (package
      (name "emacs-nano-modeline")
      (version "1.1.0")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/rougier/nano-modeline")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1q10zd8aiq5xm7p4sm1mrfmw0sfgfyznyk4lvh2rl9pqh9kh700a"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/rougier/nano-modeline")
      (synopsis "Emacs minor mode controlling mode line")
      (description "Nano modeline is a minor mode for Emacs that modifies the
mode line as @samp{[ status | name (primary) secondary ]}.  It can be
displayed at the bottom or at the top.")
      (license license:gpl3+))))

(define-public emacs-moody
  (package
    (name "emacs-moody")
    (version "1.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tarsius/moody")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0nay6mpphb8ri0b92jjj15h9dfff2nwl9rwsdjfay976qdnfffmi"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "make" "check-declare")))
    (propagated-inputs
     (list emacs-compat))
    (home-page "https://github.com/tarsius/moody")
    (synopsis "Tabs and ribbons for Emacs mode-line")
    (description
     "@code{emacs-moody} provides utilities for displaying elements of
the mode line as tabs and ribbons.  It also provides replacements for a few
built-in elements.  The biggest difference to similar packages is that
this one is much simpler and much more consistent.  When using this package,
then only the color of the mode line changes when a window becomes in-/active.")
    (license license:gpl3+)))

(define-public emacs-acme-theme
  (let ((commit "7c408d111c5e451ecb8fdd5f76cf7d8074aec793")
        (revision "0"))
    (package
      (name "emacs-acme-theme")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/ianyepan/acme-emacs-theme")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "16qxspzlf0bvw36ff4qnrn5p7mc5sf923ba0ar04cr87bfqgyak4"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/ianyepan/acme-emacs-theme")
      (synopsis "Emacs theme inspired by Plan 9's Acme and Sam Editor")
      (description "Acme theme is an Emacs theme with an old-school vibe
inspired by Plan 9 Acme and the Sam text editor.")
      (license license:gpl3+))))

(define-public emacs-catppuccin-theme
  (let ((commit "2975032bcf55d23b1cc05e323f5c30ec36bf17ba")
        (revision "2"))
    (package
      (name "emacs-catppuccin-theme")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/catppuccin/emacs")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0lqmqzanky88jlmrq1qafp5cls2wc39rm65325522izbvqaalgrp"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/catppuccin/emacs")
      (synopsis "Soothing pastel theme for Emacs")
      (description
       "Catppuccin is a soothing pastel theme for Emacs.  It provides
different color palettes, such as @samp{frappe}, @samp{macchiato}, or
@samp{latte}.")
      (license license:expat))))

(define-public emacs-theme-magic
  ;; No tagged release upstream, but the commit below correspond to the 0.2.3
  ;; release.
  (let ((commit "844c4311bd26ebafd4b6a1d72ddcc65d87f074e3")
        (revision "0"))
    (package
      (name "emacs-theme-magic")
      (version "0.2.3")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jcaw/theme-magic")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "10gkg7jh1s1484gm66a87zr7x8vmv00s7gfd0w2pj47nqf98g8hz"))))
      (build-system emacs-build-system)
      (arguments
       (list
        ;; Include Pywal interaction scripts.
        #:include #~(cons "^python/" %default-include)
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-exec-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* '("theme-magic.el" "python/wal_change_colors.py")
                  (("\"python\"")
                   (string-append "\""
                                  (search-input-file inputs "/bin/python3")
                                  "\""))
                  (("\"wal\"")
                   (string-append "\""
                                  (search-input-file inputs "/bin/wal")
                                  "\""))))))))
      (inputs
       (list python python-pywal))
      (home-page "https://github.com/jcaw/theme-magic")
      (synopsis "Generate and apply color palettes based on your Emacs theme")
      (description
       "This package provides a command to extract the colors from your Emacs
theme and apply them to the rest of Linux with Pywal.  Pywal only applies your
theme to the current session.")
      (license license:gpl3+))))

(define-public emacs-vscode-dark-plus
  (package
    (name "emacs-vscode-dark-plus")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ianyepan/vscode-dark-plus-emacs-theme")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vcaqvhdgr91pr7kqskbscs8awm8jp6dkh79h6w36i9ipmc4l4hl"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ianyepan/vscode-dark-plus-emacs-theme")
    (synopsis "Emacs port of the default VS Code Dark+ theme")
    (description
     "This theme aims to be as identical as possible to the default Dark+
color scheme used by Visual Studio Code.")
    (license license:gpl3+)))

(define-public emacs-theme-sorcery
  (let ((revision "0")
        (commit "5a1c4445b9e6e09589a299a9962a6973272a0c2f"))
    (package
      (name "emacs-theme-sorcery")
      (version "1.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mtreca/emacs-theme-sorcery")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1b858049n6nw4qf60fmszjrhl80x7ssh32f7glj722kwy7404kdh"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-autothemer))
      (home-page "https://github.com/mtreca/emacs-theme-sorcery")
      (synopsis "Dark and low-contrast Emacs theme")
      (description "Sorcery is a dark and low-contrast Emacs theme inspired by
Apprentice and Sourcerer.")
      (license license:gpl3+))))

(define-public emacs-suneater-theme
  (package
    (name "emacs-suneater-theme")
    (version "2.5.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~plattfot/suneater-theme")
             (commit version)))
       (sha256
        (base32
         "0l53709gfx70rqxp8n785bg5n4sdmblwsnbm8y4k7jj4i1sqiqpn"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (home-page "https://git.sr.ht/~plattfot/suneater-theme")
    (synopsis "Minimalistic dark theme for Emacs")
    (description
     "Suneater is a dark, minimalistic Emacs theme.  It was based on Sunburst
theme but now takes more inspiration from the Nano theme.")
    (license license:gpl3+)))

(define-public emacs-adwaita-dark-theme
  (package
    (name "emacs-adwaita-dark-theme")
    (version "1.3.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://gitlab.com/jessieh/adwaita-dark-theme")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "10hm8anw78n37pl9rz3dnjphrnsxf3fy00d008gayn70jfjl1433"))))
    (build-system emacs-build-system)
    (home-page "https://gitlab.com/jessieh/adwaita-dark-theme")
    (synopsis "Adwaita-inspired dark color scheme for Emacs")
    (description
     "This package provides an Adwaita-inspired dark color scheme for Emacs.")
    (license license:gpl2+)))

(define-public emacs-treepy
  (package
    (name "emacs-treepy")
    (version "0.1.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/volrath/treepy.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0pmrpij80m5kgcr8bw36r8wllgppasw08vn3ghwvis9srpaq75cn"))))
    (build-system emacs-build-system)
    (home-page
     "https://github.com/volrath/treepy.el")
    (synopsis "Tree traversal tools")
    (description
     "Generic tools for recursive and iterative tree traversal based on
clojure.walk and clojure.zip respectively.")
    (license license:gpl3+)))

(define-public emacs-typing
  (let ((commit "a2ef25dde2d8eb91bd9c0c6164cb5208208647fa")
        (revision "0"))
    (package
      (name "emacs-typing")
      (version (git-version "1.1.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/kensanata/typing")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1dbh0srbf54lgd60ia79y9cfnq3kxlgw01qzdjs9mk3nfazzpgnv"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/kensanata/typing/")
      (synopsis "Emacs game where you have to type fast")
      (description "The Typing of Emacs is a game for Emacs that
forces you to type words correctly as fast as possible, otherwise
you will die.  The game builds the list of words from the active buffer.")
      (license license:gpl2+))))

(define-public emacs-speed-type
  (package
    (name "emacs-speed-type")
    (version "1.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/dakra/speed-type")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1rw3lgm65jxcs7vbj0055ays4wv23mk2kj3xivnqmhnm030vk868"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command
      #~(list "emacs" "-Q" "--batch" "-L" "."
              "-l" "test-speed-type.el"
              "-f" "ert-run-tests-batch-and-exit")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'skip-failing-test
            ;; This test requires an internet connection.
            (lambda _
              (substitute* "test-speed-type.el"
                (("\\(ert-deftest speed-type--retrieve-test .*" all)
                 (string-append all " (skip-unless nil)"))))))))
    (native-inputs (list emacs-dash))
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/dakra/speed-type")
    (synopsis "Practice touch/speed typing in GNU Emacs")
    (description
     "Speed Type allows you to practice your touch typing skills.  You can
test yourself by typing snippets from online books or use any piece of text or
code you have in Emacs.  Speed Type keeps track of your stats (WPM, CPM,
accuracy) while you are typing.")
    (license license:gpl3+)))

(define-public emacs-graphql
  (let ((commit "b57b5ca5d2d0837e1fb4a4f30c051d5f3e643f0f")) ;version bump
    (package
      (name "emacs-graphql")
      (version "0.1.2")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/vermiculus/graphql.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "18k2c2b7y5qgc7qpkqjmz1nv61w470ja3vwprmy5dlkzficzqsvf"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'skip-failing-test
              (lambda _
                (substitute* "test/graphql-test.el"
                  (("\\(ert-deftest correct-tag .*" all)
                   (string-append all " (skip-unless nil)"))))))))
      (native-inputs (list emacs-ert-runner))
      (propagated-inputs (list emacs-ghub))
      (home-page "https://github.com/vermiculus/graphql.el")
      (synopsis "GraphQL utilities")
      (description
       "GraphQL.el provides a generally-applicable domain-specific language for
creating and executing GraphQL queries against your favorite web services.
GraphQL is a data query language and runtime designed and used to request and
deliver data to mobile and web apps.")
      (license license:gpl3+))))

(define-public emacs-graphql-mode
  ;; No tagged commit.  No "Version" keyword either.
  (let ((commit "9bed568ec86242dbe30bdbab324aa0eb2cd9bf08")
        (revision "1"))
    (package
      (name "emacs-graphql-mode")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/davazp/graphql-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0x9y7qq6y0zg8ncamzvk68ccmdyzh7xsj0xs0ykyl20d5wdpplj4"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/davazp/graphql-mode")
      (synopsis "Emacs mode to edit GraphQL schema and queries")
      (description
       "This package implements a major mode to edit GraphQL schemas and
query.  The basic functionality includes syntax highlight and indentation.
Additionally, it is able to send GraphQL queries to an end-point URL.

Files with the @file{.graphql} and @file{.gql} extensions are
automatically opened with this mode.")
      (license license:gpl3+))))

(define-public emacs-ghq
  (package
    (name "emacs-ghq")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rcoedo/emacs-ghq")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10a7rxmijwmdkfb5rgavd8inc3a45q0m57dxdf6v62bcy00kmw4l"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-ghq-location
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((ghq (search-input-file inputs "/bin/ghq")))
                (substitute* "ghq.el"
                  (("\"ghq") (string-append "\"" ghq)))))))))
    (inputs
     (list ghq))
    (propagated-inputs
     (list emacs-dash emacs-s))
    (home-page "https://github.com/rcoedo/emacs-ghq")
    (synopsis "Emacs interface for @code{ghq} tool")
    (description
     "This package provides a set of functions wrapping @code{ghq}, a tool for
organizing remote Go repository clones.")
    (license license:gpl3+)))

(define-public emacs-ghub
  (package
    (name "emacs-ghub")
    (version "5.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magit/ghub")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16ikjhps2ha23ab3w43vsz38l1hbjvwhk2dhajv6853gpx4xaipm"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f ; there are no tests
      #:lisp-directory "lisp"
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'build-info-manual
            (lambda _
              (invoke "make" "--directory=.." "info")))
          (add-after 'install 'install-info
            (lambda _
              (let ((info (string-append #$output "/share/info")))
                (install-file "../docs/ghub.info" info)))))))
    (native-inputs
     (list texinfo))
    (propagated-inputs
     (list emacs-compat
           emacs-llama
           emacs-let-alist
           emacs-treepy))
    (home-page "https://github.com/magit/ghub")
    (synopsis "Emacs client libraries for the APIs of various Git forges")
    (description
     "Ghub provides basic support for using the APIs of various Git forges from
Emacs packages.  It supports the REST APIs of Github, Github GraphQL, Gitlab,
Gitea, Gogs and Bitbucket.  It abstracts access to API resources using only a
handful of functions that are not resource-specific.")
    (license license:gpl3+)))

(define-public emacs-typit
  (package
    (name "emacs-typit")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mrkkrp/typit")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0djxmni5mfc9wzm0zg7fsd7138ic5qznbmqd5jyrk4mpf0li8nhy"))))
    (build-system emacs-build-system)
    (arguments
     '(#:include (cons "^dict/" %default-include)))
    (propagated-inputs
     (list emacs-f emacs-mmt))
    (home-page "https://github.com/mrkkrp/typit")
    (synopsis "Typing game for Emacs with two difficulties")
    (description "Emacs Typit is a typing game for Emacs.  Words that are
picked randomly from the most frequent words in language you're practicing,
until time is up.")
    (license license:gpl3+)))

(define-public emacs-scribble-mode
  (let ((commit "217945d54de5e4bb207033f2116baa28f5c5ecf2")
        (revision "2"))
    (package
      (name "emacs-scribble-mode")
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/emacs-pe/scribble-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1s5ccw1a5ack01wd94ywfcrar9j98agchwdh30q7iyxr0d2z4sii"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ; no tests
      (home-page "https://github.com/emacs-pe/scribble-mode")
      (synopsis "Emacs mode for editing the Scribble documentation syntax")
      (description
       "This package provides basic syntax highlighting and editing support
for editing Racket's Scribble documentation syntax in Emacs.")
      (license license:gpl3+))))

(define-public emacs-elkee
  (package
    (name "emacs-elkee")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/KeyWeeUsr/elkee")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nfgd3zp9pypwj3sxks3w5dc9wfzv9abz6g70wh557p8v88nria9"))))
    (build-system emacs-build-system)
    (arguments
     (list
      ;; Tests fail because they assume the presence of specific host packages
      ;; and Emacs configure flags.
      #:tests? #f
      #:test-command #~(list "eldev" "--use-emacsloadpath" "-dtTC" "test")))
    (native-inputs
     (list
      emacs-eldev
      emacs-undercover))
    (propagated-inputs
     (list
      emacs-elchacha
      emacs-kaesar))
    (home-page "https://github.com/KeyWeeUsr/elkee")
    (synopsis "Emacs-native KeePass client")
    (description
     "This package provides an Emacs-native KeePass client to open, read, and
modify @acronym{KDBX, Keepass DataBase @acronym{XML, eXtensible Markup
Language}} files.  It supports password-only and keyfile authentication,
allows entry lookup using regular-expression selectors (group, title,
username, URL), and can return results either as a flat list or grouped by
entry.")
    (license license:gpl3)))

(define-public emacs-shroud
  (package
    (name "emacs-shroud")
    (version "1.105")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.savannah.gnu.org/git/emacs-shroud.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0q2pb3w8s833fjhkzicciw2php4lsnismad1dnwgp2lcway757ra"))))
    (build-system gnu-build-system)
    (arguments
     `(#:modules ((guix build gnu-build-system)
                  ((guix build emacs-build-system) #:prefix emacs:)
                  (guix build utils))
       #:imported-modules (,@%default-gnu-imported-modules
                           (guix build emacs-build-system)
                           (guix build emacs-utils))
       #:configure-flags (list (string-append "--with-lispdir="
                                              (emacs:elpa-directory %output)))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'expand-load-path
           (assoc-ref emacs:%standard-phases 'expand-load-path)))))
    (native-inputs
     (list autoconf automake texinfo perl emacs-minimal))
    (propagated-inputs
     (list emacs-bui
           emacs-dash
           emacs-f
           emacs-s
           gnupg
           shroud))
    (home-page "https://www.nongnu.org/emacs-shroud")
    (synopsis "Emacs interface to the Shroud password manager")
    (description
     "This package provides an Emacs interface to the Shroud password manager,
using the Buffers User Interface library.  You can view, copy, and edit secrets
from within Emacs.")
    (license license:gpl3+)))

(define-public emacs-solidity
  ;; This commit fixes a spacing issue and adds new keywords.
  (let ((commit "d166a86b83907e0cfd64c191e9dfce4b44a9843e")
        (revision "0"))
    (package
      (name "emacs-solidity")
      (version (git-version "0.1.10" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ethereum/emacs-solidity")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19hgvsrqch2vp49ag6m76bi5qxd20v95z0ib838rib9as15b17wq"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-company emacs-flycheck))
      (home-page "https://github.com/ethereum/emacs-solidity")
      (synopsis "Major mode for writing Solidity code")
      (description
       "This is a simple language mode for the Solidity language.  It is
a constant work in progress as the language itself also progresses.")
      (license license:gpl3+))))

(define-public emacs-unpackaged
  (let ((commit "0c1f447dab29697d4e30806022f28657c1489375")
        (revision "4"))
    (package
      (name "emacs-unpackaged")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alphapapa/unpackaged.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "042vcffg1scq6zq8rhv3f2hsl4ychr1gx6hlp23b8hfmz268fima"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-dash
                               emacs-esxml
                               emacs-org
                               emacs-s
                               emacs-hydra
                               emacs-use-package
                               emacs-ts))
      (home-page "https://github.com/alphapapa/unpackaged.el")
      (synopsis "Useful snippets of Emacs Lisp code")
      (description
       "This package provides Emacs Lisp utilities for a variety
of tasks, including version control, task management, and regex-based
replacement.")
      (license license:gpl3+))))

(define-deprecated-package emacs-unpackaged-el
  emacs-unpackaged)

(define-public emacs-haskell-mode
  (let ((commit "e9c356739310332afe59b10ffa2e6c3e76f124e3")
        (revision "0"))
    (package
    (name "emacs-haskell-mode")
    (version (git-version "17.5" revision commit))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/haskell/haskell-mode")
             (commit commit)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1mkp9b31ai1z6sccx8cff40viryamw7dm85acig3q82dwlbmxx98"))))
    (propagated-inputs
     (list emacs-dash))
    (native-inputs
     (list emacs-minimal emacs-el-search emacs-stream texinfo))
    (build-system gnu-build-system)
    (arguments
     (list
      #:make-flags #~(list
                      (string-append "EMACS=" #$emacs-minimal "/bin/emacs"))
      #:modules `((ice-9 match)
                  (srfi srfi-26)
                  ((guix build emacs-build-system) #:prefix emacs:)
                  ,@%default-gnu-imported-modules)
      #:imported-modules `(,@%default-gnu-imported-modules
                           (guix build emacs-build-system)
                           (guix build emacs-utils))
      #:phases
      #~(modify-phases %standard-phases
          (delete 'configure)
          (add-before 'build 'pre-build
            (lambda* (#:key inputs #:allow-other-keys)
              (define (el-dir store-dir)
                (match (find-files store-dir "\\.el$")
                  ((f1 f2 ...) (dirname f1))
                  (_ "")))

              (let ((sh (search-input-file inputs "/bin/sh")))
                (define emacs-prefix? (cut string-prefix? "emacs-" <>))

                (setenv "SHELL" "sh")
                (setenv "EMACSLOADPATH"
                        (string-concatenate
                         (map (match-lambda
                                (((? emacs-prefix? name) . dir)
                                 (string-append (el-dir dir) ":"))
                                (_ ""))
                              inputs)))
                (substitute* (find-files "." "\\.el") (("/bin/sh") sh)))))
          (add-before 'check 'delete-failing-tests
            ;; XXX: these tests require GHC executable, which would be a big
            ;; native input.
            (lambda _
              (with-directory-excursion "tests"
                ;; File `haskell-indent-tests.el' fails with
                ;; `haskell-indent-put-region-in-literate-2'
                ;; on Emacs 27.1+
                ;; XXX: https://github.com/haskell/haskell-mode/issues/1714
                (for-each delete-file
                          '("haskell-indent-tests.el"
                            "haskell-customize-tests.el"
                            "inferior-haskell-tests.el"))

                ;; requires many external tools (e.g. git, hasktags)
                (substitute* "haskell-mode-tests.el"
                  (("\\(ert-deftest haskell-generate-tags.*" all)
                   (string-append all " (skip-unless nil)"))))))
          (replace 'install
            (lambda* (#:key outputs #:allow-other-keys)
              (let* ((out (assoc-ref outputs "out"))
                     (el-dir (emacs:elpa-directory out))
                     (doc (string-append
                           out "/share/doc/haskell-mode-" #$version))
                     (info (string-append out "/share/info")))
                (define (copy-to-dir dir files)
                  (for-each (lambda (f)
                              (install-file f dir))
                            files))

                (with-directory-excursion "doc"
                  (invoke "makeinfo" "haskell-mode.texi")
                  (install-file "haskell-mode.info" info))
                (copy-to-dir doc '("CONTRIBUTING.md" "NEWS" "README.md"))
                (copy-to-dir el-dir (find-files "." "\\.elc?"))))))))
    (home-page "https://github.com/haskell/haskell-mode")
    (synopsis "Haskell mode for Emacs")
    (description
     "This is an Emacs mode for editing, debugging and developing Haskell
programs.")
    (license license:gpl3+))))

(define-public emacs-lean4-mode
  (package
    (name "emacs-lean4-mode")
    (version "1.1.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                     (url "https://github.com/leanprover-community/lean4-mode.git")
                     (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1i4l614n0hs02y0a4xfnzc4xkilkp6bzx28pys4jkp96vp2ivf0c"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f                       ; no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'install-data
            (lambda _
              (let ((data (string-append (elpa-directory #$output) "/data")))
                (mkdir-p data)
                (copy-recursively "data" data)))))))
    ;; TODO: Just emacs-magit-section instead of emacs-magit would be enough.
    (propagated-inputs
     (list emacs-compat emacs-lsp-mode emacs-dash emacs-magit))
    (synopsis "Lean 4 major mode for Emacs")
    (description "This package provides a major mode for the Lean theorem
prover, version 4.")
    (home-page "https://lean-lang.org/")
    (license license:asl2.0)))

(define-public emacs-lem
  (package
    (name "emacs-lem")
    (version "0.24")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/martianh/lem.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "181cibmv6da4rjr6p3nqpza6i7v4scc4qndznhyjb9nhbf3gsil4"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f ; no tests
      #:lisp-directory "lisp"))
    (propagated-inputs
     (list emacs-fedi emacs-markdown-mode))
    (home-page "https://codeberg.org/martianh/lem.el")
    (synopsis "Emacs client for Lemmy")
    (description "@code{lem.el} is an Emacs client for Lemmy, the federated link
aggregator.")
    (license license:gpl3+)))

(define-public emacs-dante
  (package
    (name "emacs-dante")
    (version "1.7")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/jyp/dante")
                    (commit version)))
              (sha256
               (base32
                "0q7hackvaplh1f645ngd76f2ls5mvg93xicr3rkxr07hd36yihag"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-company
           emacs-dash
           emacs-f
           emacs-flycheck
           emacs-haskell-mode
           emacs-lcr
           emacs-s))
    (home-page "https://github.com/jyp/dante")
    (synopsis "Minor mode for interactive Haskell")
    (description
     "This package provides a minor mode for Haskell development that
supports type hints, definition-jumping, completion, and more.")
    (license license:gpl3+)))

(define-public emacs-flexoki-themes
  (let ((commit "1b871e57e989d58a793cbfef7b4996a6bd47ba9f")) ;version bump
    (package
      (name "emacs-flexoki-themes")
      (version "0.20")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/crmsnbleyd/flexoki-emacs-theme")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0npl45h1l8jhrd5dcaaql5in4pj7c3wxnqsp8di668pz2s4i9pfh"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/crmsnbleyd/flexoki-emacs-theme")
      (synopsis "Inky colour scheme for prose and code")
      (description
       "Flexoki themes is a pair of light and dark themes for GNU Emacs based
on the Flexoki colour scheme by Steph Ango.")
      (license license:gpl3+))))

(define-public emacs-flycheck
  (package
    (name "emacs-flycheck")
    (version "35.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/flycheck/flycheck/")
              (commit (string-append "v" version))))
       (sha256
        (base32 "1jj9w1j1qgpj3cdihwkgaj7nd714a0sgsydh413j9rsv6a3d4cgg"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (native-inputs
     (list emacs-shut-up))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'change-flycheck-version
            (lambda _
              (substitute* "flycheck.el"
                (("\\(pkg-info-version-info 'flycheck\\)")
                 (string-append "\"" #$version "\""))))))
      ;; TODO: many failing tests
      #:tests? #f
      #:test-command
      #~(list "emacs" "-Q" "--batch"
              "-L" "."
              "--load" "test/flycheck-test"
              "--load" "test/run.el"
              "-f" "flycheck-run-tests-main")))
    (home-page "https://www.flycheck.org")
    (synopsis "On-the-fly syntax checking")
    (description
     "This package provides on-the-fly syntax checking for GNU Emacs.  It is a
replacement for the older Flymake extension which is part of GNU Emacs, with
many improvements and additional features.

Flycheck provides fully-automatic, fail-safe, on-the-fly background syntax
checking for over 30 programming and markup languages with more than 70
different tools.  It highlights errors and warnings inline in the buffer, and
provides an optional IDE-like error list.")
    (license license:gpl3+)))                     ;+GFDLv1.3+ for the manual

(define-public emacs-flycheck-clj-kondo
  (let ((commit "e38c67ba9db1ea1cbe1b61ab39b506c05efdcdbf")
        (revision "1"))
    (package
      (name "emacs-flycheck-clj-kondo")
      (version (git-version "0.0.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/borkdude/flycheck-clj-kondo")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1pxlb8axgmc8cw4id40z576kd041qb1irq8rkjn6xbda585ix58f"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-flycheck))
      (home-page "https://github.com/borkdude/flycheck-clj-kondo")
      (synopsis "Add Clj-kondo linter to Flycheck")
      (description
       "This package integrates Clj-kondo with Emacs via Flycheck.")
      (license license:gpl3+))))

(define-public emacs-fb2-reader
  (let ((commit "9836db284749e0cef4c43c2cb5358c82ae9b8589")) ; version bump
    (package
      (name "emacs-fb2-reader")
      (version "0.1.1")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jumper047/fb2-reader")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0vx4b9wnmx1bng8wak5r7yryyvgib4m46l6b877xzkdhsjr3rbsi"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command
        #~(list "buttercup" "-L" ".")
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'qualify-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (let ((unzip (search-input-file inputs "/bin/unzip")))
                  (substitute* "fb2-reader.el"
                    (("unzip") unzip)))))
            (add-after 'unpack 'fix-tests
              (lambda _
                ;; Lexical binding is required for compatibility with recent
                ;; Buttercup.
                (emacs-batch-edit-file "tests/test-fb2-reader.el"
                  '(progn
                    (insert ";;; -*-lexical-binding:t -*-\n")
                    (basic-save-buffer)))
                ;; Fix bogus function name.
                (substitute* "tests/test-fb2-reader.el"
                  (("fb2-reader-render") "fb2-reader-render-xml")))))))
      (inputs (list unzip))
      (native-inputs
       (list emacs-async emacs-buttercup emacs-dash emacs-s))
      (propagated-inputs
       (list emacs-f emacs-visual-fill-column))
      (home-page "https://github.com/jumper047/fb2-reader")
      (synopsis "Emacs plugin to read FictionBook2 ebooks")
      (description "FB2 Reader provides a major mode for reading
FictionBook2 (@file{.fb2} and @file{.fb2.zip} files) ebooks.")
      (license license:gpl3+))))

(define-public emacs-flymake-clippy
  (let ((commit "713b7e873d6b30dc0ded75d5d890d6847f2ea093")
        (revision "0"))
    (package
      (name "emacs-flymake-clippy")
      (version (git-version "1.1.0" revision commit))
      (source
       (origin
         (uri (git-reference
               (url "https://git.sr.ht/~mgmarlow/flymake-clippy")
               (commit commit)))
         (method git-fetch)
         (sha256
          (base32 "097yha74kabxzyf6zqdi94wxjs7zdsg38nxwz1w4w86wxlrq0ymg"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #t
        #:phases
        #~(modify-phases %standard-phases
            (replace 'check
              (lambda* (#:key tests? #:allow-other-keys)
                (when tests?
                  (invoke "make" "test")))))))
      (synopsis "Flymake backend for Clippy")
      (description "Emacs package for displaying Clippy lint diagnostics for
Rust code.")
      (home-page "https://git.sr.ht/~mgmarlow/flymake-clippy")
      (license license:gpl3+))))

(define-public emacs-flymake-collection
  (package
    (name "emacs-flymake-collection")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mohkale/flymake-collection")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1dxy1bljvd8rar0pivdrfahmgnnjlxm0mlks8mzw3l7k7b7jar6k"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:lisp-directory "src"
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'move-checkers
            (lambda _
              ;; Move checkers to the top level, which is in the
              ;; EMACSLOADPATH.
              (for-each (lambda (f)
                          (rename-file f (basename f)))
                        (find-files "./checkers" ".*\\.el$")))))))
    (home-page "https://github.com/mohkale/flymake-collection/")
    (synopsis "Collection of checkers for Flymake")
    (description
     "This package provides a comprehensive list of diagnostic-functions for
use with Flymake, give users the tools to easily define new syntax checkers
and help selectively enable or disable diagnostic functions based on major
modes.")
    (license license:expat)))

(define-public emacs-flymake-guile
  (package
    (name "emacs-flymake-guile")
    (version "0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url
              "https://framagit.org/flymake-backends/flymake-guile.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0cb2wcn34bzj93y7s1g2b2sxv79vqihb3a5n0rhxbrddfila95hh"))))
    (build-system emacs-build-system)
    (home-page "https://framagit.org/flymake-backends/flymake-guile")
    (synopsis "GNU Guile support for Flymake")
    (description
     "This package provides a Flymake backend for GNU Guile using @code{guild
compile}.")
    (license license:gpl3+)))

(define-public emacs-flymake-perlcritic
  (let ((commit "311743e97d2f705e76755697eea9ff451a39dd64")
        (revision "1"))
    (package
      (name "emacs-flymake-perlcritic")
      (version (git-version "1.0.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/flymake/emacs-flymake-perlcritic")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "11h5jr7whwdgwq3zqi0wz9l5830qjazwinff2r8iyicp9azqf081"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~'("emacs" "--batch"
                           "--load" "ert"
                           "--load" "flymake-perlcritic.el"
                           "--load" "test/flymake-perlcritic-test.el"
                           "ert-run-tests-batch-and-exit")
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'set-command
              (lambda* (#:key inputs #:allow-other-keys)
                (emacs-substitute-variables "flymake-perlcritic.el"
                  ("flymake-perlcritic-command"
                   (search-input-file inputs "/bin/perlcritic"))))))))
      (inputs (list perl-critic))
      (home-page "https://github.com/flymake/emacs-flymake-perlcritic")
      (synopsis "Flymake handler for perlcritic")
      (description
       "Flymake Perlcritic adds support to Flymake for running Perl::Critic to
perform static analysis of Perl code.")
      (license license:gpl3+))))

(define-public emacs-flymake-popon
  (package
    (name "emacs-flymake-popon")
    (version "0.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/akib/emacs-flymake-popon")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0ljqnnl5k2f62ilahilx0ldv0spjp9hpgyikd4py1348flzq4k31"))))
    (build-system emacs-build-system)
    (propagated-inputs
      (list emacs-popon
            emacs-posframe))
    (home-page "https://codeberg.org/akib/emacs-flymake-popon")
    (synopsis "Flymake diagnostics on cursor hover")
    (description "This package shows Flymake diagnostics on cursor hover.")
    (license license:gpl3+)))

(define-public emacs-flymake-flycheck
  (package
    (name "emacs-flymake-flycheck")
    (version "20210404.2128")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://melpa.org/packages/flymake-flycheck-"
                           version ".el"))
       (sha256
        (base32 "1m59ahd5gjlfwf328labwdlpcxh8ywywkwgfrlsy5jyxfc9ss4nv"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-flycheck))
    (home-page "https://github.com/purcell/flymake-flycheck")
    (synopsis "Use Flycheck checkers as Flymake backends")
    (description
     "This package provides support for running any Flycheck checker as a
Flymake diagnostic backend.  The effect is that Flymake will control when the
checker runs, and Flymake will receive its errors.")
    (license license:gpl3+)))

(define-public emacs-flymake-quickdef
  ;; This particular commit includes bug fixes on top of 1.0.0 release.
  (let ((version "1.0.0")
        (revision "0")
        (commit "150c5839768a3d32f988f9dc08052978a68f2ad7"))
    (package
      (name "emacs-flymake-quickdef")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/karlotness/flymake-quickdef")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19gfd539l97j8xbrq1fw83b54mxbcamlz9m896088d3p01zf8b0g"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/karlotness/flymake-quickdef")
      (synopsis "Quickly define a new Flymake backend")
      (description
       "This package mainly defines a macro which helps remove some of the
boilerplate code from defining new Flymake backend functions.")
      (license license:gpl3+))))

(define-public emacs-flymake-kondor
  (package
    (name "emacs-flymake-kondor")
    (version "0.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/turbo-cafe/flymake-kondor")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vcl1q07faqqmrryyia36hbgf78g3cs51pbi0bx41yzz779ribvk"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/turbo-cafe/flymake-kondor")
    (synopsis "Linter with clj-kondo")
    (description "This package adds Clojure syntax checker clj-kondo.")
    (license license:gpl3+)))

(define-public emacs-flymake-shellcheck
  ;; No tag, version grabbed from source .el file.
  (let ((commit "ac534e9ef15c82ac86ae65fe5004d29dbc8c92c7")
        (revision "1"))
    (package
      (name "emacs-flymake-shellcheck")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/federicotdn/flymake-shellcheck")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "04yfb4sy41spjzk9mhm4gy0h8vnjx09p2g6nm1yzgd9a5ph9sqgl"))))
      (build-system emacs-build-system)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'substitute-shellcheck-path
             (lambda* (#:key inputs #:allow-other-keys)
               (make-file-writable "flymake-shellcheck.el")
               (emacs-substitute-sexps "flymake-shellcheck.el"
                 ("defcustom flymake-shellcheck-path"
                  `(or (executable-find "shellcheck")
                       ,(search-input-file inputs "bin/shellcheck")))))))))
      (inputs
       (list shellcheck))
      (home-page "https://github.com/federicotdn/flymake-shellcheck")
      (synopsis "Flymake backend for Bash/Sh powered by ShellCheck")
      (description
       "This package provides a backend for Flymake to use the
tool ShellCheck for static analyzing @command{bash} and @command{sh}
scripts.")
      (license license:gpl3+))))

(define-public emacs-a
  (package
    (name "emacs-a")
    (version "1.0.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/plexus/a.el")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32 "0zkv4xvw1jdsfxqqkxskl2l380gfs13n86hj4hhzrqf0sb6aymws"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/plexus/a.el/")
    (synopsis
     "Emacs library for dealing with association lists and hash tables")
    (description "@code{emacs-a} provides Emacs Lisp functions for dealing
with associative structures in a uniform and functional way.  These functions
can take association lists, hash tables, and in some cases vectors (where the
index is considered the key).")
    (license license:gpl3+)))

(define-public emacs-abyss-theme
  (package
    (name "emacs-abyss-theme")
    (version "0.7")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/mgrbyte/emacs-abyss-theme")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "07z0djv7h3yrv4iw9n633j6dxzxb4nnzijsqkmz22ik6fbwxg5mh"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/mgrbyte/emacs-abyss-theme")
    (synopsis "Dark theme with strong colours for Emacs")
    (description
     "A dark theme with contrasting colours for Emacs based on the
@url{https://github.com/andre-richter/emacs-lush-theme, @code{lush}} theme by
Andre Richter, using the same colours palette as the the built-in
@code{dichromacy} theme; intended to be suitable
for red/green colour blind users.")
    (license license:gpl3+)))

(define-public emacs-ace-jump-mode
  (package
    (name "emacs-ace-jump-mode")
    (version "2.0")
    (home-page "https://github.com/winterTTr/ace-jump-mode")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit (string-append "v" version))))
              (sha256
               (base32
                "1bwvzh056ls2v7y26a0s4j5mj582dmds04lx4x6iqihs04ss74bb"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (synopsis "Cursor location minor mode for fast navigation")
    (description "Ace-jump-mode is a fast/direct cursor location minor
mode.  It creates an N-Branch search tree internally and marks all
the possible position with predefined keys in within the whole Emacs
view.  This allows you to move to the character, word, or line almost
directly.")
    (license license:gpl3+)))

(define-public emacs-ahg
  ;; No tags; commit from 2021-04-12.
  (let ((commit "77bc2a628df006dcd2dc359ac12acdf8091a1356")
        (revision "0"))
    (package
      (name "emacs-ahg")
      (version (git-version "1.0.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://bitbucket.org/agriggio/ahg")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1wmvz9d40aznqh2y078v8k7n3l66m48vnf873vifi8rwg6158kqh"))))
      (build-system emacs-build-system)
      (home-page "https://bitbucket.org/agriggio/ahg")
      (synopsis "Emacs front-end for the Mercurial SCM")
      (description
       "This package provides a simple Emacs front-end for the Mercurial
Distributed @acronym{Source Control Management, SCM} system.")
      (license license:gpl3+))))

(define-public emacs-alarm-clock
  (package
    (name "emacs-alarm-clock")
    (version "1.0.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/wlemuel/alarm-clock")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0vdwvrbj79ylaz5ffa2bpfy4kzi1s6hf6bxijvyw7h8y6bd196av"))))
    (build-system emacs-build-system)
    (arguments
     (list #:include #~(cons "alarm.mp3" %default-include)
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'configure
                 (lambda* (#:key inputs #:allow-other-keys)
                   (substitute* "alarm-clock.el"
                     (("\"mpg123\"")
                      (string-append
                       "\"" (search-input-file inputs "bin/mpg123") "\""))
                     (("notify-send")
                      (search-input-file inputs "bin/notify-send"))))))))
    (inputs
     (list libnotify mpg123))
    (propagated-inputs
     (list emacs-f))
    (home-page "https://github.com/wlemuel/alarm-clock")
    (synopsis "Alarm clock for Emacs")
    (description "Alarm Clock provides an alarm clock for Emacs.")
    (license license:gpl3+)))

(define-public emacs-world-time-mode
  (let ((commit "ce7a3b45c87eb24cfe61eee453175d64f741d7cc")
        (revision "0"))
    (package
      (name "emacs-world-time-mode")
      (version (git-version "0.0.6" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/nicferrier/emacs-world-time-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0i00xm4rynbp2v3gm6h46ajgj8h8nxnsjh6db1659b0hbpnah0ji"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/nicferrier/emacs-world-time-mode")
      (synopsis "Show whole days of world time")
      (description "@code{emacs-world-time-mode} shows time zones in your
@code{display-time-world-list} formatted as a list of whole days with the
differing times.")
      (license license:gpl3+))))

(define-public emacs-anaphora
  (package
    (name "emacs-anaphora")
    (version "1.0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rolandwalker/anaphora")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "11fgiy029sqz7nvdm7dcal95lacryz9zql0x5h05z48nrrcl4bib"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "ert-runner" ".")
                     #:tests? #f))      ; 18 unexpected results
    (native-inputs (list emacs-ert-runner))
    (home-page "https://github.com/rolandwalker/anaphora/")
    (synopsis "Anaphoric expressions for Emacs Lisp")
    (description "@code{emacs-anaphora} implements anaphoric expressions for
Emacs Lisp.

Anaphoric expressions implicitly create one or more temporary variables which
can be referred to during the expression.  This technique can improve clarity
in certain cases.  It also enables recursion for anonymous functions.")
    (license license:public-domain)))

(define-public emacs-xah-fly-keys
  (let ((commit "e81f8143e9f7b8e55fa549ec6113048e4959b96e"))
    (package
      (name "emacs-xah-fly-keys")
      (version "24.19.20231204080156")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/xahlee/xah-fly-keys")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1pnq4p5y0h7d3nj3vcsdfccc0aahdvcgskik337z6k7hmb32xz48"))))
      (build-system emacs-build-system)
      (home-page "http://xahlee.info/emacs/misc/ergoemacs_vi_mode.html")
      (synopsis "Modal keybinding system for Emacs, based on command frequency and
ergonomics")
      (description "xah-fly-keys.el is a modal editing mode for Emacs, like Vi,
but the design of key/command choice is based on command frequency statistics
and ease-of-key score.  Most frequently used commands have most easy keys.")
      (license license:gpl3))))

(define-public emacs-xr
  (package
    (name "emacs-xr")
    (version "2.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/xr-" version ".tar"))
       (sha256
        (base32 "1yssl7av2rpanzmm93iw74acnb3pbrnh0b51kr64wcj6hwb26cy2"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/xr.html")
    (synopsis "Convert string regexp to rx notation")
    (description
     "This is an inverse companion to the @code{rx} package for translating
regexps in string form to the @code{rx} notation.  Its chief uses are:

@itemize
@item Migrating existing code to @code{rx} form, for better readability and
maintainability
@item Understanding complex regexp strings and finding errors in them
@end itemize

In addition to Emacs regexps, this package can also parse and troubleshoot
skip set strings, which are arguments to @code{skip-chars-forward} and
@code{skip-chars-backward}.")
    (license license:gpl3+)))

(define-public emacs-ample-regexps
  (let ((commit "153969ce547afe410b8986f01c9ed4087c9cd20b")
        (revision "2"))
    (package
      (name "emacs-ample-regexps")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/immerrr/ample-regexps.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0dkp7bcd7h2ds40wyszy11nmh7c2jxrwy04ayz7pbxh53ir7s2k0"))))
      (build-system emacs-build-system)
      (native-inputs
       (list emacs-ert-runner))
      (arguments
       `(#:test-command '("ert-runner" "-l" "ample-regexps")))
      (home-page "https://github.com/immerrr/ample-regexps.el")
      (synopsis "Compose and reuse Emacs regexps")
      (description
       "This package allows common parts of regexps to be easily picked out
and reused.")
      (license license:gpl3+))))

(define-public emacs-airline-themes
  (package
    (name "emacs-airline-themes")
    (version "1.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/AnthonyDiGirolamo/airline-themes")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jx17g8a6pxkw4zlx3fwhqgxfzcf3019k8fklykamfrkharzsc2l"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-powerline))
    (home-page "https://github.com/AnthonyDiGirolamo/airline-themes")
    (synopsis "Vim-airline themes for Emacs Powerline")
    (description
     "This is a port of the themes in Vim-airline to Emacs Powerline.")
    (license license:expat)))

(define-public emacs-ample-theme
  (let ((commit "536966adf882446165a1f756830028faa792c7a9")
        (revision "1"))
    (package
      (name "emacs-ample-theme")
      (version (git-version "0.0.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jordonbiondo/ample-theme")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "07bpv8dag40qjnm5000pgzpazj4whfxf93x2vprz26sg3mjfx0nf"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/jordonbiondo/ample-theme")
      (synopsis "Theme for Emacs providing dark, light, and flat versions")
      (description "Ample themes is a collection of three themes sharing a
similar pallet with a light, dark and flat versions with a focus on being easy
on the eyes during night and day.  They only support GUI and 256 colour
terminals.")
      (license license:gpl3+))))

(define-public emacs-rbs-mode
  (package
    (name "emacs-rbs-mode")
    (version "0.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ybiquitous/rbs-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ibn8246q0yqdnf3qdww9rvzac9gla7gzjj0n5j5x08brgj5ll2h"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ybiquitous/rbs-mode")
    (synopsis "Major mode for Ruby type signature")
    (description
     "RBS mode is a major mode for Ruby type signature language (RBS).  It
provides basic supports for syntax highlighting and indentation.")
    (license license:gpl3+)))

(define-public emacs-reformatter
  (package
    (name "emacs-reformatter")
    (version "0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/reformatter.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vm030lz489vjx1dz1jrnj7zd2b43y98rffdxyshfvxbfv1cbmyk"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f        ; XXX: 4/4 tests broken
                     #:test-command #~(list "make" "test" "INIT_PACKAGES=t")))
    (home-page "https://github.com/purcell/reformatter.el")
    (synopsis "Define commands which run reformatters on the current buffer")
    (description
     "This library lets elisp authors easily define an idiomatic command to
reformat the current buffer using a command-line program, together with an
optional minor mode which can apply this command automatically on save.")
    (license license:gpl3+)))

(define-public emacs-rescript-mode
  (let ((commit "b9dda43cc52cd4a9b384c59fb0cc7a11f0bad230")
        (revision "0"))
    (package
      (name "emacs-rescript-mode")
      (version (git-version "0.1.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jjlee/rescript-mode")
                      (commit commit)))
                (sha256
                 (base32
                  "00pjn683zl5rcmwf86gs4ikxzz82d3rpmicpxhgy2m2xyrfxpz89"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "ert-runner")))
      (native-inputs
       (list emacs-ert-runner))
      (home-page "https://github.com/jjlee/rescript-mode")
      (synopsis "Major mode for editing ReScript")
      (description "This package provides a major mode for editing ReScript source code.")
      (license license:gpl3))))

(define-public emacs-language-id
  (package
    (name "emacs-language-id")
    (version "0.20")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/lassik/emacs-language-id.git")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "153810jq4rbgpzvbhz2i1dyrj8bmdf4zxsrhfg0b70iq4bh78bz6"))))
    (build-system emacs-build-system)
    (synopsis "Identify programming language used in Emacs buffers")
    (description "This package provides a way for Emacs to identify the
programming language used in an Emacs buffer.")
    (home-page "https://github.com/lassik/emacs-language-id")
    (license license:isc)))

(define-public emacs-format-all-the-code
  (package
    (name "emacs-format-all-the-code")
    (version "0.6.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/lassik/emacs-format-all-the-code.git")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1p8bh96yksbpajx2pqxjc4vf7nfncwc3mvh1fcj8afw53g72is8m"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-inheritenv emacs-language-id))
    (synopsis "Auto-format any source code")
    (description "This package lets you auto-format source code in many
languages using the same command for all languages, instead of learning
a different Emacs package and formatting command for each language.
Over 70 languages are supported, including Emacs Lisp, Kotlin, Go and
Rust.")
    (home-page "https://github.com/lassik/emacs-format-all-the-code")
    (license license:expat)))

(define-public emacs-relative-buffers
  (let ((release "0.0.1")
        (revision "0")
        (commit "9762fe268e9ff150dcec2e2e45d862d82d5c4008"))
    (package
      (name "emacs-relative-buffers")
      (version (git-version release revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsattic/relative-buffers")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0fzhwbpyndwrmxip9zlcwkrr675l5pzwcygi45hv7w1hn39w0hxp"))
         (snippet
          '(begin
             ;; Delete the Cask test runners.
             (for-each delete-file '("Cask" "test/test-helper.el"))))))
      (build-system emacs-build-system)
      (native-inputs
       (list emacs-ert-runner))
      (propagated-inputs
       (list emacs-dash emacs-f emacs-s))
      (home-page "https://github.com/emacsattic/relative-buffers")
      (synopsis "Minor mode to rename buffers by project structure")
      (description
       "This package provides a minor mode for renaming buffers according to
project structure.  For Python buffers, that will be the whole module name.
For temporary files and directories, that will be the relative path from the
project root.")
      (license license:gpl3+))))

(define-public emacs-relint
  (package
    (name "emacs-relint")
    (version "2.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "relint-" version ".tar"))
       (sha256
        (base32 "0ikml87y0k85qd92m3l1gkzjd9ng3mhjfk19w15ln0w801351cq0"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-xr))
    (home-page "https://github.com/mattiase/relint")
    (synopsis "Elisp regexp mistake finder")
    (description
     "Relint (regular expression lint) scans Elisp files for mistakes in
regexps, including deprecated syntax and bad practice.  It also checks the
regexp-like arguments to @code{skip-chars-forward} and
@code{skip-chars-backward}.")
    (license license:gpl3+)))

(define-public emacs-bug-hunter
  (let ((commit "b88d981afa9154b236c5a3a83b50d5889d46c6a7")
        (revision "1"))
    (package
      (name "emacs-bug-hunter")
      (version (git-version "1.3.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Malabarba/elisp-bug-hunter")
               (commit commit)))
         (file-name (git-file-name name commit))
         (sha256
          (base32
           "134fj493sdn93pyyac8rpz1fzahzmayvphsrmqp3wvgysmfqm38l"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/Malabarba/elisp-bug-hunter")
      (synopsis "Hunt down errors by bisecting elisp files")
      (description
       "The Bug Hunter is an Emacs library that finds the source of an error
or unexpected behavior inside an elisp configuration file (typically
@file{init.el} or @file{.emacs}).")
      (license license:gpl3+))))

(define-public emacs-w3m
  ;; Emacs-w3m follows a "rolling release" model.
  (package
    (name "emacs-w3m")
    (version "20220508.2259")
    (source (origin
              ;; "Officially" this is still on cvs.namazu.org, but that repo
              ;; seems to be unreachable.
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacs-w3m/emacs-w3m.git")
                    (commit "bbcebbe20ebfa807a3e4beaadf40ce6f4be213e7")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0y892n8jaxzyxi1fgyklc7zfh57ibp4yyywmif69dm28hykj6lmz"))))
    (build-system gnu-build-system)
    (native-inputs (list autoconf texinfo emacs-minimal))
    (inputs (list w3m imagemagick))
    (arguments
     (list
      #:modules '((guix build gnu-build-system)
                  ((guix build emacs-build-system) #:prefix emacs:)
                  (guix build utils)
                  (guix build emacs-utils))
      #:imported-modules `(,@%default-gnu-imported-modules
                           (guix build emacs-build-system)
                           (guix build emacs-utils))
      #:configure-flags
      #~(list (string-append "--with-lispdir=" (emacs:elpa-directory #$output))
              (string-append "--with-icondir="
                             #$output "/share/images/emacs-w3m")
              ;; Leave .el files uncompressed, otherwise GC can't
              ;; identify run-time dependencies.  See
              ;; <http://lists.gnu.org/archive/html/guix-devel/2015-12/msg00208.html>
              "--without-compress-install")
      #:tests? #f                       ; no check target
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'autoconf
            (lambda _
              (invoke "autoconf")))
          (add-before 'configure 'support-emacs!
            (lambda _
              ;; For some reason 'AC_PATH_EMACS' thinks that 'Emacs 26' is
              ;; unsupported.
              (substitute* "configure"
                (("EMACS_FLAVOR=unsupported") "EMACS_FLAVOR=emacs"))))
          (add-before 'build 'patch-exec-paths
            (lambda* (#:key inputs #:allow-other-keys)
              (make-file-writable "w3m.el")
              (emacs-substitute-variables "w3m.el"
                ("w3m-command" (search-input-file inputs "/bin/w3m"))
                ("w3m-touch-command" (search-input-file inputs "/bin/touch"))
                ("w3m-icon-directory"
                 (string-append #$output "/share/images/emacs-w3m")))
              (make-file-writable "w3m-image.el")
              (emacs-substitute-variables "w3m-image.el"
                ("w3m-imagick-convert-program"
                 (search-input-file inputs "/bin/convert"))
                ("w3m-imagick-identify-program"
                 (search-input-file inputs "/bin/identify")))))
          (replace 'install
            (lambda _
              (invoke "make" "install" "install-icons")
              (with-directory-excursion (emacs:elpa-directory #$output)
                (for-each delete-file '("ChangeLog" "ChangeLog.1"))
                (symlink "w3m-load.el" "w3m-autoloads.el")))))))
    (home-page "http://emacs-w3m.namazu.org/")
    (synopsis "Simple Web browser for Emacs based on w3m")
    (description
     "Emacs-w3m is an emacs interface for the w3m web browser.")
    (license license:gpl2+)))

(define-public emacs-wget
  (package
    (name "emacs-wget")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "mirror://debian/pool/main/w/wget-el/wget-el_"
                           version ".orig.tar.gz"))
       (sha256
        (base32 "10byvyv9dk0ib55gfqm7bcpxmx2qbih1jd03gmihrppr2mn52nff"))))
    (build-system emacs-build-system)
    (inputs (list wget))
    (native-inputs
     (list emacs-minimal))
    (arguments
     `(#:tests? #f                      ;no check target
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-exec-paths
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (emacs-substitute-variables "wget.el"
               ("wget-command" (search-input-file inputs "/bin/wget"))))))))
    (home-page "https://www.emacswiki.org/emacs/EmacsWget")
    (synopsis "Simple file downloader for Emacs based on wget")
    (description
     "Emacs-wget is an emacs interface for the wget file downloader.")
    (license license:gpl2+)))

(define-public emacs-eww-lnum
  (package
    (name "emacs-eww-lnum")
    (version "1.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/m00natic/eww-lnum")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0gs6bi3s2sszc6v2b26929azmn5513kvyin99n4d0ark1jdbjmv2"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/m00natic/eww-lnum")
    (synopsis "Conkeror-like functionality for Eww")
    (description "This is extension to the Emacs browser Eww that adds
Conkeror-like functionality.  In short, currently visible links, forms,
buttons are temporarily assigned numbers with which the former can be
immediately activated.  Also filtering can be applied so selection can be
incrementally confined in Isearch manner.")
    (license license:gpl3+)))

(define-public emacs-dnt
  (let ((commit "d28d232d682094ab79cfa78c97668c6ebd327c8c")
        (revision "1"))
    (package
      (name "emacs-dnt")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/emacs-weirdware/dnt.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1bls9j1ibw0npjapslbrh6nmlbn3d4ajhjygsqlf6h9qg12sxm3r"))))
      (propagated-inputs (list emacs-s))
      (build-system emacs-build-system)
      (home-page "https://codeberg.org/emacs-weirdware/dnt")
      (synopsis "Strip trackers from URLs")
      (description "This package provides a series of rules and helper functions
to prevent advertisers from tracking you when you open URLs (or listen to
podcasts) in Emacs.")
      (license (list license:gpl3+)))))

(define emacs-emms-print-metadata
  (package
    (name "emacs-emms-print-metadata")
    (version "24")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.savannah.gnu.org/git/emms/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1x0lja7k2vn3dhnmhg3gvhiv6yid899k26f79c7slwfs0sl680yc"))))
    (build-system gnu-build-system)
    (arguments
     (list
      #:make-flags #~(list "emms-print-metadata")
      #:tests? #f                       ; No tests.
      #:phases
      #~(modify-phases %standard-phases
          (delete 'configure)
          (replace 'install
            (lambda _
              (install-file "src/emms-print-metadata"
                            (string-append #$output "/bin"))
              (install-file "emms-print-metadata.1"
                            (string-append #$output "/share/man/man1")))))))
    (inputs
     (list taglib))
    (home-page "https://www.gnu.org/software/emms/")
    (synopsis "The Emacs Multimedia System")
    (description
     "EMMS is the Emacs Multimedia System.  It is a small front-end which
can control one of the supported external players.  Thus, it supports
whatever formats are supported by your music player.  It also
supports tagging and playlist management, all behind a clean and
light user interface.")
    (license license:gpl3+)))

(define-public emacs-emms
  (package
    (inherit emacs-emms-print-metadata)
    (name "emacs-emms")
    (build-system emacs-build-system)
    (arguments
     `(#:test-command
       (list "emacs" "-Q" "--batch"
             "--eval=(cd \"test/\")"
             "-l" "emms-tests.el"
             "-l" "emms-info-native-tests.el"
             "-l" "emms-info-native-ogg-tests.el"
             "-l" "emms-info-native-mp3-tests.el"
             "-l" "emms-info-native-flac-tests.el"
             "-l" "emms-info-native-vorbis-tests.el"
             "-f" "ert-run-tests-batch-and-exit")
       #:phases
       (modify-phases %standard-phases
         (add-before 'install 'make-info
           (lambda _
             (invoke "make" "-C" "doc" "all")
             (rename-file "doc/emms.info" "emms.info")))
         (add-after 'unpack 'set-external-programs
           ;; Specify the absolute file names of the various programs
           ;; so that everything works out-of-the-box. (tinytag missing)
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((amixer (search-input-file inputs "/bin/amixer"))
                   (emms-print-metadata
                    (search-input-file inputs "/bin/emms-print-metadata"))
                   (exiftool (search-input-file inputs "/bin/exiftool"))
                   (metaflac (search-input-file inputs "/bin/metaflac"))
                   (mp3info (search-input-file inputs "/bin/mp3info"))
                   (mpg321 (search-input-file inputs "/bin/mpg321"))
                   (mid3v2 (search-input-file inputs "/bin/mid3v2"))
                   (ogg123 (search-input-file inputs "/bin/ogg123"))
                   (ogginfo (search-input-file inputs "/bin/ogginfo"))
                   (opusinfo (search-input-file inputs "/bin/opusinfo"))
                   (vorbiscomment (search-input-file inputs "/bin/vorbiscomment")))
               (emacs-substitute-variables "emms-player-mpg321-remote.el"
                 ("emms-player-mpg321-remote-command"
                  (string-append mpg321 "/bin/mpg321")))
               (substitute* "emms-player-simple.el"
                 (("\"ogg123\"") (string-append "\"" ogg123 "\"")))
               (substitute* "emms-player-simple.el"
                 (("\"mpg321\"") (string-append "\"" mpg321 "\"")))
               (emacs-substitute-variables "emms-info-ogginfo.el"
                 ("emms-info-ogginfo-program-name" ogginfo))
               (emacs-substitute-variables "emms-info-opusinfo.el"
                 ("emms-info-opusinfo-program-name" opusinfo))
               (emacs-substitute-variables "emms-info-libtag.el"
                 ("emms-info-libtag-program-name" emms-print-metadata))
               (emacs-substitute-variables "emms-info-mp3info.el"
                 ("emms-info-mp3info-program-name" mp3info))
               (emacs-substitute-variables "emms-info-metaflac.el"
                 ("emms-info-metaflac-program-name" metaflac))
               (emacs-substitute-variables "emms-source-file.el"
                 ("emms-source-file-gnu-find" (which "find")))
               (substitute* "emms-volume-amixer.el"
                 (("\"amixer\"") (string-append "\"" amixer "\"")))
               (substitute* "emms-tag-editor.el"
                 (("\"mid3v2\"") (string-append "\"" mid3v2 "\""))
                 (("\"vorbiscomment\"")
                  (string-append "\"" vorbiscomment "\"")))
               (substitute* "emms-info-exiftool.el"
                 (("\"exiftool\"") (string-append "\"" exiftool "\"")))))))))
    (inputs
     (list emacs-emms-print-metadata
           alsa-utils
           flac                         ;for metaflac
           vorbis-tools
           mpg321
           mp3info
           python-mutagen
           perl-image-exiftool
           opus-tools))
    (native-inputs (list emacs-ert-runner texinfo))))

(define-public emacs-emms-mode-line-cycle
  (package
    (name "emacs-emms-mode-line-cycle")
    (version "0.2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/momomo5717/emms-mode-line-cycle")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0q80f0plch6k4lhs8c9qm3mfycfbp3kn5sjrk9zxgxwnn901y9mp"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-emms))
    (home-page "https://github.com/momomo5717/emms-mode-line-cycle")
    (synopsis "Display the EMMS mode line as a ticker")
    (description
     "This is a minor mode for updating the EMMS mode-line string cyclically
within a specified width.  It is useful for displaying long track titles.")
    (license license:gpl3+)))

(define-public emacs-mediainfo-mode
  (package
    (name "emacs-mediainfo-mode")
    (version "0.2.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                     (url "https://github.com/xFA25E/mediainfo-mode.git")
                     (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1jvbwisjb8927mmqavp9x1054lpm3wljja9k4jwqwbnkydf6vn3d"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list mediainfo ffmpeg imagemagick))
    (synopsis "mediainfo mode")
    (description "This package provides a major mode that shows metadata of
media files.")
    (home-page "https://github.com/xFA25E/mediainfo-mode")
    (license license:gpl3+)))

(define-public emacs-emprise
  (package
    (name "emacs-emprise")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~plattfot/emprise")
             (commit (string-append "v" version))))
       (sha256
        (base32
         "0yddvvpjdcgsiwv24jbddkgl5r1lxgz037akjln6z9acx9qrc8px"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (home-page "https://sr.ht/~plattfot/emprise")
    (synopsis "Control MPRIS supported media players from Emacs")
    (description "This package provides a set of commands to control media
players that supports the Media Player Remote Interfacing
Specification (MPRIS) protocol from Emacs.  It uses Emacs' Completing Read
framework as the user interface, which integrates well with Vertico or
Selectrum.")
    (license license:gpl3+)))

(define-public emacs-empv
  (package
    (name "emacs-empv")
    (version "5.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/isamert/empv.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0in9yyssahrp0qfbwziymg85bmysxlzr58vycb13k4m4g9i4s3r7"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   (add-after 'unpack 'set-default-binaries
                     (lambda* (#:key inputs #:allow-other-keys)
                       (emacs-substitute-variables "empv.el"
                         ("empv-fd-binary" (search-input-file inputs "/bin/fd"))
                         ("empv-mpv-binary" (search-input-file inputs "/bin/mpv"))))))))
    (inputs (list fd mpv))
    (propagated-inputs (list emacs-compat emacs-consult emacs-s))
    (home-page "https://github.com/isamert/empv.el")
    (synopsis
     "Emacs multimedia player, media library manager, YouTube frontend")
    (description
     "This package is an Emacs multimedia player based on mpv.  It offers
a comprehensive interface to mpv, including convenient features such as an
embedded radio manager, YouTube integration, and a local music and video
library manager.")
    (license license:gpl3+)))

(define-public emacs-marginalia-emprise
  (package
    (name "emacs-marginalia-emprise")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~plattfot/marginalia-emprise")
             (commit (string-append "v" version))))
       (sha256
        (base32
         "1kbk3kgvv1k5zdysvpgcsbxiwn4la3vvnmv3sbzxq7q5v5cr4a54"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-emprise emacs-marginalia))
    (home-page "https://sr.ht/~plattfot/emprise/")
    (synopsis "Annotate Emprise with Marginalia")
    (description "This package provides an annotation function to show
playback status, artist name and title for Emprise using Marginalia.")
    (license license:gpl3+)))

(define-public emacs-eradio
  (let ((commit "47769986c79def84307921f0277e9bb2714756c2")
        (revision "0"))
    (package
      (name "emacs-eradio")
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/olavfosse/eradio")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0lks2pph44qxc9l34nr55ha667974r8ckxdwmvcp6v9mnm05317s"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/olavfosse/eradio")
      (synopsis "Simple radio player for GNU Emacs")
      (description
       "Eradio is a simple internet radio player for Emacs.  Start, stop or
toggle custom-defined channels.  An external media player like mpv or VLC is
required.")
      (license license:gpl3+))))

(define-public emacs-ace-link
  (package
    (name "emacs-ace-link")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/abo-abo/ace-link")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "147dz79vg4ym5wg3d544bw2khdb2j3hr73rw4qfm64wf0q2dj0vk"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs
     (list emacs-avy))
    (home-page "https://github.com/abo-abo/ace-link")
    (synopsis "Quickly follow links in Emacs")
    (description
     "Currently, to jump to a link in a @code{Info-mode}, @code{help-mode},
@code{woman-mode}, @code{org-mode}, @code{eww-mode}, @code{compilation-mode},
@code{goto-address-mode} buffer, you can tab through the links to select the
one you want.  This is an O(N) operation, where the N is the amount of links.
This package turns this into an O(1) operation.  It does so by assigning a
letter to each link using avy.")
    (license license:gpl3+)))

(define-public emacs-app-launcher
  ;; XXX: Upstream did not tag any commit so far.  Base version is extracted
  ;; from Version keyword.
  (let ((commit "d5015e394b0a666a8c7c4d4bdf786266e773b145")
        (revision "0"))
    (package
      (name "emacs-app-launcher")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/SebastienWae/app-launcher")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0l97ajy27awydyd4gc6323wyhpm5vm2db6i0lp5gqaxi9fp7jivp"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/SebastienWae/app-launcher")
      (synopsis "Use Emacs standard completion to launch applications")
      (description "This package defines the @code{app-launcher-run-app}
command, which uses Emacs standard completion to select an application
installed on your machine and launch it.")
      (license license:gpl3+))))

(define-public emacs-alchemist
  (package
    (name "emacs-alchemist")
    (version "1.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://stable.melpa.org/packages/"
                           "alchemist-" version ".tar"))
       (sha256
        (base32 "0ygwf9d739zqc8dcckw0j0bqkipw7cmxbrx3l281x237a3d384yw"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-elixir-mode emacs-dash emacs-company emacs-pkg-info))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'install-server
            (lambda _
              (let ((server (string-append (elpa-directory #$output)
                                           "/alchemist-server")))
                (mkdir-p server)
                (copy-recursively "alchemist-server" server)
                (delete-file-recursively (string-append server "/test"))))))))
    (home-page "https://www.github.com/tonini/alchemist.el")
    (synopsis "Elixir tooling integration into Emacs")
    (description
     "This package brings you all the Elixir tooling and power inside your Emacs
editor.  It comes with commands to compile, execute and test your code, spawn
an interactive shell, and look up definitions and documentation as well as
code completion and project management support.")
    (license license:gpl3+)))

(define-public emacs-auto-compile
  (package
    (name "emacs-auto-compile")
    (version "2.1.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacscollective/auto-compile")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "12knl2m3zww2ayl4fmpvwdjpd0qjfzlfmjslb0r6pfkwj7ixy1da"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs (list emacs-compat emacs-packed))
    (home-page "https://github.com/emacscollective/auto-compile")
    (synopsis "Automatically compile Emacs Lisp libraries")
    (description
     "This package provides two minor modes which automatically recompile
Emacs Lisp source files.  Together, these modes guarantee that Emacs never
loads outdated byte code files.")
    (license license:gpl3+)))

(define-public emacs-compile-angel
  (package
    (name "emacs-compile-angel")
    (version "1.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jamescherti/compile-angel.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0c5n6qwjjv3wn2cdmh31zgpwzz3vkdq2jmzyals7h2ag1s7cxq4r"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'set-home
            (lambda _ (setenv "HOME" (getenv  "TMPDIR")))))
      #:test-command
      #~(list "emacs" "-Q" "-batch"
              "-L" "."
              "-l" "tests/test-compile-angel.el"
              "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/jamescherti/compile-angel.el/")
    (synopsis "Automatically byte/native-compile all Elisp files")
    (description
     "This package speeds up Emacs by ensuring that all Elisp libraries are
both byte-compiled and native-compiled.")
    (license license:gpl3+)))

(define-public emacs-auto-sudoedit
  (package
    (name "emacs-auto-sudoedit")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ncaq/auto-sudoedit")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1rhdvrj2rjbvl7vkb0wcp6krqxcaigl7jk9z8yvhx6s4cm2qli6q"))))
    (propagated-inputs
     (list emacs-f))
    (build-system emacs-build-system)
    (home-page "https://github.com/ncaq/auto-sudoedit")
    (synopsis "Automatically re-open read-only files with sudo")
    (description
     "This package automatically reopens a file or directory with
@command{sudo} if it cannot write to it.")
    (license license:expat)))

(define-public emacs-read-only-cfg
  ;; XXX: Upstream has no tagged release.  Version is extracted from keyword
  ;; in main file.
  (let ((commit "c128c9412f768adf89ff5c4ad433cf0beab6656a")
        (revision "0"))
    (package
      (name "emacs-read-only-cfg")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pfchen/read-only-cfg")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "11zj4ysmacvz82j1siqlcp30i05my20lscls8wkdjl75g9d2b12l"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/pfchen/read-only-cfg")
      (synopsis "Make files read-only based on user configuration")
      (description
       "Read-only-cfg is an Emacs minor mode that can automatically make files
read-only based on user configuration.  User configuration may be prefix
directories or regex patterns.")
      (license license:gpl3+))))

;; Use latest commit since there are no tags anymore for several versions
(define-public emacs-rebecca-theme
  (let ((commit "4b8b5aae9099185e07c2b4cac4943c7f66a3f003")
        (revision "0"))
    (package
      (name "emacs-rebecca-theme")
      (version (git-version "1.3.2" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/vic/rebecca-theme")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0y2kcs6zgi3dijagyz6lxbv6gi2mih8m943fhjrzkj35wfvjmhsz"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/vic/rebecca-theme")
      (synopsis "Dark Emacs theme with purple/violet colors")
      (description
       "Rebecca Emacs theme is a dark theme with purple/violet colors, based on
the @code{Dracula} theme for Emacs and the @code{Gloom} theme for Atom.")
      (license license:expat))))

(define-public emacs-reverso
  (let ((commit "40ed3d83c4f04c39e05d69d84595761ae2956a64")
        (revision "1"))
    (package
      (name "emacs-reverso")
      (version (git-version "0.1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/SqrtMinusOne/reverso.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1agsscrkqnmz8shibfy8df5f34xwixiyfad381k04aibadh742yb"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))      ; no tests
      (propagated-inputs (list emacs-request))
      (home-page "https://github.com/SqrtMinusOne/reverso.el")
      (synopsis "Translation, grammar checking, context search")
      (description "Reverso is an emacs client for the reverso.net service.")
      (license license:gpl3+))))

(define-public emacs-bbdb
  (package
    (name "emacs-bbdb")
    (version "3.2.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "bbdb-" version ".tar"))
       (sha256
        (base32 "13i8ggknc29sny16rq126q0ssz26m3fam0zpdhlsm05pa8dydd7p"))))
    (build-system emacs-build-system)
    (arguments
     ;; XXX: The following file cannot be byte-compiled, because et requires
     ;; `vm-autoloads', from the VM package, with is neither in Emacs nor
     ;; packaged in Guix.  So, don't bother for now.
     `(#:exclude '("bbdb-vm\\.el")))
    (inputs (list emacs-notmuch))
    (home-page "https://elpa.gnu.org/packages/bbdb.html")
    (synopsis "Contact management utility for Emacs")
    (description
     "BBDB is the Insidious Big Brother Database for GNU Emacs.  It provides
an address book for email and snail mail addresses, phone numbers and the
like.  It can be linked with various Emacs mail clients (Message and Mail
mode, Rmail, Gnus, MH-E, and VM).  BBDB is fully customizable.")
    (license license:gpl3+)))

(define-public emacs-bbdb-vcard
  ;; No release since Dec 1, 2013.
  (let ((version "0.4.1") ;3d79fdb4200a64a043e203a3baac95c936095b52, not tagged
        (revision "88")
        (commit "113c66115ce68316e209f51ebce56de8dded3606"))
    (package
      (name "emacs-bbdb-vcard")
      (version (git-version version revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/tohojo/bbdb-vcard")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1sr5kd2gvw1b4hl147yb60cgx6j730vdnpyr09p7vmpw65hzwlwm"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "make" "test")
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'patch-tests
              (lambda _
                (substitute* "Makefile"
                  (("test: \\$\\(ELCS\\)")
                   "test:"))
                ;; FIXME Unclear why these tests fail.
                (substitute* "bbdb-vcard-tests.el"
                  (("\\(ert-deftest bbdb-vcard-test-(bad-1|rfc2426) .*" all)
                   (string-append all "(skip-unless nil)"))))))))
      (native-inputs (list which))
      (propagated-inputs (list emacs-bbdb))
      (home-page "https://github.com/tohojo/bbdb-vcard")
      (synopsis
       "The Insidious Big Brother Database (BBDB) vCard Import and Export")
      (description
       "@code{bbdb-vcard.el} imports and exports vCards (version 3.0) as
defined in RFC 2425 and RFC 2426 to/from The Insidious Big Brother Database
(BBDB).  Version 2.1 vCards are converted into version 3.0 on import.")
      (license license:gpl2+))))

(define-public emacs-eweouz
  (package
    (name "emacs-eweouz")
    (version "0.12")
    (source
     (origin
       (method url-fetch)
       ;; README's git://git.err.no/eweouz is gone
       (uri (string-append "mirror://debian/pool/main/e/eweouz/"
                           "eweouz_" version ".tar.xz"))
       (file-name (string-append name "-" version ".tar.xz"))
       (sha256
        (base32
         "192zl3dyphhvcrvn65bqsrc4h6zks8b747lp6pqbpbmsqy4g4mr8"))))
    (build-system gnu-build-system)
    (arguments
     (list
      #:modules '((guix build gnu-build-system)
                  ((guix build emacs-build-system) #:prefix emacs:)
                  (guix build utils)
                  (guix build emacs-utils))
      #:imported-modules `(,@%default-gnu-imported-modules
                           (guix build emacs-build-system)
                           (guix build emacs-utils))
      #:configure-flags
      #~(list (string-append "--with-lispdir="
                             (emacs:elpa-directory #$output)))
      #:phases
      #~(modify-phases %standard-phases
          (replace 'bootstrap
            (lambda _ (invoke "autoreconf" "-vif")))
          (add-after 'compress-documentation 'enter-lisp-dir
            (lambda _ (chdir "lisp/")))
          (add-after 'enter-lisp-dir 'emacs-patch-variables
            (lambda _
              (emacs-substitute-sexps "eweouz.el"
                ("eweouz-helper-dirs"
                 `(list ,(string-append #$output "/libexec/eweouz"))))))
          (add-after 'enter-lisp-dir 'emacs-make-autoloads
            (assoc-ref emacs:%standard-phases 'make-autoloads))
          (add-after 'emacs-patch-variables 'emacs-expand-load-path
            (assoc-ref emacs:%standard-phases 'expand-load-path))
          (add-after 'emacs-expand-load-path 'emacs-add-install-to-native-load-path
            (assoc-ref emacs:%standard-phases 'add-install-to-native-load-path))
          (add-after 'emacs-add-install-to-native-load-path 'emacs-install
            (assoc-ref emacs:%standard-phases 'install))
          (add-after 'emacs-install 'emacs-build
            (assoc-ref emacs:%standard-phases 'build)))))
    (native-inputs
     (list autoconf
           automake
           emacs-minimal
           pkg-config))
    (inputs
     (list evolution-data-server))
    (home-page "https://tracker.debian.org/pkg/eweouz")
    (synopsis "Emacs interface to Evolution Data Server")
    (description
     "Eweouz is an tool for looking up contacts from Evolution Data Server
from Emacs.  It is similar to BBDB, except much, much simpler.")
    ;; Most things are GPLv2-only although lisp/vcard.el is GPLv2+.
    (license (list license:gpl2 license:gpl2+))))

(define-public emacs-beacon
  (package
    (name "emacs-beacon")
    (version "1.3.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Malabarba/beacon")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0mypzfasclq7bmw0i8hfyp8c1ycd3kdgd5h1faygzh9r0phh7ciy"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Malabarba/beacon")
    (synopsis "Emacs minor mode creating a light that follows your cursor around")
    (description
     "Beacon is an Emacs minor-mode.  Whenever the window scrolls a light will
shine on top of your cursor so you know where it is.")
    (license license:gpl3+)))

(define-public emacs-bar-cursor
  (let ((revision "0")
        (commit "78f195b6db63459033c4f1c7e7add5d82f3ce424"))
    (package
      (name "emacs-bar-cursor")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/ajsquared/bar-cursor.git")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1g344fzfkq5z53vja68kv55l1x29v15q41qb08nqc9k4pvpwdvmp"))))
      (build-system emacs-build-system)
      (synopsis "Bar cursor shape")
      (description "This package provides a bar cursor shape.  When in
overwrite mode, it will turn into a block cursor.")
      (home-page "https://github.com/ajsquared/bar-cursor")
      (license license:gpl2+))))

(define-public emacs-paradox
  (let ((commit "96401577ed02f433debe7604e49afd478e9eda61")) ;version bump
    (package
      (name "emacs-paradox")
      (version "2.5.5")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Malabarba/paradox")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0v9hmvq6bcr2hwlb09ldsd6pjl19ri5n2hl2bs3x52fqjj6fdzzn"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-hydra emacs-let-alist emacs-spinner))
      (native-inputs (list emacs-ert-runner emacs-undercover))
      (home-page "https://github.com/Malabarba/paradox")
      (synopsis "Paradox is an extension to Emacs packages menu")
      (description
       "Paradox is a project for modernizing Emacs' Package menu.  It provides
improved appearance, mode-line information, GitHub integration,
customizability and asynchronous upgrading.")
      (license license:gpl2+))))

(define-public emacs-carp
  (let ((commit "17d3d84963434233997626850195f205882bf0df")
        (revision "0"))
    (package
      (name "emacs-carp")
      (version (git-version "0" revision commit))
      (source
       (origin
         (uri (git-reference
               (url "https://github.com/carp-lang/carp-emacs")
               (commit commit)))
         (method git-fetch)
         (sha256
          (base32 "0mn4mg94hzzwb54kikg4c6hvf9ka15f2nz95g0clmn8r0mvkj4d5"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (propagated-inputs
        (list emacs-clojure-mode emacs-flycheck))
      (home-page "https://github.com/carp-lang/carp-emacs")
      (synopsis "Emacs support for Carp")
      (description
       "This package provides syntax highlighting, a minor mode for
listing type errors via Flycheck, as well as REPL support for Carp.")
      (license license:asl2.0))))

(define-public emacs-cond-let
  (package
    (name "emacs-cond-let")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/tarsius/cond-let/")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0jdhdngczdwj44wk3zsb9ab5dv5j9bflfwg22hay1rrzq5jiihyw"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command
      #~(list "emacs" "--batch"
              "-l" "cond-let-tests.el"
              "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/tarsius/cond-let/")
    (synopsis "Additional and improved binding conditionals")
    (description "This package implements binding conditionals @code{and-let}
and @code{while-let*}, and the original @code{cond-let}, @code{cond-let*},
@code{and$} and @code{and>}.")
    (license license:gpl3+)))

(define-public emacs-coterm
  (package
    (name "emacs-coterm")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/coterm-"
                           version ".tar"))
       (sha256
        (base32 "0ikfm1acdsckflv1hcy9lmssyac2099x2yybhvb6vkghcgy99p00"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-compat))
    (home-page "https://repo.or.cz/emacs-coterm.git")
    (synopsis "Terminal emulation for comint")
    (description
     "This package provides terminal emulation for comint.  If the global
@code{coterm-mode} is enabled, proper terminal emulation will be supported for
all newly spawned comint processes.  This allows you to use more complex
console programs such as @code{less} and @code{mpv} and full-screen TUI
programs such as @code{vi}, @code{top}, @code{htop} or even @code{emacs
-nw}.")
    (license license:gpl3+)))

(define-public emacs-mistty
  (package
    (name "emacs-mistty")
    (version "1.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/szermatt/mistty")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1dlb4k7sbjjgyhikbcw0qf9js328vhs964lmhciyh8ahcfb7i9l6"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   (add-before 'patch-el-files 'replace-bash-path
                     (lambda* (#:key inputs #:allow-other-keys)
                       (substitute* "mistty-term.el"
                         (("/bin/bash")
                          (search-input-file inputs "bin/bash"))))))))
    (inputs (list bash))
    (home-page "https://github.com/szermatt/mistty")
    (synopsis "Emacs terminal major mode based on Term")
    (description
     "This package defines a major mode that runs a shell inside of
a buffer, similarly to Comint mode.  It is built on top of Term.")
    (license license:gpl3+)))

(define-public emacs-counsel-bbdb
  (package
    (name "emacs-counsel-bbdb")
    (version "0.0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/redguardtoo/counsel-bbdb")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jrj7hx6y518np3xcnarbj0c43lglcf9gww3fhfqp7lzxl9hvi8s"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-bbdb emacs-ivy))
    (home-page "https://github.com/redguardtoo/counsel-bbdb")
    (synopsis "Ivy interface for BBDB")
    (description "This Ivy extension enables the use of @code{ivy-mode} to input
email addresses from BBDB efficiently.  The main functions are:
@table @code
@item counsel-bbdb-complete-mail to input email addresses;
@item counsel-bbdb-reload' to reload contacts from BBDB database;
@item counsel-bbdb-expand-mail-alias to expand mail alias.
@end table
Since @code{counsel-bbdb} is based on @code{ivy-mode}, all Ivy key bindings
are supported.  For example, after @samp{C-u M-x counsel-bbdb-complete-mail},
you can press @samp{C-M-n} to input multiple email addresses.")
    (license license:gpl3+)))

(define-public emacs-bluetooth
  (package
    (name "emacs-bluetooth")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "bluetooth-" version ".tar"))
       (sha256
        (base32 "1chi9xjg5zcg6qycn2n442adhhmip1vpvg12szf1raq3zhg7lr01"))))
    (build-system emacs-build-system)
    (inputs
     (list bluez dbus))
    (propagated-inputs
     (list emacs-compat emacs-dash emacs-transient))
    (home-page "https://gitlab.com/rstocker/emacs-bluetooth")
    (synopsis "Manage Bluetooth devices using Emacs")
    (description
     "This package implements basic Bluetooth management functionality, such
as connecting and disconnecting devices, setting properties and aliases,
putting the adapter in discovery mode and controlling its power supply.  It
also includes a pairing agent.")
    (license license:gpl3+)))

(define-public emacs-aggressive-indent
  (package
    (name "emacs-aggressive-indent")
    (version "1.10.0")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/"
                                  "aggressive-indent-" version ".tar"))
              (sha256
               (base32
                "166jk1z0vw481lfi3gbg7f9vsgwfv8fiyxpkfphgvgcmf5phv4q1"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/aggressive-indent.html")
    (synopsis "Minor mode to aggressively keep your code always indented")
    (description
     "@code{aggressive-indent-mode} is a minor mode that keeps your code
always indented.  It reindents after every change, making it more reliable
than @code{electric-indent-mode}.")
    (license license:gpl2+)))

(define-public emacs-smarttabs
  (package
    (name "emacs-smarttabs")
    (version "1.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                     (url "https://github.com/jcsalomon/smarttabs")
                     (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32 "0hkgw9i4yynazx5vbkb8a1lfp0yndyi8c1w3cf7ajxpnig3hs9j6"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ;no tests
    (home-page "http://www.emacswiki.org/emacs/SmartTabs")
    (synopsis "Indent with tabs, align with spaces!")
    (description
     "There is a semantic way of using tab characters in source code:
@strong{tabs for indentation, spaces for alignment}.  This package provides a
minor mode which improves Emacs' auto-indenting so that pressing @key{TAB}
inserts the correct mix of tabs and spaces to maintain visual alignment
regardless of a viewer's tab width.  You can still use all spaces if you
prefer; the code merely ensures that @emph{if} you enable tabs, the tab size
does not matter.")
    (license license:gpl2+)))

(define-public emacs-gc-stats
  (package
    (name "emacs-gc-stats")
    (version "1.4")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/"
                                  "emacs-gc-stats-" version ".tar"))
              (sha256
               (base32
                "19195s2nw87nmdz861j6shw5m2lv0spbcb1wff0y338fgx9sicgz"))))
    (build-system emacs-build-system)
    (home-page "https://git.sr.ht/~yantar92/emacs-gc-stats")
    (synopsis "Collect Emacs GC statistics")
    (description
     "This package collects Emacs @dfn{garbage collection} (GC) statistics over
time and saves it in the format that can be shared with Emacs maintainers.

This package does not upload anything automatically.  You will need to upload
the data manually, by sending email attachment.  If necessary, you can review
@code{emacs-gc-stats-file} (defaults to @code{~/.emacs.d/emacs-gc-stats.eld})
before uploading-it is just a text file.")
    (license license:gpl3+)))

(define-public emacs-gcmh
  ;; No tagged release upstream, but the commit below correspond to the 0.2.1
  ;; release.
  (let ((commit "0089f9c3a6d4e9a310d0791cf6fa8f35642ecfd9"))
    (package
      (name "emacs-gcmh")
      (version "0.2.1")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/koral/gcmh")
               (commit commit)))
         (sha256
          (base32 "0yh1ap8phv3x44rp0yr6z884xqw2apanbx4c0acqglvj0gaaqx25"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (home-page "https://gitlab.com/koral/gcmh")
      (synopsis "Emacs Garbage Collector Magic Hack")
      (description
       "This package enforces a sneaky @dfn{garbage collector} (GC) strategy
to minimize GC interference with the activity.  During normal use a high GC
threshold is set.  When idling GC is immediately triggered and a low threshold
is set.")
      (license license:gpl3+))))

(define-public emacs-ctrlf
  (package
    (name "emacs-ctrlf")
    (version "1.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/raxod502/ctrlf")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "061id540spjycgy2xshj8kwgdngkjinznhx2qp5pmqzzx7z7rpfb"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (home-page "https://github.com/raxod502/ctrlf/")
    (synopsis "Single-buffer text search in Emacs")
    (description "CTRLF (pronounced @emph{control F}) is an intuitive and
efficient solution for single-buffer text search in Emacs, replacing packages
such as Isearch, Swiper, and helm-swoop.  It takes inspiration from the
widely-adopted and battle-tested @samp{Ctrl+F} interfaces in programs such as
web browsers, but follows the flow and keybindings of Isearch.")
    (license license:expat)))

(define-public emacs-dhall-mode
  ;; There is no proper release.  The base version is extracted from the
  ;; "Version" keyword in the main file.
  (let ((revision "1")
        (commit  "484bcf8f78f1183ef45c3b04a362bb73690c6b9b"))
    (package
      (name "emacs-dhall-mode")
      (version (git-version "0.1.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/psibi/dhall-mode")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1wggg8jlzg9rph4jhxp6yiri178rnasbv38838i973kjgqjxrl76"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-reformatter))
      (home-page "https://github.com/psibi/dhall-mode")
      (synopsis "Major mode for working with Dhall configuration language")
      (description
       "Dhall-mode provides an Emacs Major mode for working with the Dhall
configuration language.  It features:

@itemize
@item Syntax highlighting
@item Multiline support for String
@item Basic indentation, commenting
@item Automatic formatting on save using dhall-format.
@item Error highlighting.
@end itemize")
      (license license:gpl3+))))

(define-public emacs-link-hint
  ;; Last release was in 2015.
  (let ((commit "83cd0489b16f013647d0507ef20905a0a91db433")
        (revision "4"))
    (package
      (name "emacs-link-hint")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/noctuid/link-hint.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0kwaia6i0asr7yqcw1anzq6lf93357cc1fphkvp0llbmxizmkzb3"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-avy))
      (home-page "https://github.com/noctuid/link-hint.el")
      (synopsis "Vimperator-style link-hinting in Emacs")
      (description "This package provides commands for visiting and acting on
links.")
      (license license:gpl3+))))

(define-public emacs-ag
  (package
    (name "emacs-ag")
    (version "0.48")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Wilfred/ag.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1p918y24vcn2pdliaymd210xp9fvhd4a1srqbv2lfiqrh59yjidx"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'substitute-ag-path
            (lambda* (#:key inputs #:allow-other-keys)
              (make-file-writable "ag.el")
              (emacs-substitute-variables "ag.el"
                ("ag-executable" (search-input-file inputs "/bin/ag")))))
          (add-before 'install 'make-info
            (lambda _
              (with-directory-excursion "docs"
                (invoke "make" "info"))))
          (add-after 'install 'install-info
            (lambda _
              (install-file "docs/_build/texinfo/agel.info"
                            (string-append #$output "/share/info")))))))
    (inputs (list the-silver-searcher))     ; 'ag' executable
    (native-inputs
     (list emacs-ert-runner emacs-undercover python-sphinx texinfo))
    (propagated-inputs
     (list emacs-dash emacs-s))
    (home-page "https://github.com/Wilfred/ag.el")
    (synopsis "Front-end for ag (the-silver-searcher) for Emacs")
    (description "This package provides the ability to use the silver
searcher, a code searching tool, sometimes abbreviated to @code{ag}.  Features
include version control system awareness, use of Perl compatible regular
expressions, editing the search results directly and searching file names
rather than the contents of files.")
    (license license:gpl3+)))

(define-public emacs-aio
  (let ((revision "0")
        (commit "289c1e9530b59b4e2fd88f87f303547b23f2a3e3"))
    (package
      (name "emacs-aio")
      (version (git-version "1.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      ;; Switched from <https://github.com/skeeto/emacs-aio>
                      ;; since <https://github.com/skeeto/emacs-aio/issues/31>
                      ;; is open since Jan 1 2025 with no merge.
                      (url "https://github.com/kiennq/emacs-aio")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1jaq3xbk69ki10bfdphl4ac2hsnvr56bg4fcr0si8q31zgar7xzj"))))
      (build-system emacs-build-system)
      (arguments
       `(#:test-command '("emacs" "--batch"
                          "-l" "aio-test.el"
                          "-f" "ert-run-tests-batch-and-exit")))
      (propagated-inputs
       (list emacs-elfeed emacs-skewer-mode))
      (home-page "https://github.com/skeeto/emacs-aio")
      (synopsis "Async/Await for Emacs Lisp")
      (description "@code{aio} is to Emacs Lisp as @code{asyncio} is to Python.
This package builds upon Emacs generators to provide functions that pause
while they wait on asynchronous events.  They do not block any thread while
paused.")
      (license license:unlicense))))

(define-public emacs-async
  (package
    (name "emacs-async")
    (home-page "https://github.com/jwiegley/emacs-async")
    (version "1.9.9")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0krg7n8l3yv1fnixnx6j5imdh10jpfabm6ym9s1s610hp47gpfaz"))))
    (build-system emacs-build-system)
    (arguments
     `(#:test-command '("buttercup" "-L" ".")))
    (native-inputs
     (list emacs-buttercup))
    (synopsis "Asynchronous processing in Emacs")
    (description
     "This package provides the ability to call asynchronous functions and
processes.  For example, it can be used to run dired commands (for copying,
moving, etc.) asynchronously using @code{dired-async-mode}.  Also it is used
as a library for other Emacs packages.")
    (license license:gpl3+)))

(define-public emacs-auctex
  (package
    (name "emacs-auctex")
    (version "14.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "auctex-" version ".tar"))
       (sha256
        (base32 "0cb5f86p7yxqx27wck2a3wgsxrzhv5rrgn88wpias1w7v2lbsw2j"))))
    (build-system emacs-build-system)
    ;; We use 'emacs' because AUCTeX requires dbus at compile time
    ;; ('emacs-minimal' does not provide dbus).
    (arguments
     (list
      #:emacs emacs
      #:include #~(cons* "^images/" "^latex/" %default-include)
      #:exclude #~(cons "^latex/README" %default-exclude)
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'configure
            (lambda* (#:key inputs #:allow-other-keys)
              (emacs-substitute-variables "preview.el"
                ("preview-gs-command"
                 (search-input-file inputs "/bin/gs")))
              ;; Leave "dvipng" and "dvips" executables as-is.  Otherwise, this
              ;; would require to add a TeX Live system to inputs, which is
              ;; much for an Emacs package.
              (substitute* "preview.el"
                (("\"pdf2dsc ")
                 (let ((pdf2dsc (search-input-file inputs "/bin/pdf2dsc")))
                   (string-append "\"" pdf2dsc " "))))))
          (add-after 'install 'install-doc
            (lambda _
              (let ((doc-dir (string-append #$output "/share/doc/"
                                            #$name "-" #$version)))
                (with-directory-excursion "doc"
                  (setenv "HOME" (getenv  "TMPDIR")) ; for mktextfm
                  (invoke "pdftex" "tex-ref")
                  (install-file "tex-ref.pdf" doc-dir))))))))
    (native-inputs
     (list perl (texlive-local-tree)))
    (inputs
     (list ghostscript))
    (home-page "https://www.gnu.org/software/auctex/")
    (synopsis "Integrated environment for TeX")
    (description
     "AUCTeX is a comprehensive customizable integrated environment for
writing input files for TeX, LaTeX, ConTeXt, Texinfo, and docTeX using Emacs
or XEmacs.")
    (license license:gpl3+)))

(define-public emacs-latex-extra
  (let ((commit "a81e7588448f85c5fcc3f3fc71cf957d0928a656")
        (revision "0"))
    (package
      (name "emacs-latex-extra")
      (version (git-version "1.14" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/Malabarba/latex-extra")
                      (commit commit)))
                (sha256
                 (base32
                  "0sajg5vmygnkcnmkrpf8r7c4b8v95hgsv1y6pz868jpznmldnxkb"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command
        #~(list "emacs" "-Q" "--batch"
                "--eval=(cd \"tests/\")"
                "-l" "latex-extra-test.el"
                "-f" "ert-run-tests-batch-and-exit")
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'build 'set-home
              (lambda _ (setenv "HOME" (getcwd)))))))
      (propagated-inputs (list emacs-auctex))
      (home-page "https://github.com/Malabarba/latex-extra")
      (synopsis "Usability improvements for LaTeX mode")
      (description
       "Latex-extra defines extra commands and keys for LaTeX mode, as well
as brings user experience improvements.")
      (license license:gpl3+))))

(define-public emacs-xenops
  (package
    (name "emacs-xenops")
    (version "0.0.1")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://github.com/dandavison/xenops/archive/"
                                  version ".tar.gz"))
              (sha256
               (base32
                "1gaym5bl6fhdp4pa283qcx5qf77wz2g7xl9n1gyvvl9yl0kvrb48"))))
    (propagated-inputs (list emacs-aio emacs-auctex emacs-avy emacs-dash
                             emacs-f emacs-s))
    (build-system emacs-build-system)
    (arguments
     (list
      #:lisp-directory "lisp"
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-home
            (lambda _
              (setenv "HOME" "/tmp"))))))
    (synopsis "WYSIWYG LaTeX environment")
    (description "This package provides a WYSIWYG LaTeX environment.
It uses @command{dvisvgm}, @command{xclip}, @command{pngpaste} and
@command{latex}.")
    (home-page "https://github.com/dandavison/xenops")
    (license license:expat)))

(define-public emacs-autothemer
  (let ((commit "8f72afc6dba5ad7cc3a201a084fd20571f945d2e")) ;version bump
    (package
      (name "emacs-autothemer")
      (version "0.2.18")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sebastiansturm/autothemer")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "15f7i39937riswpwjpc1ryg2v0rqj944pwf7rp2ry56rbx4vgl97"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "emacs" "-Q" "--batch"
                               "-l" "tests/autothemer-tests.el"
                               "-f" "ert-run-tests-batch-and-exit")))
      (propagated-inputs
       (list emacs-dash))
      (home-page "https://github.com/sebastiansturm/autothemer")
      (synopsis "Conveniently create Emacs themes")
      (description
       "Autothemer provides a thin layer on top of @code{deftheme} and
@code{custom-theme-set-faces} that creates a new custom color theme, based on
a set of simplified face specifications and a user-supplied color palette.")
      (license license:gpl3+))))

(define-public emacs-howm
  (package
    (name "emacs-howm")
    (version "1.5.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kaorahi/howm")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1dmjcbwcghyppqrg383pkric5mjhrz95f7wlm8lxq8k6zkynm1hp"))))
    (build-system gnu-build-system)
    (native-inputs
     (list emacs-minimal))
    (arguments
     `(#:configure-flags
       (list (string-append "--with-howmdir=" (emacs:elpa-directory %output)))
       #:modules ((guix build gnu-build-system)
                  ((guix build emacs-build-system) #:prefix emacs:)
                  (guix build utils))
       #:imported-modules (,@%default-gnu-imported-modules
                           (guix build emacs-build-system)
                           (guix build emacs-utils))
       #:phases
       (modify-phases %standard-phases
         (add-after 'install 'make-autoloads
           (assoc-ref emacs:%standard-phases 'make-autoloads)))))
    (home-page "https://kaorahi.github.io/howm/")
    (synopsis "Note-taking tool for Emacs")
    (description "Howm is a note-taking tool for Emacs.  Like
@code{emacs-wiki.el}, it facilitates using hyperlinks and doing full-text
searches.  Unlike @code{emacs-wiki.el}, it can be combined with any format.")
    (license license:gpl1+)))

(define-public emacs-mediawiki
  (package
    (name "emacs-mediawiki")
    (version "2.4.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hexmode/mediawiki-el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "199vkks9adkw7rvac960sz2625n0pa7zr2bixrb552dvh29c1lxc"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command
      #~(list "make" "test-mediawiki-simple" "test-mediawiki-core"
              "test-mediawiki-utils" "test-mediawiki-mode")))
    (synopsis "Mediawiki editor for Emacs")
    (description
     "This package provides a way to edit mediawiki sites from within emacs.")
    (home-page "https://github.com/hexmode/mediawiki-el")
    (license license:gpl3+)))

(define-deprecated-package emacs-mediawiki-el
  emacs-mediawiki)

(define-public emacs-bm
  (package
    (name "emacs-bm")
    (version "202506")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joodland/bm")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0298hjdgx03y028pql6z3jcym47ji10hv66zydn1kicsjds0r45l"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "emacs" "-Q" "--batch"
                             "-l" "bm-tests.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://joodland.github.io/bm/")
    (synopsis "Visual bookmarks for Emacs")
    (description "This package provides visible, buffer local bookmarks and
the ability to jump forward and backward to the next bookmark.")
    (license license:gpl2+)))

(define-public emacs-calfw
  (package
    (name "emacs-calfw")
    (version "2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kiwanami/emacs-calfw")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0vmd9dl1hnmwjfr9gy8n91724bl05walhjx2myszh6qs28xay0z4"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs
     (list emacs-howm))
    (home-page "https://github.com/kiwanami/emacs-calfw/")
    (synopsis "Calendar framework for Emacs")
    (description
     "This package displays a calendar view with various schedule data in the
Emacs buffer.")
    (license license:gpl3+)))

(define-public emacs-varuga
  (package
    (name "emacs-varuga")
    (version "0.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.systemreboot.net/varuga/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "01hlnhqhys8qzfwhza1ypc436zg5lhlkx5yy71bhmrbmyfzfh0fr"))))
    (build-system emacs-build-system)
    (home-page "https://git.systemreboot.net/varuga/about/")
    (synopsis "Send iCal calendar invites by email")
    (description
     "Varuga allows you to format and send iCal calendar invites using your
Emacs mail client.  These invites are similar to those produced by Google
Calendar or Outlook Calendar, and are compatible with them.

Varuga populates a Message mode buffer with an iCal MIME part (using MML, the
MIME Meta Language).  It also adds a plain text part listing the time of the
event in various configured timezones.")
    (license license:gpl3+)))

(define-public emacs-caml
  (package
    (name "emacs-caml")
    (version "4.9")
    (source
      (origin
        (method url-fetch)
        (uri (string-append "https://elpa.nongnu.org/nongnu/caml-"
                            version ".tar"))
        (sha256
          (base32
            "00ldvz6r10vwwmk6f3az534p0340ywn7knsg2bmvbvh3q51vyl9i"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (home-page "https://github.com/ocaml/caml-mode")
    (synopsis "Caml mode for GNU Emacs")
    (description
      "This package provides a major mode for editing OCaml code in Emacs.
Some of its major features include:

@itemize
@item syntax highlighting (font lock);
@item automatic indentation;
@item querying the type of expressions (using compiler generated annot files);
@item running an OCaml REPL within Emacs;
@item scanning of declarations and placing them in a menu.
@end itemize")
    (license license:gpl2+)))

(define-public emacs-campus
  (let ((commit "0a475cd7704001d8dc8280acb91a317db797933b")
        (revision "0"))
    (package
      (name "emacs-campus")
      (version (git-version "0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/eshrh/campus-emacs")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "13vych4kk6adn15scl1s4znnbmfjvihfglxglrqqp2llzh0wsnlm"))))
      (arguments (list #:tests? #f)) ; There are no tests.
      (propagated-inputs (list emacs-dash emacs-s))
      (build-system emacs-build-system)
      (home-page "https://github.com/eshrh/campus-emacs")
      (synopsis "Simple and sane approach to repl programming")
      (description
       "Campus is a simple but effective improvement to the
inferior-process repl development experience in Emacs.")
      (license license:gpl3+))))

(define-public emacs-caps-lock
  (package
    (name "emacs-caps-lock")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "caps-lock-" version ".el"))
       (sha256
        (base32 "1i4hwam81p4dr0bk8257fkiz4xmv6knkjxj7a00fa35kgx5blpva"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/caps-lock.html")
    (synopsis "Caps Lock as a minor mode")
    (description
     "This package provides a minor mode to emulate the behavior of a Caps
Lock key.")
    (license license:gpl3+)))

(define-public emacs-chocolate-theme
  (let ((commit "ccc05f7ad96d3d1332727689bf6250443adc7ec0")
        (revision "0"))
    (package
      (name "emacs-chocolate-theme")
      (version (git-version "0.2.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url
                       "https://github.com/SavchenkoValeriy/emacs-chocolate-theme")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1d8a9jwv9y0sncw24k840c8yyrig30f2d6q2zqlc09f05yzq9p9p"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-autothemer))
      (home-page "https://github.com/SavchenkoValeriy/emacs-chocolate-theme")
      (synopsis "Dark chocolatey theme for Emacs")
      (description
       "Chocolate theme is a dark, chocolatey, vibrant and subtle theme for
Emacs.")
      (license license:gpl3))))

(define-public emacs-chronometrist
  (package
    (name "emacs-chronometrist")
    (version "0.10.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://tildegit.org/contrapunctus/chronometrist")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0qpkpkipmac24m3ng4ahsml3vi15qcvmid3g02pbpgbpc113zfpl"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:lisp-directory "elisp"
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'install-doc
            ;; Documentation consists of several Markdown files.
            (lambda _
              (let ((doc (string-append #$output
                                        "/share/doc/emacs-chronometrist-"
                                        #$version)))
                (with-directory-excursion "../doc"
                  (for-each (lambda (f) (install-file f doc))
                            (cons* "../UNLICENSE"
                                   "../WTFPL"
                                   (find-files "." "\\.md$"))))))))))
    (propagated-inputs
     (list emacs-alert emacs-dash emacs-s emacs-spark emacs-ts))
    (home-page "https://github.com/contrapunctus-1/chronometrist")
    (synopsis "Time tracker for Emacs")
    (description "Chronometrist is a time tracker in Emacs, largely modelled
after the Android application, @emph{A Time Tracker}.

Its features are:
@itemize
@item Simple and efficient to use,
@item Displays useful information about your time usage,
@item Support for both mouse and keyboard,
@item Human errors in tracking are easily fixed by editing a plain text file,
@item Hooks to let you perform arbitrary actions when starting/stopping tasks.
@end itemize")
    ;; Software is dual-licensed.
    (license (list license:unlicense license:wtfpl2))))

(define-public emacs-citeproc
  (package
    (name "emacs-citeproc")
    (version "0.9.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/andras-simonyi/citeproc-el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1l74c2f2xjzsp3i331sw3db4fhbvdbwyd856j1ygldwrh4rli9ml"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:emacs emacs ;need libxml support
      #:tests? #f)) ;tests require missing data
    (propagated-inputs (list emacs-compat
                             emacs-dash
                             emacs-f
                             emacs-parsebib
                             emacs-queue
                             emacs-s
                             emacs-string-inflection))
    (home-page "https://github.com/andras-simonyi/citeproc-el")
    (synopsis "Citation Style Language (CSL) processor for Emacs")
    (description
     "Citeproc-el is an Emacs Lisp library for rendering citations
and bibliographies in styles described in the Citation Style
Language (CSL), an XML-based, open format to describe the formatting
of bibliographic references.")
    (license license:gpl3+)))

(define-deprecated-package emacs-citeproc-el
  emacs-citeproc)

(define-public emacs-corfu
  (package
    (name "emacs-corfu")
    (version "2.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/minad/corfu")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0psy7ximwnansy9pppcw1l2fryr15v2vqgj81q649743py6nd60l"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f ; there are no tests
      #:phases
      #~(modify-phases %standard-phases
          ;; Move the extensions source files to the top level, which is
          ;; included in the EMACSLOADPATH.
          (add-after 'unpack 'move-source-files
            (lambda _
              (let ((el-files (find-files "./extensions" ".*\\.el$")))
                (for-each (lambda (f)
                            (rename-file f (basename f)))
                          el-files))))
          (add-after 'unpack 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (native-inputs (list texinfo))
    (propagated-inputs
     (list emacs-compat))
    (home-page "https://github.com/minad/corfu")
    (synopsis "Completion overlay region function")
    (description
     "Corfu enhances the default completion in region function with a completion
overlay.  The current candidates are shown in a popup overlay below or above
the point.  Corfu can be considered the minimalistic
@code{completion-in-region} counterpart of the Vertico minibuffer UI.")
    (license license:gpl3+)))

(define-public emacs-corfu-doc
  (package
    (name "emacs-corfu-doc")
    (version "0.6.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/galeo/corfu-doc")
             (commit "f9566cf13f6730a45b2f3c12e491a3fa2097e5d5")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "098yf29yv1b11p7kvdc7n4ra7f5vcmf6nlvhl85jgwqrsdz1795b"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-corfu))
    (home-page "https://github.com/galeo/corfu-doc")
    (synopsis "Documentation popup for Corfu")
    (description
     "The @code{corfu-doc} package provides a way to display a documentation
popup for completion candidates when using @code{emacs-corfu}.  It can
be regarded as @code{emacs-company-quickhelp} for @code{emacs-corfu}.")
    (license license:gpl3+)))

(define-public emacs-corfu-candidate-overlay
  (package
    (name "emacs-corfu-candidate-overlay")
    (version "1.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://code.bsdgeek.org/adam/corfu-candidate-overlay")
             (commit "265438b16155e899d82a869aebca16105665c998")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0i36g2i7435pby32vcapv4ydmp6rqn0r51qm91wqyzan1f3n3qck"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-corfu))
    (license license:gpl3)
    (home-page "https://code.bsdgeek.org/adam/corfu-candidate-overlay")
    (synopsis "Show first Corfu's completion candidate in an overlay while
 typing")
    (description
     "Simple corfu as-you-type auto-suggestion candidate overlay with a visual
 indication of whether there are many or exactly one candidate available.")))

(define-public emacs-cape
  (package
    (name "emacs-cape")
    (version "2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/minad/cape")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1hvdqrr0nbgimzx74srkmfk9fqgh44hvgfph048mrr0saf4mv4qj"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f                       ;no test suite
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (native-inputs (list texinfo))
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/minad/cape")
    (synopsis "Completion at point extensions for Emacs")
    (description
     "Cape provides some Completion At Point Extensions, which can be used in
combination with Corfu completion UI or the default completion UI.  The
completion backends used by @code{completion-at-point} are so called
@code{completion-at-point-functions} (Capfs).  In principle, the Capfs
provided by Cape can also be used by Company.")
    (license license:gpl3+)))

(define-public emacs-capf-autosuggest
  (package
    (name "emacs-capf-autosuggest")
    (version "0.3")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/capf-autosuggest-"
                                  version ".tar"))
              (sha256
               (base32
                "18cwiv227m8y1xqvsnjrzgd6f6kvvih742h8y38pphljssl109fk"))))
    (build-system emacs-build-system)
    (synopsis "@code{eshell} completion suggestions for Emacs")
    (description "This package provides comint autosuggestions for Emacs
eshell.")
    (home-page "https://repo.or.cz/emacs-capf-autosuggest")
    (license license:gpl3+)))

(define-public emacs-org-block-capf
  ;; There are no tagged releases upstream
  (let ((commit "080cfd2ed630a6739633b07a8ab6b896a1b5ef4a")
        (revision "0"))
    (package
      (name "emacs-org-block-capf")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/xenodium/org-block-capf")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1ryjnqbphpysms8ynjp2d83siq1q09ci7gd1gx2zl09b88mfw0w9"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #f))                   ; no tests
      (home-page "https://github.com/xenodium/org-block-capf")
      (synopsis "Completion suggestions for Org-mode source blocks")
      (description
       "This package provides completions for Org-mode source blocks using
completion at point function.")
      (license license:gpl3+))))

(define-public emacs-direnv
  (package
    (name "emacs-direnv")
    (version "2.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/wbolster/emacs-direnv")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0cf5npgksl9a03mnfdhfdhlf46gr9qz9adjxz3dbckq9b1vl0dfc"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-in-direnv
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((direnv (search-input-file inputs "/bin/direnv")))
               (substitute* "direnv.el"
                 (("\"direnv\"") (string-append "\"" direnv "\"")))))))))
    (inputs
     (list direnv))
    (propagated-inputs
     (list emacs-dash emacs-with-editor))
    (home-page "https://github.com/wbolster/emacs-direnv")
    (synopsis "Direnv integration for Emacs")
    (description
     "This package provides support for invoking direnv to get the environment
for the current file and updating the environment within Emacs to match.

Direnv can be invoked manually, and a global minor mode is included that will
update the environment when the active buffer changes.

Using emacs-direnv means that programs started from Emacs will use the
environment set through Direnv.")
    (license license:gpl3+)))

(define-public emacs-elf-mode
  (package
    (name "emacs-elf-mode")
    (version "0.1.0")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/abo-abo/elf-mode")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0cbvjbk2893ag1iy8ggixpirfiyhssm7fii96hb9jqdz874cdl0k"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/abo-abo/elf-mode")
    (synopsis "Show symbol list when opening a binary file in Emacs")
    (description "This Emacs package provides a command showing the symbols
that the binary uses instead of the actual binary contents.")
    (license license:gpl3+)))

(define-public emacs-ellama
  (package
    (name "emacs-ellama")
    (version "1.9.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/s-kostyaev/ellama")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "09xzn4daf80w7x6kbj2b8az89viv66sh367kxlxymr7rsznq1a7q"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'disable-failing-tests
            (lambda _
              (substitute* (find-files "tests/" "\\.el$")
                (((string-append
                   "\\(ert-deftest "
                   "test-ellama-context-element-extract-info-node .*") all)
                 (string-append all "(skip-unless nil)\n"))))))
      #:test-command #~(list "emacs" "-Q" "--batch"
                             "-l" "ellama.el"
                             "-l" "tests/test-ellama.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs (list emacs-compat emacs-llm emacs-plz))
    (home-page "https://github.com/s-kostyaev/ellama")
    (synopsis "Tool for interacting with LLMs")
    (description
     "Ellama is a tool for interacting with large language models from Emacs.
It allows you to ask questions and receive responses from the LLMs.  Ellama
can perform various tasks such as translation, code review, summarization,
enhancing grammar/spelling or wording and more through the Emacs interface.
Ellama natively supports streaming output, making it effortless to use with
your preferred text editor.")
    (license license:gpl3+)))

(define-public emacs-ollama-buddy
  (package
    (name "emacs-ollama-buddy")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/captainflasmr/ollama-buddy/")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "17jrpmj5wnafwsbvwrdfds9c92nflcf5sipd37ci4gsjckd83wvq"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons* "ollama-buddy-presets" "ollama-buddy-mini"
                         %default-include)
      ;; See: https://github.com/captainflasmr/ollama-buddy/issues/17
      #:tests? #f
      #:test-command #~(list "make" "test")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'build-info-manual
            (lambda _
              (invoke "make" "-C" "docs" "docs")
              (rename-file "docs/ollama-buddy.info" "ollama-buddy.info"))))))
    (native-inputs (list texinfo))
    (home-page "https://github.com/captainflasmr/ollama-buddy/")
    (synopsis "Interface for interacting with Ollama models")
    (description
     "@code{Ollama-buddy} offers a convenient way to integrate to Ollama's
local LLM capabilities from Emacs.")
    (license license:gpl3+)))

(define-public emacs-org-fc
  (package
    (name "emacs-org-fc")
    (version "0.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~l3kn/org-fc")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1bch6dlw3f8zxvfazsndmilizvxvxpcfgrv89nk6id966y3czrpl"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons* "\\.awk$" "\\.org$" %default-include)
      #:exclude #~(cons "^tests/" %default-exclude)
      #:test-command #~(list "emacs" "--batch"
                             "-L" "."
                             "-L" "tests/"
                             "-l" "tests/org-fc-card-test.el"
                             "-l" "tests/org-fc-filter-test.el"
                             "-l" "tests/org-fc-indexer-test.el"
                             "-l" "tests/org-fc-review-data-test.el"
                             "-f" "ert-run-tests-batch-and-exit")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'qualify-paths
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((find (search-input-file inputs "/bin/find"))
                    (gawk (search-input-file inputs "/bin/gawk"))
                    (xargs (search-input-file inputs "/bin/xargs")))
                (substitute* "org-fc-awk.el"
                  (("\"find ") (string-append "\"" find " "))
                  (("\"gawk ") (string-append "\"" gawk " "))
                  (("\"xargs ") (string-append "\"" xargs " ")))))))))
    (native-inputs (list emacs-el-mock))
    (inputs (list findutils gawk))
    (propagated-inputs (list emacs-hydra))
    (home-page "https://www.leonrische.me/fc/index.html")
    (synopsis "Spaced repetition system for Emacs Org mode")
    (description
     "Org-fc is a spaced-repetition system for Emacs' Org mode.
It allows you to mark headlines in a file as flashcards, turning pieces of
knowledge you want to learn into a question-answer test.  These cards are
reviewed at regular interval.  After each review, the next review interval is
calculated based on how well you remembered the contents of the card.")
    (license license:gpl3+)))

(define-public emacs-font-lock+
  (let ((commit "aa1c82d05c9222b09099a0ccd7468e955497940c")
        (revision "0"))
    (package
      (name "emacs-font-lock+")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsmirror/font-lock-plus")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1369r5p6s9c561g5f772lvrpcqxhvyhqd9yk0853hyl03ags9gvs"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/emacsmirror/font-lock-plus")
      (synopsis "Enhancements to standard Font Lock library")
      (description
       "This package provides enhancements to standard Font Lock library.")
      (license license:gpl3+))))

(define-public emacs-font-lock-studio
  (package
    (name "emacs-font-lock-studio")
    (version "0.0.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Lindydancer/font-lock-studio")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0gjr02kww4a0a4x30pj6lls2wdj25vi14ay4pl4fgc2h98yli3c8"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Lindydancer/font-lock-studio")
    (synopsis "Interactive debugger for Font Lock keywords")
    (description
     "Font Lock Studio is an interactive debugger for Emacs syntax highlighting
rules, also called Font Lock keywords.  It can @emph{single-step} Font Lock
keywords -- matchers, highlights, and anchored rules, to see what happens when
a buffer is fontified.  Breakpoints can be set on or inside rules.  When
inside a rule, matches are visualized using a palette of background colors.
The explainer can describe a rule in plain-text English.  Finally, tight
integration with Edebug allows stepping into Lisp expressions that are part of
the Font Lock keywords.")
    (license license:gpl3+)))

(define-public emacs-font-utils
  ;; latest release from 10 years ago
  (let ((commit "abc572eb0dc30a26584c0058c3fe6c7273a10003")
        (revision "0"))
    (package
      (name "emacs-font-utils")
      (version (git-version "0.7.8" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rolandwalker/font-utils/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0hx3k2zx2kdavivr1b957jq7kcwk301yzw77aprxzbs7jz73a35x"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #f ; require pcache
        #:test-command #~(list "make" "test")))
      (native-inputs (list which))
      (home-page "https://github.com/rolandwalker/font-utils/")
      (synopsis "Utility functions for working with fonts in Emacs")
      (description
       "@code{Font-utils} is a collection of functions for working with fonts.  This
library has no user-level interface, it is only useful for programming in Emacs
Lisp.")
      (license license:bsd-2))))

 (define-public emacs-fontaine
   (package
     (name "emacs-fontaine")
     (version "3.0.0")
     (source (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/protesilaos/fontaine")
                     (commit version)))
               (file-name (git-file-name name version))
               (sha256
                (base32
                 "1rkk6bzb5fwl1xkr8ifcvla7xgms7iks09xkxmpzar4qvq7y8c28"))))
     (build-system emacs-build-system)
     (home-page "https://github.com/protesilaos/fontaine")
     (synopsis "Set Emacs font configurations using presets")
     (description
      "Fontaine lets the user specify presets of font configurations
and set them on demand on graphical Emacs frames.")
     (license license:gpl3+)))

(define-public emacs-form-feed
  (package
    (name "emacs-form-feed")
    (version "0.2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://depp.brause.cc/form-feed.git")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10mcj4x2fjq0ikq9adkd72k9zp6caqib628bmj8d67wwabvzj6mk"))))
    (build-system emacs-build-system)
    (home-page "https://depp.brause.cc/form-feed")
    (synopsis "Display ^L glyphs as horizontal lines")
    (description
     "This package provides a minor mode @code{form-feed-mode} to display page
delimiters which usually appear as ^L glyphs on a single line as horizontal
lines spanning the entire window.  The minor mode is suitable for inclusion
into mode hooks and is intended to be used that way.")
    (license license:gpl3+)))

(define-public emacs-form-feed-st
  (let ((commit "f91c8daf35b7588e0aa24c8716c8cfd8ff0067c8")
        (revision "0"))
    (package
      (name "emacs-form-feed-st")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/leodag/form-feed-st")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0wj7icy2nj2kc1ayzgmrnn3slcw1ws6l9m89yr8h8j7wyrcnhkxz"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ; No tests.
      (home-page "https://github.com/leodag/form-feed-st")
      (synopsis "Display ^L glyphs as full-width horizontal lines")
      (description
       "This package provides a minor mode to displays page delimiters which
usually appear as ^L glyphs on a single line as horizontal lines spanning the
entire window.  In comparison to @code{emacs-form-feed}, this fork does not
have configurable line width; however, it always displays correctly, even if
you have multiple windows showing the same buffer, and will never cause side
scrolling since the form feed only occupies two spaces.  It also only affects
form feeds at the beginning of the line.")
      (license license:gpl3+))))

(define-public emacs-xcscope
  (let ((commit "d228d7593d762e457340f678d14b663ef66d7cee")
        (revision "0"))
    (package
      (name "emacs-xcscope")
      (version (git-version "1.5" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/dkogan/xcscope.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0pr85ywp585imjzswm04647nb4iqqvg8jgmbcs5210qmr9kh0z8d"))))
      (build-system emacs-build-system)
      (inputs (list cscope))
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'substitute-cscope-path
              (lambda* (#:key inputs #:allow-other-keys)
                (emacs-substitute-variables "xcscope.el"
                  ("cscope-program"
                   (search-input-file inputs "/bin/cscope"))))))))
      (home-page "https://github.com/dkogan/xcscope.el")
      (synopsis "Interface to the source cross-referencing tool Cscope")
      (description
       "Xcscope is an Emacs interface to Cscope, the source cross-referencing
tool.")
      (license license:gpl2+))))

(define-public emacs-ggtags
  (let ((commit "4e3630c30fb836872b5d8f2ae3e5d5ae003365d8")
        (revision "0"))
    (package
      (name "emacs-ggtags")
      (version (git-version "0.9.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/leoliu/ggtags")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1mgdli2kvsg3y6ynsl6547cwwg9f2q0s1cv4b74slpcvq5n1kb90"))))
      (build-system emacs-build-system)
      (inputs
       (list global))
      (arguments
       `(#:tests? #f                    ; no tests
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'configure
             (lambda* (#:key inputs #:allow-other-keys)
               (chmod "ggtags.el" #o644)
               (emacs-substitute-variables "ggtags.el"
                 ("ggtags-executable-directory"
                  (dirname (search-input-file inputs "bin/global")))))))))
      (home-page "https://github.com/leoliu/ggtags")
      (synopsis "Frontend to the GNU Global source code tagging system")
      (description "@code{ggtags} provides a frontend to the GNU Global source
code tagging system.

Features:

@itemize
@item Build on @code{compile.el} for asynchronicity and its large feature-set.
@item Automatically update Global's tag files when needed with tuning for
large source trees.
@item Intuitive navigation among multiple matches with mode-line display of
current match, total matches and exit status.
@item Read tag with completion.
@item Show definition at point.
@item Jump to #include files.
@item Support search history and saving a search to register/bookmark.
@item Query replace.
@item Manage Global's environment variables on a per-project basis.
@item Highlight (definition) tag at point.
@item Abbreviated display of file names.
@item Support all Global search backends: @code{grep}, @code{idutils}, etc.
@item Support exuberant ctags @url{http://ctags.sourceforge.net/} and
@code{pygments} backend.
@item Support all Global's output formats: @code{grep}, @code{ctags-x},
@code{cscope} etc.
@item Support projects on remote hosts (e.g. via @code{tramp}).
@item Support eldoc.
@item Search @code{GTAGSLIBPATH} for references and symbols.
@end itemize\n")
      (license license:gpl3+))))

(define-public emacs-go-mode
  (package
    (name "emacs-go-mode")
    (version "1.6.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/dominikh/go-mode.el")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "00qzn136d8cl3szbi44xf3iiv75r6n1m7wwgldmzn4i5mpz8dbq7"))))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-commands
            (lambda* (#:key inputs #:allow-other-keys)
              (emacs-substitute-variables "go-mode.el"
                ("godef-command" (search-input-file inputs "bin/godef")))))
          (add-before 'check 'fix-tests
            ;; Two tests fail because they (wrongly) assume we run them from
            ;; the "test" sub-directory.  Fix their expectations.
            (lambda _
              (let ((test-file "test/go-indentation-test.el"))
                (make-file-writable test-file)
                (substitute* test-file
                  (("testdata/indentation_tests/" all)
                   (string-append "test/" all)))
                (ert-number-tests "test/go-fill-paragraph-test.el"
                                  "go--fill-paragraph-block-region")))))))
    (build-system emacs-build-system)
    (native-inputs (list emacs-ert-runner))
    (inputs (list godef))
    (home-page "https://github.com/dominikh/go-mode.el")
    (synopsis "Go mode for Emacs")
    (description
     "This package provides go-mode, an Emacs mode for working with software
written in the Go programming language.")
    (license license:bsd-3)))

(define-public emacs-google-maps
  ;; There has been no new release tag since 2013.
  (let ((commit "2eb16ff609f5a9f8d02c15238a111fbb7db6c146")
        (revision "1"))
    (package
      (name "emacs-google-maps")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jd/google-maps.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1bl0dnksbf14d0xcnvdy9qpvzc5c8jwkxpmfvgayj6djikxnw2md"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/jd/google-maps.el")
      (synopsis "Access Google Maps from Emacs")
      (description "The @code{google-maps} package displays Google Maps
directly inside Emacs.  It requires a Google Map Static API key to function.")
      (license license:gpl3+))))

(define-public emacs-geoclue
  (let ((commit "f409b544be4d2cfd848f4658618374b0bc76cb3c")
        (revision "1"))
    (package
      (name "emacs-geoclue")
      (version (git-version "0.8.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/emacs-weirdware/geoclue.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1ggyn9rvc6si3xy1rrw2f2hyw6cys4bgb9v0ah0qq65y3dnziq6m"))))
      (build-system emacs-build-system)
      (home-page "https://codeberg.org/emacs-weirdware/geoclue")
      (synopsis "Determine your current location using GeoClue2 over D-Bus")
      (description "This package provides an Emacs library which lets you
determine your current location using GeoClue2 over D-Bus.")
      (license (list license:gpl3+)))))

(define-public emacs-nominatim
  (let ((revision "0")
        (commit "f814e16f8f4e2cfd633f52b29699a009ab704fbf"))
    (package
      (name "emacs-nominatim")
      (version (git-version "0.9.3" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://codeberg.org/emacs-weirdware/nominatim")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "19nw2iy8fxy6mfd4nwrdfa23a74a1b644400xx0900fwn6ihjhpl"))))
      (build-system emacs-build-system)
      (home-page "https://codeberg.org/emacs-weirdware/nominatim")
      (synopsis "Forward and reverse geocode using Nominatim inside Emacs")
      (description "This is an Emacs library which lets you forward and
reverse geocode using Nominatim, a component of OpenStreetMap.")
      (license license:gpl3+))))

(define-public emacs-org-street
  (let ((revision "0")
        (commit "17913afe01504ee0cbcf83abaca18c5c618f9b33"))
    (package
      (name "emacs-org-street")
      (version (git-version "0.7.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://codeberg.org/emacs-weirdware/org-street")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1a5mnnvs4yxrw4s71z9ap65xi0fc1ki1qprif5jxn8apswjlmiw1"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-nominatim))
      (home-page "https://codeberg.org/emacs-weirdware/org-street")
      (synopsis "(Reverse) Geocoding for Emacs Org files")
      (description "Org Street is an extension for Org Mode for turning the
names of places into a LOCATION property containing their address.  Given some
freeform text approximately describing a location, it geocodes it with
OpenStreetMap’s Nominatim API to determine a canonical location.  If Nominatim
returns multiple locations, a list is displayed to choose from.")
      (license license:gpl3+))))

(define-public emacs-graphviz-dot-mode
  (package
    (name "emacs-graphviz-dot-mode")
    (version "0.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ppareit/graphviz-dot-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1v1p85wk73nfsvv66qf90flgf9dqhmv15z1r7q4zmc4ifklqn08m"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'configure
            (lambda* (#:key inputs #:allow-other-keys)
              (emacs-substitute-variables "graphviz-dot-mode.el"
                ("graphviz-dot-dot-program"
                 (search-input-file inputs "/bin/dot")))))
          (add-before 'install 'make-info
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion "texinfo"
                (substitute* "Makefile"
                  (("\\/usr\\/bin\\/gzip")
                   (search-input-file inputs "/bin/gzip")))
                (invoke "make"
                        "clean"
                        "info"
                        (string-append "TEXINFODIR="
                                       #$(this-package-native-input "texinfo")
                                       "/bin")))))
          (add-after 'install 'install-info
            (lambda _
              (let ((info (string-append #$output "/share/info")))
                (install-file "texinfo/graphviz-dot-mode.info.gz" info)))))))
    (native-inputs
     (list gzip texinfo))
    (inputs (list graphviz))
    (propagated-inputs
     (list emacs-company))
    (home-page "http://ppareit.github.com/graphviz-dot-mode")
    (synopsis "Major mode for editing Graphviz DOT files")
    (description
     "This Emacs package helps you to create @file{.dot} or @file{.gv} files
using the DOT syntax, and use Graphviz to convert these files to diagrams.")
    (license license:gpl2+)))

(define-public emacs-imenu-list
  (let ((commit "b50222378412fbe321622a84cb2b036e084c697a")
        (revision "1")
        (version "0.9"))
    (package
      (name "emacs-imenu-list")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/bmag/imenu-list")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1936dd41fa05ndzf2bwhllvjz97iz0rflkazjipr7dvz5q072wj2"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/bmag/imenu-list")
      (synopsis
       "Automatically tracks the current buffer's imenu entries")
      (description
       "This Emacs minor mode creates an automatically updated buffer called
@code{*Ilist*} that is populated with the current buffer's imenu entries.
This buffer is typically shown as a sidebar (Emacs vertically splits the
window).")
      (license license:gpl3+))))

(define-public emacs-imenu-anywhere
  (package
    (name "emacs-imenu-anywhere")
    (version "1.1.6")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/vspinu/imenu-anywhere")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0lbwfhcl40ayxskvmsvdrg8p63qp086xpzw61bqk4b3fxndxl04h"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/vspinu/imenu-anywhere")
    (synopsis
     "Imenu tag selection across buffers with the same mode/project")
    (description
     "This Emacs package provides navigation for imenu tags across all buffers
that satisfy a filtering criteria.  Available criteria are all buffers with
the same major mode, same project buffers, and user-defined list of friendly
mode buffers.")
    (license license:gpl3+)))

(define-public emacs-mmm-mode
  (package
    (name "emacs-mmm-mode")
    (version "0.5.11")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "mmm-mode-" version ".tar"))
       (sha256
        (base32 "07pda4bvvcmdwkwh8dnfqgvhkdni2wjgps1094kn1j5c9j254741"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/mmm-mode")
    (synopsis "Allow multiple major modes in an Emacs buffer")
    (description
     "MMM Mode is a minor mode that allows multiple major modes to coexist in
a single buffer.")
    (license license:gpl3+)))

(define-public emacs-mmt
  (package
    (name "emacs-mmt")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mrkkrp/mmt")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13vbfc5597v0gd87qyhn10f93nb477vjpg3jlpphbax9fvkf4gav"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/mrkkrp/mmt")
    (synopsis "Classic tools to write Emacs Lisp macros")
    (description "Emacs MMT is a package that contains classic tools for Emacs
Lisp developers who want to write macros with convenience.")
    (license license:gpl3+)))

(define-public emacs-noman
  (package
    (name "emacs-noman")
    (version "0.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/andykuszyk/noman.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0rh1p9nlhkmhfqmp507rz8hwfgwrdvxx0zba41lxsd2admai90wv"))
       (snippet #~(begin
                    (for-each delete-file
                              '("makem.sh" "Makefile" "screencast.gif"))))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command
           #~(list #$(file-append (this-package-native-input "makem")
                                  "/bin/makem.sh") "test")
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'patch-test
                 (lambda _
                   (substitute* "tests/noman-tests.el"
                     (("#!/bin/bash")
                      (string-append "#!" (which "bash")))))))))
    (native-inputs
     (list bash emacs-ert-runner emacs-f makem-minimal))
    (synopsis "Emacs package for browsing CLI command docs without man pages")
    (description
     "Noman is an Emacs package that parses command line help from flags like
@code{--help}, and presents it in an easy-to-navigate Emacs buffer.")
    (home-page "https://github.com/andykuszyk/noman.el")
    (license license:gpl3+)))

(define-public emacs-tablist
  (package
    (name "emacs-tablist")
    (version "1.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacsorphanage/tablist")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "11vmvrhmsxy97bfj7jndpc58bik7177i3wvc45mlyldxwyirs962"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no test suite
    (home-page "https://github.com/politza/tablist")
    (synopsis "Extension for @code{tabulated-list-mode}")
    (description "Tablist is the Emacs package that provides several
additional features to @code{tabulated-list-mode}: it adds marks,
filters, new key bindings and faces.  It can be enabled by
@code{tablist-mode} or @code{tablist-minor-mode} commands.")
    (license license:gpl3+)))

(define-public emacs-djvu
  (package
    (name "emacs-djvu")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "djvu-" version ".tar"))
       (sha256
        (base32 "0i7xwgg2fxndy81lnng6fh9iknals8xvx4f1nmxq7c099bzwb57c"))))
    (build-system emacs-build-system)
    (inputs (list djview djvulibre))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'configure
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((file "djvu.el"))
                ;; Specify the absolute executable locations.
                (make-file-writable file)
                (substitute* file
                  (("\"djvused\"")
                   (string-append "\""
                                  (search-input-file inputs "/bin/djvused")
                                  "\""))
                  (("\"djvm\"")
                   (string-append "\""
                                  (search-input-file inputs "/bin/djvm")
                                  "\""))
                  (("\"ddjvu\"")
                   (string-append "\""
                                  (search-input-file inputs "/bin/ddjvu")
                                  "\"")))
                (emacs-substitute-variables file
                  ("djvu-djview-command"
                   (search-input-file inputs "/bin/djview")))))))))
    (home-page "https://elpa.gnu.org/packages/djvu.html")
    (synopsis "Edit and view Djvu files via djvused")
    (description
     "This package is a front end for the command-line program djvused from
DjVuLibre, see @url{http://djvu.sourceforge.net/}.")
    (license license:gpl3+)))

(define-public emacs-djvu3
  ;; Commit from 2021-06-03.
  (let ((commit "37b675be1d4d436cdd0c3b5d3f13e88b59a7bf18")
        (revision "0"))
    (package
      (name "emacs-djvu3")
      ;; `Version:' header says 1.0
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dalanicolai/djvu3")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0p0izjrgbayx5ybk1n6db5hbrjv9d4kpn57w4iyxdm3h96sp9cmr"))))
      (propagated-inputs
       (list emacs-djvu emacs-tablist))
      (build-system emacs-build-system)
      (home-page "https://github.com/dalanicolai/djvu3")
      (synopsis "Extend djvu.el to display annotations and more")
      (description "This package extends @code{emacs-djvu} with annotation
rendering features and a fast occur search feature using @code{svg.el}.

Other features include:

@itemize
@item clickable links
@item marker extension to @code{svg.el} for providing arrowheads (or other
types of markers)
@item a quite fancy keyboard annotation function
@item an @code{imenu} index function to enable imenu navigation
@item document restore function to open the document at the last location of
the previous session
@end itemize")
      (license license:gpl3+))))

(define-public emacs-pabbrev
  (package
    (name "emacs-pabbrev")
    (version "4.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "pabbrev-" version ".tar"))
       (sha256
        (base32 "0a54ld80s0r9zrc2kd861p4ii3jzqhxykzcnvi64fhxxg3x2aggx"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/pabbrev.html")
    (synopsis "Predictive abbreviation expansion")
    (description
     "The code provides a abbreviation expansion for Emacs.  It is
fairly similar to Dabbrev expansion, which works based on the contents
of the current buffer (or other buffers).

Predictive abbreviation expansion works based on the previously
written text.  Unlike dynamic abbreviation, the text is analysed
during idle time, while Emacs is doing nothing else.")
    (license license:gpl3+)))

(define-public emacs-pdf-tools
  (package
    (name "emacs-pdf-tools")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/vedang/pdf-tools")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1v861fpzck3ky21m4g42h6a6y0cbhc4sjzpzqx0zxd7sfi7rn768"))))
    (build-system gnu-build-system)
    (arguments
     `(#:tests? #f                      ; there are no tests
       #:modules ((guix build gnu-build-system)
                  ((guix build emacs-build-system) #:prefix emacs:)
                  (guix build utils)
                  (guix build emacs-utils))
       #:imported-modules (,@%default-gnu-imported-modules
                           (guix build emacs-build-system)
                           (guix build emacs-utils))
       #:phases
       (modify-phases %standard-phases
         ;; Build server side using 'gnu-build-system'.
         (add-after 'unpack 'enter-server-dir
           (lambda _ (chdir "server")))
         (add-after 'enter-server-dir 'autogen
           (lambda _
             (invoke "bash" "autogen.sh")))
         ;; Build emacs side using 'emacs-build-system'.
         (add-after 'compress-documentation 'enter-lisp-dir
           (lambda _ (chdir "../lisp")))
         (add-after 'enter-lisp-dir 'emacs-patch-variables
           (lambda* (#:key outputs #:allow-other-keys)
             (for-each make-file-writable (find-files "."))

             ;; Set path to epdfinfo program.
             (emacs-substitute-variables "pdf-info.el"
               ("pdf-info-epdfinfo-program"
                (string-append (assoc-ref outputs "out")
                               "/bin/epdfinfo")))
             ;; Set 'pdf-tools-handle-upgrades' to nil to avoid "auto
             ;; upgrading" that pdf-tools tries to perform.
             (emacs-substitute-variables "pdf-tools.el"
               ("pdf-tools-handle-upgrades" '()))))
         (add-after 'enter-lisp-dir 'emacs-make-autoloads
           (assoc-ref emacs:%standard-phases 'make-autoloads))
         (add-after 'emacs-patch-variables 'emacs-expand-load-path
           (assoc-ref emacs:%standard-phases 'expand-load-path))
         (add-after 'emacs-expand-load-path 'emacs-add-install-to-native-load-path
           (assoc-ref emacs:%standard-phases 'add-install-to-native-load-path))
         (add-after 'emacs-add-install-to-native-load-path 'emacs-install
           (assoc-ref emacs:%standard-phases 'install))
         (add-after 'emacs-install 'emacs-build
           (assoc-ref emacs:%standard-phases 'build)))))
    (native-inputs
     (list autoconf automake emacs-minimal pkg-config))
    (inputs
     (list cairo glib libpng poppler zlib))
    (propagated-inputs
     (list emacs-tablist))
    (home-page "https://github.com/vedang/pdf-tools")
    (synopsis "Emacs support library for PDF files")
    (description
     "PDF Tools is, among other things, a replacement of DocView for PDF
files.  The key difference is that pages are not pre-rendered by
e.g. ghostscript and stored in the file-system, but rather created on-demand
and stored in memory.")
    (license license:gpl3+)))

(define-public emacs-saveplace-pdf-view
  (package
    (name "emacs-saveplace-pdf-view")
    (version "1.0.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nicolaisingh/saveplace-pdf-view")
             (commit (string-append "saveplace-pdf-view-" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "03kqxi1f5idq7140f7h7ck5f56p1yvz5vb19dq5bz65iwgdrx6xy"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/nicolaisingh/saveplace-pdf-view")
    (synopsis "Save place in pdf-view buffers for Emacs")
    (description
     "This package extends the built-in Save-Place mode by adding support for
PDF view (see @code{emacs-pdf-tools}).  This package will store the
place (e.g., the current page and zoom) of PDF buffers under PDFView mode or
DocView mode, and revisiting those PDF files later using the same mode will
restore the saved place.")
    (license license:gpl3+)))

(define-public emacs-org-pdftools
  (let ((revision "0")
        (commit "5613b7ae561e0af199f25aacc0a9c34c16638408"))
    (package
      (name "emacs-org-pdftools")
      (version (git-version "1.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/fuxialexander/org-pdftools/")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0p86943abk55bc2402w5lb7115l3b61wv0w07m84wxi4hbfqk8k6"))))
      (build-system emacs-build-system)
      (arguments
       (list #:tests? #f ; there are no tests
             #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'setenv
                   (lambda _
                     (substitute* "org-pdftools.el"
                       ;; Fix a small typo.
                       (("let [(]pdf-isearch-narrow-to-page t[)]")
                        "let ((pdf-isearch-narrow-to-page t))"))
                     (setenv "HOME" "/tmp"))))))
      (propagated-inputs (list emacs-org-noter emacs-pdf-tools))
      (synopsis "Support for links to documents in pdfview mode")
      (description "This package adds support for org links from pdftools buffers
with more precise location control.")
      (home-page "https://github.com/fuxialexander/org-pdftools/")
      (license license:gpl3+))))

(define-public emacs-sage-shell-mode
  (let ((commit "4291700e981a2105d55fa56382ba25046d3d268d")
        (revision "1"))
    (package
      (name "emacs-sage-shell-mode")
      (version (git-version "0.3" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/sagemath/sage-shell-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1dch7cwwslffgnzp1djlhz6a792ci42p4bvazxd9lqzhzal0rsbb"))))
      (build-system emacs-build-system)
      (arguments
       (list #:include #~(cons "\\.py$" %default-include)
             #:phases
             #~(modify-phases %standard-phases
                 ;; Fix duplicate tests in test file.
                 (add-before 'check 'remove-duplicate-test
                   (lambda _
                     (ert-number-tests "test/sage-shell-mode-test.el"
                                       "sage-shell:parse-state-func-call-1")))
                 ;; The test below is meant to be called from a CI environment
                 ;; and can be ignored.
                 (add-before 'check 'skip-failing-test
                   (lambda _
                     (substitute* "test/sage-shell-mode-test.el"
                       (("\\(ert-deftest sage-shell:development-version-test .*"
                         all)
                        (string-append all "(skip-unless nil)\n"))))))
             ;; The "test" command from the Makefile rebuilds everything.  Run
             ;; the tests at a lower level.
             #:test-command #~(list "emacs" "-Q" "-batch"
                                    "-L" "."
                                    "-l" "test/sage-shell-mode-test.el"
                                    "-f" "ert-run-tests-batch-and-exit")))
      (propagated-inputs (list emacs-deferred))
      (home-page "https://github.com/sagemath/sage-shell-mode")
      (synopsis "Emacs front-end for SageMath")
      (description
       "Sage Shell mode provides an Emacs front-end for SageMath.  It can run
the Sage terminal inside Emacs, and allows editing @file{.sage} source files
with a dedicated major mode and sending their contents directly to that
terminal.")
      (license license:gpl3+))))

(define-public emacs-sakura-theme
  (package
    (name "emacs-sakura-theme")
    (version "1.0.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacsfodder/emacs-theme-sakura")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0nxj6gx5virv95sfxbasvr2mh427w5srzjsfawhf58ixif8wkhd0"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-autothemer))
    (home-page "https://github.com/emacsfodder/emacs-theme-sakura")
    (synopsis "Emacs theme of cherry blossoms")
    (description
     "Sakura Emacs theme is the rose tinted fork of @code{Creamsody},
inspired by the Deep Purple.")
    (license license:gpl3+)))

(define-public emacs-pdfgrep
  ;; XXX: Upstream does not tag releases.  The commit below matches latest
  ;; version bump.
  (let ((commit "a4ca0a1e6521de93f28bb6736a5344b4974d144c")
        (revision "1"))
    (package
      (name "emacs-pdfgrep")
      (version (git-version "1.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jeremy-compostella/pdfgrep")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "093sm3ywa338lhhz2ib3ylcgklsbxcsqck2qsaq26i2qxr0r7lq2"))))
      (build-system emacs-build-system)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'patch-pdfgrep-path
                   (lambda* (#:key inputs #:allow-other-keys)
                     (make-file-writable "pdfgrep.el")
                     (emacs-substitute-variables "pdfgrep.el"
                       ("pdfgrep-program"
                        (search-input-file inputs "bin/pdfgrep"))))))))
      (inputs (list pdfgrep))
      (home-page "https://github.com/jeremy-compostella/pdfgrep")
      (synopsis "Emacs module providing @code{grep} comparable facilities but
for PDF files")
      (description
       "pdfgrep is a GNU/Emacs module providing @code{grep} comparable
facilities but for PDF files.  Its usage is similar to the @code{grep}
function.  For example, using the @code{next-error} function gets you to the
next matching page.")
      (license license:gpl3+))))

(define-public emacs-bui
  (package
    (name "emacs-bui")
    (version "1.2.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://notabug.org/alezost/emacs-bui.git")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0sszdl4kvqbihdh8d7mybpp0d8yw2p3gyiipjcxz9xhvvmw3ww4x"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://notabug.org/alezost/emacs-bui")
    (synopsis "Buffer interface library for Emacs")
    (description
     "BUI (Buffer User Interface) is a library for making @code{list} and
@code{info} interfaces to display an arbitrary data of the same
type, for example: packages, buffers, files, etc.")
    (license license:gpl3+)))

(define-public emacs-guix
  (let ((commit "324987fb4a3e67c6f0f565b6605b8fce559f60ee")
        (revision "9"))
    (package
      (name "emacs-guix")
      (version (git-version "0.5.2" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://codeberg.org/guix/emacs-guix/")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1bg8sy20rdpdv1vzim494jwrmd63rd1mn8v94rkdijs9a2cakdkq"))))
      (build-system gnu-build-system)
      (arguments
       (list
        #:modules '((guix build gnu-build-system)
                    ((guix build emacs-build-system) #:prefix emacs:)
                    (guix build utils))
        #:imported-modules `(,@%default-gnu-imported-modules
                             (guix build emacs-build-system)
                             (guix build emacs-utils))
        #:tests? #f    ; no tests
        #:configure-flags
        #~(list (string-append "--with-lispdir="
                               (emacs:elpa-directory #$output)))
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'expand-load-path
              (lambda _
                ((assoc-ref emacs:%standard-phases 'expand-load-path)
                 #:prepend-source? #f))))))
      (native-inputs
       (list autoconf automake emacs-minimal pkg-config texinfo))
      (inputs
       (list (lookup-package-input guix "guile")
             guix))
      (propagated-inputs
       (list emacs-bui
             emacs-dash
             emacs-edit-indirect
             emacs-geiser
             emacs-geiser-guile
             emacs-magit-popup
             guile-gcrypt))
      (home-page "https://guix.gnu.org")
      (synopsis "Emacs interface for GNU Guix")
      (description
       "Emacs-Guix provides a visual interface, tools and features for the GNU
Guix package manager.  Particularly, it allows you to do various package
management tasks from Emacs.  To begin with, run @code{M-x guix-about} or
@code{M-x guix-help} command.")
      (license license:gpl3+))))

(define-public emacs-build-farm
  (package
    (name "emacs-build-farm")
    (version "0.2.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://notabug.org/alezost/emacs-build-farm.git")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0i0bwbav5861j2y15j9nd5m9rdqg9q97zgcbld8pivr9nyxy63lz"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-bui emacs-magit-popup))
    (home-page "https://notabug.org/alezost/emacs-build-farm")
    (synopsis "Emacs interface for Hydra and Cuirass build farms")
    (description
     "This Emacs package provides an interface for Hydra and
Cuirass (build farms used by Nix and Guix).  It allows you to look at
various data related to the build farm projects, jobsets, builds and
evaluations.  The entry point is @code{M-x build-farm} command.")
    (license license:gpl3+)))

(define-public emacs-d-mode
  (package
    (name "emacs-d-mode")
    (version "2.0.12")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Emacs-D-Mode-Maintainers/Emacs-D-Mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mwd412d2kha8avkyhvvkh8r7an859xk18f7phgx7kj989pr3xkr"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f        ; XXX: too many failures
                     #:test-command
                     #~(list "emacs" "-Q" "-batch" "-l" "d-mode-test.el"
                             "-l" "d-mode.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs
     (list emacs-undercover))
    (home-page "https://github.com/Emacs-D-Mode-Maintainers/Emacs-D-Mode")
    (synopsis "Emacs major mode for editing D code")
    (description "This package provides an Emacs major mode for highlighting
code written in the D programming language.")
    (license license:gpl2+)))

(define-public emacs-extempore-mode
  ;; Use the latest commit at time of packaging.  There are no releases or tags.
  (let ((commit "92e0fff482a0a4dc2971c39581c5ea9e84ae5e1c")
        (revision "2"))
    (package
      (name "emacs-extempore-mode")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/extemporelang/extempore-emacs-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1chxl2x9wjblhfknx7aa8pgqppc60917n437bxapx4hp3275x16q"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/extemporelang/extempore-emacs-mode")
      (synopsis "Emacs major mode for Extempore source files")
      (description
       "This package provides a major mode for editing Extempore code.  It can
create an Extempore REPL, connect the current @code{extempore-mode} buffer to a
running Extempore process, and more.")
      (license license:bsd-2))))

(define-public emacs-external-completion
  (package
    (name "emacs-external-completion")
    (version "0.1")
    (source (origin
              (method url-fetch)
              (uri (string-append
                    "https://elpa.gnu.org/packages/external-completion-" version
                    ".tar"))
              (sha256
               (base32
                "12pddwp5jby2icshj77w4kwxv75zi00jdxw18f721d7zx3l7q668"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/external-completion.html")
    (synopsis "Let external tools control Emacs completion style")
    (description
     "The @code{external} completion style is used with a ``programmable
completion'' table that gathers completions from an external tool such as
a shell utility, an inferior process, an HTTP server.  The table and external
tool are fully in control of the matching of the pattern string to the
potential candidates of completion.  When @code{external} is in use, the usual
styles configured by the user or other in @code{completion-styles} are
ignored.  This compromise is for speed: all other styles need the full data
set to be available in Emacs addressing space, which is often slow if not
completely unfeasible.")
    (license license:gpl3+)))

(define-public emacs-kakoune
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file.
  (let ((commit "d73d14e69ea38076af50cc69f846808383ff539d")
        (revision "0"))
    (package
      (name "emacs-kakoune")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jmorag/kakoune.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0nk6jdy1y5mc3ryd0smiqghrk6iv34d5grc7f7migmshlbq0np92"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-expand-region emacs-multiple-cursors emacs-ryo-modal))
      (home-page "https://github.com/jmorag/kakoune.el")
      (synopsis "Emacs simple simulation, but not emulation, of Kakoune")
      (description "This package provides many, but not all of the editing
primitives in the Kakoune editor.  Unlike Evil mode for Vim, this is a very
shallow emulation, which seeks to do as little work as possible, leveraging
Emacs native editing commands and the work of other packages wherever
possible.")
      (license license:expat))))

(define-public emacs-kana
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file.
  (let ((commit "b239c3c3c6124b46ff720cca7b80ecbafd7fa489")
        (revision "0"))
    (package
      (name "emacs-kana")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/chenyanming/kana")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0vrrl1kniq4h111jvnapvx3wybvsl3alfaygw634mmryr3h7pwi8"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/chenyanming/kana")
      (synopsis "Learn Japanese Kana in Emacs")
      (description
       "This Emacs mode displays Hiragana and Katakana flashcards.  It can use
functionality from Emacs Kanji mode if it is installed.")
      (license license:gpl3+))))

(define-public emacs-kanji
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file.
  (let ((commit "5e9d5b72468ece11cfb81b729be6babf63ede425")
        (revision "0"))
    (package
      (name "emacs-kanji")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/wsgac/kanji-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1zh7klqaza840q5f44zzh1wrnd6sqa2k93z3dgx3yhhsxfd1dxvy"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/wsgac/kanji-mode")
      (synopsis "Emacs minor mode for displaying Japanese Kanji stroke order")
      (description
       "This minor mode displays the stroke order of the Kanji sign under
cursor in a transient buffer.  It has a built-in collection of SVG images
depicting stroke orders for all Kanji.  The collection is a slightly modified
and limited version of the images provided by the KanjiVG project.")
      (license license:gpl3+))))

(define-public emacs-migemo
  (let ((commit "fbc16b57eace9bf25bcb325032c59c50b186b9d7")
        (revision "0"))
    (package
      (name "emacs-migemo")
      (version (git-version "1.9.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-jp/migemo")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "10d27jrmn7k4mqqd5cgqf8jwa0pq9yh2550b1r6lwmz6wx509552"))))
      (build-system emacs-build-system)
      (arguments
       (list
        ;; tests rely on cmigemo, which has not yet been packaged
        #:tests? #f))
      (home-page "https://github.com/emacs-jp/migemo")
      (synopsis
       "Japanese incremental search through dynamic pattern expansion")
      (description
       "This package provides incremental searching through Japanese text through
romanization for Emacs.")
      (license license:gpl2+))))

(define-public emacs-kbd
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file.
  (let ((commit "b9048e928ac403c8a1cf09b4fec75776dc4ecf4f")
        (revision "1"))
    (package
      (name "emacs-kbd")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/slotThe/kbd-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1rcx6aasr2vnhzqx03w3y39w78w0kvqf5j4j863nk18dalx585b2"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/slotThe/kbd-mode")
      (synopsis "Minor mode for syntax highlighting kmonad's @file{.kbd} files")
      (description
       "This minor mode provides syntax highlighting for Lisp-like DSL used in
kmonad's configuration files (@file{.kbd}).")
      (license license:gpl3+))))

(define-public emacs-keycast
  (package
    (name "emacs-keycast")
    (version "1.4.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tarsius/keycast")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1dnr2kfldbghq198bm5h784xmak6kybpfyq90bwwysd5dzli2i98"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "make" "check-declare")))
    (propagated-inputs
     (list emacs-compat))
    (home-page "https://github.com/tarsius/keycast")
    (synopsis "Show current command and its key in the mode line")
    (description
     "This package provides Keycast mode.  Once enabled, that mode shows the
current command and its key or mouse binding in the mode line, and updates
them whenever another command is invoked.")
    (license license:gpl3+)))

(define-public emacs-keyfreq
  (package
    (name "emacs-keyfreq")
    (version "20160516.716")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "http://melpa.org/packages/keyfreq-"
                           version ".el"))
       (sha256
        (base32
         "008hd7d06qskc3mx0bbdgpgy2pwxr8185fzlyqf9qjg49y74p6g8"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/dacap/keyfreq")
    (synopsis "Track Emacs command frequencies")
    (description "@code{emacs-keyfeq} tracks and shows how many times you used
a command.")
    (license license:gpl3+)))

(define-public emacs-khardel
  (package
    (name "emacs-khardel")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/DamienCassou/khardel")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0gqijnmj24phryi6n74iq410k0637j0li1ncdymxhk3bdmp4mb40"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #false              ;no tests
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'fix-path
                 (lambda* (#:key inputs #:allow-other-keys)
                   (emacs-substitute-variables "khardel.el"
                     ("khardel-command"
                      (search-input-file inputs "/bin/khard"))))))))
    (inputs
     (list khard))
    (propagated-inputs
     (list emacs-yaml-mode))
    (home-page "https://github.com/DamienCassou/khardel")
    (synopsis "Emacs interface to Khard")
    (description
     "Khardel provide an Emacs integration with Khard, a console application
to search and edit contacts in vCard format.")
    (license license:gpl3+)))

(define-public emacs-ligature
  (let ((commit "3d1460470736777fd8329e4bb4ac359bf4f1460a")
        (revision "1"))
    (package
      (name "emacs-ligature")
      (version (git-version "1.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/mickeynp/ligature.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1rnx2mp8y1phnvfirmf4a6lza38dg2554r9igyijl9rgqpjax94d"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/mickeynp/ligature.el")
      (synopsis "Typographic ligatures in Emacs")
      (description
       "This package maps ordinary graphemes (characters) to fancy ligatures,
if both your version of Emacs and the font supports it.  With this package you
can control where Emacs must display ligatures.  That is useful if you only
want a subset of the ligatures in certain major modes, for instance, or if you
want to ensure that some modes have no ligatures at all.")
      (license license:gpl3+))))

(define-public emacs-olivetti
  (package
    (name "emacs-olivetti")
    (version "2.0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rnkn/olivetti")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0q1z07z0nkvzplmsqni25hqhv81x3r7f1xahjjkskmllrhksz0bh"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f)) ; Linting but not testing.
    (home-page "https://github.com/rnkn/olivetti")
    (synopsis "Emacs minor mode for a nice writing environment")
    (description "This package provides an Emacs minor mode that puts writing
in the center.")
    (license license:gpl3+)))

(define-public emacs-undo-tree
  (package
    (name "emacs-undo-tree")
    (version "0.8.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/tsc25/undo-tree")
             (commit "42aab056e37e033816b2d192f9121b89410b958e"))) ; no 0.8.2 tag
       (file-name (git-file-name name version))
       (sha256
        (base32 "1xvkxc078b4z5zqwndz6jcv4ga8yd2ci32v7l8pdvqjmz7fq7bfz"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-queue))
    (home-page "https://www.dr-qubit.org/undo-tree.html")
    (synopsis "Treat undo history as a tree")
    (description
     "Tree-like interface to Emacs undo system, providing
graphical tree presentation of all previous states of buffer that
allows easily move between them.")
    (license license:gpl3+)))

(define-public emacs-undo-fu
  ;; There are no tagged releases upstream, instead we are using
  ;; the most recent commit.
  (let ((commit "0e22308de8337a9291ddd589edae167d458fbe77")
        (revision "0"))
    (package
      (name "emacs-undo-fu")
      (version (git-version "0.5" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/ideasman42/emacs-undo-fu")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "18c8lq4h3i5rzz8jwwszmq9ga1m7jk3sbrh76sgrsbdawpap3ak5"))))
      (build-system emacs-build-system)
      (home-page "https://codeberg.org/ideasman42/emacs-undo-fu")
      (synopsis "Simple, stable linear undo with redo for Emacs")
      (description
       "This is a light weight wrapper for Emacs built-in undo system,
adding convenient undo/redo without losing access to the full undo history,
allowing you to visit all previous states of the document if you need.")
      (license license:gpl3+))))

(define-public emacs-undo-fu-session
  ;; There are no tagged releases upstream, instead we are using the
  ;; most recent commit.
  (let ((commit "a6c4f73bc22401fd36e0f2fd4fe058bb28566d84")
        (revision "0"))
    (package
      (name "emacs-undo-fu-session")
      (version (git-version "0.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/ideasman42/emacs-undo-fu-session")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "03pb88bi5z4f01972jbk9z6w9iqamqflfp20mih29ghvbiyn6ahj"))))
      (build-system emacs-build-system)
      (arguments
       (list
        ;; The tests require temp files handling which a recent change disabled
        ;; by default. We re-enable it here to make tests work again.
        #:test-command #~(list "emacs" "--batch" "--eval"
                               "(setq undo-fu-session-ignore-temp-files nil)"
                               "-l" "tests/undo-fu-session-test.el"
                               "-f" "undo-fu-session-test-run-all")
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'set-home
              (lambda _
                (setenv "HOME" "/tmp"))))))
      (home-page "https://codeberg.org/ideasman42/emacs-undo-fu-session")
      (synopsis "Save & recover undo steps between Emacs sessions")
      (description "This package writes undo/redo information upon file save
which is restored where possible when the file is loaded again.")
      (license license:gpl3+))))

(define-public emacs-inflections
  (package
    (name "emacs-inflections")
    (version "2.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/eschulte/jump.el")
             (commit version)))
       (file-name (git-file-name name version))
       (snippet #~(begin (delete-file "jump.el")))
       (sha256
        (base32 "03fh7i6blnbc0zbmp83fk095hr3q4fdvrvfxad74zghcbc2nk7b7"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/eschulte/jump.el")
    (synopsis "Convert english words between singular and plural")
    (description "This package provides an Emacs library for converting
english words between singular and plural.")
    (license license:gpl3+)))

(define-public emacs-blight
  (package
    (name "emacs-blight")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/emacs-weirdware/blight")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1k1w1jr56pp8dgcpdxrymiam1hxsdy7nh6gi5l17pimwba3r4wbm"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-udev-rules-absolute-path-bins
            (lambda _
              (substitute* "20-backlight.rules"
                (("/bin/chgrp") (which "chgrp"))
                (("/bin/chmod") (which "chmod")))))
          (add-after 'install 'install-udev-rules
            (lambda _
              (install-file "20-backlight.rules"
                            (string-append #$output "/lib/udev/rules.d")))))))
    (home-page "https://codeberg.org/emacs-weirdware/blight")
    (synopsis "Control display brightness")
    (description
     "Blight allows you to control display brightness from Emacs.  It features
object-oriented code using EIEIO, a base class implementing a reasonable API
which focuses on the @emph{set the back light to this percentage}
functionality, it includes a concrete implementation that uses SysFS to
control brightness.  Other systems (D-Bus, xbacklight, XELB using XRandR) are
easily supportable, giving the same experience across environments.")
    (license license:gpl3+)))

(define-public emacs-symon
  (package
    (name "emacs-symon")
    (version "20160630")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/zk-phi/symon")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1q7di9s8k710nx98wnqnbkkhdimrn0jf6z4xkm4c78l6s5idjwlz"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/zk-phi/symon")
    (synopsis "Tiny graphical system monitor")
    (description
     "Tiny graphical system monitor for the Emacs minibuffer when idle.")
    (license license:gpl2+)))

(define-public emacs-lemon
  (package
    (name "emacs-lemon")
    (version "2.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/emacs-weirdware/lemon")
             (commit "b10e992a25757a91723c7d554a5fa8e14291e702")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "18yclk2zzqcahzhz2kq8g9gy1xnnxiy6rxs2lwhskj475kvwy2f9"))))
    (build-system emacs-build-system)
    (arguments
     (list
      ;; Only one test out of the four passes
      #:test-command #~(list "emacs" "-Q" "--batch" "-L" "."
                             ;; "-l" "lemon--test.el"
                             ;; "-l" "lemon-monitor--test.el"
                             ;; "-l" "lemon-sparkline--test.el"
                             "-l" "lemon-time--test.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (native-inputs
     (list emacs-blight emacs-emms))
    (propagated-inputs
     (list emacs-s))
    (home-page "https://codeberg.org/emacs-weirdware/lemon")
    (synopsis "System monitors in the echo area")
    (description
     "Lemon is a tiny system monitor which displays system information in
the echo area when Emacs is has been idle for a few seconds.  This is a fork
of zk_phi’s Symon, which has been largely rewritten.  It works nicely with
EXWM.")
    (license license:gpl3+)))

(define-public emacs-sx
  (let ((revision "1")
        (commit "8c1c28f33d714fc8869e49f5642e1a585c8c85af"))
    (package
      (name "emacs-sx")
      (version (git-version "0.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/vermiculus/sx.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0jkmb8x28v8jnhgm9zibyjn6q5dmssv24gq1084jwx2kzg135sjm"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases #~(modify-phases %standard-phases
                     (add-after 'unpack 'fix-emacs-30-build
                       (lambda _
                         (substitute* "sx-question-print.el"
                           ((":foreground nil t")
                            ":foreground nil 'default")))))
        #:tests? #f  ; Tests are broken on emacs@30
        #:test-command
        #~(list "emacs" "--batch" "-L" "." "-l" "ert" "-l" "test/tests.el"
                "-f" "ert-run-tests-batch-and-exit")))
      (propagated-inputs
       (list emacs-markdown-mode))
      (home-page "https://github.com/vermiculus/sx.el")
      (synopsis "Emacs StackExchange client")
      (description
       "Emacs StackExchange client.  Ask and answer questions on
Stack Overflow, Super User, and other StackExchange sites.")
      (license license:gpl3+))))

(define-public emacs-skempo
  (package
    (name "emacs-skempo")
    (version "0.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/xFA25E/skempo")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0xsr6819qaad0y8rhfrf555c9w7cmgbgkf1a2svgbp7rhhnywl0a"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/xFA25E/skempo")
    (synopsis "Enhancements for skeleton/tempo + abbrev")
    (description
     "Skempo is an attempt to improve Emacs built-in Skeleton and Tempo
templates.  It tries to make a unified syntax for template definitions.  It
also adds tags and marks support for Skeleton, and Abbrev support for Tempo.")
    (license license:gpl3+)))

(define-public emacs-toc-org
  (package
    (name "emacs-toc-org")
    (version "1.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/snosov1/toc-org")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "00a2al7ghrlabf65kfj1mk30p2pl37h6ppwlgghbgiy7rwlzkdbm"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/snosov1/toc-org")
    (synopsis "Table of Contents generator for Emacs Org mode")
    (description
     "This package generates a table of contents when saving in Org and
Markdown files.")
    (license license:gpl2+)))

(define-public emacs-toml-mode
  (let ((version "0.1.3")
        (revision "0")
        (commit "f6c61817b00f9c4a3cab1bae9c309e0fc45cdd06"))
    (package
      (name "emacs-toml-mode")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dryman/toml-mode.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "05b4ksay85c8y5ncax0qsvnmplwsfiw24z16a58gkarjz938hb57"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/dryman/toml-mode.el")
      (synopsis "Emacs major mode for editing TOML files")
      (description
       ;; XXX: Ideally we'd use @acronym for "TOML", but Guile's Texinfo
       ;; parser does not currently support @comma{}, making it impossible
       ;; to use commas in the @acronym arguments.
       "This package provides a major mode for editing files in @dfn{TOML}
(Tom's Obvious, Minimal Language) data format.")
      (license license:gpl3+))))

(define-public emacs-twittering-mode
  (package
    (name "emacs-twittering-mode")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "mirror://sourceforge/twmode"
                           "/twittering-mode-" version
                           "/twittering-mode-" version ".tar.xz"))
       (sha256
        (base32 "02imis1gxz90lah0b5n37j2hlsaw5igss11d85vpsm5d1bgw8j28"))))
    (build-system emacs-build-system)
    (home-page "https://twmode.sourceforge.net")
    (synopsis "Emacs major mode for Twitter")
    (description
     "Twittering mode is an Emacs major mode for Twitter.
You can check timelines, tweet, mark posts as favorites and so on with
Emacs.")
    (license license:gpl2+)))

(define-public emacs-fountain-mode
  (package
    (name "emacs-fountain-mode")
    (version "3.7.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rnkn/fountain-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "15r0pzdmimm72jx26zgdxf7fwwcppl45vvh33xx5wnhqzd140hwn"))))
    (arguments
     (list
      #:tests? #f                       ; no actual tests
      #:phases #~(modify-phases %standard-phases
                   (add-after 'unpack 'add-contrib
                     (lambda _
                       (copy-recursively "contrib" "."))))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rnkn/fountain-mode")
    (synopsis "Major mode for screenwriting in Fountain markup")
    (description "Fountain Mode is a scriptwriting program for GNU Emacs
using the Fountain plain text markup format.")
    (license license:gpl3+)))

(define-public emacs-fringe-helper
  (let ((commit "ef4a9c023bae18ec1ddd7265f1f2d6d2e775efdd")
        (revision "1"))
    (package
      (name "emacs-fringe-helper")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/nschum/fringe-helper.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0ra9rc53l1gvkqank8apasl3r7wz2yfjrcvmfk3wpxhh24ppxv9d"))))
      (build-system emacs-build-system)
      (arguments
       `(#:test-command '("emacs" "--batch"
                          "-l" "tests.el"
                          "-f" "ert-run-tests-batch-and-exit")))
      (home-page "https://github.com/nschum/fringe-helper.el")
      (synopsis "Helper functions for fringe bitmaps")
      (description
       "This package allows fringe bitmaps to be defined with a visual string
representation.")
      (license license:gpl2+))))

(define-public emacs-git-gutter
  (package
    (name "emacs-git-gutter")
    (version "0.93")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-git-gutter")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0qjp1gind95py0zfc3a32j7g6bmdh0pszpyiazqqzxm3rz82m7rn"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (home-page "https://github.com/syohex/emacs-git-gutter")
    (synopsis "See and manage hunks of text in a version control system")
    (description
     "This package is an Emacs minor mode for displaying and interacting with
hunks of text managed in a version control system.  Added modified and deleted
areas can be indicated with symbols on the edge of the buffer, and commands
can be used to move between and perform actions on these hunks.

Git, Mercurial, Subversion and Bazaar are supported, and many parts of the
display and behaviour is easily customisable.")
    (license license:gpl3+)))

(define-public emacs-git-gutter-fringe
  (let ((commit "648cb5b57faec55711803cdc9434e55a733c3eba")
        (revision "2"))
    (package
      (name "emacs-git-gutter-fringe")
      (version (git-version "0.23" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsorphanage/git-gutter-fringe")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "13bqq5r8ys2mmw1ffsm6hn6fji0vq3nx3slw98c9dgbvlprkaiip"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ; no tests
      (propagated-inputs
       (list emacs-git-gutter emacs-fringe-helper))
      (home-page "https://github.com/emacsorphanage/git-gutter-fringe")
      (synopsis "See and manage hunks of text in a version control system")
      (description
       "This package extends @code{git-gutter} to use the fringe area of a
window.")
      (license license:gpl3+))))

(define-public emacs-git-link
  (package
    (name "emacs-git-link")
    (version "0.10.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sshaw/git-link")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1cq456q908nmbz2br578fhi8vq2jh11nf0axxa7913gd7dhmqklg"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "make" "test")))
    (home-page "https://github.com/sshaw/git-link")
    (synopsis "Create links for files and commits in GitHub/GitLab/etc. repos")
    (description
     "@code{git-link} returns the URL for the current buffer's file location
at the current line number or active region.  @code{git-link-commit} returns
the URL for a commit.  URLs are added to the kill ring.")
    (license license:gpl3+)))

(define-public emacs-frowny
  (package
    (name "emacs-frowny")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/duckwork/frowny.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "01ss3js71as1jpqcf0x9hfvapiyyhj9ni4y1n6wvqsghv5dcaiy0"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/duckwork/frowny.el")
    (synopsis "Insert frownies in Emacs :(")
    (description "This package ships @code{frowny-mode}, which makes it so that
inserting a single @code{(} when after a @code{:} will not automatically close
the parenthesis, meaning that only @code{:(} is inserted.  Works with
@code{electric-pair-mode}, @code{paredit-mode}, and others.")
    (license license:public-domain)))

(define-public emacs-apache-mode
  (package
    (name "emacs-apache-mode")
    (version "2.2.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacs-php/apache-mode")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1grs2x51k8pa6sgfa82s5pwwdfv7zw46ccw0zvd2rvzbhpq21p2z"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacs-php/apache-mode")
    (synopsis
     "Syntax highlighting and indentation support for Apache config files")
    (description
     "This package provides @code{apache-mode}, an Emacs major mode for Apache
configuration files which provides syntax highlighting and indentation rules.
This mode supports Apache HTTP Server 2.4 and major modules.")
    (license license:gpl2+)))

(define-public emacs-apheleia
  (package
    (name "emacs-apheleia")
    (version "4.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/raxod502/apheleia")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ldj6cny88b7j0jspv68sw5z9jpfpqimavmbnhcbq7gmc6xlbmvz"))))
    (build-system emacs-build-system)
    (native-inputs (list emacs-buttercup))
    (home-page "https://github.com/raxod502/apheleia")
    (synopsis "Reformat buffer stably")
    (description
     "This package allows for a buffer to be reformatted without moving point,
so that running a formatting tool like @code{Prettier} or @code{Black} upon
saving won't move point back to the beginning of the buffer.")
    (license license:gpl3+)))

(define-public emacs-git-timemachine
  (package
    (name "emacs-git-timemachine")
    (version "4.13")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/pidu/git-timemachine")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "152vq34dn76m21ab97wwm31hgp2wl9y437vwmd4kcd5pvwjhx9c6"))))
    (build-system emacs-build-system)
    (home-page "https://gitlab.com/pidu/git-timemachine")
    (synopsis "Step through historic versions of Git-controlled files")
    (description "This package enables you to step through historic versions
of files under Git version control from within Emacs.")
    (license license:gpl3+)))

(define-public emacs-minitest
  (package
    (name "emacs-minitest")
    (version "0.9.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/arthurnn/minitest-emacs")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0d8kg68yy5x1y3ivj43vzcakb3gii6bh8jm40g4sah5f53bbrs16"))))
    (build-system emacs-build-system)
    (arguments
     '(#:include (cons "^snippets\\/minitest-mode\\/" %default-include)
       #:exclude (delete "^[^/]*tests?\\.el$" %default-exclude)))
    (propagated-inputs
     (list emacs-dash emacs-f))
    (home-page "https://github.com/arthurnn/minitest-emacs")
    (synopsis "Emacs minitest mode")
    (description
     "The minitest mode provides commands to run the tests for the current
file or line, as well as rerunning the previous tests, or all the tests for a
project.

This package also includes relevant snippets for yasnippet.")
    (license license:expat)))

(define-public emacs-gdscript-mode
  (package
    (name "emacs-gdscript-mode")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/godotengine/emacs-gdscript-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "09q0himrz7a6xgz0jmcl85qc5xhk5fwi6d2vw1n8qaiavm96ksdy"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/godotengine/emacs-gdscript-mode")
    (synopsis "GDScript support and syntax highlighting in Emacs")
    (description
     "This package adds support for the GDScript programming language from the
Godot game engine in Emacs.  It features all the essentials, e.g., syntax
highlighting, code folding, indentation, automatic pairing, auto-completion,
and code formatting.")
    (license license:gpl3+)))

(define-public emacs-ef-themes
  (package
    (name "emacs-ef-themes")
    (version "2.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/protesilaos/ef-themes")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0qfq9p1dvny7abx0q7gcjd1zhzvwr0w37rwphn307wcg1dqc4nzq"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (propagated-inputs
     (list emacs-modus-themes))
    (native-inputs (list texinfo))
    (home-page "https://protesilaos.com/emacs/ef-themes")
    (synopsis "Colorful and legible themes")
    (description
     "The Ef themes are a collection of light and dark themes for GNU Emacs
whose goal is to provide colorful yet legible options for users who want
something with a bit more flair than the Modus themes.")
    (license (list license:gpl3+
                   license:fdl1.3+))))

(define-public emacs-doric-themes
  (package
    (name "emacs-doric-themes")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/protesilaos/doric-themes")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "06zhm0w3j474n190simv18rqzsfq3lsq9m7ljr3a4fswd3hvx846"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ;no tests
    (home-page "https://github.com/protesilaos/doric-themes")
    (synopsis "Highly readable minimalist Emacs themes")
    (description
     "This package provides a set of Emacs themes that conform with a
minimalist aesthetic: they use few colours and appear monochromatic in many
contexts")
    (license license:gpl3+)))

(define-public emacs-eslint-flymake
  (let ((commit "c78246330ee3ac1e0e07a709473d98a113d268e5")
        (revision "1"))
    (package
      (name "emacs-eslint-flymake")
      (version "0.2.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-pe/eslint-flymake")
               (commit commit)))
         (sha256
          (base32 "19h95k57hrsysmvqzillzfn6wcinvcidv14fvbaqxgigwfwj0jnw"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-flymake))
      (home-page "https://github.com/emacs-pe/eslint-flymake")
      (synopsis "ESLint backend for Flymake")
      (description
       "This package lets Flymake run ESLint on the current buffer.")
      (license license:gpl3+))))

(define-public emacs-spark
  (let ((version "20160503")  ; no proper tag, use date of commit
        (commit "0bf148c3ede3b31d56fd75f347cdd0b0eae60025")
        (revision "1"))
    (package
      (name "emacs-spark")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alvinfrancis/spark")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1ykqr86j17mi95s08d9fp02d7ych1331b04dcqxzxnmpkhwngyj1"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/alvinfrancis/spark")
      (synopsis "Sparkline generation library for Emacs Lisp")
      (description "@code{emacs-spark} is a sparkline generation library for
Emacs Lisp.  It generates a sparkline string given a list of numbers.  It is a
port of @code{cl-spark} to Emacs Lisp.")
      (license license:expat))))

(define-public emacs-spray
  (let ((version "0.0.2") (revision "0")
        (commit "74d9dcfa2e8b38f96a43de9ab0eb13364300cb46"))
    (package
      (name "emacs-spray")
      (version (git-version version revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://git.sr.ht/~iank/spray")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1avbfr32dvff26kgvd5vgan99nb5c6al9kv5xbmy2rcls17py7r2"))))
      (build-system emacs-build-system)
      (home-page "https://git.sr.ht/~iank/spray")
      (synopsis "Speed reading mode for Emacs")
      (description
       "For speed reading, or just more enjoyable reading.  Narrows
the buffer to show one word at a time.  Adjust speed / pause as needed.")
      (license license:gpl3+))))

(define-public emacs-es-mode
  (package
    (name "emacs-es-mode")
    (version "4.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dakrone/es-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1qhfnd5anp5qrmravv7ks5ix763xnki2f5jwcyj70qyxwr0l60cg"))))
    (build-system emacs-build-system)
    (propagated-inputs
     ;; The version of org in Emacs 24.5 is not sufficient, and causes tables
     ;; to be rendered incorrectly
     (list emacs-dash emacs-org emacs-spark))
    (home-page "https://github.com/dakrone/es-mode")
    (synopsis "Major mode for editing Elasticsearch queries")
    (description "@code{es-mode} includes highlighting, completion and
indentation support for Elasticsearch queries.  Also supported are
@code{es-mode} blocks in @code{org-mode}, for which the results of queries can
be processed through @code{jq}, or in the case of aggregations, can be
rendered in to a table.  In addition, there is an @code{es-command-center}
mode, which displays information about Elasticsearch clusters.")
    (license license:gpl3+)))

(define-public emacs-expand-region
  (package
    (name "emacs-expand-region")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magnars/expand-region.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mw1jlgdp17k56rq4g801z7y35h4infm9cy3mh8jw5wqqar5ifa6"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/magnars/expand-region.el")
    (synopsis "Increase selected region by semantic units")
    (description
     "Expand region increases the selected region by semantic units.  Just
keep pressing the key until it selects what you want.  There's also
@code{er/contract-region} if you expand too far.")
    (license license:gpl3+)))

(define-public emacs-expreg
  ;; No Git tags. Version from library header; commit matches version bump.
  (let ((commit "b1dc64aef8ed8498a6d21e5e78ce7e0bda8407e0"))
    (package
      (name "emacs-expreg")
      (version "1.4.1")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/casouri/expreg")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0a8wn553g3vj6zp5rqz9axy3dfsyqpc7gh0m85d32hycy0m8yha0"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))      ; No tests.
      (home-page "https://github.com/casouri/expreg")
      (synopsis "Increase selected region by semantic units with tree-sitter")
      (description
       "@code{expreg}, like @code{expand-region}, provides commands to expand
and contract the region by semantic units.  Unlike @code{expand-region},
@code{expreg} can leverage Emacs 29's tree-sitter support.")
      (license license:gpl3+))))

(define-public emacs-filladapt
  (package
    (name "emacs-filladapt")
    (version "2.12.2")
    (source
      (origin
        (method url-fetch)
        (uri (string-append
               "https://elpa.gnu.org/packages/filladapt-"
               version ".el"))
        (sha256
          (base32
            "1cxyxfdjg1dsmn1jrl6b7xy03xr42fb6vyggh27s4dk417ils6yg"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/filladapt.html")
    (synopsis "Adaptive fill for Emacs")
    (description
     "This package provides functions which enhance the default behavior of
Emacs' Auto Fill mode and the commands @code{fill-paragraph},
@code{lisp-fill-paragraph}, @code{fill-region-as-paragraph}, and
@code{fill-region}.

The chief improvement is that the beginning of a line to be
filled is examined and, based on information gathered, an
appropriate value for fill-prefix is constructed.  Also the
boundaries of the current paragraph are located.  This occurs
only if the fill prefix is not already non-nil.

The net result of this is that blurbs of text that are offset
from left margin by asterisks, dashes, and/or spaces, numbered
examples, included text from USENET news articles, etc. are
generally filled correctly with no fuss.")
    (license license:gpl3+)))

(define-public emacs-fill-column-indicator
  (package
    (name "emacs-fill-column-indicator")
    (version "1.90")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alpaker/Fill-Column-Indicator")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0snjznxdwwfdgccdcvrnk467416r244r2r5qcm2sga8l0ha9gw9z"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/FillColumnIndicator")
    (synopsis "Graphically indicate the fill column")
    (description
     "Fill-column-indicator graphically indicates the location of the fill
column by drawing a thin line down the length of the editing window.")
    (license license:gpl3+)))

(define-public emacs-greader
  (let ((commit "c3f28c1ca3d6dea5b44b0c7677c94a4a20d6370b")) ;version bump
    (package
      (name "emacs-greader")
      (version "0.13.0")
      (source
       (origin
         (uri (git-reference
                (url "https://gitlab.com/michelangelo-rodriguez/greader")
                (commit commit)))
         (method git-fetch)
         (file-name (git-file-name name version))
         (sha256
          (base32 "1al5cqkh7x0wmhf69780pgdm77zrrq5c323nmbqsbifh65d468l6"))))
      (build-system emacs-build-system)
      (arguments
       (list #:tests? #f))              ;no tests
      (inputs (list emacs-compat espeak-ng))
      (home-page "https://gitlab.com/michelangelo-rodriguez/greader")
      (synopsis
       "Gnamù Reader, or Greader, sends buffer contents to a speech engine")
      (description
       "Greader is a module that sends any Emacs buffer to a @acronym{TTS,
Text To Speech} engine, such as Espeak-NG or Speech Dispatcher.

The mode supports timer reading, automatic scrolling of buffers in modes like
Info mode, and repeating reading of regions or the whole buffer.  It also
includes a feature to facilitate the compilation of Espeak-NG
pronunciations.")
      (license license:gpl3+))))

(define-public emacs-grep-a-lot
  (package
    (name "emacs-grep-a-lot")
    (version "1.0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ZungBang/emacs-grep-a-lot")
             (commit "9f9f645b9e308a0d887b66864ff97d0fca1ba4ad")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1f8262mrlinzgnn4m49hbj1hm3c1mvzza24py4b37sasn49546lw"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ZungBang/emacs-grep-a-lot")
    (synopsis "Enables multiple grep buffers in Emacs")
    (description
     "This Emacs package allows managing multiple grep buffers.")
    (license license:gpl3+)))

(define-public emacs-fd
  (package
    (name "emacs-fd")
    (version "0.1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/yqrashawn/fd-dired")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1fas0fpvym2lyzybwm44gly9jz6a2fpp72yxnwfbqqjkfgk9910y"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/yqrashawn/fd-dired")
    (synopsis "Dired-mode interface for fd result")
    (description "This package provides a dired-mode interface for fd's
result.")
    (license license:gpl3+)))

(define-public emacs-ripgrep
  (package
    (name "emacs-ripgrep")
    (version "0.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nlamirault/ripgrep.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1a5rdpmvsgsjlc9sywism9pq7jd6n9qbcdsvpbfkq1npwhpifkbj"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "ert-runner")
           #:phases
           #~(modify-phases %standard-phases
               ;; The repository contains both ripgrep and projectile-ripgrep
               ;; packages. The latter has been merged into projectile itself.
               (add-after 'unpack 'delete-projectile-ripgrep
                 (lambda _
                   (delete-file "projectile-ripgrep.el"))))))
    (native-inputs (list emacs-ert-runner))
    (propagated-inputs (list ripgrep))
    (home-page "https://github.com/nlamirault/ripgrep.el")
    (synopsis "Search using ripgrep from inside Emacs")
    (description "@code{ripgrep} is an Emacs search package based on the
@command{ripgrep} command line tool.")
    (license license:gpl2+)))

(define-public emacs-rg
  (package
    (name "emacs-rg")
    (version "2.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dajva/rg.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "19vczsw4f36gn0n7gfmq5j919m813rr9s4vg8kjh20ysnl04qqxl"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "ert-runner" "--pattern" "rg-unit")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'remove-rg-path
            ;; Remove the path to ripgrep so that it works on remote systems.
            (lambda _
              (let ((file "rg.el"))
                (make-file-writable file)
                (emacs-substitute-sexps file
                  ("(defcustom rg-executable" "rg")))))
          (add-before 'check 'skip-failing-tests
            (lambda _
              (substitute* (list "test/rg-isearch.el-test.el"
                                 "test/rg-menu.el-test.el")
                (("\\(ert-deftest rg-unit/isearch-project.*" all)
                 (string-append all " (skip-unless nil)"))
                (("\\(ert-deftest rg-unit/menu-define-search.*" all)
                 (string-append all " (skip-unless nil)"))
                (("\\(ert-deftest rg-unit/menu-transient-insert.*" all)
                 (string-append all " (skip-unless nil)"))))))))
    (propagated-inputs
     (list emacs-s emacs-wgrep ripgrep))
    (native-inputs (list emacs-ert-runner))
    (home-page "https://rgel.readthedocs.io/en/latest/")
    (synopsis "Search tool based on @code{ripgrep}")
    (description
     "@code{rg} is an Emacs search package based on the @code{ripgrep} command
line tool.  It allows one to interactively search based on the editing context
then refine or modify the search results.")
    (license license:gpl3+)))

(define-public emacs-inf-ruby
  (package
    (name "emacs-inf-ruby")
    (version "2.9.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nonsequitur/inf-ruby")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ah4hfy17x4ikrg3q555q7qfmz021wmfm5v11l1id3aqfqira599"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/nonsequitur/inf-ruby")
    (synopsis "Provides a REPL buffer connected to a Ruby subprocess in Emacs")
    (description
     "@code{inf-ruby} provides a Read Eval Print Loop (REPL) buffer, allowing
for easy interaction with a Ruby subprocess.  Features include support for
detecting specific uses of Ruby, e.g., when using Rails, and using an
appropriate console.

If you are using Guix shell with @file{manifest.scm}, the
@code{inf-ruby-wrapper-command} customization variable could be helpful.")
    (license license:gpl3+)))

(define-public emacs-chruby
  (let ((version "1.0")
        (commit "42bc6d521f832eca8e2ba210f30d03ad5529788f")
        (revision "0"))
    (package
      (name "emacs-chruby")
      (version (git-version version revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/plexus/chruby.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256 (base32 "06pvjw40qk017py9km26vjrh90acycnkr5r04nxf664qqkjlg2mc"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/plexus/chruby.el")
      (synopsis "Emacs support for the Chruby version switcher for Ruby")
      (description "This package lets you switch Ruby versions using chruby.")
      (license license:gpl3+))))

(define-deprecated-package emacs-chruby-el
  emacs-chruby)

;; Package has no release.  Version is extracted from "Version:" keyword in
;; main file.
(define-public emacs-zeno-theme
  (let ((commit "70fa7b7442f24ea25eab538b5a22da690745fef5")
        (revision "0"))
    (package
      (name "emacs-zeno-theme")
      (version (git-version "1.0.2" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/zenobht/zeno-theme")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "10v6yf9c5qdsxrp6rk1n1xkv4byyfkinsikskdb2apjg05cx2273"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/zenobht/zeno-theme")
      (synopsis "Dark theme using different shades of blue for Emacs")
      (description
       "This package provides a dark theme using different shades of blue for
Emacs, inspired by @code{Dracula} theme.")
      (license license:gpl3+))))

(define-public emacs-zig-mode
  (let ((commit "f0b4a487530146f99230f4a5ff67e8d56c8f3f80")
        (revision "2"))
    (package
      (name "emacs-zig-mode")
      (version (git-version "0.0.8" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ziglang/zig-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1cm4wvddvqyjhlp7wngls1lapsiq1n14qgi1ygiq3w2vryg96s1v"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:emacs emacs
        #:test-command #~(list "emacs" "--batch"
                               "-l" "zig-mode.el"
                               "-l" "test/zig-tests.el"
                               "-f" "ert-run-tests-batch-and-exit")))
      (propagated-inputs (list emacs-reformatter))
      (home-page "https://github.com/ziglang/zig-mode/")
      (synopsis "Zig mode for Emacs")
      (description
       "This package provides syntax highlighting and automatic indentation
for the Zig programming language in Emacs.")
      (license license:gpl3+))))

(define-public emacs-zk
  (package
    (name "emacs-zk")
    (version "0.7")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/localauthor/zk/")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0449zsahyzvjlhv27lkj33ybnq86j47paww779zd0qhq550hdnjs"))))
    (arguments
     (list
      #:tests? #f ; There are no tests.
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'configure
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "zk.el"
                (("\"grep")
                 (string-append
                  "\""
                  (search-input-file inputs "/bin/grep")))
                (("\"egrep")
                 (string-append
                  "\""
                  (search-input-file inputs "/bin/egrep")))))))))
    (propagated-inputs (list emacs-citar emacs-link-hint))
    (inputs (list grep))
    (build-system emacs-build-system)
    (home-page "https://github.com/localauthor/zk/")
    (synopsis "Zettelkasten-style linked notes for Emacs")
    (description
     "Emacs packages for working with Zettelkasten-style linked notes.")
    (license license:gpl3+)))

(define-public emacs-erc
  (package
    (name "emacs-erc")
    (version "5.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/erc-" version ".tar"))
       (sha256
        (base32 "13dzip6xhj0mf8hs8wk08pfxny5gwpbzfsqkmz146xvl2d8m621x"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-compat))
    (home-page "https://www.gnu.org/software/emacs/erc.html")
    (synopsis "An Emacs Internet Relay Chat client")
    (description
     "ERC is a powerful, modular, and extensible IRC client for Emacs.")
    (license license:gpl3+)))

(define-public emacs-znc
  (package
    (name "emacs-znc")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sshirokov/ZNC.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ran86ycnays9s23wk3iczqqgnpbyx0lijiarx65am3jc1yzg5ia"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/sshirokov/ZNC.el")
    (synopsis "Make ERC and ZNC get along better")
    (description
     "This is a thin wrapper around @code{erc} that enables one to use the ZNC
IRC bouncer with ERC.")
    (license license:expat)))

(define-public emacs-erc-irc-format
  (package
    (name "emacs-erc-irc-format")
    (version "0.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/fmqa/erc-irc-format")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1l6jgj7rh8wzbvszlfn5h4dydkc7p5cfin9fm0jf9krlbiig67aj"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ;no tests
    (home-page "https://github.com/fmqa/erc-irc-format")
    (synopsis "IRC formatting code extension package for ERC")
    (description
     "A @acronym{UI, User Interface} for
@uref{https://modern.ircdocs.horse/formatting, @acronym{IRC, Internet
Relay Chat} formatting control codes}, for usage within ERC.")
    (license license:gpl3+)))

(define-public emacs-erc-status-sidebar
  (let ((commit "ea4189a1dbfe60117359c36e681ad7c389e2968c")
        (revision "1"))
    (package
      (name "emacs-erc-status-sidebar")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/drewbarbs/erc-status-sidebar")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1hwlhzgx03z8891sblz56zdp8zj0izh72kxykgcnz5rrkyc3vfi3"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/drewbarbs/erc-status-sidebar")
      (synopsis "Hexchat-like activity overview for ERC channels")
      (description
       "This package provides a Hexchat-like status bar for joined channels in
ERC, an Emacs client for IRC (Internet Relay Chat).  It relies on the
@code{erc-track} module, and displays all the same information
@code{erc-track} does in the mode line, but in an alternative format.")
      (license license:gpl3+))))

(define-public emacs-paren-face
  (package
    (name "emacs-paren-face")
    (version "1.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tarsius/paren-face")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0bs5hdn7agyr0r0ywblpihp4x3gn89xdfvzsb8wlyd0gvc2rx6g9"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "make" "check-declare")))
    (propagated-inputs
     (list emacs-compat))
    (home-page "https://github.com/tarsius/paren-face")
    (synopsis "Face for parentheses in Lisp modes")
    (description
     "This library defines a face named @code{parenthesis} used just for
parentheses.  The intended purpose of this face is to make parentheses less
visible in Lisp code by dimming them.  Lispers probably don't need to be
constantly made aware of the existence of the parentheses.  Dimming them might
be even more useful for people new to Lisp who have not yet learned to
subconsciously blend out the parentheses.")
    (license license:gpl3+)))

(define-public emacs-page-break-lines
  (package
    (name "emacs-page-break-lines")
    (version "0.15")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/page-break-lines")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "11b9mxxly3jsiha1znprkbfsgcxppjr2a6qza1xb3pysk3k8szha"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (home-page "https://github.com/purcell/page-break-lines")
    (synopsis "Display page breaks as tidy horizontal lines")
    (description
     "This library provides a global mode which displays form feed characters
as horizontal rules.")
    (license license:gpl3+)))

(define-public emacs-simple-httpd
  (package
    (name "emacs-simple-httpd")
    (version "1.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/skeeto/emacs-web-server")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0dpn92rg813c4pq7a1vzj3znyxzp2lmvxqz6pzcqi0l2xn5r3wvb"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/skeeto/emacs-web-server")
    (synopsis "HTTP server in pure Emacs Lisp")
    (description
     "This package provides a simple HTTP server written in Emacs Lisp to
serve files and directory listings.")
    (license license:unlicense)))

(define-public emacs-skewer-mode
  (package
    (name "emacs-skewer-mode")
    (version "1.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/skeeto/skewer-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ha7jl7776pk1bki5zj2q0jy66450mn8xr3aqjc0m9kj3gc9qxgw"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-simple-httpd emacs-js2-mode))
    (arguments '(#:tests? #f            ; no tests
                 #:include '("\\.el$" "\\.js$" "\\.html$")))
    (home-page "https://github.com/skeeto/skewer-mode")
    (synopsis "Live web development in Emacs")
    (description
     "Skewer-mode provides live interaction with JavaScript, CSS, and HTML in
a web browser.  Expressions are sent on-the-fly from an editing buffer to be
evaluated in the browser, just like Emacs does with an inferior Lisp process
in Lisp modes.")
    (license license:unlicense)))

(define-public emacs-litable
  (let ((commit "b0278f3f8dcff424bfbdfdefb545b1fbff33206f"))
    (package
      (name "emacs-litable")
      (version (git-version "0.1" "0" commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/Fuco1/litable")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0bny40hv9a024n01clxns351cs4j4ifhgcc7m4743xncqf612p7g"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash))
      (home-page "https://github.com/Fuco1/litable/")
      (synopsis "Dynamic evaluation replacement with Emacs")
      (description "This package provides dynamic evaluation in Emacs.")
      (license license:gpl3+))))

(define-public emacs-literate-elisp
  (package
    (name "emacs-literate-elisp")
    (version "0.8")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/jingtaozf/literate-elisp")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32 "0i9468rh61l4xq918fgwk6li93lpm6zbn0lkpxr7pbvkgrl5xsr6"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/jingtaozf/literate-elisp/tags")
    (synopsis "Load Emacs Lisp code blocks from Org files")
    (description
     "Literate-Elisp is an Emacs lisp library to provide an easy way to use
literal programming in Emacs lisp.  It extends the Emacs load mechanism so
Emacs can load Org files as Lisp source files directly.")
    (license license:gpl3+)))

(define-public emacs-calc-currency
  (let ((commit "7021d892ef38b01b875082aba4bae2517ce47ae6")
        (revision "0"))
    (package
      (name "emacs-calc-currency")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jws85/calc-currency")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0y4m0hasg4ji6zfis3088hq90pm9998lnnh8yg9g8yqqaqpfizp8"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "emacs" "--batch"
                               "-L" "."
                               "-l" "test/calc-currency-init.el"
                               "-l" "test/calc-currency-ecb-test.el"
                               "-l" "test/calc-currency-oxr-test.el"
                               ;; test/calc-currency-utils-test.el fails
                               "-f" "ert-run-tests-batch-and-exit")))
      (propagated-inputs (list emacs-f))
      (home-page "https://github.com/jws85/calc-currency")
      (synopsis "Add currency units to Emacs Calc")
      (description "This package adds custom units to the units table in Emacs
Calc by fetching exchange rates backends.")
      (license license:gpl3+))))

(define-public emacs-literate-calc-mode
  (let ((commit "ba7d22140a165b0fdd900a8d04916115ca6ab8ff")
        (revision "2"))
    (package
      (name "emacs-literate-calc-mode")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sulami/literate-calc-mode.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1bdybw44pmhfpikdv1kg2sx88546xyncks5a4b2s0ak4p66r82k3"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-s))
      (home-page "https://github.com/sulami/literate-calc-mode.el")
      (synopsis "Literate programming for Emacs Calc")
      (description
       "This library provides literate programming for Calc.  There is both
a major and a minor mode.  The major mode does some basic syntax highlighting,
while the minor mode only evaluates all Calc statements while typing.  In
particular, the minor mode works quite well with Org or Markdown modes, or
other markup language major modes.")
      (license license:gpl3+))))

(define-public emacs-standard-dirs
  (package
    (name "emacs-standard-dirs")
    (version "2.0.0")
    (home-page "https://github.com/lafrenierejm/standard-dirs.el")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0r814qcrhvx4qlx4sdzwdmrhiryslqclx0bnpp0qcrbx6g8qfl25"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-f emacs-s))
    (synopsis "Platform-specific paths for config, cache, and other data")
    (description
     "This package provides platform-specific paths for reading and writing
configuration, cache, and other data.")
    (license license:gpl3+)))

(define-public emacs-standard-themes
  (package
    (name "emacs-standard-themes")
    (version "3.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/protesilaos/standard-themes")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fv8vh67c7lpipcpmcnr0skilj29cjlc86s8m4bfwmycjzikc332"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (propagated-inputs
     (list emacs-modus-themes))
    (native-inputs (list texinfo))
    (home-page "https://protesilaos.com/emacs/standard-themes")
    (synopsis "Like the default Emacs theme but more consistent")
    (description
     "The standard-themes are a pair of light and dark themes for GNU Emacs.
They emulate the out-of-the-box looks of Emacs (which technically do
@emph{not} constitute a theme) while bringing to them thematic consistency,
customizability, and extensibility.")
    (license (list license:gpl3+
                   license:fdl1.3+))))  ;GFDLv1.3+ for the manual

(define-public emacs-string-inflection
  (package
    (name "emacs-string-inflection")
    (version "1.0.16")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/akicho8/string-inflection")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0wskrp3v5gi3b3s9471ijkdncnfd888qd50c72rv2p8846174paj"))))
    (build-system emacs-build-system)
    (native-inputs
     (list emacs-ert-runner))
    (home-page "https://github.com/akicho8/string-inflection")
    (synopsis "Convert symbol names between different naming conventions")
    (description
     "This Emacs package provides convenient methods for manipulating the
naming style of a symbol.  It supports different naming conventions such as:

@enumerate
@item camel case
@item Pascal case
@item all upper case
@item lower case separated by underscore
@item etc...
@end enumerate\n")
    (license license:gpl2+)))

(define-public emacs-stripe-buffer
  (package
    (name "emacs-stripe-buffer")
    (version "0.2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sabof/stripe-buffer")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "035ym1c1vzg6hjsnd258z4dkrfc11lj4c0y4gpgybhk54dq3w9dk"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/sabof/stripe-buffer/")
    (synopsis "Add stripes to list buffers")
    (description
     "This Emacs package adds faces to add stripes to list buffers and org
tables.")
    (license license:gpl2+)))

(define-public emacs-org-beautify-theme
  ;; Latest release (0.4) is not tagged, use commit hash.
  (let ((commit "df6a1114fda313e1689363e196c8284fbe2a2738")
        (revision "0"))
    (package
      (name "emacs-org-beautify-theme")
      (version "0.4")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jonnay/org-beautify-theme")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1lkz7736swimad12khwbbqc4gxjydgr1k45p4mx03s25pv1w920y"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/jonnay/org-beautify-theme")
      (synopsis "Theme to make Org mode look more beautiful")
      (description
       "The theme adds padding between headings, increases the size of titles,
strike through completed TODO headings, changes Org blocks, changes Org check
boxes, and more.")
      (license license:gpl3+))))

(define-public emacs-org-books
  (package
    (name "emacs-org-books")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/lepisma/org-books")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1sgckvpjdaig9r2clcvs6ckgf2kx7amikkpq26y30jbnfnbskf0v"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash
           emacs-enlive
           emacs-helm
           emacs-helm-org
           emacs-org
           emacs-s))
    (home-page "https://github.com/lepisma/org-books")
    (synopsis "Reading list management with Org mode and Helm")
    (description
     "Org Books is a tool for managing reading lists in an Org mode file.")
    (license license:gpl3+)))

(define-public emacs-org-chef
  ;; Upstream does not tag version bumps.  Version is extracted from "Version"
  ;; keyword in main file.
  (let ((commit "9f749324f7e8c51a2da8516820268c83e825c6c7")
        (revision "1"))
    (package
      (name "emacs-org-chef")
      (version (git-version "0.1.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Chobbes/org-chef")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0ii763fhfrd47ivkndml09ivn5s21vy35a182xasb42bji8mmqv8"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:emacs emacs-no-x                ;need libxml support
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'patch-tests-to-include-full-file-path
              (lambda _
                (substitute* "tests/org-chef-json-ld-test.el"
                  (("\"json-ld")
                   "\"tests/json-ld")))))
        #:test-command #~(list "ert-runner" "tests")))
      (native-inputs (list emacs-ert-runner))
      (home-page "https://github.com/Chobbes/org-chef")
      (synopsis "Cookbook and recipe management with Emacs Org mode")
      (description
       "Org Chef is a package for managing recipes in Org mode.  One of the
main features is that it can automatically extract recipes from websites like
allrecipes.com.")
      (license license:expat))))

(define-public emacs-org-inline-pdf
  (package
    (name "emacs-org-inline-pdf")
    (version "0.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/shg/org-inline-pdf.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "04rfv4qsyhc8w23hbzw8k5f292lafkgf1n0gbbkgc93gifx91s4f"))))
    (build-system emacs-build-system)
    (inputs
     (list pdf2svg))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-exec-paths
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((pdf2svg (search-input-file inputs "/bin/pdf2svg")))
                (substitute* "org-inline-pdf.el"
                  (("\"pdf2svg\"") (string-append "\"" pdf2svg "\"")))))))))
    (home-page "https://github.com/shg/org-inline-pdf.el")
    (synopsis "Inline PDF previewing for Org")
    (description "This package provides a minor mode that enables
inline PDF preview in Org buffers by using @command{pdf2svg}.")
    (license license:gpl3+)))

(define-public emacs-org-rainbow-tags
  (let ((commit "dfe36047bc9646b621452f3e2e97170e99e2b43f")
        (revision "1"))
    (package
      (name "emacs-org-rainbow-tags")
      (version (git-version "0.1-pre" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/KaratasFurkan/org-rainbow-tags")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1rhgvbhsbm999l5kg19747dxwscd5h5sl330d6a422f0dxvvxqrq"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/KaratasFurkan/org-rainbow-tags")
      (synopsis "Colorize Org tags automatically")
      (description
       "This package adds random colors to your Org tags.  In order to make
colors random but consistent between same tags, colors are generated from the
hash of the tag names.")
      (license license:gpl3+))))

(define-public emacs-comment-tags
  ;; Upstream didn't tag a working version.
  (let ((commit "7d914097f0a03484af71e621db533737fc692f58")
        (revision "1"))
    (package
      (name "emacs-comment-tags")
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/vincekd/comment-tags.git")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0s86a7078arck9z4gzkp2hnxyklprl0zh5hsw7nkyyscjydly80i"))))
      (build-system emacs-build-system)
      (synopsis "Minor mode to show comments which have tags like TODO")
      (description "This package provides a minor mode to show all lines that
have a comment with a tag, for example listing them right next to each other.")
      (home-page "https://github.com/vincekd/comment-tags")
      (license license:gpl3+))))

(define-public emacs-org-rich-yank
  (package
    (name "emacs-org-rich-yank")
    (version "0.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/unhammer/org-rich-yank")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0cajgkfcwqgqdqyqf01hxji28n27jmj9nf0w3rbyw6l5dffgch0n"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/unhammer/org-rich-yank")
    (synopsis "Surround source code pasted into Org with @code{#+BEGIN_SRC}
blocks")
    (description
     "This package provides a utility function for Org buffers that makes a
@code{_SRC} block with the appropriate language annotation for code that has
been copied from an Emacs major mode.")
    (license license:gpl2+)))

(define-public emacs-org-fancy-priorities
  (let ((commit "819bb993b71e7253cefef7047306ab4e0f9d0a86")
        (revision "1"))
    (package
      (name "emacs-org-fancy-priorities")
      (version (git-version "1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/harrybournis/org-fancy-priorities.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "13cyzlx0415i953prq6ch7r5iy23c1pz116bdxi5yqags4igh4wv"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/harrybournis/org-fancy-priorities")
      (synopsis "Display org priorities as custom strings")
      (description
       "This package provides a minor mode that displays Org priorities as
custom strings.  This mode does not change your files in any way, it only
displays the priority part of a heading as your preferred string value.")
      (license license:expat))))

(define-public emacs-org-fragtog
  (package
    (name "emacs-org-fragtog")
    (version "0.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/io12/org-fragtog")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1xag0pdphigk0ilrj2hacai3p6xgl27jji08aa1zlhq7p3rbay7m"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-org))
    (home-page "https://github.com/io12/org-fragtog")
    (synopsis "Toggle Org mode LaTeX fragments preview at cursor")
    (description
     "Org mode supports inline image previews of LaTeX fragments.  This
package automates this, so fragment previews are disabled for editing when
your cursor steps onto them, and re-enabled when the cursor leaves.")
    (license license:gpl3+)))

(define-public emacs-ob-erlang
  (let ((revision "1")
        (commit "a029c23902b4ad73b84f262a7fc5b98d87b63dfd"))
    (package
      (name "emacs-ob-erlang")
      (version (git-version "20210321" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/xfwduke/ob-erlang")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1dlb9qgmijff4giglwb358g5zzyjbnay0wkr5spks1bawvyxpiyl"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/xfwduke/ob-erlang/")
      (synopsis "Org-babel support for Erlang")
      (description "This package adds support for working with Erlang code
blocks with @code{org-babel} in @code{org-mode}.")
      (license license:gpl3+))))

(define-public emacs-ob-go
  (let ((commit "2067ed55f4c1d33a43cb3f6948609d240a8915f5")
        (revision "0"))
    (package
      (name "emacs-ob-go")
      (version (git-version "0.02" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/pope/ob-go")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "069w9dymiv97cvlpzabf193nyw174r38lz5j11x23x956ladvpbw"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "emacs" "--batch" "-L" "."
                               "--eval=(require 'ob-go)"
                               "-l" "test-ob-go.el"
                               "-f" "ert-run-tests-batch-and-exit")
        #:phases #~(modify-phases %standard-phases
                     (add-after 'unpack 'ert-number-tests
                       (lambda _
                         (ert-number-tests "test-ob-go.el"
                                           "ob-go/string-variables")
                         (ert-number-tests "test-ob-go.el"
                                           "ob-go/imports"))))))
      (home-page "https://github.com/pope/ob-go")
      (synopsis "Org Babel support for evaluating Go code")
      (description "@code{ob-go} enables Org Babel support for evaluating Go
code.  It was created based on the usage of @code{ob-C}.")
      (license license:gpl3+))))

(define-public emacs-ob-gptel
  (let ((commit "60e704a390d767a7d06c8d3845ba8786b75f7da3")
        (revision "2"))
    (package
      (name "emacs-ob-gptel")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/jwiegley/ob-gptel/")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0l4abglx5q8ym2ii6my58001v98jhqd0c0jpvbk4dz2i3h9rsxqv"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ;no tests
      (propagated-inputs
       (list emacs-gptel))
      (home-page "https://github.com/jwiegley/ob-gptel/")
      (synopsis "Org Babel support for evaluating @code{gptel} prompts.")
      (description "@code{ob-gptel} is a backend for Org Babel.  It provides
an alternative interface to evaluate @{gptel} prompts as Org mode blocks.")
      (license license:gpl3+))))

(define-public emacs-ob-restclient
  (let ((commit "1b021ce1c67c97fa1aa4d2c0816edb7add129e48"))
    (package
      (name "emacs-ob-restclient")
      (version (git-version "0.02" "3" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alf/ob-restclient.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1bcjj01q5n9w2cch6brbz8pzwnwsmdlgaa4sf5s97b9frmqb2ffg"))))
      (propagated-inputs
       (list emacs-restclient))
      (build-system emacs-build-system)
      (home-page "https://github.com/alf/ob-restclient.el")
      (synopsis "Org-babel functionality for @code{restclient-mode}")
      (description
       "This package integrates @code{restclient-mode} with Org.")
      (license license:gpl3+))))

(define-public emacs-org-now
  (let ((commit "8f6b277a73f1c66e58ccb4b7f40d406851befc91"))
    (package
      (name "emacs-org-now")
      (version (git-version "0.1-pre" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alphapapa/org-now")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "117zzkryznznk6h4i1jqzdn888nl019xrgxm2gza0lndx8dxsg2c"))))
      (propagated-inputs
       (list emacs-dash))
      (build-system emacs-build-system)
      (home-page "https://github.com/alphapapa/org-now")
      (synopsis "Show current Org tasks in a sidebar")
      (description
       "This package provides commands to show Org headings in a sidebar
window while working on them.  After defining one heading as the \"now\"
heading, other headings can be refiled to it with one command, and back to
their original location with another.")
      (license license:gpl3+))))

(define-public emacs-orgmdb
  (package
    (name "emacs-orgmdb")
    (version "1.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/isamert/orgmdb.el")
             (commit (string-append "v" version))))
       (sha256
        (base32
         "0ypga3ywmaiv74r14bxn668zvv77mv6dhw6f3hrmlmvm20k7q0f0"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'configure
                 (lambda* (#:key inputs #:allow-other-keys)
                   (substitute* "orgmdb.el"
                     (("\"fd ")
                      (string-append "\""
                                     (search-input-file inputs "/bin/fd")
                                     " "))))))))
    (inputs
     (list fd))
    (propagated-inputs
     (list emacs-dash emacs-org emacs-s))
    (home-page "https://github.com/isamert/orgmdb.el")
    (synopsis "Emacs' Org mode watchlist manager and OMDb API client")
    (description "This package adds tools for managing your watchlist in Emacs'
Org mode and some functions for interacting with the OMDb API.")
    (license license:gpl3+)))

(define-public emacs-rich-minority
  (package
    (name "emacs-rich-minority")
    (version "1.0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Malabarba/rich-minority")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1kn7c9qr9ykj68iqffzzmjsr6aazwac8cxb7j960sjb282rq0yyj"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Malabarba/rich-minority")
    (synopsis "Clean-up and beautify the list of minor modes")
    (description
     "This Emacs package hides and/or highlights minor modes in the
mode-line.")
    (license license:gpl2+)))

(define-public emacs-robe
  (package
    (name "emacs-robe")
    (version "0.8.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dgutov/robe")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14apmvbs89si3v5hsiz11dckp8fdfidm14lc090lswq7mgk7h79s"))))
    (build-system emacs-build-system)
    (arguments
     '(#:include (cons "^lib\\/" %default-include)
       #:test-command (list "make" "ert")))
    (propagated-inputs
     (list emacs-inf-ruby))
    (home-page "https://github.com/dgutov/robe")
    (synopsis "Ruby code assistance tool for Emacs")
    (description
     "Robe can provide information on loaded classes and modules in Ruby code,
as well as where methods are defined.  This allows the user to jump to method
definitions, modules and classes, display method documentation and provide
method and constant name completion.")
    (license license:gpl3+)))

(define-public emacs-robot-mode
  (package
    (name "emacs-robot-mode")
    (version "0.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kopoli/robot-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1a377lws4f0az2y1r3z2i3mghvg7a4094wkchvjvsl1nd6yxdxwa"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/kopoli/robot-mode")
    (synopsis "Emacs mode for Robot Framework")
    (description
     "This major mode facilitates editing Robot Framework source files with
features such as syntax highlighting, comments, finding keywords, completing
keywords and smart indentation.")
    (license license:gpl3+)))

(define-public emacs-robot-log
  (package
    (name "emacs-robot-log")
    (version "0.1.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://git.sr.ht/~apteryx/emacs-robot-log")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1l9yxryrhvylh2x17cczd8v8978w1nv8173d4l9hv0cr26kp5b68"))))
    (build-system emacs-build-system)
    (arguments
     ;; XXX: Tests are currently broken due to python-robotframework.
     (list #:tests? #f))
    (native-inputs (list python-robotframework))
    (home-page "https://sr.ht/~apteryx/emacs-robot-log/")
    (synopsis "Emacs major mode for viewing RobotFramework debug log files")
    (description "@code{robot-log} is an Emacs major mode that allows more
easily viewing and navigating RobotFramework debug log files.  It provides
syntax highlighting and convenient shortcuts to move from one keyword to the
next, or locate errors.")
    (license license:gpl3+)))

(define-public emacs-robots-txt-mode
  (package
    (name "emacs-robots-txt-mode")
    (version "0.0.9")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacs-php/robots-txt-mode")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "07255pn80w4742sz2h9vbmfxxd8ps2kcn73p7m2bgy02kgbzw42b"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacs-php/robots-txt-mode")
    (synopsis "Syntax highlighting for @file{robots.txt} files")
    (description "This package provides an Emacs major mode for editing
@file{robots.txt} files.")
    (license license:gpl3+)))

(define-public emacs-roguel-ike
  (package
    (name "emacs-roguel-ike")
    (version "0.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/stevenremot/roguel-ike")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "02yq2qy17gafkayzxfvf9nwm950cw54hlqgzc4mjb21al75rfyrn"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-popup))
    (arguments
     (list
      #:include #~(cons* "^roguel-ike/" "^roguel-ike-lib/" %default-include)
      #:tests? #t ; no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'set-build-environment
            (lambda _
              (setenv "HOME" "/tmp"))))))
    (home-page "https://github.com/stevenremot/roguel-ike.git")
    (synopsis "Coffee-break roguelike for Emacs")
    (description
     "Roguel-ike is an attempt to develop a coffee-break roguelike for
Emacs.  The complete game would allow the player to create various characters
and to make them fulfill challenges like arena fight and short dungeon
explorations.")
    (license license:gpl3+)))

(define-public emacs-rspec
  (let ((commit "66ea7cc9699d6edc6115daa024818adbd85efc20")
        (revision "1"))
    (package
      (name "emacs-rspec")
      (version (git-version "1.11" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pezra/rspec-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0b11s8r0pi7ah54km4yg4fqff8wkk409d25qnlwm1l94pdwjd1c8"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include (cons "^snippets\\/rspec-mode\\/" %default-include)
         #:test-command '("make" "test")))
      (home-page "https://github.com/pezra/rspec-mode")
      (synopsis "Provides a rspec mode for working with RSpec")
      (description
       "The Emacs RSpec mode provides keybindings for Ruby source files, e.g. to
verify the spec associated with the current buffer, or entire project, as well
as moving between the spec files, and corresponding code files.

Also included are keybindings for spec files and Dired buffers, as well as
snippets for yasnippet.")
      (license license:gpl3+))))

(define-public emacs-vhdl-ext
  (package
    (name "emacs-vhdl-ext")
    (version "0.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/gmlarumbe/vhdl-ext/")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0agiamq7g8zm3blznykbr1kgr09rb133rd4mh9nfc0vfk8i5mabv"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f         ;the testing framework, test-hdl, requires network
      #:test-command #~(list "make")))
    (propagated-inputs
     (list emacs-ag
           emacs-async
           emacs-flycheck
           emacs-hydra
           emacs-lsp-mode
           emacs-ripgrep
           emacs-vhdl-ts-mode))
    (home-page "https://github.com/gmlarumbe/vhdl-ext/")
    (synopsis "Extensions to Emacs @code{vhdl-mode}")
    (description "This package provides additional features and utilities for
@code{vhdl-mode}, such as snippet selection via @code{hydra}, code navigation, code
formatting, and code folding.")
    (license license:gpl3+)))

(define-public emacs-vhdl-mode
  (package
    (name "emacs-vhdl-mode")
    (version "3.39.3")
    (source (origin
              (method url-fetch)
              (uri (string-append
                    "https://iis-people.ee.ethz.ch/~zimmi/emacs/vhdl-mode-"
                    version ".tar.gz"))
              (sha256
               (base32
                "1yvh4gyig8hgf5pahajjgsgp4jpzwgmlprwzsfybqxrcfza6f3yq"))))
    (build-system emacs-build-system)
    (home-page "https://iis-people.ee.ethz.ch/~zimmi/emacs/vhdl-mode.html")
    (synopsis "Major mode for VHDL programming language")
    (description
     "This Emacs package provides a mode for the VHDL programming language.
It tracks the latest version of the same @code{vhdl-mode} package included
with Emacs.")
    (license license:gpl3+)))

(define-public emacs-vhdl-ts-mode
  (package
    (name "emacs-vhdl-ts-mode")
    (version "0.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/gmlarumbe/vhdl-ts-mode/")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0x11sjiy3j43am0clwxsbx7b38pfsl74qgypkc3czs7dh1c5xyrx"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f         ;the testing framework, test-hdl, requires network
      #:test-command #~(list "make")))
    (propagated-inputs (list tree-sitter-vhdl))
    (home-page "https://github.com/gmlarumbe/vhdl-ts-mode/")
    (synopsis "VHDL Tree-sitter mode")
    (description
     "VHDL-ts-mode provides syntax highlighting, indentation, imenu,
which-func, navigation and basic beautify and completion features to navigate
and edit VHDL files.")
    (license license:gpl3+)))

(define-public emacs-typst-ts-mode
  (let ((commit "972dc69d6b8a3f8983f6b8000654f59c8a8d05ba")
        (revision "0"))
    ;; Releases are not tagged, so use commits that change the "Version:"
    ;; keyword in the main file.
    (package
      (name "emacs-typst-ts-mode")
      (version (git-version "0.12.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://codeberg.org/meow_king/typst-ts-mode")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "167kdgbxp8n721xnka803lzgwxrfx4h6m4m2ip0lnfxi2fv007zv"))
         (snippet #~(begin (delete-file "test/basic-syntax.pdf")))))
      (build-system emacs-build-system)
      (propagated-inputs (list tree-sitter-typst))
      ;; There is a 'test' directory, but it is for use during development.
      ;; There are no automated tests.
      (arguments (list #:tests? #f))
      (home-page "https://codeberg.org/meow_king/typst-ts-mode")
      (synopsis "Typst tree-sitter mode")
      (description
       "@code{typst-ts-mode} is a tree-sitter mode for the Typst typesetting and
markup language, providing automatic (re-)compilation, structural navigation,
symbol and documentation lookup, and more.")
      (license license:gpl3+))))

(define-public emacs-mode-line-bell
  (package
    (name "emacs-mode-line-bell")
    (version "0.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/purcell/mode-line-bell")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "13n3di05lgqfm4f8krn3p36yika5znhymp5vr2d747x54hqmgh7y"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f)) ; no tests
    (home-page "https://github.com/purcell/mode-line-bell")
    (synopsis "Flash the mode-line instead of ringing the bell")
    (description
     "This Emacs package provides a global minor mode @code{mode-line-bell-mode}
which sets @code{ring-bell-function} to a function that will briefly flash the
mode-line when the bell is rung.")
    (license license:gpl3+)))

(define-public emacs-mode-line-idle
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file.
  (let ((commit "1dc0115bd4864b8b8cc9cbaac75c03d764070873")
        (revision "0"))
    (package
      (name "emacs-mode-line-idle")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (file-name (git-file-name name version))
         (uri (git-reference
               (url "https://codeberg.org/ideasman42/emacs-mode-line-idle")
               (commit commit)))
         (sha256
          (base32 "006ynxzakfc11lz9s915agdiiisnbfxiv9a7mj9g0890qh7isjvy"))))
      (build-system emacs-build-system)
      (home-page "https://codeberg.org/ideasman42/emacs-mode-line-idle")
      (synopsis "Simple delayed text evaluation for the mode-line")
      (description
       "Mode Line Idle provides a convenient way to defer text evaluation
which integrates into existing mode-line without requiring a minor mode or
configuration.")
      (license license:gpl3+))))

(define-public emacs-nyan-mode
  ;; Tagged release is not up-to-date, according to the "Version:" keyword in
  ;; main file.
  (let ((commit "09904af23adb839c6a9c1175349a1fb67f5b4370")
        (revision "0"))
    (package
      (name "emacs-nyan-mode")
      (version (git-version "1.1.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/TeMPOraL/nyan-mode/")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "03xp4dvq3y3q9xyb6pm9m5gb756rvbxcqk52ind08n7prqv4w1lp"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #f                     ;no tests
        #:include #~(cons* "img/" "mus/" %default-include)
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-sources
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "nyan-mode.el"
                  (("mplayer ")
                   (string-append (search-input-file inputs "bin/mplayer")
                                  " "))))))))
      (inputs (list mplayer))
      (home-page "https://github.com/TeMPOraL/nyan-mode/")
      (synopsis "Nyan Cat as buffer position indicator")
      (description
       "Nyan mode is an analog indicator of your position in the buffer.  The cat
should go from left to right in your mode-line, as you move your point from 0%
to 100%.  You can click on the rainbow or the empty space to scroll backwards
and forwards and also animate it.")
      (license license:gpl3+))))

(define-public emacs-smart-mode-line
  (package
    (name "emacs-smart-mode-line")
    (version "2.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Malabarba/smart-mode-line")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1h5w5lrgrmhpaqwppg5msylh7z78mvwy9mm8xiiv8w4wxvncxxl2"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-rich-minority))
    (home-page "https://github.com/Malabarba/smart-mode-line")
    (synopsis "Color-coded smart mode-line")
    (description
     "Smart Mode Line is a mode-line theme for Emacs.  It aims to be easy to
read from small to large monitors by using colors, a prefix feature, and smart
truncation.")
    (license license:gpl2+)))

(define-public emacs-sqlite
  ;; XXX: There is no tagged commit.
  (let ((commit "dad42b8bbca4994be1871343dd18fd6528ee5797")
        (revision "0"))
    (package
      (name "emacs-sqlite")
      (build-system emacs-build-system)
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/cnngimenez/sqlite.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "06ln4vijl8kii3nzc5cscgsadx1fqgxksflijd3ain83bn8g4wrd"))))
      (home-page "https://gitlab.com/cnngimenez/sqlite.el")
      (synopsis "SQLite interface for Emacs Lisp")
      (description "Emacs SQLite is a simple SQLite interface for connecting
and retrieving information using the SQLite program through Elisp programming.
It is not intended as a user interface.")
      (license license:gpl3+))))

(define-public emacs-sqlite3-api
  (package
    (name "emacs-sqlite3-api")
    (version "0.18")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/pekingduck/emacs-sqlite3-api")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1d1r65ybcf5idbs8sv0l3dna4l1wy3jba9dvv1kkz7zj6qhr48fs"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "make" "test" "EMACS=emacs")
      #:modules '((guix build emacs-build-system)
                  (guix build emacs-utils)
                  (guix build utils))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-module-load
            (lambda _
              (make-file-writable "sqlite3.el")
              (emacs-substitute-sexps "sqlite3.el"
                ("(require 'sqlite3-api nil t)"
                 `(module-load
                   ,(string-append #$output "/lib/sqlite3-api.so"))))))
          (add-before 'check 'build-emacs-module
            (lambda _
              ;; Remove code that fetches constants from the SQLite website
              ;; and the call to generate a timestamp.
              (invoke "sed" "--in-place" "3,4d;24,28d;31d" "tools/gen-consts.sh")
              ;; Remove filter logic from the script that generates the constants.
              (invoke "sed" "--in-place" "7,11d;18,22d" "tools/gen-consts.py")
              ;; Generate the consts.c file.
              (invoke "make" "--directory=tools")
              ;; Remove the SQLITE_STATIC and SQLITE_TRANSIENT
              ;; constants. They cause a compilation warning and would have
              ;; been removed by the original script.
              (invoke "sed" "--in-place" "/ifdef SQLITE_STATIC/,+2d" "consts.c")
              (invoke "sed" "--in-place" "/ifdef SQLITE_TRANSIENT/,+2d" "consts.c")
              ;; Compile the shared object file.
              (invoke "make" #$(string-append "CC=" (cc-for-target)))
              ;; Move the shared object file into /lib.
              (install-file "sqlite3-api.so"
                            (string-append #$output "/lib")))))))
    (native-inputs (list python sed))
    (inputs (list sqlite))
    (home-page "https://github.com/pekingduck/emacs-sqlite3-api")
    (synopsis "Dynamic module for Emacs to access the SQLite C interface")
    (description "This package provides a dynamic module for Emacs that allows
direct access to the SQLite C interface.  It only exposes a subset of the full
SQLite C interface, but should satisfy most user's needs.")
    (license license:gpl3+)))

(define-public emacs-pretty-speedbar
  (let ((commit "56dc9f114fcc55843e182cde1fc9d7a14c261c6a")
        (revision "0"))
    (package
      (name "emacs-pretty-speedbar")
      (version (git-version "0.2" revision commit))
      (source (origin
                (uri (git-reference
                      (url "https://github.com/kcyarn/pretty-speedbar")
                      (commit commit)))
                (method git-fetch)
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1hz67jhvg9n9d07lil6zqciqhh512k0fv54dl605p7vi704ma2ir"))))
      (build-system emacs-build-system)
      (propagated-inputs (list font-awesome))
      (home-page "https://github.com/kcyarn/pretty-speedbar")
      (synopsis "SVG icons for the Emacs Speedbar")
      (description
       "This package generates and implements appealing SVG icons for the
Emacs Speedbar.  By default, it generates icons from the Font Awesome fontset.
However, alternative fontsets may also be used, and the color of the icons may
be customized.")
      (license license:gpl3+))))

(define-public emacs-sr-speedbar
  (let ((commit "77a83fb50f763a465c021eca7343243f465b4a47")
        (revision "0"))
    (package
      (name "emacs-sr-speedbar")
      (version (git-version "20161025" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsorphanage/sr-speedbar")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0sd12555hk7z721y00kv3crdybvcn1i08wmd148z5imayzibj153"))))
      (build-system emacs-build-system)
      (home-page "https://www.emacswiki.org/emacs/SrSpeedbar")
      (synopsis "Same frame Emacs @code{speedbar}")
      (description
       "This Emacs package allows you to show @code{M-x speedbar} in the
same frame (in an extra window).  You can customize the initial width of
the speedbar window.")
      (license license:gpl3+))))

(define-public emacs-shell-maker
  (package
    (name "emacs-shell-maker")
    (version "0.84.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/xenodium/shell-maker")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1g0lwv2g5b0cjqsr61jaw902j93wi61qznwl6yybs4hgjj3vjzgg"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ;no tests
    (home-page "https://github.com/xenodium/shell-maker")
    (synopsis "Create Emacs shells")
    (description "Shell Maker is a convenience wrapper around Comint mode.")
    (license license:gpl3+)))

(define-public emacs-shell-switcher
  (package
    (name "emacs-shell-switcher")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/DamienCassou/shell-switcher")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0py95c6i7bffidwkwld1j1h2isyq7psna2kz81jigzz0wi885pjr"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command
                     #~(list "emacs" "--batch" "-L" "."
                             "-l" "test/rswitcher-tests.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/DamienCassou/shell-switcher")
    (synopsis "Provide fast switching between shell buffers")
    (description
     "This package provides commands to quickly switch between shell buffers.")
    (license license:gpl3+)))

(define-public emacs-shx
  ;; XXX: Some tests fails in the latest stable release.
  (let ((commit "b99d16f36bc278d668d8428c4bc9af77064c336a")
        (revision "1"))
    (package
      (name "emacs-shx")
      (version (git-version "1.5.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/riscy/shx-for-emacs")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1wkqnc5n8if8fsh7f3bdr5nzn6dbj1nzdxlmnz8nflmx4g32fp6v"))
                (patches
                 (search-patches "emacs-shx-byte-compilation-test.patch"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command
        #~(list "emacs" "--batch" "--quiet" "--script" "test/script.el")
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'appease-checkdoc
              (lambda _
                (substitute* "shx.el"
                  (("Toggle shx-mode on") "Toggle `shx-mode' on")))))))
      (home-page "https://github.com/riscy/shx-for-emacs")
      (synopsis "Extras for the Comint mode shell")
      (description
       "This package extends Comint mode: it parses markup in the output
stream, enabling plots and graphics to be embedded, and adds command-line
functions which plug into Emacs (e.g., use @code{:e <filename>} to edit
a file).")
      (license license:gpl3+))))

(define-public emacs-names
  (let ((commit "d8baba5360e5253938a25d3e005455b6d2d86971")
        (version "20151201.0")
        (revision "8"))
    (package
      (name "emacs-names")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Malabarba/names")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "11wyha2q8y7bzqq3jrzix8n97ywvsibvddrahqcps1a1yqk4hzfz"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f      ; XXX: "Package cl is deprecated"
                       #:test-command #~(list "make" "test")))
      (home-page "https://github.com/Malabarba/names/")
      (synopsis "Namespace implementation for Emacs Lisp")
      (description
       "This package provides a macro that writes your namespaces for you.")
      (license license:gpl3+))))

(define-public emacs-nameless
  (package
    (name "emacs-nameless")
    (version "1.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Malabarba/Nameless")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "107q1rximjnag9r9vgwh0iv687i3rsscbdnjc46f8l16j6vi4n7d"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Malabarba/nameless")
    (synopsis "Hide package namespace in your Emacs-lisp code")
    (description
     "This package provides a @code{nameless-mode} minor mode in which the
package namespace prefix is ​​hidden by a colon.")
    (license license:gpl2+)))

(define-public emacs-nano-theme
  ;; No named branches.
  (let ((commit "ffe414c8af9c673caf8b8b05ba89a229cb9ad48b")
        (revision "0"))
    (package
      (name "emacs-nano-theme")
      (version (git-version "0.3.4" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/rougier/nano-theme")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0wi5snsakpag7lcdndz10x5fxb0yrnignqdx3v4fm5drbk0d7hkr"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/rougier/nano-theme")
      (synopsis "GNU Emacs / N Λ N O Theme")
      (description
       "Nano is a consistent theme for GNU Emacs which is based on Material
colors and the dark theme is based on Nord colors.")
      (license license:gpl3+))))

(define-public emacs-evil-leader
  (package
    (name "emacs-evil-leader")
    (version "0.4.3")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/cofi/evil-leader")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1k2zinchs0jjllp8zkpggckyy63dkyi5yig3p46vh4w45jdzysk5"))))
    (inputs
     (list emacs-evil))
    (build-system emacs-build-system)
    (home-page "https://github.com/cofi/evil-leader")
    (synopsis "Implement <leader> feature from Vim")
    (description
     "Evil Leader provides the @code{<leader>} feature from Vim that provides
an easy way to bind keys under a configurable prefix key.")
    (license license:gpl3+)))

(define-public emacs-evil-tex
  (package
    (name "emacs-evil-tex")
    (version "1.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/iyefrat/evil-tex")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1wrx8ihimn1sx3vzzfppcwv0yfh3x95jrkxqvzj0ykckipm3zk0b"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'set-home
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list emacs-auctex emacs-evil))
    (home-page "https://github.com/iyefrat/evil-tex")
    (synopsis "Evil oriented additions for editing LaTeX")
    (description "This package is a toolbox for LaTeX editing with Evil.  It
provides many text objects fully utilizing @code{evil-surround}, some useful
movements, and keymaps for quickly entering environments or
@code{cdlatex}-like accents.")
    (license license:gpl3+)))

(define-public emacs-evil-textobj-syntax
  (let ((commit "2d9ba8c75c754b409aea7469f46a5cfa52a872f3")
        (version "0")
        (revision "1"))
    (package
      (name "emacs-evil-textobj-syntax")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/laishulu/evil-textobj-syntax/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "031p5i3274dazp7rz6m5y38shfgszm1clmkcf58qfqlvy978ammc"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil emacs-names))
      (home-page "https://github.com/laishulu/evil-textobj-syntax/")
      (synopsis "Text objects based on syntax highlighting")
      (description
       "This package provides text objects for @code{evil-mode} with
boundaries defined by syntax highlighting.")
      (license license:gpl3+))))

(define-public emacs-flycheck-flow
  (let ((commit "9e8e52cfc98af6a23fd906f9cb5d5d470d8cf82d")
        (version "1.1")
        (revision "1"))
    (package
      (name "emacs-flycheck-flow")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/lbolla/emacs-flycheck-flow")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "14qldlisbmxzammr500gyha2hiv2xgyzfc6mysqii06kbcqn1ik1"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-flycheck))
      (home-page "https://github.com/lbolla/emacs-flycheck-flow")
      (synopsis "Flow support for @code{flycheck-mode}")
      (description
       "This package allows @code{flycheck-mode} to provide syntax-checking
for Flow files.")
      (license license:gpl3+))))

(define-public emacs-flycheck-grammalecte
  (package
    (name "emacs-flycheck-grammalecte")
    (version "2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.umaneti.net/flycheck-grammalecte/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1bv6g3y39ifcyxynmwk619hkfl643s3pa4qrmy7m440dndfqjzxf"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons "\\.py$" %default-include)
      #:emacs emacs-no-x                ;need libxml support
      #:tests? #f  ; Tests require a tty.
      #:test-command
      #~(list "emacs" "-l" "test-home/classic.el" "example.org")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'specify-python-location
            ;; Hard-code python3 executable location in the library.
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((python3 (search-input-file inputs "/bin/python3")))
                (substitute* '("flycheck-grammalecte.el" "grammalecte.el")
                  (("\"python3") (string-append "\"" python3)))
                (substitute* '("conjugueur.py" "flycheck_grammalecte.py")
                  (("/usr/bin/env python3?") python3)))))
          (add-after 'unpack 'specify-grammalecte-location
            ;; Use our own Grammalecte.
            (lambda* (#:key inputs #:allow-other-keys)
              (make-file-writable "grammalecte.el")
              (emacs-substitute-variables "grammalecte.el"
                ("grammalecte-python-package-directory"
                 (search-input-directory
                  inputs
                  (string-append "lib/python"
                                 #$(version-major+minor (package-version python))
                                 "/site-packages/grammalecte"))))))
          (add-after 'unpack 'do-not-phone-home
            ;; Do not check for Grammalecte updates, ever.
            (lambda _
              (make-file-writable "grammalecte.el")
              (emacs-substitute-variables "grammalecte.el"
                ("grammalecte-check-upstream-version-delay" 0)))))))
    (inputs
     (list grammalecte python))
    (propagated-inputs
     (list emacs-flycheck emacs-pkg-info))
    (home-page "https://git.umaneti.net/flycheck-grammalecte/")
    (synopsis "Integrate Grammalecte with Flycheck")
    (description
     "Integrate the French grammar and typography checker Grammalecte with
Flycheck to automatically look for mistakes in your writings.  It also
provides an easy way to find synonyms and antonyms for a given word (to avoid
repetitions for example).")
    (license license:gpl3+)))

(define-public emacs-flycheck-guile
  (package
    (name "emacs-flycheck-guile")
    (version "0.5")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/flatwhatson/flycheck-guile")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "18rkkc7zdcdqp8zlpz6n4zhqky0svacf03arqw0b1whb62p44j9r"))))
    (propagated-inputs
     (list emacs-flycheck emacs-geiser emacs-geiser-guile))
    (build-system emacs-build-system)
    (home-page "https://github.com/flatwhatson/flycheck-guile")
    (synopsis "GNU Guile support for Flycheck")
    (description
     "This package provides a Flycheck checker for GNU Guile using @code{guild
compile}.")
    (license license:gpl3+)))

(define-public emacs-flycheck-ledger
  (package
    (name "emacs-flycheck-ledger")
    (version "0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/flycheck-ledger")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1djrj3is0dzrl2703bw7bclf33dp4xqmy144q7xj5pvpb9v3kf50"))))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'configure
            (lambda _
              (let ((ledger #$(this-package-input "ledger")))
                ;; Specify the absolute executable location of ledger.
                (substitute* "flycheck-ledger.el"
                  (("\"ledger\"") (string-append "\"" ledger "\"")))))))))
    (inputs (list ledger))
    (propagated-inputs
     (list emacs-flycheck))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/flycheck-ledger")
    (synopsis "Ledger support for Flycheck")
    (description
     "This Flycheck checker uses the output of @code{ledger balance} on the
current file to find errors such as unbalanced transactions and syntax
errors.")
    (license license:gpl3+)))

(define-public emacs-flycheck-rust
  (package
    (name "emacs-flycheck-rust")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/flycheck/flycheck-rust")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fh6j5w2387nh2fwwjphkhq17cgj5m2q5k0fhidvgc2w65lzbr1r"))))
    (propagated-inputs
     (list emacs-dash emacs-flycheck emacs-let-alist))
    (native-inputs
     (list emacs-buttercup
           rust-bootstrap-1.54
           `(,rust-bootstrap-1.54 "cargo")))
    (build-system emacs-build-system)
    (home-page "https://github.com/flycheck/flycheck-rust")
    (synopsis "Rust/Cargo support for Flycheck")
    (description
     "This Flycheck extension configures Flycheck automatically for
the current Cargo project.")
    (license license:gpl3+)))

(define-public emacs-flycheck-deno
  (package
    (name "emacs-flycheck-deno")
    (version "0.1.0")
    (source
     (origin
      (method git-fetch)
      (uri
       (git-reference
        (url "https://github.com/flycheck/flycheck-deno")
        (commit version)))
      (file-name (git-file-name name version))
      (sha256
       (base32 "1vvhzidnpzf25z5qn85zx7cpwaavd22vsds4q9y5mpmf8hi526l6"))))
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs
     (list emacs-flycheck))
    (build-system emacs-build-system)
    (home-page "https://github.com/flycheck/flycheck-deno")
    (synopsis "Deno support for Flycheck")
    (description
     "This Flycheck extension configures Flycheck automatically for
  the current Deno project.")
    (license license:gpl3+)))

(define-public emacs-flycheck-package
  (package
    (name "emacs-flycheck-package")
    (version "0.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/flycheck-package")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "00py39n1383761wq6wp194pvyk94ydqdbxj9kl64g9jnipkp7849"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs
     (list emacs-flycheck emacs-package-lint))
    (home-page "https://github.com/purcell/flycheck-package")
    (synopsis "Flycheck checker for elisp package metadata")
    (description
     "This library provides a flycheck checker for the metadata in Emacs Lisp
files which are intended to be packages.")
    (license license:gpl3+)))

(define-public emacs-flymake-proselint
  (let ((commit "9c68ee881f18f554f0ab5bbf5bee1a4b753d792b"))
    (package
      (name "emacs-flymake-proselint")
      (version "0.3.0")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://git.sr.ht/~manuel-uberti/flymake-proselint")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1n8i17il2nfazw3d9kza2r7py61dgdr7kqmg0s1vhrk86qq39669"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-exec-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "flymake-proselint.el"
                  (("\"proselint\"")
                   (string-append
                    "\"" (search-input-file inputs "/bin/proselint") "\""))))))))
      (inputs
       (list python-proselint))
      (home-page "https://git.sr.ht/~manuel-uberti/flymake-proselint")
      (synopsis "Flymake backend for @code{proselint}")
      (description "This package adds support for @code{proselint} in Flymake.")
      (license license:gpl3+))))

(define-public emacs-el-job
  (package
    (name "emacs-el-job")
    (version "2.6.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/meedstrom/el-job")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1m4q0d8j55wgzbwqkwfh0a5dwlag7qcnfg1mjgmg8l8848q88w7q"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "emacs" "-Q" "--batch"
                                  "-l" "el-job-test.el"
                                  "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/meedstrom/el-job")
    (synopsis "Split up the inputs of a function in many sub-processes")
    (description
     "This library gives you the tools to split up the inputs and run the
function in many sub-processes (one per CPU core), then merges their outputs
and passes it back to the current Emacs.  In the meantime, current Emacs does
not hang at all.")
    (license license:gpl3+)))

(define-public emacs-elastic-modes
  (let ((commit "ea49bb03b78cb9fd17655990223e3095f137a3ce")
        (revision "1"))
    (package
      (name "emacs-elastic-modes")
      (version "1.0.0")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jyp/elastic-modes")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1dkigkjw4i9nz5rl0dnic16ljdnp5cyz2xic3hc2myqnjlqnc6z6"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #false)) ;no tests
      (propagated-inputs (list emacs-dash))
      (home-page "https://github.com/jyp/elastic-modes")
      (synopsis "Text and code alignment for variable-width fonts")
      (description
       "This is an Emacs package for text and code alignment for
variable-width (i.e., proportional, or variable pitch) fonts.")
      (license license:gpl3+))))

(define-public emacs-elisp-demos
  (package
    (name "emacs-elisp-demos")
    (version "2024.01.16")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/xuchunyang/elisp-demos")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1pgg5z3z2pf0vps86lrkxfr36v4c24mpgvj551gixdlrm2s55p0l"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons* "\\.org$" %default-include)
      #:test-command #~(list "make" "test")))
    (home-page "https://github.com/xuchunyang/elisp-demos/")
    (synopsis "Enhance @code{*Help*} buffers with additional examples")
    (description
     "This package injects example uses of Elisp functions into their
respective @code{*Help*} buffers.")
    (license license:gpl3+)))

(define-public emacs-docker-compose-mode
  (package
    (name "emacs-docker-compose-mode")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/meqif/docker-compose-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1fbcxwfvm33xcdj3cs26d9i1zyrryyjjkv7sc3mfxd45nq8d3ivj"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-f emacs-yaml-mode))
    (home-page "https://github.com/meqif/docker-compose-mode/")
    (synopsis "Major mode for editing @file{docker-compose} files")
    (description
     "This is a major mode for @file{docker-compose} files that provides
completion of relevant keywords.")
    (license license:expat)))

(define-public emacs-dwim-shell-command
  (package
    (name "emacs-dwim-shell-command")
    ;; This release is untagged, change commit below when updating.
    (version "0.63.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/xenodium/dwim-shell-command")
             (commit "dd742977abaa25991a8b0b8beff1ae9e4bb39fd6")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0b9nzla9gygljchdw04sr8c86h4sh52wqv644fzw5nmzvs9zkagj"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ;No tests.
    (home-page "https://github.com/xenodium/dwim-shell-command")
    (synopsis "Shell commands with @acronym{DWIM, do what I mean} behaviour")
    (description
     "This package provides @code{dwim-shell-command} as an opinionated,
@acronym{DWIM, do what I mean} alternative to @code{shell-command}.")
    (license license:gpl3+)))

(define-public emacs-dvc
  (let ((revision "591")                ;no tags or official releases
        (guix-revision "1"))
    (package
      (name "emacs-dvc")
      (version (string-append "0.0.0-" guix-revision "." revision))
      (source
       (origin
         (method bzr-fetch)
         (uri (bzr-reference
               (url "lp:dvc")
               (revision revision)))
         (sha256
          (base32 "03pqn493w70wcpgaxvqnfgynxghw114l9pyiv3r414d84vzhan6h"))
         (file-name (string-append name "-" version "-checkout"))))
      (build-system gnu-build-system)
      (arguments
       (list
        #:modules `((guix build gnu-build-system)
                    ((guix build emacs-build-system) #:prefix emacs:)
                    (guix build utils))
        #:imported-modules `(,@%default-gnu-imported-modules
                             (guix build emacs-build-system)
                             (guix build emacs-utils))
        #:configure-flags
        #~(list (string-append "--with-lispdir="
                               (emacs:elpa-directory #$output)))
        #:tests? #f                     ;no test suite
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'build 'set-home
              ;; Something in dvc-bookmarks.el attempts to write config files
              ;; in $HOME during the autoload generation.
              (lambda _ (setenv "HOME" (getenv "TMPDIR"))))
            (add-before 'build 'fix-texinfo
              ;; See https://bugs.launchpad.net/dvc/+bug/1264383.
              (lambda _
                (substitute* "texinfo/dvc-intro.texinfo"
                  (("@itemx update ``to''") "@item update ``to''")
                  (("@itemx brief") "@item brief")
                  (("@itemx full") "@item full")
                  (("@itemx drop") "@item drop")
                  (("@itemx left file") "@item left file")))))))
      (native-inputs
       (list autoconf automake emacs-minimal texinfo))
      (home-page "http://xsteve.at/prg/emacs_dvc/index.html")
      (synopsis "Emacs front-end for various distributed version control systems")
      (description "DVC is a legacy Emacs front-end for a number of
distributed version control systems.  It currently supports GNU Arch, GNU
Bazaar, git, Mercurial, and Monotone.  It also provides some integration with
Gnus, e.g., for applying patches received by email.")
      (license license:gpl2+))))

(define-public emacs-sudo-edit
  (package
    (name "emacs-sudo-edit")
    (version "0.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nflath/sudo-edit")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1hncxbg5lvywzkwvdmzvrz71midy4samjq2vvxxhz90z1y5l8l29"))))
    (build-system emacs-build-system)
    (native-inputs
     (list emacs-undercover))
    (arguments
     (list
      #:emacs emacs
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'fix-makefile
            (lambda _
              (substitute* "Makefile"
                (("\\$\\(CASK\\) exec ") "")))))
      #:test-command #~(list "make" "test")))
    (home-page "https://github.com/nflath/sudo-edit/")
    (synopsis "Open files as another user")
    (description
     "This package allows editing files as another user, including the root
user.")
    (license license:gpl3+)))

(define-public emacs-subed
  (package
    (name "emacs-subed")
    (version "1.2.23")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.nongnu.org/nongnu/subed-"
                                  version ".tar"))
              (sha256
               (base32
                "0bvsv688mqhga8dffy3841wxs5pkw0vish15dgligll47cj98mzp"))))
    (arguments
     (list
      #:test-command #~(list "buttercup" "-L" ".")))
    (native-inputs (list emacs-buttercup))
    (inputs (list ffmpeg))
    (build-system emacs-build-system)
    (home-page "https://elpa.nongnu.org/nongnu/subed.html")
    (synopsis "Major mode for editing subtitles")
    (description
     "@code{subed} is an Emacs major mode for editing subtitles while playing
the corresponding video with @code{mpv}.  At the moment, the only supported
formats are SubRip (@file{.srt}), WebVTT (@file{.vtt}), and Advanced
SubStation Alpha (@file{.ass}).")
    (license license:gpl3+)))

(define-public emacs-miniedit
  (package
    (name "emacs-miniedit")
    (version "2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsmirror/miniedit")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1850z96gly0jnr50472idqz1drzqarr0n23bbasslrc501xkg0bq"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacsmirror/miniedit/")
    (synopsis "Enhanced editing for minibuffer fields")
    (description
     "This package provides a function that can be called from the
minibuffer to enable editing the minibuffer input in another buffer with
@code{text-mode} enabled.")
    (license license:gpl2+)))

(define-public emacs-ob-ipython
  (package
    (name "emacs-ob-ipython")
    (version "20180224")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (commit "7147455230841744fb5b95dcbe03320313a77124")
                    (url "https://github.com/gregsexton/ob-ipython")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1a10fc2jk37ni5sjjvf87s5nyaz2a6h2mlj5dxh4dhv5sd3bb85p"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-f))
    (home-page "http://www.gregsexton.org")
    (synopsis "Org-Babel functions for IPython evaluation")
    (description "This package adds support to Org-Babel for evaluating Python
source code using IPython.")
    (license license:gpl3+)))

(define-public emacs-ob-asymptote
  (package
    (name "emacs-ob-asymptote")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/ob-asymptote-"
                           version ".tar"))
       (sha256
        (base32 "0b9glzj3aq39rksb0bg4qvsnqknwjk7lbixapw9695hfr2l4hv02"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/hurrja/ob-asymptote")
    (synopsis "Babel functions for Asymptote")
    (description
     "This package provides Org Babel support for evaluating Asymptote source
code.  This differs from most standard languages in that:
@itemize
@item there is no such thing as a ``session'' in Asymptote,
@item we are generally only going to return results of type @code{file},
@item we are adding the @code{file} and @code{cmdline} header arguments, if
file is omitted then the @samp{-V} option is passed to the @command{asy}
command for interactive viewing.
@end itemize")
    (license license:gpl3+)))

(define-public emacs-ob-async
  (package
    (name "emacs-ob-async")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/astahlman/ob-async")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10x4hxrjm4pr6vg42a961h9ilqzyd0l0fv7fsbq9clxi439f1nd6"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f  ; ~1/2 tests fail.
           #:test-command
           #~(list "ert-runner" "--verbose" "--debug" "-l" "ob-async.el")))
    (native-inputs
     (list emacs-ert-runner))
    (propagated-inputs
     (list emacs-async emacs-dash))
    (home-page "https://github.com/astahlman/ob-async")
    (synopsis "Asynchronous src_block execution for org-babel")
    (description "@code{ob-async} enables asynchronous execution of org-babel
src blocks.")
    (license license:gpl3+)))

(define-public emacs-ol-notmuch
  (package
    (name "emacs-ol-notmuch")
    (version "2.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tarsius/ol-notmuch")
             (commit (string-append "v" version))))
       (sha256
        (base32
         "0cdi73vfikhm8gcj1y05b07fvzvninz811yppb3kyhdis8kzc7qk"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command
           #~(list "make" "check-declare")))
    (propagated-inputs
     (list emacs-compat emacs-notmuch emacs-org))
    (home-page "https://github.com/tarsius/ol-notmuch")
    (synopsis "Links to notmuch messages for Emacs' Org mode")
    (description
     "This package implements links to Notmuch messages and searches for
Emacs' Org mode.  A search is a query to be performed by Notmuch; it is the
equivalent to folders in other mail clients.  Similarly, mails are referred to
by a query, so both a link can refer to several mails.")
    (license license:gpl3+)))

(define-public emacs-debbugs
  (package
    (name "emacs-debbugs")
    (version "0.46")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/debbugs-"
                           version ".tar"))
       (sha256
        (base32 "100yshwnbk70yxah1hy0cqhva8qqh5i2pbqxi5a5j6cja2awdi38"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(list "\\.el$" "\\.wsdl$" "\\.info$")
      #:phases #~(modify-phases %standard-phases
                   (add-before 'check 'add-test-dir-to-emacs-load-path
                     (lambda _
                       (setenv "EMACSLOADPATH"
                               (string-append (getcwd) "/test:"
                                              (getenv "EMACSLOADPATH"))))))))
    (propagated-inputs (list emacs-soap-client))
    (home-page "https://elpa.gnu.org/packages/debbugs.html")
    (synopsis "Access the Debbugs bug tracker in Emacs")
    (description
     "This package lets you access the @uref{http://bugs.gnu.org,GNU Bug
Tracker} from within Emacs.

For instance, it defines the command @code{M-x debbugs-gnu} for listing bugs,
and the command @code{M-x debbugs-gnu-search} for bug searching.  If you
prefer the listing of bugs as TODO items of @code{org-mode}, you could use
@code{M-x debbugs-org} and related commands.

A minor mode @code{debbugs-browse-mode} let you browse URLs to the GNU Bug
Tracker as well as bug identifiers prepared for @code{bug-reference-mode}.")
    (license license:gpl3+)))

(define-public emacs-piem
  (package
    (name "emacs-piem")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.kyleam.com/piem")
             (commit (string-append "v" version))))
       (file-name (string-append name "-" version "-checkout"))
       (sha256
        (base32 "0smdb1iph2q1xvxix5c93llckcxh7kmhg6pxgyrm88j736m4l16q"))))
    (build-system emacs-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'configure
                 (lambda* (#:key inputs #:allow-other-keys)
                   (emacs-substitute-variables "piem-b4.el"
                     ("piem-b4-b4-executable"
                      (search-input-file inputs "/bin/b4")))))
               (add-after 'install 'makeinfo
                 (lambda _
                   (invoke "makeinfo" "Documentation/piem.texi")
                   (install-file "piem.info"
                                 (string-append #$output "/share/info")))))))
    (native-inputs (list texinfo))
    (inputs
     (list b4
           emacs-debbugs
           emacs-elfeed
           emacs-notmuch))
    (home-page "https://docs.kyleam.com/piem/")
    (synopsis "Glue for working with public-inbox archives")
    (description "This package provides a collection of Emacs libraries for
working with public-inbox archives.  As much of the hard work here is already
done by other Emacs libraries—things like mail clients, news readers, Git
interfaces, and even web browsers—piem is mostly about bridging some of these
parts for convenience.")
    (license license:gpl3+)))

(define-public emacs-deferred
  (package
    (name "emacs-deferred")
    (version "0.5.1")
    (home-page "https://github.com/kiwanami/emacs-deferred")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xy9zb6wwkgwhcxdnslqk52bq3z24chgk6prqi4ks0qcf2bwyh5h"))
       (patches
        (search-patches "emacs-deferred-fix-number-of-arguments.patch"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-shell
           ;; Setting the SHELL environment variable is required for the tests
           ;; to find sh.
           (lambda _
             (setenv "SHELL" (which "sh"))))
         (add-before 'check 'fix-makefile
           (lambda _
             (substitute* "Makefile"
               (("\\$\\(CASK\\) exec ") "")))))
       #:test-command '("make" "test")))
    (native-inputs
     (list emacs-ert-expectations emacs-ert-runner emacs-undercover))
    (synopsis "Simple asynchronous functions for Emacs Lisp")
    (description
     "The @code{deferred.el} library provides support for asynchronous tasks.
The API is almost the same as that of
@uref{https://github.com/cho45/jsdeferred, JSDeferred}, a JavaScript library
for asynchronous tasks.")
    (license license:gpl3+)))

(define-public emacs-butler
  (package
    (name "emacs-butler")
    (version "0.2.6")
    (home-page "https://github.com/AshtonKem/Butler")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1wsk5isza8xqr84w6haal95ssifz6j2lrr5phbsdc90jb9hicbff"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-deferred))
    (synopsis "Emacs client for Jenkins")
    (description
     "Butler provides an interface to connect to Jenkins continuous
integration servers.  Users can specify a list of server in the
@code{butler-server-list} variable and then use @code{M-x butler-status} to
view the build status of those servers' build jobs, and possibly to trigger
build jobs.")
    (license license:gpl3+)))

(define-public emacs-zmq
  (package
    (name "emacs-zmq")
    (version "1.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nnicandro/emacs-zmq")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1my9gw15xdbw7wdv6xa29lw8vfxqjsypk2465zxic2825hs0wn07"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f                       ; no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'configure
            (lambda _
              (invoke "make" "src/configure")
              (substitute* "src/configure"
                (("/bin/sh") (which "sh"))
                (("/usr/bin/file") (which "file")))
              (substitute* "zmq.el"
                ;; This typo is already fixed in master--but no release was
                ;; made.
                (("zmq-mesage-more-p") "zmq-message-more-p"))
              (invoke "make")))
          (add-after 'install 'install-shared-object
            (lambda _
              (install-file "emacs-zmq.so" (elpa-directory #$output)))))))
    (native-inputs
     (list autoconf automake libtool pkg-config))
    (inputs
     (list zeromq))
    (home-page "https://github.com/nnicandro/emacs-zmq")
    (synopsis "Emacs bindings to ØMQ")
    (description "This package provides Emacs bindings to ØMQ.")
    (license (list license:gpl2+        ;zmq.el
                   license:gpl3+)))) ;src/emacs-module.h

(define-public emacs-tup-mode
  (package
    (name "emacs-tup-mode")
    (version "1.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ejmr/tup-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0asd024n5v23wdsg1959sszq568wg3a1bp4jrk0cllfji1z0n78y"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ejmr/tup-mode")
    (synopsis "Major mode for editing ``tupfiles'' used by the Tup build system")
    (description
     "Tup mode provides syntax highlighting for all of the elements of
tupfiles, such as rule definitions, user-defined variables, macros, flags, bin
variables, and so on.  The mode also allows you to execute Tup commands.")
    (license license:gpl3+)))

(define-public emacs-turtles
  (package
    (name "emacs-turtles")
    (version "2.0.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/szermatt/turtles")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1cipfgzx8ws79lzx7dfqr9lbirxf5fl332y8m5wz46455421avgi"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/szermatt/turtles")
    (synopsis "Library for writing ERT-based tests")
    (description
     "This package helps writing ERT-based tests that check how Emacs renders
buffers and windows. The ERT tests can be run interactively or in batch
mode.")
    (license license:gpl3+)))

(define-public emacs-combobulate
  (let ((commit "17c71802eed2df1a6b25199784806da6763fb90c")
        (revision "2"))
    (package
      (name "emacs-combobulate")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mickeynp/combobulate")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "14fv5nvll0v1i5zwn7xlf6n7g0yxl7vgkkxwj16dk4f7nxc3mvcv"))))
      (build-system emacs-build-system)
      (arguments (list #:test-command #~(list "ert-runner" "tests")))
      (propagated-inputs
       (list tree-sitter-javascript
             tree-sitter-python
             tree-sitter-typescript))
      (native-inputs
       (list emacs-ert-runner python-minimal))
      (home-page "https://www.masteringemacs.org/article/combobulate-structured-movement-editing-treesitter")
      (synopsis "Structured editing and navigation in Emacs with tree-sitter")
      (description
       "Combobulate is a package that adds structured editing and movement to
a wide range of programming languages.  Unlike most programming major modes
that use error-prone imperative code and regular expressions to determine
what's what in your code, Combobulate uses Emacs 29's tree-sitter library.
Tree-sitter maintains a concrete syntax tree of your code; it gives
Combobulate absolute clarity of all aspects of your code, enabling more
correct movement and editing than you would otherwise have.")
      (license license:gpl3+))))

(define-public emacs-companion-mode
  ;; No tags or releases.
  (let ((commit "2c3c794c583058db83e92e69b8cb1bf0c84551eb")
        (revision "0"))
    (package
      (name "emacs-companion-mode")
      ;; Version is extracted from the main file.
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
            (url "https://codeberg.org/rahguzar/companion-mode/")
            (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0bi3y3r0y1n7kl6nrr0mpdp0zyr1mgcg8mrm5yxldfvdh2245jgq"))))
      (build-system emacs-build-system)
      (home-page "https://codeberg.org/rahguzar/companion-mode/")
      (synopsis "Pairing buffers for simulatenous display")
      (description
       "This package defines a global minor mode to pair buffers with a
companion, such that when the buffer is displayed in a window, the companion is
also displayed.")
      (license license:gpl3+))))

(define-public emacs-company
  (package
    (name "emacs-company")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "company-" version ".tar"))
       (sha256
        (base32 "00vmqra0fav0w4q13ngwpyqpxqah0ahfg7kp5l2nd0h2l8sp79qr"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons* "icons/" %default-include)
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'move-doc 'install-doc-images
            (lambda* (#:key outputs #:allow-other-keys)
              (let ((images (find-files "./images/small/" ".*\\.png$")))
                (for-each
                 (lambda (image)
                   (install-file
                    image
                    (string-append #$output "/share/info/images/small")))
                 images)))))))
    (home-page "https://company-mode.github.io/")
    (synopsis "Modular text completion framework")
    (description
     "Company is a modular completion mechanism.  Modules for retrieving
completion candidates are called back-ends, modules for displaying them are
front-ends.  Company comes with many back-ends, e.g., @code{company-elisp}.
These are distributed in separate files and can be used individually.")
    (license license:gpl3+)))

(define* (%emacs-company-box-upstream-source #:key commit version hash)
  (origin
    (method git-fetch)
    (uri (git-reference
          (url "https://github.com/sebastiencs/company-box")
          (commit commit)))
    (file-name (git-file-name "emacs-company-box" version))
    (hash hash)))

(define-public emacs-company-box
  ;; There is no release yet.  Version is extracted from the main
  ;; file.
  (let ((version "0.0.1")
        (revision "0")
        (commit "be37a9a30dc112ab172af21af694e2cb04a74f85"))
    (package
      (name "emacs-company-box")
      (version (git-version version revision commit))
      (source
       (origin
         (method (@@ (guix packages) computed-origin-method))
         (file-name (string-append name "-" version ".tar.gz"))
         (sha256 #f)
         (uri
          (delay
            (with-imported-modules '((guix build emacs-utils)
                                     (guix build utils))
              #~(begin
                  (use-modules (guix build utils)
                               (guix build emacs-utils))
                  (let* ((dir (string-append "emacs-company-box-" #$version)))

                    (set-path-environment-variable
                     "PATH" '("bin")
                     (list #+emacs-minimal
                           #+(canonical-package bash)
                           #+(canonical-package coreutils)
                           #+(canonical-package gzip)
                           #+(canonical-package tar)))

                    ;; Copy the upstream source
                    (copy-recursively
                     #+(%emacs-lsp-treemacs-upstream-source
                        #:commit commit #:version version
                        #:hash
                        (content-hash
                         "13fgmdy51gqdwijqfvb784pirx4lgva0y7ysi0c3fcx8f82cdj59"))
                     dir)

                    (with-directory-excursion dir
                      ;; The icons are unclearly licensed and possibly non-free,
                      ;; see <https://github.com/emacs-lsp/lsp-treemacs/issues/123>
                      (with-directory-excursion "images"
                        (for-each delete-file-recursively
                                  '("eclipse" "idea" "netbeans")))

                      ;; Also remove any mentions in the source code.
                      (make-file-writable "company-box-icons.el")
                      (emacs-batch-edit-file "company-box-icons.el"
                        '(progn
                          (while (search-forward-regexp
                                  "(defvar company-box-icons-\\([a-z-]*\\)"
                                  nil t)
                            (pcase (match-string 1)
                                   ((or "images"
                                        "all-the-icons"
                                        "icons-in-terminal") nil)
                                   (_ (beginning-of-line)
                                      (kill-sexp)))
                            (basic-save-buffer))))

                      ;; Also patch source to not show broken icons as configuration
                      ;; option.
                      (substitute* "company-box-icons.el"
                        (("- .*, from.*editor.*") "")
                        (("\\(const :tag \"([a-z]*)\".*\\)" all tag)
                         (if (member tag
                                     '("images" "all-the-icons" "icons-in-terminal"))
                             all
                             ""))))

                    (invoke "tar" "cvfa" #$output
                            "--mtime=@0"
                            "--owner=root:0"
                            "--group=root:0"
                            "--sort=name"
                            "--hard-dereference"
                            dir))))))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-company emacs-dash emacs-frame-local))
      (home-page "https://github.com/sebastiencs/company-box")
      (synopsis "Company front-end with icons")
      (description
       "Company box is a Company front-end.  It supports different
colors for different backends, associates icons to functions,
variables... and their backends, and displays candidate's
documentation.  It is not limited by the current window size or
buffer's text properties.

This package is not compatible with a TTY.")
      (license license:gpl3+))))

(define-public emacs-company-posframe
  (package
    (name "emacs-company-posframe")
    (version "0.7.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/tumashu/company-posframe")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "03kj8yxd4y9aw86b6y6z5l9y76q5gjyiyhi5120nx1a8cwbd9g4a"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-company emacs-posframe))
    (home-page "https://github.com/tumashu/company-posframe")
    (synopsis "Use a posframe for @code{emacs-company}'s candidate menu")
    (description
     "Allows @code{emacs-company} to use child frames for its candidate menus.

@code{emacs-company-posframe} is fast enough for daily use and supports CJK
languages.")
    (license license:gpl3+)))

(define-public emacs-irony-mode
  (package
    (name "emacs-irony-mode")
    (version "1.6.1")
    (home-page "https://github.com/Sarcasm/irony-mode")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url (string-append home-page ".git"))
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1w0rd74kjgda7mjbf853yavppkgzdfyw1a2hgskbqbbjii3mr1zy"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'configure
            (lambda _
              (chmod "irony.el" #o644)
              (emacs-substitute-variables "irony.el"
                ("irony-server-install-prefix" #$emacs-irony-mode-server)))))))
    (inputs (list emacs-irony-mode-server))
    (synopsis "C/C++/ObjC Code completion and syntax checks for Emacs")
    (description "Irony-mode provides Clang-assisted syntax checking and
completion for C, C++, and ObjC in GNU Emacs.  Using @code{libclang} it can
provide syntax checking and autocompletion on compiler level which is very
resistant against false positives.  It also integrates well with other
packages like @code{eldoc-mode} and especially @code{company-mode} as
described on the homepage.")
    (license license:gpl3+)))

(define-public emacs-irony-mode-server
  (package
    (inherit emacs-irony-mode)
    (name "emacs-irony-mode-server")
    (arguments
     (list
      #:tests? #f
      #:phases
      #~(modify-phases %standard-phases
          (replace 'configure
            (lambda _
              (invoke "cmake" "server"
                      (string-append "-DCMAKE_INSTALL_PREFIX=" #$output)))))))
    (inputs
     (list clang))
    (build-system cmake-build-system)
    (synopsis "Server for the Emacs @dfn{irony mode}")))

(define-public emacs-company-irony
  (package
    (name "emacs-company-irony")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Sarcasm/company-irony")
             (commit (string-append "v" version))))
       (sha256
        (base32 "1d3jw0d4zymznri86a5iixyxnw16jzkkrbhrh657ys73189c1c73"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (inputs
     (list emacs-company emacs-irony-mode))
    (synopsis "C++ completion backend for Company using Irony mode")
    (description "This backend for Company allows for C++ code completion
with Irony mode using Clang tooling.")
    (home-page "https://github.com/Sarcasm/company-irony")
    (license license:gpl3+)))

(define-public emacs-flycheck-irony
  (package
    (name "emacs-flycheck-irony")
    (version "0.1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/Sarcasm/flycheck-irony")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32 "0qa5a8wzvzxwqql92ibc9s43k8sj3vwn7skz9hfr8av0skkhx996"))))
    (build-system emacs-build-system)
    (inputs
     (list emacs-irony-mode emacs-flycheck emacs-company))
    (synopsis "Live syntax checking frontend for Flycheck using irony-mode")
    (description "This package provides a frontend for Flycheck that lets
irony-mode do the syntax checking.")
    (home-page "https://github.com/Sarcasm/flycheck-irony")
    (license license:gpl3+)))

(define-public emacs-irony-eldoc
  (package
    (name "emacs-irony-eldoc")
    (version (package-version emacs-irony-mode))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ikirill/irony-eldoc")
             (commit "0df5831eaae264a25422b061eb2792aadde8b3f2")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1l5qpr66v1l12fb50yh73grb2rr85xxmbj19mm33b5rdrq2bqmmd"))))
    (build-system emacs-build-system)
    (inputs
     (list emacs-irony-mode))
    (synopsis "Eldoc integration for irony-mode")
    (description "Irony-eldoc is an eldoc extension that shows documentation
for the current function or variable in the minibuffer.")
    (home-page "https://github.com/ikirill/irony-eldoc")
    (license license:gpl3+)))

(define-public emacs-company-quickhelp
  (package
    (name "emacs-company-quickhelp")
    (version "2.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/expez/company-quickhelp")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08ccsfvwdpzpj0gai3xrdb2bv1nl6myjkxsc5774pbvlq9nkfdvr"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-pos-tip emacs-company))
    (home-page "https://github.com/expez/company-quickhelp")
    (synopsis "Popup documentation for completion candidates")
    (description "@code{company-quickhelp} shows documentation for the
completion candidate when using the Company text completion framework.")
    (license license:gpl3+)))

(define-public emacs-math-symbol-lists
  (package
    (name "emacs-math-symbol-lists")
    (version "1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/vspinu/math-symbol-lists")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1r2i600356k8g0l53s4b5xc24flpka664i8f23zbj4h7gk1g2787"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/vspinu/math-symbol-lists")
    (synopsis "Lists of Unicode math symbols and @code{LaTeX} commands")
    (description "This is a storage package used by completion engines like
@code{company-math}.")
    (license license:gpl3+)))

(define-public emacs-math-preview
  (package
    (name "emacs-math-preview")
    (version "5.1.1")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://gitlab.com/matsievskiysv/math-preview")
         (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0ni08900p0pbajw143iw0b7a62qiqcm9b6jy7pqgpn437vydjx1z"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-dash emacs-s))
    (home-page "https://gitlab.com/matsievskiysv/math-preview")
    (synopsis "Preview TeX math equations inline using MathJax")
    (description
     "Emacs math-preview uses MathJax for displaying TeX, MathML and AsciiMath
  math inline in Emacs buffers.")
    (license license:gpl3+)))

(define-public emacs-company-coq
  (package
    (name "emacs-company-coq")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/cpitclaudel/company-coq")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0dxi4h8xqq5647k7h89s4pi8nwyj3brlhsckrv3p3b1g4dr6mk3b"))))
    (inputs
     (list emacs-company emacs-company-math emacs-dash emacs-yasnippet))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (home-page "https://github.com/cpitclaudel/company-coq")
    (synopsis "Emacs extensions for Proof General's Coq mode")
    (description "This package includes a collection of Company mode backends
for Proof-General's Coq mode, and many useful extensions to Proof-General.  It
features:

@itemize
@item Prettification of operators, types, and subscripts,
@item Auto-completion,
@item Insertion of cases,
@item Fully explicit intros,
@item Outlines, code folding, and jumping to definition,
@item Help with errors,
@item and more.
@end itemize")
    (license license:gpl3+)))

(define-public emacs-company-math
  (package
    (name "emacs-company-math")
    (version "1.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/vspinu/company-math")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1pj10i7ml5d2spcmf8035ngcq5zc6rs3lqx09d0qj6bsghglr6j3"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-company emacs-math-symbol-lists))
    (home-page "https://github.com/vspinu/company-math")
    (synopsis "Completion backends for math symbols and @code{LaTeX} tags")
    (description
     "This package provides a backend for use with Company mode allowing for
completion of common math symbols.")
    (license license:gpl3+)))

(define-public emacs-compdef
  (let ((commit "67104a38763cc819644f711248b170a43bce151b")
        (revision "2"))
    (package
      (name "emacs-compdef")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/jjzmajic/compdef.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1f6y6cr67gps9jp5hd20xszfd3k26v70g6z4g5db6wdkvlnc2wkg"))))
      (build-system emacs-build-system)
      (home-page "https://gitlab.com/jjzmajic/compdef")
      (synopsis "Set local completion backends")
      (description "This package provides a function to cleanly set local
completion backends according to mode, and integrates with
@code{use-package}.")
      (license license:gpl3+))))

(define-public emacs-icomplete-vertical
  (package
    (name "emacs-icomplete-vertical")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/oantolin/icomplete-vertical")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "02v190pb802vck7di39jyf5prvmfsgcxln8mgwsls2b4clx9da97"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/oantolin/icomplete-vertical")
    (synopsis "Display Icomplete candidates vertically")
    (description
     "This package defines a global minor mode to display Icomplete
completion candidates vertically.")
    (license license:gpl3+)))

(define-public emacs-handle
  (let ((commit "51c050bc1c6e5caf0eb47ecd985daea1db7241ab")
        (revision "2"))
    (package
      (name "emacs-handle")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/jjzmajic/handle.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "14f15qzfmwdslml4rv37zb5d1lsjf0jibriz636hb7q7knx1n4sg"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-parent-mode))
      (home-page "https://gitlab.com/jjzmajic/handle")
      (synopsis "Handle generic functions across related major modes")
      (description "This package provides generic functions that specialize on
major modes and intended purpose rather than on arguments.  Different
callables for tasks like expression evaluation, definition-jumping, and more
can now be grouped accordingly and tried in sequence until one of them
succeeds.")
      (license license:gpl3+))))

(define-public emacs-nswbuff
  (package
    (name "emacs-nswbuff")
    (version "1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joostkremers/nswbuff")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0bkx7mwy3zbb0ixawvn4cysxk3jjc7ahssvdprvw19ls9xx3wbsp"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/joostkremers/nswbuff")
    (synopsis "Quickly switch between buffers")
    (description "This package allows for navigating between buffers within
a customizable list.")
    (license license:gpl3+)))

(define-public emacs-phi-search
  (let ((commit "9a089b8271cb1cff9640848850298c9ec855286c")
        (revision "1"))
    (package
      (name "emacs-phi-search")
      (version (git-version "20160630" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/zk-phi/phi-search")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1gr5plcbrfdc4pglfj905s89hf8x0kc083h30wcnd81bnw9jwz1x"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/zk-phi/phi-search")
      (synopsis "Interactive search compatible with @code{multiple-cursors}")
      (description "This package can be used with @code{multiple-cursors} to
provide an incremental search that moves all fake cursors in sync.")
      (license license:gpl2+))))

(define-public emacs-phi-search-mc
  (let ((commit "7aa671910f766437089aec26c3aa7814222d1356")
        (revision "1"))
    (package
      (name "emacs-phi-search-mc")
      (version (git-version "2.2.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/knu/phi-search-mc.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0wr86ad0yl52im6b9z0b9pzmhcn39qg5m9878yfv1nbxliw40lcd"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-phi-search emacs-multiple-cursors))
      (home-page "https://github.com/knu/phi-search-mc.el")
      (synopsis "Extend @code{phi-search} with additional
@code{multiple-cursors} functionality")
      (description "This package provides further integration between
@code{multiple-cursors} and @code{phi-search}, a package that allows for
interactive searches to move multiple fake cursors.")
      (license license:bsd-2))))

(define-public emacs-multiple-cursors
  (package
    (name "emacs-multiple-cursors")
    (version "1.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magnars/multiple-cursors.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "01ccwbfrnc66ax4bngw1b6k9rzw0m85cm4s0wzk1gkdsc2z647jn"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/magnars/multiple-cursors.el")
    (synopsis "Multiple cursors for Emacs")
    (description
     "This package adds support to Emacs for editing text with multiple
simultaneous cursors.")
    (license license:gpl3+)))

(define-public emacs-multifiles
  ;; There is no tag and no "Version:" keyword.  Using the latest release
  ;; instead.
  (let ((commit "dddfe64b8e1c1cd1f9ccc1f03405477fc0d53897")
        (revision "1"))
    (package
      (name "emacs-multifiles")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/magnars/multifiles.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "065l04ylplng1vgykkbn2vnkcs3sn1k2cikx1ha2q8wmgx6bkvai"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))      ; no tests
      (propagated-inputs
       (list emacs-dash))
      (home-page "https://github.com/magnars/multifiles.el")
      (synopsis "Edit multiple files in a single Emacs buffer")
      (description
       "This package allows one to view and edit parts of multiple files in
one Emacs buffer.")
      (license license:gpl3+))))

(define-public emacs-mc-extras
  (package
    (name "emacs-mc-extras")
    (version "1.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/knu/mc-extras.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1xrlp192wi51qpzgpkn9ph5zlpj08ifd8r3444llskyv0bay6g14"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-multiple-cursors))
    (home-page "https://github.com/knu/mc-extras.el")
    (synopsis "Extra functions for manipulating multiple cursors")
    (description
     "This package provides additional functions for
@code{multiple-cursors}, including functions for marking s-expressions,
comparing characters, removing cursors, and more.")
    (license license:bsd-2)))

(define-public emacs-substitute
  (package
    (name "emacs-substitute")
    (version "0.4.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/protesilaos/substitute")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0z3qq30258ynlra4532m43dxpsdbh6ywacf9xxp63zj3q5pm6q59"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/protesilaos/substitute")
    (synopsis "Efficiently replace targets in the buffer or context")
    (description
     "Substitute is a set of commands that perform text replacement (i)
throughout the buffer, (ii) limited to the current definition (per
narrow-to-defun), (iii) from point to the end of the buffer, and (iv) from
point to the beginning of the buffer.

These substitutions are meant to be as quick as possible and, as such, differ
from the standard @code{query-replace} tool.  The provided commands prompt for
substitute text and perform the substitution outright.")
    (license license:gpl3+)))

(define-public emacs-sudoku
  (package
    (name "emacs-sudoku")
    (version "20191015.1315")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/zevlg/sudoku.el.git")
             (commit "b1924fd244a5fa284de9d67b66fbd69164b37318")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "19i3rrz4qnc9i845j0bbmps69372rry7gadcyj06gvq2hf9dy3nh"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/zevlg/sudoku.el")
    (synopsis "Simple sudoku game in Emacs")
    (description "This package provides a simple sudoku game in Emacs.")
    (license license:gpl3+)))

(define-public emacs-typo
  ;; Latest tagged release is from 2013.
  (let ((commit "173ebe4fc7ac38f344b16e6eaf41f79e38f20d57")
        (revision "0"))
    (package
      (name "emacs-typo")
      (version (git-version "1.1" revision commit))
      (home-page "https://github.com/jorgenschaefer/typoel")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                       (url home-page)
                       (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "09835zlfzxby5lpz9njl705nqc2n2h2f7a4vpcyx89f5rb9qhy68"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ;no tests
      (synopsis "Minor mode for typographic editing")
      (description
       "This package provides two Emacs modes, @code{typo-mode} and
@code{typo-global-mode}.  These modes automatically insert Unicode characters
for quotation marks, dashes, and ellipses.  For example, typing @kbd{\"}
automatically inserts a Unicode opening or closing quotation mark, depending
on context.")
      (license license:gpl3+))))

(define-public emacs-company-lsp
  (package
    (name "emacs-company-lsp")
    (version "2.1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/tigersoldier/company-lsp")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1hy1x2w0yp5brm7714d1hziz3rpkywb5jp3yj78ibmi9ifny9vri"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-lsp-mode emacs-company emacs-s emacs-dash))
    (native-inputs
     (list emacs-buttercup))
    (arguments
     `(#:test-command '("buttercup" "-L" ".")))
    (home-page "https://github.com/tigersoldier/company-lsp")
    (synopsis "Completion for @code{lsp-mode}")
    (description
     "This package provides completion features that are not possible with
@code{lsp-mode} and @code{company-capf} alone, including support for trigger
characters and asynchronous fetching of completion candidates.")
    (license license:gpl3+)))

(define-public emacs-scala-mode
  (package
    (name "emacs-scala-mode")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hvesalai/emacs-scala-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1072lsin7dxadc0xyhy42wd0cw549axbbd4dy95wfmfcc1xbzjwv"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "ert-runner")))
    (native-inputs (list emacs-ert-runner))
    (home-page "https://github.com/hvesalai/emacs-scala-mode")
    (synopsis "Emacs major mode for Scala")
    (description
     "This package provides basic Emacs support for the Scala language,
including: local indenting of code, comments and multi-line strings, motion
commands and highlighting.")
    ;; There are no copyright headers in the source code.  The LICENSE file
    ;; indicates GPL3.
    (license license:gpl3)))

(define-public emacs-sbt-mode
  (package
    (name "emacs-sbt-mode")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hvesalai/emacs-sbt-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0lv9ridzk9x6rkf7lj21srnszypyq04vqg05vl10zhpz1yqlnbjd"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (home-page "https://github.com/hvesalai/emacs-sbt-mode")
    (synopsis "Basic functionality for interacting with sbt inside Emacs")
    (description
     "This mode provides basic functionality required for successfully
interacting with sbt inside Emacs.  The core functionality includes
interacting with the sbt shell and Scala console, compiling code and
navigation to errors.")
    (license license:gpl3+)))

(define-public emacs-9lc-mode
  (let ((commit "7871476488fc7b66e05714797a9a5b8275988662")
        (revision "1"))
    (package
      (name "emacs-9lc-mode")
      (version (git-version  "0.7" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/emacs-weirdware/9lc-mode.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1kmx0c413yvvaq33v7lf3gzdjpxkr5faa1wj2j0m25lyyz8dsdm7"))))
      (build-system emacs-build-system)
      (home-page "https://codeberg.org/emacs-weirdware/geoclue")
      (synopsis "Major mode for editing Fluke 9000 scripts")
      (description
       "This package provides a major mode for editing Fluke 9010a \"9LC\" files.")
      (license (list license:gpl3+)))))

(define-public emacs-tl1-mode
  (let ((commit "48d12893cc81d7f92dc7b603d3751d8512ed0eb0")
        (revision "1"))
    (package
      (name "emacs-tl1-mode")
      (version (git-version "1.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/emacs-weirdware/tl1-mode.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1mf0wqbn9h0353hkhcykzrm2dk1jvyijqs4hsvgj3kwp1whws7br"))))
      (build-system emacs-build-system)
      (home-page "https://codeberg.org/emacs-weirdware/geoclue")
      (synopsis "Major mode for editing Fluke 9100 TL/1 source code")
      (description
       "This package provides a major mode for editing Fluke TL/1 source code.
TL/1 is a language used to control Fluke’s 9100 series of testing and
troubleshooting mainframes.")
      (license (list license:gpl3+)))))

(define-public emacs-scheme-complete
  ;; Upstream does not provide tags.  The commit below corresponds to the
  ;; exact version update.  Version is extracted from main file.
  (let ((commit "5c0a16684a3be7021d67067b2955f1c3e17a320a"))
    (package
      (name "emacs-scheme-complete")
      (version "0.9.9")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ashinn/scheme-complete")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1smxr5bkzbfrjx21vhrj1wagmqx5yd92i997dbgs16iaqbzzr7cz"))))
      (build-system emacs-build-system)
      (arguments (list #:test-command #~(list "make" "test")))
      (home-page "https://github.com/ashinn/scheme-complete")
      (synopsis "Smart tab completion for Scheme in Emacs")
      (description
       "This file provides a single function, @code{scheme-smart-complete},
which you can use for intelligent, context-sensitive completion for any Scheme
implementation in Emacs.  To use it just load this file and bind that function
to a key in your preferred mode.")
      (license license:public-domain))))

(define-public emacs-scel
  (let ((version "20170629")
        (revision "1")
        (commit "aeea3ad4be9306d14c3a734a4ff54fee10ac135b"))
    (package
      (name "emacs-scel")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/supercollider/scel")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0jvmzs1lsjyndqshhii2y4mnr3wghai26i3p75453zrpxpg0zvvw"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #f ; No tests.
        #:modules '((guix build emacs-build-system)
                    ((guix build cmake-build-system) #:prefix cmake:)
                    (guix build utils))
        #:imported-modules `(,@%emacs-build-system-modules
                             (guix build cmake-build-system))
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'configure
              (lambda* (#:key outputs #:allow-other-keys)
                (substitute* "el/CMakeLists.txt"
                  (("share/emacs/site-lisp/SuperCollider")
                   (elpa-directory #$output)))
                ((assoc-ref cmake:%standard-phases 'configure)
                 #:outputs outputs
                 #:configure-flags '("-DSC_EL_BYTECOMPILE=OFF"))))
            (add-after 'expand-load-path 'add-el-dir-to-emacs-load-path
              (lambda _
                (setenv "EMACSLOADPATH"
                        (string-append (getcwd)
                                       "/el:"
                                       (getenv "EMACSLOADPATH")))))
            (replace 'install (assoc-ref cmake:%standard-phases 'install)))))
      (inputs
       (list supercollider))
      (native-inputs
       (list cmake-minimal))
      (home-page "https://github.com/supercollider/scel")
      (synopsis "SuperCollider Emacs interface")
      (description "@code{emacs-scel} is an Emacs interface to SuperCollider.
SuperCollider is a platform for audio synthesis and algorithmic composition.")
      (license license:gpl2+))))

(define-public emacs-soothe-theme
  ;; There is no named branch.
  (let ((commit "0786fe70c6c1b4ddcfb932fdc6862b9611cfc09b")
        (revision "0"))
    (package
     (name "emacs-soothe-theme")
     (version (git-version "20141027.2233" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsfodder/emacs-soothe-theme")
             (commit commit)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10gh1hvxq9gm29r6qzlnva7vjidd7n4kih4z2ihyvbvy9za20xqw"))))
     (build-system emacs-build-system)
     (home-page "https://github.com/emacsfodder/emacs-soothe-theme")
     (synopsis "Colorful, but muted theme for Emacs, dark background with light text")
     (description
      "Soothe theme is an amalgam of muted color tones and highlighted
backgrounds.  It has builtin support for Rainbow delimiters, Org mode,
Whitespace mode, ECB, Flyspell, Ido, Linum, highlight indentation, Show Paren
mode.")
     (license license:gpl3))))

(define-public emacs-company-auctex
  (let ((commit "48c42c58ce2f0e693301b0cb2d085055410c1b25")
        (revision "1"))
    (package
      (name "emacs-company-auctex")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alexeyr/company-auctex")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "10qn7frn5wcmrlci3v6iliqzj7r9dls87h9zp3xkgrgn4bqprfp8"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-before 'build 'set-home
             (lambda _ (setenv "HOME" "/tmp"))))))
      (propagated-inputs
       (list emacs-auctex emacs-company emacs-yasnippet))
      (home-page "https://github.com/alexeyr/company-auctex/")
      (synopsis "Completion for @code{AUCTeX}")
      (description
       "This package provides a group of backends permitting auto-completion
for @code{AUCTeX}.")
      (license license:gpl3+))))

(define-public emacs-mit-scheme-doc
  (package
    (name "emacs-mit-scheme-doc")
    (version "20140203")
    (source
     (origin
       (modules '((guix build utils)))
       (snippet
        ;; keep only file of interest
        '(begin
           (for-each delete-file '("dot-emacs.el" "Makefile"))
           (install-file "6.945-config/mit-scheme-doc.el" ".")
           (delete-file-recursively "6.945-config")))
       (file-name (string-append name "-" version ".tar.bz2"))
       (method url-fetch)
       (uri (string-append "http://groups.csail.mit.edu/mac/users/gjs/"
                           "6.945/dont-panic/emacs-basic-config.tar.bz2"))
       (sha256
        (base32
         "0dqidg2bd66pawqfarvwca93w5gqf9mikn1k2a2rmd9ymfjpziq1"))))
    (build-system emacs-build-system)
    (inputs (list mit-scheme))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure-doc
           (lambda* (#:key inputs #:allow-other-keys)
             (let* ((mit-scheme-dir (assoc-ref inputs "mit-scheme"))
                    (doc-dir (string-append mit-scheme-dir "/share/doc/"
                                            "mit-scheme-"
                                            ,(package-version mit-scheme))))
               (substitute* "mit-scheme-doc.el"
                 (("http://www\\.gnu\\.org/software/mit-scheme/documentation/mit-scheme-ref/")
                  (string-append "file:" doc-dir "/mit-scheme-ref/")))))))))
    (home-page "https://groups.csail.mit.edu/mac/users/gjs/6.945/dont-panic/")
    (synopsis "MIT-Scheme documentation lookup for Emacs")
    (description
     "This package provides a set of Emacs functions to search definitions of
identifiers in the MIT-Scheme documentation.")
    (license license:gpl2+)))

(define-public emacs-constants
  (package
    (name "emacs-constants")
    (version "2.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/constants-" version
                           ".tar"))
       (sha256
        (base32 "0n1wa9hr0841733s6w30x1n5mmis8fpjfzl5mn7s9q12djpp20fy"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/cdominik/constants-for-Emacs")
    (synopsis "Enter definition of constants into an Emacs buffer")
    (description
     "This package provides functions for inserting the definition of natural
constants and units into an Emacs buffer.")
    (license license:gpl2+)))

(define-public emacs-tagedit
  (package
    (name "emacs-tagedit")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/magnars/tagedit")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0kq40g46s8kgiafrhdq99h79rz9h5fvgz59k7ralmf86bl4sdmdb"))))
    (build-system emacs-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'remove-spurious-require
                 (lambda _
                   (substitute* "tagedit.el"
                     (("\\(require 'assoc\\)") "")))))))
    (propagated-inputs
     (list emacs-dash emacs-s))
    (home-page "https://github.com/magnars/tagedit")
    (synopsis "Some Paredit-like features for HTML mode")
    (description
     "This package provides a collection of Paredit-like functions for editing
in HTML mode.")
    (license license:gpl3+)))

(define-public emacs-slime
  ;; Update together with sbcl-slime-swank.
  (package
    (name "emacs-slime")
    (version "2.31")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/slime/slime")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0nv99wq2vz053p0rn9953rhmyz4g40zdl01mz7z9xbklxzbsx6x7"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons* "\\.lisp$" "\\.asd$"
                         "contrib"
                         "lib/hyperspec.el"
                         %default-include)
      #:exclude #~(list "^slime-tests.el" "^contrib/test/"
                        "^contrib/Makefile$" "^contrib/README.md$")
      #:tests? #f                       ; tests appear to require networking
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'configure
            (lambda* _
              (emacs-substitute-variables "slime.el"
                ("inferior-lisp-program" "sbcl"))))
          (add-before 'install 'install-doc
            (lambda _
              (let ((info-dir (string-append #$output "/share/info"))
                    (doc-dir (string-append #$output "/share/doc/"
                                            #$name "-" #$version))
                    (doc-files '("doc/slime-refcard.pdf"
                                 "README.md" "NEWS" "PROBLEMS"
                                 "CONTRIBUTING.md")))
                (with-directory-excursion "doc"
                  (substitute* "Makefile"
                    (("infodir=/usr/local/info")
                     (string-append "infodir=" info-dir)))
                  (invoke "make" "html/index.html")
                  (invoke "make" "slime.info")
                  (install-file "slime.info" info-dir)
                  (copy-recursively "html" (string-append doc-dir "/html")))
                (for-each (lambda (f)
                            (install-file f doc-dir)
                            (delete-file f))
                          doc-files)
                (delete-file-recursively "doc")))))))
    (propagated-inputs
     (list emacs-macrostep))
    (native-inputs
     (list texinfo))
    (home-page "https://github.com/slime/slime")
    (synopsis "Superior Lisp Interaction Mode for Emacs")
    (description
     "SLIME extends Emacs with support for interactive programming in
Common Lisp.  The features are centered around @command{slime-mode},
an Emacs minor mode that complements the standard @command{lisp-mode}.
While lisp-mode supports editing Lisp source files, @command{slime-mode}
adds support for interacting with a running Common Lisp process
for compilation, debugging, documentation lookup, and so on.")
    (license (list license:gpl2+ license:public-domain))))

(define-public emacs-popup
  (package
    (name "emacs-popup")
    (version "0.5.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/auto-complete/popup-el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13ww7hld5pa32myj9krr6prmc99s7hnpsw8mw9krpxffykkblj2f"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "ert-runner" "tests")))
    (native-inputs (list emacs-ert-runner))
    (home-page "https://github.com/auto-complete/popup-el")
    (synopsis "Visual Popup User Interface for Emacs")
    (description
     "Popup.el is a visual popup user interface library for Emacs.
This provides a basic API and common UI widgets such as popup tooltips
and popup menus.")
    (license license:gpl3+)))

(define-public emacs-popup-kill-ring
  (let ((commit "a45c9cf79c4e1207fdbdd662e161154ef224ad61")
        (revision "0"))
    (package
      (name "emacs-popup-kill-ring")
      (version (git-version "0.2.8" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/waymondo/popup-kill-ring")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0bpnsc4agy6mcnc79d9a6gi79jiiqrhf3a55pw0p4z16m86vwyqr"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-pos-tip emacs-popup))
      (home-page "https://github.com/waymondo/popup-kill-ring")
      (synopsis "Interactively insert item from kill-ring")
      (description "This Emacs package manages your Emacs kill-ring in an
autocomplete style popup menu.")
      (license license:gpl3+))))

(define-public emacs-popper
  (package
    (name "emacs-popper")
    (version "0.4.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/karthink/popper")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1x1nnc0li8jd609lnmmax2hl69wmbq84c6b2mdg0wb7zf0k29lba"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/karthink/popper")
    (synopsis "Emacs minor-mode to summon and dismiss buffers easily")
    (description
     "Popper is a minor-mode to tame the flood of ephemeral
windows Emacs produces, while still keeping them within arm’s reach.")
    (license license:gpl3+)))

(define-public emacs-pydoc
  ;; https://github.com/statmobile/pydoc/issues/31
  (let ((commit "c8b667e17bfe3e63221f822c5c4d58c8fb4fea90")
        (revision "0"))
    (package
      (name "emacs-pydoc")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (uri (git-reference
               (url "https://github.com/statmobile/pydoc")
               (commit commit)))
         (method git-fetch)
         (sha256
          (base32 "082ar5w28dknaa63mf587vdzr78xlnvh8lbxqq3hk6qa2c72akam"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (arguments
        (list
         #:phases
         #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-python-executable
              (lambda* (#:key inputs #:allow-other-keys)
                (emacs-substitute-variables "pydoc.el"
                  ("pydoc-python-command"
                    (search-input-file inputs "bin/python")))))
            (add-after 'unpack 'patch-lsof-executable
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "pydoc.el"
                  (("\"lsof")
                   ;; Replace removed double quote in parsing of lsof executable.
                   (string-append "\"" (search-input-file inputs "bin/lsof")))))))))
      (inputs (list lsof python-wrapper))
      (propagated-inputs (list python-jedi))
      (home-page "https://github.com/statmobile/pydoc")
      (synopsis "Navigate Python documentation in Emacs")
      (description "This package provides an Emacs mode for navigating
Python documentation with @code{pydoc} in Emacs.")
      (license license:gpl3+))))

(define-public emacs-python-black
  (package
    (name "emacs-python-black")
    (version "1.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/wbolster/emacs-python-black")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1x6b67cs7kn8711fxr3fq8y9wcpf9g71asf9wiqfrk2mrfzli6a3"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-reformatter python-black-macchiato))
    (arguments `(#:tests? #f))
    (home-page "https://github.com/wbolster/emacs-python-black")
    (synopsis "Reformat Python code via @code{python-black}")
    (description
     "This package makes it easy to reformat Python code using
@code{python-black} and @code{python-black-macchiato} for entire and partial
buffers, respectively.")
    (license license:bsd-3)))

(define-public emacs-py-isort
  (package
    (name "emacs-py-isort")
    (version "2016.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/paetzke/py-isort.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08i55gv392wc12x8v3dca0dmz8a8p9ljsqhyajsb6qv1k120wqhx"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #f))     ;tests fail with "emacs: standard input is not a tty"
    (propagated-inputs
     (list python-isort))
    (home-page "https://github.com/paetzke/py-isort.el")
    (synopsis "Sort the imports in Python buffers")
    (description
     "This package provides commands and a minor mode to sort Python imports
using @code{python-isort}.")
    (license license:gpl3+)))

(define-public emacs-python-environment
  (package
    (name "emacs-python-environment")
    (version "0.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tkf/emacs-python-environment/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0q6bib9nr6xiq6npzbngyfcjk87yyvwzq1zirr3z1h5wadm34lsk"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command
           #~(list "emacs" "--batch" "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs
     (list emacs-deferred))
    (home-page "https://github.com/tkf/emacs-python-environment")
    (synopsis "Provides a @code{virtualenv} API in Emacs Lisp")
    (description
     "This package permits automated installation of tools written in Python.")
    (license license:gpl3+)))

(define-public emacs-pythonic
  (let ((commit "9eff417654c1fc3eca367c357b5b2cddb3fd8ce4")
        (revision "1"))
    (package
      (name "emacs-pythonic")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pythonic-emacs/pythonic")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "00rkab305iwbn61jspcbxhvbwryf91ly7jz1axa2fzdkfqaj6727"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ; missing tests
      (propagated-inputs (list emacs-f emacs-s emacs-tramp))
      (home-page "https://github.com/pythonic-emacs/pythonic")
      (synopsis "Utility functions for writing Pythonic in Emacs")
      (description
       "The Pythonic Emacs package provides function for convenient running
Python on different platforms on local and remote hosts including Docker
containers and Vagrant virtual machines.  To use Pythonic with Docker you need
to install Docker Tramp Emacs package.")
      (license license:gpl3+))))

(define-public emacs-anaconda-mode
  (let ((commit "f900bd7656a03aa24ef3295251f266736f7756eb")
        (revision "0"))
    (package
      (name "emacs-anaconda-mode")
      (version (git-version "0.1.16" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pythonic-emacs/anaconda-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1gricygbs9f210z7bnzdhcmqpwnpzs4mwbw8rvabfplcbiw7sg6r"))))
      (build-system emacs-build-system)
      (arguments
       (list #:include #~(cons "^anaconda-mode\\.py$" %default-include)
             #:tests? #f))              ; no tests
      (propagated-inputs (list emacs-dash
                               emacs-f
                               emacs-pythonic
                               emacs-s
                               emacs-tramp
                               emacs-xref))
      (home-page "https://github.com/pythonic-emacs/anaconda-mode")
      (synopsis
       "Python code navigation, documentation lookup and completion in Emacs")
      (description
       "This package provides Python code navigation, documentation lookup,
and code completion for Emacs.  It uses a lightweight Python backend to offer
features like jumping to definitions, finding references, and viewing
documentation, enhancing the Python development experience within Emacs.")
      (license license:gpl3+))))

(define-public emacs-jack
  (let ((commit "3b4ea97fcc107d0ffd201ea695129af52f390113")
        (revision "0"))
    (package
      (name "emacs-jack")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tonyaldon/jack")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1cizszj62ic41zc97glf2mdvm1kd95vdfg2dip3n2p2g0nlk2hjf"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "emacs"
                               "--batch"
                               "-l"
                               "jack-tests.el"
                               "-f"
                               "ert-run-tests-batch-and-exit")))
      (home-page "https://jack.tonyaldon.com")
      (synopsis "HTML generator library")
      (description
       "@code{jack} provides the function @code{jack-html} that takes a data
structure as input representing the HTML tree you want to generate and
generates it as a string.  Please see the homepage for usage examples.")
      (license license:gpl3+))))

(define-public emacs-jedi
  (package
    (name "emacs-jedi")
    (version "20250602.2107")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/tkf/emacs-jedi/")
                    (commit "0a92f57dcfd76f1daf6d382d1e2eb437784a71e0")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0d88nyr689b311abi4zbjifm0llnyd16h3riwkq11y0vjkp5i6vq"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "make" "test" "CASK=")
      #:imported-modules `(,@%emacs-build-system-modules
                           (guix build python-build-system))
      #:modules '((guix build emacs-build-system)
                  ((guix build python-build-system) #:prefix python:)
                  (guix build emacs-utils)
                  (guix build utils))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'avoid-server-installation-for-tests
            (lambda _
              (substitute* "Makefile"
                ;; Disable tox since it's only configured for python 3.8 and
                ;; python 3.9 by the project--that's ancient.
                (("tox")
                 "echo tox")
                (("env: .*$")
                 (string-append "env: " #$output "/bin/jediepcserver\n")))))
          (add-after 'unpack 'ensure-no-mtimes-pre-1980
            (assoc-ref python:%standard-phases
                       'ensure-no-mtimes-pre-1980))
          (add-before 'check 'setenv
            (lambda _
              (setenv "HOME" "/tmp")))
          (add-after 'ensure-no-mtimes-pre-1980 'relax-python-requirements
            (lambda _
              ;; Argparse should only be required for Python < 3.2
              ;; (see: https://github.com/tkf/emacs-jedi/issues/365).
              (substitute* "setup.py"
                ((".*argparse.*") ""))))
          (add-after 'relax-python-requirements 'python:add-install-to-pythonpath
            (assoc-ref python:%standard-phases 'add-install-to-pythonpath))
          (add-after 'python:add-install-to-pythonpath 'python:install
            ;; This is needed to get the Python-built 'jediepcserver' command.
            (lambda args
              (apply (assoc-ref python:%standard-phases 'install)
                     #:use-setuptools? #t ; make reproducible
                     args)))
          (add-after 'python:install 'python:wrap
            (assoc-ref python:%standard-phases 'wrap))
          (add-after 'python:wrap 'patch-jedi:server-command
            (lambda* (#:key outputs #:allow-other-keys)
              (emacs-substitute-variables "jedi-core.el"
                ("jedi:server-command"
                 `(list ,(search-input-file outputs "bin/jediepcserver")))))))))
    (native-inputs (list emacs-mocker python-wrapper))
    (inputs (list python-wrapper python-epc python-jedi)) ;wrapped
    (propagated-inputs
     (list emacs-auto-complete emacs-python-environment emacs-epc))
    (home-page "https://github.com/tkf/emacs-jedi")
    (synopsis "Provides Python completion in Emacs")
    (description
     "This package provides completion in Python buffers and also helps find
the locations of docstrings, arguments, and functions.")
    (license license:gpl3+)))

(define-public emacs-jira
  (package
    (name "emacs-jira")
    (version "2.14.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/unmonoqueteclea/jira.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "108zm86iq0ica9jqd5pcs4msa7gcy55k2svq5af0y1zghz8gbxy9"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f)) ; no tests
    (propagated-inputs (list emacs-magit
                             emacs-request
                             emacs-tablist
                             emacs-transient))
    (home-page "https://github.com/unmonoqueteclea/jira.el")
    (synopsis "Emacs Interface to Jira")
    (description "This package allows you to visualuze and manipulate Jira
issues from Emacs.")
    (license license:gpl3+)))

(define-public emacs-company-jedi
  (package
    (name "emacs-company-jedi")
    (version "0.04")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/syohex/emacs-company-jedi")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1ihqapp4dv92794rsgyq0rmhwika60cmradqd4bn9b72ss6plxs1"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f)) ; no "check" target
    (propagated-inputs
     (list emacs-jedi emacs-company))
    (home-page "https://github.com/syohex/emacs-company-jedi")
    (synopsis "Provides Python completion in @code{company-mode}")
    (description
     "This package provides a Company backend for Python.")
    (license license:gpl3+)))

(define-public emacs-elquery
  (package
    (name "emacs-elquery")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/AdamNiederer/elquery")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "035zjzmd7yfw0rsjpaklc2wwiqw6brkjadch9x8n8n2gjyxg05mn"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:emacs emacs-no-x
      #:phases #~(modify-phases %standard-phases
                   (add-after 'unpack 'fix-native-compilation
                     (lambda _
                       (substitute* "elquery.el"
                         (("\\(1- \\(/ length \\(match-data\\)\\) 2\\)")
                          "(1- (/ (length (match-data)) 2))"))))
                   (add-before 'check 'disable-failing-tests
                     (lambda _
                       (substitute* "test/elquery-test.el"
                         (("\\(ert-deftest elquery--write-test .*" all)
                          (string-append all "(skip-unless nil)\n"))))))))
    (native-inputs
     (list emacs-ert-runner emacs-undercover))
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://github.com/AdamNiederer/elquery/")
    (synopsis "Read and manipulate HTML in Emacs")
    (description
     "Elquery is a library that lets you parse, query, set, and format HTML using
Emacs Lisp.  It implements most of the @code{querySelector} API, and can get
and set HTML attributes.")
    (license license:gpl3+)))

(define-public emacs-cov
  ;; XXX: Upstream made no release nor any tag so far.
  (let ((commit "cd3e1995c596cc227124db9537792d8329ffb696")
        (revision "0"))
    (package
      (name "emacs-cov")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/AdamNiederer/cov")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1gyc0si60czhgrkm7kink1p1zj1h5j5nzif4ivm5bg78l28skmpm"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:emacs emacs-no-x              ;for libxml
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'disable-failing-tests
              (lambda _
                (substitute* "test/cov-test.el"
                  (("\\(ert-deftest cov--load-coverage-test-mtime-check .*" all)
                   (string-append all "(skip-unless nil)\n"))))))))
      (native-inputs
       (list emacs-ert-runner emacs-mocker emacs-undercover))
      (propagated-inputs
       (list emacs-elquery emacs-f emacs-s))
      (home-page "https://github.com/AdamNiederer/cov/")
      (synopsis "Emacs extension for displaying coverage data")
      (description
       "Cov shows code coverage data for your program in Emacs.  It supports
currently @code{gcov}, @code{lcov}, @code{coverage.py}, and @code{clover}
output, as well as the Coveralls format produced by Undercover.")
      (license license:gpl3+))))

(define-public emacs-puppet-mode
  (package
    (name "emacs-puppet-mode")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/voxpupuli/puppet-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0c5q8qmbligzjsn05di4wh6ggpd3944j4yqb78vzd441b8ssq70i"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "make" "test" "CASK=")))
    (native-inputs
     (list emacs-ert-runner))
    (home-page "https://github.com/voxpupuli/puppet-mode")
    (synopsis "Emacs major mode for the Puppet configuration language")
    (description
     "This package provides support for the Puppet configuration language,
including syntax highlighting, indentation of expressions and statements,
linting of manifests and integration with Puppet Debugger.")
    ;; Also incorporates work covered by the Apache License, Version 2.0
    (license license:gpl3+)))

(define-public emacs-purescript-mode
  ;; Retrieved on 2021-05-18.
  (let ((revision "0")
        (commit "0acd1af446424ba855153161fe07a20f67dc0a89"))
    (package
      (name "emacs-purescript-mode")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/purescript-emacs/purescript-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0rxdsmx8826az4blhnnvqrx7bjky9hwph6gkyrh33sck26xhh3g5"))))
      (build-system emacs-build-system)
      (arguments
       `(#:test-command (list "ert-runner" "tests"
                              "-l" "tests/haskell-sort-imports-tests.el"
                              "-l" "tests/haskell-str-tests.el")
         #:phases
         (modify-phases %standard-phases
           (add-before 'install 'make-info
             (lambda _
               (invoke "makeinfo" "--no-split"
                       "-o" "purescript-mode.info" "purescript-mode.texi"))))))
      (native-inputs
       (list emacs-ert-runner texinfo))
      (home-page "https://github.com/purescript-emacs/purescript-mode")
      (synopsis "Emacs major mode and related tools for Purescript")
      (description "This package provides an Emacs major mode for writing Purescript.")
      (license license:gpl3+))))

(define-public emacs-new-purescript-mode
  (let ((commit "9f7bb73e26340fcd2ea1946dbad165f0406eb3e1")
        (revision "0"))
    (package
      (name "emacs-new-purescript-mode")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/justinwoo/new-purescript-mode")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0b3499df0gfz8yrdxz9dpgwal21h50sciigwz25ri1hwv1c1i7k0"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/justinwoo/new-purescript-mode/")
      (synopsis "Simple PureScript mode for cheap syntax highlighting")
      (description "New PureScript mode is a simple PureScript Emacs mode that
just provides syntax highlighting.")
      (license license:expat))))

(define-public emacs-god-mode
  (package
    (name "emacs-god-mode")
    (version "2.19.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/god-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1b39lq1l7xa2i4l5ciry3pjaxgzs0xawadb5kbcfhqhd4xlgb04g"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command
           #~(list "emacs" "--no-init-file" "--batch"
                   "--eval=(require 'ecukes)" "--eval=(ecukes)")))
    (native-inputs (list emacs-ecukes))
    (home-page "https://github.com/emacsorphanage/god-mode")
    (synopsis "Minor mode for entering commands without modifier keys")
    (description
     "This package provides a global minor mode for entering Emacs commands
without modifier keys.  It's similar to Vim's separation of commands and
insertion mode.  When enabled all keys are implicitly prefixed with
@samp{C-} (among other helpful shortcuts).")
    (license license:gpl3+)))

(define-public emacs-jinja2-mode
  (package
    (name "emacs-jinja2-mode")
    (version "0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/paradoxxxzero/jinja2-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0l26wcy496k6xk7q5sf905xir0p73ziy6c44is77854lv3y0z381"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/paradoxxxzero/jinja2-mode")
    (synopsis "Major mode for jinja2")
    (description
     "Emacs major mode for jinja2 with: syntax highlighting,
sgml/html integration, and indentation (working with sgml).")
    (license license:gpl3+)))

(define-public emacs-jinx
  (package
    (name "emacs-jinx")
    (version "2.5")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/minad/jinx")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ql2gv9jrva5l16d9xm2fz77ganpri7p73br1k0sj9kvinkyqxyf"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f ; no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'expand-load-path 'build-jinx-mod
            (lambda* _
              (invoke
               "emacs" "--batch" "-L" "."
               "-l" "jinx.el"
               "-f" "jinx--load-module")))
          (add-after 'expand-load-path 'build-info
            (lambda _
              (invoke "emacs" "--batch"
                      "--eval=(require 'ox-texinfo)"
                      "--eval=(find-file \"README.org\")"
                      "--eval=(org-texinfo-export-to-info)")))
          (add-after 'build-jinx-mod 'patch-path-to-jinx-mod
            (lambda _
              (let ((file "jinx.el"))
                (emacs-substitute-sexps file
                  ("\"Compile and load dynamic module.\""
                   `(module-load
                     ,(string-append #$output
                                     "/lib/emacs/jinx-mod.so")))))))
          (add-after 'install 'install-jinx-mod
            (lambda _
              (install-file "jinx-mod.so"
                            (string-append #$output "/lib/emacs")))))))
    (inputs (list enchant))
    (propagated-inputs (list emacs-compat))
    (native-inputs (list pkg-config texinfo))
    (home-page "https://github.com/minad/jinx")
    (synopsis "Emacs spell checker based on Enchant library")
    (description "Jinx is a just-in-time spell-checker for Emacs
based on the Enchant library.  It lazily highlights misspelled words in the
text of the visible portion of the buffer by honouring window boundaries as
well as text folding, if any.")
    (license license:gpl3+)))

(define-public emacs-jit-spell
  (package
    (name "emacs-jit-spell")
    (version "0.5")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/jit-spell-"
                                  version ".tar"))
              (sha256
               (base32
                "0xdn4hm4d26vmqh75i2ghyissm2s2szgynwynpgmlvhr4q5nkswf"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/astoff/jit-spell")
    (synopsis "Just-in-time spell checking")
    (description
     "This package highlights all misspelled words in a window, just like a
word processor or web browser does.  This behavior is different from the
built-in Flyspell package, which only checks words as the cursor moves over
them.  Moreover, unlike Flyspell, Jit-spell communicates with the
spell-checking subprocess entirely asynchronously, which can lead to a
noticeable performance improvement.")
    (license license:gpl3+)))

(define-public emacs-company-cabal
  ;; The latest version is 0.3.0, but no release has been provided after 0.2.1.
  (let ((commit "62112a7259e24bd6c08885629a185afe512b7d3d")
        (revision "1"))
    (package
      (name "emacs-company-cabal")
      (version (git-version "0.3.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/iquiw/company-cabal/")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1gf45xwjzdm8i4q6c6khk4dbg1mmp2r0awz2sjr4dcr2dbd1n7mg"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-company))
      (arguments
       `(#:include (cons "^tools\\/" %default-include)))
      (home-page "https://github.com/iquiw/company-cabal/")
      (synopsis "Company completion for Haskell Cabal files")
      (description
       "This package allows for completion of field names, section names,
field values, and more within @code{haskell-cabal-mode}.")
      (license license:gpl3+))))

(define-public emacs-rfc-mode
  (package
    (name "emacs-rfc-mode")
    (version "1.4.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/galdor/rfc-mode")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0sym5pji4ba4jy79zfs7gb2n9kqa60ma4z622s0mz647g56z09f4"))))
    (build-system emacs-build-system)
    (arguments
     ;; No tests
     (list #:tests? #f))
    (home-page "https://github.com/galdor/rfc-mode")
    (synopsis "Emacs major mode to read and browse @acronym{RFC, Request for Comments} documents")
    (description "The @code{rfc-mode} Emacs major mode is a browser and reader
for @acronym{RFC, Request for Comments} documents.")
    (license license:isc)))

(define-public emacs-rfcview
  (package
    (name "emacs-rfcview")
    (version "0.13")
    (home-page "http://www.loveshack.ukfsn.org/emacs")
    (source (origin
              (method url-fetch)
              (uri "http://www.loveshack.ukfsn.org/emacs/rfcview.el")
              (sha256
               (base32
                "0ympj5rxig383zl2jf0pzdsa80nnq0dpvjiriq0ivfi98fj7kxbz"))))
    (build-system emacs-build-system)
    (synopsis "Prettify Request for Comments (RFC) documents")
    (description "The Internet Engineering Task Force (IETF) and the Internet
Society (ISOC) publish various Internet-related protocols and specifications
as \"Request for Comments\" (RFC) documents and Internet Standard (STD)
documents.  RFCs and STDs are published in a simple text form.  This package
provides an Emacs major mode, rfcview-mode, which makes it more pleasant to
read these documents in Emacs.  It prettifies the text and adds
hyperlinks/menus for easier navigation.  It also provides functions for
browsing the index of RFC documents and fetching them from remote servers or
local directories.")
    (license license:gpl3+)))

(define-public emacs-ffap-rfc-space
  (package
    (name "emacs-ffap-rfc-space")
    (version "12")
    (home-page "https://user42.tuxfamily.org/ffap-rfc-space/index.html")
    (source (origin
              (method url-fetch)
              (uri "http://download.tuxfamily.org/user42/ffap-rfc-space.el")
              (sha256
               (base32
                "1iv61dv57a73mdps7rn6zmgz7nqh14v0ninidyrasy45b1nv6gck"))))
    (build-system emacs-build-system)
    (synopsis "Make ffap recognize an RFC with a space before its number")
    (description "The Internet Engineering Task Force (IETF) and the
Internet Society (ISOC) publish various Internet-related protocols and
specifications as \"Request for Comments\" (RFC) documents.  The
built-in Emacs module \"ffap\" (Find File at Point) has the ability to
recognize names at point which look like \"RFC1234\" and \"RFC-1234\"
and load the appropriate RFC from a remote server.  However, it fails
to recognize a name like \"RFC 1234\".  This package enhances ffap so
that it correctly finds RFCs even when a space appears before the
number.")
    (license license:gpl3+)))

(define-public emacs-feature-mode
  (let ((version "20190801")
        (revision "1")
        (commit "11ae1671629bfedaa553c7b819676d64eb320992"))
    (package
      (name "emacs-feature-mode")
      (version (git-version version revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/michaelklishin/cucumber.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0yd4gkxz9xcbgibfgr8apsid3f83nmg5jgqk5nql0linj5gymc28"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include (cons* "^features\\/" "snippets\\/" "^support\\/"
                          %default-include)
         ;; XXX: tests require gherkin (>= 2.11.8, < 4.0.0)
         #:tests? #f))
      (home-page "https://github.com/michaelklishin/cucumber.el/")
      (synopsis "Emacs mode for editing Gherkin plain text user stories")
      (description "Major mode for editing Gherkin (popularized by the
Cucumber tool) user stories.  Also known by the name @code{cucumber.el}.")
      (license license:gpl2+))))

(define-public emacs-org-bullets
  (package
    (name "emacs-org-bullets")
    (version "0.2.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sabof/org-bullets")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10nr4sjffnqbllv6gmak6pviyynrb7pi5nvrq331h5alm3xcpq0w"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/sabof/org-bullets")
    (synopsis "Show bullets in org-mode as UTF-8 characters")
    (description
     "This package provides an Emacs minor mode causing bullets in
@code{org-mode} to be rendered as UTF-8 characters.")
    (license license:gpl3+)))

(define-public emacs-org-appear
  (package
    (name "emacs-org-appear")
    (version "0.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/awth13/org-appear")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1hfhnzhmbxrw4kz977s48x4nbq86vda5dvj00s2ima2i22b8l2z4"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/awth13/org-appear")
    (synopsis "Make invisible parts of Org fragments appear visible")
    (description "This package enables automatic visibility toggling of
org-mode elements depending on cursor position.  Hidden fragment parts appear
when the cursor enters a fragment and disappear when it leaves.")
    (license license:expat)))

(define-public emacs-org-dailies
  ;; No tags or versions.
  (let ((commit "f2dfc221d3566c6241f87c331667f96569651ada")
        (revision "2"))
    (package
      (name "emacs-org-dailies")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://git.sr.ht/~ngraves/org-dailies")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1nwa2dp1b03smyg8pvwqql1cwmcs4qdszw13ik02d51m238a6wy5"))))
      (build-system emacs-build-system)
      (home-page "https://git.sr.ht/~ngraves/org-dailies")
      (synopsis "Bare-bones daily journaling with Emacs")
      (description
       "This package provides daily journaling helpers.  It is a bare-bones
copy of the org-roam-dailies extension without org-roam.")
      (license license:gpl3+))))

(define-public emacs-org-drill
  (package
    (name "emacs-org-drill")
    (version "2.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/phillord/org-drill")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13y302lyscdqrba1sfx60yf5ji2xi7fbsvjsjbw7hiz63kg6rccy"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command
           #~(list "emacs" "--batch" "-l" "assess-discover"
                   "-L" "."
                   "--eval" "(assess-discover-run-and-exit-batch t)")))
    (propagated-inputs
     (list emacs-org emacs-persist))
    (native-inputs (list emacs-assess))
    (home-page "https://gitlab.com/phillord/org-drill")
    (synopsis "Flash card memorization system using Org mode")
    (description
     "This package uses spaced repetition algorithms to conduct interactive
drill sessions to aid in memorization.  In these sessions you are shown flash
cards created in Org mode.")
    (license license:gpl3+)))

(define-public emacs-anki-editor
  ;; Last release was in 2018.
  (let ((commit "546774a453ef4617b1bcb0d1626e415c67cc88df")
        (revision "0")
        (version "0.3.3"))
    (package
      (name "emacs-anki-editor")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/louietan/anki-editor")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1if610hq5j8rbjh1caw5bwbgnsn231awwxqbpwvrh966kdxzl4qf"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash emacs-request))
      (home-page "https://github.com/louietan/anki-editor")
      (synopsis "Minor mode for making Anki cards with Org mode")
      (description
       "This package is for people who use Anki as a spaced repetition system
(SRS) but would like to make cards in Org mode.")
      (license license:gpl3+))))

(define-public emacs-org-mime
  (package
    (name "emacs-org-mime")
    (version "0.3.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/org-mime/org-mime")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "12144hhiygvbx2ws01b47z4wqqd5jfbpxx4cn503mkqwcxzvpvgb"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command
                     #~(list "emacs" "--batch" "-l" "org-mime.el"
                             "-l" "htmlize" "-l" "test/org-mime-tests.el")
                     #:phases
                     #~(modify-phases %standard-phases
                         (add-before 'check 'set-home
                           (lambda _
                             (setenv "HOME" (getenv "TMPDIR")))))))
    (native-inputs (list emacs-htmlize))
    (home-page "https://github.com/org-mime/org-mime")
    (synopsis "Send HTML email using Org mode HTML export")
    (description
     "This program sends HTML email using Org-mode HTML export.
This approximates a WYSiWYG HTML mail editor from within Emacs, and can be
useful for sending tables, fontified source code, and inline images in
email.")
    (license license:gpl3+)))

(define-public emacs-org-msg
  ;; No git tags.  The commit below corresponds to the release of version 4.0.
  (let ((commit "60e22e446325a9b3387396459d98be7c1c52579d"))
    (package
      (name "emacs-org-msg")
      (version "4.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jeremy-compostella/org-msg")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "077g7gvn1k6i2x4m2kd3dkrznc89f5a5pd916wsmpy703pv0aca5"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-htmlize))
      (home-page "https://github.com/jeremy-compostella/org-msg")
      (synopsis "Mix Org mode and Message mode to compose emails")
      (description
       "OrgMsg is a GNU Emacs global minor mode mixing up Org mode and your
Mail User Agent Mode (Message, mu4e, or Notmuch) to compose and reply to
emails in a Outlook HTML friendly style.")
      (license license:gpl3+))))

(define-public emacs-org-superstar
  (package
    (name "emacs-org-superstar")
    (version "1.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/integral-dw/org-superstar-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1hz4m3axcnsvwmal0fsr2b3s6wa9gzxd5rkk4r74lmsz36x5yl0h"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-org))
    (home-page "https://github.com/integral-dw/org-superstar-mode")
    (synopsis "Prettify headings and plain lists in Org mode")
    (description "This package prettifies headings and plain lists in
Org mode.  It is a direct descendant of @code{org-bullets}, with most
of the code base completely rewritten.

Currently, this package prettifies Org heading lines by:
@itemize
@item replacing trailing bullets by UTF-8 bullets,
@item hiding leading stars, customizing their look or removing them from vision,
@item applying a custom face to the header bullet,
@item applying a custom face to the leading bullets,
@item using double-bullets for inline tasks,
@item (optional) using special bullets for TODO keywords.
@end itemize

It also prettifies Org plain list bullets by:
@itemize
@item replacing each bullet type (*, + and -) with UTF-8 bullets,
@item applying a custom face to item bullets.
@end itemize

Features degrade gracefully when viewed from terminal.")
    (license license:gpl3+)))

(define-public emacs-org-pandoc-import
  (let ((commit "db308f1a05be26ce5b287633637ce554599b1377")
        (revision "0"))
    (package
      (name "emacs-org-pandoc-import")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tecosaur/org-pandoc-import/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19z1qaairhpj8kyyqwx8yf53j3f03a9a1z1jfa348qmncnra5jmh"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include
         (cons* "^filters\\/" "^preprocessors" %default-include)
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-exec-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (emacs-substitute-variables "org-pandoc-import.el"
                 ("org-pandoc-import-executable"
                  (search-input-file inputs "bin/pandoc"))))))))
      (inputs
       (list pandoc))
      (home-page "https://github.com/tecosaur/org-pandoc-import/")
      (synopsis "Read and edit non-Org file types in Org")
      (description
       "This package uses Pandoc to convert selected file types to Org.  It can
convert supported non-Org files to an Org file with Pandoc.

It can also intercept requests for non-Org files it knows it can convert,
convert the file to a temporary Org file, and open this file instead.  On
save, it exports back to the original non-Org file.")
      (license license:gpl3+))))

(define-public emacs-org-pomodoro
  ;; Last release version was from 2016.
  (let ((commit "aa07c11318f91219336197e62c47bc7a3d090479")
        (revision "1"))
    (package
      (name "emacs-org-pomodoro")
      (version (git-version "2.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/marcinkoziej/org-pomodoro")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0nbprh2nhnmb7ngp9ndr6zr37ashcsvpi5slv7a37x1dl7j6w1k4"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-alert))
      (arguments
       (list
        #:include #~(cons "^resources\\/" %default-include)
        #:test-command
        #~(list "emacs" "--batch"
                "-l" "org-pomodoro-tests.el"
                "-f" "ert-run-tests-batch-and-exit")
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'make-tests-writable
              (lambda _
                (make-file-writable "org-pomodoro-tests.el")))
            (add-before 'check 'add-require
              (lambda _
                (emacs-batch-edit-file "org-pomodoro-tests.el"
                  `(progn (progn (goto-char (point-min))
                                 (re-search-forward "ert-deftest")
                                 (beginning-of-line)
                                 (forward-line -1)
                                 (insert "(require 'org-pomodoro)"))
                          (basic-save-buffer))))))))
      (home-page "https://github.com/marcinkoziej/org-pomodoro")
      (synopsis "Pomodoro technique for org-mode")
      (description "@code{emacs-org-pomodoro} adds very basic support for
Pomodoro technique in Emacs org-mode.

Run @code{M-x org-pomodoro} for the task at point or select one of the
last tasks that you clocked time for.  Each clocked-in pomodoro starts
a timer of 25 minutes and after each pomodoro a break timer of 5
minutes is started automatically.  Every 4 breaks a long break is
started with 20 minutes.  All values are customizable.")
      (license license:gpl3+))))

(define-public emacs-org-sidebar
  (package
    (name "emacs-org-sidebar")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alphapapa/org-sidebar")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gccih9wgi31m59flljw4cphfyhlfcqbjih91gkcnldq5z7n83nj"))
       (modules '((guix build utils)))
       (snippet #~(begin
                    (delete-file-recursively "images")
                    ;; Contents of makem package, but no tests.
                    (for-each delete-file
                              '("makem.sh" "Makefile"))))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash
           emacs-org
           emacs-org-ql
           emacs-org-super-agenda
           emacs-s))
    (home-page "https://github.com/alphapapa/org-sidebar")
    (synopsis "Helpful sidebar for Org buffers")
    (description "This package provides a sidebar for Org buffers.  At the
top is a chronological list of scheduled and deadlined tasks in the current
buffer (similar to the Org agenda ,but without all its features), and below
that is a list of all other non-done to-do items.  If the buffer is narrowed,
the sidebar only shows items in the narrowed portion; this allows seeing an
overview of tasks in a subtree.")
    (license license:gpl3+)))

(define-public emacs-org-trello
  (package
    (name "emacs-org-trello")
    (version "0.8.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/org-trello/org-trello")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "18y5zdjc7zh4jlwz6k1nl13i721rknqm0vp4mxfnmq0sc5a0qva0"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f  ; Old incompatible version of dash is used.
           #:test-command #~(list "ert-runner")))
    (native-inputs (list emacs-ert-runner emacs-undercover))
    (propagated-inputs
     (list emacs-dash
           emacs-deferred
           emacs-f
           emacs-helm
           emacs-request
           emacs-s))
    (home-page "https://org-trello.github.io")
    (synopsis "Emacs minor mode for interacting with Trello")
    (description "This package provides an Emacs minor mode to extend
@code{org-mode} with Trello abilities.  Trello is an online project
organizer.")
    (license license:gpl3+)))

(define-public emacs-org-tanglesync
  (let ((commit "af83a73ae542d5cb3c9d433cbf2ce1d4f4259117")
        (revision "3"))
    (package
      (name "emacs-org-tanglesync")
      (version (git-version "1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/mtekman/org-tanglesync.el/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "11rfn0byy0k0321w7fjgpa785ik1nrk1j6d0y4j0j4a8gys5hjr5"))))
      (build-system emacs-build-system)
      (arguments
       (list
        ;; no tests
        #:tests? #f))
      (home-page "https://gitlab.com/mtekman/org-tanglesync.el/")
      (synopsis "Sync Org source blocks with tangled external files")
      (description "This package automatically pulls changes from source code
to their corresponding tangled blocks.")
      (license license:gpl3+))))

(define-public emacs-company-flow
  (let ((commit "76ef585c70d2a3206c2eadf24ba61e59124c3a16")
        (revision "1"))
    (package
      (name "emacs-company-flow")
      (version (git-version "0.1.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/aaronjensen/company-flow/")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0zs9cblnbkxa0dxw4lyllmybqizxcdx96gv8jlhx20nrjpi78piw"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-company emacs-dash))
      (home-page "https://github.com/aaronjensen/company-flow/")
      (synopsis "Flow backend for @code{company-mode}")
      (description
       "This package provides completion for JavaScript files utilizing Flow.")
      (license license:gpl3+))))

(define-public emacs-habitica
  (let ((commit "c45c602ddf9d6cbb0e3baf5cb3e1b7ef90f2759d")
        (revision "1"))
    (package
      (name "emacs-habitica")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/abrochard/emacs-habitica")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0wgnzn3z98bl28jgqi7xklw9fwx2wwgihj3mq0jb8ah4vn70d0j3"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/abrochard/emacs-habitica")
      (synopsis "Emacs interface for Habitica")
      (description "Emacs extension for @uref{https://habitica.com/, Habitica},
a RPG style habit tracker and todo list.")
      (license license:gpl3+))))

(define-public emacs-atom-one-dark-theme
  (let ((commit "1f1185bf667a38d3d0d180ce85fd4c131818aae2")
        (revision "0"))
    (package
     (name "emacs-atom-one-dark-theme")
     (version (git-version "0.4.0" revision commit))
     (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/jonathanchu/atom-one-dark-theme")
                    (commit commit)))
              (sha256
               (base32
                "1alma16hg3mfjly8a9s3mrswkjjx4lrpdnf43869hn2ibkn7zx9z"))
              (file-name (git-file-name name version))))
     (build-system emacs-build-system)
     (home-page "https://github.com/jonathanchu/atom-one-dark-theme")
     (synopsis "Atom One Dark color theme for Emacs")
     (description "An Emacs port of the Atom One Dark theme from Atom.io.")
     (license license:gpl3+))))

(define-public emacs-atomic-chrome
  (let ((commit "072a137a19d7e6a300ca3e87c0e142a7f4ccb5fb")
        (revision "1"))
    (package
      (name "emacs-atomic-chrome")
      (version (git-version "2.0.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/alpha22jp/atomic-chrome")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0lfvqzndip8jxlc0j7pc4kxi9vi84qsqmkhaq14rj3krx79djqnq"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-websocket))
      (home-page "https://github.com/alpha22jp/atomic-chrome")
      (synopsis
       "Edit browser text area with Emacs using Atomic Chrome or Ghost Text")
      (description
       "This is an Emacs version of Atomic Chrome and Ghost Text,
which are extensions that allows you to edit text areas of the browser in
Emacs.

The input on Emacs is reflected to the browser instantly and continuously.
You can use both the browser and Emacs at the same time.  They are updated to
the same content bi-directionally.")
      (license license:gpl2+))))

(define-public emacs-zenburn-theme
  (package
    (name "emacs-zenburn-theme")
    (version "2.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bbatsov/zenburn-emacs")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "00zyx2knfchxkml19kf4wfgigsbgzqf47mvbgrmk3nfznnnnyvmf"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/bbatsov/zenburn-emacs")
    (synopsis "Low contrast color theme for Emacs")
    (description
     "Zenburn theme is a port of the popular Vim Zenburn theme for Emacs.
It is built on top of the custom theme support in Emacs 24 or later.")
    (license license:gpl3+)))

(define-public emacs-moe-theme
  (package
    (name "emacs-moe-theme")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kuanyui/moe-theme.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14higsv6h0pka90gr25a3yxh95xn65l6qxb39mmdzkfdlnzsg664"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/kuanyui/moe-theme.el")
    (synopsis "Anime-inspired color themes")
    (description
     "This package provides vibrant color schemes with light and dark
variants.")
    (license license:gpl3+)))

(define-deprecated-package emacs-moe-theme-el
  emacs-moe-theme)

(define-public emacs-color-theme-sanityinc-tomorrow
  (package
    (name "emacs-color-theme-sanityinc-tomorrow")
    (version "1.18")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url
              "https://github.com/purcell/color-theme-sanityinc-tomorrow")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0r8q6ld2zma1bqq5pv61gpy99a4vx6bwx4v820ijzbymmi62vv3z"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "./run-tests.sh")))
    (home-page "https://github.com/purcell/color-theme-sanityinc-tomorrow")
    (synopsis "Emacs color themes based on Chris Kempson's 'tomorrow' themes")
    (description
     "An Emacs version of Chris Kempson's \"Tomorrow\" themes, with much more
extensive face definitions than the \"official\" Emacs variant.")
    (license license:gpl3+)))

(define-public emacs-solarized-theme
  (package
    (name "emacs-solarized-theme")
    (version "2.0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bbatsov/solarized-emacs/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0nwyax9dikpw4fcplnk0az9k1pk02wnhkadvfp325s7rl2j8y23b"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f  ; Tests require a standard tty.
           #:test-command #~(list "make" "run" "CASK=")))
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://github.com/bbatsov/solarized-emacs")
    (synopsis "Port of the Solarized theme for Emacs")
    (description
     "Solarized for Emacs is a port of the Solarized theme for Vim.  This
package provides a light and a dark variant.")
    (license license:gpl3+)))

(define-public emacs-color-theme-solarized
  ;; From 2017-10-24.  No releases available.
  (let ((commit "f3ca8902ea056fb8e46cb09f09c96294e31cd4ee")
        (revision "0"))
    (package
      (name "emacs-color-theme-solarized")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url
                       "https://github.com/sellout/emacs-color-theme-solarized")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "16d7adqi07lzzr0qipl1fbag9l8kiyr3xrqxi528pimcisbg85d3"))))
      (build-system emacs-build-system)
      (arguments
       (list #:tests? #f                ; no tests
             #:phases
             #~(modify-phases %standard-phases
                 ;; These are intended for old versions of Emacs and do not
                 ;; compile with emacs>=24.
                 (add-before 'install 'remove-color-theme
                   (lambda _
                     (delete-file "./color-theme-solarized.el")
                     (delete-file "./color-theme-solarized-pkg.el"))))))
      (home-page "https://github.com/sellout/emacs-color-theme-solarized")
      (synopsis "Solarized color scheme for Emacs")
      (description
       "This package provides Emacs highlighting using Ethan Schoonover’s
Solarized color scheme.")
      (license license:expat))))

(define-public emacs-color-identifiers-mode
  (let ((commit "a26d00d898e0a3295cb7da9323046397223ea1fe")
        (revision "0"))
    (package
      (name "emacs-color-identifiers-mode")
      (version (git-version "1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ankurdave/color-identifiers-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1kky827f922ziiwasrfnv97vqdf62fp9yml36x1fjsm2h6qw0c8v"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-dash))
      (home-page "https://github.com/ankurdave/color-identifiers-mode")
      (synopsis "Minor mode for coloring identifiers based on their names")
      (description
       "This package provides an Emacs minor mode to highlight each source
code identifier uniquely based on its name.")
      (license license:gpl3+))))

(define-public emacs-poet-theme
  (let ((commit "16eb694f0755c04c4db98614d0eca1199fddad70")
        (revision "1"))
    (package
      (name "emacs-poet-theme")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/kunalb/poet")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0zm8jbviddyj7jnyssh77jx43jghbpjwr77n9s3cjp3bmadwkrv5"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/kunalb/poet/")
      (synopsis "Emacs theme for prose")
      (description
       "Emacs has very good support for multiple fonts in a single file.  Poet
uses this support to make it much more convenient to write prose within Emacs,
with particular attention paid to @code{org-mode} and @code{markdown-mode}.
Code blocks, tables, etc are formatted in monospace text with the appropriate
backgrounds.")
      (license license:expat))))

(define-public emacs-ahungry-theme
  (package
    (name "emacs-ahungry-theme")
    (version "1.10.0")
    (source
     (origin (method url-fetch)
             (uri (string-append "https://elpa.gnu.org/packages/ahungry-theme-"
                                 version ".tar"))
             (sha256
              (base32
               "14q5yw56n82qph09bk7wmj5b1snhh9w0nk5s1l7yn9ldg71xq6pm"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ahungry/color-theme-ahungry")
    (synopsis "Ahungry color theme for Emacs")
    (description "Ahungry theme for Emacs provides bright and bold colors.
If you load it from a terminal, you will be able to make use of the
transparent background.  If you load it from a GUI, it will default to a
dark background.")
    (license license:gpl3+)))

(define-public emacs-color-theme-modern
  ;; No release since October 2019
  (let ((commit "74ad69bbca6fcfff3c0960d888c7c9c1f9f3e2e8")
        (revision "1"))
    (package
      (name "emacs-color-theme-modern")
      (version (git-version "0.0.3" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/emacs-jp/replace-colorthemes.git")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "13ff4s372wsl5x13vh4vywhi6qcc54gybhp6rxl0r1l4wxidanwn"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/emacs-jp/replace-colorthemes")
      (synopsis "Emacs color themes implemented via built-in customization")
      (description "This package contains several themes that were originally
implemented with the venerable @code{color-themes} package, ported to Emacs'
built-in custom themes.")
      (license license:gpl3+))))

(define-public emacs-gruvbox-theme
  (package
    (name "emacs-gruvbox-theme")
    (version "1.30.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/greduan/emacs-theme-gruvbox")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1bnmp9nbpsrnxhn6v81533xcb9hx043wf86n5hwj9mpacl5ic33y"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-autothemer))
    (home-page "https://github.com/greduan/emacs-theme-gruvbox")
    (synopsis "Gruvbox is a retro groove color scheme ported from Vim")
    (description
     "Gruvbox is heavily inspired by badwolf, jellybeans and solarized.

Designed as a bright theme with pastel 'retro groove' colors and light/dark
mode switching in the way of solarized.  The main focus when developing gruvbox
is to keep colors easily distinguishable, contrast enough and still pleasant
for the eyes.")
    (license license:expat))) ; MIT license

(define-public emacs-spacegray-theme
  (let ((commit "9826265c2bceb2ebc1c5e16a45021da0253ace97")
        (revision "0"))
    (package
      (name "emacs-spacegray-theme")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/bruce/emacs-spacegray-theme")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0aplwmm17ypbns5blc4rf5rr6dasj0zp5ibykpfl43fh4bd8z89n"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/bruce/emacs-spacegray-theme")
      (synopsis "Port of Sublime Text's Spacegray theme for Emacs")
      (description
       "@code{spacegray-theme} is an Emacs port of the Spacegray theme from
Sublime Text.  It features a dark blue/gray background and soft blue, green,
orange and red as accent colors.")
      (license license:expat)))) ; MIT license

(define-public emacs-org-cv
  ;; There are no tagged releases.
  (let ((commit "24bcd82348d441d95c2c80fb8ef8b5d6d4b80d95")
        (revision "0"))
    (package
      (name "emacs-org-cv")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/Titan-C/org-cv")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0zcnbxvlwi4d6vzsm3ag7z74qphdigmx303gppb9d614jnsfsdg2"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ox-hugo))
      (home-page "https://titan-c.gitlab.io/org-cv/")
      (synopsis "Collection of export backends for Org to generate a CV")
      (description
       "This project exports an Org file with reasonably structured items into
a LaTeX file, which compiles into a nice CV.  In the same spirit, the Org file
may export to Markdown so that it can be used for a web based CV.")
      (license license:gpl3+))))

(define-public emacs-ox-gfm
  (package
    (name "emacs-ox-gfm")
    (version "1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/larstvei/ox-gfm")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0drdypmgxk3238hmkqw9s3cw9wv94cyfqar5ar0bv0k69s92pxj8"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/larstvei/ox-gfm")
    (synopsis "Github Flavored Markdown Back-End for Org Export Engine")
    (description "This package is a small exporter based on the Markdown
exporter already existing in Org mode.  It supports the Github flavored
markdown features.")
    (license license:gpl3+)))

(define-public emacs-2048-game
  (package
    (name "emacs-2048-game")
    (version "20151026.1233")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://melpa.org/packages/2048-game-"
                           version ".el"))
       (sha256
        (base32
         "0gy2pvz79whpavp4jmz8h9krzn7brmvv3diixi1d4w51pcdvaldd"))))
    (build-system emacs-build-system)
    (home-page "https://hg.sr.ht/~zck/game-2048")
    (synopsis "Implementation of the game 2048 in Emacs Lisp")
    (description
     "This program is an implementation of 2048 for Emacs.
The goal of this game is to create a tile with value 2048.  The size of the
board and goal value can be customized.")
    (license license:gpl3+)))

(define-public emacs-chess
  (package
    (name "emacs-chess")
    (version "2.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "chess-" version ".tar"))
       (sha256
        (base32 "1a4iwjdh6k348df6qywjws9z9f862d62m0b2sz57z4xhywiyxpr7"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'install-pieces
            (lambda _
              (copy-recursively
               "pieces"
               (string-append (elpa-directory #$output) "/pieces")))))))
    (home-page "https://elpa.gnu.org/packages/chess.html")
    (synopsis "Play chess in GNU Emacs")
    (description
     "Chess is an Emacs Lisp library and several clients on top of the
underlying library functionality for performing various activities related to
the game of chess.")
    (license license:gpl3+)))

(define-public emacs-4clojure
  ;; There is no release.  Base version is extracted from Version keyword in
  ;; the main file.
  (let ((commit "4eccf8c7d4341a36c269451838114b27836699f9")
        (revision "1"))
    (package
      (name "emacs-4clojure")
      (version (git-version "0.2.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsorphanage/4clojure")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19x653lzc1dxil4ix257hciidbdmbhaxhs6qhlkwi9ygjrlrgvnk"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-request))
      (home-page "https://github.com/emacsorphanage/4clojure/")
      (synopsis "Open and evaluate 4clojure questions in Emacs")
      (description "Emacs 4clojure interacts with
@url{http://www.4clojure.com, 4clojure} problems.  You can open a specific
question and move to the next or previous one.  You can also verify your
answers.")
      (license license:gpl3+))))

(define-public emacs-base16-theme
  (package
    (name "emacs-base16-theme")
    (version "3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tinted-theming/base16-emacs")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mdnm6xam1md9yiy6y14yp59j2864brazqszm7vklgb40xpxaxsq"))))
    (build-system emacs-build-system)
    (arguments
     (list #:include #~(cons "^build\\/.*\\.el$" %default-include)
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'install 'mv-themes
                 (lambda _
                   (use-modules (ice-9 regex))
                   (let ((theme-dir (string-append (elpa-directory #$output)
                                                   "/build")))
                     (for-each (lambda (theme)
                                 (rename-file
                                  theme
                                  (regexp-substitute #f
                                                     (string-match "build\\/"
                                                                   theme)
                                                     'pre 'post)))
                               (find-files theme-dir "\\.el$"))
                     (delete-file-recursively theme-dir)))))))
    (home-page "https://github.com/tinted-theming/base16-emacs")
    (synopsis "Base16 color themes for Emacs")
    (description
     "Base16 provides carefully chosen syntax highlighting and a default set
of sixteen colors suitable for a wide range of applications.  Base16 is not a
single theme but a set of guidelines with numerous implementations.")
    (license license:expat)))

(define-public emacs-solaire-mode
  (package
    (name "emacs-solaire-mode")
    (version "2.0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hlissner/emacs-solaire-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "164qqzmj1321rkvpiwpr5xnm1nbniibjkymfw5az32m2acdwk52j"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "make" "test")))
    (home-page "https://github.com/hlissner/emacs-solaire-mode")
    (synopsis "Change background of file-visiting buffers in Emacs")
    (description
     "@code{solaire-mode} is inspired by editors which visually distinguish
code-editing windows from sidebars, popups, terminals, ecetera.  It changes the
background of file-visiting buffers (and certain aspects of the UI) to make
them easier to distinguish from other, less important buffers.")
    (license license:expat)))

(define-public emacs-embark
  (package
    (name "emacs-embark")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/oantolin/embark")
             (commit version)))
       (sha256
        (base32 "1361jvwr3wjbpmq6dfkrhhhv9vrmqpkp1j18syp311g6h8hzi3hg"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (native-inputs (list texinfo))
    (propagated-inputs
     (list emacs-avy emacs-consult))
    (home-page "https://github.com/oantolin/embark")
    (synopsis "Emacs mini-buffer actions rooted in keymaps")
    (description
     "This package provides a sort of right-click contextual menu for Emacs
offering you relevant @emph{actions} to use on a @emph{target} determined by
the context.

In the minibuffer, the target is the current best completion candidate.  In
the @code{*Completions*} buffer the target is the completion at point.  In
a regular buffer, the target is the region if active, or else the file, symbol
or URL at point.

The type of actions offered depend on the type of the target.  For files you
get offered actions like deleting, copying, renaming, visiting in another
window, running a shell command on the file, etc.  For buffers the actions
include switching to or killing the buffer.  For package names the actions
include installing, removing or visiting the homepage.")
    (license license:gpl3+)))

(define-public emacs-prescient
  (package
    (name "emacs-prescient")
    (version "6.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/raxod502/prescient.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0f4wi8aq3yfykxfza4y4c5yhcs50cs3gpfj0qrmvfq9hvkhzj52w"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "make" "test")))
    (propagated-inputs
     (list emacs-company emacs-corfu emacs-ivy emacs-selectrum emacs-vertico))
    (home-page "https://github.com/raxod502/prescient.el/")
    (synopsis "Emacs library for sorting and filtering candidates")
    (description
     "Prescient is a library for sorting and filtering, as well as extensions
for Ivy and Company that make use of the library.")
    (license license:expat)))

(define-public emacs-selectrum
  (package
    (name "emacs-selectrum")
    (version "3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/raxod502/selectrum")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "02jrki6vzyfyi1bbslki5pk2348flh9dz18jkc4y7p60bvbr52cb"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (home-page "https://github.com/raxod502/selectrum/")
    (synopsis "Incremental narrowing in Emacs")
    (description "Selectrum is a solution for incremental narrowing in
Emacs, replacing Helm, Ivy, and IDO.  Its design philosophy is based
on choosing the right abstractions and prioritizing consistency and
predictability over special-cased improvements for particular cases.
As such, Selectrum follows existing Emacs conventions where they exist
and are reasonable, and it declines to implement features which have
marginal benefit compared to the additional complexity of a new
interface.")
    (license license:expat)))

(define-public emacs-orderless
  (package
    (name "emacs-orderless")
    (version "1.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/oantolin/orderless")
             (commit version)))
       (sha256
        (base32 "0cgklam29vsfrl70n3cqv1dxbsnpzjylfxabfs9v1yz02q27nggv"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (native-inputs (list texinfo))
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/oantolin/orderless")
    (synopsis
     "Emacs completion style that matches multiple regexps in any order")
    (description "This package provides an orderless completion style that
divides the pattern into space-separated components, and matches candidates
that match all of the components in any order.  Each component can match in
any one of several ways: literally, as a regexp, as an initialism, in the flex
style, or as multiple word prefixes.")
    (license license:gpl3+)))

(define-public emacs-consult
  (package
    (name "emacs-consult")
    (version "3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/minad/consult")
             (commit version)))
       (sha256
        (base32 "1qhmlig5z5gmavzw4l7ml3rqgr6aa7as80wxrdigf5i6mdn58z67"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f ; there are no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (native-inputs (list texinfo))
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/minad/consult")
    (synopsis "Consulting completing-read")
    (description "This package provides various handy commands based on the
Emacs completion function completing-read, which allows quickly selecting from a
list of candidates.")
    (license license:gpl3+)))

(define-public emacs-consult-bibtex
  ;; XXX: Upstream contains a single commit, which matches the version below.
  (let ((commit "2f870d6eefb54a53216d90a82cff0ff97ba54725"))
    (package
      (name "emacs-consult-bibtex")
      (version "0.1")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/mohkale/consult-bibtex")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0jxjvpg3j8zk77sfhyy27fd1zbj2zz7xayavan3hhj4853q92kwq"))))
      (build-system emacs-build-system)
      (inputs (list emacs-consult emacs-embark emacs-org-roam-bibtex))
      (home-page "https://github.com/mohkale/consult-bibtex")
      (synopsis "Consulting-read interface for BibTeX completion")
      (description "This package provides a read interface for BibTeX
completion using Consult.")
      (license license:gpl3+))))

(define-public emacs-consult-denote
  (package
    (name "emacs-consult-denote")
    (version "0.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/protesilaos/consult-denote/")
              (commit version)))
       (sha256
        (base32 "0lc16scxbxc79zsxmsb0kf8lkhpz16v3vcyfzm00zl5pmn5yy7x8"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f ;no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (native-inputs (list texinfo))
    (propagated-inputs (list emacs-consult emacs-denote))
    (home-page "https://github.com/protesilaos/consult-denote")
    (synopsis "Consult interface for Denote")
    (description
     "Consult Denote provides commands to interact with Emacs Denote using
a Completing Read interface.")
    (license license:gpl3+)))

(define-public emacs-consult-dir
  (package
    (name "emacs-consult-dir")
    (version "0.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/karthink/consult-dir")
                    (commit (string-append "v" version))))
              (sha256
               (base32 "1cff4ssrn1mw2s5n090pdmwdirnfih8idg5f0ll2bi2djc4hq5kn"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-consult))
    (home-page "https://github.com/karthink/consult-dir")
    (synopsis "Insert paths into minibuffer prompts in Emacs")
    (description "Consult-dir allows you to easily insert directory
paths into the minibuffer prompt in Emacs.

When using the minibuffer, you can switch---with completion and filtering
provided by your completion setup---to any directory you’ve visited recently,
or to a project or bookmarked directory.  The minibuffer prompt will be
replaced with the directory you choose.")
    (license license:gpl3+)))

(define-public emacs-consult-mu
  (let ((commit "e1dc63674b924698b30a9ecc0400a05864711c85")
        (revision "0"))
    (package
      (name "emacs-consult-mu")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/armindarvish/consult-mu/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "17ad0901xbg2vrgdvpp67kia2r7gqsvbkqqb44f4pwakr7zwiz2y"))))
      (build-system emacs-build-system)
      (arguments
       '(#:phases (modify-phases %standard-phases
                    (add-after 'unpack 'move-source-files
                      (lambda _
                        (let ((el-files (find-files "./extras" ".*\\.el$")))
                          (for-each (lambda (f)
                                      (rename-file f
                                                   (basename f))) el-files)))))))
      (propagated-inputs (list emacs-consult emacs-embark mu))
      (home-page "https://github.com/armindarvish/consult-mu/")
      (synopsis "Search mu4e emails with Consult")
      (description "This package provides a query interface for mu4e using
Consult.")
      (license license:gpl3+))))

(define-public emacs-consult-notes
  (let ((commit "7c9cd970c75fae9a6140ca1beefed9532d8e1b96")
        (revision "0"))
    (package
      (name "emacs-consult-notes")
      (version (git-version "0.7" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/mclear-tools/consult-notes/")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1lccpnqqaai6vsjn9v65xhpzs0bmhrsyflaxg3n3iszigmsxrfaz"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))      ;no tests
      (propagated-inputs (list emacs-consult emacs-dash emacs-s))
      (home-page "https://github.com/mclear-tools/consult-notes/")
      (synopsis "Management of personal notes with @code{emacs-consult}")
      (description
       "This package allows selecting notes easily.  Its most basic use is to
integrate directories of files (notes) and to provide easy narrowing via
@code{emacs-consult}.  @code{consult-notes} can be used with any directory (or
directories) of note files.  It easily integrates with note systems like
@code{emacs-zk}, @code{emacs-denote} or @code{emacs-org-roam}.  Additionally, it
may also search org headings in a set of specified files.")
      (license license:gpl3+))))

(define-public emacs-consult-notmuch
  (package
    (name "emacs-consult-notmuch")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/jao/consult-notmuch")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1yx33bzj251igsagdphlxa84wb07ynlz4rf1nplpk19m5lfkj54c"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-consult emacs-notmuch))
    (home-page "https://codeberg.org/jao/consult-notmuch")
    (synopsis "Search and preview Notmuch emails using Consult")
    (description
     "This package provides two commands using Consult to query Notmuch emails
and present results either as single emails or full trees.")
    (license license:gpl3+)))

(define-public emacs-consult-org-roam
  (let* ((commit "2ca42a1c1641a29f1447d35be01bd1fda368a9e2")
         (revision "1"))
    (package
      (name "emacs-consult-org-roam")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jgru/consult-org-roam")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "142fra7wap6dfwd4c82j7z3nk1yw78slrwhjx6vkiql8ylbiw5fi"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-consult emacs-org-roam))
      (home-page "https://github.com/jgru/consult-org-roam")
      (synopsis "Consult integration for Org Roam")
      (description
       "This is a set of functions to use Org Roam with Consult.  This
packages replaces Org Roam's own completing read functions with equivalent
versions utilizing Consult's internal API.")
      (license license:gpl3+))))

(define-public emacs-consult-eglot
  (package
    (name "emacs-consult-eglot")
    (version "0.5.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/mohkale/consult-eglot")
                    (commit (string-append "v" version))))
              (sha256
               (base32
                "1xx5g4z4l0kanf2mh3f798gw8ydfzbx15wfyqrnhwhiljz796xis"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs (list emacs-consult emacs-eglot))
    (home-page "https://github.com/mohkale/consult-eglot")
    (synopsis "Consulting-read interface for eglot")
    (description "This package acts as a parallel of consult-lsp for eglot and
provides a front-end interface for the workspace/symbols LSP procedure
call.")
    (license license:gpl3+)))

(define-public emacs-consult-flycheck
  (package
    (name "emacs-consult-flycheck")
    (version "1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/minad/consult-flycheck")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1yi2qa4gbxlyhwc4rj3iidgr1dpdij68gbkgkk55l53p3yl1p2ww"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-consult emacs-flycheck))
    (home-page "https://github.com/minad/consult-flycheck")
    (synopsis "Consult integration for Flycheck")
    (description
     "This package provides the @code{consult-flycheck} command for Emacs,
 which integrates @code{Consult} with @code{Flycheck}.")
    (license license:gpl3+)))

(define-public emacs-eglot-tempel
  (package
    (name "emacs-eglot-tempel")
    (version "0.8.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fejfighter/eglot-tempel")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "00v94h3zvl2pm1yizjmdfqgmzwqq8aghjixdcb23x703inq5p82x"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "emacs" "-Q" "-batch"
                             "-l" "eglot-tempel-tests.el"
                             "-f" "ert-run-tests-batch-and-exit")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'skip-failing-test
            (lambda _
              (substitute* "eglot-tempel-tests.el"
                (("\\(ert-deftest test-named .*" all)
                 (string-append all " (skip-unless nil)"))))))))
    (native-inputs (list emacs-ert-runner))
    (propagated-inputs (list emacs-eglot emacs-peg emacs-tempel))
    (home-page "https://github.com/fejfighter/eglot-tempel")
    (synopsis "Bridge for Tempel templates with Eglot")
    (description "This package is an adapter to use the Tempel templating
library with Eglot instead of Yasnippet.")
    (license license:gpl3+)))

(define-public emacs-eglot-jl
  (package
    (name "emacs-eglot-jl")
    (version "2.4.0")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/non-Jedi/eglot-jl")
         (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1xy6lssg5x8m2d5802in2b5nl5wrcxz4pilw85kk0mc8640kg2ma"))))
    (build-system emacs-build-system)
    (arguments (list #:include #~(cons "\\.(jl|toml)$" %default-include)))
    (propagated-inputs (list emacs-eglot))
    (home-page "https://github.com/non-Jedi/eglot-jl")
    (synopsis "Julia support for Eglot")
    (description
     "This package adds support for Eglot to the Julia language.")
    (license license:cc0)))

(define-public emacs-consult-xdg-recent-files
  (let ((commit "593023ffb99a368152ebd4e739488fa560bdfdea")
        (revision "0"))
    (package
      (name "emacs-consult-xdg-recent-files")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hrehfeld/consult-xdg-recent-files")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0nd23n67dmlflw52dc1rbhy04mc9ymydnsmvfr75hqb7sznn3343"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-consult))
      (home-page "https://github.com/hrehfeld/consult-xdg-recent-files")
      (synopsis "Include files used by other programs than Emacs in Consult")
      (description
       "This package provides the ability to include files used by other
programs in the candidate lists of commands like @code{consult-recent-file}
and @code{consult-buffer}.  This allows using the same interface for file
opening.

On systems that comply with the XDG specification, these files are listed in
the file @file{recently-used.xbel}, which is found in the directory
@file{~/.local/share} or the location described by the environment variable
@code{XDG_DATA_HOME}.")
      (license license:gpl3+))))

(define-public emacs-consult-yasnippet
  (let ((commit "ae0450889484f23dc4ec37518852a2c61b89f184")
        (revision "0"))
    (package
      (name "emacs-consult-yasnippet")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mohkale/consult-yasnippet")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "13hmmsnmh32vafws61sckzzy354rq0nslqpyzhw97iwvn0fpsa35"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-consult emacs-yasnippet))
      (home-page "https://github.com/mohkale/consult-yasnippet")
      (synopsis "Consulting-read interface for Yasnippet")
      (description
       "This package allows you to expand Yasnippet' snippets through
a completing-read interface.  It supports previewing the current snippet
expansion and overwriting the marked region with a new snippet completion.")
      (license license:gpl3+))))

(define-public emacs-marginalia
  (package
    (name "emacs-marginalia")
    (version "2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/minad/marginalia")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "064kc6p8zh6vbrcg06jilc7s2zc2kb8bddbqxr0mdypm8pwvymg4"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f                       ;no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (native-inputs (list texinfo))
    (propagated-inputs
     (list emacs-compat))
    (home-page "https://github.com/minad/marginalia")
    (synopsis "Marginalia in the minibuffer completions")
    (description
     "This package provides Marginalia mode which adds marginalia to the
minibuffer completions.  Marginalia are marks or annotations placed at the
margin of the page of a book or in this case helpful colorful annotations
placed at the margin of the minibuffer for your completion candidates.")
    (license license:gpl3+)))

(define-public emacs-smartparens
  (let ((commit "b629b4e893ba21ba5a381f6c0054bb72f8e96df2")
        (revision "1"))
    (package
      (name "emacs-smartparens")
      (version (git-version "1.11.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Fuco1/smartparens")
               (commit commit)))
         (file-name (git-file-name name version))
         (modules '((guix build utils)
                    (ice-9 ftw)
                    (srfi srfi-26)))
         (snippet
          '(begin
             ;; Taken from nextpnr package.
             (define (delete-all-but directory . preserve)
               (with-directory-excursion directory
                 (let* ((pred
                         (negate (cut member <> (append '("." "..") preserve))))
                        (items (scandir "." pred)))
                   (for-each delete-file items))))
             ;; Only activate basic tests.
             (delete-all-but "test"
                             "test-helper.el"
                             "smartparens-advice-test.el"
                             "smartparens-delete-pair-test.el"
                             "smartparens-elisp-test.el"
                             "smartparens-framework-test.el"
                             "smartparens-get-comment-bounds-test.el"
                             "smartparens-get-paired-expression-elisp-test.el"
                             "smartparens-get-prefix-test.el"
                             "smartparens-get-stringlike-expression-elisp-test.el"
                             "smartparens-get-stringlike-expression-python-test.el"
                             "smartparens-get-stringlike-expression-test.el"
                             "smartparens-get-suffix-test.el"
                             "smartparens-insertion-specification-parser-test.el"
                             "smartparens-markdown-test.el"
                             "smartparens-movement-test.el"
                             "smartparens-org-test.el"
                             "smartparens-region-ok-test.el"
                             "smartparens-rst-test.el"
                             "smartparens-search-fn-test.el"
                             "smartparens-settings-sp-pair-test.el"
                             "smartparens-skip-closing-pair-test.el")))
         (sha256
          (base32 "1nfd10kxd1l8bmxhaghhxphl424yg5qn6xcqaligwc3b406b566w"))))
      (build-system emacs-build-system)
      (native-inputs
       (list emacs-ert-runner emacs-yasnippet))
      (propagated-inputs
       (list emacs-dash emacs-markdown-mode))
      (home-page "https://github.com/Fuco1/smartparens")
      (synopsis "Paredit-like insertion, wrapping and navigation with user
defined pairs")
      (description
       "Smartparens is a minor mode for Emacs that deals with parens pairs
and tries to be smart about it.  It started as a unification effort to
combine functionality of several existing packages in a single,
compatible and extensible way to deal with parentheses, delimiters, tags
and the like.  Some of these packages include autopair, textmate,
wrap-region, electric-pair-mode, paredit and others.  With the basic
features found in other packages it also brings many improvements as
well as completely new features.")
      (license license:gpl3+))))

(define-public emacs-dumbparens
  ;; There are no releases.
  (let ((commit "59bb5aeb85bdc0772a7a21d1194be87aae6f2b7b")
        (revision "1"))
    (package
      (name "emacs-dumbparens")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/radian-software/dumbparens")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0c5zw9qcq5n33212p8fcnjvgn6z582178dnv0jhnrl887h5xr9w2"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "make" "test")))
      (home-page "https://github.com/radian-software/dumbparens")
      (synopsis "Minor mode that provides improvements on Smartparens")
      (description
       "@code{emacs-dumbparens} is a minor mode for Emacs that deals with parens
pairs and doesn't try to be smart about it.")
      (license license:expat))))

(define-public emacs-highlight-symbol
  ;; We prefer a more recent commit that provides an option to squelch
  ;; echo-area alerts that can drown out useful information like eldoc
  ;; messages.
  (let ((commit "7a789c779648c55b16e43278e51be5898c121b3a")
        (version "1.3")
        (revision "1"))
    (package
      (name "emacs-highlight-symbol")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/nschum/highlight-symbol.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19cgyk0sh8nsmf3jbi92i8qsdx4l4yilfq5jj9zfdbj9p5gvwx96"))))
      (build-system emacs-build-system)
      (home-page "https://nschum.de/src/emacs/highlight-symbol/")
      (synopsis "Automatic and manual symbol highlighting for Emacs")
      (description
       "Use @code{highlight-symbol} to toggle highlighting of the symbol at
point throughout the current buffer.  Use @code{highlight-symbol-mode} to keep
the symbol at point highlighted.

The functions @code{highlight-symbol-next}, @code{highlight-symbol-prev},
@code{highlight-symbol-next-in-defun} and
@code{highlight-symbol-prev-in-defun} allow for cycling through the locations
of any symbol at point.  Use @code{highlight-symbol-nav-mode} to enable key
bindings @code{M-p} and @code{M-p} for navigation.  When
@code{highlight-symbol-on-navigation-p} is set, highlighting is triggered
regardless of @code{highlight-symbol-idle-delay}.

@code{highlight-symbol-query-replace} can be used to replace the symbol.")
      (license license:gpl2+))))

(define-public emacs-symbol-overlay
  (package
    (name "emacs-symbol-overlay")
    (version "4.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/wolray/symbol-overlay")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xqzn4j27xny3gmjan9phcl60zipp49p79nv57i7mpz8y0qahc59"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (home-page "https://github.com/wolray/symbol-overlay")
    (synopsis "Highlight symbols and perform various search operations on them")
    (description
     "This package provides functions for highlighting and navigating
between symbols.")
    (license license:gpl3+)))

(define-public emacs-hl-todo
  (package
    (name "emacs-hl-todo")
    (version "3.9.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/tarsius/hl-todo")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1ym4al62ljnpr6zk459qwl1as8hf8grvigh28h635bc5mv6qnaj3"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs
     (list emacs-compat))
    (home-page "https://github.com/tarsius/hl-todo")
    (synopsis "Emacs mode to highlight TODO and similar keywords")
    (description
     "This package provides an Emacs mode to highlight TODO and similar
keywords in comments and strings.  This package also provides commands for
moving to the next or previous keyword and to invoke @code{occur} with a
regexp that matches all known keywords.")
    (license license:gpl3+)))

(define-public emacs-pde
  (package
    (name "emacs-pde")
    (version "0.2.17")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "mirror://cpan/authors/id/Y/YE/YEWENBIN/Emacs-PDE-v"
                           version ".tar.gz"))
       (modules '((guix build utils)))
       (snippet '(begin
                   ;; Delete pre-generated Texinfo and HTML documentation.
                   (for-each delete-file '("lisp/doc/pde.info"
                                           "lisp/doc/pde.html"))
                   (delete-file-recursively "lisp/doc/pde")))
       (sha256
        (base32 "1i82isha839c8lx73kgp43v7gxr2adsr1yfw1glyxvi62w5ab9qz"))))
    (build-system perl-build-system)
    (arguments
     (list
      #:imported-modules `(,@%emacs-build-system-modules
                           ,@%perl-build-system-modules)
      #:modules '((guix build perl-build-system)
                  (guix build emacs-utils)
                  (guix build utils))
      #:module-build-flags
      #~(list (string-append "--elispdir=" #$output
                             "/share/emacs/site-lisp/pde")
              "--verbose")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-commands
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion "lisp"
                (for-each make-file-writable
                          '("pde-vars.el" "perlcritic.el" "perldoc.el"
                            "perltidy.el"))
                (emacs-substitute-variables "pde-vars.el"
                  ("pde-perl-program"
                   (search-input-file inputs "bin/perl"))
                  ("pde-perl-version"
                   #$(package-version (this-package-input "perl")))
                  ("pde-perldoc-program"
                   (search-input-file inputs "bin/perldoc"))
                  ("pde-find-program"
                   (search-input-file inputs "bin/find")))
                (emacs-substitute-variables "perlcritic.el"
                  ("perlcritic-program"
                   (search-input-file inputs "bin/perlcritic")))
                (emacs-substitute-variables "perldoc.el"
                  ("perldoc-cache-el"
                   "(expand-file-name \"~/.cache/perldoc-cache.el\"")
                  ("perldoc-pod2man"
                   (search-input-file inputs "bin/pod2man")))
                (emacs-substitute-variables "perltidy.el"
                  ("perltidy-program"
                   (search-input-file inputs "bin/perltidy")))
                (substitute* "tools/perldoc-cache.pl"
                  (("`perldoc")
                   (string-append
                    "`" (search-input-file inputs "bin/perldoc")))))))
          (add-after 'build 'generate-doc
            (lambda _
              (invoke "./Build" "info")))
          (add-after 'install 'move-doc
            (lambda _
              (let ((info (string-append #$output "/share/info/pde.info")))
                (mkdir-p (dirname info))
                (rename-file (string-append
                              #$output
                              "/share/emacs/site-lisp/pde/doc/pde.info")
                             info)))))))
    (native-inputs (list emacs-minimal perl-module-build texinfo))
    (inputs (list findutils perl perl-critic))
    (home-page "https://metacpan.org/release/Emacs-PDE")
    (synopsis "Perl Development Environment for Emacs")
    (description "Emacs::PDE is a collection of Emacs Lisp extensions to
facilitate Perl programming.  CPerl Mode has provided an excellent environment
for coding; Emacs::PDE provides other common tools such as creating files
using templates, smart compiling, @command{perldoc}, @command{perltidy},
debugger, tags tree view and so on.  PDE also provides an easy configuration
for Perl programming, and a tutorial for novices to start using Emacs.")
    (license license:perl-license)))

(define-public emacs-perspective
  (package
    (name "emacs-perspective")
    (version "2.20")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nex3/perspective-el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "108n8xgyxf0mxv6l0mbqb9s0v20bdnj4xcd2mi0zbl46r48cq6gp"))))
    (build-system emacs-build-system)
    (arguments
     `(#:test-command '("emacs" "-Q" "-batch" "-L" "."
                        "-l" "test/test-perspective.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/nex3/perspective-el")
    (synopsis "Switch between named \"perspectives\"")
    (description
     "This package provides tagged workspaces in Emacs, similar to workspaces in
windows managers such as Awesome and XMonad.  @code{perspective.el} provides
multiple workspaces (or \"perspectives\") for each Emacs frame.  Each
perspective is composed of a window configuration and a set of buffers.
Switching to a perspective activates its window configuration, and when in a
perspective only its buffers are available by default.")
    ;; This package is released under the same license as Emacs (GPLv3+) or
    ;; the Expat license.
    (license license:gpl3+)))

(define-public emacs-persp-mode
  (package
    (name "emacs-persp-mode")
    (version "3.0.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Bad-ptr/persp-mode.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0fi07h5q0srjasjxn7rzzd8zahl15agspm6q9hs2rzd0m8x3zp52"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command
           #~(list "buttercup" "-L" "." "-L" "tests")
           #:phases
           #~(modify-phases %standard-phases
               (add-before 'check 'tests-add-lexical-bindings
                 (lambda _
                   (substitute* "tests/test-persp-mode.el"
                     (("\\(require 'buttercup-init\\)" all)
                      (string-append ";;; -*- lexical-binding: t; -*-\n"
                                     all))))))))
    (native-inputs (list emacs-buttercup))
    (home-page "https://github.com/Bad-ptr/persp-mode.el")
    (synopsis "Switch between named \"perspectives\" shared among frames")
    (description
     "This package extends @code{perspective.el} to enable perspectives that
can be saved to and restored from a file.")
    (license license:gpl2+)))

(define-public emacs-eyebrowse
  ;; XXX: Upstream has no tagged release.  Version is extracted from keyword
  ;; in main file.
  (let ((commit "88c7b59aa7c5c93bc23812217213adfa238f977b")
        (revision "0"))
    (package
      (name "emacs-eyebrowse")
      (version (git-version "0.7.8" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://depp.brause.cc/eyebrowse.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "09s07mvg5bz3dm9sxgn40c7z6d6ry1sdjzsxwgmy825f3xm66avs"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://depp.brause.cc/eyebrowse/")
    (synopsis "Simple-minded way to manage window configs in Emacs")
    (description
     "Eyebrowse is a global minor mode for Emacs that allows you to manage
your window configurations in a simple manner, just like tiling window
managers like i3wm with their workspaces do.  It displays their current state
in the modeline by default.")
    (license license:gpl3+))))

(define-public emacs-test-simple
  (let ((commit "da8ddb6fecb820c8e0809ac0892374e755e4efec")) ;version bump
    (package
      (name "emacs-test-simple")
      (version "1.3.1")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/rocky/emacs-test-simple/")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "18a9d1n2xc2fqimvsg0nkvizn7y7sb6ap5i9al526cp40l0yky3n"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (replace 'check
              (lambda* (#:key tests? #:allow-other-keys)
                (when tests?
                  (with-directory-excursion "test"
                    (invoke "emacs" "--batch"
                            "-l" "test-basic.el"
                            "-l" "test-buffer.el"
                            "-l" "test-fns.el"
                            "-l" "test-no-clear.el"))))))))
      (home-page "https://github.com/rocky/emacs-test-simple")
      (synopsis "Simple unit test framework for Emacs Lisp")
      (description
       "Test Simple is a simple unit test framework for Emacs Lisp.  It
alleviates the need for context macros, enclosing specifications or required
test tags.  It supports both interactive and non-interactive use.")
      (license license:gpl3+))))

(define-public emacs-load-dir
  ;; This package is kept inside ELPA; there is no version-specific
  ;; tag. Version string was taken from source code.
  (let ((commit "22bcac73d8808a680fd9b261cd89937d8e5c6a3c")
        (revision "0"))
    (package
      (name "emacs-load-dir")
      (version (git-version "0.0.5" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://git.savannah.gnu.org/git/emacs/elpa.git")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "011m9vnjrxmnpnvf7zjfg3pzkkfsfwc4xf3h5z37f2d4x7ghlw10"))))
      (build-system emacs-build-system)
      (arguments
       (list #:tests? #f))              ; No tests.
      (synopsis "Load all Emacs Lisp files in a given directory")
      (description
       "This package provides a way to load all Emacs Lisp snippets (they
don't have to be libraries) in a directory on startup or when Emacs is already
running.  It won't reload snippets unless the user requests it.")
      (home-page "https://elpa.gnu.org/packages/load-dir.html")
      (license license:gpl3+))))

(define-public emacs-load-relative
  (package
    (name "emacs-load-relative")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/load-relative-"
                           version ".tar"))
       (sha256
        (base32 "1fwa51jp0sq5l69y98l2zyj0iq9s6rj1rnqrmvncif61smma8fd7"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rocky/emacs-load-relative")
    (synopsis "Emacs Lisp relative file loading related functions")
    (description
     "Provides functions which facilitate writing multi-file Emacs packages
and running from the source tree without having to \"install\" code or fiddle
with @code{load-path}.

The main function, @code{load-relative}, loads an Emacs Lisp file relative to
another (presumably currently running) Emacs Lisp file.")
    (license license:gpl3+)))

(define-public emacs-loc-changes
  (package
    (name "emacs-loc-changes")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/loc-changes-"
                           version ".el"))
       (sha256
        (base32
         "1x8fn8vqasayf1rb8a6nma9n6nbvkx60krmiahyb05vl5rrsw6r3"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/rocky/emacs-loc-changes")
    (synopsis "Keeps track of positions even after buffer changes")
    (description
     "This Emacs package provides a mean to track important buffer positions
after buffer changes.")
    (license license:gpl3+)))

(define-public emacs-loccur
  (let ((commit "01b7afa62589432a98171074abb8c5a1e089034a")
        (revision "1"))
    (package
      (name "emacs-loccur")
      (version (git-version "1.2.5" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/fourier/loccur/")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1b1x1xsiwqzsiss1jc6w990v1vfvbn5d5w67yzmx59s9ldjmdqq2"))))
    (build-system emacs-build-system)
      (home-page "https://github.com/fourier/loccur")
      (synopsis "Perform an occur-like folding in current buffer")
      (description
       "Loccur is a tool to quickly navigate a file.  It is a minor mode for
Emacs acting like occur but w/o creating a new window.  It just hides all the
text excepting lines containing matches.")
      (license license:gpl3+))))

(define-public emacs-realgud
  ;; Last tagged release is from 2019.
  (let ((commit "56a8d82830ad65c9cbb9c694617f078f007281ac")
        (revision "0"))
    (package
      (name "emacs-realgud")
      (version (git-version "1.5.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/realgud/realgud/")
                (commit commit)))
         (sha256
          (base32
           "1n232jphfgqbb44p806bpgg2wisbmr5iz09js71knk7n5gslrz25"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'delete-cask-install
              (lambda _
                (delete-file "cask-install.el")))
            (add-after 'expand-load-path 'fix-autogen-script
              (lambda _
                (substitute* "autogen.sh"
                  (("./configure") "sh configure"))))
            (add-after 'fix-autogen-script 'autogen
              (lambda _
                (setenv "CONFIG_SHELL" "sh")
                (invoke "sh" "autogen.sh")))
            (add-after 'fix-autogen-script 'set-home
              (lambda _
                (setenv "HOME" (getenv "TMPDIR"))))
            (add-before 'patch-el-files 'patch-more-el-files
              (lambda _
                ;; Misc failures
                (for-each delete-file
                          (list "test/test-pdb.el"
                                "test/test-shortkey.el"
                                "test/test-track.el"
                                "test/test-trepan2.el"
                                "test/test-lang.el"))
                ;; XXX: Some tests/assumptions in this file are
                ;; not valid on Emacs@30.
                (delete-file "test/test-regexp-perldb.el")
                ;; FIXME: `patch-el-files' crashes on this file with error:
                ;; unable to locate "bashdb".
                (delete-file "./test/test-regexp-bashdb.el"))))
        #:include #~(cons* ".*\\.el$" %default-include)))
      (native-inputs
       (list autoconf automake emacs-test-simple perl python-minimal-wrapper
             ruby))
      (propagated-inputs
       (list emacs-load-relative emacs-loc-changes))
      (home-page "https://github.com/realgud/realgud/")
      (synopsis
       "Modular front-end for interacting with external debuggers")
      (description
       "RealGUD is a modular, extensible GNU Emacs front-end for interacting
with external debuggers.  It integrates various debuggers such as gdb, pdb,
ipdb, jdb, lldb, bashdb, zshdb, etc. and allows visually steping through code in the
sources.  Unlike GUD, it also supports running multiple debug sessions in
parallel.")
      (license license:gpl3+))))

(define-public emacs-rmsbolt
  ;; There is no release tag. Version is extracted from main file.
  (let ((commit "ff496660cc52a6dd33d358ef0acc6d4bb70cc340")
        (revision "0")
        (version "0.1.2"))
    (package
      (name "emacs-rmsbolt")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/jgkamat/rmsbolt")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "05i0101238yy1da6z543nr9x5gpvgdxrrdn3sw5dibcn6z62ml3p"))))
      (build-system emacs-build-system)
      (home-page "https://gitlab.com/jgkamat/rmsbolt")
      (synopsis "Emacs viewer for compiler output")
      (description
       "RMSBolt is a package to provide assembly or bytecode output for
a source code input file.")
      (license license:agpl3+))))

(define-public emacs-request
  ;; We prefer a more recent commit that has support for auth-source,
  ;; and has some bug fixes for Emacs 28.
  (let ((commit "3336eaa97de923f74b90dda3e35985e122d40805")
        (revision "1"))
    (package
      (name "emacs-request")
      (version (git-version "0.3.2" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/tkf/emacs-request")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0jckwy5zhz95d6l3lz8b9b34pppcjjzy97fg1wn8mqzhf3h460ac"))))
      (build-system emacs-build-system)
      (arguments
       `(#:tests? #f))                  ; requires network access.
      (propagated-inputs
       (list emacs-deferred))
      (home-page "https://github.com/tkf/emacs-request")
      (synopsis "Package for speaking HTTP in Emacs Lisp")
      (description "This package provides a HTTP request library with multiple
backends.  It supports url.el which is shipped with Emacs and the curl command
line program.")
      (license license:gpl3+))))

(define-public emacs-http-post-simple
  (let ((commit "f53697fca278c741051aeb668b00466b5e0fd3fe")
        (revision "0"))
    (package
      (name "emacs-http-post-simple")
      ;; Upstream does not provide a version number. The package is very old,
      ;; feature-complete and not likely to be updated. So, we assume a
      ;; version of 1.0.0.
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsorphanage/http-post-simple")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0krdbvvvzn323vx554yw7947nddl3icfjk4wf5kfx7fim5v3mdn6"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #f ;no tests
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-obsolete-functions
              (lambda _
                ;; Replace obsolete functions from 'cl.
                (substitute* "http-post-simple.el"
                  (("\\(require 'url\\)")
                   "(require 'cl-lib)\n(require 'cl-macs)\n(require 'url)")
                  (("\\(destructuring-bind")
                   "(cl-destructuring-bind")
                  (("\\(values")
                   "(cl-values")))))))
      (home-page "https://github.com/emacsorphanage/http-post-simple")
      (synopsis "HTTP POST requests using the url library")
      (description "@code{emacs-http-post-simple} provides a simple HTTP POST
requests library that uses the url library.")
      (license license:gpl2+))))

(define-public emacs-ruby-electric
  (let ((revision "0")
        (commit "c53376da891713e0c49f01aad2ff64d4fbb0b812"))
    (package
      (name "emacs-ruby-electric")
      (version (git-version "2.3.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ruby/elisp-ruby-electric")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "14grv2gwr6lyjlcp8h1frvipyisakkw2q0jpv4h5rd5bzky7m8w0"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/ruby/elisp-ruby-electric")
      (synopsis "Minor mode for electrically editing Ruby code")
      (description
       "Ruby Electric mode accelerates code writing in Ruby by making some keys
electric and automatically supplying with closing parentheses and @code{end}
as appropriate.")
      (license license:ruby))))

(define-public emacs-rudel
  (package
    (name "emacs-rudel")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/rudel-"
                           version ".tar"))
       (sha256
        (base32 "03hcvpp6ykavidwn5x48gs986w1i5icvh7ks6p74pdaagpgw4jmk"))))
    (build-system emacs-build-system)
    (home-page "https://rudel.sourceforge.net/")
    (synopsis "Collaborative editing framework")
    (description
     "Rudel is a collaborative editing environment for GNU Emacs.  Its purpose
is to share buffers with other users in order to edit the contents of those
buffers collaboratively.  Rudel supports multiple backends to enable
communication with other collaborative editors using different protocols,
though currently Obby (for use with the Gobby editor) is the only
fully-functional one.")
    (license license:gpl3+)))

(define-public emacs-wakib-keys
  (package
    (name "emacs-wakib-keys")
    (version "1.0.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/darkstego/wakib-keys.git")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0fr70jmrcnyyl16h0k6kj3gcd50422ggqps688wa7x51dk6f9cvr"))))
    (build-system emacs-build-system)
    (synopsis "Make C-c, C-v and C-x clipboard keys work reliably in Emacs")
    (description "This package provides an Emacs minor mode that provides
modern, efficient and easy to learn keybindings (especially C-c, C-x and C-v
work and provide clipboard action).")
    (home-page "https://github.com/darkstego/wakib-project")
    (license license:gpl3+)))

(define-public emacs-hydra
  (package
    (name "emacs-hydra")
    (version "0.15.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/abo-abo/hydra")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0fapvhmhgc9kppf3bvkgry0cd7gyilg7sfvlscfrfjxpx4xvwsfy"))))
    (build-system emacs-build-system)
    (arguments
     `(#:test-command '("make" "test")))
    (home-page "https://github.com/abo-abo/hydra")
    (synopsis "Make Emacs bindings that stick around")
    (description
     "This package can be used to tie related commands into a family of short
bindings with a common prefix---a Hydra.  Once you summon the Hydra (through
the prefixed binding), all the heads can be called in succession with only a
short extension.  Any binding that isn't the Hydra's head vanquishes the
Hydra.  Note that the final binding, besides vanquishing the Hydra, will still
serve its original purpose, calling the command assigned to it.  This makes
the Hydra very seamless; it's like a minor mode that disables itself
automatically.")
    (license license:gpl3+)))

(define-public emacs-pretty-hydra
  (package
    (name "emacs-pretty-hydra")
    (version "0.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jerrypnz/major-mode-hydra.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "08a15knkdq35pzjq82imff016fbfdib5q4glg2xmdy2b5fnk7jqa"))
       (modules '((guix build utils)))
       (snippet #~(begin (substitute* "test/pretty-hydra-test.el"
                           (("\\(c1 \\(quote foo\\)\\)") "(c1 'foo)"))))))
    (build-system emacs-build-system)
    (arguments
     (list #:exclude #~(cons "^major-mode-hydra\\.el" %default-exclude)))
    (propagated-inputs
     (list emacs-dash emacs-hydra emacs-s))
    (native-inputs (list emacs-ert-runner))
    (home-page "https://github.com/jerrypnz/major-mode-hydra.el")
    (synopsis "Major mode keybindings managed by Hydra")
    (description
     "This package offers an hydra-based method of managing major
mode-specific key bindings.  It is intended for use as a library only; see
package @code{emacs-major-mode-hydra} for a user-friendly interface.")
    (license license:gpl3+)))

(define-public emacs-interleave
  (package
    (name "emacs-interleave")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/rudolfochrist/interleave")
         (commit (string-append "interleave-" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0l5b681mrpk12lx5c16m7kc13p29z6zismwg1llsjg7cdmrmsrcb"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command
           #~(list "emacs" "--no-init-file" "--batch"
                   "--eval=(require 'ecukes)" "--eval=(ecukes)")))
    (native-inputs (list emacs-ecukes))
    (home-page "https://github.com/rudolfochrist/interleave")
    (synopsis "Emacs minor mode to interleave notes and text books")
    (description
     "Interleave is a minor mode that presents a document viewer side
by side to an Org buffer with your notes relevant to the current page.")
    (license license:gpl3+)))

(define-public emacs-major-mode-hydra
  (package
    (inherit emacs-pretty-hydra)
    (name "emacs-major-mode-hydra")
    (propagated-inputs
     (list emacs-dash emacs-pretty-hydra))
    (arguments
     `(#:exclude (cons "^pretty-hydra\\.el" %default-exclude)))
    (synopsis "Create nice-looking hydras")
    (description
     "This package provides the macro @code{pretty-hydra-define} to define
hydras with one column per group of heads.")))

(define-public emacs-ivy
  (package
    (name "emacs-ivy")
    (version "0.15.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/ivy-" version ".tar"))
       (sha256
        (base32 "12ni3n8h7316hv4nrx4kbjah58n8zdxkf1v8fi0w39da1aqn3r0p"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list))
    (home-page "https://github.com/abo-abo/swiper")
    (synopsis "Incremental vertical completion for Emacs")
    (description
     "This package provides @code{ivy-read} as an alternative to
@code{completing-read} and similar functions.  No attempt is made to determine
the best candidate.  Instead, the user can navigate candidates with
@code{ivy-next-line} and @code{ivy-previous-line}.  The matching is done by
splitting the input text by spaces and re-building it into a regular
expression.")
    (license license:gpl3+)))

(define-public emacs-counsel
  (package
    (name "emacs-counsel")
    (version "0.15.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "counsel-" version ".tar"))
       (sha256
        (base32 "1sgaph2wb4mkxlfq6448i1kymaxhs7h37nrn7vzbp9fhik634rhc"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-ivy emacs-swiper))
    (home-page "https://github.com/abo-abo/swiper")
    (synopsis "Various completion functions using Ivy")
    (description
     "Just call one of the interactive functions in a file to complete the
corresponding thing using Ivy.

The following completions are currently available:
@itemize
@item Symbol completion for Elisp, Common Lisp, Python, Clojure, C, C++.
@item Describe functions for Elisp: function, variable, library, command,
@item bindings, theme.
@item Navigation functions: imenu, ace-line, semantic, outline.
@item Git utilities: git-files, git-grep, git-log, git-stash, git-checkout.
@item Grep utilities: grep, ag, pt, recoll, ack, rg.
@item System utilities: process list, rhythmbox, linux-app.
@item Many more.
@end itemize")
    (license license:gpl3+)))

(define-public emacs-sway
  (let ((commit "84eae5e16a643eb00b0a422ded751cceb17cc8f0")
        (revision "0"))
    (package
      (name "emacs-sway")
      (version (git-version "0.7" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/thblt/sway.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "194plzc6rg7a5j3f68say0znix34yp8421cdlkwnw345czh52mjn"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/thblt/sway.el")
      (synopsis "Communication with the Sway window manager")
      (description
       "This is a basic library to control the Sway window manager from Emacs.
Its main use case is in combination with popup managers like Shackle, to
use frames instead of windows while still giving focus to existing frames
instead of duplicating them.")
      (license license:gpl3+))))

(define-public emacs-sweet-theme
  (let ((commit "78f741806ecebe01224bf54d09ad80e306652508")
        (revision "0"))
    (package
      (name "emacs-sweet-theme")
      (version (git-version "4" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/2bruh4me/sweet-theme")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1yqz15l6xa1vkll4gaa3jpr30vq3yjgbgadjilsmz5p8mblawhyx"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/2bruh4me/sweet-theme")
      (synopsis "Emacs theme inspired by the GTK theme Sweet")
      (description "Sweet is an Emacs theme inspired by the GTK theme with
the same name.")
      (license license:gpl3+))))

(define-public emacs-swiper
  (package
    (name "emacs-swiper")
    (version "0.15.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/swiper-" version ".tar"))
       (sha256
        (base32 "0m70jgcdsbrj6i5b1srrdgzkwavzi098532fv6vi2051nl42snvz"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-ivy))
    (home-page "https://github.com/abo-abo/swiper")
    (synopsis "Isearch with an overview")
    (description
     "This package gives an overview of the current regex search candidates.
The search regex can be split into groups with a space.  Each group is
highlighted with a different face.

It can double as a quick `regex-builder', although only single lines will be
matched.")
    (license license:gpl3+)))

(define-public emacs-ivy-xref
  (let ((commit "1a35fc0f070388701b05b0a455cbe262e924d547")
        (revision "1"))
    (package
      (name "emacs-ivy-xref")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alexmurray/ivy-xref")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0d71nm9d9ajp5i6dnl8h1hw9jqp8gd1ajgninb1h13i80rplzl9k"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ivy))
      (home-page "https://github.com/alexmurray/ivy-xref")
      (synopsis "Ivy interface for @code{xref}")
      (description "This package provides an Ivy interface for selecting from
@code{xref} results.")
      (license license:gpl3))))

(define-public emacs-ivy-pass
  (let ((commit "5b523de1151f2109fdd6a8114d0af12eef83d3c5")
        (revision "1"))
    (package
      (name "emacs-ivy-pass")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ecraven/ivy-pass")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "18crb4zh2pjf0cmv3b913m9vfng27girjwfqc3mk7vqd1r5a49yk"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ivy emacs-password-store))
      (home-page "https://github.com/ecraven/ivy-pass")
      (synopsis "Ivy interface to the @code{pass} password store")
      (description
       "This package provides an Ivy interface for working with the password
store (@code{pass}) in Emacs.")
      (license license:gpl3))))

(define-public emacs-ivy-yasnippet
  (let ((commit "32580b4fd23ebf9ca7dde96704f7d53df6e253cd")
        (revision "2"))
    (package
      (name "emacs-ivy-yasnippet")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mkcms/ivy-yasnippet")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1wfg6mmd5gl1qgvayyzpxlkh9s7jgn20y8l1vh1zbj1czvv51xp8"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ivy emacs-yasnippet emacs-dash))
      (home-page "https://github.com/mkcms/ivy-yasnippet")
      (synopsis "Preview @code{yasnippets} with @code{ivy}")
      (description "This package allows you to select @code{yasnippet}
snippets using @code{ivy} completion.  When current selection changes in the
minibuffer, the snippet contents are temporarily expanded in the buffer.  To
use it, call @code{M-x ivy-yasnippet} (but make sure you have enabled
@code{yas-minor-mode} first).")
      (license license:gpl3+))))

(define-public emacs-ivy-rich
  (package
    (name "emacs-ivy-rich")
    (version "0.1.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Yevgnen/ivy-rich")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0fn3v6221750hk6hs5rrrr894d53ibgj3yza9rismmj321xwbrh5"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-ivy))
    (home-page "https://github.com/Yevgnen/ivy-rich")
    (synopsis "More friendly interface for @code{ivy}")
    (description
     "This package extends Ivy by showing more information in the minibuffer
for each candidate.  It adds columns showing buffer modes, file sizes,
docstrings, etc.  If @code{emacs-all-the-icons} is installed, it can show
icons as well.")
    (license license:gpl3+)))

(define-public emacs-avy
  (package
    (name "emacs-avy")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/abo-abo/avy")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "09qdni1s74i5pv8741szl5g4ynj8fxn0x65qmwa9rmfkbimnc0fs"))))
    (build-system emacs-build-system)
    (arguments
     `(#:test-command '("make" "test")))
    (home-page "https://github.com/abo-abo/avy")
    (synopsis "Tree-based completion for Emacs")
    (description
     "This package provides a generic completion method based on building a
balanced decision tree with each candidate being a leaf.  To traverse the tree
from the root to a desired leaf, typically a sequence of @code{read-key} can
be used.

In order for @code{read-key} to make sense, the tree needs to be visualized
appropriately, with a character at each branch node.  So this completion
method works only for things that you can see on your screen, all at once,
such as the positions of characters, words, line beginnings, links, or
windows.")
    (license license:gpl3+)))

(define-public emacs-ace-window
  (package
    (name "emacs-ace-window")
    (version "0.10.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/abo-abo/ace-window")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0f3r40d5yxp2pm2j0nn86s29nqj8py0jxjbj50v4ci3hsd92d8jl"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-avy))
    (native-inputs (list emacs-ert-runner))
    (home-page "https://github.com/abo-abo/ace-window")
    (synopsis "Quickly switch windows in Emacs")
    (description
     "@code{ace-window} is meant to replace @code{other-window}.
In fact, when there are only two windows present, @code{other-window} is
called.  If there are more, each window will have its first character
highlighted.  Pressing that character will switch to that window.")
    (license license:gpl3+)))

(define-public emacs-windsize
  ;; There is no proper release.  The base version is extracted from the
  ;; "Version" keyword in the main file.
  (let ((revision "1")
        (commit "62c2846bbe95b0a73e996c75e4a644d05f57aaaa"))
    (package
      (name "emacs-windsize")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/grammati/windsize")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "13kfrmv3vmkfanxv9nym5v43hx5p7xkgqmx65zcxh4gcbaham1mi"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/grammati/windsize")
      (synopsis "Easy resizing of Emacs windows")
      (description
       "This package allows moving the borders of the active window
with the arrow keys.  It prefers to move the right or bottom border when
possible, and falls back to moving the left or top border otherwise.")
      (license license:gpl3+))))

(define-public emacs-window-purpose
  (package
    (name "emacs-window-purpose")
    (version "1.8.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bmag/emacs-purpose.git")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1cw513mh3gyl21qpmgwqjgpi8kwddmd4n69l4ax5a5pv3vvwrcx9"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "sh" "-c" "ert-runner < test/user-input.txt")
           #:include #~(list "^[^/]+.el$"
                             "^[^/]+.el.in$"
                             "^dir$"
                             "^[^/]+.info$"
                             "^[^/]+.texi$"
                             "^[^/]+.texinfo$"
                             "^doc/dir$"
                             "^doc/[^/]+.info$"
                             "^doc/[^/]+.texi$"
                             "^doc/[^/]+.texinfo$"
                             "^layouts$")
           #:exclude #~(list "^.dir-locals.el$"
                             "^test.el$"
                             "^tests.el$"
                             "^[^/]+-test.el$"
                             "^[^/]+-tests.el$")
           #:phases #~(modify-phases %standard-phases
                        (add-after 'unpack 'number-tests
                          (lambda _
                            (ert-number-tests "test/switch-test.el"
                                              "purpose-test-temp-actions-1")))
                        (add-after 'unpack 'create-test-file
                          (lambda _
                            (call-with-output-file "test/user-input.txt"
                              (const #t)))))))
    (propagated-inputs
     (list emacs-let-alist emacs-imenu-list))
    (native-inputs (list emacs-ert-runner))
    (home-page "https://github.com/bmag/emacs-purpose")
    (synopsis "Purpose-based window management for Emacs")
    (description "Purpose is a package that introduces the concept of a
\"purpose\" for windows and buffers, and then helps you maintain a robust
window layout easily.")
    (license license:gpl3+)))

(define-public emacs-iedit
  (package
    (name "emacs-iedit")
    (version "0.9.9.9.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/victorhge/iedit")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "02jdyrff88n69d4kadjaac38gwcv28lhiqqa93rlqzdvmgqsbwak"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command
           #~(list "emacs" "--batch" "-l" "iedit-tests.el"
                   "-f" "ert-run-tests-batch-and-exit")
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'skip-failing-test
                 (lambda _
                   (substitute* "iedit-tests.el"
                     (("\\(ert-deftest iedit-batch-compile-test .*" all)
                      (string-append all "(skip-unless nil)"))))))))
    (home-page "https://www.emacswiki.org/emacs/Iedit")
    (synopsis "Edit multiple regions in the same way simultaneously")
    (description
     "This package is an Emacs minor mode and allows you to edit one
occurrence of some text in a buffer (possibly narrowed) or region, and
simultaneously have other occurrences edited in the same way.

You can also use Iedit mode as a quick way to temporarily show only the buffer
lines that match the current text being edited.  This gives you the effect of
a temporary @code{keep-lines} or @code{occur}.")
    (license license:gpl3+)))

(define-public emacs-zop-to-char
  (package
    (name "emacs-zop-to-char")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/thierryvolpiatto/zop-to-char")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14waf3g7b92k3qd5088w4pn0wcspxjfkbswlzf7nnkjliw1yh0kf"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/thierryvolpiatto/zop-to-char")
    (synopsis "Visual zap-to-char command for Emacs")
    (description
     "This package provides a visual zap-to-char command for Emacs.")
    (license license:gpl3+)))

(define-public emacs-zoutline
  (package
    (name "emacs-zoutline")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/abo-abo/zoutline")
             (commit version)))
       (sha256
        (base32
         "1w0zh6vs7klgivq5r030a82mcfg1zwic4x3fimyiqyg5n8p67hyx"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (home-page "https://github.com/abo-abo/zoutline")
    (synopsis "Simple outline library")
    (description
     "This library provides helpers for outlines.  Outlines allow users to
navigate code in a tree-like fashion.")
    (license license:gpl3+)))

(define-public emacs-lispy
  ;; No release since May 2019 and tons of fixes have landed on master.
  ;; https://github.com/abo-abo/lispy/issues/513
  (let ((commit "df1b7e614fb0f73646755343e8892ddda310f427"))
    (package
      (name "emacs-lispy")
      (version (git-version "0.27.0" "3" commit))
      (home-page "https://github.com/abo-abo/lispy")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/abo-abo/lispy")
                      (commit commit)))
                (sha256
                 (base32
                  "02pmnn9cqslahnvllqzawp2j5icmb3wgkrk4qrfxjds68jg7pjj4"))
                (patches
                 (search-patches "emacs-lispy-fix-thread-last-test.patch"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ace-window emacs-hydra emacs-iedit emacs-swiper
             emacs-zoutline))
      (native-inputs
       (list which emacs-clojure-mode emacs-undercover))
      (arguments
       (list
        #:include #~(cons* "^lispy-clojure\\.clj$"
                           "^lispy-python\\.py$"
                           %default-include)
        #:phases
        ;; XXX: Some failing tests
        #~(modify-phases %standard-phases
            (add-before 'check 'make-test-writable
              (lambda _
                (make-file-writable "lispy-test.el")))
            (add-before 'check 'fix-tests
              (lambda _
                (ert-number-tests "lispy-test.el" "lispy-outline-add")
                (ert-number-tests "lispy-test.el" "lispy-ace-subword")
                (emacs-batch-edit-file "lispy-test.el"
                  `(progn
                    (dolist (test '("lispy-eval-python-str"
                                    "lispy-outline-add-0"
                                    "lispy--clojure-dot-object"
                                    "lispy--pretty-args"
                                    "lispy-flatten"
                                    "lispy-move-up"
                                    "lispy-move-down" ; XXX: defined twice?
                                    "lispy-move-down"))
                            (goto-char (point-min))
                            (re-search-forward
                             (concat "ert-deftest " test))
                            (beginning-of-line)
                            (kill-sexp))
                    (basic-save-buffer))))))
        ;; Set BEMACS to prevent the test suite from loading straight.el.
        #:test-command #~(list "make" "test" "BEMACS=emacs -batch")))
      (synopsis "Modal S-expression editing")
      (description
       "Due to the structure of Lisp syntax it's very rare for the programmer
to want to insert characters right before \"(\" or right after \")\".  Thus
unprefixed printable characters can be used to call commands when the point is
at one of these special locations.  Lispy provides unprefixed keybindings for
S-expression editing when point is at the beginning or end of an
S-expression.")
      (license license:gpl3+))))

(define-public emacs-lispyville
  (let ((commit "89316f01822b2135e52ca27fd308d207ef618052")
        (revision "3"))
    (package
      (name "emacs-lispyville")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/noctuid/lispyville")
      (source (origin
                (method git-fetch)
                (uri (git-reference (url home-page) (commit commit)))
                (sha256
                 (base32
                  "10k3hxxpx2v2k4dyad7j1bzmr1q7rzvv4y6c67pa9zcqyaw8m91v"))
                (file-name (git-file-name name version))))
      (propagated-inputs
       (list emacs-evil emacs-lispy))
      (native-inputs (list emacs-ert-runner))
      (build-system emacs-build-system)
      (arguments (list #:test-command #~(list "ert-runner" "tests")))
      (synopsis "Minor mode for integrating Evil with lispy")
      (description
       "LispyVille's main purpose is to provide a Lisp editing environment
suited towards Evil users.  It can serve as a minimal layer on top of lispy
for better integration with Evil, but it does not require the use of lispy’s
keybinding style.  The provided commands allow for editing Lisp in normal
state and will work even without lispy being enabled.")
      (license license:gpl3+))))

(define-public emacs-function-args
  ;; The latest release is from August 21, 2017.
  (let ((commit "beba049751fed78666c87bd146a6f1cf149bb819")
        (revision "0"))
    (package
      (name "emacs-function-args")
      (version (git-version "0.6.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/abo-abo/function-args")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1j92ll2afvcp891fxra3sawxg000cs3ra01wxksiil2dg5zpzzkn"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ; XXX: tests need a TTY?
      (propagated-inputs (list emacs-ivy))
      (home-page "https://github.com/abo-abo/function-args")
      (synopsis "C/C++ completion for GNU Emacs")
      (description
       "This package provides a way of showing an inline arguments hint for
the C/C++ function at point.")
      (license license:gpl3+))))

(define-public emacs-lpy
  ;; There is no proper release/tag.
  (let ((commit "fa95b11e1023704510cc7dd2897bf8bcc3027cbb")
        (revision "6"))
    (package
      (name "emacs-lpy")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/abo-abo/lpy")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "18kx2mfmxy8s8csnp0iaiirl2z9baicq9f2w7rxlgkxww5511v7d"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-function-args emacs-lispy emacs-zoutline))
      (home-page "https://github.com/abo-abo/lpy")
      (synopsis "Modal editing for Python")
      (description
       "This package provides a minor mode for Python that binds useful
commands to unprefixed keys, such as @code{j} or @code{e}, under certain
circumstances, and leaves the keys untouched outside of those situations,
allowing unprefixed keys to insert their respective characters as expected.")
      (license license:gpl3+))))

(define-public emacs-claude-code
  ;; There is no proper release/tag.
  (let ((commit "becece683bcf60f7b150a87a30ef14885dcf8ce3")
        (revision "0"))
    (package
      (name "emacs-claude-code")
      (version (git-version "0.4.5" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/stevemolitor/claude-code.el")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0z77nxazkw08pmqam2z27a56s9nyp72a1vvc0ba3vgcwfkjx0v81"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:include #~(cons "^bin\\/" %default-include)
        #:tests? #f)) ; There are no tests.
      (propagated-inputs
       (list emacs-transient
             emacs-inheritenv))
      (home-page "https://github.com/stevemolitor/claude-code.el")
      (synopsis "Claude Code Emacs integration")
      (description
       "This package provides convenient ways to interact with Claude from
within Emacs, including sending commands, toggling the Claude window, and
accessing slash commands.")
      (license license:asl2.0))))

(define-public emacs-claude-code-ide
  ;; Upstream does not make versioned releases.
  (let ((commit "c5e2de1a343bc6c0444789e0a99ad822cd56cfbe"))
    (package
      (name "emacs-claude-code-ide")
      (version "0.2.5")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/manzaltu/claude-code-ide.el")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "17rha7rvv72r75lpa2hz65mphrjrzkfn4pz3xf9lfvivg7fc7n0d"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'set-home
              (lambda _
                (setenv "HOME" (getenv "TMPDIR")))))
        #:test-command
        #~(list "emacs" "-batch"
                "-L" "."
                "-l" "ert"
                "-l" "claude-code-ide-tests.el"
                "--eval"
                ;; Exclude failing test (uncaught throw)
                (string-append
                 "(ert-run-tests-batch-and-exit "
                 "'(not claude-code-ide-mcp-server-test-ws-send-fix))"))))
      (propagated-inputs
       (list emacs-flycheck
             emacs-transient
             emacs-vterm
             emacs-web-server
             emacs-websocket))
      (home-page "https://github.com/manzaltu/claude-code-ide.el")
      (synopsis "Claude Code IDE integration for Emacs")
      (description
       "This package provides native integration with Claude Code
@acronym{CLI, command-line interface} through the @acronym{MCP, Model
Context Protocol}.  It creates a bidirectional bridge between Claude and
Emacs, enabling Claude to leverage Emacs features including @acronym{LSP,
Language Server Protocol}, project management, tree-sitter, and custom
Elisp functions.  Features include automatic project detection and
session management, terminal integration with @code{vterm} or @code{eat},
diagnostic integration with Flycheck and Flymake, advanced diff viewing
with ediff, and an extensible MCP tools server for accessing Emacs
commands such as xref and imenu.")
      (license license:gpl3+))))

(define-public emacs-clojure-mode
  (package
    (name "emacs-clojure-mode")
    (version "5.20.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clojure-emacs/clojure-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "123x8rwv4nb30h1rz7avshvr00xjfjjsmzrqsyxhgdm3f0rhac5w"))))
    (build-system emacs-build-system)
    (native-inputs
     (list emacs-buttercup emacs-dash emacs-paredit emacs-s))
    (arguments
     `(#:test-command '("buttercup")))
    (home-page "https://github.com/clojure-emacs/clojure-mode")
    (synopsis "Major mode for Clojure code")
    (description
     "This Emacs package provides font-lock, indentation, navigation and basic
refactoring for the @uref{http://clojure.org, Clojure programming language}.
It is recommended to use @code{clojure-mode} with Paredit or Smartparens.")
    (license license:gpl3+)))

(define-public emacs-clj-deps-new
  (let ((commit "e1cf65eb040f5a2e9a3eca970044ba71cc53fb27")
        (revision "0"))
    (package
      (name "emacs-clj-deps-new")
      (version (git-version "1.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jpe90/emacs-clj-deps-new")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "03db3l5klc20wgdaj44scgjfi2mha85bip07ls6pwbi039ls7rvx"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/jpe90/emacs-clj-deps-new")
      (synopsis "Create Clojure projects from templates")
      (description
       "This is a small wrapper around the
@uref{https://github.com/seancorfield/deps-new, deps-new} and
@uref{https://github.com/seancorfield/clj-new, clj-new} tools for creating
Clojure projects from templates.")
      (license license:gpl3+))))

(define-public emacs-clj-refactor
  (package
    (name "emacs-clj-refactor")
    (version "3.12.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clojure-emacs/clj-refactor.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mha1wqn5hd9g8y0fp35qkhlnxlrwli62x7mbifman279h16gaml"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "buttercup" "-L" "." "-L" "test")
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'enable-lexical-binding
                 (lambda _
                   (emacs-batch-edit-file "tests/unit-test.el"
                     '(progn
                       (add-file-local-variable-prop-line 'lexical-binding t)
                       (basic-save-buffer))))))))
    (propagated-inputs
     (list emacs-cider
           emacs-clojure-mode
           emacs-hydra
           emacs-inflections
           emacs-multiple-cursors
           emacs-paredit
           emacs-parseedn
           emacs-yasnippet))
    (native-inputs (list emacs-buttercup))
    (home-page "https://github.com/clojure-emacs/clj-refactor.el")
    (synopsis "Powerful refactoring functionality for Clojure projects")
    (description "This Emacs package complements the refactoring functionality
you'd find in Clojure mode and CIDER.")
    (license license:gpl3+)))

(define-public emacs-clojure-snippets
  ;; Use latest commit (2018) since latest tagged release is too old and is
  ;; missing important changes.
  (let ((version "1.0.1")
        (revision "0")
        (commit "6068dca90467a0f4ebc2cd39338a173d6f5ddc04"))
    (package
      (name "emacs-clojure-snippets")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mpenet/clojure-snippets")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0vvadcydpsz4b17dlm1jd4fbddzfqibh3mlzv3k4gvp67vv10cqy"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include (cons* "^.*\\/" %default-include)))
      (propagated-inputs
       (list emacs-yasnippet))
      (home-page "https://github.com/mpenet/clojure-snippets")
      (synopsis "Yasnippets for Clojure")
      (description
       "This package provides Yasnippets snippets for Clojure.")
      (license license:gpl3+))))

(define-public emacs-anakondo
  ;; This particular commit introduces bug fixes above latest release.
  (let ((version "0.2.1")
        (revision "0")
        (commit "c48518560815c49d8d78fb9069906d17e883385e"))
    (package
      (name "emacs-anakondo")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/didibus/anakondo")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1fzsqd150gpmrj8kz3zy9cd78x9vank7ra720mljhyf04z0h1mj6"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/didibus/anakondo")
      (synopsis "Clojure[Script] editing facilities based on clj-kondo")
      (description
       "This package makes use of clj-kondo's analysis data to provide code
editing facilities related to Clojure, ClojureScript and cljc source.")
      (license license:expat))))

(define-public emacs-epl
  (package
    (name "emacs-epl")
    (version "0.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cask/epl")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0d3z5z90ln8ipk1yds1n1p8fj9yyh2kpspqjs7agl38indra3nb4"))))
    (build-system emacs-build-system)
    (native-inputs (list emacs-ert-runner))
    (home-page "https://github.com/cask/epl")
    (synopsis "Emacs Package Library")
    (description
     "A package management library for Emacs, based on @code{package.el}.

The purpose of this library is to wrap all the quirks and hassle of
@code{package.el} into a sane API.")
    (license license:gpl3+)))

(define-public emacs-counsel-jq
  (package
    (name "emacs-counsel-jq")
    (version "1.1")
    (home-page "https://github.com/200ok-ch/counsel-jq")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit "aaf33fc2447096cd0d03b77395fe2a95c9fe1481")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10rz0qm8a4bl0m86kx19zq8lri047p4sxqyny08bgm9pbam0wvwn"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-swiper jq))
    (synopsis "Live preview @code{jq} queries using counsel")
    (description
     "This Emacs package provides the ability to live preview @code{jq}
queries using counsel.")
    (license license:gpl3+)))

(define-public emacs-counsel-notmuch
  ;; Upstream provides no release.  Extract version for main file.
  (let ((commit "a4a1562935e4180c42524c51609d1283e9be0688")
        (revision "0"))
    (package
      (name "emacs-counsel-notmuch")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fuxialexander/counsel-notmuch")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "01k1321d961kc2i660a5595bqk0d85f16snsxngsn5si6y83kqr7"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'locate-notmuch
             (lambda* (#:key inputs #:allow-other-keys)
               (make-file-writable "counsel-notmuch.el")
               (emacs-substitute-variables "counsel-notmuch.el"
                 ("counsel-notmuch-path"
                  (search-input-file inputs "/bin/notmuch"))))))))
      (inputs
       (list emacs-counsel notmuch emacs-s))
      (propagated-inputs
       (list emacs-notmuch))
      (home-page "https://github.com/fuxialexander/counsel-notmuch")
      (synopsis "Search emails in Notmuch asynchronously with Ivy")
      (description
       "This package can be used to search emails in Notmuch
asynchronously, with Counsel and Ivy.  Simply call
@code{counsel-notmuch} and input your Notmuch query.")
      (license license:gpl3+))))

(define-public emacs-counsel-projectile
  (package
    (name "emacs-counsel-projectile")
    (version "0.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ericdanan/counsel-projectile")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vp39r5njfzchkqv9g0w77whazp070anh9gmbkp3z4n3xxbik27f"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs
     (list emacs-counsel emacs-projectile))
    (home-page "https://github.com/ericdanan/counsel-projectile")
    (synopsis "Enhance Projectile with Ivy")
    (description
     "This package uses Ivy to provide additional actions for Projectile
commands and replacements for existing functions.")
    (license license:gpl3+)))

(define-public emacs-qml-mode
  (package
    (name "emacs-qml-mode")
    (version "0.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/coldnew/qml-mode")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1sncsvzjfgmhp4m8w5jd4y51k24n2jfpgvrkd64wlhhzbj3wb947"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/coldnew/qml-mode/")
    (synopsis "Qt Modeling Language (QML) mode for Emacs")
    (description "This package provides the @code{qml-mode} major Emacs mode
for editing source files written in the Qt Modeling Language (QML) user
interface markup language.  It provides syntax highlighting and basic
navigation commands.  @code{qml-mode} is derived from code{js-mode}, the Emacs
builtin JavaScript mode.")
    (license license:gpl2+)))

(define-public emacs-qt-pro-mode
  (package
    (name "emacs-qt-pro-mode")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/qt-pro-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1xprnq3y74hfm931a80wcj35faafzqc59j3vavx95wzv4z4yfgdm"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "make" "test")))
    (home-page "https://github.com/emacsorphanage/qt-pro-mode")
    (synopsis "Emacs major mode for Qt build-system files")
    (description
     "This package provides a major mode for editing Qt build-system files.")
    (license license:gpl2+)))

(define-public emacs-queue
  (package
    (name "emacs-queue")
    (version "0.2")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/queue-"
                                  version ".el"))
              (sha256
               (base32
                "0cx2848sqnnkkr4zisvqadzxngjyhmb36mh0q3if7q19yjjhmrkb"))))
    (build-system emacs-build-system)
    (home-page "https://www.dr-qubit.org/emacs_data-structures.html")
    (synopsis "Queue data structure for Emacs")
    (description
     "This Emacs library provides queue data structure.  These queues can be
used both as a first-in last-out (FILO) and as a first-in first-out (FIFO)
stack, i.e. elements can be added to the front or back of the queue, and can
be removed from the front.  This type of data structure is sometimes called an
\"output-restricted deque\".")
    (license license:gpl3+)))

(define-public emacs-quickrun
  (package
    (name "emacs-quickrun")
    (version "2.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/quickrun")
             (commit version)))
       (sha256
        (base32 "0a1n2v09h0n7d9p2izflqqang4ny0b46dlqvmxvkkik4bb6f4wcz"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments (list #:test-command
                     #~(list "emacs" "--batch" "-L" "."
                             "-l" "test/test-quickrun.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (native-inputs (list python-wrapper))
    (home-page "https://github.com/emacsorphanage/quickrun")
    (synopsis "Execute editing buffer and show its output quickly")
    (description
     "This package evaluates the content of a buffer, or region, and displays
the result.  Quickrun executes not only script languages (Perl, Ruby, Python
etc), but also compiling languages (C, C++, Go, Java etc) and markup
languages.")
    (license license:gpl3+)))

(define-public emacs-pkg-info
  (package
    (name "emacs-pkg-info")
    (version "0.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/lunaryorn/pkg-info.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0nk12dcppdyhav6m6yf7abpywyd7amxd4237zsfd32w4zxsx39k1"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; tests appear to require cask
    (propagated-inputs (list emacs-epl))
    (home-page "https://github.com/lunaryorn/pkg-info.el")
    (synopsis "Information about Emacs packages")
    (description
     "This library extracts information from the installed Emacs packages.")
    (license license:gpl3+)))

(define-public emacs-spinner
  (package
    (name "emacs-spinner")
    (version "1.7.4")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/spinner-"
                                  version ".tar"))
              (sha256
               (base32 "140kss25ijbwf8hzflbjz67ry76w2cyrh02axk95n6qcxv7jr7pv"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Malabarba/spinner.el")
    (synopsis "Emacs mode-line spinner for operations in progress")
    (description
     "This Emacs package adds spinners and progress-bars to the mode-line for
ongoing operations.")
    (license license:gpl3+)))

(define-public emacs-sparql-mode
  (package
    (name "emacs-sparql-mode")
    (version "4.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ljos/sparql-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hqp8r24wvzrkl630wbm0lynrcrnawv2yn2a3xgwqwwhwgva35rn"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f  ; XXX: Fails with wrong number of arguments.
           #:test-command #~(list "ert-runner")))
    (native-inputs
     (list emacs-ert-runner))
    (propagated-inputs
     (list emacs-company))
    (home-page "https://github.com/ljos/sparql-mode")
    (synopsis "SPARQL mode for Emacs")
    (description
     "This package is a major mode for Emacs that provides syntax highlighting
for SPARQL.  It can also execute queries against a SPARQL HTTP endpoint, such
as Fuseki or DBPedia.")
    (license license:gpl3+)))

(define-public emacs-sphinx-doc
  (let ((commit "1eda612a44ef027e5229895daa77db99a21b8801")
        (revision "1"))
    (package
      (name "emacs-sphinx-doc")
      (version (git-version "0.3.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/naiquevin/sphinx-doc.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0q72i95yx3xa57jlgr7dik6prf20hi8bp8xf3f5c6ificv7i5378"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "emacs" "-Q" "--batch"
                               "-l" "sphinx-doc-tests.el"
                               "-f" "ert-run-tests-batch-and-exit")))
      (propagated-inputs (list emacs-dash emacs-s))
      (home-page "https://github.com/naiquevin/sphinx-doc.el")
      (synopsis
       "Generate Sphinx friendly docstrings for Python functions in Emacs")
      (description
       "Sphinx Doc is an Emacs minor mode for inserting docstring skeletons
for Python functions and methods.  The structure of the docstring is as per
the equirement of the Sphinx documentation generator.")
      (license license:expat))))

(define-public emacs-better-defaults
  (package
    (name "emacs-better-defaults")
    (version "0.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~technomancy/better-defaults")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1rxznx2l0cdpiz8mad8s6q17m1fngpgb1cki7ch6yh18r3qz8ysr"))))
    (build-system emacs-build-system)
    (home-page "https://git.sr.ht/~technomancy/better-defaults")
    (synopsis "Better defaults for Emacs")
    (description
     "Better defaults attempts to address the most obvious deficiencies of the
Emacs default configuration in uncontroversial ways that nearly everyone can
agree upon.")
    (license license:gpl3+)))

(define-public emacs-uniquify-files
  (package
    (name "emacs-uniquify-files")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/uniquify-files-"
                           version ".tar"))
       (sha256
        (base32 "0xw2l49xhdy5qgwja8bkiq2ibdppl45xzqlr17z92l1vfq4akpzp"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/uniquify-files.html")
    (synopsis "Disambiguate files with the same basename")
    (description "This package helps differentiate files with the same name
but in different directories when displayed in Emacs buffers or completion
interfaces.

Generally, you probably want to use emacs' builtin uniquify instead--which
makes unique buffer names.  Only if you want to programmatically generate
unique file names you need this package here.")
    (license license:gpl3+)))

(define-public emacs-undohist
  (package
    (name "emacs-undohist")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/undohist")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1s1574q85lflik7w983v859qgxy1sn6i09hspa78smiawfva1855"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f))  ; No tests.
    (home-page "https://github.com/emacsorphanage/undohist")
    (synopsis "Save undo history between sessions")
    (description "This package allows persistent use of undo history for
individual file buffers.")
    (license license:gpl3+)))

(define-deprecated-package emacs-undohist-el
  emacs-undohist)

(define-public emacs-eprime
  (let ((commit "17a481af26496be91c07139a9bfc05cfe722506f"))
    (package
      (name "emacs-eprime")
      (version (string-append "20140513-" (string-take commit 7)))
      (source (origin
                (method url-fetch)
                (uri (string-append "https://raw.githubusercontent.com"
                                    "/AndrewHynes/eprime-mode/"
                                    commit "/eprime-mode.el"))
                (file-name (string-append "eprime-" version ".el"))
                (sha256
                 (base32
                  "0v68lggkyq7kbcr9zyi573m2g2x251xy3jadlaw8kx02l8krwq8d"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/AndrewHynes/eprime-mode")
      (synopsis "E-prime checking mode for Emacs")
      (description "This package provides an E-prime checking mode for Emacs
that highlights non-conforming text.  The subset of the English language called
E-Prime forbids the use of the \"to be\" form to strengthen your writing.")
      (license license:gpl3+))))

(define-public emacs-julia-mode
  (let ((commit "7fc071eb2c383d44be6d61ea6cef73b0cc8ef9b7")
        (revision "0"))
    (package
      (name "emacs-julia-mode")
      (version (git-version "1.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/JuliaEditorSupport/julia-emacs")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1dfls9ggn192xblfyjrbxi007hg4yd25s2cl8zh0v40akpqclhqc"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:include
        #~(cons* "^make-julia-latexsubs\\.jl" %default-include)
        #:test-command #~(list "emacs" "--batch"
                               "-l" "julia-mode-tests.el"
                               "-f" "ert-run-tests-batch-and-exit")))
      (home-page "https://github.com/JuliaEditorSupport/julia-emacs")
      (synopsis "Major mode for Julia")
      (description "This Emacs package provides a mode for the Julia
programming language.")
      (license license:expat))))

(define-public emacs-julia-repl
  (package
    (name "emacs-julia-repl")
    (version "1.3.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/tpapp/julia-repl")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "11vpqqnxqj9nxh8kccj4y6h3f8lib6jxnsk6vxc2j2fqw6alnafm"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tpapp/julia-repl")
    (synopsis "Minor mode for interacting with a Julia REPL")
    (description "This package provides a minor mode for interacting with a
Julia REPL running inside Emacs.  The julia process is started in an ANSI
terminal (term), which allows text formatting and colors, and interaction with
the help system and the debugger.  It is recommended that you use this minor
mode with the package emacs-julia-mode.")
    (license license:expat)))

(define-public emacs-julia-snail
  (package
    (name "emacs-julia-snail")
    (version "1.3.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/gcv/julia-snail")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1jphpyhg52c2gm8dkz42s3nsyb4b1bg9n4vx8qncn1flclczkgcz"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include
      #~(cons* "^JuliaSnail\\.jl" "extensions" %default-include)))
    (inputs
     (list emacs-dash emacs-s emacs-spinner emacs-xref))
    (propagated-inputs
     (list libvterm
           emacs-julia-mode             ;required by parser
           emacs-parsec                 ;required by parser
           emacs-popup
           emacs-vterm
           julia-tokenize
           julia-cstparser))
    (home-page "https://github.com/gcv/julia-snail")
    (synopsis "Development environment and REPL interaction package for Julia")
    (description "This package provides a development environment and REPL
interaction package for Julia in the spirit of Common Lisp’s SLIME and
Clojure’s CIDER.  It enables convenient and dynamic REPL-driven development.")
    (license license:gpl3)))

(define-public emacs-smex
  (package
    (name "emacs-smex")
    (version "3.0")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://raw.githubusercontent.com"
                                  "/nonsequitur/smex/" version "/smex.el"))
              (file-name (string-append "smex-" version ".el"))
              (sha256
               (base32
                "0ar310zx9k5y4i1vl2rawvi712xj9gx77160860jbs691p77cxqp"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/nonsequitur/smex/")
    (synopsis "M-x interface with Ido-style fuzzy matching")
    (description
     "Smex is a M-x enhancement for Emacs.  Built on top of Ido, it provides a
convenient interface to your recently and most frequently used commands.  And
to all the other commands, too.")
    (license license:gpl3+)))

(define-public emacs-js2-mode
  (package
    (name "emacs-js2-mode")
    (version "20231224")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mooz/js2-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "11ppp1m7hl4ii79zjw62bqvksyzh5xmp3q1qw21wlj2s47mkpm73"))))
    (build-system emacs-build-system)
    (arguments
     `(#:test-command '("make" "test")))
    (home-page "https://github.com/mooz/js2-mode/")
    (synopsis "Improved JavaScript editing mode for Emacs")
    (description
     "Js2 mode provides a JavaScript major mode for Emacs that is more
advanced than the built-in javascript-mode.  Features include accurate syntax
highlighting using a recursive-descent parser, on-the-fly reporting of syntax
errors and strict-mode warnings, smart line-wrapping within comments and
strings, and code folding.")
    (license license:gpl3+)))

(define-public emacs-js-comint
  (package
    (name "emacs-js-comint")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://stable.melpa.org/packages/"
                           "js-comint-" version ".el"))
       (sha256
        (base32 "1qin0hclm3ly62nl5ddiim64bcd2k74b1yqsqqc61cf9k2q8k287"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/redguardtoo/js-comint")
    (synopsis "Interacting with a JavaScript interpreter")
    (description
     "This program is a comint mode for Emacs which allows you to run a
compatible JavaScript REPL, such as node, SpiderMonkey or Rhino.
It also defines a few functions for sending JavaScript input to this REPL from
an Emacs buffer.")
    (license license:gpl3+)))

(define-public emacs-nodejs-repl
  (package
    (name "emacs-nodejs-repl")
    (version "0.2.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/abicky/nodejs-repl.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "06in0nnynrj6ciwbch4x8s65n6d750ikarvrdcjypi0cb0vscwsk"))))
    (build-system emacs-build-system)
    (inputs
     (list node-lts))
    (native-inputs
     (list emacs-ert-expectations))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-shell
            ;; Setting the SHELL environment variable is required for the tests
            ;; to find sh.
            (lambda _
              (setenv "SHELL" (which "sh"))))
          (add-after 'unpack 'configure
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((node (search-input-file inputs "/bin/node")))
                ;; Specify the absolute file names of the various
                ;; programs so that everything works out-of-the-box.
                (emacs-substitute-variables "nodejs-repl.el"
                  ("nodejs-repl-command" node))))))
      #:test-command #~(list "emacs" "-Q" "--batch"
                             "-L" "."
                             "-l" "test/test.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/abicky/nodejs-repl.el")
    (synopsis "Node.js REPL inside Emacs")
    (description
     "This program is derived from comint-mode and provides the following
features:

@itemize
@item TAB completion same as Node.js REPL
@item file name completion in string
@item incremental history search
@end itemize")
    (license license:gpl3+)))

(define-public emacs-typescript-mode
  (package
    (name "emacs-typescript-mode")
    (version "0.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ananthakumaran/typescript.el")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "186bpvqxx87kp3857mq0mzn1ddsvzmpijix810k6bdz8522x7zdw"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command
                     #~(list "emacs" "--batch" "-l" "typescript-mode-tests.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/ananthakumaran/typescript.el")
    (synopsis "Emacs major mode for editing Typescript code")
    (description
     "This is based on Karl Landstrom's barebones @code{typescript-mode}.
This is much more robust and works with @code{cc-mode}'s comment
filling (mostly).  The modifications to the original @code{javascript.el} mode
mainly consisted in replacing \"javascript\" with \"typescript\"

The main features of this Typescript mode are syntactic highlighting (enabled
with @code{font-lock-mode} or @code{global-font-lock-mode}), automatic
indentation and filling of comments and C preprocessor fontification.")
    (license license:gpl3+)))

(define-public emacs-tide
  (package
    (name "emacs-tide")
    (version "5.1.3")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ananthakumaran/tide")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "01chyr71b8893jxgf4wncpskfmg9iwfpcaxq0vfc6yaij46yfhky"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command
                     #~(list "emacs" "--batch" "-l" "tide-tests.el"
                             "-f" "ert-run-tests-batch-and-exit")
                     #:phases
                     #~(modify-phases %standard-phases
                         (add-before 'check 'set-home
                           (lambda _
                             (setenv "HOME" (getenv "TMPDIR"))))
                         (add-before 'check 'skip-package-refresh
                           (lambda _
                             (emacs-batch-edit-file "tide-tests.el"
                               '(progn (search-forward "dolist (p")
                                       (beginning-of-line)
                                       (kill-sexp)
                                       (basic-save-buffer)))))
                         (add-before 'check 'skip-failing-tests
                           (lambda _
                             (substitute* "tide-tests.el"
                               (("tide-list-servers/.*" all)
                                (string-append all " (skip-unless nil)"))))))))
    (propagated-inputs
     (list emacs-dash emacs-flycheck emacs-s emacs-typescript-mode))
    (native-inputs (list node))
    (home-page "https://github.com/ananthakumaran/tide")
    (synopsis "Typescript IDE for Emacs")
    (description
     "Tide is an Interactive Development Environment (IDE) for Emacs which
provides the following features:

@itemize
@item ElDoc
@item Auto complete
@item Flycheck
@item Jump to definition, Jump to type definition
@item Find occurrences
@item Rename symbol
@item Imenu
@item Compile On Save
@item Highlight Identifiers
@item Code Fixes
@item Code Refactor
@item Organize Imports
@end itemize")
    (license license:gpl3+)))

(define-public emacs-tinysegmenter
  (let ((commit "872134704bd25c13a4c59552433da4c6881b5230"))
    (package
      (name "emacs-tinysegmenter")
      (version "0.1")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/myuhe/tinysegmenter.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1n8cn6mr26hgmsm2mkbj5gs6dv61d0pap8ija4g0n1vsibfhzd8j"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/myuhe/tinysegmenter.el")
      (synopsis "Compact Japanese tokenizer in Emacs Lisp")
      (description
       "This package provides functions for tokenizing Japanese text in
Emacs buffers.")
      (license license:bsd-3))))

(define-public emacs-markdown-mode
  (package
    (name "emacs-markdown-mode")
    (version "2.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jrblevin/markdown-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1w6y18bg0fpvb5xwr827ynzbj0f0nh3dms3n0xq6hg38dcyly46b"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "make" "test")
                     #:tests? #f))      ; XXX: 5 unexpected results
    (home-page "https://jblevins.org/projects/markdown-mode/")
    (synopsis "Emacs Major mode for Markdown files")
    (description
     "Markdown-mode is a major mode for editing Markdown-formatted text files
in Emacs.")
    (license license:gpl3+)))

(define-public emacs-evil-markdown
  (let ((commit "685d7fbb81bc02fa32779d2a127b99a0c8c7436b")
        (revision "2"))
    (package
      (name "emacs-evil-markdown")
      (version (git-version "0.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Somelauw/evil-markdown")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1z1sjn6dcqv8mmkh6nfcwhnql2z6xr9yx3hs77bfxj79pf3c466p"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-evil emacs-markdown-mode))
      (home-page "https://github.com/Somelauw/evil-markdown/")
      (synopsis "Evil keybindings for @code{markdown-mode}")
      (description
       "This package provides custom text objects and bindings for
@code{markdown-mode}.")
      (license license:gpl3+))))

(define-public emacs-edit-indirect
  (package
    (name "emacs-edit-indirect")
    (version "0.1.13")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Fanael/edit-indirect")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1qjnhhf8c00hnn0b8icq71l73fa1blxfx9q0ahnvpd32wh6i0bql"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Fanael/edit-indirect")
    (synopsis "Edit regions in separate buffers")
    (description "This package allows you to edit regions in separate buffers,
like @code{org-edit-src-code} but for arbitrary regions.")
    (license license:bsd-2)))

(define-public emacs-projectile
  (package
    (name "emacs-projectile")
    (version "2.9.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bbatsov/projectile")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "15wc2ivmac0kgbdgsaaxngmcffgd3227zsb4n7inhn14cqwr6qxd"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "buttercup" "-L" ".")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'fix-failing-test
            (lambda _
              (substitute* "test/projectile-test.el"
                (("user-emacs-directory") "\".\"")))))))
    (native-inputs
     (list emacs-buttercup))
    (propagated-inputs
     (list emacs-dash emacs-pkg-info))
    (home-page "https://github.com/bbatsov/projectile")
    (synopsis "Manage and navigate projects in Emacs easily")
    (description
     "This library provides easy project management and navigation.  The
concept of a project is pretty basic: just a folder containing special file.
Currently Git, Mercurial and Bazaar repositories are considered projects by
default.  If you want to mark a folder manually as a project just create an
empty @file{.projectile} file in it.")
    (license license:gpl3+)))

(define-public emacs-skeletor
  (let ((commit "47c5b761aee8452716c97a69949ac2f675affe13")
        (revision "1"))
    (package
      (name "emacs-skeletor")
      (version (git-version "1.6.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/chrisbarrett/skeletor.el")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "12bdgykfh4mwsqdazxjdvha62h3q3v33159ypy91f6x59y01fi0n"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:include #~(cons "^project-skeletons\\/" %default-include)
        #:phases
        #~(modify-phases %standard-phases
            ;; XXX: one failing test involving initializing a git repo.
            (add-before 'check 'remove-git-test
              (lambda _
                (emacs-batch-edit-file "test/skeletor-test.el"
                  `(progn
                    (goto-char (point-min))
                    (re-search-forward "ert-deftest initialises-git-repo")
                    (beginning-of-line)
                    (kill-sexp)
                    (basic-save-buffer))))))))
      (native-inputs
       (list emacs-ert-runner))
      (propagated-inputs
       (list emacs-dash emacs-f emacs-let-alist emacs-s))
      (home-page "https://github.com/chrisbarrett/skeletor.el")
      (synopsis "Project skeletons for Emacs")
      (description "This package provides project templates and automates the
mundane parts of setting up a new project, such as version control, licenses,
and tooling.")
      (license license:gpl3+))))

(define-public emacs-elfeed
  (package
    (name "emacs-elfeed")
    (version "3.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/skeeto/elfeed")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0yq93abyadzrmcd40pi06wcr4jg9ddhlz2phg0wjypprqvv4q49z"))))
    (build-system emacs-build-system)
    (arguments
     `(#:test-command '("make" "test")
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-program-calls
           (lambda* (#:key inputs #:allow-other-keys)
             (emacs-substitute-variables "elfeed-curl.el"
               ("elfeed-curl-program-name"
                (search-input-file inputs "/bin/curl"))))))))
    (inputs
     (list curl))
    (home-page "https://github.com/skeeto/elfeed")
    (synopsis "Atom/RSS feed reader for Emacs")
    (description
     "Elfeed is an extensible web feed reader for Emacs, supporting both Atom
and RSS, with a user interface inspired by notmuch.")
    (license license:gpl3+)))

(define-public emacs-elfeed-goodies
  (let ((commit "544ef42ead011d960a0ad1c1d34df5d222461a6b"))
    (package
      (name "emacs-elfeed-goodies")
      (version commit)
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jeetelongname/elfeed-goodies")
               (commit version)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "147pwqx2maf430qhigzfd6lqk7a5sbrydf9a4c5bvsw8jv7wzb6l"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list
        emacs-elfeed
        emacs-popwin
        emacs-powerline
        emacs-link-hint))
      (home-page "https://github.com/jeetelongname/elfeed-goodies")
      (synopsis
       "Various bits and pieces to enhance the Elfeed user experience")
      (description
       "This package enhances the vanilla Elfeed user experience with:
@itemize @bullet
@item
An adaptive, powerline-based header for the @code{*elfeed-search*} and
@code{*elfeed-entry*} buffers, with a matching entry format.

@item
Split pane setup.

@item
A function to toggle the @code{*elfeed-log*} buffer in a popup window.
@end itemize")
      (license license:gpl3+))))

(define-public emacs-elfeed-org
  (let ((commit "1197cf29f6604e572ec604874a8f50b58081176a")
        (version "20250104.0")
        (revision "0"))
    (package
      (name "emacs-elfeed-org")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/remyhonig/elfeed-org")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0giwnzlqk2s5hb6fs8a0l4dxcmn2fvkngpj1fayzwj0qnvds1kri"))))
      (build-system emacs-build-system)
      (arguments
       `(#:test-command '("ert-runner" "-L" "org-mode/lisp")))
      (propagated-inputs (list emacs-elfeed))
      (native-inputs (list emacs-ert-runner emacs-xtest))
      (home-page "https://github.com/remyhonig/elfeed-org")
      (synopsis "Configure Elfeed with an Org-mode file")
      (description
       "@code{elfeed-org} lets you manage your Elfeed subscriptions
in Org-mode.  Maintaining tags for all RSS feeds is cumbersome using
the regular flat list, where there is no hierarchy and tag names are
duplicated a lot.  Org-mode makes the book keeping of tags and feeds
much easier.")
      (license license:gpl3+))))

(define-public emacs-elfeed-protocol
  (package
    (name "emacs-elfeed-protocol")
    (version "0.9.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fasheng/elfeed-protocol")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1n5bns7181j6n603a626jsv26v06s3wm86ml7vixlp234p0frypp"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-elfeed))
    (native-inputs (list emacs-ert-runner))
    (home-page "https://github.com/fasheng/elfeed-protocol")
    (synopsis "Fever/NewsBlur/ownCloud/tt-RSS protocols for Elfeed")
    (description
     "Elfeed-protocol provides extra protocols to make self-hosting RSS
readers like Fever, NewsBlur, ownCloud News and Tiny TIny RSS work
with Elfeed.")
    (license license:gpl3+)))

(define-public emacs-elfeed-score
  (package
    (name "emacs-elfeed-score")
    (version "1.2.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sp1ff/elfeed-score")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14f5m81ik8w3yi2dc3mff88v63abkcjs5fcp5d2zbg35adbqrb7l"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #false                   ;FIXME: How to run tests properly?
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'make-info
            (lambda _
              (with-directory-excursion "doc"
                (invoke "makeinfo" "--no-split"
                        "-o" "elfeed-score.info" "elfeed-score.texi")))))))
    (native-inputs
     (list texinfo))
    (propagated-inputs
     (list emacs-elfeed))
    (home-page "https://github.com/sp1ff/elfeed-score")
    (synopsis "Gnus-style scoring for Elfeed")
    (description
     "Elfeed-score is an add-on for Elfeed, an RSS reader for Emacs.  It
brings Gnus-style scoring to your RSS feeds.  Elfeed, by default, displays
feed entries by date.  This package allows you to setup rules for assigning
numeric scores to entries, and sorting entries with higher scores ahead of
those with lower, regardless of date.  The idea is to prioritize content
important to you.")
    (license license:gpl3+)))

(define-public emacs-elfeed-tube
  (package
    (name "emacs-elfeed-tube")
    (version "0.15")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/karthink/elfeed-tube")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vsrsnvz0ysd36a99zk7n2giv0gxznlnls8zq6lcc0hwqw78i5cq"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-elfeed emacs-aio emacs-mpv))
    (home-page "https://github.com/karthink/elfeed-tube/")
    (synopsis "YouTube integration for Elfeed")
    (description
     "@code{elfeed-tube} is an extension for Elfeed that enhances Youtube RSS
feed subscriptions.")
    (license license:unlicense)))

(define-public emacs-el-x
  (package
    (name "emacs-el-x")
    (version "0.3.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/sigma/el-x")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1i6j44ssxm1xdg0mf91nh1lnprwsaxsx8vsrf720nan7mfr283h5"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #f                      ; no tests
       #:phases
       (modify-phases %standard-phases
         ;; Move the source files to the top level, which is included in
         ;; the EMACSLOADPATH.
         (add-after 'unpack 'move-source-files
           (lambda _
             (let ((el-files (find-files "./lisp" ".*\\.el$")))
               (for-each (lambda (f)
                           (rename-file f (basename f)))
                         el-files))
             #t)))))
    (home-page "https://github.com/sigma/el-x")
    (synopsis "Emacs Lisp extensions")
    (description "@command{emacs-el-x} defines the @code{dflet} macro to
provide the historic behavior of @code{flet}, as well as
@code{declare-function} stub for older Emacs.")
    (license license:gpl2+)))

(define-public emacs-epithet
  ;; No tags.
  (let ((commit "cc42338376c2c58da561214c554be8e8856f6a2b"))
    (package
      (name "emacs-epithet")
      (version "0.1")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/oantolin/epithet")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "06irgshgcgmm09nswrny8mam6l660ai71rgn0l3rmyp9li8n97j0"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/oantolin/epithet")
      (synopsis "Rename Emacs buffers with descriptive names")
      (description
       "This package provides a function---@code{epithet-rename-buffer}---to
rename the current buffer with a descriptive name.  The name suggestion is
governed by the @code{epithet-suggesters} hook variable: each hook should
return either a name suggestion or @code{nil}, they are called in turn and the
first non-nil suggestion is taken.")
      (license license:gpl3+))))

(define-public emacs-eterm-256color
  (package
    (name "emacs-eterm-256color")
    (version "0.3.13")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/dieggsy/eterm-256color")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0ysxblc90kjcz84siprnyxwh94scflivqbxylzkvjm7hbx93rsh1"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-f emacs-xterm-color))
    (home-page "https://github.com/dieggsy/eterm-256color")
    (synopsis
     "Customizable 256 colors for Emacs @code{term} and @code{ansi-term}")
    (description "This package uses @code{emacs-xterm-color} to add
customizable 256 color support to @code{term} and @code{ansi-term}.")
    (license license:gpl3+)))

(define-public emacs-centaur-tabs
  (package
    (name "emacs-centaur-tabs")
    (version "3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ema2159/centaur-tabs")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1z7b3s29xb0n25bfbbm1wrcap9dvig5zi5fcnvlyrl9si9565948"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-all-the-icons emacs-powerline))
    (home-page "https://github.com/ema2159/centaur-tabs")
    (synopsis "Modern looking tabs plugin for Emacs")
    (description
     "This projects aims to become an aesthetic, functional and
efficient tabs plugin for Emacs with a lot of customization options.")
    (license license:gpl3+)))

(define-public emacs-org-remark
  (package
    (name "emacs-org-remark")
    (version "1.3.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/nobiot/org-remark")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0npw7niqjhxspnaw4f2wnrjz5wr7qfkib0865hcri3aq8ccd46xr"))
              (modules '((guix build utils)))
              (snippet #~(begin (for-each delete-file-recursively
                                          '("docs/resources" "resources"))))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f))  ; No proper tests.
    (propagated-inputs (list emacs-org))
    (home-page "https://nobiot.github.io/org-remark/")
    (synopsis "Highlight & annotate text using Org mode")
    (description "Org-remark lets you highlight and annotate text files,
websites, EPUB books and Info documentation using Org mode.

Features:

@itemize
@item Highlight and annotate any text file.  The highlights and notes are kept
in an Org file as the plain text database.  This lets you easily manage your
marginal notes and use the built-in Org facilities on them – e.g. create a
sparse tree based on the category of the notes
@item Create your your own highlighter pens with different colors, type (e.g.
underline, squiggle, etc. optionally with Org’s category for search and filter
on your highlights and notes)
@item Have the same highlighting and annotating functionality for websites
(when browsing with EWW), EPUB books with @code{nov.el}, Info documentation
@end itemize")
    (license license:gpl3+)))

(define-public emacs-mocker
  (package
    (name "emacs-mocker")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sigma/mocker.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1dc514cqbfmg33sb3j90s5jmw6jnm3wzvs0zhw3maz13bp7w6z48"))))
    (build-system emacs-build-system)
    (native-inputs
     (list emacs-ert-runner))
    (propagated-inputs
     (list emacs-el-x))
    (home-page "https://github.com/sigma/mocker.el")
    (synopsis "Mocking framework for Emacs Lisp")
    (description "Mocker.el is a framework for writing tests in Emacs Lisp.
It uses regular Lisp rather than a domain specific language (DSL), which
maximizes flexibility (at the expense of conciseness).")
    (license license:gpl2+)))

(define-public emacs-find-file-in-project
  (package
    (name "emacs-find-file-in-project")
    (version "6.2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/technomancy/find-file-in-project")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0crr4597naffxa4cli6flzjrz3x73nml50kgv6x2i5bspxjzkv27"))))
    (build-system emacs-build-system)
    (arguments
     `(#:test-command '("ert-runner" "tests")))
    (native-inputs
     (list emacs-ert-runner))
    (home-page "https://github.com/technomancy/find-file-in-project")
    (synopsis "File/directory finder for Emacs")
    (description "@code{find-file-in-project} finds files or
directories quickly in the current project.  The project root is detected
automatically when Git, Subversion or Mercurial are used.  It also provides
functions to assist in reviewing changes on files.")
    (license license:gpl3+)))

(define-public emacs-popwin
  ;; Last release is from 2020.
  (let ((commit "213e462c4aa23c9aa78105b78a8fb27c8bbc3c9c")
        (revision "0"))
    (package
      (name "emacs-popwin")
      (version (git-version "1.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/emacsorphanage/popwin")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "13gn96h0f4z9g1dg65hiq24srjq75jnndd0khzx8j2xv7d5fmmyk"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command
        #~(list "emacs" "-Q" "-batch"
                "-l" "test/popwin-test.el"
                "-f" "ert-run-tests-batch-and-exit")
        #:phases
        #~(modify-phases %standard-phases
            ;; Ran 42 tests, 33 results as expected, 0 unexpected, 9 skipped.
            (add-before 'check 'skip-tests
              (lambda _
                (emacs-batch-edit-file "test/popwin-test.el"
                  '(progn
                    (let ((tests (list "find-file-interactively"
                                       "display-buffer-interactively"
                                       "find-file-tail-interactively"
                                       "popup-at-bottom-with-three-columes"
                                       "popup-at-top-with-three-columes.*"
                                       "popup-buffer-interactively"
                                       "popup-buffer-tail-interactively"
                                       "popwin-side-window"
                                       "popup-from-minibuffer")))
                      (dolist (test tests)
                              (save-excursion
                               (re-search-forward (format "%s ()" test))
                               (insert "\n(skip-unless nil)")))
                      (basic-save-buffer)))))))))
      (native-inputs
       (list emacs-ert-runner))
      (home-page "https://github.com/emacsorphanage/popwin")
      (synopsis "Popup window manager for Emacs")
      (description
       "This package provides utilities for treating certain windows as
@dfn{pop up windows}, which close automatically when quitting a command or
selecting another window.")
      (license license:gpl3+))))

(define-public emacs-pyvenv
  (package
    (name "emacs-pyvenv")
    (version "1.21")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jorgenschaefer/pyvenv")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "055sgk8zf4wb5nqsf3qasf5gg861zlb1831733f1qcrd2ij5gzxx"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; This phase incorrectly attempts to substitute "activate" and fails
         ;; doing so.
         (delete 'patch-el-files)
         (add-after 'unpack 'ert-number-tests
             (lambda _
               (ert-number-tests "test/pyvenv-hook-dir-test.el"
                                 "pyvenv-hook-dir"))))))
    (native-inputs
     (list emacs-ert-runner emacs-mocker))
    (home-page "https://github.com/jorgenschaefer/pyvenv")
    (synopsis "Python virtual environment interface for Emacs")
    (description "pyvenv.el is a minor mode to support using Python virtual
environments (virtualenv) inside Emacs.")
    (license license:gpl3+)))

(define-public emacs-highlight-indent-guides
  (let ((version "0.8.5") ; from package metadata
        (revision "0")
        (commit "c2c9de4d01edfb89609c91d4d7f1d81312015a2c"))
    (package
      (name "emacs-highlight-indent-guides")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/DarthFennec/highlight-indent-guides")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "10chvqnmdmkx6i9sigqframr85ziyafiz44glwhvhjajfkv42ad2"))))
      (build-system emacs-build-system)
      (home-page
       "https://github.com/DarthFennec/highlight-indent-guides")
      (synopsis "Minor mode to highlight indentation")
      (description
       "This package provides a minor mode to highlight indentation levels via
font-lock.  Indent widths are dynamically discovered, which means this
correctly highlights in any mode, regardless of indent width, even in
languages with non-uniform indentation such as Haskell.  This mode works
properly around hard tabs and mixed indentation and behaves well in large
buffers.")
      (license license:expat))))

(define-public emacs-highlight-indentation
  ;; Last release version is from 2015.
  (let ((commit "d03803f2c06749c430443a3d24e039cbafc9c58f")
        (revision "1"))
    (package
      (name "emacs-highlight-indentation")
      (version (git-version "0.7.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/antonj/Highlight-Indentation-for-Emacs")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1jq0gf4kcx9hvrw40rnw5c2qynjpjw1vsjbi2i4lqjbsnfnxn4wz"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/antonj/Highlight-Indentation-for-Emacs/")
      (synopsis "Highlighting indentation for Emacs")
      (description "This package provides two minor modes to highlight
indentation guides in Emacs:

@enumerate
@item @code{highlight-indentation-mode}, which displays guidelines
  indentation (space indentation only).
@item @code{highlight-indentation-current-column-mode}, which displays
  guidelines for the current-point indentation (space indentation only).
@end enumerate")
      (license license:gpl2+))))

(define-public emacs-elpy
  ;; Using the latest commit fixes outstanding bugs such as the following:
  ;; https://github.com/jorgenschaefer/elpy/issues/1824
  ;; https://github.com/jorgenschaefer/elpy/pull/1951
  ;; https://github.com/jorgenschaefer/elpy/issues/1940.
  (let ((commit "0b381f55969438ab2ccc2d1a1614045fcf7c9545")
        (revision "3"))
    (package
      (name "emacs-elpy")
      (version (git-version "1.35.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jorgenschaefer/elpy")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0398zwzq5c33fi8icyy2x50q7rs819i5xkpmhbfm1s34m6prv46a"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include (cons* "^elpy/[^/]+\\.py$" "^snippets\\/" %default-include)
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'disable-broken-tests
             ;; Some tests are known to have problems with Python 3.9; disable
             ;; them (see:
             ;; https://github.com/jorgenschaefer/elpy/issues/1856).
             ;; Aggressively remove the modules where failing tests were
             ;; discovered, as they are similar and fail in a nondeterministic
             ;; way.
             (lambda _
               (with-directory-excursion "test"
                 (for-each delete-file
                           (append (find-files "." "elpy-refactor")
                                   (find-files "." "elpy-multiedit")
                                   (find-files "." "elpy-pdb")
                                   (find-files "." "elpy-promise")))
                 ;; These test fail since upgrading Emacs from version 27 to
                 ;; 28.1 (see:
                 ;; https://github.com/jorgenschaefer/elpy/issues/1982).
                 (delete-file "elpy-project-find-git-root-test.el")
                 (substitute* "elpy-company-backend-test.el"
                   (("elpy-company-backend-should-add-shell-candidates.*" all)
                    (string-append all "  :expected-result :failed\n")))
                 (substitute* "elpy-eldoc-documentation-test.el"
                   (("elpy-eldoc-documentation-should-show-object-onelinedoc.*" all)
                    (string-append all "  :expected-result :failed\n")))
                 (substitute* "elpy-shell-send-file-test.el"
                   (("elpy-shell-send-file-should-accept-large-strings.*" all)
                    (string-append all "  :expected-result :failed\n")))
                 (substitute* "elpy-shell-echo-inputs-and-outputs-test.el"
                   (("elpy-shell-should-echo-outputs.*" all)
                    (string-append all "  :expected-result :failed\n")))
                 ;; This test started failing with Emacs 29 (see:
                 ;; https://github.com/jorgenschaefer/elpy/issues/2032).
                 (substitute* "elpy-folding-fold-blocks-test.el"
                   (("elpy-fold-at-point-should-NOT-fold-and-unfold-functions\
-from-after.*" all)
                    (string-append all "  :expected-result :failed\n")))
                 ;; These tests started failing with Emacs 30.
                 ;; (TODO: report upstream)
                 (substitute* "elpy-company-backend-test.el"
                   (("elpy-company-backend-should-find-.*-prefix-string.*" all)
                    (string-append all "  :expected-result :failed\n")))
                 (substitute* "elpy-format-code-test.el"
                   (("elpy-should-format-code-with-default-formatter.*" all)
                    (string-append all "  :expected-result :failed\n"))))))
           ;; The default environment of the RPC uses Virtualenv to install
           ;; Python dependencies from PyPI.  We don't want/need this in Guix.
           (add-before 'check 'do-not-use-virtualenv
             (lambda _
               (setenv "ELPY_TEST_DONT_USE_VIRTUALENV" "1")
               (substitute* "elpy-rpc.el"
                 (("defcustom elpy-rpc-virtualenv-path 'default")
                  "defcustom elpy-rpc-virtualenv-path 'system"))))
           (add-before 'check 'build-doc
             (lambda _
               (with-directory-excursion "docs"
                 (invoke "make" "info" "man"))
               ;; Move .info file at the root so that it can installed by the
               ;; 'move-doc phase.
               (rename-file "docs/_build/texinfo/Elpy.info" "Elpy.info")))
           (add-after 'build-doc 'install-manpage
             (lambda* (#:key outputs #:allow-other-keys)
               (let* ((out  (assoc-ref outputs "out"))
                      (man1 (string-append out "/share/man/man1")))
                 (mkdir-p man1)
                 (copy-file "docs/_build/man/elpy.1"
                            (string-append man1 "/elpy.1"))))))))
      (propagated-inputs
       (list emacs-company
             emacs-find-file-in-project
             emacs-highlight-indentation
             emacs-yasnippet
             emacs-pyvenv
             emacs-s
             ;; The following are recommended Python dependencies that make
             ;; Elpy much more useful.  Installing these avoids Elpy prompting
             ;; to install them from PyPI using pip.
             python-autopep8
             python-black
             python-flake8
             python-jedi
             python-yapf))
      (native-inputs
       (list emacs-ert-runner
             emacs-f
             python-wrapper
             ;; For documentation.
             python-sphinx
             texinfo))
      (home-page "https://github.com/jorgenschaefer/elpy")
      (synopsis "Python development environment for Emacs")
      (description "Elpy brings powerful Python editing to Emacs.  It combines
and configures a number of other packages written in Emacs Lisp as well as
Python, together offering features such as navigation, documentation,
completion, interactive development and more.")
      (license license:gpl3+))))

(define-public emacs-railscasts-theme
  (let ((commit "1340c3f6c2717761cab95617cf8dcbd962b1095b")
        (revision "0"))
    (package
      (name "emacs-railscasts-theme")
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/mikenichols/railscasts-theme")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "021x1l5kzsbm0qj5a3bngxa7ickm4lbwsdz81a2ks9pi1ivmw205"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/mikenichols/railscasts-theme")
      (synopsis "Railscasts is a color theme for Emacs")
      (description "Railscasts is a color theme for Emacs.")
      (license license:expat))))

(define-public emacs-rainbow-delimiters
  (package
    (name "emacs-rainbow-delimiters")
    (version "2.1.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/Fanael/rainbow-delimiters")
                    (commit version)))
              (file-name (git-file-name name version))
              ;; Fix tests for Emacs 29
              ;; https://github.com/Fanael/rainbow-delimiters/pull/78
              (modules '((guix build utils)))
              (snippet '(substitute* "rainbow-delimiters-test.el"
                          (("category c-type " all)
                           (string-append all "c-<>-c-types-set "))))
              (sha256
               (base32
                "179mzsd8nvlr0ym9zf9fgdngsgxj3kdgbjblynliirsyk05ssrwc"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Fanael/rainbow-delimiters")
    (arguments
     `(#:test-command '("emacs" "-Q" "-batch"
                        "-l" "rainbow-delimiters-test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (synopsis "Highlight brackets according to their depth")
    (description
     "Rainbow-delimiters is a \"rainbow parentheses\"-like mode for Emacs which
highlights parentheses, brackets, and braces according to their depth.  Each
successive level is highlighted in a different color, making it easy to spot
matching delimiters, orient yourself in the code, and tell which statements
are at a given level.")
    (license license:gpl3+)))

(define-public emacs-rainbow-identifiers
  (package
    (name "emacs-rainbow-identifiers")
    (version "0.2.2")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://raw.githubusercontent.com/Fanael"
                                  "/rainbow-identifiers/" version
                                  "/rainbow-identifiers.el"))
              (file-name (string-append "rainbow-identifiers-" version ".el"))
              (sha256
               (base32
                "0325abxj47k0g1i8nqrq70w2wr6060ckhhf92krv1s072b3jzm31"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Fanael/rainbow-identifiers")
    (synopsis "Highlight identifiers in source code")
    (description
     "Rainbow identifiers mode is an Emacs minor mode providing highlighting of
identifiers based on their names.  Each identifier gets a color based on a hash
of its name.")
    (license license:bsd-2)))

(define-public emacs-rainbow-mode
  (package
    (name "emacs-rainbow-mode")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "rainbow-mode-" version ".tar"))
       (sha256
        (base32 "04v73cm1cap19vwc8lqsw0rmfr9v7r3swc4wgxnk9dnzxi9j2527"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/rainbow-mode.html")
    (synopsis "Colorize color names in buffers")
    (description
     "This minor mode sets background color to strings that match color
names, e.g., @samp{#0000ff} is displayed in white with a blue background.")
    (license license:gpl3+)))

(define-public emacs-colorful-mode
  (package
    (name "emacs-colorful-mode")
    (version "1.2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/DevelopmentCool2449/colorful-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0d85wpvh56l8v0k8174g9dpniibc4k7j5nzszsk8ix1l42fsbi8i"))))
    (build-system emacs-build-system)
    ;; No automated tests.  The test directory contains sample files for
    ;; visual inspection.
    (arguments (list #:tests? #f))
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/DevelopmentCool2449/colorful-mode")
    (synopsis "Highlight color strings in buffers")
    (description
     "@code{colorful-mode} is a minor mode to highlight any color
format, such as hex codes or HTML color names, in buffers in real time.  It is
inspired by @code{rainbow-mode} but uses overlays instead of text properties
to support a different feature set.  It also supports conversion of color
strings between formats.")
    (license license:gpl3+)))

(define-public emacs-indent-bars
  (package
    (name "emacs-indent-bars")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/indent-bars-"
                           version ".tar"))
       (sha256
        (base32 "030haxxla7m6p2zks9g50dj8rr8grm67n2ig7zd3k20h1yrfm6q0"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ;No tests.
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/jdtsmith/indent-bars")
    (synopsis "Highlight indentation with bars")
    (description
     "Indent Bars highlights indentation with configurable vertical graphical
bars, using stipples.  The color and appearance (weight, pattern, position
within the character, zigzag, etc.) are all configurable.  Indent Bars works
in any mode using fixed tab or space-based indentation.  In the terminal (or
on request) it uses vertical bar characters instead of stipple patterns.
Optional Treesitter support is also available.")
    (license license:gpl3+)))

(define-public emacs-ryo-modal
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file.
  (let ((commit "a10f564474cc8fa28a74b04e3b15375315223c44")
        (revision "0"))
    (package
      (name "emacs-ryo-modal")
      (version (git-version "0.45" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Kungsgeten/ryo-modal")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0ypm1rnyry6hb4znb8sgwfi0la6q46ihm8k99kisk0mkgz7im93d"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/Kungsgeten/ryo-modal")
      (synopsis "Emacs minor mode for defining modal editing environments")
      (description "RYO modal provides a convenient way of defining modal
keybindings in Emacs, and does not come with any predefined bindings.")
      (license license:expat))))

(define-public emacs-valign
  (package
    (name "emacs-valign")
    (version "3.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/casouri/valign")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "11ks6z532i7vxi6f9g32zhimvikhsqywa2bd5fnnj2ahfx3msa95"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; "no effect on non-graphical display"
    (home-page "https://github.com/casouri/valign")
    (synopsis "Pixel-perfect visual alignment for Org and Markdown tables")
    (description
     "Valign provides visual alignment for Org mode, Markdown and Table.el
tables on GUI Emacs.  It can properly align tables containing variable-pitch
font, CJK characters and images.  Meanwhile, the text-based alignment
generated by Org mode (or Markdown mode) is left untouched.")
    (license license:gpl3+)))

(define-public emacs-visual-fill-column
  (package
    (name "emacs-visual-fill-column")
    (version "2.7.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/joostkremers/visual-fill-column")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1xsc49w5bkznaij2g9qdspv6gh83bxdhxb44s3wxvjrb8cyvy9sq"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "emacs" "--batch"
                             "-l" "test/visual-fill-column-test.el"
                             "-l" "test/test-helper.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://codeberg.org/joostkremers/visual-fill-column")
    (synopsis "Fill-column for visual-line-mode")
    (description
     "@code{visual-fill-column-mode} is a small Emacs minor mode that mimics
the effect of @code{fill-column} in @code{visual-line-mode}.  Instead of
wrapping lines at the window edge, which is the standard behaviour of
@code{visual-line-mode}, it wraps lines at @code{fill-column}.  If
@code{fill-column} is too large for the window, the text is wrapped at the
window edge.")
    (license license:gpl3+)))

(define-public emacs-visual-replace
  (let ((commit "17d693fd5b5ba0597230a3cdc78f5e6a285d4700")
        (revision "1"))
    (package
      (name "emacs-visual-replace")
      ;; XXX: when updating version, please ensure substitution in install-info
      ;; phase is still accurate.
      (version (git-version "1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/szermatt/visual-replace")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1jn94ivfalgiw6lfx8hqgq08qffrsq6lcydcxv6b41k04gkwm0yr"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases #~(modify-phases %standard-phases
                     (add-before 'check 'add-test-dir-to-emacs-load-path
                       (lambda _
                         (setenv "EMACSLOADPATH"
                                 (string-append (getcwd) "/test:"
                                                (getenv "EMACSLOADPATH")))))
                     (add-after 'install 'install-info
                       (lambda _
                         (let ((info-dir (string-append #$output "/share/info")))
                           (invoke "makeinfo" "--no-split"
                                   "-o" "visual-replace.info"
                                   "visual-replace.texi")
                           (install-file "./visual-replace.info" info-dir)))))
        #:test-command #~(list "eldev" "--use-emacsloadpath" "-dtTC" "test")))
      (native-inputs (list emacs-eldev emacs-turtles texinfo))
      (home-page "https://github.com/szermatt/visual-replace")
      (synopsis
       "Alternate interface for @code{replace-string} and @code{query-replace}")
      (description
       "@code{visual-replace} provides an alternate interface for search and
replacement commands that supports previews.  The interface also allows one to
edit both the query-text and its replacement in the same minibuffer prompt.
The interface covers the following commands:

@enumerate
@item @code{replace-string}
@item @code{replace-regexp}
@item @code{query-replace}
@item @code{query-replace-regexp}
@end enumerate")
      (license license:gpl3+))))

(define-public emacs-writeroom
  (package
    (name "emacs-writeroom")
    (version "3.11")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joostkremers/writeroom-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0y4jcja9kml1lq88r8b9myk39dgaggh7q7f3a43sj828hvzlccb7"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-visual-fill-column))
    (home-page "https://github.com/joostkremers/writeroom-mode")
    (synopsis "Distraction-free writing for Emacs")
    (description
     "This package defines a minor mode for distraction-free writing.  Some of
the default effects include entering fullscreen, deleting other windows of the
current frame, disabling the mode line, and adding margins to the buffer that
restrict the text width to 80 characters.")
    (license license:bsd-3)))

(define-public emacs-wucuo
  (package
    (name "emacs-wucuo")
    (version "0.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/redguardtoo/wucuo")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ivy3jaj9jml10jn020mma6x92j8q75q7wzbd23m9jl4w60bpqlq"))))
    (build-system emacs-build-system)
    (arguments
     `(#:test-command '("make" "test")
       #:phases (modify-phases %standard-phases
                  ;; The files auto-generated by `emacs-build-system' cause
                  ;; the Makefile target `compile' to fail (due to missing
                  ;; `lexical-binding' directives in the generated files).
                  ;; Since `emacs-build-system' already byte-compiles the
                  ;; source files (to `.elc' files), `make compile' is not
                  ;; needed anyway. Additionally, the `clean' target must be
                  ;; inhibited as it deletes all `.elc' files in the source
                  ;; directory, which, however, are part of the installation.
                  (add-after 'unpack 'patch-makefile
                    (lambda _
                      (substitute* "Makefile"
                        (("test: compile clean")
                         "test:"))))
                  ;; Set HOME, otherwise tests fail on loading aspell dict.
                  (add-before 'check 'set-home
                    (lambda _ (setenv "HOME" (getcwd)))))))
    (native-inputs
     ;; For tests.
     (list aspell aspell-dict-en))
    (home-page "https://github.com/redguardtoo/wucuo")
    (synopsis "Fast spell checker for camel case code or plain text")
    (description
     "Wucuo provides a spell checker on top of either Aspell or Hunspell, and
relies on Flyspell internally.  It operates on the current region or buffer,
a file, or a complete directory.")
    (license license:gpl3+)))

(define-public emacs-ido-completing-read+
  (package
    (name "emacs-ido-completing-read+")
    (version "4.14")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://raw.githubusercontent.com"
                                  "/DarwinAwardWinner/ido-ubiquitous/v"
                                  version "/ido-completing-read+.el"))
              (file-name (string-append "ido-completing-read+-" version ".el"))
              (sha256
               (base32
                "1wn94nkfv6qyyj6clvms7m7ncqf09bgszv67may530y75kylivav"))))
    (build-system emacs-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'disable-native-comp
                 (lambda _
                   ;; Native compilation of this package may crash your system,
                   ;; see <https://bugs.gnu.org/57878>.
                   (for-each
                    (lambda (file)
                      (make-file-writable file)
                      (emacs-batch-disable-compilation file #:native? #t))
                    (find-files "." "\\.el$")))))))
    (propagated-inputs
     (list emacs-s))
    (home-page "https://github.com/DarwinAwardWinner/ido-ubiquitous")
    (synopsis "Replacement for completing-read using ido")
    (description
     "The ido-completing-read+ function is a wrapper for ido-completing-read.
Importantly, it detects edge cases that ordinary ido cannot handle and either
adjusts them so ido can handle them, or else simply falls back to the standard
Emacs completion function instead.")
    (license license:gpl3+)))

(define-public emacs-ido-ubiquitous
  (package
    (name "emacs-ido-ubiquitous")
    (version "4.13")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://raw.githubusercontent.com"
                                  "/DarwinAwardWinner/ido-ubiquitous/v"
                                  version "/ido-ubiquitous.el"))
              (file-name (string-append "ido-ubiquitous-" version ".el"))
              (sha256
               (base32
                "08iwvqknicqlffda7ixwgzw7q9g2g4j4nsxdw6544r85vaysi4cc"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-ido-completing-read+))
    (home-page "https://github.com/DarwinAwardWinner/ido-ubiquitous")
    (synopsis "Use ido (nearly) everywhere")
    (description
     "Ido-ubiquitous enables ido-style completion for almost every function
that uses the standard completion function completing-read.")
  (license license:gpl3+)))

(define-public emacs-yaml
  (package
    (name "emacs-yaml")
    (version "1.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/zkry/yaml.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gp3076cf32vq8925c38xpd9cxnndlx5xazagh34irrq6dvb2y10"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "emacs" "--batch" "-Q"
                             "-l" "yaml.el"
                             "-l" "yaml-tests.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/zkry/yaml.el")
    (synopsis "YAML parser in Elisp")
    (description
     "@code{yaml.el} is a YAML parser written in Emacs Lisp without any
external dependencies.  It provides an interface similar to the Emacs JSON
parsing utility.")
    (license license:gpl3+)))

(define-public emacs-yaml-mode
  (package
    (name "emacs-yaml-mode")
    (version "0.0.16")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/yoshiki/yaml-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0jqg2hmh7qsgqywwd6fy3k8z8j45nqhpdzr3hw4hd5s2hry3zhg1"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "make" "test")))
    (home-page "https://github.com/yoshiki/yaml-mode")
    (synopsis "Major mode for editing YAML files")
    (description
     "Yaml mode is an Emacs major mode for editing files in the YAML data
serialization format.  As YAML and Python share the fact that indentation
determines structure, this mode provides indentation and indentation command
behavior very similar to that of Python mode.")
    (license license:gpl3+)))

(define-public emacs-yaml-pro
  (package
    (name "emacs-yaml-pro")
    (version "1.3.3")
    (home-page "https://github.com/zkry/yaml-pro")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1sipz42gb8pl8w9xci5m0kdz5dlinxj409hvyz173z3gzg7f4qr1"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-yaml))
    (synopsis "Tools for editing YAML leveraging tree-sitter/parser")
    (description "Leverages tree-sitter and provides fast and accurate
YAML parsing.")
    (license license:gpl3+)))

(define-public emacs-yari
  (let ((revision "0")
        (commit "de61285ceb21f56c29f4be12e2e65b2aa2bccf56"))
    (package
      (name "emacs-yari")
      (version (git-version "0.8" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hron/yari.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0sik21rifw0q1rw4wrffnnwynsmgrv6w323gz3fw89cz6n8kqsgn"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "ert-runner")
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'set-program-names
              (lambda* (#:key inputs #:allow-other-keys)
                (emacs-substitute-variables "yari.el"
                  ("yari-ri-program-name"
                   (search-input-file inputs "/bin/ri"))
                  ("yari-ruby-program-name"
                   (search-input-file inputs "/bin/ruby"))))))))
      (native-inputs (list emacs-ert-runner))
      (inputs (list ruby))
      (home-page "https://github.com/hron/yari.el")
      (synopsis "Yet Another RI interface for Emacs")
      (description
       "This package provides an Emacs frontend to Ruby's @code{ri}
documentation tool, and offers lookup and completion.  The main
function you should use as interface to @code{ri} is @samp{M-x yari}.")
      (license license:gpl3+))))

(define-public emacs-gitlab-ci-mode
  (package
    (name "emacs-gitlab-ci-mode")
    (version "20190824.12.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://gitlab.com/joewreschnig/gitlab-ci-mode")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "16fb4r3vq8xkzl911v7gaky95w1agfxjlpaxpjmidwx48rbcar59"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "ert-runner" "tests")))
    (native-inputs (list emacs-ert-runner))
    (propagated-inputs
     (list emacs-yaml-mode))
    (home-page "https://gitlab.com/joewreschnig/gitlab-ci-mode/")
    (synopsis "Emacs mode for editing GitLab CI files")
    (description
     "@code{gitlab-ci-mode} is an Emacs major mode for editing GitLab CI
files.  It provides syntax highlighting and completion for keywords and
special variables.  An interface to GitLab’s CI file linter is also provided
via @code{gitlab-ci-lint}.")
    (license license:gpl3+)))

(define-public emacs-gitlab-snip-helm
  (package
    (name "emacs-gitlab-snip-helm")
    (version "0.0.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://gitlab.com/sasanidas/gitlab-snip-helm.git")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1c5js19zyb1z61hapvbfcl5jhrjqij46cxldgqij6al0scw44dga"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-helm))
    (home-page "https://gitlab.com/sasanidas/gitlab-snip-helm/")
    (synopsis "GitLab snippet API interaction for Emacs")
    (description "This package provides GitLab snippet API interaction for
Emacs.")
    (license license:gpl3+)))

(define-public emacs-web-mode
  (package
    (name "emacs-web-mode")
    (version "17.3.20")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fxbois/web-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0lvixg4c5apwrpqljj11b3yrq8nklz4ky4njnh8y6h1j5bisx40p"))))
    (build-system emacs-build-system)
    (synopsis "Major mode for editing web templates")
    (description "Web mode is an Emacs major mode for editing web templates
aka HTML files embedding parts (CSS/JavaScript) and blocks (pre rendered by
client/server side engines).  Web mode is compatible with many template
engines: PHP, JSP, ASP, Django, Twig, Jinja, Mustache, ERB, FreeMarker,
Velocity, Cheetah, Smarty, CTemplate, Mustache, Blade, ErlyDTL, Go Template,
Dust.js, React/JSX, Angularjs, ejs, etc.")
    (home-page "https://web-mode.org/")
    (license license:gpl3+)))

(define-public emacs-templatel
  (package
    (name "emacs-templatel")
    (version "0.1.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clarete/templatel")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "03n7amd2mfr4jmc4s1ar5ckm86knr7qarxxlkdhbnw3svy5kbc57"))))
    (build-system emacs-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'number-tests
                 (lambda _
                   (ert-number-tests "templatel-tests.el"
                                     "render-expr-math-sub"))))))
    (home-page "https://clarete.li/templatel")
    (synopsis "Jinja inspired template language for Emacs Lisp")
    (description
     "templatel is the modern templating language.  It provides variable
substitution and control flow through a clean and powerful language inspired
by Python's Jinja.")
    (license license:gpl3+)))

(define-public emacs-wgrep
  (package
    (name "emacs-wgrep")
    (version "3.0.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/mhayashi1120/Emacs-wgrep")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "16qg5dpg7hms5dmh92ksnjahf6010pw97ggi7sb0mfafd6iwps0a"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "emacs" "--batch" "-Q"
                             "-l" "wgrep-test.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (native-inputs (list emacs-dash emacs-s))
    (home-page "https://github.com/mhayashi1120/Emacs-wgrep")
    (synopsis "Edit a grep buffer and apply those changes to the files")
    (description
     "Emacs wgrep allows you to edit a grep buffer and apply those changes
to the file buffer.  Several backends are supported beside the classic grep:
ack, ag, helm and pt.")
    (license license:gpl3+)))

(define-public emacs-helm
  (package
    (name "emacs-helm")
    (version "4.0.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-helm/helm")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0bcwy60wqfhxvxkhc0rl7bkasf0y1pm5kwg90qh9y23ri69z08zx"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no test suite
    (propagated-inputs
     (list emacs-async emacs-popup))
    (home-page "https://emacs-helm.github.io/helm/")
    (synopsis
     "Incremental completion and selection narrowing framework for Emacs")
    (description
     "Helm is an incremental completion and selection narrowing framework for
Emacs.  It will help steer you in the right direction when you're looking for
stuff in Emacs (like buffers, files, etc).")
    (license license:gpl3+)))

(define-public emacs-helm-org
  (let ((commit "8457e1e46227bf87726e05c42cec5a4b51c2ef7b")
        (revision "3"))
    (package
      (name "emacs-helm-org")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-helm/helm-org")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0kcjhwwi492n9m2w894hvdavfvhj45zygy7bwvx103wvpay5h6h6"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-helm))
      (home-page "https://github.com/emacs-helm/helm-org")
      (synopsis "Helm interface to the Silver Searcher")
      (description
       "This package provides a frontend for grepping tools like ag and ack,
as well as features for editing search results.")
      (license license:gpl3+))))

(define-public emacs-helm-swoop
  (package
    (name "emacs-helm-swoop")
    (version "3.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/helm-swoop")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1qjay0fvryxa8n1ws6r1by512p2fylb2nj7ycm1497fcalb0d706"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm))
    (native-inputs (list emacs-buttercup))
    (home-page "https://github.com/emacsorphanage/helm-swoop")
    (synopsis "Filter and jump to lines in an Emacs buffer using Helm")
    (description
     "This package builds on the Helm interface to provide several commands
for search-based navigation of buffers.")
    (license license:gpl2+)))

(define-public emacs-helm-ag
  (package
    (name "emacs-helm-ag")
    (version "0.64")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-helm-ag")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ml9yp3qaiwn7iixyxvsj3fxn7gw913qxisr47df57q4ka912law"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "emacs" "-Q" "--batch"
                                  "-l" "test/test-util.el"
                                  "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs
     (list emacs-helm))
    (home-page "https://github.com/syohex/emacs-helm-ag")
    (synopsis "Helm interface to the Silver Searcher")
    (description
     "This package provides a frontend for grepping tools like ag and ack,
as well as features for editing search results.")
    (license license:gpl3+)))

(define-public emacs-helm-projectile
  (package
    (name "emacs-helm-projectile")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bbatsov/helm-projectile")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "19zafd0l2mcd53q83bd2mxinadzsp90q5znfcm9fq0m88lpcmg94"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-helm emacs-projectile))
    (home-page "https://github.com/bbatsov/helm-projectile")
    (synopsis "Helm integration for Projectile")
    (description
     "This Emacs library provides a Helm interface for Projectile.")
    (license license:gpl3+)))

(define-public emacs-hexrgb
  (let ((commit "90e5f07f14bdb9966648977965094c75072691d4"))
    (package
      (name "emacs-hexrgb")
      (version "0")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/emacsmirror/hexrgb")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0y5l6hrzm5j2jfrm5jp5zrxhxgvf930m2k4nyvk0rllpx0i1271z"))))
      (build-system emacs-build-system)
      (home-page "https://www.emacswiki.org/emacs/hexrgb.el")
      (synopsis "Emacs functions to convert color formats")
      (description
       "HexRGB provides functions for converting between RGB (red, green, blue)
color components and HSV (hue, saturation, value) color components.  More
accurately, it converts Emacs color components (whole numbers from 0 through
65535), RGB and HSV floating-point components (0.0 through 1.0), Emacs
color-name strings (such as \"blue\") and hex RGB color strings (such as
\"#FC43A7912\").")
      (license license:gpl2+))))

(define-public emacs-taskrunner
  (let ((commit "3afd4a546d42339543d3d4e51b175fc3e82b3358")
        (revision "1"))
    (package
      (name "emacs-taskrunner")
      (version (git-version "0.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-taskrunner/emacs-taskrunner")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1lkdvmjn3alhqxq2i64sdr977sbw3g0b2670d9bwyzi67qh0jxrv"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-async emacs-projectile))
      (home-page "https://github.com/emacs-taskrunner/emacs-taskrunner")
      (synopsis "Retrieve tasks from various build systems and task-runners")
      (description "This package parses Makefiles and build-system files for
multiple project types.")
      (license license:gpl3+))))

(define-public emacs-tp
  (package
    (name "emacs-tp")
    (version "0.7")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://codeberg.org/martianh/tp.el")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1hv0j4dzwamhm2gp5123j415mq13347v5lsbxlrksha5nw9h7kds"))))
    (build-system emacs-build-system)
    (home-page "https://codeberg.org/martianh/tp.el")
    (synopsis "Utilities to create transient menus for POSTing to an API")
    (description
     "This package provides functions, classes and methods to make it easier
to create transient menus that send complex POST, PUT, or PATCH requests to
JSON APIs.")
    (license license:gpl3+)))


(define-public emacs-ivy-taskrunner
  (let ((commit "75d8d67cfe3c29663fe0f5508a887adf40ed5162")
        (revision "1"))
    (package
      (name "emacs-ivy-taskrunner")
      (version (git-version "0.9" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-taskrunner/ivy-taskrunner")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1wf4s4k0ap21f7g5w6128an8nsvbja7f5n889vcml5b6gjz058db"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-ivy emacs-taskrunner emacs-projectile))
      (home-page "https://github.com/emacs-taskrunner/ivy-taskrunner")
      (synopsis "Retrieve build-system tasks using Ivy")
      (description "This package provides an Ivy interface for selecting
Makefile targets.")
      (license license:gpl3+))))

(define-public emacs-helm-taskrunner
  (let ((commit "1910dac19cbc7bd4fd08b0faf9affd455339fbea")
        (revision "1"))
    (package
      (name "emacs-helm-taskrunner")
      (version (git-version "0.9" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-taskrunner/helm-taskrunner")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "182lmr858fx6rdhp1fy7kv8dvrhzcnxzwfck1q22s6xs8x85d5q7"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-helm emacs-taskrunner emacs-projectile))
      (home-page "https://github.com/emacs-taskrunner/helm-taskrunner")
      (synopsis "Retrieve build-system tasks using Helm")
      (description "This package provides a Helm interface for selecting
Makefile targets.")
      (license license:gpl3+))))

(define-public emacs-helm-make
  (let ((commit "ebd71e85046d59b37f6a96535e01993b6962c559")
        (revision "0"))
    (package
      (name "emacs-helm-make")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/abo-abo/helm-make")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "14jvhhw4chl94dgfwbyy7yirwchvcz5zrsgr9w6qy4z0fhqba41a"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ; no tests
      (propagated-inputs
       (list emacs-helm emacs-ivy emacs-projectile))
      (home-page "https://github.com/abo-abo/helm-make")
      (synopsis "Select a Makefile target with helm")
      (description "@code{helm-make} or @code{helm-make-projectile} will give
you a @code{helm} selection of directory Makefile's targets.  Selecting a
target will call @code{compile} on it.")
      (license license:gpl3+))))

(define-public emacs-islisp-mode
  (package
    (name "emacs-islisp-mode")
    (version "0.3.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://gitlab.com/sasanidas/islisp-mode")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1s6alrv1hfi1plj5lh826j0h71xvm2v092kglj3yvy34g73dgrna"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons "\\.lsp$" %default-include)
      #:phases
      #~(modify-phases %standard-phases
          ;; Move the extensions source files to the top level, which is
          ;; included in the EMACSLOADPATH.
          (add-after 'unpack 'move-source-files
            (lambda _
              (for-each (lambda (dir)
                          (let ((files (find-files dir "\\.(lsp|el)$")))
                            (for-each (lambda (f)
                                        (rename-file f (basename f)))
                                      files)))
                        '("advance" "implementations/easy-islisp"))))
          (add-after 'move-source-files 'patch-eisl-variables
            (lambda* (#:key inputs #:allow-other-keys)
              (emacs-substitute-variables "easy-islisp.el"
                ("easy-islisp-executable"
                 (search-input-file inputs "/bin/eisl"))
                ("easy-islisp-library-directory"
                 `(or (getenv "EASY_ISLISP")
                      ,(search-input-directory inputs "share/eisl/library")))))))))
    (native-inputs (list emacs-ert-runner))
    (inputs (list eisl))
    (home-page "https://gitlab.com/sasanidas/islisp-mode")
    (synopsis "ISLisp support for Emacs")
    (description
     "This package provides support for programming with ISLisp in Emacs.  It
features a major mode with syntax highlighting, symbol autocompletion and
documentation search, among other features.  It also includes an inferior mode
with REPL integration.  Currently it only supports the Easy ISLisp (eisl)
implementation.")
    (license license:gpl3+)))

(define-public emacs-cider
  (package
    (name "emacs-cider")
    (version "1.20.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clojure-emacs/cider")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08hd281ybskkhir170hr3xpga1b1hwpph7rd0fk6fvm0ngdgxazs"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons* "^lein\\.sh$" "^clojure\\.sh$" %default-include)
      #:exclude                        ;don't exclude 'cider-test.el'
      #~(list "^\\.dir-locals\\.el$" "^test/")
      #:test-command
      #~(list "eldev" "--use-emacsloadpath" "-dtT" "-p" "test")
      #:phases
      ;; XXX: file "test/cider-tests.el" contains a bogus "/bin/command"
      ;; string, and `patch-el-files' phase chokes on it (even though the
      ;; file is excluded from installation).  Remove the phase altogether
      ;; since there is no "/bin/executable" to replace in the code base
      ;; anyway.
      #~(modify-phases %standard-phases
          (delete 'patch-el-files)
          (add-before 'check 'skip-failing-tests
            (lambda _ ;; Require network.
              (delete-file "test/cider-jar-tests.el"))))))
    (native-inputs (list emacs-buttercup emacs-eldev))
    (propagated-inputs
     (list emacs-clojure-mode
           emacs-parseedn
           emacs-pkg-info
           emacs-queue
           emacs-sesman
           emacs-spinner))
    (home-page "https://cider.mx/")
    (synopsis "Clojure development environment for Emacs")
    (description
     "CIDER (Clojure Interactive Development Environment that Rocks) aims to
provide an interactive development experience similar to the one you'd get
when programming in Emacs Lisp, Common Lisp (with SLIME or Sly), Scheme (with
Geiser) and Smalltalk.

CIDER is the successor to the now deprecated combination of using SLIME +
swank-clojure for Clojure development.

There are plenty of differences between CIDER and SLIME, but the core ideas
are pretty much the same (and SLIME served as the principle inspiration for
CIDER).")
    (license license:gpl3+)))

(define-public emacs-cider-eval-sexp-fu
  (let ((commit "7fd229f1441356866aedba611fd0cf4e89b50921")) ;version bump
    (package
      (name "emacs-cider-eval-sexp-fu")
      (version "1.2")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/clojure-emacs/cider-eval-sexp-fu")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "01gky548v3758fyr317lkwsc9aacab6m9d9vk1mrr3qyvmciwd51"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-eval-sexp-fu))
      (home-page "https://github.com/clojure-emacs/cider-eval-sexp-fu")
      (synopsis "Eval Sexp-fu extensions for CIDER")
      (description
       "This package provides tiny improvements to expression evaluation,
e.g., the expression you've just evaluated would briefly flash and so on.")
      (license license:gpl3+))))

(define-public emacs-sly
  ;; Update together with sbcl-slynk.
  (let ((commit "9c43bf65b967e12cef1996f1af5f0671d8aecbf4")
        (revision "9"))
    ;; Versions are not always tagged.  Besides, latest master contains
    ;; important fixes.
    (package
      (name "emacs-sly")
      (version (git-version "1.0.43" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/joaotavora/sly")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "15nyr02ykkws4q79jcmxcawddg8sgq9v5l8k7jv7gg3hnpzxjlb2"))))
      (build-system emacs-build-system)
      (native-inputs
       (list sbcl texinfo))
      (arguments
       (list
        #:include #~(cons* "^contrib\\/" "^lib\\/" "^slynk\\/" %default-include)
        #:phases
        #~(modify-phases %standard-phases
            (delete 'make-autoloads) ; The package provides autoloads.
            (add-before 'install 'install-doc
              (lambda _
                (let* ((info-dir (string-append #$output "/share/info"))
                       (doc-dir (string-append #$output "/share/doc/"
                                               #$name "-" #$version))
                       (doc-files '( ;; "doc/sly-refcard.pdf" ; See sly-refcard.pdf below.
                                    "README.md" "NEWS.md" "PROBLEMS.md"
                                    "CONTRIBUTING.md")))
                  (with-directory-excursion "doc"
                    (substitute* "Makefile"
                      (("infodir=/usr/local/info")
                       (string-append "infodir=" info-dir))
                      ;; Don't rebuild contributors.texi since we are not in
                      ;; the git repo.
                      (("contributors.texi: Makefile texinfo-tabulate.awk")
                       "contributors.texi:"))
                    (invoke "make" "html/index.html")
                    (invoke "make" "sly.info")
                    ;; TODO: We need minimal texlive with "preprint" package
                    ;; (for fullpage.sty).  (invoke "make" "sly-refcard.pdf")
                    (install-file "sly.info" info-dir)
                    (copy-recursively "html" (string-append doc-dir "/html")))
                  (for-each (lambda (f)
                              (install-file f doc-dir)
                              (delete-file f))
                            doc-files)
                  (delete-file-recursively "doc"))))
            (add-before 'check 'patch-tests
              (lambda _
                (setenv "HOME" (dirname (getcwd)))
                (substitute* "test/sly-stickers-tests.el"
                  (("\
\\(define-sly-ert-test stickers-when-invalid-dont-stick .*" all)
                   (string-append all "  (skip-unless nil)\n"))))))))
      (home-page "https://github.com/joaotavora/sly")
      (synopsis "Sylvester the Cat's Common Lisp IDE")
      (description
       "SLY is Sylvester the Cat's Common Lisp IDE.  SLY is a fork of SLIME, and
contains the following improvements over it:

@enumerate
@item A full-featured REPL based on Emacs's @code{comint.el}.  Everything
can be copied to the REPL;
@item Stickers, or live code annotations that record values as code traverses them.
@item Flex-style completion out-of-the-box, using Emacs's completion API.
Company, Helm, and other supported natively, no plugin required;
@item An interactive Trace Dialog;
@item Multiple inspectors and multiple REPLs, with independent history.
@item Regexp-capable @code{M-x sly-apropos}.
@item Cleanly ASDF-loaded by default, including contribs, enabled out-of-the-box;
@item \"Presentations\" replaced by interactive backreferences, which
highlight the object and remain stable throughout the REPL session;
@end enumerate

SLY tracks SLIME's bugfixes and all its familiar features (debugger, inspector,
xref, etc.) are still available, but with better integration.")
      (license license:gpl3+))))

(define-public emacs-sly-quicklisp
  (let ((commit "01ebe3976a244309f2e277c09206831135a0b66c")
        (revision "1"))
    (package
      (name "emacs-sly-quicklisp")
      (version (git-version "0.0.0" revision commit))
      (home-page "https://github.com/joaotavora/sly-quicklisp")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1vfqmvayf35g6y3ljsm3rlzv5jm50qikhh4lv2zkkswj6gkkb1cv"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-sly))
      (arguments
       `(#:include (cons* "\\.lisp$" "\\.asd$" %default-include)
         #:phases
         ;; The package provides autoloads.
         (modify-phases %standard-phases
           (delete 'make-autoloads)
           (delete 'enable-autoloads-compilation))))
      (synopsis "Quicklisp support for SLY")
      (description
       "@command{sly-quicklisp} is an external contrib for SLY that provides a
sly-quickload command that prompts the user for a package to install.")
      (license license:gpl3+))))

(define-public emacs-sly-asdf
  (package
    (name "emacs-sly-asdf")
    (version "0.2.0")
    (home-page "https://github.com/mmgeorge/sly-asdf")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0gncp8xv33s4wx594bgd35vr1455bcggv1bg28qv75mhv41nzw97"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-sly emacs-popup))
    (arguments
     '(#:include (cons* "\\.lisp$" "\\.asd$" %default-include)))
    (synopsis "ASDF contrib for SLY")
    (description
     "@command{sly-asdf} is an external contrib for SLY that provides
additional support for working with ASDF projects.")
    (license license:gpl3+)))

(define-public emacs-sly-named-readtables
  (let ((commit "a5a42674ccffa97ccd5e4e9742beaf3ea719931f")
        (revision "1"))
    (package
      (name "emacs-sly-named-readtables")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/joaotavora/sly-named-readtables")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "16asd119rzqrlclps2q6yrkis8jy5an5xgzzqvb7jdyq39zxg54q"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-sly))
      (arguments
       '(#:include (cons* "\\.lisp$" "\\.asd$" %default-include)
         #:phases
         ;; The package provides autoloads.
         (modify-phases %standard-phases
           (delete 'make-autoloads)
           (delete 'enable-autoloads-compilation))))
      (synopsis "Named-readtables support for SLY")
      (description
       "@command{sly-named-readtables} is an external contrib for SLY that
enables different readtables to be active in different parts of the same
file.")
      (license license:gpl3+))))

(define-public emacs-sly-macrostep
  (let ((commit "5113e4e926cd752b1d0bcc1508b3ebad5def5fad")
        (revision "2"))
    (package
      (name "emacs-sly-macrostep")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/joaotavora/sly-macrostep")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1nxf28gn4f3n0wnv7nb5sgl36fz175y470zs9hig4kq8cp0yal0r"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-sly emacs-macrostep))
      (arguments
       '(#:include (cons* "\\.lisp$" "\\.asd$" %default-include)
         #:phases
         ;; The package provides autoloads.
         (modify-phases %standard-phases
           (delete 'make-autoloads)
           (delete 'enable-autoloads-compilation))))
      (synopsis "Expand Common Lisp macros inside source files with SLY")
      (description
       "@command{sly-macrostep} is a SLY contrib for expanding CL macros right
inside the source file.")
      (license license:gpl3+))))

(define-public emacs-sly-stepper
  (let ((commit "da84e3bba8466c2290c2dc7c27d7f4c48c27b39e"))
    (package
      (name "emacs-sly-stepper")
      (version (git-version "0.0.0" "2" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/joaotavora/sly-stepper")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "07p0k797fagn1qha191p6g2b55hsqqkcj59mh0ms9id0ildydil0"))
         (modules '((guix build utils)))
         (snippet #~(for-each delete-file
                              (find-files "." ".*-autoloads\\.elc?$")))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:include
        #~(cons* "\\.lisp$" "\\.asd$" %default-include)
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'expand-load-path 'expand-sly-contrib
              (lambda _
                (setenv "EMACSLOADPATH"
                        (string-append (elpa-directory
                                        #$(this-package-input "emacs-sly"))
                                       "/contrib:" (getenv "EMACSLOADPATH")))))
            (add-after 'install 'find-agnostic-lizard
              (lambda* (#:key inputs #:allow-other-keys)
                (let ((file (string-append (elpa-directory #$output)
                                           "/slynk-stepper.lisp")))
                  ;; agnostic-lizard is found at runtime.
                  (emacs-substitute-sexps file
                    ("(require :asdf)"
                     `(funcall (read-from-string "asdf:load-asd")
                               ,(search-input-file inputs "\
share/common-lisp/systems/agnostic-lizard.asd"))))))))))
      (inputs (list cl-agnostic-lizard))
      (propagated-inputs (list emacs-sly))
      (home-page "https://github.com/joaotavora/sly-stepper")
      (synopsis "Portable Common Lisp stepper interface for Emacs")
      (description
       "This package features a new, portable, visual stepping facility for
Common Lisp, realized as an extension to SLY.")
      (license license:gpl3+))))

(define-public emacs-sly-package-inferred
  (let ((commit "800e71e2be631422277e2ec77e6d6f6ea20e95ef")
        (revision "1"))
    (package
      (name "emacs-sly-package-inferred")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/40ants/sly-package-inferred")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1216idyp034nkqddhw4p53jkhhdxa6xnjjmsvijpf4rxqnfqvapg"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-sly))
      (arguments
       '(#:include (cons* "\\.lisp$" "\\.asd$" %default-include)
         #:phases
         ;; The package provides autoloads.
         (modify-phases %standard-phases
           (delete 'make-autoloads))))
      (synopsis "Improved package inferred systems support for SLY")
      (description
       "@command{sly-package-inferred} is an external contrib for SLY that
replaces its completion with a function which is better suited for systems
using package inferred style.")
      (license license:gpl3+))))

(define-public emacs-lua-mode
  (let ((commit "d074e4134b1beae9ed4c9b512af741ca0d852ba3")
        (revision "1"))
    (package
      (name "emacs-lua-mode")
      (version (git-version "20221027" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/immerrr/lua-mode/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "00gvrmw8pll0cl7srygh2kmbf0g44sk9asj5sm77qvhr8jz4xkkq"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "buttercup" "-l" "lua-mode.el")
        #:phases
        #~(modify-phases %standard-phases
            ;; XXX: These tests are not compatible with Buttercup, and cause
            ;; build to fail.  Remove them until they are fixed by upstream.
            (add-after 'unpack 'remove-faulty-tests
              (lambda _
                (delete-file "test/test-indentation.el")
                (delete-file "test/test-fill.el"))))))
      (native-inputs
       (list emacs-buttercup lua))
      (home-page "https://github.com/immerrr/lua-mode/")
      (synopsis "Major mode for Lua")
      (description
       "This Emacs package provides a mode for @uref{https://www.lua.org/,
Lua programming language}.")
      (license license:gpl2+))))

(define-public emacs-ebuild-mode
  (package
    (name "emacs-ebuild-mode")
    (version "1.79")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://dev.gentoo.org/~ulm/emacs/"
             "ebuild-mode-" version ".tar.xz"))
       (file-name (string-append name "-" version ".tar.xz"))
       (sha256
        (base32 "1w1axpgcchp6mry5vnpkcl4h6sbbhpdl22bygbqmf31xihcri3j4"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'install-doc
            (lambda _
              (invoke "make" "ebuild-mode.info")
              (install-file "ebuild-mode.info"
                            (string-append #$output "/share/info")))))))
    (native-inputs
     (list texinfo))
    (home-page "https://devmanual.gentoo.org")
    (synopsis "Major modes for Gentoo package files")
    (description
     "This Emacs package provides modes for ebuild, eclass, eblit, GLEP42
news items, openrc and runscripts.")
    (license license:gpl2+)))

(define-public emacs-ebuku
  ;; Upstream has no tagged release.
  (let ((revision "1")
        (commit "0c6cf404a49bd68800221446df186fffa0139325"))
    (package
      (name "emacs-ebuku")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/flexibeast/ebuku")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "09fkzmcvzdbdjaa167wiybj0kir7y12pcq2varjywshvq2l7niz4"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/flexibeast/ebuku")
      (synopsis "Emacs interface to the buku Web bookmark manager")
      (description
       "Ebuku provides a basic interface to the @code{buku} Web bookmark
manager.")
      (license license:gpl3+))))

(define-public emacs-evil
  ;; Commit message claims this is 1.15.0, but there's no tag for it, so we
  ;; use full git-version instead
  (let ((commit "008a6cdb12f15e748979a7d1c2f26c34c84dedbf")
        (revision "0"))
    (package
      (name "emacs-evil")
      (version (git-version "1.15.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacs-evil/evil")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1hxhw1rsm0wbrhz85gfabncanijpxd47g5yrdnl3bbm499z1gsvg"))))
      (arguments
       `(#:test-command (list "make" "test")
         #:phases
         (modify-phases %standard-phases
           (add-before 'check 'fix-test-helpers
             (lambda _
               (substitute* "evil-test-helpers.el"
                 (("\\(undo-tree-mode 1\\)") ""))
               #t))
           (add-before 'install 'make-info
             (lambda _
               (with-directory-excursion "doc/build/texinfo"
                   (invoke "makeinfo" "--no-split"
                           "-o" "evil.info" "evil.texi")))))))
      (build-system emacs-build-system)
      (native-inputs (list texinfo))
      (home-page "https://github.com/emacs-evil/evil")
      (synopsis "Extensible Vi layer for Emacs")
      (description
       "Evil is an extensible vi layer for Emacs.  It emulates the
main features of Vim, and provides facilities for writing custom
extensions.")
      (license license:gpl3+))))

(define-public emacs-evil-collection
  (package
    (name "emacs-evil-collection")
    (version "0.0.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-evil/evil-collection")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "09hnxb8nh3g0hi93fz9f1y164gv9iyh5994wfn6fsq2v1xdz8phm"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons* "^modes\\/" %default-include)
      #:test-command #~(list "emacs" "-Q" "--batch"
                             "-L" "."
                             "-L" "./test"
                             "-l" "evil-collection-test.el"
                             "-l" "evil-collection-magit-tests.el"
                             "-f" "ert-run-tests-batch-and-exit")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'skip-failing-tests
            (lambda _
              (substitute* "test/evil-collection-magit-tests.el"
                (("\\(ert-deftest evil-collection-magit-section-maps-accounted-for .*" all)
                 (string-append all " (skip-unless nil)"))))))))
    (native-inputs
     (list emacs-magit))
    (propagated-inputs
     (list emacs-annalist emacs-evil))
    (home-page "https://github.com/emacs-evil/evil-collection")
    (synopsis "Collection of Evil bindings for many major and minor modes")
    (description "This is a collection of Evil bindings for the parts of
Emacs that Evil does not cover properly by default, such as @code{help-mode},
@code{M-x calendar}, Eshell and more.")
    (license license:gpl3+)))

(define-public emacs-evil-goggles
  (let ((commit "08a22058fd6a167f9f1b684c649008caef571459")
        (version "0.0.1")
        (revision "0"))
    (package
      (name "emacs-evil-goggles")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/edkolev/evil-goggles")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1p3vjrij63v9nrcyj3b5jsqzv9y7dgv9i1inx1q7x3s90vndavac"))))
      (build-system emacs-build-system)
      (arguments
       (list #:test-command #~(list "ert-runner" "test")
             #:phases
             #~(modify-phases %standard-phases
                 (add-before 'check 'skip-failing-test
                   (lambda _
                     (substitute* "test/evil-goggles-test.el"
                       (("\\(ert-deftest evil-test-last-insert-register.*" all)
                        (string-append all " (skip-unless nil)"))))))))
      (propagated-inputs
       (list emacs-evil))
      (native-inputs (list emacs-ert-runner))
      (home-page "https://github.com/edkolev/evil-goggles")
      (synopsis "Displays visual hints when editing with evil")
      (description "Creates a visual pulse to indicate the region that is
being deleted, changed, yanked, or pasted when using evil commands")
      (license license:gpl3+))))

(define-public emacs-goggles
  (package
    (name "emacs-goggles")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/minad/goggles")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fczxygg1blfmlwswck49rllww77rc7qn91wqw1kvjwfz31sk8z4"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "ert-runner" ".")))
    (native-inputs (list emacs-ert-runner))
    (home-page "https://github.com/minad/goggles")
    (synopsis "Pulse modified region")
    (description "Goggles highlights the modified region using Pulse.
Currently the commands undo, yank, kill and delete are supported.")
    (license license:gpl3+)))

(define-public emacs-goto-chg
  (package
    (name "emacs-goto-chg")
    (version "1.7.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-evil/goto-chg")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0rgdzhan4n5bd78wvivacqkp0g7jvnwzgh0571p2m4yra09a36mv"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacs-evil/goto-chg")
    (synopsis "Go to the last change in the Emacs buffer")
    (description
     "This package provides @code{M-x goto-last-change} command that goes to
the point of the most recent edit in the current Emacs buffer.  When repeated,
go to the second most recent edit, etc.  Negative argument, @kbd{C-u -}, is
used for reverse direction.")
    (license license:gpl2+)))

(define-public emacs-evil-owl
  (let ((commit "24c5f43df375194386344e69bc720ea3986c9510")
        (revision "3"))
    (package
      (name "emacs-evil-owl")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mamapanda/evil-owl")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0bqzch14whlmrcasakah3psrzswvkzd7mmi8hx5s64kfp29wbdhi"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "make" "test")
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'check 'skip-failing-test
              (lambda _
                (substitute* "test/evil-owl-test.el"
                  (("\\(ert-deftest evil-owl-test-mark-string.*" all)
                   (string-append all " (skip-unless nil)"))))))))
      (propagated-inputs
       (list emacs-evil))
      (home-page "https://github.com/mamapanda/evil-owl")
      (synopsis "Preview candidates when using Evil registers and marks")
      (description
       "This package supplements Evil's register- and mark-based commands with
a popup window for previewing candidates.")
      (license license:gpl3+))))

(define-public emacs-evil-paredit
  (let ((commit "e058fbdcf9dbf7ad6cc77f0172d7517ef233d55f"))
    (package
      (name "emacs-evil-paredit")
      (version "0.0.2")                 ; says 0.0.2 in evil-paredit.el
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/roman/evil-paredit")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0b08y4spapl4g2292j3l4cr84gjlvm3rpma3gqld4yb1sxd7v78p"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-evil emacs-paredit))
      (home-page "https://github.com/roman/evil-paredit")
      (synopsis "Evil extension to integrate nicely with Paredit")
      (description
       "This package helps you to not screw up your Paredit setup when using
Evil mode.  Whenever you try to use a modifier command like @kbd{d}, @kbd{c},
@kbd{y} to modify the Paredit buffer, it will stop you to do so in the case
you break the parity of parenthesis.")
      (license license:expat))))

(define-public emacs-evil-args
  (let ((commit "758ad5ae54ad34202064fec192c88151c08cb387")
        (revision "1"))
    (package
      (name "emacs-evil-args")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/wcsmith/evil-args")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0k35glgsirc3cph8v5hhjrqfh4ndwh8a28qbr03y3jl8s453xcj7"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (home-page "https://github.com/wcsmith/evil-args")
      (synopsis "Motions and text objects for delimited arguments in Evil")
      (description
       "This package provides motions and text objects for delimited
arguments, such as arguments separated by commas and semicolons.")
      (license license:expat))))

(define-public emacs-evil-escape
  (package
    (name "emacs-evil-escape")
    (version "3.16")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/emacsorphanage/evil-escape")
         (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1z30v59igndqzxg9gcx4bsbf5jkh11wp936il8azkrz3qdryaj4a"))))
    (propagated-inputs
     (list emacs-evil))
    (build-system emacs-build-system)
    (home-page "https://github.com/emacsorphanage/evil-escape")
    (synopsis "Escape from insert state and everything else in Emacs")
    (description
     "Evil escape provides a customizable key sequence to escape from insert
state and everything else in Emacs.")
    (license license:gpl3+)))

(define-public emacs-evil-exchange
  (let ((commit "47691537815150715e64e6f6ec79be7746c96120")
        (version "0.41")
        (revision "1"))
    (package
      (name "emacs-evil-exchange")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Dewdrops/evil-exchange")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0bjpn4yqig17ddym6wqq5fm1b294q74hzcbj9a6gs97fqiwf88xa"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (native-inputs (list emacs-ert-runner))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-before 'check 'fix-makefile
             (lambda _
               (substitute* "Makefile"
                 (("cask exec ") ""))
               #t)))
         #:test-command '("make" "test")))
      (home-page "https://github.com/Dewdrops/evil-exchange")
      (synopsis "Exchange text easily within Evil")
      (description
       "This package, a port of @code{vim-exchange}, provides an Evil operator
for exchanging text.")
      (license license:gpl3+))))

(define-public emacs-evil-replace-with-register
  (let ((commit "91cc7bf21a94703c441cc9212214075b226b7f67")
        (version "0.1")
        (revision "1"))
    (package
      (name "emacs-evil-replace-with-register")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Dewdrops/evil-ReplaceWithRegister")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "14rpn76qrf287s3y2agmddcxi27r226i53ixjvd694ss039g0r11"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (home-page "https://github.com/Dewdrops/evil-ReplaceWithRegister")
      (synopsis "Quickly replace text with the contents of a register")
      (description
       "This package provides an Evil operator for replacing text with the
contents of a register.")
      (license license:gpl3+))))

(define-public emacs-evil-indent-plus
  (let ((commit "0c7501e6efed661242c3a20e0a6c79a6455c2c40")
        (version "1.0.0")
        (revision "1"))
    (package
      (name "emacs-evil-indent-plus")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/TheBB/evil-indent-plus")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1g6r1ydscwjvmhh1zg4q3nap4avk8lb9msdqrh7dff6pla0r2qs6"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (home-page "https://github.com/TheBB/evil-indent-plus")
      (synopsis "Text objects based on indentation")
      (description
       "This package adds new text objects for @code{evil-mode} based on
blocks having the same or higher indentation, including or excluding
surrounding lines.")
      (license license:gpl2+))))

(define-public emacs-evil-text-object-python
  (let ((commit "9a064fe6475429145cbcc3b270fcc963b67adb15")
        (version "1.0.1")
        (revision "1"))
    (package
      (name "emacs-evil-text-object-python")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/wbolster/evil-text-object-python")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "074zpm6mmr1wfl6d5xdf8jk1fs4ccpbzf4ahhkwga9g71xiplszv"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (home-page "https://github.com/wbolster/evil-text-object-python")
      (synopsis "Text objects for Python")
      (description
       "This package provides @code{evil-mode} text objects for Python.")
      (license license:gpl3+))))

(define-public emacs-evil-lion
  (let ((commit "6b03593f5dd6e7c9ca02207f9a73615cf94c93ab")
        (revision "1"))
    (package
      (name "emacs-evil-lion")
      (version (git-version "0.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/edkolev/evil-lion")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1a162hynp0jcsn50c1w5a02mrw9w3q05c7lkqzqd25px3d0p772q"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (arguments
       `(#:test-command '("make" "test")))
      (home-page "https://github.com/edkolev/evil-lion")
      (synopsis "Align operator for @code{evil-mode}")
      (description
       "This package, a port of @code{vim-lion}, provides an operator for
aligning text objects based on separators.")
      (license license:gpl3+))))

(define-public emacs-evil-expat
  (let ((commit "f4fcd0aa3edc359adb5c986b5dd9188d220d84e2")
        (revision "1"))
    (package
      (name "emacs-evil-expat")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/edkolev/evil-expat")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0872ix682hkdz0k8pn6sb54rqkx00rz5fxpd5j2snx406yagpaxz"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (arguments
       `(#:test-command '("make" "test")))
      (home-page "https://github.com/edkolev/evil-expat")
      (synopsis "Extra @code{ex} commands for @code{evil-mode}")
      (description
       "This package provides additional commands for the @code{ex} command
line, including functions for version control with Git and for copying and
pasting into and from @code{tmux} paste buffers.")
      (license license:gpl3+))))

(define-public emacs-evil-nerd-commenter
  (package
    (name "emacs-evil-nerd-commenter")
    (version "3.6.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/redguardtoo/evil-nerd-commenter")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1xi4sd75pzhgcd9lzhx18hlzbrwh5q9gbscb1971qn94mzxwd60r"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "make" "test")
                     #:tests? #f        ; XXX: broken docstring
                     #:phases
                     #~(modify-phases %standard-phases
                         (add-after 'unpack 'patch-Makefile
                           (lambda _
                             (substitute* "Makefile"
                               (("-Q") "")
                               (("-L [^.]*") "")
                               (("deps/") "")
                               ((" deps") "")))))))
    (propagated-inputs (list emacs-evil))
    (native-inputs (list emacs-web-mode))
    (home-page "https://github.com/redguardtoo/evil-nerd-commenter")
    (synopsis "Comment and uncomment lines efficiently")
    (description
     "This package provides text objects and operators for comments within
@code{evil-mode}.")
    (license license:gpl3+)))

(define-public emacs-evil-visual-replace
  (package
    (name "emacs-evil-visual-replace")
    (version "0.0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/troyp/evil-visual-replace")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1gfyrq7xfzmzh3x8k5f08n027dlbwi0pkkxf9c39fkxp4jngibsz"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-evil))
    (home-page "https://github.com/troyp/evil-visual-replace")
    (synopsis "Replacement commands for @code{evil-mode} visual blocks")
    (description
     "This package provides versions of @code{query-replace} and
@code{replace-regexp} that work for @code{evil-mode} visual blocks.")
    (license license:gpl2+)))

(define-public emacs-evil-visualstar
  (let ((commit "06c053d8f7381f91c53311b1234872ca96ced752")
        (version "0.2.0")
        (revision "1"))
    (package
      (name "emacs-evil-visualstar")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/bling/evil-visualstar")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0mkbzw12fav945icibc2293m5haxqr3hzkyli2cf4ssk6yvn0x4c"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-evil))
      (home-page "https://github.com/bling/evil-visualstar")
      (synopsis "Instantly search using the visual selection")
      (description
       "This package provides @code{evil-mode} functions for using selected text
to search.")
      (license license:gpl3+))))

(define-public emacs-monky
  (package
    (name "emacs-monky")
    (version "0.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ananthakumaran/monky")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1fgn7al4zwz2k5wb5dy3byqg9lsrjk9fra341mxh5ma2pfwxjgps"))))
    (build-system emacs-build-system)
    (home-page "https://ananthakumaran.in/monky/index.html")
    (arguments
     `(#:test-command '("emacs" "--batch"
                        "-l" "test/monky-unit-test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (synopsis "Interactive interface for the Mercurial version control system")
    (description
     "Monky provides an Emacs interface for Mercurial (Hg).  Using Monky, you
can selectively commit files, view the diffs, and other things.")
    (license license:gpl3+)))

(define-public emacs-monroe
  (package
    (name "emacs-monroe")
    (version "0.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sanel/monroe")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "101lfrykdbv37spkbw7zihhx26bc1lhjyxbanrcp9880bxj04jiy"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/sanel/monroe")
    (synopsis "Clojure nREPL client for Emacs")
    (description
     "Monroe is a nREPL client for Emacs, focused on simplicity and easy
distribution, primarily targeting Clojure users")
    (license license:gpl3+)))

(define-public emacs-rail
  (package
    (name "emacs-rail")
    (version "0.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Sasanidas/Rail")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1i07zv0z6r46jpg22x99a1izyfp6536xf951ibyr9kis5bql5jz9"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; tests require networking
    (home-page "https://github.com/Sasanidas/Rail")
    (synopsis "Generic nREPL client for Emacs")
    (description
     "Rail is a nREPL client based on monroe with similar features, but aims
to be a more complete implementation.")
    (license license:gpl3+)))

(define-public emacs-orgalist
  (package
    (name "emacs-orgalist")
    (version "1.16")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "orgalist-" version ".tar"))
       (sha256
        (base32 "0j78g12q66piclraa2nvd1h4ri8d6cnw5jahw6k5zi4xfjag6yx3"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/orgalist.html")
    (synopsis "Manage Org-like lists in non-Org buffers")
    (description "Orgalist writes and manages Org mode's plain lists in
non-Org buffers.  More specifically, it supports the syntax of Org mode for
numbered, unnumbered, description items, checkboxes, and counter cookies.

The library also implements radio lists, i.e., lists written in Org syntax
later translated into the host format, e.g., LaTeX or HTML.")
    (license license:gpl3+)))

(define-public emacs-writegood-mode
  (package
    (name "emacs-writegood-mode")
    (version "2.2.0")
    (home-page "https://github.com/bnbeckwith/writegood-mode")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit (string-append "v" version))))
              (sha256
               (base32
                "1a3gmaaa344kigr209b6wnjiw9ikkmw1j5jda04h3g8f9817njyv"))
              (file-name (string-append name "-checkout"))))
    (build-system emacs-build-system)
    (synopsis "Polish up poor writing on the fly")
    (description
     "This minor mode tries to find and highlight problems with your writing
in English as you type.  It primarily detects \"weasel words\" and abuse of
passive voice.")
    (license license:gpl3+)))

(define-public emacs-writefreely
  (let ((commit "cfbba9c3a34f580f39c0796966ea76b0cf98a23e")
        (revision "0"))
    (package
      (name "emacs-writefreely")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dangom/writefreely.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "02gy3kg28igqcg7ai8n2p19q8m4xpgp5wn34n2fwz2bjymgf9g4s"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-ox-hugo emacs-request))
      (home-page "https://github.com/dangom/writefreely.el")
      (synopsis "Emacs interface to the WriteFreely API")
      (description
       "This library publishes Org mode files as posts to any instance of the
federated blogging platform WriteFreely.")
      (license license:gpl3+))))

(define-public emacs-neotree
  (package
    (name "emacs-neotree")
    (version "0.6.0")
    (home-page "https://github.com/jaypei/emacs-neotree")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                     (url home-page)
                     (commit version)))
              (sha256
               (base32
                "1rwm8j48ks9fa5q3g8crpfzbikxfjj5m13w9ylimg34xniycrlq2"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "make" "test-batch")))
    (synopsis "Folder tree view for Emacs")
    (description "This Emacs package provides a folder tree view.")
    (license license:gpl3+)))

(define-public emacs-org
  (package
    (name "emacs-org")
    (version "9.7.39")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.savannah.gnu.org/git/emacs/org-mode")
             (commit (string-append "release_" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1bq4k37iax3zyhr6g335g9p9ja316yhj9a2jbh2d1mfw3rykfy2b"))))
    (build-system emacs-build-system)
    (outputs (list "out" "test"))
    (arguments
     (list
      #:test-command #~(list "make" "test-dirty")
      #:phases
      #~(modify-phases %standard-phases
          (replace 'expand-load-path
            ;; Make sure `load-path' includes "lisp" directory, otherwise
            ;; byte-compilation fails.
            (lambda args
              (with-directory-excursion "lisp"
                (apply (assoc-ref %standard-phases 'expand-load-path) args))))
          (add-after 'expand-load-path 'bootstrap
            ;; XXX: Generate "org-loaddefs.el".
            (lambda _
              (invoke "make" "autoloads")))
          (add-before 'check 'fix-tests
            (lambda* (#:key inputs #:allow-other-keys)
              ;; XXX: Running tests updates ID locations.  The process expects
              ;; a file to be writeable in "~/.emacs.d/".
              (setenv "HOME" (getcwd))
              (mkdir-p ".emacs.d")
              ;; These files are modified during testing.
              (with-directory-excursion "testing/examples"
                (for-each make-file-writable
                          '("babel.org"
                            "ob-awk-test.org"
                            "ob-sed-test.org"))
                ;; Specify where sh executable is.
                (let ((sh (search-input-file inputs "/bin/sh")))
                  (substitute* "babel.org"
                    (("/bin/sh") sh))))
              ;; XXX: Fix failure in ob-tangle/collect-blocks.  The test
              ;; assumes that ~/../.. corresponds to /.  This isn't true in
              ;; our case.
              (substitute* "testing/lisp/test-ob-tangle.el"
                ((" ~/\\.\\./\\.\\./")
                 (string-append " ~"
                                ;; relative path from ${HOME} to / during
                                ;; build
                                (string-join
                                 (map-in-order
                                  (lambda (x)
                                    (if (equal? x "") "" ".."))
                                  (string-split (getcwd) #\/)) "/")
                                "/")))
              ;; XXX: Skip failing tests.
              (substitute* "testing/lisp/test-ob-shell.el"
                (("ob-shell/remote-with-stdin-or-cmdline .*" all)
                 (string-append all "  (skip-unless nil)\n")))
              (substitute* "testing/lisp/test-org.el"
                (("test-org/org-(encode-time|time-string-to-time) .*" all)
                 (string-append all "  (skip-unless nil)\n")))))
          (replace 'build
            (lambda args
              (with-directory-excursion "lisp"
                (apply (assoc-ref %standard-phases 'build) args))))
          (replace 'install
            (lambda _
              (let ((elpa (elpa-directory #$output))
                    (info (string-append #$output "/share/info")))
                (substitute* "local.mk"
                  (("^lispdir.*") (string-append "lispdir = " elpa))
                  (("^datadir.*") (string-append "datadir = " elpa "/etc"))
                  (("^infodir.*") (string-append "infodir = " info))))
              (invoke "make" "install" (string-append "ORGVERSION=" #$version))))
          (add-after 'install 'install-org-test
            (lambda _
              (with-directory-excursion "testing"
                (copy-recursively "."
                                  (string-append (elpa-directory #$output:test))))))
          (add-after 'install 'install-org-news
            ;; Install ORG-NEWS files in doc directory.
            (lambda _
              (install-file "etc/ORG-NEWS"
                            (string-append #$output "/share/doc/"
                                           #$name "-" #$version)))))))
    (native-inputs
     (list texinfo))
    (home-page "https://orgmode.org/")
    (synopsis "Outline-based notes management and organizer")
    (description "Org is an Emacs mode for keeping notes, maintaining TODO
lists, and project planning with a fast and effective lightweight markup
language.  It also is an authoring system with unique support for literate
programming and reproducible research.  If you work with the LaTeX output
capabilities of Org-mode, you may want to install the
@code{emacs-org-texlive-collection} meta-package, which propagates the TexLive
components required by the produced @file{.tex} file.")
    (license license:gpl3+)))

(define-public emacs-org-contrib
  (package
    (name "emacs-org-contrib")
    (version "0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~bzg/org-contrib")
             (commit (string-append "release_" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1mjgfpjs32hnsj631mvmwrwxqvdb6clj3j077xmfrrp80r25gvqx"))))
    (build-system emacs-build-system)
    (arguments
     (list #:tests? #f                  ;no tests
           #:lisp-directory "lisp"))
    (home-page "https://git.sr.ht/~bzg/org-contrib")
    (synopsis "Unmaintained add-ons for Org mode")
    (description
     "This package contains add-ons to Org.  Be warned that these libraries
receive little if no maintenance and there is no guaranty that they are
compatible with the Org stable version.")
    (license license:gpl3+)))

(define-public emacs-org-count-words
  ;; No releases.
  (let ((commit "df4f06905e3020106d6ceaada854ebd7f9a231d2")
        (revision "0"))
    (package
      (name "emacs-org-count-words")
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/Elilif/org-count-words.git")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "12yxgkqv33i8hcgc5z033fhrar5l937kpsi36v4jffw6lr3wrlbv"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/Elilif/org-count-words")
      (synopsis "Word count in org-mode")
      (description "This package calculates a precise word count in org-mode
by excluding unwanted elements such as code blocks, options, and drawers.  The
results are displayed on the modeline.")
      (license license:gpl3+))))

(define-public emacs-org-texlive-collection
  (package
    (name "emacs-org-texlive-collection")
    (source #f)
    (version (package-version emacs-org))
    (build-system trivial-build-system)
    (arguments (list #:builder #~(mkdir #$output)))
    (native-inputs '())
    (inputs '())
    (propagated-inputs
     (list texlive-capt-of
           ;; The latexrecommended collection provides fontspec, amsmath,
           ;; hyperref, graphicx, tools, etc.
           texlive-collection-latexrecommended
           texlive-soul
           texlive-standalone
           texlive-ulem
           texlive-wrapfig))
    (home-page (package-home-page emacs-org))
    (synopsis "Basic TeX Live packages for Org mode LaTeX export")
    (description "This meta-package propagates the TeX Live packages minimally
required by the LaTeX output produced by Org mode.")
    (license (license:fsf-free "https://www.tug.org/texlive/copying.html"))))

(define-public emacs-org-contacts
  ;; XXX: Upstream does not tag version bumps. Commit below matches latest
  ;; version bump.
  (let ((commit "217ba04c9d638067a6ccb0829cf1885f54c1d568"))
    (package
      (name "emacs-org-contacts")
      (version "1.1")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://repo.or.cz/org-contacts")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0f0vjdvx0hffj2xvyrya8yfl77djmzmpxdxsx58ym4lmdvwyb6x3"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-org))
      (home-page "https://repo.or.cz/org-contacts")
      (synopsis "Contacts management system for Org mode")
      (description "Manage your contacts from Org mode.  You can auto
complete email addresses, export contacts to a vCard file, put birthdays
in your Org Agenda, and more.")
      (license license:gpl3+))))

(define-public emacs-org-vcard
  (package
    (name "emacs-org-vcard")
    (version "0.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pinoaffe/org-vcard")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "06w4w3wxsrbv67ssnlpk8sj4jg4qvgc87cyaiin8h9f4az3yivkz"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "ert-runner" "tests"
                                  "-l" "tests/org-vcard-tests.el")))
    (native-inputs (list emacs-ert-runner))
    (home-page "https://github.com/pinoaffe/org-vcard")
    (synopsis "Org mode support for vCard export and import")
    (description
     "This package exports and imports vCard files from within GNU Emacs' Org
mode.")
    (license license:gpl3+)))

(define-public emacs-org-pretty-table
  ;; There is no release yet.
  (let ((commit "1331c600b83d95b28730b1bfcb48369ac1cf12ef")
        (revision "0"))
    (package
      (name "emacs-org-pretty-table")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Fuco1/org-pretty-table")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0yvqxh66y400n2n5ykmb1zrzd80bakffpwn6nmf37728x4cj8krh"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/Fuco1/org-pretty-table")
      (synopsis "Make tables in Org mode and OrgTbl mode prettier")
      (description
       "This package displays tables in Org mode and OrgTbl mode using Unicode
characters.")
      (license license:gpl3+))))

(define-public emacs-ob-sclang
  (let ((commit "cd3f3c847d8149cd4ce4a775942dac88ba92c772")
        (revision "1"))
    (package
      (name "emacs-ob-sclang")
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://repo.or.cz/ob-sclang")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0dr8va2v0262plqxd63yxymqiffkql9klci7wsp5i7xgpka8925q"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-org emacs-scel))
      (home-page "https://repo.or.cz/ob-sclang")
      (synopsis "Org Babel support for SuperCollider")
      (description "This package adds support for evaluating @code{sclang} Org
mode source blocks.")
      (license license:gpl3+))))

(define-public emacs-org-edna
  (package
    (name "emacs-org-edna")
    (version "1.1.2")
    (source (origin
              (method bzr-fetch)
              (uri (bzr-reference
                    (url "bzr://bzr.savannah.nongnu.org/org-edna-el")
                    (revision version)))
              (file-name (string-append name "-" version "-checkout"))
              (sha256
               (base32
                "01dblddgx0yid5hrgl4swbr4grhv057kfbdy122wihzqpsrgq86n"))))
    (build-system emacs-build-system)
    (home-page "https://savannah.nongnu.org/projects/org-edna-el/")
    (synopsis "Manage Org task dependencies")
    (description "This package provides an extensible means of specifying
conditions which must be fulfilled before a task can be completed and actions
to take once it is.  Org Edna runs when either the BLOCKER or TRIGGER
properties are set on a heading, and when it is changing from a TODO state to
a DONE state.")
    (license license:gpl3+)))

(define-public emacs-doct
  ;; No Git tags. Version from library header; commit matches version bump.
  (let ((commit "5cab660dab653ad88c07b0493360252f6ed1d898"))
    (package
      (name "emacs-doct")
      (version "3.2.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/progfolio/doct")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0r3j7rah6sb5pscnr7p1jnbc6kmlvnpc3paswwxb4byd18dq7jvj"))))
      (build-system emacs-build-system)
      (native-inputs (list emacs-buttercup))
      (home-page "https://github.com/progfolio/doct")
      (synopsis "Declarative Org capture templates")
      (description
       "@code{doct} provides an alternative, declarative syntax for defining Org
capture templates.")
      (license license:gpl3+))))

(define-public emacs-toodoo
  ;; Package has no release.  Version is extracted from "Version:" keyword in
  ;; main file, and commit below matches version bump.
  (package
    (name "emacs-toodoo")
    (version "0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ChanderG/toodoo.el")
             (commit "149a563863c2f728c5f903475dbce50547c51000")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "00q7aym0kl03j9m66pivgy0snxcjjg402049b2wdy18kgyypfvx8"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-evil))
    (home-page "https://github.com/ChanderG/toodoo.el")
    (synopsis "Magit-like interface for a Todo workflow built on top of Org")
    (description "This package provides a minor mode for fast and easy management of Todos
using Org mode and transients.")
    (license license:asl2.0)))

(define-public emacs-flx
  (package
    (name "emacs-flx")
    (version "0.6.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/lewang/flx")
              (commit (string-append "v" version))))
       (sha256
        (base32
         "0sjybrcnb2sl33swy3q664vqrparajcl0m455gciiih2j87hwadc"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f        ; tests require a TTY
                     #:test-command #~(list "make" "test")))
    (home-page "https://github.com/lewang/flx")
    (synopsis "Fuzzy matching for Emacs")
    (description
     "Flx provides fuzzy matching for emacs a la sublime text.
The sorting algorithm is a balance between word beginnings (abbreviation)
and contiguous matches (substring).  The longer the substring match,
the higher it scores.  This maps well to how we think about matching.
Flx has support for ido (interactively do things) through flx-ido.")
    (license license:gpl3+)))

(define-public emacs-afternoon-theme
  (let ((commit "89b1d778a1f8b385775c122f2bd1c62f0fbf931a")
        (revision "0"))
    (package
      (name "emacs-afternoon-theme")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "http://github.com/osener/emacs-afternoon-theme")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19d5d6qs5nwmpf26rsb86ranb5p4236qp7p2b4i88cimcmzspylb"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/osener/emacs-afternoon-theme")
      (synopsis "Dark color theme with a deep blue background")
      (description
       "Afternoon theme is a dark color theme with a deep blue background.")
      (license license:gpl3+))))

(define-public emacs-cyberpunk-theme
  (package
    (name "emacs-cyberpunk-theme")
    (version "1.22")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/n3mo/cyberpunk-theme.el/")
              (commit version)))
       (sha256
        (base32
         "06nff38pcy5rgz13svkajsg0jjk73qy4a8m7p9f76yxcywxlgxlc"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (home-page "https://github.com/n3mo/cyberpunk-theme.el")
    (synopsis "Cyberpunk theme for Emacs built-in color theme support")
    (description
     "Cyberpunk color theme for the Emacs 24+ built-in color theme support
known loosely as deftheme.  Many mode-specific customizations are included.")
    (license license:gpl3+)))

(define-public emacs-dart-mode
  (package
    (name "emacs-dart-mode")
    (version "1.0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bradyt/dart-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vql8m4nj0brmv58b6lkbhykik8n6j4i7d3nylcls78y7ihc2cz8"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command
                     ;; XXX: test-font-lock has one unexpected failure.
                     #~(list "emacs" "--batch" "-l" "dart-mode"
                             ;; "-l" "test/test-font-lock.el"
                             "-l" "test/test-indentation.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs
     (list emacs-dash emacs-flycheck emacs-s))
    (home-page "https://github.com/bradyt/dart-mode")
    (synopsis "Emacs mode for the Dart programming language")
    (description
     "Dart mode is an Emacs major mode for editing Dart files.  It provides
basic syntax highlighting and indentation.")
    (license license:gpl3+)))

(define-public emacs-danneskjold-theme
  (let ((commit "b3335e44f468c019c95a8210ce1ed9fe23c65735")) ;version bump
    (package
      (name "emacs-danneskjold-theme")
      (version "20231110.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rails-to-cosmos/danneskjold-theme")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19lncwxzxyi73cn7439rk8cvgcj6l4x1kj6fykmw3b18s7rj555f"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'delete-screenshots
              (lambda _
                (delete-file-recursively "screenshots"))))))
      (home-page "https://github.com/rails-to-cosmos/danneskjold-theme")
      (synopsis "High-contrast Emacs theme")
      (description
       "@code{danneskjold-theme} is a high-contrast theme for Emacs.")
      (license license:gpl3+))))

(define-public emacs-dream-theme
  (let ((commit "62caa37d5f1ddb1187ee0b9e7dd9833679cc5eb5")) ;version bump
    (package
      (name "emacs-dream-theme")
      (version "1.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/djcb/dream-theme")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "13ziwd6cw8s8gyzbklxlvpvbx5dbchvvhlxq9pi8vn3zlzpprd6h"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/djcb/dream-theme")
      (synopsis "High-contrast Emacs theme")
      (description
       "@code{dream-theme} is a dark, clean theme for Emacs.  It is inspired
by zenburn, sinburn and similar themes, but slowly diverging from them.")
      (license license:gpl3+))))

(define-public emacs-dracula-theme
  (package
    (name "emacs-dracula-theme")
    (version "1.8.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dracula/emacs")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vv00hgik7pvj1p0ii8g6bcyvfjzwhh33hjh0gfgsh8gxm1lfij8"))))
    (build-system emacs-build-system)
    (home-page "https://draculatheme.com/")
    (synopsis "Dark theme for Emacs")
    (description
     "Dracula is a dark color theme for many editors, shells and more.  This
package provides the Emacs theme.")
    (license license:expat)))

(define-public emacs-auto-complete
  (package
    (name "emacs-auto-complete")
    (version "1.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/auto-complete/auto-complete")
              (commit (string-append "v" version))))
       (sha256
        (base32
         "04i9b11iksg6acn885wl3qgi5xpsm3yszlqmd2x21yhprndlz7gb"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "ert-runner" "tests")))
    (propagated-inputs
     (list emacs-popup))
    (native-inputs (list emacs-ert-runner))
    (home-page "https://github.com/auto-complete/auto-complete")
    (synopsis "Intelligent auto-completion extension for Emacs")
    (description
     "Auto-Complete is an intelligent auto-completion extension for Emacs.
It extends the standard Emacs completion interface and provides an environment
that allows users to concentrate more on their own work.  Its features are:
a visual interface, reduce overhead of completion by using statistic method,
extensibility.")
    (license license:gpl3+)))

(define-public emacs-auto-dark
  (package
    (name "emacs-auto-dark")
    (version "0.13.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/LionyxML/auto-dark-emacs")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1jmh27fkf1pivavv0qwwbb1fhdaycj3gpbbgsd917flsp6pfw55x"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/LionyxML/auto-dark-emacs")
    (synopsis "Dark/light automatic Emacs theme switcher")
    (description "This package provides the @code{auto-dark-mode} minor mode,
which enables automatic switching between two user-defined (customizable)
themes.  This transition occurs seamlessly in response to dark mode being
enabled or disabled in the desktop preferences (such as in GNOME).  It uses
DBus to query the system configured value.  To enable it, put the following
snippet to your Emacs configuration file:
@lisp
(require auto-dark)
(auto-dark-mode t)
@end lisp
To customize the themes used, visit @samp{M-x customize-group auto-dark}.")
    (license license:gpl2+)))

(define-public emacs-autocrypt
  (let ((commit "dc0223f11daf526621fda206b38bf06c29759c94")) ;version bump
    (package
      (name "emacs-autocrypt")
      (version "0.4.2")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://git.sr.ht/~pkal/autocrypt")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0p4fmmldsypb5v4h3p1dfi1qdbk4i6w03465b3hb0x0qnj49l695"))))
      (build-system emacs-build-system)
      (home-page "https://git.sr.ht/~pkal/autocrypt")
      (synopsis "Autocrypt implementation for Emacs")
      (description "Autocrypt package is an implementation of
Autocrypt (@url{https://autocrypt.org/}) for various Emacs MUAs,
a cryptographic protocol for email clients aiming to simplify key exchange and
encryption.")
      (license license:gpl3+))))

(define-public emacs-nginx-mode
  (package
    (name "emacs-nginx-mode")
    (version "1.1.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ajc/nginx-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1zal05l3lnb41pvfxwkzrcf39g7amqbaaffxn3wz7qa45gvvc6fw"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ajc/nginx-mode")
    (synopsis "Emacs major mode for editing nginx config files")
    (description "This package provides an Emacs major mode for
editing nginx config files.")
    (license license:gpl2+)))

(define-public emacs-stream
  (package
    (name "emacs-stream")
    (version "2.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "stream-" version ".tar"))
       (sha256
        (base32 "16wl1q7wikk0wyzfwjz16azq025dx4wdh1j9q0nadi68ygxi172b"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/stream.html")
    (synopsis "Implementation of streams for Emacs")
    (description "This library provides an implementation of streams for Emacs.
Streams are implemented as delayed evaluation of cons cells.")
    (license license:gpl3+)))

(define-public emacs-cl-print
  (let ((commit "1a70c553dfb04352afb5b8696fe0cef8acc8f991")
        (revision "1"))
    (package
      (name "emacs-cl-print")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsmirror/cl-print")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "164zbnsi5mssvcpy0158fm7fw5cmd1r5nkpn29fmd2b2scy3gm79"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/emacsmirror/cl-print")
      (synopsis "CL-style generic printing")
      (description "This package provides a generic function,
@code{cl-print-object}, to which the programmer can add any method they
please.")
      (license license:gpl3+))))

(define-public emacs-el-search
  (let ((commit "07bed84dd8ae9e4c6c648834224b1d33fdbd51e0")
        (revision "2"))
    (package
      (name "emacs-el-search")
      (version (git-version "1.12.6.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/emacsmirror/el-search")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "10w1ldgijdhfsrazp0y3bm76jv5wvdn94k1yp0pmc2m1896b58ak"))))
      (build-system emacs-build-system)
      (inputs
       (list emacs-stream emacs-cl-print))
      (home-page "https://github.com/emacsmirror/el-search")
      (synopsis "Expression based interactive search for emacs-lisp-mode")
      (description "This package provides expression based interactive search
procedures for emacs-lisp-mode.")
      (license license:gpl3+))))

(define-public emacs-ht
  (package
    (name "emacs-ht")
    (version "2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Wilfred/ht.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0can9v336lgnq0q2ha3js0565jzp3dlwwqxhcbx5swk5kp148f07"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-dash))
    (native-inputs
     (list emacs-ert-runner))
    (home-page "https://github.com/Wilfred/ht.el")
    (synopsis "Hash table library for Emacs")
    (description
     "This package simplifies the use of hash tables in elisp.  It also
provides functions to convert hash tables from and to alists and plists.")
    (license license:gpl3+)))

(define-public emacs-log4e
  (package
    (name "emacs-log4e")
    (version "0.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/aki2o/log4e")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1x08dz18zhifkhrwdbh57izzidaf6vy1vb865f4xrqs6blgfiwj4"))))
    (build-system emacs-build-system)
    (arguments
     `(#:tests? #f                      ; tests require el-expectations
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'remove-tests
           ;; Guile builder complains about null characters in some
           ;; strings of test files.  Remove "test" directory (it is not
           ;; needed anyway).
           (lambda _
             (delete-file-recursively "test"))))))
    (home-page "https://github.com/aki2o/log4e")
    (synopsis "Logging framework for elisp")
    (description
     "This package provides a logging framework for elisp.  It allows
you to deal with multiple log levels.")
    (license license:gpl3+)))

(define-public emacs-denote
  (package
    (name "emacs-denote")
    (version "4.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/protesilaos/denote")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "157hmdxndj26987lscwiygsz2w9fdllw5imk7m15qla30yp9q5f4"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   (add-after 'unpack 'build-info-manual
                     (lambda _
                       (invoke "emacs"
                               "--batch"
                               "--eval=(require 'ox-texinfo)"
                               "--eval=(find-file \"README.org\")"
                               "--eval=(org-texinfo-export-to-info)"))))
      #:test-command #~(list "emacs" "--batch"
                             "-l" "tests/denote-test.el"
                             "--eval"
                             "(ert-run-tests-batch-and-exit
             `(not ,(rx (or \"make-denote-directory\" \"date-convert\"
\"--denote-directory\" \"get-identifier\" \"identifier-p\"))))")))
    (native-inputs (list texinfo))
    (home-page "https://protesilaos.com/emacs/denote/")
    (synopsis "Simple notes for Emacs")
    (description
     "Denote is a simple note-taking tool for Emacs.  It is based on the idea
that notes should follow a predictable and descriptive file-naming scheme.
The file name must offer a clear indication of what the note is about, without
reference to any other metadata.  Denote basically streamlines the creation of
such files while providing facilities to link between them.")
    (license license:gpl3+)))

(define-public emacs-denote-journal
  (package
    (name "emacs-denote-journal")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/denote-journal-"
                           version ".tar"))
       (sha256
        (base32 "00rav8kachy85npcr96dwzb4kbgym0p2m5aw3v3pmg278nmc73v3"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-denote))
    (home-page "https://github.com/protesilaos/denote-journal")
    (synopsis "Convenience functions for daily journaling with Denote")
    (description "The denote-journal package makes it easier to use Denote for
journaling.  While it is possible to use the generic @code{denote} command
(and related) to maintain a journal, this package defines extra functionality
to streamline the journaling workflow.")
    (license license:gpl3+)))

(define-public emacs-denote-markdown
  (package
    (name "emacs-denote-markdown")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/denote-markdown-"
                           version ".tar"))
       (sha256
        (base32 "0y1lnzv2x6wnw06gx9jb38wwpd4cyn1f8r430wg26zc6grb4fmsz"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-denote))
    (home-page "https://github.com/protesilaos/denote-markdown")
    (synopsis "Extensions that better integrate Denote with Markdown")
    (description "This package provides some convenience functions to better
integrate Markdown with Denote.")
    (license license:gpl3+)))

(define-public emacs-denote-silo
  (package
    (name "emacs-denote-silo")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/denote-silo-"
                           version ".tar"))
       (sha256
        (base32 "10n4xv179dl6zz1k28lcbrgyqx8k3hfh3isd7q3qg1vcahlw04vl"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-denote))
    (home-page "https://github.com/protesilaos/denote-silo")
    (synopsis "Convenience functions for using Denote in multiple silos")
    (description "The denote-silo package makes it easier to work with
multiple silos.  A silo is a localised denote-directory that is not connected
to the default/global denote-directory and other silos.")
    (license license:gpl3+)))

(define-public emacs-denote-menu
  (package
    (name "emacs-denote-menu")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/namilus/denote-menu")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "15kaf45ndyg4xvgnpn8qwapkgcswasykcqfpkr0mny35a3jhdgrq"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))    ; no tests
    (propagated-inputs (list emacs-denote))
    (home-page "https://www.scss.tcd.ie/~sulimanm/posts/denote-menu.html")
    (synopsis "View and filter Denote files in a tabulated list")
    (description "This package provides an interface for viewing your
Denote files that goes beyond using the standard Dired Emacs command to
view your Denote directory.")
    (license license:gpl3+)))

(define-public emacs-denote-org
  (package
    (name "emacs-denote-org")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/denote-org-" version
                           ".tar"))
       (sha256
        (base32 "05jyy4gmd4nhgbh0cfjnjspwjzdkrljgl12wygqlai4d4hpv54mr"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (propagated-inputs (list emacs-denote))
    (home-page "https://github.com/protesilaos/denote-org")
    (synopsis "Denote extensions for Org mode")
    (description "This package contains extra features that better integrate
Denote with Org mode.")
    (license license:gpl3+)))

(define-public emacs-denote-sequence
  (package
    (name "emacs-denote-sequence")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/denote-sequence-"
                           version ".tar"))
       (sha256
        (base32 "0i0vm1n48aw7j4y6laa8fvs0av5smimdky980qgp69pha6hcvph5"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-denote))
    (home-page "https://github.com/protesilaos/denote-sequence")
    (synopsis "Sequence notes or Folgezettel with Denote")
    (description "This package provides an optional extension to denote for
naming files with a sequencing scheme.  The idea is to establish hiearchical
relationships between files, such that the contents of one logically follow or
complement those of another.")
    (license license:gpl3+)))

(define-public emacs-denote-explore
  (package
    (name "emacs-denote-explore")
    (version "4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pprevos/denote-explore")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "04lc5fw11wixbjdkzbl63g03rdybv6q4mh1dc6c9y322g8qq3r0k"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-denote emacs-dash))
    (arguments
     (list
      #:tests? #f ;no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'build-info-manual
            (lambda* (#:key outputs #:allow-other-keys)
              (invoke "emacs"
                      "--batch"
                      "--eval=(require 'ox-texinfo)"
                      "--eval=(find-file \"denote-explore.org\")"
                      "--eval=(org-texinfo-export-to-info)"))))))
    (native-inputs (list texinfo))
    (home-page "https://github.com/pprevos/denote-explore")
    (synopsis "Analyse and visualise a collection of Denote notes")
    (description
     "The Denote Explore package provides auxiliary functions to
maintain and explore your collection of Denote files.  Denote Explore provides
four groups of Emacs commands:
@enumerate
@item Summary statistics: Count and visualize notes, attachments and keywords.
@item Random walks: Generate new ideas using Serendipity.
@item Janitor: Manage your Denote collection.
@item Visualisations: Visualise your Denote network as a network
graph.  (Optional dependencies GraphViz, D3js, to be acquired separately!)
@end enumerate")
    (license license:gpl3+)))

(define-public emacs-logos
  (package
    (name "emacs-logos")
    (version "1.2.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/protesilaos/logos")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0yjhvmzdzyi9hy46420i2zp00m0p89lca3bjs749i8izpllv8kxr"))))
    (native-inputs (list texinfo))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (home-page "https://protesilaos.com/emacs/logos")
    (synopsis "Simple focus mode for Emacs")
    (description "This package provides a simple focus mode which can be
applied to any buffer for reading, writing, or even doing a presentation.  The
buffer can be divided in pages using the @code{page-delimiter}, outline
structure, or any other pattern.")
    (license (list license:gpl3+
                   license:fdl1.3+)))) ; GFDLv1.3+ for the manual

(define-public emacs-tmr
  (package
    (name "emacs-tmr")
    (version "1.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/protesilaos/tmr")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1x7brjlmyxzdbixzc8fldyvmc8qyvi5s5is8s7zcv6fvxbm2dp1a"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f                       ; no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-paths
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((ffplay (search-input-file inputs "/bin/ffplay")))
                (substitute* "tmr.el"
                  (("\"ffplay") (string-append "\"" ffplay))))
              (emacs-substitute-variables "tmr.el"
                ("tmr-sound-file"
                 (search-input-file
                  inputs
                  "share/sounds/freedesktop/stereo/alarm-clock-elapsed.oga")))))
          (add-after 'unpack 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (native-inputs (list texinfo))
    (inputs (list ffmpeg sound-theme-freedesktop))
    (home-page "https://protesilaos.com/emacs/tmr/")
    (synopsis "Set timers using a convenient notation")
    (description
     "TMR is an Emacs package that provides facilities for setting timers
using a convenient notation.")
    (license (list license:gpl3+
                   license:fdl1.3+)))) ;GFDLv1.3+ for the manual

(define-public emacs-beframe
  (let ((commit "c3f4583b0767e7f8c38c83ed29af40af8ba3bdfa")) ;version bump
    (package
      (name "emacs-beframe")
      (version "1.4.0")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/protesilaos/beframe")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1j9v85wxahnm2h828c8dbjm0f81j9pxlf54dgcw443cl0kwcda9c"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:tests? #f                     ;no tests
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'install 'makeinfo
              (lambda _ (emacs-makeinfo))))))
      (native-inputs
       (list texinfo))
      (home-page "https://protesilaos.com/emacs/beframe")
      (synopsis "Isolate Emacs buffers per frame")
      (description
       "Beframe enables a frame-oriented Emacs workflow where each frame has
access to the list of buffers visited therein.  In the interest of brevity, we
call buffers that belong to frames ``beframed''.  Producing multiple frames
does not generate multiple buffer lists.  There still is only one global list
of buffers.  Beframing them simply filters the list.")
      (license (list license:gpl3+
                     license:fdl1.3+))))) ; GFDLv1.3+ for the manual

(define-public emacs-gn-mode
  (package
    (name "emacs-gn-mode")
    (version "0.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/lashtear/gn-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0dz5kgzbgsssr38z2kg6m915cvfys42ag1k42bsra3la2pixywfx"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/lashtear/gn-mode")
    (synopsis "Emacs major mode for editing GN (ninja generator) config files")
    (description
     "GN mode is a major mode for editing @acronym{GN,Ninja Generator} config
files in Emacs.  Files of this type (e.g., @file{BUILD.gn} or @file{*.gni})
are common in Chromium-derived projects.")
    (license license:bsd-3)))

(define-public emacs-gnosis
  (package
    (name "emacs-gnosis")
    (version "0.5.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://git.thanosapollo.org/gnosis")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nzyys00jdh1d7sv8jigaxb1h1ghvkc9d1r0603rsmfkrsfq229p"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "make" "test")
                     #:emacs emacs   ; tests require built-in SQLite support
                     #:phases
                     #~(modify-phases %standard-phases
                         (add-before 'check 'set-home
                           (lambda _
                             (setenv "HOME" (getenv "TMPDIR"))
                             (mkdir-p (string-append (getenv "HOME")
                                                     "/.emacs.d"))))
                         (add-before 'install 'make-info
                           (lambda _ (invoke "make" "doc"))))))
    (native-inputs (list texinfo))
    (propagated-inputs
     (list emacs-compat emacs-emacsql emacs-org-gnosis emacs-transient))
    (home-page "https://thanosapollo.org/projects/gnosis")
    (synopsis "Spaced repetition system for GNU Emacs")
    (description
     "Gnosis is a spaced repetition system for note-taking and self-testing
where notes are formatted as Question/Answer/Explanation.  Notes are reviewed
at spaced intervals based on the success or failure in recalling the answer to
each question.")
    (license license:gpl3+)))

(define-public emacs-drag-stuff
  (package
    (name "emacs-drag-stuff")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rejeep/drag-stuff")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jrr59iazih3imkl9ja1lbni9v3xv6b8gmqs015g2mxhlql35jka"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command
                     #~(list "emacs" "-l" "ecukes"
                             "--batch" "--eval"
                             (string-append
                              "(let ((ecukes-exclude-tags"
                              "'(\"only-in-emacs-23\" \"not-in-emacs-24.5\")))"
                              "(ecukes))"))))
    (native-inputs (list emacs-ecukes emacs-evil))
    (home-page "https://github.com/rejeep/drag-stuff")
    (synopsis "Drag stuff around in Emacs")
    (description
"Drag Stuff is a minor mode for Emacs that makes it possible to drag
stuff (words, region, lines) around in Emacs.")
    (license license:gpl3+)))

(define-public emacs-bazel
  ;; From 2021-11-21.
  ;; No releases available.
  (let ((commit "cdb2643dba39fe2bd64ba3b190b94d1ef1d83b18")
        (revision "0"))
    (package
      (name "emacs-bazel")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/bazelbuild/emacs-bazel-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32 "0ln06dprnivx9zxm6n23ppyx7x4kbn0f85pxwvkq32aq7wnqz82m"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ; tests appear to require bazel
      (home-page "https://github.com/bazelbuild/emacs-bazel-mode")
      (synopsis "Bazel support for Emacs")
      (description
       "This package provides support for the Bazel build system.  See
@uref{https://bazel.build/} for background on Bazel.")
      (license license:asl2.0))))

(define-public emacs-clue
  ;; There are no releases so far.
  (let ((commit "41895da52cf76f964d97cb8204406ab9828c4839")
        (revision "0"))
    (package
      (name "emacs-clue")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/AmaiKinono/clue")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32 "08xpdpac82v5vwqqqgbh5imakl4pys6bpfacfk05pk88lw925ql8"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ; no tests
      (home-page "https://github.com/AmaiKinono/clue/")
      (synopsis "Connecting clues while reading code")
      (description
       "Clue is a tool for helping you take notes while reading code.

Code reading is all about finding connections between different locations in
a project.  With Clue, you can take notes about these connections in plain
text (or your favorite markup language), and insert links to take you to these
locations.")
      (license license:gpl3+))))

(define-public emacs-gntp
  (package
    (name "emacs-gntp")
    (version "0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tekai/gntp.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nvyjjjydrimpxy4cpg90si7sr8lmldbhlcm2mx8npklp9pn5y3a"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tekai/gntp.el")
    (synopsis "Growl Notification Protocol for Emacs")
    (description
     "This package implements the Growl Notification Protocol GNTP
described at @uref{http://www.growlforwindows.com/gfw/help/gntp.aspx}.
It is incomplete as it only lets you send but not receive
notifications.")
    (license license:bsd-3)))

(define-public emacs-alert
  (package
    (name "emacs-alert")
    (version "1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jwiegley/alert")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0lc0p5cl4hfrzw1z2ghb11k1lvljn5m08jw5fmgwgxv667kwh49r"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-gntp emacs-log4e))
    (home-page "https://github.com/jwiegley/alert")
    (synopsis "Growl-style notification system for Emacs")
    (description
     "Alert is a Growl-workalike for Emacs which uses a common notification
interface and multiple, selectable \"styles\", whose use is fully
customizable by the user.")
    (license license:gpl2+)))

(define-public emacs-zones
  (package
    (name "emacs-zones")
    (version "2023.6.11")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "zones-" version ".tar"))
       (sha256
        (base32 "1znz720s9pchc7r9g1mpz9jcnz122bppimmh09g1rn94fh3m6vm3"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/Zones")
    (synopsis "Define and act on multiple zones of buffer text")
    (description
     "Library @file{zones.el} lets you easily define and subsequently act on
multiple zones of buffer text.  You can think of this as enlarging the notion
of region.  In effect, it can remove the requirement of target text being
a contiguous sequence of characters.  A set of buffer zones is, in effect,
a (typically) noncontiguous set of text.")
    (license license:gpl3+)))

(define-public emacs-mu4e-alert
  (let ((commit "d36eb0c1842dea51ee0465bb3751948c8886617c")
        (revision "1"))
    (package
      (name "emacs-mu4e-alert")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/xzz53/mu4e-alert")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "039kfpwgw0vi6fv2p4ixdh9qx9hdsahl48yl1niq00zmsp7rgg07"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ;no tests
      (propagated-inputs
       (list emacs-alert emacs-ht emacs-s mu))
      (home-page "https://github.com/xzz53/mu4e-alert")
      (synopsis "Desktop notifications and mode line display for mu4e")
      (description
       "This package provides desktop notifications for mu4e.
Additionally it can display the number of unread emails in the mode line.")
      (license license:gpl3+))))

(define-public emacs-org-notify
  (package
    (name "emacs-org-notify")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/org-notify-" version
                           ".tar"))
       (sha256
        (base32 "1vg0h32x5lc3p5n71m23q8mfdd1fq9ffmy9rsm5rcdphfk8s9x5l"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/p-m/org-notify")
    (synopsis "Notifications for Org-mode")
    (description
     "This package allows you to get notifications when there is something
to do (for org mode).

Sometimes, you need a reminder a few days before a deadline, e.g. to buy a
present for a birthday, and then another notification one hour before to have
enough time to choose the right clothes.

For other events, e.g. rolling the dustbin to the roadside once per week, you
probably need another kind of notification strategy.

This package tries to satisfy the various needs.

In order to activate this package, you must add the following code into your
.emacs or .emacs.d configuration:

@lisp
(require org-notify)
(org-notify-start)
@end lisp")
    (license license:gpl3+)))

(define-public emacs-mu4e-column-faces
  (package
   (name "emacs-mu4e-column-faces")
   (version "20221213.2206")
   (source
    (origin
     (method git-fetch)
     (uri (git-reference
           (url "https://github.com/Alexander-Miller/mu4e-column-faces.git")
           (commit "1bbb646ea07deb1bd2daa4c6eb36e0f65aac40b0")))
     (file-name (git-file-name name version))
     (sha256
      (base32 "12cb37lj8j1fd5kp3gbnzgknb57j5l8xgrnhb60ysff66m1mbrr7"))))
   (build-system emacs-build-system)
   (propagated-inputs
    (list mu))
   (home-page "https://github.com/Alexander-Miller/mu4e-column-faces")
   (synopsis "Faces for individual mu4e columns")
   (description
    "This package provides a minor mode for individual column faces in mu4e's
mail overview.")
   (license license:gpl3+)))

(define-public emacs-mu4e-jump-to-list
  (let ((commit "358bba003543b49ffa266e503e54aebd0ebe614b")
        (revision "1"))
    (package
      (name "emacs-mu4e-jump-to-list")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/wavexx/mu4e-jump-to-list.el.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "00y9nap61q1z2cdql4k9g7fgi2gdgd9iy5s5lzrd9a4agbx6r7sv"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list mu))
      (home-page "https://gitlab.com/wavexx/mu4e-jump-to-list.el")
      (synopsis "Select and view mailing lists in mu4e")
      (description
        "@code{mu4e-jump-to-list} allows you to select and view mailing lists
automatically using existing List-ID headers in your mu database.  Just press
\"l\" in the headers view and any mailing list you've subscribed to will be
automatically discovered and presented in recency order.")
      (license license:gpl3+))))

(define-public emacs-url-scgi
  (package
    (name "emacs-url-scgi")
    (version "0.9")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://elpa.gnu.org/packages/"
                                  "url-scgi-" version ".tar"))
              (sha256
               (base32
                "0mfbqr03302gk38aamlg1lgdznd6y3blcc3zizfb72ppb87j78mc"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "make" "test")))
    (home-page "https://github.com/skangas/url-scgi/")
    (synopsis "SCGI support for url.el")
    (description
     "This library add support for SCGI URLs to Emacs.  It is based on url.el,
which is shipped with Emacs.")
    (license license:gpl3+)))

(define-public emacs-mentor
  (package
    (name "emacs-mentor")
    (version "0.5")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.nongnu.org/nongnu/mentor-"
                           version ".tar"))
       (sha256
        (base32
         "1kkzm881fxhc5hb83x0j12lv22b72nzw45qrypbl1jf2siispz9l"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-async emacs-url-scgi emacs-xml-rpc))
    (home-page "https://elpa.nongnu.org/nongnu/mentor.html")
    (synopsis "Emacs front-end for the rTorrent bittorrent client")
    (description
     "Mentor is a GNU Emacs frontend for the rTorrent bittorrent client.

By default, it will start and run rTorrent from within Emacs but can also be
configured to use an external rTorrent instance over XML-RPC.

This project aims to provide a feature complete and customizable interface,
that will feel familiar to Emacs users.  Key bindings are chosen to be as
close to the vanilla rTorrent curses interface as possible.")
    (license license:gpl3+)))

(define-public emacs-message-view-patch
  (let ((commit "40bc2e554fc1d0b6f0c403192c0a3ceaa019a78d")
        (revision "2"))
    (package
      (name "emacs-message-view-patch")
      (version (git-version "0.2.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/seanfarley/message-view-patch")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0cmkiggrl42sjx31dwnzac32bs3q2ksmamkq1pjjl8fwshp4g8sv"))))
      (build-system emacs-build-system)
      (inputs (list emacs-magit))
      (home-page "https://github.com/seanfarley/message-view-patch")
      (synopsis "Colorize patch-like emails in mu4e or gnus")
      (description
       "Extension for mu4e or gnus to colorize patch-like emails with diff-mode.
This is based on Frank Terbeck's @code{gnus-article-treat-patch.el} but has
been adapted to also work with mu4e.")
      (license license:gpl3+))))

(define-deprecated-package emacs-mu4e-patch
  emacs-message-view-patch)

(define-public emacs-pretty-mode
  (package
    (name "emacs-pretty-mode")
    (version "2.0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/akatov/pretty-mode/")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "013fig9i4fyx16krp2vfv953p3rwdzr38zs6i50af4pqz4vrcfvh"))))
    (build-system emacs-build-system)
    (native-inputs (list emacs-ert-runner))
    (home-page "https://github.com/akatov/pretty-mode")
    (synopsis "Redisplay parts of the buffer as Unicode symbols")
    (description
     "Emacs minor mode for redisplaying parts of the buffer as pretty symbols.")
    (license license:gpl3+)))

(define-public emacs-tempel
  (package
    (name "emacs-tempel")
    (version "1.9")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                     (url "https://github.com/minad/tempel")
                     (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1d4flcfnszvl2nyxqav3ha42lx5mhj93f8r4l0gc4n3ir8x5y9f5"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f                       ;no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (native-inputs (list texinfo))
    (propagated-inputs
     (list emacs-compat))
    (home-page "https://github.com/minad/tempel")
    (synopsis "Simple templates for Emacs")
    (description
     "Tempel is a tiny template package for Emacs, which uses the syntax of
the Emacs Tempo library.  You may also write your templates in Lisp.")
    (license license:gpl3+)))

(define-public emacs-tempel-collection
  (let ((commit "b2fd7929bd767db9d31b2782168f91dcdc75af5b")
        (revision "2"))
    (package
      (name "emacs-tempel-collection")
      (version (git-version "0.2" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/Crandel/tempel-collection")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0m52k8fx88ry9ay6xs5xaq6j56rx2lykb1jgxmia26xyf4h5ykd9"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:include #~(cons "^templates\\/" %default-include)))
      (propagated-inputs (list emacs-tempel))
      (home-page "https://github.com/Crandel/tempel-collection")
      (synopsis "Collection of TempEl templates")
      (description "This package provides a collection of templates for
the Emacs TempEl package.")
      (license license:gpl3+))))

(define-public emacs-yasnippet
  (let ((commit "dd570a6b22364212fff9769cbf4376bdbd7a63c5"))
    (package
      (name "emacs-yasnippet")
      ;; Missing Git tags, version bumped in package file.
      (version "0.14.3")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/joaotavora/yasnippet")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1s7zsdw83v5v7alsnzzrrr3m177qnm7x4hr8w7f84a4lamd0h6s3"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command
        #~(list
           "emacs" "--batch"
           "-l" "yasnippet-tests.el"
           ;; XXX: one test is broken…
           "--eval"
           "(ert-run-tests-batch-and-exit
             '(not yas-org-native-tab-in-source-block-emacs-lisp))")
        #:phases
        #~(modify-phases %standard-phases
            ;; Set HOME, otherwise test-rebindings fails.
            (add-before 'check 'set-home
              (lambda _
                (setenv "HOME" (getcwd)))))))
      (home-page "https://github.com/joaotavora/yasnippet")
      (synopsis "Yet another snippet extension for Emacs")
      (description "YASnippet is a template system for Emacs.  It allows you to
type an abbreviation and automatically expand it into function templates.")
      (license license:gpl3+))))

(define-public emacs-yasnippet-snippets
  (package
    (name "emacs-yasnippet-snippets")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/AndreaCrotti/yasnippet-snippets")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0p38k8a3l9vpph1g2a6wz40y30wb2nhp770rv8947bxzjc5xc0gf"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:include #~(cons* "^snippets\\/" %default-include)
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'set-home
            (lambda _
              (setenv "HOME" (getcwd)))))))
    (propagated-inputs
     (list emacs-yasnippet))
    (home-page "https://github.com/AndreaCrotti/yasnippet-snippets")
    (synopsis "Collection of YASnippet snippets for many languages")
    (description "This package provides an extensive collection of YASnippet
snippets.  When this package is installed, the extra snippets it provides are
automatically made available to YASnippet.")
    (license license:gpl3+)))

(define-public emacs-doom-snippets
  ;; Use the latest commit, as there are no tagged releases.  Version is
  ;; extracted from main file.
  (let ((release "1.1.0")
        (revision "0")
        (commit "bc613f448eed1bd363e61c41691a61e9fd139534"))
    (package
      (name "emacs-doom-snippets")
      (version (git-version release revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hlissner/doom-snippets")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0n4b2pr0gpn8vb2n1rckdq4jk9sj995a62yxk6z2ygw5ad7pkj8f"))))
      (build-system emacs-build-system)
      (arguments
       `(#:include (cons* "^.*\\/" %default-include)))
      (propagated-inputs
       (list emacs-yasnippet))
      (home-page "https://github.com/hlissner/doom-snippets")
      (synopsis "Doom Emacs' snippet library")
      (description
       "This package provides Yasnippets snippets for Doom Emacs.  It also
exposes a small API to assist in writing your own snippets.")
      (license license:expat))))

(define-public emacs-helm-c-yasnippet
  (let ((commit "c5880e740da101fde7a995e94a7b16c330e57583")
        (revision "2"))
    (package
      (name "emacs-helm-c-yasnippet")
      (version (git-version "0.6.7" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/emacs-jp/helm-c-yasnippet")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "026i2cywf3gvhbvnc996i76vv1pqzi21j6v8zwm198dj1f1wg4kw"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "emacs" "--batch"
                               "-l" "test/helm-yasnippet-test.el"
                               "-f" "ert-run-tests-batch-and-exit")))
      (propagated-inputs
       (list emacs-helm emacs-yasnippet))
      (home-page "https://github.com/emacs-jp/helm-c-yasnippet")
      (synopsis "Helm integration for Yasnippet")
      (description
       "This Emacs library provides Helm interface for Yasnippet.")
      (license license:gpl2+))))

(define-public emacs-helm-system-packages
  (package
    (name "emacs-helm-system-packages")
    (version "1.10.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/emacs-helm/helm-system-packages")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32 "13a8jpj4wwm0yjv8hnsizgjf8wi3r2ap87lyvw7g4c7snp2dydwa"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "helm-system-packages-guix.el"
               (("recsel")
                (search-input-file inputs "bin/recsel"))))))))
    (inputs (list recutils))
    (propagated-inputs (list emacs-helm))
    (home-page "https://github.com/emacs-helm/helm-system-packages")
    (synopsis "Helm System Packages is an interface to your package manager")
    (description
     "List all available packages in Helm (with installed
packages displayed in their own respective face).  Fuzzy-search, mark and
execute the desired action over any selections of packages: Install,
uninstall, display packages details (in Org Mode) or insert details at point,
find files owned by packages...  And much more, including performing all the
above over the network.")
    (license license:gpl3+)))

(define-public emacs-helm-org-rifle
  (package
    (name "emacs-helm-org-rifle")
    (version "1.7.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alphapapa/helm-org-rifle")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0pm6va26kadjvbai4qsnjc2bk379w2nk6h3b5f0c2yv3q5na0p49"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "buttercup" "-L" ".")))
    (native-inputs
     (list emacs-buttercup))
    (propagated-inputs
     (list emacs-dash emacs-f emacs-helm emacs-org emacs-s))
    (home-page "https://github.com/alphapapa/helm-org-rifle")
    (synopsis "Rifle through Org files")
    (description "This package searches both headings and contents of entries
in Org buffers and displays matching entries.")
    (license license:gpl3+)))

(define-public emacs-dired-git-info
  ;; Upstream has no proper release.  The base version is extracted from the
  ;; "Version" keyword in the main file.
  (let ((commit "91d57e3a4c5104c66a3abc18e281ee55e8979176")
        (revision "0"))
    (package
      (name "emacs-dired-git-info")
      (version (git-version "0.3.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/clemera/dired-git-info")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1dr4iv95s4barxxj56znqkl9z0lg5jw731jmjr01s6vn8ar69gik"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/clemera/dired-git-info/")
      (synopsis "Show git info in Emacs Dired")
      (description "This Emacs package provides a minor mode which shows git
information inside the Dired buffer.")
      (license license:gpl3+))))

(define-public emacs-dired-quick-sort
  (package
    (name "emacs-dired-quick-sort")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://gitlab.com/xuhdev/dired-quick-sort/")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0wk29rqaczlz1r42xygphpyvhfcrkzilrz9xd4ps0qjybnx9dsgq"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-hydra))
    (home-page "https://gitlab.com/xuhdev/dired-quick-sort/")
    (synopsis "Automatic sorting of Dired buffers")
    (description
     "@{dired-quick-sort} provides persistent quick sorting of Dired buffers
in various ways with @code{hydra}.")
    (license license:gpl3+)))

(define-public emacs-diss
  (let ((commit "8a99a1b34de4575087da49fe1e19bcf33ac49f46")
        (revision "1"))
    (package
      (name "emacs-diss")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/emacs-weirdware/diss.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "06xvl85dkp3c2cw41f2gy7db2d7fy5pv5w1wr7vd7ccdlg3fq4gc"))))

      (build-system emacs-build-system)
      (home-page "https://codeberg.org/emacs-weirdware/diss")
      (synopsis "Dired Image Slideshow")
      (description "Diss is a full-featured image slideshow for Emacs, based
on Dired and image-mode.")
      (license (list license:gpl3+)))))

(define-public emacs-dired-toggle-sudo
  (let ((commit "13bbe52c54893f5aa3e56228450ffdd0c9e1d169")
        (revision "0"))
    (package
      (name "emacs-dired-toggle-sudo")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/renard/dired-toggle-sudo")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1fw1pb1z6krqd1pfxxhr6rrfr9ckkcb0zsjzbjk0i2i1q5cg6car"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/renard/dired-toggle-sudo")
      (synopsis "Browse directory with @code{sudo} privileges")
      (description "This package allows for the use of @code{dired} with
@code{sudo} privileges.")
      (license license:wtfpl2))))

(define-public emacs-diredfl
  (package
    (name "emacs-diredfl")
    (version "0.5")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/purcell/diredfl")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "125a49ibbaicp6kxv0ja9mz9paryqgz30xhl0pk3kvnm8z40hlr6"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; no tests
    (home-page "https://github.com/purcell/diredfl/")
    (synopsis "Extra Emacs font lock rules for a more colourful Dired")
    (description "This library enables additional font locking in Dired mode.
This is adapted from the extra font lock rules provided by Drew Adams' Dired+
package.")
    (license license:gpl3+)))

(define-public emacs-memoize
  (package
    (name "emacs-memoize")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/skeeto/emacs-memoize")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "04qgnlg4x6va7x364dhj1wbjmz8p5iq2vk36mn9198k2vxmijwzk"))))
    (build-system emacs-build-system)
    (arguments
     `(#:test-command '("emacs" "--batch"
                        "-l" "memoize-test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/skeeto/emacs-memoize")
    (synopsis "Emacs lisp memoization library")
    (description "@code{emacs-memoize} is an Emacs library for
memoizing functions.")
    (license license:unlicense)))

(define-public emacs-memory-usage
  (package
    (name "emacs-memory-usage")
    (version "0.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/memory-usage-"
                           version ".el"))
       (sha256
        (base32 "03qwb7sprdh1avxv3g7hhnhl41pwvnpxcpnqrikl7picy78h1gwj"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/memory-usage.html")
    (synopsis "Analyze the memory usage of Emacs in various ways")
    (description
     "This package provides the command @code{memory-usage}, which lists all
buffers and how much memory they use.")
    (license license:gpl3+)))

(define-public emacs-linum-relative
  (package
    (name "emacs-linum-relative")
    (version "0.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/coldnew/linum-relative")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0b3n1gk2w1p72x0zfdz9l70winq2fnjpjrgq0awxx730xk7ypp5n"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/coldnew/linum-relative")
    (synopsis "Relative line numbering for Emacs")
    (description "@code{emacs-linum-relative} displays the relative line
number on the left margin in Emacs.")
    (license license:gpl2+)))

(define-public emacs-lin
  (package
    (name "emacs-lin")
    (version "1.1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/protesilaos/lin")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "00l74ldkv0nb58v6la12k36b43y3qxlcgccygpph5fhzj47v1gn4"))))
    (native-inputs (list texinfo))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f                       ; no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'makeinfo
            (lambda _ (emacs-makeinfo))))))
    (home-page "https://protesilaos.com/emacs/lin")
    (synopsis "Make Hl Line mode more suitable for selection UIs")
    (description
     "Lin is a stylistic enhancement for Emacs’ built-in Hl Line mode.  It
remaps the @code{hl-line} face (or equivalent) buffer-locally to a style that is
optimal for major modes where line selection is the primary mode of
interaction.")
    (license (list license:gpl3+
                   license:fdl1.3+)))) ; GFDLv1.3+ for the manual

;; Package has no releases or tags.  Version is extracted from "Version:"
;; keyword in main file.
(define-public emacs-idle-highlight
  (let ((commit "f9091c907d41e7b12d99d108a194229b8dbfc5ae")
        (revision "0"))
    (package
      (name "emacs-idle-highlight")
      (version (git-version "1.1.4" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url
                       "https://codeberg.org/ideasman42/emacs-idle-highlight-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0757x4iy7q0mj1rshlxr00hbc78g5hzijgzyqs36nrw6bn65fb93"))))
      (build-system emacs-build-system)
      (home-page "https://codeberg.org/ideasman42/emacs-idle-highlight-mode")
      (synopsis "Highlights all occurrences of the word the point is on")
      (description
       "This Emacs package provides @code{idle-highlight-mode} that sets
 an idle timer to highlight all occurrences in the buffer of the word under
 the point.")
      (license license:gpl3+))))

(define-public emacs-ox-twbs
  (package
    (name "emacs-ox-twbs")
    (version "1.1.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/marsmining/ox-twbs")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0nffy7ivs8fw0dj3s66hbsby0riz5wrv7xzm8g9mrfvhki938pqa"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/marsmining/ox-twbs")
    (synopsis "Export org-mode docs as HTML compatible with Twitter Bootstrap")
    (description
     "This Emacs package outputs your org-mode docs with a simple, clean and
modern look.  It implements a new HTML back-end for exporting org-mode docs as
HTML compatible with Twitter Bootstrap.  By default, HTML is exported with
jQuery and Bootstrap resources included via osscdn.")
    (license license:gpl3+)))

(define-public emacs-highlight-sexp
  (package
    (name "emacs-highlight-sexp")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/daimrod/highlight-sexp")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "12cyk2q5g6p4ac2hykw1cag7dp1prjjnck5f7nalwwaklmy62y79"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/daimrod/highlight-sexp")
    (synopsis "Minor mode that highlights the s-exp at the current position")
    (description
     "This Emacs package highlights the s-exp at the current position.")
    (license license:gpl3+)))

(define-public emacs-highlight-stages
  (let ((commit "29cbc5b78261916da042ddb107420083da49b271")
        (revision "1"))
    (package
      (name "emacs-highlight-stages")
      (version (string-append "1.1.0" "-" revision "." (string-take commit 7)))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/zk-phi/highlight-stages")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0r6nbcrr0dqpgm8dir8ahzjy7rw4nrac48byamzrq96r7ajlxlv0"))
         (patches
          (search-patches "emacs-highlight-stages-add-gexp.patch"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/wigust/highlight-stages")
      (synopsis "Minor mode that highlights (quasi-quoted) expressions")
      (description "@code{highlight-stages} provides an Emacs minor mode that
highlights quasi-quoted expressions.")
      (license license:gpl3+))))

(define-public emacspeak
  (package
    (name "emacspeak")
    (version "60.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tvraman/emacspeak")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nry9qklhxwqpbqvhms0p25sz49s291rk2a8vf23fp4h5p37cxfh"))))
    (build-system gnu-build-system)
    (arguments
     (list
      #:make-flags #~(list (string-append "prefix=" #$output))
      #:phases
      #~(modify-phases %standard-phases
          (replace 'configure
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (setenv "SHELL" (which "sh"))
              ;; Ensure the tclespeak.so binary is found in the correct location
              ;; by adding the path to the Tclx library to the Tcl $auto_path
              ;; variable.
              (with-fluids ((%default-port-encoding "ISO-8859-1"))
                (substitute* "servers/espeak"
                  (("package require Tclx")
                   (string-append "set auto_path [linsert $auto_path 0 "
                                  #$tclx
                                  "/lib]\n"
                                  "package require Tclx"))))
              ;; Configure Emacspeak according to etc/install.org.
              (invoke "make" "config")))
          (add-after 'build 'build-espeak
            (lambda _
              (invoke "make" "espeak")))
          (replace 'install
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (let* ((out (assoc-ref outputs "out"))
                     (bin (string-append out "/bin"))
                     (lisp (string-append out "/share/emacs/site-lisp/emacspeak"))
                     (info (string-append out "/share/info"))
                     (emacs (search-input-file inputs "/bin/emacs")))
                ;; According to etc/install.org, the Emacspeak directory should
                ;; be copied to its installation destination.
                (for-each
                 (lambda (file)
                   (copy-recursively file (string-append lisp "/" file)))
                 '("etc" "info" "js" "lisp" "media" "servers" "sounds"
                   "stumpwm" "xsl"))
                ;; Make sure emacspeak is loaded from the correct directory.
                (substitute* "run"
                  (("\\./lisp/emacspeak-setup.el")
                   (string-append lisp "/lisp/emacspeak-setup.el")))
                ;; Install the convenient startup script.
                (mkdir-p bin)
                (copy-file "run" (string-append bin "/emacspeak"))))))
      #:tests? #f))                     ; no check target
    (inputs
     (list emacs espeak-ng perl tcl tclx))
    (home-page "https://emacspeak.sourceforge.net")
    (synopsis "Audio desktop interface for Emacs")
    (description
     "Emacspeak is a speech interface that allows visually impaired users to
interact independently and efficiently with the computer.  Audio
formatting---a technique pioneered by AsTeR---and full support for W3C's Aural
CSS (ACSS) allows Emacspeak to produce rich aural presentations of electronic
information.  By seamlessly blending all aspects of the Internet such as
Web-surfing and messaging, Emacspeak speech-enables local and remote
information via a consistent and well-integrated user interface.")
    (license license:gpl2+)))

(define-public emacs-adaptive-wrap
  (package
    (name "emacs-adaptive-wrap")
    (version "0.8")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "adaptive-wrap-" version ".tar"))
       (sha256
        (base32 "1dz5mi21v2wqh969m3xggxbzq3qf78hps418rzl73bb57l837qp8"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/adaptive-wrap.html")
    (synopsis "Smart line-wrapping with wrap-prefix")
    (description
     "This Emacs package provides the @code{adaptive-wrap-prefix-mode}
minor mode which sets the wrap-prefix property on the fly so that
single-long-line paragraphs get word-wrapped in a way similar to what
you'd get with @kbd{M-q} using @code{adaptive-fill-mode}, but without
actually changing the buffer's text.")
    (license license:gpl3+)))

(define-public emacs-diff-hl
  (package
    (name "emacs-diff-hl")
    (version "1.10.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dgutov/diff-hl")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0vfqyhzf3lyrhn788fbyc4p3lf36fkh8qnxvg6vddg4bxmqcjnsw"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command #~(list "make" "test")))
    (home-page "https://github.com/dgutov/diff-hl")
    (synopsis "Highlight uncommitted changes using VC")
    (description
     "Diff Hl mode highlights uncommitted changes on the side of the
window (using the fringe, by default), allows you to jump between the hunks
and revert them selectively.")
    (license license:gpl3+)))

(define-public emacs-diminish
  ;; XXX: Upstream did not tag last release.
  (let ((commit "fd486ef76e4c1d8211ae337a43b8bba106d4bca7")
        (revision "1"))
    (package
      (name "emacs-diminish")
      (version (git-version "0.46" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/myrjola/diminish.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1vlgn7swwfzy6yr880698h3qsmfcqprcb1jvffkzmbvhvf458szf"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/myrjola/diminish.el")
      (synopsis "Diminish minor modes with no modeline display")
      (description "@code{emacs-diminish} implements hiding or
abbreviation of the mode line displays (lighters) of minor modes.")
      (license license:gpl3+))))

(define-public emacs-use-package
  ;; XXX: Upstream did not tag latest release.  Using commit matching exact
  ;; version bump.
  (let ((commit "942617d26e11d80d879ff23d2a8b477bd074a734"))
    (package
      (name "emacs-use-package")
      (version "2.4.4")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/jwiegley/use-package")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1zpf9xv65jg813k90x8g9k4lja896nqfh48pjinicmz1rn0rf51a"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "emacs" "--batch"
                               "-l" "use-package-tests.el"
                               "-f" "ert-run-tests-batch-and-exit")
        #:phases
        #~(modify-phases %standard-phases
            (add-before 'install 'install-manual
              (lambda _
                (let ((info-dir (string-append #$output "/share/info")))
                  (install-file "use-package.info" info-dir))))
            (add-before 'install-manual 'build-manual
              (lambda _
                (invoke "makeinfo" "use-package.texi"))))))
      (native-inputs
       (list texinfo))
      (propagated-inputs
       (list emacs-diminish))
      (home-page "https://github.com/jwiegley/use-package")
      (synopsis "Declaration for simplifying your .emacs")
      (description "The use-package macro allows you to isolate package
configuration in your @file{.emacs} file in a way that is both
performance-oriented and tidy.")
      (license license:gpl2+))))

(define-public emacs-leaf
  (package
    (name "emacs-leaf")
    (version "4.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "leaf-" version ".tar"))
       (sha256
        (base32 "1rdbrf84ijapiqhq72gy8r5xgk54sf0jy31pgd3w4rl1wywh5cas"))))
    (build-system emacs-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-before 'check 'skip-failing-tests
                 (lambda _
                   (emacs-batch-edit-file "leaf-tests.el"
                     '(progn (search-forward-regexp
                              "leaf-key .* (lambda () \"color-moccur\"")
                             (beginning-of-line)
                             (kill-sexp)
                             (basic-save-buffer))))))))
    (home-page "https://github.com/conao3/leaf.el")
    (synopsis "Simplify your init.el configuration, extended use-package")
    (description
     "This package provides macros that allows you to declaratively configure
settings typical of an Elisp package with various keywords.  The syntax is
similar, but not identical to use-package -- overall, leaf aims at a cleaner
and more predictable implementation.")
    (license license:agpl3+)))

(define-public emacs-strace-mode
  (let* ((commit "6a69b4b06db6797af56f33eda5cb28af94e59f11")
         (revision "1"))
    (package
      (name "emacs-strace-mode")
      (version (string-append "0.0.2-" revision "." (string-take commit 7)))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/pkmoore/strace-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1lbk2kzdznf2bkfazizfbimaxxzfzv00lrz1ran9dc2zqbc0bj9f"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/pkmoore/strace-mode")
      (synopsis "Emacs major mode to highlight strace outputs")
      (description "@code{emacs-strace-mode} provides an Emacs major mode
 highlighting strace outputs.")
      (license license:gpl3+))))

(define-public emacs-defaultencrypt
  (package
    (name "emacs-defaultencrypt")
    (version "5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/lechten/defaultencrypt")
             (commit (string-append "vs" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1hkcikfms0y5xbr169b3bb00kbjf0zyfby0gipay054jns7y4i5z"))))
    (build-system emacs-build-system)
    (home-page "https://gitlab.com/lechten/defaultencrypt")
    (synopsis "Automatically encrypt or sign Gnus messages in Emacs")
    (description
     "DefaultEncrypt is designed to be used with Gnus in Emacs.  It
automatically encrypts messages that you send (e.g., email) when public keys
for all recipients are available, and it protects you from accidentally
sending un-encrypted messages.  It can also be configured to automatically
sign messages that you send.  For details and instructions on how to use
DefaultEncrypt, please refer to the home page or read the comments in the
source file, @file{jl-encrypt.el}.")
    (license license:gpl3+)))

(define-deprecated-package emacs-default-encrypt
  emacs-defaultencrypt)

(define-public emacs-deflate
  (package
    (name "emacs-deflate")
    (version "0.0.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                     (url "https://github.com/skuro/deflate")
                     (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "15zrjv3wqnqzscjy7vny6j13dy12vzri1i9zzmj2jii3x7wdkv4b"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "ert-runner" "test/")))
    (native-inputs (list emacs-ert-runner))
    (propagated-inputs (list emacs-dash))
    (home-page "https://github.com/skuro/deflate")
    (synopsis "Elisp implementation of the DEFLATE algorithm")
    (description
     "This Emacs library implements the DEFLATE algorithm specified in RFC 1951.

While the scope of this project is to write a full implementation of the
algorithm, there is currently no interest of developing the best compression
ratios on the planet, but rather being able to support DEFLATE (and a little
bit of zlib) in Emacs in a portable fashion.")
    (license license:gpl3+)))

;; Package has no release.  Version is extracted from "Version:" keyword in
;; main file.
(define-public emacs-exotica-theme
  (let ((commit "ff3ef4f6fa38c93b99becad977c7810c990a4d2f")
        (revision "0"))
    (package
      (name "emacs-exotica-theme")
      (version (git-version "1.0.2" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/zenobht/exotica-theme")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1kp6q55g3dcya4y79x877vqwxa4z2rkkvhs49pkwr3wljf4af2pd"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/zenobht/exotica-theme")
      (synopsis "Dark theme for Emacs with vibrant colors")
      (description
       "A dark opinionated theme with vibrant colors for Emacs.  Inspired by
@code{Molokai} and @code{Dracula} themes.")
      (license license:gpl3+))))

(define-public emacs-extend-smime
  (package
    (name "emacs-extend-smime")
    (version "3.3")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://informationelle-selbstbestimmung-im-internet.de"
             "/emacs/jl-smime" version "/jl-smime.el"))
       (file-name (string-append "jl-smime-" version ".el"))
       (sha256
        (base32
         "1iv8s2wjmv3v5qfwlcy9hvvrmxxvp3f8m1krlr789q7bbh35jynh"))))
    (build-system emacs-build-system)
    (home-page
     "https://informationelle-selbstbestimmung-im-internet.de/Emacs.html")
    (synopsis "Improved S/MIME support for Gnus in Emacs")
    (propagated-inputs
     (list emacs-defaultencrypt))
    (description
     ;; TRANSLATORS: ExtendSMIME, DefaultEncrypt, and emacs-defaultencrypt
     ;; should not be translated.  The name "emacs-defaultencrypt" refers to
     ;; the Guix package that provides DefaultEncrypt.
     "ExtendSMIME is designed to be used with Gnus in Emacs.  It enhances
DefaultEncrypt (emacs-defaultencrypt) to support S/MIME (Secure/Multipurpose
Internet Mail Extensions) via LDAP (Lightweight Directory Access Protocol).
Before a message (e.g., email) is sent, ExtendSMIME searches for missing
certificates via LDAP and imports them into @code{gpgsm}.  When certificates
for all recipients are available, DefaultEncrypt automatically encrypts the
message.  For details and instructions on how to use ExtendSMIME, please refer
to the home page or read the comments in the source file,
@file{jl-smime.el}.")
    (license license:gpl3+)))

(define-public emacs-htmlize
  (package
    (name "emacs-htmlize")
    (version "1.59")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hniksic/emacs-htmlize")
             (commit (string-append "release/" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1kdria0h5pmrgdrrxrhf2wlxsmk4drq0byj7mnx4h73sd2ynhhr7"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #false))  ;no tests
    (home-page "https://github.com/hniksic/emacs-htmlize")
    (synopsis "Convert buffer text and decorations to HTML")
    (description "@code{emacs-htmlize} converts the buffer text and
the associated decorations to HTML.  Output to CSS, inline CSS and
fonts is supported.")
    (license license:gpl2+)))

(define-public emacs-xmlgen
  (package
    (name "emacs-xmlgen")
    (version "0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/philjackson/xmlgen")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "096i29v0badx0a6339h9ckdz78zj59gbjdp7vj7vhkq9d830392s"))))
    (build-system emacs-build-system)
    (arguments
     `(#:test-command '("emacs" "--batch"
                        "-l" "xmlgen-test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/philjackson/xmlgen")
    (synopsis "S-expression to XML domain specific language (DSL) in
Emacs Lisp")
    (description "@code{emacs-xmlgen} provides S-expression to XML
conversion for Emacs Lisp.")
    (license license:gpl2+)))

(define-public emacs-cdlatex
  (let ((commit "fac070f0164ac9f5859cb4cccba7d29a65c337f3")) ;version bump
    (package
      (name "emacs-cdlatex")
      (version "4.18.5")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cdominik/cdlatex")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1851nf6bghgzh9nbv8x92yzgdc9rl2jiiwqw2kpninr5myk7fh9y"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ; no tests
      (propagated-inputs
       (list emacs-auctex))
      (home-page "https://github.com/cdominik/cdlatex")
      (synopsis "Fast Emacs input methods for LaTeX environments and
math")
      (description "CDLaTeX is an Emacs minor mode supporting fast
insertion of environment templates and math in LaTeX.  Similar
commands are also offered as part of the AUCTeX package, but it is not
the same - CDLaTeX focuses on speediness for inserting LaTeX
constructs.")
      (license license:gpl3+))))

(define-public emacs-cnfonts
  (package
    (name "emacs-cnfonts")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tumashu/cnfonts")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0k0mh653sjwhli6hxdyzvcqdmpxdsx1s0fwzsw69dfr6nxr7f1dv"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tumashu/cnfonts")
    (synopsis "Emacs Chinese fonts setup tool")
    (description "Cnfonts is a Chinese fonts setup tool, allowing for easy
configuration of Chinese fonts.")
    (license license:gpl2+)))

(define-public emacs-cal-china-x
  (let ((revision "0")
        (commit  "94005e678a1d2522b7a00299779f40c5c77286b8"))
    (package
      (name "emacs-cal-china-x")
      (version (git-version "2.6b" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/xwl/cal-china-x")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0dy9awy5y990wz925rdn95gn23ywarwbvkqq0l0xms1br1v8kxc6"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/xwl/cal-china-x")
      (synopsis "Chinese localization, lunar/horoscope/zodiac info and more")
      (description
       "Cal-China-X provides additional features for Emacs' Cal-China package:

@itemize
@item Chinese localizations.
@item Display holiday, lunar, horoscope, zodiac, solar term info on mode line.
@item Define holidays using holiday-lunar, holiday-solar-term.
@item Highlight holidays based on different priorities.
@item Add cal-china-x-chinese-holidays, cal-china-x-japanese-holidays.
@item custom week diary (like weeks in school).
@end itemize")
      (license license:gpl3+))))

(define-public emacs-boon
  (package
    (name "emacs-boon")
    (version "1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jyp/boon")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0jmmxav45sbch9prdxipd04rdmyh5ca1r9lpdlj61b5c4vlm4282"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; tests require networking
    (propagated-inputs
     (list emacs-dash emacs-expand-region emacs-multiple-cursors
           emacs-powerline emacs-spaceline))
    (home-page "https://github.com/jyp/boon")
    (synopsis "Ergonomic command mode for Emacs")
    (description "Boon is a complete package for modal editing with a focus on
ergonomics and modularity.  Spacial allocation of keys comes first, mnemonics
second.  Most common operations are mapped to the home row, common editing
commands are bound to keys reachable with the left hand and movement keys are
reached with the right hand.")
    (license license:gpl3+)))

(define-public emacs-cc-mode
  (package
   (name "emacs-cc-mode")
   (version "5.35")
   (source
    (origin
     (method hg-fetch)
     (uri (hg-reference
           (url "http://hg.code.sf.net/p/cc-mode/cc-mode")
           (changeset
            (string-append "Release_"
                           (string-replace-substring version "." "_")))))
     (file-name (hg-file-name name version))
     (sha256
      (base32 "03cvl61baccx57zd62nz2wy4hvij5hl2syg7byaxgrs4c7grr414"))))
   (build-system emacs-build-system)
   (arguments
    '(#:test-command '("make" "test")
      #:phases
      (modify-phases %standard-phases
        (add-before 'install 'make-info
          (lambda _
            (invoke "make" "info"))))))
   (native-inputs
    (list texinfo))
   (home-page "https://cc-mode.sourceforge.net/")
   (synopsis "Framework for creating major modes for C-style languages")
   (description
    "CC Mode is an Emacs and XEmacs mode for editing C and other languages with
similar syntax; currently C++, Objective-C, Java, CORBA's IDL, Pike, and AWK.")
   (license license:gpl3+)))

(define-public emacs-csharp-mode
  (package
    (name "emacs-csharp-mode")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/josteink/csharp-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1d0pf236xi4c7fazv67a53yrac24lilnkzp9pb55xm88gig7rfmz"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/josteink/csharp-mode")
    (synopsis "Major mode for C# code")
    (description
     "This is a C# editing mode for Emacs, based on CC mode.  It handles
syntax coloring, indentation, insertion of matched pairs of curly braces and
documentation generation.  In addition, it provides menu-based navigation
using Imenu, and Compilation mode support for MSBuild, devenv and xbuild.")
    (license license:gpl3+)))

(define-public emacs-vala-mode
  ;; Upstream has no tagged release.
  (let ((commit "d696a8177e94c81ea557ad364a3b3dcc3abbc50f")
        (revision "0"))
    (package
      (name "emacs-vala-mode")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rrthomas/vala-mode")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0g5pdq757z9d8rk489n5ilhqipdc4i4sfkjwwrxyvgjlapjc04c0"))))
      (build-system emacs-build-system)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'disable-multiline-support
             (lambda* (#:key inputs #:allow-other-keys)
               (make-file-writable "vala-mode.el")
               (emacs-batch-edit-file "vala-mode.el"
                 '(progn
                   (require 'thingatpt) ;; beginning-of-thing, end-of-thing
                   (goto-char (point-min))
                   (save-excursion
                    (re-search-forward ";; Support multiline strings")
                    (goto-char (match-beginning 0))
                    (kill-sexp)
                    (insert ";; FIXME: Support multiline strings
(c-lang-defconst c-multiline-string-start-char vala nil)"))
                   (save-excursion
                    (re-search-forward "(defcustom vala-multiline-strings")
                    (goto-char (match-beginning 0))
                    (insert ";; FIXME: Support multiline strings\n")
                    (comment-region (beginning-of-thing 'sexp)
                                    (end-of-thing 'sexp)))
                   (basic-save-buffer))))))))
      (home-page "https://github.com/rrthomas/vala-mode")
      (synopsis "Vala mode for Emacs")
      (description
       "This package provides a major mode for editing .vala and .vapi files
in Emacs.")
      (license license:gpl2+))))

(define-public emacs-php-mode
  (package
    (name "emacs-php-mode")
    (version "1.27.0")
    (home-page "https://github.com/emacs-php/php-mode")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0pkvqpzzy7wmbd99gvphfaz2ds79n5fcx4n7f772mgz8x5f9xq1b"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:test-command #~(list "emacs" "-Q" "--batch"
                             "-l" "../tests/php-mode-test.el"
                             "-f" "ert-run-tests-batch-and-exit")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'prepare-testing-bed
            (lambda _
              ;; This file is necessary for `php-project-root' test.
              (call-with-output-file "tests/project/1/.git"
                (const #t))))
          (add-after 'prepare-testing-bed 'enter-source-directory
            (lambda _
              (chdir "lisp"))))))
    (propagated-inputs (list emacs-projectile))
    (synopsis "Major mode for editing PHP code")
    (description
     "PHP mode is a major mode for editing PHP source code.  It's an extension
of C mode; thus it inherits all C mode's navigation functionality.  But it
colors according to the PHP grammar and indents according to the PEAR coding
guidelines.  It also includes a couple handy IDE-type features such as
documentation search and a source and class browser.")
    (license license:gpl3+)))

(define-public emacs-composer
  (let ((commit "791a7104be2ef2748757a186094c1e8f7f531a01")
        (revision "0"))
    (package
      (name "emacs-composer")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/zonuexe/composer.el")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "01kb74nlkp4fvpbz6wdx776q3v7jfknhax1qmg85kj2ilkadfrd0"))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f))    ; no tests
      (home-page "https://github.com/zonuexe/composer.el")
      (synopsis "Emacs interface for managing PHP dependencies with Composer")
      (description
       "This package provides an Emacs interface for working with PHP
 dependencies managed by Composer.  It allows users to run Composer commands
 directly from Emacs, including installing and updating packages, and managing
 Composer configurations.  The package aims to streamline the development
 workflow for PHP projects within Emacs.")
      (license license:gpl3+))))

(define-public emacs-pippel
  (let ((commit "cb194952ee150e77601d3233dabdb521b976ee79")
        (revision "0"))
    (package
      (name "emacs-pippel")
      (version (git-version "0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/arifer612/pippel")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "17606l24yyrjxa4rc0p2zj50lfbayqldw4phhi59yqf61289d520"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:include #~(cons "^pippel\\.py$" %default-include)
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'substitute-pippel-package-path
              (lambda _
                (emacs-substitute-variables "pippel.el"
                  ("pippel-package-path" (elpa-directory #$output)))))
            (add-after 'unpack 'substitute-python-path
              (lambda* (#:key inputs #:allow-other-keys)
                (emacs-substitute-variables "pippel.el"
                  ("pippel-python-command"
                   (search-input-file inputs "/bin/python"))))))))
      (inputs
       (list python-wrapper))
      (propagated-inputs
       (list emacs-dash emacs-s))
      (home-page "https://github.com/arifer612/pippel")
      (synopsis "Emacs frontend to Python package manager Pip")
      (description
       "Pippel is an Emacs frontend for the Python package manager Pip.  As
Pippel also uses Tabulated List mode, it provides a similar package menu like
@code{package-list-packages}.")
      (license license:gpl3+))))

(define-public emacs-pos-tip
  (package
    (name "emacs-pos-tip")
    (version "0.4.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pitkali/pos-tip")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1k6r59jhbyiknhsl7df0zafyc4d9r3vk953x6sdxgz92kx6hxpfy"))))
    (build-system emacs-build-system)
    ;; The following functions and variables needed by emacs-pos-tip are
    ;; not included in emacs-minimal:
    ;; x-display-pixel-width, x-display-pixel-height, x-show-tip
    (arguments `(#:emacs ,emacs))
    (home-page "https://github.com/pitkali/pos-tip")
    (synopsis "Show tooltip at point")
    (description "The standard library tooltip.el provides a function for
displaying a tooltip at the mouse position.  However, locating a tooltip at an
arbitrary buffer position in a window is not easy.  Pos-tip provides such a
function to be used by other frontend programs.")
    (license license:gpl2+)))

(define-public emacs-pyim-basedict
  ;; XXX: The commit below points to the latest (un-tagged) release.
  (let ((commit "55d9b324831b0fc79ff62f1c6f21aad72341a114"))
    (package
      (name "emacs-pyim-basedict")
      (version "0.5.5")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tumashu/pyim-basedict")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "15hd6zffc2s9rdxdjrybggf355risw60l4skqm8hc0xx0kmss9x2"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:include #~(cons "pyim-basedict.pyim" %default-include)))
      (propagated-inputs
       (list emacs-pyim))
      (home-page "https://github.com/tumashu/pyim-basedict")
      (synopsis "Input method dictionary of pyim")
      (description "Pyim-basedict is the default pinyin input method dictionary,
containing words from the Rime project.")
      (license license:gpl2+))))

(define-public emacs-pyim
  (package
    (name "emacs-pyim")
    (version "5.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/pyim-" version ".tar"))
       (sha256
        (base32 "1s452swgbkbnpfhiwmipmvbqn6wkf6f7dq63gr349h7n29nbnnnk"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ; tests require emacs-pyim-basedict
    (propagated-inputs
     (list emacs-async emacs-xr))
    (home-page "https://github.com/tumashu/pyim")
    (synopsis "Chinese input method")
    (description
     "This package provides a Chinese input method which supports quanpin,
shuangpin, wubi and cangjie.")
    (license license:gpl2+)))

(define-public emacs-pinyinlib
  (package
    (name "emacs-pinyinlib")
    (version "0.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cute-jumper/pinyinlib.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1nwj4c3y0kdlkf3jqd2dnibaiazrq6qcj533xk2qw4wmx072yij0"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/cute-jumper/pinyinlib.el")
    (synopsis "Convert first letter of Pinyin to Chinese characters")
    (description
     "This Emacs library provides functionality for converting the first
letter of Pinyin to Simplified/Traditional Chinese characters.")
    (license license:gpl3+)))

(define-public emacs-reverse-im
  (package
    (name "emacs-reverse-im")
    (version "0.0.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/a13/reverse-im.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1h4gpyqir0kqf6a7ni8dbqwd4mr33imay0fmprrpfpfqxj0lj7c1"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/a13/reverse-im.el")
    (synopsis "Reverse mapping for non-default system layouts")
    (description
     "Reverse IM provides a minor mode that toggles translations for all input
methods from a given list.")
    (license license:gpl3+)))

(define-public emacs-cyrillic-dvorak-im
  (package
    (name "emacs-cyrillic-dvorak-im")
    (version "0.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/xFA25E/cyrillic-dvorak-im")
             (commit version)))
       (sha256
        (base32 "12adszd4p9i9glx2chasgq68i6cnxcrwbf5c268jjb5dw4q7ci0n"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (home-page "https://github.com/xFA25E/cyrillic-dvorak-im")
    (synopsis "Cyrillic input method for dvorak layout")
    (description "Cyrillic input method for dvorak layout.")
    (license license:gpl3+)))

(define-public emacs-mini-echo
  (package
    (name "emacs-mini-echo")
    (version "0.15.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/liuyinz/mini-echo.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fgh93xzf4y3fhi7nby0h1vnay78sc2hv06ai5x3j972qz5b0v5v"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-dash emacs-hide-mode-line))
    (home-page "https://github.com/liuyinz/mini-echo.el")
    (synopsis "Echo buffer status in minibuffer window")
    (description "This package lets you show buffer status in the echo area,
so you can get rid of the mode-line.")
    (license license:gpl3+)))

(define-public emacs-mini-frame
  (let ((commit "60838f3cab438dcbda8eaa15ab3e5d1af88910e9")
        (revision "0"))
    (package
      (name "emacs-mini-frame")
      (version (git-version "1.19" revision commit))
      (source
       (origin
         (uri (git-reference
               (url "https://github.com/muffinmad/emacs-mini-frame.git")
               (commit commit)))
         (method git-fetch)
         (sha256
          (base32 "0q01iymz657bg3mcmq7vcl8r0ypsa1pqj1p6gxs7ywx1d33lan4d"))
         (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (home-page "https://github.com/muffinmad/emacs-mini-frame")
      (synopsis "Show minibuffer in child frame")
      (description
       "@dfn{mini-frame-mode} adds an advice around @code{read-from-minibuffer}
to show the minibuffer as a child frame on top of the current frame.
@code{find-file} and similar functions associated mini-buffers may appear at
the center of the screen and not at the bottom.")
      (license license:gpl3+))))

(define-public emacs-posframe
  (package
    (name "emacs-posframe")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "posframe-" version ".tar"))
       (sha256
        (base32 "0yk38fc08fgxwai6dn6da9yykcmq3bd4x7msfnlrg081b15q9a32"))))
    (build-system emacs-build-system)
    ;; emacs-minimal does not include the function font-info.
    (arguments
     `(#:emacs ,emacs))
    (home-page "https://github.com/tumashu/posframe")
    (synopsis "Pop a posframe (a child frame) at point")
    (description
     "Posframe can pop a posframe at point.  A posframe is a child frame
displayed within its root window's buffer.  Posframe is fast and works well
with CJK languages.")
    (license license:gpl3+)))

(define-public emacs-el2org
  (package
    (name "emacs-el2org")
    (version "0.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tumashu/el2org")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mzddqny6wpg1fv99xrvlv7rxmaifvmy5bvj4in4pldhm4cx4q1b"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tumashu/el2org")
    (synopsis "Convert Emacs-lisp file to org file")
    (description "El2org is a simple tool, which can convert Emacs-lisp file
to org file, you can use this tool to write orgify commentary.")
    (license license:gpl2+)))

(define-public emacs-muse
  (package
    (name "emacs-muse")
    (version "3.20.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/"
                           "muse-" version ".tar"))
       (sha256
        (base32 "0g2ff6x45x2k5dnkp31sk3bjj92jyhhnar7l5hzn8vp22l0rv8wn"))))
    (build-system emacs-build-system)
    (home-page "https://www.gnu.org/software/emacs-muse")
    (synopsis "Authoring and publishing environment for Emacs")
    (description
     "Emacs Muse (also known as Muse) is an authoring and publishing
environment for Emacs.  It simplifies the process of writing documents and
publishing them to various output formats such as HTML, LaTeX, or PDF.")
    (license license:gpl3+)))

(define-public emacs-mustache
  (package
    (name "emacs-mustache")
    (version "0.23")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Wilfred/mustache.el")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1n2ymd92qpvsby6ms0l3kjhdzzc47rri2aiscc6bs07hm4mjpr9q"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command
           #~(list "emacs" "-Q" "-batch" "-L" "." "-l" "mustache-tests"
                   "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs
     (list emacs-dash emacs-ht emacs-s))
    (home-page "https://github.com/Wilfred/mustache.el")
    (synopsis "Mustache templating library for Emacs")
    (description "Mustache templating library for Emacs, mustache is
a simple web template system, which is described as a logic-less system
because it lacks any explicit control flow statements, both looping and
conditional evaluation can be achieved using section tags processing lists
and lambdas.")
    (license license:gpl3+)))

(define-public emacs-org2web
  (package
    (name "emacs-org2web")
    (version "0.9.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tumashu/org2web")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "103fzmadgd93x1y0c6xsdjx70z0jkwpvj0xnkybdancxz4ba8p9l"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'fix-byte-compilation
            ;; XXX: The fix below was integrated upstream and can be removed
            ;; in next release.
            (lambda _
              (substitute* "org2web-el2org.el"
                (("(define-obsolete-function-alias .*)\\)" _ lead)
                 (string-append lead " \"0.1\")"))))))))
    (propagated-inputs
     (list emacs-dash
           emacs-el2org
           emacs-ht
           emacs-mustache
           emacs-simple-httpd))
    (home-page "https://github.com/tumashu/org2web")
    (synopsis "Static site generator based on Org mode")
    (description "Org2web is a static site generator based on Org mode, which
code derived from Kelvin H's Org page.")
    (license license:gpl2+)))

(define-public emacs-meow
  (package
    (name "emacs-meow")
    (version "1.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/meow-edit/meow")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gfvqzp00vwbhxgp2wdcm4waba0r280dx0qbb7vpzyx93bqiplig"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/meow-edit/meow")
    (synopsis "Yet another modal editing on Emacs")
    (description "Meow is yet another modal editing mode for Emacs.  It aims
to blend modal editing into Emacs with minimum interface with its original
key-bindings, avoiding most if not all the hassle introduced by key-binding
conflicts.")
    (license license:gpl3+)))

(define-public emacs-xelb
  (package
    (name "emacs-xelb")
    (version "0.22")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-exwm/xelb")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0q6jlz9yb1ijw4pqqw9ksy1pb6qhsvslh47n9i97489qzhvms6nd"))))
    (build-system emacs-build-system)
    ;; The following functions and variables needed by emacs-xelb are
    ;; not included in emacs-minimal:
    ;; x-display-screens, x-keysym-table, x-alt-keysym, x-meta-keysym
    ;; x-hyper-keysym, x-super-keysym, libxml-parse-xml-region
    ;; x-display-pixel-width, x-display-pixel-height
    (arguments
     (list
      #:emacs emacs
      #:tests? #f                       ; no test suite
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'expand-load-path 'regenerate-el-files
            (lambda* (#:key inputs native-inputs #:allow-other-keys)
              (substitute* "xelb-gen"
                (("/usr/bin/env") (which "env")))
              (let ((xcb-proto #$(this-package-native-input "xcb-proto"))
                    (emacs (search-input-file (or native-inputs inputs)
                                              "/bin/emacs")))
                (invoke "make"
                        (format #f "PROTO_PATH=~a/share/xcb" xcb-proto))))))))
    (native-inputs (list xcb-proto))
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/emacs-exwm/xelb")
    (synopsis "X protocol Emacs Lisp binding")
    (description "@code{emacs-xelb} is a pure Emacs Lisp implementation of the
X11 protocol based on the XML description files from the XCB project.  It
features an object-oriented API and permits a certain degree of concurrency.
It should enable you to implement low-level X11 applications.")
    (license license:gpl3+)))

(define-public emacs-exwm
  (package
    (name "emacs-exwm")
    (version "0.34")
    (synopsis "Emacs X window manager")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-exwm/exwm")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "12v3f67qji3dqn7bs2kgwkbmv8l9in17d6pq0mkwc5hcd692z7zd"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-compat emacs-xelb))
    (inputs
     (list xhost dbus))
    ;; The following functions and variables needed by emacs-exwm are
    ;; not included in emacs-minimal:
    ;; scroll-bar-mode, fringe-mode
    ;; x-display-pixel-width, x-display-pixel-height
    (arguments
     (list
      #:emacs emacs
      #:tests? #f                       ;No test suite.
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'build 'install-xsession
            (lambda* (#:key inputs #:allow-other-keys)
              (let* ((xsessions (string-append #$output "/share/xsessions"))
                     (bin (string-append #$output "/bin"))
                     (exwm-executable (string-append bin "/exwm")))
                ;; Add a .desktop file to xsessions
                (mkdir-p xsessions)
                (mkdir-p bin)
                (make-desktop-entry-file
                 (string-append xsessions "/exwm.desktop")
                 #:name #$name
                 #:comment #$synopsis
                 #:exec exwm-executable
                 #:try-exec exwm-executable)
                ;; Add a shell wrapper to bin
                (with-output-to-file exwm-executable
                  (lambda _
                    (format #t "#!~a ~@
                     ~a +SI:localuser:$USER ~@
                     exec ~a --exit-with-session ~a \"$@\" --eval '~s' ~%"
                            (search-input-file inputs "/bin/sh")
                            (search-input-file inputs "/bin/xhost")
                            (search-input-file inputs "/bin/dbus-launch")
                            (search-input-file inputs "/bin/emacs")
                            '(cond
                              ((file-exists-p "~/.exwm")
                               (load-file "~/.exwm"))
                              ((not (featurep 'exwm))
                               (require 'exwm)
                               (exwm-enable)
                               (message
                                "exwm configuration not found.
Falling back to minimal configuration.
An example configuration can be found here:
https://github.com/emacs-exwm/exwm/wiki/Configuration-Example"))))))
                (chmod exwm-executable #o555)))))))
    (home-page "https://github.com/emacs-exwm/exwm")
    (description
     "EXWM is a full-featured tiling X window manager for Emacs built on top
of XELB.")
    (license license:gpl3+)))

(define-public emacs-xelb-no-x-toolkit
  (package
    (inherit emacs-xelb)
    (name "emacs-xelb-no-x-toolkit")
    (arguments
     (substitute-keyword-arguments (package-arguments emacs-xelb)
       ((#:emacs emacs) `,emacs-no-x-toolkit)))))

(define-public emacs-exwm-no-x-toolkit
  (package
    (inherit emacs-exwm)
    (name "emacs-exwm-no-x-toolkit")
    (synopsis "Emacs X window manager (without an X toolkit)")
    (propagated-inputs
     (list emacs-xelb-no-x-toolkit))
    (arguments
     (substitute-keyword-arguments (package-arguments emacs-exwm)
       ((#:emacs emacs) `,emacs-no-x-toolkit)))))

(define-public emacs-switch-window
  (package
    (name "emacs-switch-window")
    (version "1.6.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dimitri/switch-window")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0rci96asgamr6qp6nkyr5vwrnslswjxcjd96yccy4aivh0g66yfg"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/dimitri/switch-window")
    (synopsis "Emacs window switch tool")
    (description "Switch-window is an emacs window switch tool, which
offer a visual way to choose a window to switch to, delete, split or
other operations.")
    (license license:wtfpl2)))

(define-public emacs-exwm-x
  (package
    (name "emacs-exwm-x")
    (version "2.0.2")
    (synopsis "Derivative window manager based on EXWM")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tumashu/exwm-x")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0h248mma7kky30jr9bbhmp95wchl2cx5p6kh0gxmzpbc247dn2cc"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-counsel emacs-exwm emacs-switch-window emacs-use-package))
    (inputs
     (list xhost dbus))
    ;; Need emacs instead of emacs-minimal,
    ;; for emacs's bin path will be inserted into bin/exwm-x file.
    (arguments
     `(#:emacs ,emacs
       #:phases
       (modify-phases %standard-phases
         (add-after 'build 'install-xsession
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let* ((out (assoc-ref outputs "out"))
                    (xsessions (string-append out "/share/xsessions"))
                    (bin (string-append out "/bin"))
                    (exwm-executable (string-append bin "/exwm-x")))
               ;; Add a .desktop file to xsessions
               (mkdir-p xsessions)
               (mkdir-p bin)
               (with-output-to-file
                   (string-append xsessions "/exwm-x.desktop")
                 (lambda _
                   (format #t "[Desktop Entry]~@
                     Name=~a~@
                     Comment=~a~@
                     Exec=~a~@
                     TryExec=~@*~a~@
                     Type=Application~%" ,name ,synopsis exwm-executable)))
               ;; Add a shell wrapper to bin
               (with-output-to-file exwm-executable
                 (lambda _
                   (format #t "#!~a ~@
                     ~a +SI:localuser:$USER ~@
                     exec ~a --exit-with-session ~a \"$@\" --eval '~s' ~%"
                           (search-input-file inputs "/bin/sh")
                           (search-input-file inputs "/bin/xhost")
                           (search-input-file inputs "/bin/dbus-launch")
                           (search-input-file inputs "/bin/emacs")
                           '(require 'exwmx-loader))))
               (chmod exwm-executable #o555)
               #t))))))
    (home-page "https://github.com/tumashu/exwm-x")
    (description "EXWM-X is a derivative window manager based on EXWM, with focus
on mouse-control.")
    (license license:gpl3+)))

(define-public emacs-gnugo
  (package
    (name "emacs-gnugo")
    (version "3.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/gnugo-"
                           version ".tar"))
       (sha256
        (base32
         "138gzdyi8scqimvs49da66j8f5a43bhgpasn1bxzdj2zffwlwp6g"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure
           (lambda* (#:key inputs #:allow-other-keys)
             (emacs-substitute-variables "gnugo.el"
               ("gnugo-xpms" "#'gnugo-imgen-create-xpms" (as-display))
               ("gnugo-program" (search-input-file inputs "/bin/gnugo"))))))))
    (inputs (list gnugo))
    (propagated-inputs
     (list emacs-ascii-art-to-unicode emacs-xpm))
    (home-page "https://elpa.gnu.org/packages/gnugo.html")
    (synopsis "Emacs major mode for playing GNU Go")
    (description "This package provides an Emacs based interface for GNU Go,
which can be started via @samp{M-x gnugo}.  It has a graphical mode where the
board and stones are drawn using XPM images and supports the use of a mouse.
You can switch to the graphical mode by running @samp{M-x
gnugo-image-display-mode}.")
    (license license:gpl3+)))

(define-public emacs-gnuplot
  (package
    (name "emacs-gnuplot")
    (version "0.11")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/gnuplot-mode")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "17kh2mpbm5rir4bfrl2hmf8hic6v09z13y6svbf22fm0nkfvic1p"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "make" "test"
                                  ;; XXX: Do not load gnuplot-debug-context,
                                  ;; because it requires gnuplot-test-context.
                                  "LOAD=-l gnuplot -l gnuplot-context \
                                        -l gnuplot-gui -l gnuplot-tests \
                                        -l gnuplot-test-context")
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'number-tests
                 (lambda _
                   ;; variant of ert-number-tests
                   (define (gnuplot-number-tests file test-name)
                     (emacs-batch-edit-file file
                       `(let ((i 0))
                          (while (re-search-forward
                                  ,(string-append "gnuplot-test-comment "
                                                  test-name)
                                  nil t)
                            (goto-char (match-beginning 0))
                            (kill-region (match-beginning 0) (match-end 0))
                            (insert (format "gnuplot-test-comment %s-%d"
                                            ,test-name i))
                            (setq i (+ i 1)))
                          (basic-save-buffer))))
                   (gnuplot-number-tests
                    "gnuplot-tests.el"
                    "gnuplot-comment-with-single-quotes"))))))
    (home-page "https://github.com/emacsorphanage/gnuplot-mode")
    (synopsis "Emacs major mode for interacting with Gnuplot")
    (description
     "Emacs Gnuplot is an Emacs major mode for interacting with Gnuplot.")
    (license license:gpl2+)))

(define-public emacs-transpose-frame
  (package
    (name "emacs-transpose-frame")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/transpose-frame")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0m9jmfwwhgkwxbq3y000ymx7parbgqr7gq3yjm2wh1ll747gv51y"))))
    (build-system emacs-build-system)
    (home-page "https://www.emacswiki.org/emacs/TransposeFrame")
    (synopsis "Transpose window arrangement in current frame")
    (description "@code{emacs-transpose-frame} provides some interactive
functions which allows users to transpose windows arrangement in currently
selected frame.")
    (license license:bsd-2)))

(define-public emacs-transpose-mark
  ;; XXX: Upstream made no release so far, and did not add a Version keyword.
  (let ((commit "667327602004794de97214cf336ac61650ef75b7")
        (revision "0"))
    (package
      (name "emacs-transpose-mark")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/kwrooijen/transpose-mark")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "03wc50vn1kmrgnzzhs06pwpap2p2rx84wwzxw0hawsg1f1l35m2x"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/kwrooijen/transpose-mark")
      (synopsis "Library for transposing lines and regions")
      (description "Transpose mark provides some commands that makes
transposing lines and regions easier.  You can mark a line and transpose it
with a line at point, or mark a region and transpose it with another region
a point.  The plugin provides visual feedback for marked regions.")
      (license license:gpl3+))))

(define-public emacs-key-chord
  (package
    (name "emacs-key-chord")
    (version "0.8.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacsorphanage/key-chord")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1lr5vgkcn13vq0lhyxl4lvwqnmvyf3kk5fs705qrv56l2hl4k2rm"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f)) ; no tests.
    (home-page "https://www.emacswiki.org/emacs/key-chord.el")
    (synopsis "Map pairs of simultaneously pressed keys to Emacs commands")
    (description "@code{emacs-key-chord} provides @code{key-chord-mode}, a
mode for binding key chords to commands.  A key chord is defined as two keys
pressed simultaneously or a single key quickly pressed twice.")
    (license license:gpl2+)))

(define-public emacs-evil-surround
  (package
    (name "emacs-evil-surround")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-evil/evil-surround")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gfgmr4909m36gknprcam6q4rkcqfbi6w43ky7x6jnlmgb6mxggg"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-evil))
    (arguments
     `(#:test-command '("make" "test")))
    (home-page "https://github.com/emacs-evil/evil-surround")
    (synopsis "Easily modify surrounding parentheses and quotes")
    (description "@code{emacs-evil-surround} allows easy deletion, change and
addition of surrounding pairs, such as parentheses and quotes, in evil mode.")
    (license license:gpl3+)))

(define-public emacs-evil-commentary
  (package
    (name "emacs-evil-commentary")
    (version "2.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/linktohack/evil-commentary")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1l8zi9wlg1f7ffm8gh92qwk3q7h6cdl8b8zkd9hcda53mq6klpjr"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-evil))
    (home-page "https://github.com/linktohack/evil-commentary")
    (synopsis "Comment out code in evil mode")
    (description "@code{emacs-evil-commentary} adds keybindings to easily
comment out lines of code in evil mode.  It provides @code{gcc} to comment out
lines, and @code{gc} to comment out the target of a motion.")
    (license license:gpl3+)))

(define-public emacs-eglot
  (package
    (name "emacs-eglot")
    (version "1.19")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/eglot-" version
                           ".tar"))
       (sha256
        (base32
         "0bsz3grw41nh5r76brfdb4gb3hncs5chlhwsqm6qqg0ach69m7zi"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-eldoc
           emacs-external-completion
           emacs-flymake
           emacs-jsonrpc
           emacs-project
           emacs-xref))
    (home-page "https://github.com/joaotavora/eglot")
    (synopsis "Client for Language Server Protocol (LSP) servers")
    (description
     "Emacs Polyglot, or Eglot, is an Emacs @acronym{Language Server Protocol,
LSP} client that stays out of the way.  It guesses the LSP program to start
for the current file, using the major mode as a hint.  It prompts you to enter
one if it fails.")
    (license license:gpl3+)))

(define-public emacs-eglot-x
  ;; Not tagged.
  (let ((commit "8e872efd3d0b7779bde5b1e1d75c8e646a1f729f")
        (revision "1"))
    (package
      (name "emacs-eglot-x")
      (version (git-version "0.6" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/nemethf/eglot-x")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0s2p22w0b5a3b97x99qybhfgicvkzkcma6lfbi0nda54v25a8skb"))))
      (build-system emacs-build-system)
      (inputs (list emacs-eglot))
      (home-page "https://github.com/nemethf/eglot-x")
      (synopsis "Protocol extensions for Eglot")
      (description
       "This package adds support for some LSP extensions to
@code{emacs-eglot}.")
      (license license:gpl3+))))

(define-public emacs-eglot-booster
  ;; Not tagged
  (let ((commit "3f9159a8b7fe87e2f01280a2c4c98ca6dab49d13"))
    (package
      (name "emacs-eglot-booster")
      (version "0.0.2")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jdtsmith/eglot-booster")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1aq5fpfasgm5lz8hk476c1zqyj33m024nx8w9qv4qrg88y5mq5n9"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/jdtsmith/eglot-booster")
      (synopsis "Configuration to use LSP-booster with Eglot")
      (description
       "This package adds configuration to simplify using Emacs LSP booster
with Eglot.")
      (license license:gpl3+))))

(define-public emacs-jabber
  (package
    (name "emacs-jabber")
    (version "0.9.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://codeberg.org/emacs-jabber/emacs-jabber")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0ain52p79sxll0bnsb4llfp1h4pqcqx3l6im4ibia06lg2aiqhpv"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:lisp-directory "lisp"
      #:emacs emacs                   ;requires gnutls
      #:test-command #~(list "ert-runner" "../tests")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'make-info
            (lambda _
              (invoke "makeinfo" "../jabber.texi"))))))
    (native-inputs (list emacs-ert-runner texinfo))
    (propagated-inputs (list emacs-fsm emacs-srv gnutls))
    (home-page "https://codeberg.org/emacs-jabber/emacs-jabber")
    (synopsis "XMPP (Jabber) client for Emacs")
    (description
     "@code{jabber.el} is an XMPP client for Emacs.  XMPP (also known as
\"Jabber\") is an instant messaging system; see @url{https://xmpp.org} for
more information.")
    (license license:gpl2+)))

(define-public emacs-jarchive
  (package
    (name "emacs-jarchive")
    (version "0.11.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://git.sr.ht/~dannyfreeman/jarchive")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1v8a2bbjgkn95pxq8x9251znj03m5n0f6bngbf4a63pxa2il3r8n"))))
    (build-system emacs-build-system)
    (home-page "https://sr.ht/~dannyfreeman/jarchive")
    (synopsis "Jarchive teaches Emacs how to navigate to files inside JARs")
    (description "Jarchive makes Emacs handle Java and LSP URIs pointing to
 source inside JARs.")
    (license license:gpl3+)))

(define-public emacs-eldoc
  (package
    (name "emacs-eldoc")
    (version "1.16.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://elpa.gnu.org/packages/eldoc-" version ".tar"))
       (sha256
        (base32 "08dnvfyz6qkjx3fcggp628qacbxvac1agl7kgbkg6kiq4axwmifb"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/eldoc.html")
    (synopsis "Show function arglist or variable docstring in echo area")
    (description
     "This program was inspired by the behavior of the ``mouse documentation
window'' on many Lisp Machine systems; as you type a function's symbol name as
part of a sexp, it will print the argument list for that function.  Behavior
is not identical; for example, you need not actually type the function name,
you need only move point around in a sexp that calls it.  Also, if point is
over a documented variable, it will print the one-line documentation for that
variable instead, to remind you of that variable's meaning.")
    (license license:gpl3+)))

(define-public emacs-eldoc-box
  (package
    (name "emacs-eldoc-box")
    (version "1.14.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/casouri/eldoc-box")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0hk716pym15crmnviwikwrdqzhs74widjlz5zrp5107klqgxicwn"))))
    (build-system emacs-build-system)
    (arguments (list #:tests? #f))      ;no tests
    (home-page "https://github.com/casouri/eldoc-box")
    (synopsis "Childframe doc for eglot and anything that uses eldoc")
    (description
     "This package displays ElDoc documentations in a childframe.  The
childfrme is selectable and scrollable with mouse, even thought the cursor is
hidden.")
    (license license:gpl3+)))

(define-public emacs-doctest
  (let ((commit "0620ab6283a4e4302761ac415354b0b2b889dcda")
        (revision "0"))
    (package
      (name "emacs-doctest")
      (version (git-version "0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                       (url "https://github.com/ag91/doctest.git")
                       (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1g759f1ypw00vqbbcxa8yxf51bdmlrfdxybgjf4fmzzhvfbcpc4d"))))
      (build-system emacs-build-system)
      (synopsis "emacs-doctest")
      (description "This package provides doctests for emacs elisp.")
      (home-page "https://github.com/ag91/doctest")
      (license license:gpl3+))))

(define-public emacs-xtest
  (package
    (name "emacs-xtest")
    (version "1.1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/promethial/xtest")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1wqx6hlqcmqiljydih5fx89dw06g8w728pyn4iqsap8jwgjngb09"))))
    (arguments
     `(#:exclude '()))
    (build-system emacs-build-system)
    (home-page "https://github.com/promethial/xtest/")
    (synopsis "Simple testing with Emacs")
    (description "This package provides a simple testing library for Emacs.")
    (license license:gpl3+)))

(define-public emacs-org-transclusion
  (let ((commit "e6e638710e90198070c9b07ebdaa345a79f74706")) ;version bump
    (package
      (name "emacs-org-transclusion")
      (version "1.4.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/nobiot/org-transclusion")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "18v64vgr93yqx57m92hsj6s6ib315gq06dk3ib34s966iz96yi4a"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:test-command #~(list "emacs" "--batch"
                               "-l" "org-transclusion.el"
                               "-l" "test/unit-tests.el"
                               "-f" "ert-run-tests-batch-and-exit")))
      (home-page "https://nobiot.github.io/org-transclusion/")
      (synopsis "Enable transclusion with Org Mode")
      (description "Org-transclusion lets you insert a copy of text content via
a file link or ID link within an Org file.  It lets you have the same content
present in different buffers at the same time without copy-and-pasting it.
Edit the source of the content, and you can refresh the transcluded copies to
the up-to-date state.  Org-transclusion keeps your files clear of the
transcluded copies, leaving only the links to the original content.")
      (license license:gpl3+))))

(define-public emacs-disable-mouse
  (package
    (name "emacs-disable-mouse")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/purcell/disable-mouse")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0l6mai68ns3qw3rlvjvzsnqwdy7bxqiy0vdwflq0l1plxb1vazyc"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/purcell/disable-mouse")
    (synopsis "Disable mouse commands globally")
    (description
     "Provides @code{disable-mouse-mode} and @code{global-disable-mouse-mode},
pair of minor modes which suppress all mouse events by intercepting them and
running a customisable handler command (@code{ignore} by default).")
    (license license:gpl3+)))

(define-public emacs-json-reformat
  (package
    (name "emacs-json-reformat")
    (version "0.0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/gongo/json-reformat")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gaifz1brh7yh1wk1c02gddwis4ab6bggv27gy7gcd2s861f8bkx"))
       (patches (search-patches "emacs-json-reformat-fix-tests.patch"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'make-tests-writable
           (lambda _
             (for-each make-file-writable (find-files "test"))))
         (add-before 'check 'delete-json-objects-order-test
           (lambda _
             (emacs-batch-edit-file "test/json-reformat-test.el"
               `(progn (progn (goto-char (point-min))
                              (re-search-forward
                               "ert-deftest json-reformat-test:json-reformat-region")
                              (beginning-of-line)
                              (kill-sexp))
                       (basic-save-buffer)))))
         (add-before 'check 'delete-json-reformat-region-occur-error-test
           (lambda _
             (emacs-batch-edit-file "test/json-reformat-test.el"
               `(progn (goto-char (point-min))
                       (re-search-forward
                        "ert-deftest json-reformat-test:json-reformat-region-occur-error")
                       (beginning-of-line)
                       (kill-sexp)
                       (basic-save-buffer))))))))
    (native-inputs
     (list emacs-dash emacs-ert-runner emacs-shut-up))
    (propagated-inputs
     (list emacs-undercover))
    (home-page "https://github.com/gongo/json-reformat")
    (synopsis "Reformatting tool for JSON")
    (description "@code{json-reformat} provides a reformatting tool for
@url{http://json.org/, JSON}.")
    (license license:gpl3+)))

(define-public emacs-json-snatcher
  (package
    (name "emacs-json-snatcher")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Sterlingg/json-snatcher")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "05zsgnk7grgw9jzwl80h5sxfpifxlr37b4mkbvx7mjq4z14xc2jw"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/sterlingg/json-snatcher")
    (synopsis "Grabs the path to JSON values in a JSON file")
    (description "@code{emacs-json-snatcher} grabs the path to JSON values in
a @url{http://json.org/, JSON} file.")
    (license license:gpl3+)))

(define-public emacs-json-mode
  (package
    (name "emacs-json-mode")
    (version "1.9.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joshwnj/json-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16jf8nrbxgwr7a5sgx088j9ymyvh4r6hnc65nqr0vgdjb6w1h598"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-json-snatcher))
    (home-page "https://github.com/joshwnj/json-mode")
    (synopsis "Major mode for editing JSON files")
    (description "@code{json-mode} extends the builtin js-mode syntax
highlighting.")
    (license license:gpl3+)))

(define-public emacs-jsonrpc
  (package
    (name "emacs-jsonrpc")
    (version "1.0.26")
    (source
     (origin
       (method url-fetch)
       (uri (list (string-append "https://elpa.gnu.org/packages/"
                                 "jsonrpc-" version ".tar")
                  (string-append "https://elpa.gnu.org/packages/"
                                 "jsonrpc-" version ".tar.lz")))
       (sha256
        (base32 "0lsm17kak4wb9anplqlyqfy0527akb8vp2gl3lszbxh281kjg1qx"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/jsonrpc.html")
    (synopsis "JSON-RPC library")
    (description
     "This library implements the JSONRPC 2.0 specification as
described in @url{http://www.jsonrpc.org/}.  As the name suggests,
JSONRPC is a generic Remote Procedure Call protocol designed around
JSON objects.")
    (license license:gpl3+)))

(define-public emacs-jsonnet-mode
  (package
    (name "emacs-jsonnet-mode")
    (version "0.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tminor/jsonnet-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "14nxfa91yg2243v4d5kvynp2645x3811ispmhmpgil3x9qbl9jg9"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://github.com/tminor/jsonnet-mode")
    (synopsis "Major mode for editing jsonnet files")
    (description "This package provides syntax highlighting, indenting,
formatting, and utility methods for jsonnet files.")
    (license license:gpl3+)))

(define-public emacs-restclient
  (let ((commit "1fb570643b08ba66eb70831b6f874f52546917f1")
        (version "0")
        (revision "4"))               ;Guix package revision,
                                        ;upstream doesn't have official releases
    (package
      (name "emacs-restclient")
      (version (git-version version revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/pashky/restclient.el")
                      (commit commit)))
                (sha256
                 (base32
                  "0npij1p1yw4p1f1yrx6bl8q18nav5p2xvbp7qhzhn7lb2fdn5jqv"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-helm emacs-jq-mode))
      (home-page "https://github.com/pashky/restclient.el")
      (synopsis "Explore and test HTTP REST webservices")
      (description
       "This tool allows for testing and exploration of HTTP REST Web services
from within Emacs.  Restclient runs queries from a plan-text query sheet,
displays results pretty-printed in XML or JSON with @code{restclient-mode}")
      (license license:public-domain))))

(define-public emacs-jq-mode
  (package
    (name "emacs-jq-mode")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ljos/jq-mode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xk0if5i9cz4w06lx8v1vdm112pn1ybqgfw048sx15yyvfzgril1"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/ljos/jq-mode")
    (synopsis "Major mode for editing jq queries")
    (description
     "Jq mode is an Emacs major mode for editing jq-scripts.")
    (license license:gpl3+)))

(define-public emacs-whitespace-cleanup-mode
  (let ((commit "0c9b795d78e2b230c426684af59c71794f2fc8b0")
        (revision "2"))
    (package
      (name "emacs-whitespace-cleanup-mode")
      (version (git-version "0.10" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/purcell/whitespace-cleanup-mode")
                      (commit commit)))
                (sha256
                 (base32
                  "0jarh37z5ahjm493c4n0f7fm0zjd2p0isaw331gv7ybc5adfm4pl"))
                (file-name (git-file-name name version))))
      (build-system emacs-build-system)
      (arguments (list #:tests? #f)) ; no actual tests
      (home-page "https://github.com/purcell/whitespace-cleanup-mode")
      (synopsis "Intelligently call @code{whitespace-cleanup} on save")
      (description
       "This package provides a minor mode that calls
@code{whitespace-cleanup} before saving the current buffer only if the
whitespace in the buffer was initially clean.")
      (license license:gpl3+))))

(define-public emacs-eimp
  (let ((version "1.4.0")
        (commit "2e7536fe6d8f7faf1bad7a8ae37faba0162c3b4f")
        (revision "1"))
    (package
      (name "emacs-eimp")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/nicferrier/eimp")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "154d57yafxbcf39r89n5j43c86rp2fki3lw3gwy7ww2g6qkclcra"))))
      (build-system emacs-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'configure
             (lambda* (#:key inputs #:allow-other-keys)
               ;; eimp.el is read-only in git.
               (chmod "eimp.el" #o644)
               (emacs-substitute-variables "eimp.el"
                 ("eimp-mogrify-program"
                  (search-input-file inputs "bin/mogrify"))))))))
      (inputs
       (list imagemagick))
      (home-page "https://github.com/nicferrier/eimp")
      (synopsis "Interactive image manipulation utility for Emacs")
      (description "@code{emacs-eimp} allows interactive image manipulation
from within Emacs.  It uses the @code{mogrify} utility from ImageMagick to do
the actual transformations.")
      (license license:gpl2+))))

(define-public emacs-dired-hacks
  (let ((commit "d1a2bda6aa8f890cb367297ed93aee6d3b5ba388")
        (revision "3"))
    (package
      (name "emacs-dired-hacks")
      (version (git-version "0.0.1" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/Fuco1/dired-hacks")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "12m81a9kjhs4cyq3lym0vp5nx6z3sfnypyzrnia76x6rjvixjf6y"))))
      (build-system emacs-build-system)
      (propagated-inputs
       (list emacs-dash emacs-eimp emacs-f emacs-s))
      (home-page "https://github.com/Fuco1/dired-hacks")
      (synopsis
       "Collection of useful dired additions")
      (description
       "This package provides the following collection of Emacs dired mode
additions:

@itemize
@item dired-avfs
@item dired-columns
@item dired-filter
@item dired-hacks-utils
@item dired-images
@item dired-list
@item dired-narrow
@item dired-open
@item dired-rainbow
@item dired-ranger
@item dired-subtree
@item dired-tagsistant
@end itemize\n")
      (license license:gpl3+))))

(define-public emacs-dired-sidebar
  (package
    (name "emacs-dired-sidebar")
    (home-page "https://github.com/jojojames/dired-sidebar")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0f9cikyb53ybsawkm9g1sja2wsz2lmnc9zq63sx2h8d86acza2cp"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dired-hacks))
    (native-inputs (list emacs-ert-runner))
    (synopsis "Sidebar for Emacs using Dired")
    (description
     "This package provides a sidebar for Emacs similar to @code{NeoTree}
or @code{treemacs}, but leveraging @code{Dired} to do the job of display.")
    (license license:gpl3+)))

(define-public emacs-dirvish
  (package
    (name "emacs-dirvish")
    (version "2.3.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/alexluigit/dirvish")
                    (commit version)))
              (sha256
               (base32
                "1x79j3xlvhrvigh38vqhfrzqvdnpzaivbxsjzfi0pnx00y8czs5q"))
              (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f ; no actual tests
      #:phases
      #~(modify-phases %standard-phases
          ;; Move the extensions source files to the top level, which
          ;; is included in the EMACSLOADPATH.
          (add-after 'unpack 'move-source-files
            (lambda _
              (let ((el-files (find-files "./extensions" ".*\\.el$")))
                (for-each (lambda (f)
                            (rename-file f (basename f)))
                          el-files)))))))
    (propagated-inputs (list emacs-compat))
    (home-page "https://github.com/alexluigit/dirvish")
    (synopsis "Improved version of the Emacs package Dired")
    (description
     "Dirvish is an improved version of the Emacs inbuilt package Dired.  It
not only gives Dired an appealing and highly customizable user interface, but
also comes together with almost all possible parts required for full usability
as a modern file manager.")
    (license license:gpl3+)))

(define-public emacs-which-key
  (package
    (name "emacs-which-key")
    (version "3.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://elpa.gnu.org/packages/which-key-" version
                           ".tar"))
       (sha256
        (base32 "0p1vl7dnd7nsvzgsff19px9yzcw4w07qb5sb8g9r8a8slgvf3vqh"))))
    (build-system emacs-build-system)
    (home-page "https://elpa.gnu.org/packages/which-key.html")
    (synopsis "Display available keybindings in popup")
    (description
     "@code{emacs-which-key} is a minor mode for Emacs that displays the key
bindings following your currently entered incomplete command (a prefix) in a
popup.  For example, after enabling the minor mode if you enter C-x and wait
for the default of 1 second, the minibuffer will expand with all of the
available key bindings that follow C-x (or as many as space allows given your
settings).")
    (license license:gpl3+)))

;; Tagged release upstream is from before the package was orphaned.
;; The base version is extracted from the "Version" keyword in the main file
;; with "-git" suffix removed.
(define-public emacs-which-key-posframe
  (let ((commit "e4a9ce9a1b20de550fca51f14d055821980d534a")
        (revision "0"))
    (package
      (name "emacs-which-key-posframe")
      (version (git-version "0.2.0.50" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url
                       "https://github.com/emacsorphanage/which-key-posframe")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0kgc29pb5k6cb2m13cz1yhys1k8l4dpx6wjjgldpdlg9qw2i1b53"))))
      (build-system emacs-build-system)
      (propagated-inputs (list emacs-posframe emacs-which-key))
      (home-page "https://github.com/emacsorphanage/which-key-posframe")
      (synopsis "Display which-key popup in a posframe (a child frame)")
      (description
       "This package is a @code{which-key} extension, which uses posframe
(a child frame) to show @code{which-key} popups.")
      (license license:gpl3+))))

(define-public emacs-display-wttr
  (package
    (name "emacs-display-wttr")
    (version "2.1.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://git.sr.ht/~josegpt/display-wttr")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1hmawlnd2l89p48pviwn4khvjs0iry8x67cyqw70r10dd0ybn851"))))
    (build-system emacs-build-system)
    (arguments
     (list #:test-command #~(list "emacs" "--batch"
                                  "-l" "display-wttr-test.el"
                                  "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://git.sr.ht/~josegpt/display-wttr")
    (synopsis "Display wttr (weather) in the mode line")
    (description "This package contains a minor mode that can be toggled.  It
fetches weather information based on your location or on a given location from
@uref{https://wttr.in} and then displays it on the mode line.")
    (license license:gpl3+)))

(define-public emacs-ffi
  (package
    (name "emacs-ffi")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/emacs-ffi/emacs-ffi")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "05crpgscpbzkg4k0ylbfjz2wyw2r8lki8q9w2kmdpljsqrpdrwl0"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? (not (%current-target-system))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-module-load
            (lambda _
              (make-file-writable "src/ffi.el")
              (emacs-substitute-sexps "src/ffi.el"
                ("(require 'ffi-module nil t)"
                 `(module-load
                   ,(string-append #$output "/lib/ffi-module.so"))))))
          (add-before 'check 'build-emacs-module
            (lambda _
              ;; Compile the shared object file.
              (invoke "make"
                      #$(string-append "CC="
                                       (cc-for-target)))
              ;; Copy the build artifacts to root and let the install phase do
              ;; its thing
              (copy-recursively "build/lib" ".")
              ;; Install the shared object file into /lib.
              (install-file "build/lib/ffi-module.so"
                            (string-append #$output "/lib"))))
          (add-before 'install 'installinfo
            (lambda _
              (install-file "build/doc/emacs-ffi.info"
                            (string-append #$output "/share/info")))))))
    (inputs (list emacs-compat libltdl libffi))
    (native-inputs (list texinfo))
    (home-page "https://emacs-ffi.github.io/emacs-ffi/")
    (synopsis "FFI for Emacs based on libffi")
    (description
     "This package provides an FFI for Emacs.  It is based on
libffi and relies on the dynamic module support in order to be loaded into
Emacs.  It is relatively full-featured, but for the time being low-level.")
    (license license:gpl3+)))

(define-public emacs-free-keys
  (package
    (name "emacs-free-keys")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/Fuco1/free-keys")
         (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xgifa7s9n882f9ymyyz9gc11xfbj3vfpnxiq1fqfm5hmwx9pwbc"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/Fuco1/free-keys")
    (synopsis "Show free keybindings for modkeys or prefixes in Emacs")
    (description
     "Free-keys shows available key bindings in the current Emacs buffer.")
    (license license:gpl3+)))

(define-public emacs-hercules
  (package
    (name "emacs-hercules")
    (version "0.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/jjzmajic/hercules.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1rp37rhkj8jm07dwr74vc68dhrbvyvrxjdavpb0h073ps9vl9dsc"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-which-key))
    (home-page "https://gitlab.com/jjzmajic/hercules.el")
    (synopsis "Call a chain of related commands without repeated prefix keys")
    (description
     "This package provides sticky-key-like functionality to obviate the need
for repeated prefix-key sequences, and can reuse existing keymaps.  The list
of commands is displayed in a handy popup.")
    (license license:gpl3+)))

(define-public emacs-ws-butler
  (let ((commit "9ee5a7657a22e836618813c2e2b64a548d27d2ff")
        (revision "0"))
    (package
      (name "emacs-ws-butler")
      (version (git-version "1.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://git.savannah.gnu.org/git/emacs/nongnu")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0ivpgib2bxv7x6cp04mj8crc1a60d7c77jcc59sj14scq4jqbmjb"))))
      (build-system emacs-build-system)
      (arguments (list #:test-command
                       #~(list "emacs" "--batch" "-L" "."
                               "-l" "tests/run-test.el")))
      (home-page "https://elpa.nongnu.org/nongnu/ws-butler.html")
      (synopsis "Unobtrusively remove trailing whitespace")
      (description
       "ws-butler automatically trims trailing whitespace characters on save.
In contrast with other whitespace cleanup solutions, only modified lines are
trimmed.")
      (license license:gpl3+))))

(define-public emacs-opencl-mode
  (package
    (name "emacs-opencl-mode")
    (version "2.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/salmanebah/opencl-mode")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32 "1x3h187r7waibrx5llsk6irb5afhqsrddb1f9hm3f9saks6n1ldv"))))
    (build-system emacs-build-system)
    (synopsis "Emacs major mode for editing OpenCL kernels")
    (description "This Emacs package provides the @code{opencl-mode} major
mode for editing OpenCL kernels.  It supports syntax highlighting and online
access to the OpenCL documentation through the @code{opencl-lookup} function.")
    (home-page "https://github.com/salmanebah/opencl-mode")
    (license license:gpl3+)))

(define-public emacs-openwith
  ;; There is no release tag. Version is extracted from main file.
  (let ((version "20120531")
        (revision "0")
        (commit "5fe01dee520d24c839ad5ee18822667457d9f352"))
    (package
      (name "emacs-openwith")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/garberw/openwith")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1scbawhlzmj5nhix779rlqf462g37q84vpq205qhg4qyscvfx6bi"))))
      (build-system emacs-build-system)
      (home-page "https://github.com/garberw/openwith")
      (synopsis "Open external applications for files with Emacs")
      (description
       "This package enables you to associate file name patterns with external
applications that are automatically invoked when you use commands like
@code{find-file}.  For example, you can have it open @code{png} files with
@code{feh} and @code{mp4} files with @code{mpv}.  This is especially useful
when browsing files with Dired.")
      (license license:gpl2+))))

(define-public emacs-org-edit-latex
  (package
    (name "emacs-org-edit-latex")
    (version "0.8.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/et2010/org-edit-latex")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1w0lyz71dq8x28ira4hig1b70bqn1dr53w3k5dgch9szcf6xa86y"))))
    (build-system emacs-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'set-home
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list emacs-auctex emacs-org))
    (home-page "https://github.com/et2010/org-edit-latex")
    (synopsis "Edit a LaTeX fragment just like editing a source block")
    (description
     "Org Edit LaTeX is an extension for Org mode.  It lets you edit a LaTeX
fragment in a dedicated buffer just like editing a source block.")
    (license license:gpl3+)))

(define-public emacs-emamux
  (package
    (name "emacs-emamux")
    (version "0.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-emamux")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "19y69qw79miim9cz5ji54gwspjkcp9g2c1xr5s7jj2fiabnxax6b"))))
    (build-system emacs-build-system)
    (arguments (list #:test-command
                     #~(list "emacs" "--batch" "-L" "."
                             "-l" "test/emamux-test.el"
                             "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/syohex/emacs-emamux")
    (synopsis "Manipulate Tmux from Emacs")
    (description
     "@code{emacs-emamux} lets Emacs interact with the @code{tmux} terminal
multiplexer.")
    (license license:gpl3+)))

(define-public emacs-plz
  (package
    (name "emacs-plz")
    (version "0.9.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alphapapa/plz.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1xigrw84wbkr8ny6apfq1a8rws198my4ycr3grdwk5mvdx75h5qr"))))
    (build-system emacs-build-system)
    (inputs (list curl))
    (arguments
     (list
      #:tests? #f                       ;require internet access
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'substitute-curl-path
            (lambda* (#:key inputs #:allow-other-keys)
              (emacs-substitute-variables "plz.el"
                ("plz-curl-program" (search-input-file inputs "/bin/curl"))))))))
    (home-page "https://github.com/alphapapa/plz.el")
    (synopsis "HTTP library for Emacs")
    (description
     "This package provides HTTP library for Emacs.  It uses Curl as a backend,
which avoids some of the issues with using Emacs’s built-in Url library.")
    (license license:gpl3+)))

(define-public emacs-plz-media-type
  (package
    (name "emacs-plz-media-type")
    (version "0.2.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/r0man/plz-media-type")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1g9j12p8ifkp2k0lss5nx3mr1nfjsakj4d3mcq9gvzgj7qg8aw2d"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-plz))
    (arguments (list #:tests? #f))
    (home-page "https://github.com/r0man/plz-media-type")
    (synopsis "HTTP media type extension for plz.el")
    (description
     "The @code{plz-media-type} library enhances MIME type handling for HTTP
requests within Emacs.  It leverages the Plz HTTP library for networking calls
and introduces a mechanism to process responses based on the content type
header.  This library defines various classes and methods for parsing and
processing standard MIME types, including JSON, XML, HTML, and binary data, in
a streaming and non-streaming way.")
    (license license:gpl3+)))

(define-public emacs-plz-event-source
  (package
    (name "emacs-plz-event-source")
    (version "0.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/r0man/plz-event-source")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1bh61gcnznvcs0dmqpai5pnxkapdcgb51d5zjqvzvpr2i84cwgv9"))))
    (build-system emacs-build-system)
    (propagated-inputs (list emacs-plz-media-type))
    (arguments (list #:tests? #f))
    (home-page "https://github.com/r0man/plz-event-source")
    (synopsis "Server Sent Events extension for Plz")
    (description
     "The @code{plz-event-source} library provides a @code{plz-media-type},
a parser, and an event source implementation for the @acronym{SSE, Server Sent
Event} protocol.")
    (license license:gpl3+)))

(define-public emacs-ement
  (package
    (name "emacs-ement")
    (version "0.17")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alphapapa/ement.el")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1i0wxqz371qp80l5a0jma6pbz2zb1h36ki9bjlvrifs30wzyv6am"))))
    (build-system emacs-build-system)
    (arguments
     (list #:emacs emacs              ;need libxml support
           #:test-command #~(list "emacs" "--batch"
                                  "-l" "tests/ement-tests.el"
                                  "-f" "ert-run-tests-batch-and-exit")))
    (propagated-inputs
     (list emacs-persist
           emacs-plz
           emacs-svg-lib
           emacs-taxy
           emacs-taxy-magit-section
           emacs-ts))
    (home-page "https://github.com/alphapapa/ement.el")
    (synopsis "Matrix client for Emacs")
    (description "Ement.el is a Matrix client for Emacs.")
    (license license:gpl3+)))

(define-public emacs-rpm-spec-mode
  (let ((commit "c1c38050c48ea330c7cea632b8785d66daeefb2b")
        (revision "0"))
    (package
      (name "emacs-rpm-spec-mode")
      (version (git-version "0.16" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/stigbjorlykke/rpm-spec-mode")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0427kcvf2ljhzwxskn3jzk0ncrl3f9zcz2sm83d9pmhh5jax2gch"))))
      (build-system emacs-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'adjust-for-emacs-28
              (lambda _
                ;; Since Emacs 28, define-obsolete-variable-alias require a
                ;; 3rd argument to specify when the deprecation was
                ;; introduced.
                ;; The rpm-spec-mode.el file is encoded in ISO-8859-1 (iso-latin-1).
                (with-fluids ((%default-port-encoding "ISO-8859-1"))
                  (substitute* "rpm-spec-mode.el"
                    (("'rpm-spec-completion-ignore-case" all)
                     (string-append all " \"0.12\""))
                    (("'rpm-spec-nobuild" all)
                     (string-append all " \"0.12\""))
                    (("'rpm-spec-initialize-sections" all)
                     (string-append all " \"0.12\""))
                    (("'rpm-spec-insert-changelog-version" all)
                     (string-append all " \"0.12\"")))))))))
      (home-page "https://github.com/stigbjorlykke/rpm-spec-mode")
      (synopsis "Emacs major mode for editing RPM spec files")
      (description "@code{emacs-rpm-spec-mode} provides an Emacs major mode for
editing RPM spec files.")
      (license license:gpl2+))))

(define-public emacs-lcr
  (package
    (name "emacs-lcr")
    (version "1.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jyp/lcr")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hhn0gqkwki0dfk6j759hmbj1ijn4bs550jh3kgy9jfmnb7cd81l"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash))
    (home-page "https://github.com/jyp/lcr")
    (synopsis "Lightweight coroutines in Emacs Lisp")
    (description "This package provides macros that can translate code into
equivalent continuation-passing code, as well as miscellaneous utility
functions written in continuation-passing style.")
    (license license:gpl3+)))

(define-public emacs-attrap
  (package
    (name "emacs-attrap")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jyp/attrap")
             (commit version)))
       (sha256
        (base32 "0wqc7bqx9rvk8r7fd3x84h8p01v97s6w2jf29nnjb59xakwp22i7"))
       (file-name (git-file-name name version))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-dash emacs-f emacs-flycheck emacs-s))
    (home-page "https://github.com/jyp/attrap")
    (synopsis "Fix coding error at point")
    (description "This package provides a command to fix the Flycheck error
at point.")
    (license license:gpl3+)))

(define-public emacs-git-messenger
  (package
    (name "emacs-git-messenger")
    (version "0.18")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syohex/emacs-git-messenger")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "04fnby2nblk8l70gv09asxkmnn53fh1pdfs77ix44npp99fyw8ix"))))
    (build-system emacs-build-system)
    (propagated-inputs
     (list emacs-popup))
    (arguments
     `(#:test-command '("emacs" "--batch" "-l" "test/test.el"
                        "-f" "ert-run-tests-batch-and-exit")))
    (home-page "https://github.com/syohex/emacs-git-messenger")
    (synopsis "Popup commit message at current line")
    (description "@code{emacs-git-messenger} provides
@code{git-messenger:popup-message}, a function that when called, will popup
the last git commit message for the current line.  This uses git-blame
internally.")
    (license license:gpl3+)))

(define-public emacs-gitpatch
  (package
    (name "emacs-gitpatch")
    (version "0.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tumashu/gitpatch")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1drf4fvmak7brf16axkh4nfz8pg44i7pjhfjz3dbkycbpp8y5vig"))))
    (build-system emacs-build-system)
    (home-page "https://github.com/tumashu/gitpatch")
    (synopsis "Mail git patch from Emacs")
    (description "@code{emacs-gitpatch} lets users easily send git patches,
created by @code{git format-patch}, from @code{magit}, @code{dired} and
@code{ibuffer} buffers.")
    (license license:gpl3+)))

(define-public emacs-git-email
  (package
    (name "emacs-git-email")
    (version "0.7.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/suhail/git-email")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0p8c449nvn77bxmq1pinpw47lx6gj1k08yrxgi8bc8xrwkni9glp"))))
    (build-system emacs-build-system)
    (arguments
     (list
      #:tests? #f ; Makefile but no tests.
      #:phases #~(modify-phases %standard-phases
                   (add-before 'install 'makeinfo
                     (lambda _
                       (invoke "makeinfo" "doc/git-email.texi"))))))
    (inputs (list mu emacs-magit emacs-notmuch emacs-piem))
    (native-inputs (list texinfo))
    (license license:gpl3+)
    (home-page "https://suhail.codeberg.page/git-email")
    (synopsis "Format and send Git patches in Emacs")
    (description "This package provides utilities for formatting and
sending Git patches via Email, without leaving Emacs.")))

(define-public emacs-erc-hl-nicks
  (package
    (name "emacs-erc-hl-nicks")
    (version "1.3.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/leathekd/erc-hl-nicks")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0k57scxa8rm859fqsm8srhps7rlq06jzazhjbwnadzrh8i5fyvra"))))
    (build-system emacs-build-system)
    (synopsis "Nickname highlighting for Emacs ERC")
    (description "@code{erc-hl-nicks} highlights nicknames in ERC, an IRC
client for Emacs.  The main features are:
@itemize
@item Auto-colorizes nicknames without having to specify colors
@item Ignores certain characters that IRC clients add to nicknames to avoid
duplicates (nickname, nickname’, nickname\", etc.)
@item Attempts to produce colors with a sufficient amount of contrast between
the nick color and the background color
@end itemize\n")
    (home-page "https://github.com/leathekd/erc-hl-nicks")
    (license license:gpl3+)))

(define-public emacs-engine-mode
  (package
    (name "emacs-engine-mode")
    (version "2.2.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
   