package Devscripts::Uscan::Templates::Github;

use strict;

sub transform {
    my $watchSource = shift;
    delete $watchSource->{template};
    my $owner   = delete $watchSource->{owner};
    my $project = delete $watchSource->{project};
    die 'Missing owner'   unless $owner;
    die 'Missing project' unless $project;

    $watchSource->{source}
      ||= "https://api.github.com/repos/$owner/$project/git/matching-refs/"
      . ($watchSource->{releaseonly} ? 'release/' : 'tags/');
    $watchSource->{matchingpattern}
      ||= 'https://api.github.com/repos/[^/]+/[^/]+/git/refs/tags/(?>[^/]+(?<=(?:\D|alpha|beta|rc))\-)?'
      . $watchSource->{versiontype}
      . '(?:(?=")|$)';
    $watchSource->{downloadurlmangle}
      ||= 's%(api.github.com/repos/[^/]+/[^/]+)/git/refs/%$1/tarball/refs/%g';
    $watchSource->{filenamemangle} ||= (
        $watchSource->{component}
        ? 's%.*/(?:[^/]+(?<=(?:\D|alpha|beta|rc))\-)?@ANY_VERSION@%@PACKAGE@-@COMPONENT@-$1.tar.gz%'
        : 's%.*/(?:[^/]+(?<=(?:\D|alpha|beta|rc))\-)?@ANY_VERSION@%@PACKAGE@-$1.tar.gz%'
    );
    $watchSource->{searchmode} ||= 'plain';
    $watchSource->{pgpmode}    ||= 'none';
    return $watchSource;
}

1;
