# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from azure.ai.transcription import TranscriptionClient
from devtools_testutils import AzureRecordedTestCase, PowerShellPreparer
import functools


class TranscriptionClientTestBase(AzureRecordedTestCase):

    def create_client(self, endpoint):
        credential = self.get_credential(TranscriptionClient)
        return self.create_client_from_credential(
            TranscriptionClient,
            credential=credential,
            endpoint=endpoint,
        )


TranscriptionPreparer = functools.partial(
    PowerShellPreparer, "transcription", transcription_endpoint="https://fake_transcription_endpoint.com"
)
