# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementWorkspaceBackendOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_backend_list_by_workspace(self, resource_group):
        response = self.client.workspace_backend.list_by_workspace(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_backend_get_entity_tag(self, resource_group):
        response = self.client.workspace_backend.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            backend_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_backend_get(self, resource_group):
        response = self.client.workspace_backend.get(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            backend_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_backend_create_or_update(self, resource_group):
        response = self.client.workspace_backend.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            backend_id="str",
            parameters={
                "circuitBreaker": {
                    "rules": [
                        {
                            "acceptRetryAfter": bool,
                            "failureCondition": {
                                "count": 0,
                                "errorReasons": ["str"],
                                "interval": "1 day, 0:00:00",
                                "percentage": 0,
                                "statusCodeRanges": [{"max": 0, "min": 0}],
                            },
                            "name": "str",
                            "tripDuration": "1 day, 0:00:00",
                        }
                    ]
                },
                "credentials": {
                    "authorization": {"parameter": "str", "scheme": "str"},
                    "certificate": ["str"],
                    "certificateIds": ["str"],
                    "header": {"str": ["str"]},
                    "query": {"str": ["str"]},
                },
                "description": "str",
                "id": "str",
                "name": "str",
                "pool": {"services": [{"id": "str", "priority": 0, "weight": 0}]},
                "properties": {
                    "serviceFabricCluster": {
                        "managementEndpoints": ["str"],
                        "clientCertificateId": "str",
                        "clientCertificatethumbprint": "str",
                        "maxPartitionResolutionRetries": 0,
                        "serverCertificateThumbprints": ["str"],
                        "serverX509Names": [{"issuerCertificateThumbprint": "str", "name": "str"}],
                    }
                },
                "protocol": "str",
                "proxy": {"url": "str", "password": "str", "username": "str"},
                "resourceId": "str",
                "title": "str",
                "tls": {"validateCertificateChain": True, "validateCertificateName": True},
                "type": "str",
                "url": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_backend_update(self, resource_group):
        response = self.client.workspace_backend.update(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            backend_id="str",
            if_match="str",
            parameters={
                "circuitBreaker": {
                    "rules": [
                        {
                            "acceptRetryAfter": bool,
                            "failureCondition": {
                                "count": 0,
                                "errorReasons": ["str"],
                                "interval": "1 day, 0:00:00",
                                "percentage": 0,
                                "statusCodeRanges": [{"max": 0, "min": 0}],
                            },
                            "name": "str",
                            "tripDuration": "1 day, 0:00:00",
                        }
                    ]
                },
                "credentials": {
                    "authorization": {"parameter": "str", "scheme": "str"},
                    "certificate": ["str"],
                    "certificateIds": ["str"],
                    "header": {"str": ["str"]},
                    "query": {"str": ["str"]},
                },
                "description": "str",
                "pool": {"services": [{"id": "str", "priority": 0, "weight": 0}]},
                "properties": {
                    "serviceFabricCluster": {
                        "managementEndpoints": ["str"],
                        "clientCertificateId": "str",
                        "clientCertificatethumbprint": "str",
                        "maxPartitionResolutionRetries": 0,
                        "serverCertificateThumbprints": ["str"],
                        "serverX509Names": [{"issuerCertificateThumbprint": "str", "name": "str"}],
                    }
                },
                "protocol": "str",
                "proxy": {"url": "str", "password": "str", "username": "str"},
                "resourceId": "str",
                "title": "str",
                "tls": {"validateCertificateChain": True, "validateCertificateName": True},
                "type": "str",
                "url": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_workspace_backend_delete(self, resource_group):
        response = self.client.workspace_backend.delete(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            backend_id="str",
            if_match="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
