"""remove ws from agents and make schedule multiworkspaces

Revision ID: f82a9136c408
Revises: 384784872dc1
Create Date: 2022-06-15 13:14:49.442283+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'f82a9136c408'
down_revision = '384784872dc1'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('agents_schedule_workspace_table',
    sa.Column('workspace_id', sa.Integer(), nullable=True),
    sa.Column('agents_schedule_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['agents_schedule_id'], ['agent_schedule.id'], ),
    sa.ForeignKeyConstraint(['workspace_id'], ['workspace.id'], )
    )
    op.add_column('agent_schedule', sa.Column('ignore_info', sa.Boolean(), nullable=True))
    op.add_column('agent_schedule', sa.Column('resolve_hostname', sa.Boolean(), nullable=True))
    op.drop_table('association_workspace_and_agents_table')
    op.execute("DROP INDEX IF EXISTS ix_agent_schedule_workspace_id")
    op.execute("ALTER TABLE agent_schedule DROP CONSTRAINT IF EXISTS agent_schedule_workspace_id_fkey")
    op.drop_column('agent_schedule', 'workspace_id')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('agent_schedule', sa.Column('workspace_id', sa.INTEGER(), autoincrement=False, nullable=False))
    op.create_foreign_key('agent_schedule_workspace_id_fkey', 'agent_schedule', 'workspace', ['workspace_id'], ['id'])
    op.create_index('ix_agent_schedule_workspace_id', 'agent_schedule', ['workspace_id'], unique=False)
    op.create_table('association_workspace_and_agents_table',
    sa.Column('workspace_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('agent_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['agent_id'], ['agent.id'], name='association_workspace_and_agents_table_agent_id_fkey', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['workspace_id'], ['workspace.id'], name='association_workspace_and_agents_table_workspace_id_fkey')
    )
    op.drop_column('agent_schedule', 'resolve_hostname')
    op.drop_column('agent_schedule', 'ignore_info')
    op.drop_table('agents_schedule_workspace_table')
    # ### end Alembic commands ###
