# Copyright (c) 2006-2025 Broadcom. All Rights Reserved.
# Broadcom Confidential. The term "Broadcom" refers to Broadcom Inc.
# and/or its subsidiaries.

# ******* WARNING - AUTO GENERATED CODE - DO NOT EDIT *******

from typing import NoReturn
from typing import Optional

from pyVmomi.VmomiSupport import ManagedObject
from pyVmomi.VmomiSupport import long

from pyVmomi.vim import Datastore
from pyVmomi.vim import Task

from pyVmomi.vmodl import DynamicData
from pyVmomi.vmodl import MethodFault

from pyVmomi.vim.host import NasVolume
from pyVmomi.vim.host import ScsiDisk
from pyVmomi.vim.host import UnresolvedVmfsResignatureSpec
from pyVmomi.vim.host import UnresolvedVmfsVolume
from pyVmomi.vim.host import VmfsDatastoreCreateSpec
from pyVmomi.vim.host import VmfsDatastoreExpandSpec
from pyVmomi.vim.host import VmfsDatastoreExtendSpec
from pyVmomi.vim.host import VmfsDatastoreOption

class DatastoreSystem(ManagedObject):
   class Capabilities(DynamicData):
      nfsMountCreationRequired: bool
      nfsMountCreationSupported: bool
      localDatastoreSupported: bool
      vmfsExtentExpansionSupported: bool

   class VvolDatastoreSpec(DynamicData):
      name: str
      scId: str

   class DatastoreResult(DynamicData):
      key: Datastore
      fault: Optional[MethodFault] = None

   @property
   def datastore(self) -> list[Datastore]: ...
   @property
   def capabilities(self) -> Capabilities: ...

   def UpdateLocalSwapDatastore(self, datastore: Optional[Datastore]) -> NoReturn: ...
   def QueryAvailableDisksForVmfs(self, datastore: Optional[Datastore]) -> list[ScsiDisk]: ...
   def QueryVmfsDatastoreCreateOptions(self, devicePath: str, vmfsMajorVersion: Optional[int]) -> list[VmfsDatastoreOption]: ...
   def CreateVmfsDatastore(self, spec: VmfsDatastoreCreateSpec) -> Datastore: ...
   def QueryVmfsDatastoreExtendOptions(self, datastore: Datastore, devicePath: str, suppressExpandCandidates: Optional[bool]) -> list[VmfsDatastoreOption]: ...
   def QueryVmfsDatastoreExpandOptions(self, datastore: Datastore) -> list[VmfsDatastoreOption]: ...
   def ExtendVmfsDatastore(self, datastore: Datastore, spec: VmfsDatastoreExtendSpec) -> Datastore: ...
   def EnableClusteredVmdkSupport(self, datastore: Datastore) -> NoReturn: ...
   def DisableClusteredVmdkSupport(self, datastore: Datastore) -> NoReturn: ...
   def ExpandVmfsDatastore(self, datastore: Datastore, spec: VmfsDatastoreExpandSpec) -> Datastore: ...
   def CreateNasDatastore(self, spec: NasVolume.Specification) -> Datastore: ...
   def CreateLocalDatastore(self, name: str, path: str) -> Datastore: ...
   def CreateVvolDatastore(self, spec: VvolDatastoreSpec) -> Datastore: ...
   def RemoveDatastore(self, datastore: Datastore) -> NoReturn: ...
   def SetMaxQueueDepth(self, datastore: Datastore, maxQdepth: long) -> NoReturn: ...
   def QueryMaxQueueDepth(self, datastore: Datastore) -> long: ...
   def RemoveDatastoreEx(self, datastore: list[Datastore]) -> Task: ...
   def ConfigureDatastorePrincipal(self, userName: str, password: Optional[str]) -> NoReturn: ...
   def QueryUnresolvedVmfsVolumes(self) -> list[UnresolvedVmfsVolume]: ...
   def ResignatureUnresolvedVmfsVolume(self, resolutionSpec: UnresolvedVmfsResignatureSpec) -> Task: ...
