/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLObject;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class AreaFunction
extends GeometryFunction {
    public static final LanguageFeature FEATURE = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo", "AREA", true, "Compute the area (in square degrees) of a given geometry. Note: AREA of a POINT is always zero.");
    private GeometryFunction.GeometryValue<GeometryFunction> parameter;

    public AreaFunction(GeometryFunction.GeometryValue<GeometryFunction> param) throws NullPointerException {
        if (param == null) {
            throw new NullPointerException("The only parameter of an AREA function must be different from NULL!");
        }
        if (!(param instanceof GeometryFunction.GeometryValue)) {
            throw new NullPointerException("The ADQL function AREA must have one geometric parameter (a GeometryValue)!");
        }
        this.parameter = param;
    }

    public AreaFunction(AreaFunction toCopy) throws Exception {
        this.parameter = (GeometryFunction.GeometryValue)toCopy.parameter.getCopy();
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    public final GeometryFunction.GeometryValue<GeometryFunction> getParameter() {
        return this.parameter;
    }

    public final void setParameter(GeometryFunction.GeometryValue<GeometryFunction> parameter) {
        this.parameter = parameter;
        this.setPosition(null);
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new AreaFunction(this);
    }

    @Override
    public String getName() {
        return "AREA";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.parameter.getValue()};
    }

    @Override
    public int getNbParameters() {
        return 1;
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (index == 0) {
            return this.parameter.getValue();
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (index == 0) {
            ADQLOperand replaced = this.parameter.getValue();
            if (replacer == null) {
                throw new NullPointerException("");
            }
            if (replacer instanceof GeometryFunction.GeometryValue) {
                this.parameter = (GeometryFunction.GeometryValue)replacer;
            } else if (replacer instanceof ADQLColumn) {
                this.parameter.setColumn((ADQLColumn)replacer);
            } else if (replacer instanceof GeometryFunction) {
                this.parameter.setGeometry((GeometryFunction)replacer);
            } else {
                throw new Exception("Impossible to replace a GeometryValue/Column/GeometryFunction by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
            }
            this.setPosition(null);
            return replaced;
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
    }
}

