#!/usr/bin/perl -w

# ICC::Profile::para test module / 2018-08-31
#
# Copyright © 2004-2018 by William B. Birkett

use strict;

use File::Spec;
use File::Temp;
use t::lib::Boot;
use Test::More tests => 6;

# local variables
my ($profile, $tag, $temp, $raw1, $raw2);

# does module load
BEGIN { use_ok('ICC::Profile::para') };

# test class methods
can_ok('ICC::Profile::para', qw(new new_fh write_fh size inverse derivative transform parametric array sdump));

# make empty para object
$tag = ICC::Profile::para->new;

# test object class
isa_ok($tag, 'ICC::Profile::para');

# read eciRGB_v2_ICCv4 profile
$profile = t::lib::Boot->new(File::Spec->catfile('t', 'data', 'eciRGB_v2_ICCv4.icc'));

# read 'rTRC' tag
$tag = ICC::Profile::para->new_fh($profile, $profile->fh, $profile->tag_table->[3]);

# test object class
isa_ok($tag, 'ICC::Profile::para');

# test size method
ok($tag->size == $profile->tag_table->[3][2], 'tag size');

# open temporary file for write-read access, binmode
$temp = File::Temp::tempfile();

# write tag to temporary file
$tag->write_fh($profile, $temp, $profile->tag_table->[3]);

# flush buffer
$temp->flush;

# read profile raw data
seek($profile->fh, $profile->tag_table->[3][1], 0);
read($profile->fh, $raw1, $tag->size);

# read temporary raw data
seek($temp, $profile->tag_table->[3][1], 0);
read($temp, $raw2, $tag->size);

# test raw data round-trip integrity
ok($raw1 eq $raw2, 'raw data round-trip');

# close files
close($profile->fh);
close($temp);

##### more tests needed ######


