/* -*- buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
 *    2007, 2008 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *  This file is built by opcode.pl from its data.  Any changes made here
 *  will be lost!
 */

typedef enum opcode {
	OP_NULL,	/* 0 */
	OP_STUB,	/* 1 */
	OP_SCALAR,	/* 2 */
	OP_PUSHMARK,	/* 3 */
	OP_WANTARRAY,	/* 4 */
	OP_CONST,	/* 5 */
	OP_GVSV,	/* 6 */
	OP_GV,		/* 7 */
	OP_GELEM,	/* 8 */
	OP_PADSV,	/* 9 */
	OP_PADAV,	/* 10 */
	OP_PADHV,	/* 11 */
	OP_PADANY,	/* 12 */
	OP_PUSHRE,	/* 13 */
	OP_RV2GV,	/* 14 */
	OP_RV2SV,	/* 15 */
	OP_AV2ARYLEN,	/* 16 */
	OP_RV2CV,	/* 17 */
	OP_ANONCODE,	/* 18 */
	OP_PROTOTYPE,	/* 19 */
	OP_REFGEN,	/* 20 */
	OP_SREFGEN,	/* 21 */
	OP_REF,		/* 22 */
	OP_BLESS,	/* 23 */
	OP_BACKTICK,	/* 24 */
	OP_GLOB,	/* 25 */
	OP_READLINE,	/* 26 */
	OP_RCATLINE,	/* 27 */
	OP_REGCMAYBE,	/* 28 */
	OP_REGCRESET,	/* 29 */
	OP_REGCOMP,	/* 30 */
	OP_MATCH,	/* 31 */
	OP_QR,		/* 32 */
	OP_SUBST,	/* 33 */
	OP_SUBSTCONT,	/* 34 */
	OP_TRANS,	/* 35 */
	OP_SASSIGN,	/* 36 */
	OP_AASSIGN,	/* 37 */
	OP_CHOP,	/* 38 */
	OP_SCHOP,	/* 39 */
	OP_CHOMP,	/* 40 */
	OP_SCHOMP,	/* 41 */
	OP_DEFINED,	/* 42 */
	OP_UNDEF,	/* 43 */
	OP_STUDY,	/* 44 */
	OP_POS,		/* 45 */
	OP_PREINC,	/* 46 */
	OP_I_PREINC,	/* 47 */
	OP_PREDEC,	/* 48 */
	OP_I_PREDEC,	/* 49 */
	OP_POSTINC,	/* 50 */
	OP_I_POSTINC,	/* 51 */
	OP_POSTDEC,	/* 52 */
	OP_I_POSTDEC,	/* 53 */
	OP_POW,		/* 54 */
	OP_MULTIPLY,	/* 55 */
	OP_I_MULTIPLY,	/* 56 */
	OP_DIVIDE,	/* 57 */
	OP_I_DIVIDE,	/* 58 */
	OP_MODULO,	/* 59 */
	OP_I_MODULO,	/* 60 */
	OP_REPEAT,	/* 61 */
	OP_ADD,		/* 62 */
	OP_I_ADD,	/* 63 */
	OP_SUBTRACT,	/* 64 */
	OP_I_SUBTRACT,	/* 65 */
	OP_CONCAT,	/* 66 */
	OP_STRINGIFY,	/* 67 */
	OP_LEFT_SHIFT,	/* 68 */
	OP_RIGHT_SHIFT,	/* 69 */
	OP_LT,		/* 70 */
	OP_I_LT,	/* 71 */
	OP_GT,		/* 72 */
	OP_I_GT,	/* 73 */
	OP_LE,		/* 74 */
	OP_I_LE,	/* 75 */
	OP_GE,		/* 76 */
	OP_I_GE,	/* 77 */
	OP_EQ,		/* 78 */
	OP_I_EQ,	/* 79 */
	OP_NE,		/* 80 */
	OP_I_NE,	/* 81 */
	OP_NCMP,	/* 82 */
	OP_I_NCMP,	/* 83 */
	OP_SLT,		/* 84 */
	OP_SGT,		/* 85 */
	OP_SLE,		/* 86 */
	OP_SGE,		/* 87 */
	OP_SEQ,		/* 88 */
	OP_SNE,		/* 89 */
	OP_SCMP,	/* 90 */
	OP_BIT_AND,	/* 91 */
	OP_BIT_XOR,	/* 92 */
	OP_BIT_OR,	/* 93 */
	OP_NEGATE,	/* 94 */
	OP_I_NEGATE,	/* 95 */
	OP_NOT,		/* 96 */
	OP_COMPLEMENT,	/* 97 */
	OP_SMARTMATCH,	/* 98 */
	OP_ATAN2,	/* 99 */
	OP_SIN,		/* 100 */
	OP_COS,		/* 101 */
	OP_RAND,	/* 102 */
	OP_SRAND,	/* 103 */
	OP_EXP,		/* 104 */
	OP_LOG,		/* 105 */
	OP_SQRT,	/* 106 */
	OP_INT,		/* 107 */
	OP_HEX,		/* 108 */
	OP_OCT,		/* 109 */
	OP_ABS,		/* 110 */
	OP_LENGTH,	/* 111 */
	OP_SUBSTR,	/* 112 */
	OP_VEC,		/* 113 */
	OP_INDEX,	/* 114 */
	OP_RINDEX,	/* 115 */
	OP_SPRINTF,	/* 116 */
	OP_FORMLINE,	/* 117 */
	OP_ORD,		/* 118 */
	OP_CHR,		/* 119 */
	OP_CRYPT,	/* 120 */
	OP_UCFIRST,	/* 121 */
	OP_LCFIRST,	/* 122 */
	OP_UC,		/* 123 */
	OP_LC,		/* 124 */
	OP_QUOTEMETA,	/* 125 */
	OP_RV2AV,	/* 126 */
	OP_AELEMFAST,	/* 127 */
	OP_AELEM,	/* 128 */
	OP_ASLICE,	/* 129 */
	OP_EACH,	/* 130 */
	OP_VALUES,	/* 131 */
	OP_KEYS,	/* 132 */
	OP_DELETE,	/* 133 */
	OP_EXISTS,	/* 134 */
	OP_RV2HV,	/* 135 */
	OP_HELEM,	/* 136 */
	OP_HSLICE,	/* 137 */
	OP_UNPACK,	/* 138 */
	OP_PACK,	/* 139 */
	OP_SPLIT,	/* 140 */
	OP_JOIN,	/* 141 */
	OP_LIST,	/* 142 */
	OP_LSLICE,	/* 143 */
	OP_ANONLIST,	/* 144 */
	OP_ANONHASH,	/* 145 */
	OP_SPLICE,	/* 146 */
	OP_PUSH,	/* 147 */
	OP_POP,		/* 148 */
	OP_SHIFT,	/* 149 */
	OP_UNSHIFT,	/* 150 */
	OP_SORT,	/* 151 */
	OP_REVERSE,	/* 152 */
	OP_GREPSTART,	/* 153 */
	OP_GREPWHILE,	/* 154 */
	OP_MAPSTART,	/* 155 */
	OP_MAPWHILE,	/* 156 */
	OP_RANGE,	/* 157 */
	OP_FLIP,	/* 158 */
	OP_FLOP,	/* 159 */
	OP_AND,		/* 160 */
	OP_OR,		/* 161 */
	OP_XOR,		/* 162 */
	OP_DOR,		/* 163 */
	OP_COND_EXPR,	/* 164 */
	OP_ANDASSIGN,	/* 165 */
	OP_ORASSIGN,	/* 166 */
	OP_DORASSIGN,	/* 167 */
	OP_METHOD,	/* 168 */
	OP_ENTERSUB,	/* 169 */
	OP_LEAVESUB,	/* 170 */
	OP_LEAVESUBLV,	/* 171 */
	OP_CALLER,	/* 172 */
	OP_WARN,	/* 173 */
	OP_DIE,		/* 174 */
	OP_RESET,	/* 175 */
	OP_LINESEQ,	/* 176 */
	OP_NEXTSTATE,	/* 177 */
	OP_DBSTATE,	/* 178 */
	OP_UNSTACK,	/* 179 */
	OP_ENTER,	/* 180 */
	OP_LEAVE,	/* 181 */
	OP_SCOPE,	/* 182 */
	OP_ENTERITER,	/* 183 */
	OP_ITER,	/* 184 */
	OP_ENTERLOOP,	/* 185 */
	OP_LEAVELOOP,	/* 186 */
	OP_RETURN,	/* 187 */
	OP_LAST,	/* 188 */
	OP_NEXT,	/* 189 */
	OP_REDO,	/* 190 */
	OP_DUMP,	/* 191 */
	OP_GOTO,	/* 192 */
	OP_EXIT,	/* 193 */
	OP_SETSTATE,	/* 194 */
	OP_METHOD_NAMED,/* 195 */
	OP_ENTERGIVEN,	/* 196 */
	OP_LEAVEGIVEN,	/* 197 */
	OP_ENTERWHEN,	/* 198 */
	OP_LEAVEWHEN,	/* 199 */
	OP_BREAK,	/* 200 */
	OP_CONTINUE,	/* 201 */
	OP_OPEN,	/* 202 */
	OP_CLOSE,	/* 203 */
	OP_PIPE_OP,	/* 204 */
	OP_FILENO,	/* 205 */
	OP_UMASK,	/* 206 */
	OP_BINMODE,	/* 207 */
	OP_TIE,		/* 208 */
	OP_UNTIE,	/* 209 */
	OP_TIED,	/* 210 */
	OP_DBMOPEN,	/* 211 */
	OP_DBMCLOSE,	/* 212 */
	OP_SSELECT,	/* 213 */
	OP_SELECT,	/* 214 */
	OP_GETC,	/* 215 */
	OP_READ,	/* 216 */
	OP_ENTERWRITE,	/* 217 */
	OP_LEAVEWRITE,	/* 218 */
	OP_PRTF,	/* 219 */
	OP_PRINT,	/* 220 */
	OP_SAY,		/* 221 */
	OP_SYSOPEN,	/* 222 */
	OP_SYSSEEK,	/* 223 */
	OP_SYSREAD,	/* 224 */
	OP_SYSWRITE,	/* 225 */
	OP_SEND,	/* 226 */
	OP_RECV,	/* 227 */
	OP_EOF,		/* 228 */
	OP_TELL,	/* 229 */
	OP_SEEK,	/* 230 */
	OP_TRUNCATE,	/* 231 */
	OP_FCNTL,	/* 232 */
	OP_IOCTL,	/* 233 */
	OP_FLOCK,	/* 234 */
	OP_SOCKET,	/* 235 */
	OP_SOCKPAIR,	/* 236 */
	OP_BIND,	/* 237 */
	OP_CONNECT,	/* 238 */
	OP_LISTEN,	/* 239 */
	OP_ACCEPT,	/* 240 */
	OP_SHUTDOWN,	/* 241 */
	OP_GSOCKOPT,	/* 242 */
	OP_SSOCKOPT,	/* 243 */
	OP_GETSOCKNAME,	/* 244 */
	OP_GETPEERNAME,	/* 245 */
	OP_LSTAT,	/* 246 */
	OP_STAT,	/* 247 */
	OP_FTRREAD,	/* 248 */
	OP_FTRWRITE,	/* 249 */
	OP_FTREXEC,	/* 250 */
	OP_FTEREAD,	/* 251 */
	OP_FTEWRITE,	/* 252 */
	OP_FTEEXEC,	/* 253 */
	OP_FTIS,	/* 254 */
	OP_FTSIZE,	/* 255 */
	OP_FTMTIME,	/* 256 */
	OP_FTATIME,	/* 257 */
	OP_FTCTIME,	/* 258 */
	OP_FTROWNED,	/* 259 */
	OP_FTEOWNED,	/* 260 */
	OP_FTZERO,	/* 261 */
	OP_FTSOCK,	/* 262 */
	OP_FTCHR,	/* 263 */
	OP_FTBLK,	/* 264 */
	OP_FTFILE,	/* 265 */
	OP_FTDIR,	/* 266 */
	OP_FTPIPE,	/* 267 */
	OP_FTSUID,	/* 268 */
	OP_FTSGID,	/* 269 */
	OP_FTSVTX,	/* 270 */
	OP_FTLINK,	/* 271 */
	OP_FTTTY,	/* 272 */
	OP_FTTEXT,	/* 273 */
	OP_FTBINARY,	/* 274 */
	OP_CHDIR,	/* 275 */
	OP_CHOWN,	/* 276 */
	OP_CHROOT,	/* 277 */
	OP_UNLINK,	/* 278 */
	OP_CHMOD,	/* 279 */
	OP_UTIME,	/* 280 */
	OP_RENAME,	/* 281 */
	OP_LINK,	/* 282 */
	OP_SYMLINK,	/* 283 */
	OP_READLINK,	/* 284 */
	OP_MKDIR,	/* 285 */
	OP_RMDIR,	/* 286 */
	OP_OPEN_DIR,	/* 287 */
	OP_READDIR,	/* 288 */
	OP_TELLDIR,	/* 289 */
	OP_SEEKDIR,	/* 290 */
	OP_REWINDDIR,	/* 291 */
	OP_CLOSEDIR,	/* 292 */
	OP_FORK,	/* 293 */
	OP_WAIT,	/* 294 */
	OP_WAITPID,	/* 295 */
	OP_SYSTEM,	/* 296 */
	OP_EXEC,	/* 297 */
	OP_KILL,	/* 298 */
	OP_GETPPID,	/* 299 */
	OP_GETPGRP,	/* 300 */
	OP_SETPGRP,	/* 301 */
	OP_GETPRIORITY,	/* 302 */
	OP_SETPRIORITY,	/* 303 */
	OP_TIME,	/* 304 */
	OP_TMS,		/* 305 */
	OP_LOCALTIME,	/* 306 */
	OP_GMTIME,	/* 307 */
	OP_ALARM,	/* 308 */
	OP_SLEEP,	/* 309 */
	OP_SHMGET,	/* 310 */
	OP_SHMCTL,	/* 311 */
	OP_SHMREAD,	/* 312 */
	OP_SHMWRITE,	/* 313 */
	OP_MSGGET,	/* 314 */
	OP_MSGCTL,	/* 315 */
	OP_MSGSND,	/* 316 */
	OP_MSGRCV,	/* 317 */
	OP_SEMOP,	/* 318 */
	OP_SEMGET,	/* 319 */
	OP_SEMCTL,	/* 320 */
	OP_REQUIRE,	/* 321 */
	OP_DOFILE,	/* 322 */
	OP_ENTEREVAL,	/* 323 */
	OP_LEAVEEVAL,	/* 324 */
	OP_ENTERTRY,	/* 325 */
	OP_LEAVETRY,	/* 326 */
	OP_GHBYNAME,	/* 327 */
	OP_GHBYADDR,	/* 328 */
	OP_GHOSTENT,	/* 329 */
	OP_GNBYNAME,	/* 330 */
	OP_GNBYADDR,	/* 331 */
	OP_GNETENT,	/* 332 */
	OP_GPBYNAME,	/* 333 */
	OP_GPBYNUMBER,	/* 334 */
	OP_GPROTOENT,	/* 335 */
	OP_GSBYNAME,	/* 336 */
	OP_GSBYPORT,	/* 337 */
	OP_GSERVENT,	/* 338 */
	OP_SHOSTENT,	/* 339 */
	OP_SNETENT,	/* 340 */
	OP_SPROTOENT,	/* 341 */
	OP_SSERVENT,	/* 342 */
	OP_EHOSTENT,	/* 343 */
	OP_ENETENT,	/* 344 */
	OP_EPROTOENT,	/* 345 */
	OP_ESERVENT,	/* 346 */
	OP_GPWNAM,	/* 347 */
	OP_GPWUID,	/* 348 */
	OP_GPWENT,	/* 349 */
	OP_SPWENT,	/* 350 */
	OP_EPWENT,	/* 351 */
	OP_GGRNAM,	/* 352 */
	OP_GGRGID,	/* 353 */
	OP_GGRENT,	/* 354 */
	OP_SGRENT,	/* 355 */
	OP_EGRENT,	/* 356 */
	OP_GETLOGIN,	/* 357 */
	OP_SYSCALL,	/* 358 */
	OP_LOCK,	/* 359 */
	OP_ONCE,	/* 360 */
	OP_CUSTOM,	/* 361 */
	OP_max		
} opcode;

#define MAXO 362
#define OP_phoney_INPUT_ONLY -1
#define OP_phoney_OUTPUT_ONLY -2


#define OP_IS_SOCKET(op)	\
	((op) == OP_ACCEPT || \
	 (op) == OP_BIND || \
	 (op) == OP_CONNECT || \
	 (op) == OP_GETPEERNAME || \
	 (op) == OP_GETSOCKNAME || \
	 (op) == OP_GSOCKOPT || \
	 (op) == OP_LISTEN || \
	 (op) == OP_RECV || \
	 (op) == OP_SEND || \
	 (op) == OP_SHUTDOWN || \
	 (op) == OP_SOCKET || \
	 (op) == OP_SOCKPAIR || \
	 (op) == OP_SSOCKOPT)


#define OP_IS_FILETEST(op)	\
	((op) == OP_FTATIME || \
	 (op) == OP_FTBINARY || \
	 (op) == OP_FTBLK || \
	 (op) == OP_FTCHR || \
	 (op) == OP_FTCTIME || \
	 (op) == OP_FTDIR || \
	 (op) == OP_FTEEXEC || \
	 (op) == OP_FTEOWNED || \
	 (op) == OP_FTEREAD || \
	 (op) == OP_FTEWRITE || \
	 (op) == OP_FTFILE || \
	 (op) == OP_FTIS || \
	 (op) == OP_FTLINK || \
	 (op) == OP_FTMTIME || \
	 (op) == OP_FTPIPE || \
	 (op) == OP_FTREXEC || \
	 (op) == OP_FTROWNED || \
	 (op) == OP_FTRREAD || \
	 (op) == OP_FTRWRITE || \
	 (op) == OP_FTSGID || \
	 (op) == OP_FTSIZE || \
	 (op) == OP_FTSOCK || \
	 (op) == OP_FTSUID || \
	 (op) == OP_FTSVTX || \
	 (op) == OP_FTTEXT || \
	 (op) == OP_FTTTY || \
	 (op) == OP_FTZERO)

/* ex: set ro: */
