=begin comment

PeakForest REST API

API specification to support \"PeakForest - REST API\" operations

The version of the OpenAPI document: 2.1.0
Contact: contact@peakforest.org
Generated by: https://openapi-generator.tech

=end comment

=cut

#
# NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
# Do not edit the class manually.
# Ref: https://openapi-generator.tech
#
package PeakForest::REST_Client::ChromatographyApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use PeakForest::REST_Client::ApiClient;

use base "Class::Data::Inheritable";

our $VERSION = '1.00';

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'PeakForest::REST_Client::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = PeakForest::REST_Client::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# get_chromatographies
#
# Get / search chromatography data
# 
# @param string $spectra_type the mandatory spectra type (required)
# @param string $column_name the optional column name (optional)
# @param string $column_constructor the optional column constructor (optional)
# @param string $mode the optional chromatography mode (optional)
# @param double $column_length the optional column length, in &#39;mm&#39; (optional)
# @param double $column_diameter the optional column diameter, in &#39;mm&#39; (optional)
# @param double $column_particule_size the optional column particule size, in &#39;µm&#39; (optional)
# @param double $flow_rate the optional separation flow rate, in &#39;µL/min&#39; (optional)
# @param int $offset The number of items to skip before starting to collect the result set. (optional, default to 0)
# @param int $limit The numbers of items to return. (optional, default to 20)
{
    my $params = {
    'spectra_type' => {
        data_type => 'string',
        description => 'the mandatory spectra type',
        required => '1',
    },
    'column_name' => {
        data_type => 'string',
        description => 'the optional column name',
        required => '0',
    },
    'column_constructor' => {
        data_type => 'string',
        description => 'the optional column constructor',
        required => '0',
    },
    'mode' => {
        data_type => 'string',
        description => 'the optional chromatography mode',
        required => '0',
    },
    'column_length' => {
        data_type => 'double',
        description => 'the optional column length, in &#39;mm&#39;',
        required => '0',
    },
    'column_diameter' => {
        data_type => 'double',
        description => 'the optional column diameter, in &#39;mm&#39;',
        required => '0',
    },
    'column_particule_size' => {
        data_type => 'double',
        description => 'the optional column particule size, in &#39;µm&#39;',
        required => '0',
    },
    'flow_rate' => {
        data_type => 'double',
        description => 'the optional separation flow rate, in &#39;µL/min&#39;',
        required => '0',
    },
    'offset' => {
        data_type => 'int',
        description => 'The number of items to skip before starting to collect the result set.',
        required => '0',
    },
    'limit' => {
        data_type => 'int',
        description => 'The numbers of items to return.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_chromatographies' } = { 
        summary => 'Get / search chromatography data',
        params => $params,
        returns => 'ARRAY[Chromatography]',
        };
}
# @return ARRAY[Chromatography]
#
sub get_chromatographies {
    my ($self, %args) = @_;

    # verify the required parameter 'spectra_type' is set
    unless (exists $args{'spectra_type'}) {
      croak("Missing the required parameter 'spectra_type' when calling get_chromatographies");
    }

    # parse inputs
    my $_resource_path = '/spectra/{spectraType}/chromatographies';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'column_name'}) {
        $query_params->{'column_name'} = $self->{api_client}->to_query_value($args{'column_name'});
    }

    # query params
    if ( exists $args{'column_constructor'}) {
        $query_params->{'column_constructor'} = $self->{api_client}->to_query_value($args{'column_constructor'});
    }

    # query params
    if ( exists $args{'mode'}) {
        $query_params->{'mode'} = $self->{api_client}->to_query_value($args{'mode'});
    }

    # query params
    if ( exists $args{'column_length'}) {
        $query_params->{'column_length'} = $self->{api_client}->to_query_value($args{'column_length'});
    }

    # query params
    if ( exists $args{'column_diameter'}) {
        $query_params->{'column_diameter'} = $self->{api_client}->to_query_value($args{'column_diameter'});
    }

    # query params
    if ( exists $args{'column_particule_size'}) {
        $query_params->{'column_particule_size'} = $self->{api_client}->to_query_value($args{'column_particule_size'});
    }

    # query params
    if ( exists $args{'flow_rate'}) {
        $query_params->{'flow_rate'} = $self->{api_client}->to_query_value($args{'flow_rate'});
    }

    # query params
    if ( exists $args{'offset'}) {
        $query_params->{'offset'} = $self->{api_client}->to_query_value($args{'offset'});
    }

    # query params
    if ( exists $args{'limit'}) {
        $query_params->{'limit'} = $self->{api_client}->to_query_value($args{'limit'});
    }

    # path params
    if ( exists $args{'spectra_type'}) {
        my $_base_variable = "{" . "spectraType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'spectra_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyAuth ApiKeyToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[Chromatography]', $response);
    return $_response_object;
}

#
# get_chromatographies_properties
#
# Get / search chromatographies, extract queried properties.
# 
# @param string $spectra_type the mandatory spectra type (required)
# @param ARRAY[string] $properties  (required)
# @param string $column_name the optional column name (optional)
# @param string $column_constructor the optional column constructor (optional)
# @param string $mode the optional chromatography mode (optional)
# @param double $column_length the optional column length, in &#39;mm&#39; (optional)
# @param double $column_diameter the optional column diameter, in &#39;mm&#39; (optional)
# @param double $column_particule_size the optional column particule size, in &#39;µm&#39; (optional)
# @param double $flow_rate the optional separation flow rate, in &#39;µL/min&#39; (optional)
# @param int $offset The number of items to skip before starting to collect the result set. (optional, default to 0)
# @param int $limit The numbers of items to return. (optional, default to 20)
{
    my $params = {
    'spectra_type' => {
        data_type => 'string',
        description => 'the mandatory spectra type',
        required => '1',
    },
    'properties' => {
        data_type => 'ARRAY[string]',
        description => '',
        required => '1',
    },
    'column_name' => {
        data_type => 'string',
        description => 'the optional column name',
        required => '0',
    },
    'column_constructor' => {
        data_type => 'string',
        description => 'the optional column constructor',
        required => '0',
    },
    'mode' => {
        data_type => 'string',
        description => 'the optional chromatography mode',
        required => '0',
    },
    'column_length' => {
        data_type => 'double',
        description => 'the optional column length, in &#39;mm&#39;',
        required => '0',
    },
    'column_diameter' => {
        data_type => 'double',
        description => 'the optional column diameter, in &#39;mm&#39;',
        required => '0',
    },
    'column_particule_size' => {
        data_type => 'double',
        description => 'the optional column particule size, in &#39;µm&#39;',
        required => '0',
    },
    'flow_rate' => {
        data_type => 'double',
        description => 'the optional separation flow rate, in &#39;µL/min&#39;',
        required => '0',
    },
    'offset' => {
        data_type => 'int',
        description => 'The number of items to skip before starting to collect the result set.',
        required => '0',
    },
    'limit' => {
        data_type => 'int',
        description => 'The numbers of items to return.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_chromatographies_properties' } = { 
        summary => 'Get / search chromatographies, extract queried properties.',
        params => $params,
        returns => 'object',
        };
}
# @return object
#
sub get_chromatographies_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'spectra_type' is set
    unless (exists $args{'spectra_type'}) {
      croak("Missing the required parameter 'spectra_type' when calling get_chromatographies_properties");
    }

    # verify the required parameter 'properties' is set
    unless (exists $args{'properties'}) {
      croak("Missing the required parameter 'properties' when calling get_chromatographies_properties");
    }

    # parse inputs
    my $_resource_path = '/spectra/{spectraType}/chromatographies/{properties}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'column_name'}) {
        $query_params->{'column_name'} = $self->{api_client}->to_query_value($args{'column_name'});
    }

    # query params
    if ( exists $args{'column_constructor'}) {
        $query_params->{'column_constructor'} = $self->{api_client}->to_query_value($args{'column_constructor'});
    }

    # query params
    if ( exists $args{'mode'}) {
        $query_params->{'mode'} = $self->{api_client}->to_query_value($args{'mode'});
    }

    # query params
    if ( exists $args{'column_length'}) {
        $query_params->{'column_length'} = $self->{api_client}->to_query_value($args{'column_length'});
    }

    # query params
    if ( exists $args{'column_diameter'}) {
        $query_params->{'column_diameter'} = $self->{api_client}->to_query_value($args{'column_diameter'});
    }

    # query params
    if ( exists $args{'column_particule_size'}) {
        $query_params->{'column_particule_size'} = $self->{api_client}->to_query_value($args{'column_particule_size'});
    }

    # query params
    if ( exists $args{'flow_rate'}) {
        $query_params->{'flow_rate'} = $self->{api_client}->to_query_value($args{'flow_rate'});
    }

    # query params
    if ( exists $args{'offset'}) {
        $query_params->{'offset'} = $self->{api_client}->to_query_value($args{'offset'});
    }

    # query params
    if ( exists $args{'limit'}) {
        $query_params->{'limit'} = $self->{api_client}->to_query_value($args{'limit'});
    }

    # path params
    if ( exists $args{'spectra_type'}) {
        my $_base_variable = "{" . "spectraType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'spectra_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'properties'}) {
        my $_base_variable = "{" . "properties" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'properties'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyAuth ApiKeyToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('object', $response);
    return $_response_object;
}

#
# get_chromatography
#
# Get a chromatography by its PeakForest ID or its InChIKey
# 
# @param string $id The chromatography PeakForest ID or its code. (required)
{
    my $params = {
    'id' => {
        data_type => 'string',
        description => 'The chromatography PeakForest ID or its code.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_chromatography' } = { 
        summary => 'Get a chromatography by its PeakForest ID or its InChIKey',
        params => $params,
        returns => 'Chromatography',
        };
}
# @return Chromatography
#
sub get_chromatography {
    my ($self, %args) = @_;

    # verify the required parameter 'id' is set
    unless (exists $args{'id'}) {
      croak("Missing the required parameter 'id' when calling get_chromatography");
    }

    # parse inputs
    my $_resource_path = '/chromatography/{id}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'id'}) {
        my $_base_variable = "{" . "id" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyAuth ApiKeyToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chromatography', $response);
    return $_response_object;
}

#
# get_spectra_matching_peaks
#
# Perform a Spectra naïve Peakmachting query (without either ranking or scoring; return all spectra with at least one peak matching the query)
# 
# @param string $spectra_type the mandatory spectra type (required)
# @param string $column_code the optional column code (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional)
# @param string $polarity the optional mass polarity mode (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional)
# @param string $resolution the optional mass resolution filter (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional)
# @param double $rt_min the starting range to Retention Time in peak matching (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional)
# @param double $rt_max the ending range to Retention Time in peak matching (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional)
# @param ARRAY[double] $list_mz the optional list of MZ to match (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional)
# @param double $precursor_mz the optional MS precursor MZ to match (only for LC-MSMS spectra matching) (optional)
# @param double $delta the delta tolerance for MZ or PPM peaks matching (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional, default to 0.05)
# @param ARRAY[double] $list_ppm the optional list of PPM to match (only for either 1D-NMR spectra matching) (optional)
# @param ARRAY[double] $list_ppm_f1 the optional list of PPM to match in F1 (only for either 2D-NMR spectra matching) (optional)
# @param ARRAY[double] $list_ppm_f2 the optional list of PPM to match in F2 (only for either 2D-NMR spectra matching) (optional)
{
    my $params = {
    'spectra_type' => {
        data_type => 'string',
        description => 'the mandatory spectra type',
        required => '1',
    },
    'column_code' => {
        data_type => 'string',
        description => 'the optional column code (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'polarity' => {
        data_type => 'string',
        description => 'the optional mass polarity mode (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'resolution' => {
        data_type => 'string',
        description => 'the optional mass resolution filter (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'rt_min' => {
        data_type => 'double',
        description => 'the starting range to Retention Time in peak matching (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'rt_max' => {
        data_type => 'double',
        description => 'the ending range to Retention Time in peak matching (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'list_mz' => {
        data_type => 'ARRAY[double]',
        description => 'the optional list of MZ to match (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'precursor_mz' => {
        data_type => 'double',
        description => 'the optional MS precursor MZ to match (only for LC-MSMS spectra matching)',
        required => '0',
    },
    'delta' => {
        data_type => 'double',
        description => 'the delta tolerance for MZ or PPM peaks matching (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'list_ppm' => {
        data_type => 'ARRAY[double]',
        description => 'the optional list of PPM to match (only for either 1D-NMR spectra matching)',
        required => '0',
    },
    'list_ppm_f1' => {
        data_type => 'ARRAY[double]',
        description => 'the optional list of PPM to match in F1 (only for either 2D-NMR spectra matching)',
        required => '0',
    },
    'list_ppm_f2' => {
        data_type => 'ARRAY[double]',
        description => 'the optional list of PPM to match in F2 (only for either 2D-NMR spectra matching)',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_spectra_matching_peaks' } = { 
        summary => 'Perform a Spectra naïve Peakmachting query (without either ranking or scoring; return all spectra with at least one peak matching the query)',
        params => $params,
        returns => 'ARRAY[Spectrum]',
        };
}
# @return ARRAY[Spectrum]
#
sub get_spectra_matching_peaks {
    my ($self, %args) = @_;

    # verify the required parameter 'spectra_type' is set
    unless (exists $args{'spectra_type'}) {
      croak("Missing the required parameter 'spectra_type' when calling get_spectra_matching_peaks");
    }

    # parse inputs
    my $_resource_path = '/spectra-peakmatching/{spectraType}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'column_code'}) {
        $query_params->{'column_code'} = $self->{api_client}->to_query_value($args{'column_code'});
    }

    # query params
    if ( exists $args{'polarity'}) {
        $query_params->{'polarity'} = $self->{api_client}->to_query_value($args{'polarity'});
    }

    # query params
    if ( exists $args{'resolution'}) {
        $query_params->{'resolution'} = $self->{api_client}->to_query_value($args{'resolution'});
    }

    # query params
    if ( exists $args{'rt_min'}) {
        $query_params->{'rt_min'} = $self->{api_client}->to_query_value($args{'rt_min'});
    }

    # query params
    if ( exists $args{'rt_max'}) {
        $query_params->{'rt_max'} = $self->{api_client}->to_query_value($args{'rt_max'});
    }

    # query params
    if ( exists $args{'list_mz'}) {
        $query_params->{'list_mz'} = $self->{api_client}->to_query_value($args{'list_mz'});
    }

    # query params
    if ( exists $args{'precursor_mz'}) {
        $query_params->{'precursor_mz'} = $self->{api_client}->to_query_value($args{'precursor_mz'});
    }

    # query params
    if ( exists $args{'delta'}) {
        $query_params->{'delta'} = $self->{api_client}->to_query_value($args{'delta'});
    }

    # query params
    if ( exists $args{'list_ppm'}) {
        $query_params->{'list_ppm'} = $self->{api_client}->to_query_value($args{'list_ppm'});
    }

    # query params
    if ( exists $args{'list_ppm_f1'}) {
        $query_params->{'list_ppm_f1'} = $self->{api_client}->to_query_value($args{'list_ppm_f1'});
    }

    # query params
    if ( exists $args{'list_ppm_f2'}) {
        $query_params->{'list_ppm_f2'} = $self->{api_client}->to_query_value($args{'list_ppm_f2'});
    }

    # path params
    if ( exists $args{'spectra_type'}) {
        my $_base_variable = "{" . "spectraType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'spectra_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyAuth ApiKeyToken )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[Spectrum]', $response);
    return $_response_object;
}

1;
