/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.fsm;

import edu.stanford.nlp.fsm.DFSA;
import edu.stanford.nlp.fsm.DFSATransition;
import edu.stanford.nlp.util.Scored;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DFSAState<T, S>
implements Scored {
    private S stateID;
    private Map<T, DFSATransition<T, S>> inputToTransition;
    public boolean accepting;
    private DFSA<T, S> dfsa;
    public double score;
    private int hashCodeCache;

    @Override
    public double score() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public DFSA<T, S> dfsa() {
        return this.dfsa;
    }

    public void setStateID(S stateID) {
        this.stateID = stateID;
    }

    public S stateID() {
        return this.stateID;
    }

    public void addTransition(DFSATransition<T, S> transition) {
        this.inputToTransition.put(transition.input(), transition);
    }

    public DFSATransition<T, S> transition(T input) {
        return this.inputToTransition.get(input);
    }

    public Collection<DFSATransition<T, S>> transitions() {
        return this.inputToTransition.values();
    }

    public Set<T> continuingInputs() {
        return this.inputToTransition.keySet();
    }

    public Set<DFSAState<T, S>> successorStates() {
        HashSet<DFSAState<T, S>> successors = new HashSet<DFSAState<T, S>>();
        Collection<DFSATransition<T, S>> transitions = this.inputToTransition.values();
        for (DFSATransition<T, S> transition : transitions) {
            successors.add(transition.getTarget());
        }
        return successors;
    }

    public void setAccepting(boolean accepting) {
        this.accepting = accepting;
    }

    public boolean isAccepting() {
        return this.accepting;
    }

    public boolean isContinuable() {
        return !this.inputToTransition.isEmpty();
    }

    public String toString() {
        return this.stateID.toString();
    }

    public int hashCode() {
        if (this.hashCodeCache == 0) {
            this.hashCodeCache = this.stateID.hashCode() ^ this.dfsa.hashCode();
        }
        return this.hashCodeCache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DFSAState)) {
            return false;
        }
        DFSAState s = (DFSAState)o;
        return this.dfsa.equals(s.dfsa) && this.stateID.equals(s.stateID);
    }

    public Set<DFSAState<T, S>> statesReachable() {
        HashSet<DFSAState<T, S>> visited = new HashSet<DFSAState<T, S>>();
        ArrayList<DFSAState<T, S>> toVisit = new ArrayList<DFSAState<T, S>>();
        toVisit.add(this);
        this.exploreStates(toVisit, visited);
        return visited;
    }

    private void exploreStates(List<DFSAState<T, S>> toVisit, Set<DFSAState<T, S>> visited) {
        while (!toVisit.isEmpty()) {
            DFSAState<T, S> state = toVisit.get(toVisit.size() - 1);
            toVisit.remove(toVisit.size() - 1);
            if (visited.contains(state)) continue;
            toVisit.addAll(state.successorStates());
            visited.add(state);
        }
    }

    public DFSAState(S id, DFSA<T, S> dfsa) {
        this.dfsa = dfsa;
        this.stateID = id;
        this.accepting = false;
        this.inputToTransition = new HashMap<T, DFSATransition<T, S>>();
        this.score = Double.NEGATIVE_INFINITY;
    }

    public DFSAState(S id, DFSA<T, S> dfsa, double score) {
        this(id, dfsa);
        this.setScore(score);
    }
}

