/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.graph;

import edu.stanford.nlp.graph.DirectedMultiGraph;
import edu.stanford.nlp.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ConnectedComponents<V, E> {
    public static <V, E> List<Set<V>> getConnectedComponents(DirectedMultiGraph<V, E> graph) {
        ArrayList<Set<V>> ccs = new ArrayList<Set<V>>();
        LinkedList<V> todo = new LinkedList<V>();
        List<V> verticesLeft = CollectionUtils.toList(graph.getAllVertices());
        while (verticesLeft.size() > 0) {
            todo.add(verticesLeft.get(0));
            verticesLeft.remove(0);
            ccs.add(ConnectedComponents.bfs(todo, graph, verticesLeft));
        }
        return ccs;
    }

    private static <V, E> Set<V> bfs(LinkedList<V> todo, DirectedMultiGraph<V, E> graph, List<V> verticesLeft) {
        HashSet<V> cc = new HashSet<V>();
        while (todo.size() > 0) {
            V node = todo.removeFirst();
            cc.add(node);
            for (V neighbor : graph.getNeighbors(node)) {
                if (!verticesLeft.contains(neighbor)) continue;
                cc.add(neighbor);
                todo.add(neighbor);
                verticesLeft.remove(neighbor);
            }
        }
        return cc;
    }
}

