/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.pascal;

import edu.stanford.nlp.ie.pascal.CliqueTemplates;
import edu.stanford.nlp.ie.pascal.PascalTemplate;

public class InfoTemplate {
    String whomepage = "null";
    String wacronym = "null";
    String wname = "null";
    String chomepage = "null";
    String cacronym = "null";
    String cname = "null";

    public InfoTemplate(String whomepage, String wacronym, String wname, String chomepage, String cacronym, String cname, CliqueTemplates ct) {
        if (whomepage != null) {
            this.whomepage = whomepage;
        }
        if (wacronym != null) {
            this.wacronym = PascalTemplate.stemAcronym(wacronym, ct);
        }
        if (wname != null) {
            this.wname = wname;
        }
        if (chomepage != null) {
            this.chomepage = chomepage;
        }
        if (cacronym != null) {
            this.cacronym = PascalTemplate.stemAcronym(cacronym, ct);
        }
        if (cname != null) {
            this.cname = cname;
        }
    }

    public int hashCode() {
        int tally = 31;
        int n = 7;
        tally = this.whomepage.hashCode() + n * this.wacronym.hashCode() + n * n * this.wname.hashCode();
        return tally += this.chomepage.hashCode() + n * this.cacronym.hashCode() + n * n * this.cname.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InfoTemplate)) {
            return false;
        }
        InfoTemplate i = (InfoTemplate)obj;
        return this.whomepage.equals(i.whomepage) && this.wacronym.equals(i.wacronym) && this.wname.equals(i.wname) && this.chomepage.equals(i.chomepage) && this.cacronym.equals(i.cacronym) && this.cname.equals(i.cname);
    }

    public String toString() {
        return "W_URL: " + this.whomepage + " W_ACRO: " + this.wacronym + " W_NAME: " + this.wname + "\nC_URL: " + this.chomepage + " C_ACRO: " + this.cacronym + " C_NAME: " + this.cname;
    }
}

