/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.BasicSequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchAction;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.CoreMapAggregator;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class CoreMapSequenceMatchAction<T extends CoreMap>
implements SequenceMatchAction<T> {
    public static final MergeAction DEFAULT_MERGE_ACTION = new MergeAction();

    public static final class MergeAction
    extends CoreMapSequenceMatchAction<CoreMap> {
        CoreMapAggregator aggregator = CoreMapAggregator.getDefaultAggregator();

        public MergeAction() {
        }

        public MergeAction(CoreMapAggregator aggregator) {
            this.aggregator = aggregator;
        }

        @Override
        public SequenceMatchResult<CoreMap> apply(SequenceMatchResult<CoreMap> matchResult, int ... groups) {
            BasicSequenceMatchResult<CoreMap> res = matchResult.toBasicSequenceMatchResult();
            List<CoreMap> elements = matchResult.elements();
            ArrayList mergedElements = new ArrayList();
            res.elements = mergedElements;
            int last = 0;
            int mergedGroup = 0;
            int offset = 0;
            List<Integer> orderedGroups = CollectionUtils.asList(groups);
            Collections.sort(orderedGroups);
            for (int group : orderedGroups) {
                int groupStart = matchResult.start(group);
                if (groupStart < last) continue;
                mergedElements.addAll(elements.subList(last, groupStart));
                while (mergedGroup < group) {
                    if (res.matchedGroups[mergedGroup] != null) {
                        res.matchedGroups[mergedGroup].matchBegin -= offset;
                        res.matchedGroups[mergedGroup].matchEnd -= offset;
                    }
                    ++mergedGroup;
                }
                int groupEnd = matchResult.end(group);
                if (groupEnd - groupStart < 1) continue;
                CoreMap merged = this.aggregator.merge(elements, groupStart, groupEnd);
                mergedElements.add(merged);
                last = groupEnd;
                res.matchedGroups[mergedGroup].matchBegin = mergedElements.size() - 1;
                res.matchedGroups[mergedGroup].matchEnd = mergedElements.size();
                ++mergedGroup;
                while (mergedGroup < res.matchedGroups.length) {
                    if (res.matchedGroups[mergedGroup] != null) {
                        if (res.matchedGroups[mergedGroup].matchBegin == matchResult.start(group) && res.matchedGroups[mergedGroup].matchEnd == matchResult.end(group)) {
                            res.matchedGroups[mergedGroup].matchBegin = res.matchedGroups[group].matchBegin;
                            res.matchedGroups[mergedGroup].matchEnd = res.matchedGroups[group].matchEnd;
                        } else {
                            if (res.matchedGroups[mergedGroup].matchEnd > matchResult.end(group)) break;
                            res.matchedGroups[mergedGroup] = null;
                        }
                    }
                    ++mergedGroup;
                }
                offset = matchResult.end(group) - res.matchedGroups[group].matchEnd;
            }
            mergedElements.addAll(elements.subList(last, elements.size()));
            while (mergedGroup < res.matchedGroups.length) {
                if (res.matchedGroups[mergedGroup] != null) {
                    res.matchedGroups[mergedGroup].matchBegin -= offset;
                    res.matchedGroups[mergedGroup].matchEnd -= offset;
                }
                ++mergedGroup;
            }
            return res;
        }
    }

    public static final class AnnotateAction<T extends CoreMap>
    extends CoreMapSequenceMatchAction<T> {
        Map<String, String> attributes;

        public AnnotateAction(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        @Override
        public SequenceMatchResult<T> apply(SequenceMatchResult<T> matchResult, int ... groups) {
            for (int group : groups) {
                int groupStart = matchResult.start(group);
                if (groupStart < 0) continue;
                int groupEnd = matchResult.end(group);
                ChunkAnnotationUtils.annotateChunks(matchResult.elements(), groupStart, groupEnd, this.attributes);
            }
            return matchResult;
        }
    }
}

