#!/bin/bash

tooldir=`dirname "$0"`

data="$tooldir/../testcases/data/bnc"
data_dir="$data/data"
resource_dir="$tooldir/resources/pdt2base:$data/resources:$tooldir/../resources:"


btred -qI "$tooldir/pml2base.btred" \
    --no-secondary-files \
    --resource-dir "$resource_dir": \
    -g \
    -o \
    --syntax "postgres" \
    --data-dir $data_dir \
    -r a_coreference/target-node.rf=- \
    -r n-node/a.rf=a-node \
    -r t-node/src_tnode.rf=t-node \
    -r t-node/original_parent.rf=t-node \
    -r t-node/coref_text.rf=t-node \
    -r t-node/compl.rf=t-node \
    -r t-node/coref_gram.rf=t-node \
    -r t-node/val_frame.rf=- \
    -r t-a/lex.rf=a-node \
    -r t-a/aux.rf=a-node \
    -r t-root/atree.rf=a-root \
    -r t-root/src_tnode.rf=t-node \
    -r a-root/ptree.rf=p-nonterminal \
    -r a-root/s.rf=- \
    -r a-root/giza_scores/counterpart.rf=- \
    -r a-node/p_terminal.rf=p-terminal \
    -r a-align-links/counterpart.rf=a-node \
    -r t-align-links/counterpart.rf=t-node \
    -r a-node/align=- \
    -- "$data_dir/*.treex.gz"


