# Building Apache Clownfish projects in C environments

The following steps are required to build a project that uses
Apache Clownfish:

- Run the `cfc` command-line application (Clownfish compiler) to
  generate C headers, C source files, and documentation.
- Include the C headers generated by the Clownfish compiler in your
  own code to [work with Clownfish objects](ClassIntro).
- Compile an additional C source file generated by CFC.
- Link your object code, the object code from the generated file,
  and the Clownfish runtime library.

## Running cfc

    cfc [--source=<dir>] [--include=<dir>] [--parcel=<name>]
        --dest=<dir>
        [--header=<file>] [--footer=<file>]

### --source

Every `--source` argument adds a directory to the list of source
directories to search for source parcels. For every source parcel
found, CFC generates C headers, a C source file, and documentation.

The source directories are scanned for Clownfish parcel definitions
(`.cfp`), Clownfish headers (`.cfh`), and standalone documentation
in Markdown format (`.md`).

This option may be specified multiple times.

### --include

Every `--include` argument adds a directory to the list of include
directories. CFC generates C headers for parcels from an include
directory only if they're required by a source parcel or if they're
specified with the `--parcel` option. Only C headers are generated
for included parcels, no C source code or documentation.

The include directories are scanned for Clownfish parcel
definitions (`.cfp`) and Clownfish headers (`.cfh`).

After the directories specified on the command-line, the following
directories are processed:

- Directories from the environment variable `CLOWNFISH_INCLUDE`.
  This variable contains a colon-separated list of directories.
- On UNIX-like systems `/usr/local/share/clownfish/include` and
  `/usr/share/clownfish/include`.

This option may be specified multiple times.

### --parcel

Adds a parcel to the list of prerequisite parcels to make sure that
its C headers are generated. This is useful when running without the
`--source` option. For example, a project that doesn't define its
own Clownfish classes can generate the C headers for the Clownfish
runtime with:

    cfc --parcel=Clownfish --dest=autogen

This option may be specified multiple times.

### --dest

The destination directory for generated files. By convention,
the name `autogen` is used.

CFC creates the following subdirectories in the destination
directory:

- `include` contains generated C headers.
- `sources` contains generated C source files.
- `man` contains generated man pages.
- `share/doc/clownfish` contains generated HTML documentation.

This option is required.

### --header

Specifies a file whose contents are added as a comment on top of
each generated file.

### --footer

Specifies a file whose contents are added as a comment on the
bottom of each generated file.

## Including the generated C headers

The C header files generated with `cfc` can be found in
`autogen/include`. You should add this directory to your compiler's
search path, for example using `-Iautogen/include` under GCC.

One C header file is generated for every Clownfish header (.cfh) file.
C code that makes use of a class defined in the .cfh file must include
the respective C header. The Clownfish compiler also creates a few
other internal C header files.

## Compiling the generated source files

`cfc` creates one source file for every parcel in
`autogen/sources/{parcel_nick}_parcel.c`. These files must be
compiled with `autogen/include` added to the header search path.

## Linking

When linking, add the object files of the CFC-generated code created
in the previous step. You must also link the shared library of the
Clownfish runtime (`-lcfish` under GCC).

