/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.analysis;

import at.ac.tuwien.dbai.pdfwrap.analysis.CandidateCluster;
import at.ac.tuwien.dbai.pdfwrap.analysis.ISegmentationRules;
import at.ac.tuwien.dbai.pdfwrap.analysis.PageSegmenter;
import at.ac.tuwien.dbai.pdfwrap.model.document.CompositeSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyEdge;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;
import java.util.HashMap;
import java.util.List;

public class TextBlockSegmentationRules
implements ISegmentationRules {
    public static float MAX_CLUST_LINE_SPACING = 1.75f;
    public static float MIN_CLUST_LINE_SPACING = 0.25f;
    public static float MAX_COL_LINE_THRESHOLD = 3.5f;
    public static float LINE_SPACING_TOLERANCE = 0.05f;

    @Override
    public boolean clusterTogether(AdjacencyEdge<GenericSegment> ae, CandidateCluster clustFrom, CandidateCluster clustTo, List<AdjacencyEdge<GenericSegment>> allEdges, HashMap<GenericSegment, List<GenericSegment>> vertNeighbourMap, List<GenericSegment> items) {
        TextSegment segTo;
        TextSegment segFrom = (TextSegment)ae.getNodeFrom();
        if (segFrom == (segTo = (TextSegment)ae.getNodeTo())) {
            return false;
        }
        if (ae.isHorizontal()) {
            float horizGap;
            boolean sameBaseline;
            float distanceFrom;
            if (clustFrom == null) {
                clustFrom = new CandidateCluster();
                clustFrom.getItems().add(segFrom);
                clustFrom.findLinesWidth();
                clustFrom.findBoundingBox();
            }
            if (clustTo == null) {
                clustTo = new CandidateCluster();
                clustTo.getItems().add(segFrom);
                clustTo.findLinesWidth();
                clustFrom.findBoundingBox();
            }
            if (clustFrom == clustTo) {
                return false;
            }
            long t = System.currentTimeMillis();
            List<GenericSegment> neighboursFrom = PageSegmenter.findNearestVerticalNeighbours(segFrom, allEdges, vertNeighbourMap);
            List<GenericSegment> neighboursTo = PageSegmenter.findNearestVerticalNeighbours(segTo, allEdges, vertNeighbourMap);
            TextSegment closestNeighbourFrom = null;
            if (neighboursFrom.get(0) != null && neighboursFrom.get(1) != null) {
                float distanceBelow;
                float distanceAbove = ((TextSegment)neighboursFrom.get(0)).getY1() - segFrom.getY2();
                closestNeighbourFrom = distanceAbove < (distanceBelow = segFrom.getY1() - ((TextSegment)neighboursFrom.get(1)).getY2()) ? (TextSegment)neighboursFrom.get(0) : (TextSegment)neighboursFrom.get(1);
            } else if (neighboursFrom.get(0) != null) {
                closestNeighbourFrom = (TextSegment)neighboursFrom.get(0);
            } else if (neighboursFrom.get(1) != null) {
                closestNeighbourFrom = (TextSegment)neighboursFrom.get(1);
            }
            TextSegment closestNeighbourTo = null;
            if (neighboursTo.get(0) != null && neighboursTo.get(1) != null) {
                float distanceBelow;
                float distanceAbove = ((TextSegment)neighboursTo.get(0)).getY1() - segTo.getY2();
                closestNeighbourTo = distanceAbove < (distanceBelow = segTo.getY1() - ((TextSegment)neighboursTo.get(1)).getY2()) ? (TextSegment)neighboursTo.get(0) : (TextSegment)neighboursTo.get(1);
            } else if (neighboursTo.get(0) != null) {
                closestNeighbourTo = (TextSegment)neighboursTo.get(0);
            } else if (neighboursTo.get(1) != null) {
                closestNeighbourTo = (TextSegment)neighboursTo.get(1);
            }
            TextSegment closestNeighbour = null;
            float neighbourDistance = -1.0f;
            if (closestNeighbourFrom != null && closestNeighbourTo != null) {
                float distanceTo;
                distanceFrom = closestNeighbourFrom.getYmid() < segFrom.getYmid() ? segFrom.getY1() - closestNeighbourFrom.getY2() : closestNeighbourFrom.getY1() - segFrom.getY2();
                if (distanceFrom < (distanceTo = closestNeighbourTo.getYmid() < segTo.getYmid() ? segTo.getY1() - closestNeighbourTo.getY2() : closestNeighbourTo.getY1() - segTo.getY2())) {
                    closestNeighbour = closestNeighbourFrom;
                    neighbourDistance = distanceFrom;
                } else {
                    closestNeighbour = closestNeighbourTo;
                    neighbourDistance = distanceTo;
                }
            } else if (closestNeighbourFrom != null) {
                closestNeighbour = closestNeighbourFrom;
                distanceFrom = closestNeighbourFrom.getYmid() < segFrom.getYmid() ? segFrom.getY1() - closestNeighbourFrom.getY2() : closestNeighbourFrom.getY1() - segFrom.getY2();
                neighbourDistance = distanceFrom;
            } else if (closestNeighbourTo != null) {
                closestNeighbour = closestNeighbourTo;
                float distanceTo = closestNeighbourTo.getYmid() < segTo.getYmid() ? segTo.getY1() - closestNeighbourTo.getY2() : closestNeighbourTo.getY1() - segTo.getY2();
                neighbourDistance = distanceTo;
            }
            float max_horiz_edge_width = 0.75f;
            if (clustFrom.getFoundLines().size() > 2 && clustTo.getFoundLines().size() > 2) {
                max_horiz_edge_width = 0.85f;
            }
            if (clustFrom.getFoundLines().size() > 1 && clustTo.getFoundLines().size() > 1) {
                max_horiz_edge_width = 1.0f;
            }
            if (!(sameBaseline = Utils.within(segFrom.getY1(), segTo.getY1(), Utils.calculateThreshold(segFrom, segTo, 0.2f)))) {
                max_horiz_edge_width = 0.3f;
            }
            float smallestFontSize = ((TextSegment)ae.getNodeFrom()).getFontSize();
            if (((TextSegment)ae.getNodeFrom()).getFontSize() > ((TextSegment)ae.getNodeTo()).getFontSize()) {
                smallestFontSize = ((TextSegment)ae.getNodeTo()).getFontSize();
            }
            return !((horizGap = ae.physicalLength() / smallestFontSize) > max_horiz_edge_width);
        }
        float lineSpacing = ae.getDirection() == 2 ? ae.getNodeTo().getY1() - ae.getNodeFrom().getY1() : ae.getNodeFrom().getY1() - ae.getNodeTo().getY1();
        lineSpacing /= ae.getFontSize();
        if (!Utils.sameFontSize(segFrom, segTo)) {
            return false;
        }
        if (!(lineSpacing <= MAX_CLUST_LINE_SPACING) || !(lineSpacing >= MIN_CLUST_LINE_SPACING)) {
            return false;
        }
        if (clustFrom == null && clustTo == null) {
            return true;
        }
        if (clustFrom == null) {
            if (clustTo.getLineSpacing() == 0.0f || Utils.within(lineSpacing, clustTo.getLineSpacing(), LINE_SPACING_TOLERANCE)) {
                return true;
            }
        } else if (clustTo == null) {
            if (clustFrom.getLineSpacing() == 0.0f || Utils.within(lineSpacing, clustFrom.getLineSpacing(), LINE_SPACING_TOLERANCE)) {
                return true;
            }
        } else {
            if (clustFrom == clustTo) {
                return false;
            }
            boolean sameLineSpacing = Utils.within(clustFrom.getLineSpacing(), clustTo.getLineSpacing(), LINE_SPACING_TOLERANCE);
            return sameLineSpacing && Utils.within(lineSpacing, clustFrom.getLineSpacing(), LINE_SPACING_TOLERANCE) && Utils.within(lineSpacing, clustTo.getLineSpacing(), LINE_SPACING_TOLERANCE);
        }
        return false;
    }

    @Override
    public boolean isValidCluster(CandidateCluster c) {
        c.setCalculatedFields();
        boolean clashingLines = false;
        CompositeSegment<? extends TextSegment> prevLine = null;
        for (CompositeSegment<? extends TextSegment> l : c.getFoundLines()) {
            if (prevLine != null) {
                float lineSpacing = (prevLine.getY1() - l.getY1()) / c.getFontSize();
                if (SegmentUtils.vertIntersect(prevLine, l.getYmid())) {
                    clashingLines = true;
                }
                if (!Utils.within(lineSpacing, c.getLineSpacing(), LINE_SPACING_TOLERANCE)) {
                    return false;
                }
            }
            prevLine = l;
        }
        return !PageSegmenter.checkForChasms(c);
    }
}

