/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Map;
import java.util.Objects;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public abstract class AbstractMapEntry<K, V>
implements Map.Entry<K, V> {
    protected AbstractMapEntry() {
    }

    @Override
    public V setValue(V v) {
        throw new UnsupportedOperationException(Errors.format((short)153, Map.Entry.class));
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return Objects.equals(this.getKey(), entry.getKey()) && Objects.equals(this.getValue(), entry.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
    }

    public String toString() {
        return String.valueOf(this.getKey()) + '=' + AbstractMapEntry.firstLine(this.getValue());
    }

    static String firstLine(Object object) {
        String string = String.valueOf(object);
        return string.substring(0, CharSequences.indexOfLineStart(string, 1, 0));
    }
}

