/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Context;
import org.opengis.metadata.acquisition.Event;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Objective;
import org.opengis.metadata.acquisition.PlatformPass;
import org.opengis.metadata.acquisition.Sequence;
import org.opengis.metadata.acquisition.Trigger;

@XmlType(name="MI_Event_Type", propOrder={"identifier", "trigger", "context", "sequence", "time", "expectedObjectives", "relatedPass", "relatedSensors"})
@XmlRootElement(name="MI_Event")
public class DefaultEvent
extends ISOMetadata
implements Event {
    private static final long serialVersionUID = -519920133287763009L;
    private Trigger trigger;
    private Context context;
    private Sequence sequence;
    private long time = Long.MIN_VALUE;
    private Collection<Objective> expectedObjectives;
    private PlatformPass relatedPass;
    private Collection<Instrument> relatedSensors;

    public DefaultEvent() {
    }

    public DefaultEvent(Event event) {
        super(event);
        if (event != null) {
            this.identifiers = this.singleton(event.getIdentifier(), Identifier.class);
            this.trigger = event.getTrigger();
            this.context = event.getContext();
            this.sequence = event.getSequence();
            this.time = MetadataUtilities.toMilliseconds(event.getTime());
            this.expectedObjectives = this.copyCollection(event.getExpectedObjectives(), Objective.class);
            this.relatedPass = event.getRelatedPass();
            this.relatedSensors = this.copyCollection(event.getRelatedSensors(), Instrument.class);
        }
    }

    public static DefaultEvent castOrCopy(Event event) {
        if (event == null || event instanceof DefaultEvent) {
            return (DefaultEvent)event;
        }
        return new DefaultEvent(event);
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return NonMarshalledAuthority.getMarshallable(this.identifiers);
    }

    public void setIdentifier(Identifier identifier) {
        this.checkWritePermission();
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        NonMarshalledAuthority.setMarshallable(this.identifiers, identifier);
    }

    @Override
    @XmlElement(name="trigger", required=true)
    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger trigger) {
        this.checkWritePermission();
        this.trigger = trigger;
    }

    @Override
    @XmlElement(name="context", required=true)
    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.checkWritePermission();
        this.context = context;
    }

    @Override
    @XmlElement(name="sequence", required=true)
    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.checkWritePermission();
        this.sequence = sequence;
    }

    @Override
    @XmlElement(name="time", required=true)
    public Date getTime() {
        return MetadataUtilities.toDate(this.time);
    }

    public void setTime(Date date) {
        this.checkWritePermission();
        this.time = MetadataUtilities.toMilliseconds(date);
    }

    @XmlElement(name="expectedObjective")
    public Collection<Objective> getExpectedObjectives() {
        this.expectedObjectives = this.nonNullCollection(this.expectedObjectives, Objective.class);
        return this.expectedObjectives;
    }

    public void setExpectedObjectives(Collection<? extends Objective> collection) {
        this.expectedObjectives = this.writeCollection(collection, this.expectedObjectives, Objective.class);
    }

    @Override
    @XmlElement(name="relatedPass")
    public PlatformPass getRelatedPass() {
        return this.relatedPass;
    }

    public void setRelatedPass(PlatformPass platformPass) {
        this.relatedPass = platformPass;
    }

    @Override
    @XmlElement(name="relatedSensor")
    public Collection<? extends Instrument> getRelatedSensors() {
        this.relatedSensors = this.nonNullCollection(this.relatedSensors, Instrument.class);
        return this.relatedSensors;
    }

    public void setRelatedSensors(Collection<? extends Instrument> collection) {
        this.relatedSensors = this.writeCollection(collection, this.relatedSensors, Instrument.class);
    }
}

