/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006.Relationship;

class RelationshipsManager {
    Map<String, Map<String, Relationship>> map = new HashMap<String, Map<String, Relationship>>();

    RelationshipsManager() {
    }

    public void addRelationship(String relsFileName, String id, String type, String target, TargetMode targetMode) {
        String packageName = this.convertRelsFileNameToPackageName(relsFileName);
        Map<String, Relationship> thisPackageRels = this.map.get(packageName);
        if (thisPackageRels == null) {
            thisPackageRels = new HashMap<String, Relationship>();
        }
        thisPackageRels.put(id, new Relationship(type, target, targetMode));
        this.map.put(packageName, thisPackageRels);
    }

    public Relationship getRelationship(String packageName, String id) {
        Map<String, Relationship> thisPackageRels = this.map.get(packageName);
        if (thisPackageRels != null) {
            return thisPackageRels.get(id);
        }
        return null;
    }

    private String convertRelsFileNameToPackageName(String relsFileName) {
        if ("/_rels/.rels".equals(relsFileName)) {
            return "/";
        }
        String tmp = relsFileName;
        tmp = tmp.replaceFirst("\\/_rels\\/", "/");
        tmp = tmp.replaceFirst(".rels\\Z", "");
        return tmp;
    }
}

