/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.speex;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggPacketWriter;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.gagravarr.ogg.audio.OggAudioHeaders;
import org.gagravarr.ogg.audio.OggAudioSetupHeader;
import org.gagravarr.ogg.audio.OggAudioStream;
import org.gagravarr.speex.SpeexAudioData;
import org.gagravarr.speex.SpeexInfo;
import org.gagravarr.speex.SpeexPacket;
import org.gagravarr.speex.SpeexPacketFactory;
import org.gagravarr.speex.SpeexTags;

public class SpeexFile
implements OggAudioStream,
OggAudioHeaders,
Closeable {
    private OggFile ogg;
    private OggPacketReader r;
    private OggPacketWriter w;
    private int sid = -1;
    private SpeexInfo info;
    private SpeexTags tags;
    private List<SpeexAudioData> writtenPackets;

    public SpeexFile(File f) throws IOException, FileNotFoundException {
        this(new OggFile(new FileInputStream(f)));
    }

    public SpeexFile(OggFile ogg) throws IOException {
        this(ogg.getPacketReader());
        this.ogg = ogg;
    }

    public SpeexFile(OggPacketReader r) throws IOException {
        this.r = r;
        OggPacket p = null;
        while ((p = r.getNextPacket()) != null) {
            if (!p.isBeginningOfStream() || p.getData().length <= 10 || !SpeexPacketFactory.isSpeexStream(p)) continue;
            this.sid = p.getSid();
            break;
        }
        if (this.sid == -1) {
            throw new IllegalArgumentException("Supplied File is not Speex");
        }
        this.info = (SpeexInfo)SpeexPacketFactory.create(p);
        this.tags = (SpeexTags)SpeexPacketFactory.create(r.getNextPacketWithSid(this.sid));
    }

    public SpeexFile(OutputStream out) {
        this(out, new SpeexInfo(), new SpeexTags());
    }

    public SpeexFile(OutputStream out, SpeexInfo info, SpeexTags tags) {
        this(out, -1, info, tags);
    }

    public SpeexFile(OutputStream out, int sid, SpeexInfo info, SpeexTags tags) {
        this.ogg = new OggFile(out);
        if (sid > 0) {
            this.w = this.ogg.getPacketWriter(sid);
            this.sid = sid;
        } else {
            this.w = this.ogg.getPacketWriter();
            this.sid = this.w.getSid();
        }
        this.writtenPackets = new ArrayList<SpeexAudioData>();
        this.info = info;
        this.tags = tags;
    }

    public SpeexAudioData getNextAudioPacket() throws IOException {
        OggPacket p = null;
        SpeexPacket sp = null;
        while ((p = this.r.getNextPacketWithSid(this.sid)) != null) {
            sp = SpeexPacketFactory.create(p);
            if (sp instanceof SpeexAudioData) {
                return (SpeexAudioData)sp;
            }
            System.err.println("Skipping non audio packet " + sp + " mid audio stream");
        }
        return null;
    }

    public void skipToGranule(long granulePosition) throws IOException {
        this.r.skipToGranulePosition(this.sid, granulePosition);
    }

    public int getSid() {
        return this.sid;
    }

    public OggStreamIdentifier.OggStreamType getType() {
        return OggStreamIdentifier.SPEEX_AUDIO;
    }

    public SpeexInfo getInfo() {
        return this.info;
    }

    public SpeexTags getTags() {
        return this.tags;
    }

    public OggAudioSetupHeader getSetup() {
        return null;
    }

    public void writeAudioData(SpeexAudioData data) {
        this.writtenPackets.add(data);
    }

    public void close() throws IOException {
        if (this.r != null) {
            this.r = null;
            this.ogg.close();
            this.ogg = null;
        }
        if (this.w != null) {
            this.w.bufferPacket(this.info.write(), true);
            this.w.bufferPacket(this.tags.write(), false);
            long lastGranule = 0L;
            for (SpeexAudioData vd : this.writtenPackets) {
                if (vd.getGranulePosition() >= 0L && lastGranule != vd.getGranulePosition()) {
                    this.w.flush();
                    lastGranule = vd.getGranulePosition();
                    this.w.setGranulePosition(lastGranule);
                }
                this.w.bufferPacket(vd.write());
                if (this.w.getSizePendingFlush() <= 16384) continue;
                this.w.flush();
            }
            this.w.close();
            this.w = null;
            this.ogg.close();
            this.ogg = null;
        }
    }

    public OggFile getOggFile() {
        return this.ogg;
    }
}

