/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.guide.instance;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.FeatureException;
import org.maltparser.core.feature.FeatureVector;
import org.maltparser.core.feature.function.FeatureFunction;
import org.maltparser.core.feature.function.Modifiable;
import org.maltparser.core.feature.value.SingleFeatureValue;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.parser.guide.ClassifierGuide;
import org.maltparser.parser.guide.GuideException;
import org.maltparser.parser.guide.Model;
import org.maltparser.parser.guide.instance.AtomicModel;
import org.maltparser.parser.guide.instance.InstanceModel;
import org.maltparser.parser.history.action.SingleDecision;

public class FeatureDivideModel
implements InstanceModel {
    private Model parent;
    private final SortedMap<Integer, AtomicModel> divideModels;
    private FeatureVector masterFeatureVector;
    private FeatureVector divideFeatureVector;
    private int frequency = 0;
    private FeatureFunction divideFeature;
    private int divideThreshold;
    private AtomicModel masterModel;
    private ArrayList<Integer> divideFeatureIndexVector;

    public FeatureDivideModel(FeatureVector features, Model parent) throws MaltChainedException {
        this.setParent(parent);
        this.setFrequency(0);
        this.initSplitParam(features);
        this.divideModels = new TreeMap<Integer, AtomicModel>();
        if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.BATCH) {
            this.masterModel = new AtomicModel(-1, this.masterFeatureVector, this);
        } else if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.CLASSIFY) {
            this.load();
        }
    }

    public void addInstance(SingleDecision decision) throws MaltChainedException {
        if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.CLASSIFY) {
            throw new GuideException("Can only add instance during learning. ");
        }
        if (!(this.divideFeature.getFeatureValue() instanceof SingleFeatureValue)) {
            throw new GuideException("The divide feature does not have a single value. ");
        }
        this.divideFeature.update();
        if (this.divideModels != null) {
            if (!this.divideModels.containsKey(((SingleFeatureValue)this.divideFeature.getFeatureValue()).getCode())) {
                this.divideModels.put(((SingleFeatureValue)this.divideFeature.getFeatureValue()).getCode(), new AtomicModel(((SingleFeatureValue)this.divideFeature.getFeatureValue()).getCode(), this.divideFeatureVector, this));
            }
        } else {
            throw new GuideException("The feature divide models cannot be found. ");
        }
        ((AtomicModel)this.divideModels.get(((SingleFeatureValue)this.divideFeature.getFeatureValue()).getCode())).addInstance(decision);
    }

    public void noMoreInstances() throws MaltChainedException {
        if (this.divideModels != null) {
            this.divideFeature.updateCardinality();
            for (Integer index : this.divideModels.keySet()) {
                ((AtomicModel)this.divideModels.get(index)).noMoreInstances();
            }
            TreeSet<Integer> removeSet = new TreeSet<Integer>();
            for (Integer index : this.divideModels.keySet()) {
                if (((AtomicModel)this.divideModels.get(index)).getFrequency() > this.divideThreshold) continue;
                ((AtomicModel)this.divideModels.get(index)).moveAllInstances(this.masterModel, this.divideFeature, this.divideFeatureIndexVector);
                removeSet.add(index);
            }
            for (Integer index : removeSet) {
                this.divideModels.remove(index);
            }
        } else {
            throw new GuideException("The feature divide models cannot be found. ");
        }
        this.masterModel.noMoreInstances();
    }

    public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {
        if (this.divideModels != null) {
            for (AtomicModel divideModel : this.divideModels.values()) {
                divideModel.finalizeSentence(dependencyGraph);
            }
        } else {
            throw new GuideException("The feature divide models cannot be found. ");
        }
    }

    public boolean predict(SingleDecision decision) throws MaltChainedException {
        if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.BATCH) {
            throw new GuideException("Can only predict during parsing. ");
        }
        if (!(this.divideFeature.getFeatureValue() instanceof SingleFeatureValue)) {
            throw new GuideException("The divide feature does not have a single value. ");
        }
        if (this.divideModels != null && this.divideModels.containsKey(((SingleFeatureValue)this.divideFeature.getFeatureValue()).getCode())) {
            return ((AtomicModel)this.divideModels.get(((SingleFeatureValue)this.divideFeature.getFeatureValue()).getCode())).predict(decision);
        }
        if (this.masterModel != null && this.masterModel.getFrequency() > 0) {
            return this.masterModel.predict(decision);
        }
        this.getGuide().getConfiguration().getConfigLogger().info("Could not predict the next parser decision because there is no divide or master model that covers the divide value '" + ((SingleFeatureValue)this.divideFeature.getFeatureValue()).getCode() + "', as default" + " class code '1' is used. ");
        decision.addDecision(1);
        return true;
    }

    public FeatureVector predictExtract(SingleDecision decision) throws MaltChainedException {
        return this.getAtomicModel().predictExtract(decision);
    }

    public FeatureVector extract() throws MaltChainedException {
        return this.getAtomicModel().extract();
    }

    private AtomicModel getAtomicModel() throws MaltChainedException {
        if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.BATCH) {
            throw new GuideException("Can only predict during parsing. ");
        }
        if (!(this.divideFeature.getFeatureValue() instanceof SingleFeatureValue)) {
            throw new GuideException("The divide feature does not have a single value. ");
        }
        if (this.divideModels != null && this.divideModels.containsKey(((SingleFeatureValue)this.divideFeature.getFeatureValue()).getCode())) {
            return (AtomicModel)this.divideModels.get(((SingleFeatureValue)this.divideFeature.getFeatureValue()).getCode());
        }
        if (this.masterModel != null && this.masterModel.getFrequency() > 0) {
            return this.masterModel;
        }
        this.getGuide().getConfiguration().getConfigLogger().info("Could not predict the next parser decision because there is no divide or master model that covers the divide value '" + ((SingleFeatureValue)this.divideFeature.getFeatureValue()).getCode() + "', as default" + " class code '1' is used. ");
        return null;
    }

    public void terminate() throws MaltChainedException {
        if (this.divideModels != null) {
            for (AtomicModel divideModel : this.divideModels.values()) {
                divideModel.terminate();
            }
        }
        if (this.masterModel != null) {
            this.masterModel.terminate();
        }
    }

    public void train() throws MaltChainedException {
        for (AtomicModel divideModel : this.divideModels.values()) {
            divideModel.train();
        }
        this.masterModel.train();
        this.save();
        for (AtomicModel divideModel : this.divideModels.values()) {
            divideModel.terminate();
        }
        this.masterModel.terminate();
    }

    protected void initSplitParam(FeatureVector featureVector) throws MaltChainedException {
        if (this.getGuide().getConfiguration().getOptionValue("guide", "data_split_column") == null || this.getGuide().getConfiguration().getOptionValue("guide", "data_split_column").toString().length() == 0) {
            throw new GuideException("The option '--guide-data_split_column' cannot be found, when initializing the data split. ");
        }
        if (this.getGuide().getConfiguration().getOptionValue("guide", "data_split_structure") == null || this.getGuide().getConfiguration().getOptionValue("guide", "data_split_structure").toString().length() == 0) {
            throw new GuideException("The option '--guide-data_split_structure' cannot be found, when initializing the data split. ");
        }
        try {
            String spec = "InputColumn(" + this.getGuide().getConfiguration().getOptionValue("guide", "data_split_column").toString().trim() + ", " + this.getGuide().getConfiguration().getOptionValue("guide", "data_split_structure").toString().trim() + ")";
            this.divideFeature = featureVector.getFeatureModel().identifyFeature(spec);
        }
        catch (FeatureException e) {
            throw new GuideException("The data split feature 'InputColumn(" + this.getGuide().getConfiguration().getOptionValue("guide", "data_split_column").toString() + ", " + this.getGuide().getConfiguration().getOptionValue("guide", "data_split_structure").toString() + ") cannot be initialized. ", e);
        }
        if (!(this.divideFeature instanceof Modifiable)) {
            throw new GuideException("The data split feature 'InputColumn(" + this.getGuide().getConfiguration().getOptionValue("guide", "data_split_column").toString() + ", " + this.getGuide().getConfiguration().getOptionValue("guide", "data_split_structure").toString() + ") does not implement Modifiable interface. ");
        }
        this.divideFeatureIndexVector = new ArrayList();
        for (int i = 0; i < featureVector.size(); ++i) {
            if (!((FeatureFunction)featureVector.get(i)).equals(this.divideFeature)) continue;
            this.divideFeatureIndexVector.add(i);
        }
        this.masterFeatureVector = featureVector;
        this.divideFeatureVector = (FeatureVector)featureVector.clone();
        for (Integer i : this.divideFeatureIndexVector) {
            this.divideFeatureVector.remove(this.divideFeatureVector.get(i));
        }
        try {
            this.divideThreshold = this.getGuide().getConfiguration().getOptionValue("guide", "data_split_threshold").toString() != null ? Integer.parseInt(this.getGuide().getConfiguration().getOptionValue("guide", "data_split_threshold").toString()) : 0;
        }
        catch (NumberFormatException e) {
            throw new GuideException("The --guide-data_split_threshold option is not an integer value. ", e);
        }
    }

    protected void save() throws MaltChainedException {
        try {
            BufferedWriter out = new BufferedWriter(this.getGuide().getConfiguration().getConfigurationDir().getOutputStreamWriter(this.getModelName() + ".dsm"));
            out.write(this.masterModel.getIndex() + "\t" + this.masterModel.getFrequency() + "\n");
            if (this.divideModels != null) {
                for (AtomicModel divideModel : this.divideModels.values()) {
                    out.write(divideModel.getIndex() + "\t" + divideModel.getFrequency() + "\n");
                }
            }
            out.close();
        }
        catch (IOException e) {
            throw new GuideException("Could not write to the guide model settings file '" + this.getModelName() + ".dsm" + "', when " + "saving the guide model settings to file. ", e);
        }
    }

    protected void load() throws MaltChainedException {
        try {
            String line;
            BufferedReader in = new BufferedReader(this.getGuide().getConfiguration().getConfigurationDir().getInputStreamReaderFromConfigFile(this.getModelName() + ".dsm"));
            Pattern tabPattern = Pattern.compile("\t");
            while ((line = in.readLine()) != null) {
                String[] cols = tabPattern.split(line);
                if (cols.length != 2) {
                    throw new GuideException("");
                }
                int code = -1;
                int freq = 0;
                try {
                    code = Integer.parseInt(cols[0]);
                    freq = Integer.parseInt(cols[1]);
                }
                catch (NumberFormatException e) {
                    throw new GuideException("Could not convert a string value into an integer value when loading the feature divide model settings (.fsm). ", e);
                }
                if (code == -1) {
                    this.masterModel = new AtomicModel(-1, this.masterFeatureVector, this);
                    this.masterModel.setFrequency(freq);
                } else if (this.divideModels != null) {
                    this.divideModels.put(code, new AtomicModel(code, this.divideFeatureVector, this));
                    ((AtomicModel)this.divideModels.get(code)).setFrequency(freq);
                }
                this.setFrequency(this.getFrequency() + freq);
            }
            in.close();
        }
        catch (IOException e) {
            throw new GuideException("Could not read from the guide model settings file '" + this.getModelName() + ".dsm" + "', when " + "loading the guide model settings. ", e);
        }
    }

    public Model getParent() {
        return this.parent;
    }

    public ClassifierGuide getGuide() {
        return this.parent.getGuide();
    }

    protected void setParent(Model parent) throws MaltChainedException {
        this.parent = parent;
    }

    public String getModelName() throws MaltChainedException {
        try {
            return this.parent.getModelName();
        }
        catch (NullPointerException e) {
            throw new GuideException("The parent guide model cannot be found. ", e);
        }
    }

    public FeatureVector getMasterFeatureVector() {
        return this.masterFeatureVector;
    }

    public FeatureVector getDivideFeatureVector() {
        return this.divideFeatureVector;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void increaseFrequency() {
        if (this.parent instanceof InstanceModel) {
            ((InstanceModel)this.parent).increaseFrequency();
        }
        ++this.frequency;
    }

    public void decreaseFrequency() {
        if (this.parent instanceof InstanceModel) {
            ((InstanceModel)this.parent).decreaseFrequency();
        }
        --this.frequency;
    }

    protected void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }
}

