# This Makefile.PL for App-Sandy was generated by
# inc::SandyMakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.47.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

use File::ShareDir::Install;
install_share dist => "share";

my %WriteMakefileArgs = (
  "ABSTRACT" => "A straightforward and complete next-generation sequencing read simulator",
  "AUTHOR" => "Thiago L. A. Miller <tmiller\@mochsl.org.br>, J. Leonel Buzzo <lbuzzo\@mochsl.org.br>, Gabriela Guardia <gguardia\@mochsl.org.br>, Fernanda Orpinelli <forpinelli\@mochsl.org.br>, Pedro A. F. Galante <pgalante\@mochsl.org.br>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::ShareDir::Install" => "0.03"
  },
  "DISTNAME" => "App-Sandy",
  "EXE_FILES" => [
    "script/sandy"
  ],
  "LICENSE" => "gpl",
  "NAME" => "App::Sandy",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Compress::BGZF::Writer" => 0,
    "DBIx::Class::Core" => 0,
    "DBIx::Class::Schema" => 0,
    "Data::OptList" => 0,
    "File::Cat" => 0,
    "File::Path" => 0,
    "Getopt::Long" => 0,
    "Hook::AfterRuntime" => 0,
    "IO::Compress::Gzip" => 0,
    "IO::Uncompress::Gunzip" => 0,
    "Import::Into" => 0,
    "List::Util" => 0,
    "Math::Random" => "0.72",
    "Module::Runtime" => 0,
    "Moose" => 0,
    "Moose::Role" => 0,
    "Moose::Util::TypeConstraints" => 0,
    "MooseX::Singleton" => 0,
    "MooseX::StrictConstructor" => 0,
    "MooseX::UndefTolerant" => 0,
    "Parallel::ForkManager" => "1.19",
    "Path::Class" => 0,
    "PerlIO::gzip" => "0.19",
    "Pod::Usage" => 0,
    "Scalar::Util" => 0,
    "Storable" => "2.51",
    "Text::ASCIITable" => 0,
    "Try::Tiny" => 0,
    "base" => 0,
    "constant" => 0,
    "feature" => 0,
    "namespace::autoclean" => 0,
    "strict" => 0,
    "true" => 0,
    "utf8" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Class::Data::Inheritable" => "0.08",
    "Test::Class" => "0.50",
    "Test::Most" => "0.35",
    "Test::UseAllModules" => 0,
    "autodie" => 0
  },
  "VERSION" => "0.19",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "Class::Data::Inheritable" => "0.08",
  "Compress::BGZF::Writer" => 0,
  "DBIx::Class::Core" => 0,
  "DBIx::Class::Schema" => 0,
  "Data::OptList" => 0,
  "File::Cat" => 0,
  "File::Path" => 0,
  "Getopt::Long" => 0,
  "Hook::AfterRuntime" => 0,
  "IO::Compress::Gzip" => 0,
  "IO::Uncompress::Gunzip" => 0,
  "Import::Into" => 0,
  "List::Util" => 0,
  "Math::Random" => "0.72",
  "Module::Runtime" => 0,
  "Moose" => 0,
  "Moose::Role" => 0,
  "Moose::Util::TypeConstraints" => 0,
  "MooseX::Singleton" => 0,
  "MooseX::StrictConstructor" => 0,
  "MooseX::UndefTolerant" => 0,
  "Parallel::ForkManager" => "1.19",
  "Path::Class" => 0,
  "PerlIO::gzip" => "0.19",
  "Pod::Usage" => 0,
  "Scalar::Util" => 0,
  "Storable" => "2.51",
  "Test::Class" => "0.50",
  "Test::Most" => "0.35",
  "Test::UseAllModules" => 0,
  "Text::ASCIITable" => 0,
  "Try::Tiny" => 0,
  "autodie" => 0,
  "base" => 0,
  "constant" => 0,
  "feature" => 0,
  "namespace::autoclean" => 0,
  "strict" => 0,
  "true" => 0,
  "utf8" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
package
MY;
use File::ShareDir::Install qw(postamble);
}

package MY;

use File::ShareDir::Install;

sub install {
	my $self = shift;
	my $inherited = $self->SUPER::install(@_);
	my $new;
	for (split( "\n", $inherited)) {
		if ( /^install :: / ) {
			$_ .= " support_files_install";
		} elsif (/^uninstall ::/) {
			$_ .= " support_files_uninstall";
		}
		$new .= "$_\n";
	}
	return $new;
}

sub postamble {
	my $self = shift;
	my @ret = File::ShareDir::Install::postamble($self);

	my $cmd = q{
SHELL := /bin/bash
support_files_install :
	$(NOECHO) [ `id -u` = 0 ] \
		&& $(ABSPERLRUN) -MExtUtils::Install -e 'pm_to_blib({@ARGV}, '\''$(INST_LIB)'\'')' -- \
			'completions/sandy-completion.bash' '/usr/share/bash-completion/completions/sandy' \
		&& $(ABSPERLRUN) -MExtUtils::Install -e 'pm_to_blib({@ARGV}, '\''$(INST_LIB)'\'')' -- \
			'completions/sandy-completion.zsh' '/usr/share/zsh/site-functions/_sandy'

support_files_uninstall :
	$(NOECHO) rm -f '/usr/share/bash-completion/completions/sandy' \
		'/usr/share/zsh/site-functions/_sandy'
};

	push @ret, $cmd;
	return join "\n", @ret;
}
