package Microsoft::AdCenter::V8::ReportingService::ShareOfVoiceReportColumn;
# Copyright (C) 2012 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V8::ReportingService::ShareOfVoiceReportColumn - Represents "ShareOfVoiceReportColumn" in Microsoft AdCenter Reporting Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AccountId
    AccountName
    AccountNumber
    AdDistribution
    AdGroupId
    AdGroupName
    AverageCpc
    AveragePosition
    BidMatchType
    CampaignId
    CampaignName
    Clicks
    ConversionRate
    Conversions
    CostPerConversion
    Ctr
    CurrentMaxCpc
    ImpressionLostToBidPercent
    ImpressionLostToBudgetPercent
    ImpressionLostToKeywordRelevancePercent
    ImpressionLostToLandingPageRelevancePercent
    ImpressionLostToRankPercent
    ImpressionLostToRelevancePercent
    Impressions
    ImpressionSharePercent
    Keyword
    KeywordId
    KeywordRelevance
    LandingPageRelevance
    LandingPageUserExperience
    Language
    LanguageAndRegion
    MatchType
    ProductName
    QualityScore
    Spend
    TimePeriod

=cut

sub AccountId {
    return 'AccountId';
}

sub AccountName {
    return 'AccountName';
}

sub AccountNumber {
    return 'AccountNumber';
}

sub AdDistribution {
    return 'AdDistribution';
}

sub AdGroupId {
    return 'AdGroupId';
}

sub AdGroupName {
    return 'AdGroupName';
}

sub AverageCpc {
    return 'AverageCpc';
}

sub AveragePosition {
    return 'AveragePosition';
}

sub BidMatchType {
    return 'BidMatchType';
}

sub CampaignId {
    return 'CampaignId';
}

sub CampaignName {
    return 'CampaignName';
}

sub Clicks {
    return 'Clicks';
}

sub ConversionRate {
    return 'ConversionRate';
}

sub Conversions {
    return 'Conversions';
}

sub CostPerConversion {
    return 'CostPerConversion';
}

sub Ctr {
    return 'Ctr';
}

sub CurrentMaxCpc {
    return 'CurrentMaxCpc';
}

sub ImpressionLostToBidPercent {
    return 'ImpressionLostToBidPercent';
}

sub ImpressionLostToBudgetPercent {
    return 'ImpressionLostToBudgetPercent';
}

sub ImpressionLostToKeywordRelevancePercent {
    return 'ImpressionLostToKeywordRelevancePercent';
}

sub ImpressionLostToLandingPageRelevancePercent {
    return 'ImpressionLostToLandingPageRelevancePercent';
}

sub ImpressionLostToRankPercent {
    return 'ImpressionLostToRankPercent';
}

sub ImpressionLostToRelevancePercent {
    return 'ImpressionLostToRelevancePercent';
}

sub Impressions {
    return 'Impressions';
}

sub ImpressionSharePercent {
    return 'ImpressionSharePercent';
}

sub Keyword {
    return 'Keyword';
}

sub KeywordId {
    return 'KeywordId';
}

sub KeywordRelevance {
    return 'KeywordRelevance';
}

sub LandingPageRelevance {
    return 'LandingPageRelevance';
}

sub LandingPageUserExperience {
    return 'LandingPageUserExperience';
}

sub Language {
    return 'Language';
}

sub LanguageAndRegion {
    return 'LanguageAndRegion';
}

sub MatchType {
    return 'MatchType';
}

sub ProductName {
    return 'ProductName';
}

sub QualityScore {
    return 'QualityScore';
}

sub Spend {
    return 'Spend';
}

sub TimePeriod {
    return 'TimePeriod';
}

1;
