/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.functions.Adjust;
import net.sf.saxon.functions.Average;
import net.sf.saxon.functions.BaseURI;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.CodepointEqual;
import net.sf.saxon.functions.CodepointsToString;
import net.sf.saxon.functions.Collection;
import net.sf.saxon.functions.Compare;
import net.sf.saxon.functions.Component;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.Contains;
import net.sf.saxon.functions.Count;
import net.sf.saxon.functions.Current;
import net.sf.saxon.functions.CurrentDateTime;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.functions.CurrentGroupingKey;
import net.sf.saxon.functions.Data;
import net.sf.saxon.functions.DateTimeConstructor;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.functions.DefaultCollation;
import net.sf.saxon.functions.DistinctValues;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocAvailable;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.DocumentUriFn;
import net.sf.saxon.functions.ElementAvailable;
import net.sf.saxon.functions.Empty;
import net.sf.saxon.functions.EndsWith;
import net.sf.saxon.functions.Error;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.Exists;
import net.sf.saxon.functions.ForceCase;
import net.sf.saxon.functions.FormatDate;
import net.sf.saxon.functions.FormatNumber;
import net.sf.saxon.functions.FunctionArity;
import net.sf.saxon.functions.FunctionAvailable;
import net.sf.saxon.functions.FunctionName;
import net.sf.saxon.functions.GenerateId;
import net.sf.saxon.functions.Id;
import net.sf.saxon.functions.Idref;
import net.sf.saxon.functions.InScopePrefixes;
import net.sf.saxon.functions.IndexOf;
import net.sf.saxon.functions.Insert;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.Lang;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.LocalNameFn;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.NameFn;
import net.sf.saxon.functions.NamespaceForPrefix;
import net.sf.saxon.functions.NamespaceUriFn;
import net.sf.saxon.functions.Nilled;
import net.sf.saxon.functions.NodeNameFn;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.functions.NormalizeUnicode;
import net.sf.saxon.functions.NotFn;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.Put;
import net.sf.saxon.functions.QNameFn;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.Remove;
import net.sf.saxon.functions.Replace;
import net.sf.saxon.functions.ResolveQName;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.functions.Root;
import net.sf.saxon.functions.Rounding;
import net.sf.saxon.functions.StartsWith;
import net.sf.saxon.functions.StaticBaseURI;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.StringLength;
import net.sf.saxon.functions.StringToCodepoints;
import net.sf.saxon.functions.Subsequence;
import net.sf.saxon.functions.Substring;
import net.sf.saxon.functions.SubstringAfter;
import net.sf.saxon.functions.SubstringBefore;
import net.sf.saxon.functions.Sum;
import net.sf.saxon.functions.SystemProperty;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.functions.Trace;
import net.sf.saxon.functions.Translate;
import net.sf.saxon.functions.TreatFn;
import net.sf.saxon.functions.TypeAvailable;
import net.sf.saxon.functions.Unordered;
import net.sf.saxon.functions.UnparsedEntity;
import net.sf.saxon.functions.UnparsedText;
import net.sf.saxon.functions.UnparsedTextAvailable;
import net.sf.saxon.functions.UnparsedTextLines;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public abstract class StandardFunction {
    public static Value EMPTY = EmptySequence.getInstance();
    public static final int CORE = 1;
    public static final int XSLT = 2;
    public static final int USE_WHEN = 4;
    public static final int XQUPDATE = 8;
    public static final int XPATH30 = 16;
    public static final int INTERNAL = 32;
    public static final int XSLT30 = 64;
    private static HashMap<String, Entry> functionTable = new HashMap(200);
    protected static ItemType SAME_AS_FIRST_ARGUMENT = NodeKindTest.NAMESPACE;

    private StandardFunction() {
    }

    public static Entry register(String name, Class implementationClass, int opcode, int minArguments, int maxArguments, ItemType itemType, int cardinality, int applicability) {
        Entry e = StandardFunction.makeEntry(name, implementationClass, opcode, minArguments, maxArguments, itemType, cardinality, applicability);
        functionTable.put(name, e);
        return e;
    }

    public static Entry makeEntry(String name, Class implementationClass, int opcode, int minArguments, int maxArguments, ItemType itemType, int cardinality, int applicability) {
        Entry e = new Entry();
        int hash = name.indexOf(35);
        e.name = hash < 0 ? name : name.substring(0, hash);
        e.implementationClass = implementationClass;
        e.opcode = opcode;
        e.minArguments = minArguments;
        e.maxArguments = maxArguments;
        e.itemType = itemType;
        e.cardinality = cardinality;
        e.applicability = applicability;
        if (maxArguments > 100) {
            e.argumentTypes = new SequenceType[1];
            e.resultIfEmpty = new Value[1];
        } else {
            e.argumentTypes = new SequenceType[maxArguments];
            e.resultIfEmpty = new Value[maxArguments];
        }
        return e;
    }

    public static void arg(Entry e, int a, ItemType type, int cardinality, Value resultIfEmpty) {
        try {
            e.argumentTypes[a] = SequenceType.makeSequenceType(type, cardinality);
            e.resultIfEmpty[a] = resultIfEmpty;
        }
        catch (ArrayIndexOutOfBoundsException err) {
            System.err.println("Internal Saxon error: Can't set argument " + a + " of " + e.name);
        }
    }

    public static Entry getFunction(String name, int arity) {
        Entry e = functionTable.get(name + '#' + arity);
        if (e != null) {
            return e;
        }
        return functionTable.get(name);
    }

    static {
        Entry e = StandardFunction.register("abs", Rounding.class, 4, 1, 1, SAME_AS_FIRST_ARGUMENT, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.NUMERIC, 24576, EMPTY);
        e = StandardFunction.register("adjust-date-to-timezone", Adjust.class, 0, 1, 2, BuiltInAtomicType.DATE, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE, 24576, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.DAY_TIME_DURATION, 24576, null);
        e = StandardFunction.register("adjust-dateTime-to-timezone", Adjust.class, 0, 1, 2, BuiltInAtomicType.DATE_TIME, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.DAY_TIME_DURATION, 24576, null);
        e = StandardFunction.register("adjust-time-to-timezone", Adjust.class, 0, 1, 2, BuiltInAtomicType.TIME, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.TIME, 24576, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.DAY_TIME_DURATION, 24576, null);
        e = StandardFunction.register("avg", Average.class, 0, 1, 1, BuiltInAtomicType.ANY_ATOMIC, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
        e = StandardFunction.register("base-uri", BaseURI.class, 0, 0, 1, BuiltInAtomicType.ANY_URI, 24576, 1);
        StandardFunction.arg(e, 0, Type.NODE_TYPE, 24576, EMPTY);
        e = StandardFunction.register("boolean", BooleanFn.class, 0, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, null);
        e = StandardFunction.register("ceiling", Rounding.class, 1, 1, 1, SAME_AS_FIRST_ARGUMENT, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.NUMERIC, 24576, EMPTY);
        e = StandardFunction.register("codepoint-equal", CodepointEqual.class, 0, 2, 2, BuiltInAtomicType.BOOLEAN, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 24576, EMPTY);
        e = StandardFunction.register("codepoints-to-string", CodepointsToString.class, 0, 1, 1, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.INTEGER, 57344, null);
        e = StandardFunction.register("collection", Collection.class, 0, 0, 1, Type.NODE_TYPE, 57344, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        e = StandardFunction.register("compare", Compare.class, 0, 2, 3, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 24576, EMPTY);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("concat", Concat.class, 0, 2, Integer.MAX_VALUE, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.ANY_ATOMIC, 24576, null);
        e = StandardFunction.register("contains", Contains.class, 0, 2, 3, BuiltInAtomicType.BOOLEAN, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 24576, BooleanValue.TRUE);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("count", Count.class, 0, 1, 1, BuiltInAtomicType.INTEGER, 16384, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, Int64Value.ZERO);
        StandardFunction.register("current", Current.class, 0, 0, 0, Type.ITEM_TYPE, 16384, 2);
        StandardFunction.register("current-date", CurrentDateTime.class, 0, 0, 0, BuiltInAtomicType.DATE, 16384, 1);
        StandardFunction.register("current-dateTime", CurrentDateTime.class, 0, 0, 0, BuiltInAtomicType.DATE_TIME, 16384, 1);
        StandardFunction.register("current-time", CurrentDateTime.class, 0, 0, 0, BuiltInAtomicType.TIME, 16384, 1);
        StandardFunction.register("current-group", CurrentGroup.class, 0, 0, 0, Type.ITEM_TYPE, 57344, 2);
        StandardFunction.register("current-grouping-key", CurrentGroupingKey.class, 0, 0, 0, BuiltInAtomicType.ANY_ATOMIC, 24576, 2);
        e = StandardFunction.register("data#0", Data.class, 0, 0, 1, BuiltInAtomicType.ANY_ATOMIC, 8192, 16);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, EMPTY);
        e = StandardFunction.register("data#1", Data.class, 0, 1, 1, BuiltInAtomicType.ANY_ATOMIC, 57344, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, EMPTY);
        e = StandardFunction.register("dateTime", DateTimeConstructor.class, 0, 2, 2, BuiltInAtomicType.DATE_TIME, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE, 24576, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.TIME, 24576, EMPTY);
        e = StandardFunction.register("day-from-date", Component.class, 197129, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE, 24576, EMPTY);
        e = StandardFunction.register("day-from-dateTime", Component.class, 197127, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        e = StandardFunction.register("days-from-duration", Component.class, 197126, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DURATION, 24576, EMPTY);
        e = StandardFunction.register("deep-equal", DeepEqual.class, 0, 2, 3, BuiltInAtomicType.BOOLEAN, 16384, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, null);
        StandardFunction.arg(e, 1, Type.ITEM_TYPE, 57344, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("default-collation", DefaultCollation.class, 0, 0, 0, BuiltInAtomicType.STRING, 16384, 1);
        e = StandardFunction.register("distinct-values", DistinctValues.class, 0, 1, 2, BuiltInAtomicType.ANY_ATOMIC, 57344, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("doc", Doc.class, 0, 1, 1, NodeKindTest.DOCUMENT, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, EMPTY);
        e = StandardFunction.register("doc-available", DocAvailable.class, 0, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, BooleanValue.FALSE);
        e = StandardFunction.register("document", DocumentFn.class, 0, 1, 2, Type.NODE_TYPE, 57344, 2);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, null);
        StandardFunction.arg(e, 1, Type.NODE_TYPE, 16384, null);
        e = StandardFunction.register("document-uri#0", DocumentUriFn.class, 0, 0, 1, BuiltInAtomicType.ANY_URI, 24576, 16);
        StandardFunction.arg(e, 0, Type.NODE_TYPE, 24576, EMPTY);
        e = StandardFunction.register("document-uri#1", DocumentUriFn.class, 0, 1, 1, BuiltInAtomicType.ANY_URI, 24576, 1);
        StandardFunction.arg(e, 0, Type.NODE_TYPE, 24576, EMPTY);
        e = StandardFunction.register("empty", Empty.class, 0, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, BooleanValue.TRUE);
        e = StandardFunction.register("ends-with", EndsWith.class, 0, 2, 3, BuiltInAtomicType.BOOLEAN, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 24576, BooleanValue.TRUE);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("element-available", ElementAvailable.class, 0, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 6);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("element-with-id", Id.class, 1, 1, 2, NodeKindTest.ELEMENT, 57344, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 57344, EMPTY);
        StandardFunction.arg(e, 1, Type.NODE_TYPE, 16384, null);
        e = StandardFunction.register("encode-for-uri", EscapeURI.class, 1, 1, 1, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        e = StandardFunction.register("escape-html-uri", EscapeURI.class, 3, 1, 1, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        e = StandardFunction.register("error", Error.class, 0, 0, 3, Type.ITEM_TYPE, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.QNAME, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 2, Type.ITEM_TYPE, 57344, null);
        e = StandardFunction.register("exactly-one", TreatFn.class, 16384, 1, 1, SAME_AS_FIRST_ARGUMENT, 16384, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 16384, null);
        e = StandardFunction.register("exists", Exists.class, 0, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, BooleanValue.FALSE);
        e = StandardFunction.register("floor", Rounding.class, 0, 1, 1, SAME_AS_FIRST_ARGUMENT, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.NUMERIC, 24576, EMPTY);
        e = StandardFunction.register("format-date", FormatDate.class, 521, 2, 5, BuiltInAtomicType.STRING, 16384, 18);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 3, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 4, BuiltInAtomicType.STRING, 24576, null);
        e = StandardFunction.register("format-dateTime", FormatDate.class, 519, 2, 5, BuiltInAtomicType.STRING, 16384, 18);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE_TIME, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 3, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 4, BuiltInAtomicType.STRING, 24576, null);
        e = StandardFunction.register("format-number", FormatNumber.class, 0, 2, 3, BuiltInAtomicType.STRING, 16384, 18);
        StandardFunction.arg(e, 0, BuiltInAtomicType.NUMERIC, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("format-time", FormatDate.class, 520, 2, 5, BuiltInAtomicType.STRING, 16384, 18);
        StandardFunction.arg(e, 0, BuiltInAtomicType.TIME, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 3, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 4, BuiltInAtomicType.STRING, 24576, null);
        e = StandardFunction.register("function-arity", FunctionArity.class, 0, 1, 1, BuiltInAtomicType.INTEGER, 16384, 16);
        StandardFunction.arg(e, 0, AnyFunctionType.getInstance(), 16384, null);
        e = StandardFunction.register("function-available", FunctionAvailable.class, 0, 1, 2, BuiltInAtomicType.BOOLEAN, 16384, 6);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.INTEGER, 16384, null);
        e = StandardFunction.register("function-name", FunctionName.class, 0, 1, 1, BuiltInAtomicType.QNAME, 24576, 16);
        StandardFunction.arg(e, 0, AnyFunctionType.getInstance(), 16384, null);
        e = StandardFunction.register("generate-id", GenerateId.class, 0, 0, 1, BuiltInAtomicType.STRING, 16384, 18);
        StandardFunction.arg(e, 0, Type.NODE_TYPE, 24576, StringValue.EMPTY_STRING);
        e = StandardFunction.register("hours-from-dateTime", Component.class, 262663, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        e = StandardFunction.register("hours-from-duration", Component.class, 262662, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DURATION, 24576, EMPTY);
        e = StandardFunction.register("hours-from-time", Component.class, 262664, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.TIME, 24576, EMPTY);
        e = StandardFunction.register("id", Id.class, 0, 1, 2, NodeKindTest.ELEMENT, 57344, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 57344, EMPTY);
        StandardFunction.arg(e, 1, Type.NODE_TYPE, 16384, null);
        e = StandardFunction.register("idref", Idref.class, 0, 1, 2, Type.NODE_TYPE, 57344, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 57344, EMPTY);
        StandardFunction.arg(e, 1, Type.NODE_TYPE, 16384, null);
        StandardFunction.register("implicit-timezone", CurrentDateTime.class, 0, 0, 0, BuiltInAtomicType.DAY_TIME_DURATION, 16384, 1);
        e = StandardFunction.register("in-scope-prefixes", InScopePrefixes.class, 0, 1, 1, BuiltInAtomicType.STRING, 57344, 1);
        StandardFunction.arg(e, 0, NodeKindTest.ELEMENT, 16384, null);
        e = StandardFunction.register("index-of", IndexOf.class, 0, 2, 3, BuiltInAtomicType.INTEGER, 57344, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.ANY_ATOMIC, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("insert-before", Insert.class, 0, 3, 3, Type.ITEM_TYPE, 57344, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.INTEGER, 16384, null);
        StandardFunction.arg(e, 2, Type.ITEM_TYPE, 57344, null);
        e = StandardFunction.register("iri-to-uri", EscapeURI.class, 2, 1, 1, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        e = StandardFunction.register("key", KeyFn.class, 0, 2, 3, Type.NODE_TYPE, 57344, 2);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
        StandardFunction.arg(e, 2, Type.NODE_TYPE, 16384, null);
        e = StandardFunction.register("lang", Lang.class, 0, 1, 2, BuiltInAtomicType.BOOLEAN, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, Type.NODE_TYPE, 16384, null);
        StandardFunction.register("last", Last.class, 0, 0, 0, BuiltInAtomicType.INTEGER, 16384, 1);
        e = StandardFunction.register("local-name", LocalNameFn.class, 0, 0, 1, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, Type.NODE_TYPE, 24576, StringValue.EMPTY_STRING);
        e = StandardFunction.register("local-name-from-QName", Component.class, 524818, 1, 1, BuiltInAtomicType.NCNAME, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.QNAME, 24576, EMPTY);
        e = StandardFunction.register("lower-case", ForceCase.class, 1, 1, 1, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        e = StandardFunction.register("matches", Matches.class, 0, 2, 3, BuiltInAtomicType.BOOLEAN, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("max", Minimax.class, 3, 1, 2, BuiltInAtomicType.ANY_ATOMIC, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("min", Minimax.class, 2, 1, 2, BuiltInAtomicType.ANY_ATOMIC, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("minutes-from-dateTime", Component.class, 328199, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        e = StandardFunction.register("minutes-from-duration", Component.class, 328198, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DURATION, 24576, EMPTY);
        e = StandardFunction.register("minutes-from-time", Component.class, 328200, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.TIME, 24576, EMPTY);
        e = StandardFunction.register("month-from-date", Component.class, 131593, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE, 24576, EMPTY);
        e = StandardFunction.register("month-from-dateTime", Component.class, 131591, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        e = StandardFunction.register("months-from-duration", Component.class, 131590, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DURATION, 24576, EMPTY);
        e = StandardFunction.register("name", NameFn.class, 0, 0, 1, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, Type.NODE_TYPE, 24576, StringValue.EMPTY_STRING);
        e = StandardFunction.register("namespace-uri", NamespaceUriFn.class, 0, 0, 1, BuiltInAtomicType.ANY_URI, 16384, 1);
        StandardFunction.arg(e, 0, Type.NODE_TYPE, 24576, StringValue.EMPTY_STRING);
        e = StandardFunction.register("namespace-uri-for-prefix", NamespaceForPrefix.class, 0, 2, 2, BuiltInAtomicType.ANY_URI, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, NodeKindTest.ELEMENT, 16384, null);
        e = StandardFunction.register("namespace-uri-from-QName", Component.class, 590354, 1, 1, BuiltInAtomicType.ANY_URI, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.QNAME, 24576, EMPTY);
        e = StandardFunction.register("nilled", Nilled.class, 0, 1, 1, BuiltInAtomicType.BOOLEAN, 24576, 1);
        StandardFunction.arg(e, 0, Type.NODE_TYPE, 24576, EMPTY);
        e = StandardFunction.register("node-name#0", NodeNameFn.class, 0, 0, 1, BuiltInAtomicType.QNAME, 24576, 16);
        StandardFunction.arg(e, 0, Type.NODE_TYPE, 24576, EMPTY);
        e = StandardFunction.register("node-name#1", NodeNameFn.class, 0, 1, 1, BuiltInAtomicType.QNAME, 24576, 1);
        StandardFunction.arg(e, 0, Type.NODE_TYPE, 24576, EMPTY);
        e = StandardFunction.register("not", NotFn.class, 0, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, BooleanValue.TRUE);
        StandardFunction.register("normalize-space", NormalizeSpace.class, 0, 0, 1, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.register("normalize-space#0", NormalizeSpace.class, 0, 0, 0, BuiltInAtomicType.STRING, 16384, 1);
        e = StandardFunction.register("normalize-space#1", NormalizeSpace.class, 0, 1, 1, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        e = StandardFunction.register("normalize-unicode", NormalizeUnicode.class, 0, 1, 2, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("number", NumberFn.class, 0, 0, 1, BuiltInAtomicType.DOUBLE, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.ANY_ATOMIC, 24576, DoubleValue.NaN);
        e = StandardFunction.register("one-or-more", TreatFn.class, 49152, 1, 1, SAME_AS_FIRST_ARGUMENT, 49152, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 49152, null);
        StandardFunction.register("position", Position.class, 0, 0, 0, BuiltInAtomicType.INTEGER, 16384, 1);
        e = StandardFunction.register("prefix-from-QName", Component.class, 655890, 1, 1, BuiltInAtomicType.NCNAME, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.QNAME, 24576, EMPTY);
        e = StandardFunction.register("put", Put.class, 0, 2, 2, AnyItemType.getInstance(), 24576, 8);
        StandardFunction.arg(e, 0, Type.NODE_TYPE, 16384, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("QName", QNameFn.class, 0, 2, 2, BuiltInAtomicType.QNAME, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("regex-group", RegexGroup.class, 0, 1, 1, BuiltInAtomicType.STRING, 16384, 2);
        StandardFunction.arg(e, 0, BuiltInAtomicType.INTEGER, 16384, null);
        e = StandardFunction.register("remove", Remove.class, 0, 2, 2, SAME_AS_FIRST_ARGUMENT, 57344, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.INTEGER, 16384, null);
        e = StandardFunction.register("replace", Replace.class, 0, 3, 4, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 3, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("resolve-QName", ResolveQName.class, 0, 2, 2, BuiltInAtomicType.QNAME, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, EMPTY);
        StandardFunction.arg(e, 1, NodeKindTest.ELEMENT, 16384, null);
        e = StandardFunction.register("resolve-uri", ResolveURI.class, 0, 1, 2, BuiltInAtomicType.ANY_URI, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("reverse", Reverse.class, 0, 1, 1, Type.ITEM_TYPE, 57344, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, EMPTY);
        e = StandardFunction.register("root", Root.class, 0, 0, 1, Type.NODE_TYPE, 24576, 1);
        StandardFunction.arg(e, 0, Type.NODE_TYPE, 24576, EMPTY);
        e = StandardFunction.register("round#1", Rounding.class, 2, 1, 1, SAME_AS_FIRST_ARGUMENT, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.NUMERIC, 24576, EMPTY);
        e = StandardFunction.register("round#2", Rounding.class, 2, 2, 2, SAME_AS_FIRST_ARGUMENT, 24576, 16);
        StandardFunction.arg(e, 0, BuiltInAtomicType.NUMERIC, 24576, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.INTEGER, 16384, null);
        e = StandardFunction.register("round-half-to-even", Rounding.class, 3, 1, 2, SAME_AS_FIRST_ARGUMENT, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.NUMERIC, 24576, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.INTEGER, 16384, null);
        e = StandardFunction.register("seconds-from-dateTime", Component.class, 393735, 1, 1, BuiltInAtomicType.DECIMAL, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        e = StandardFunction.register("seconds-from-duration", Component.class, 393734, 1, 1, BuiltInAtomicType.DECIMAL, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DURATION, 24576, EMPTY);
        e = StandardFunction.register("seconds-from-time", Component.class, 393736, 1, 1, BuiltInAtomicType.DECIMAL, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.TIME, 24576, EMPTY);
        e = StandardFunction.register("starts-with", StartsWith.class, 0, 2, 3, BuiltInAtomicType.BOOLEAN, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 24576, BooleanValue.TRUE);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("static-base-uri", StaticBaseURI.class, 0, 0, 0, BuiltInAtomicType.ANY_URI, 24576, 1);
        e = StandardFunction.register("string", StringFn.class, 0, 0, 1, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 24576, StringValue.EMPTY_STRING);
        StandardFunction.register("string-length", StringLength.class, 0, 0, 1, BuiltInAtomicType.INTEGER, 16384, 1);
        StandardFunction.register("string-length#0", StringLength.class, 0, 0, 0, BuiltInAtomicType.INTEGER, 16384, 1);
        e = StandardFunction.register("string-length#1", StringLength.class, 0, 1, 1, BuiltInAtomicType.INTEGER, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        e = StandardFunction.register("string-join#1", StringJoin.class, 0, 1, 2, BuiltInAtomicType.STRING, 16384, 16);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 57344, StringValue.EMPTY_STRING);
        e = StandardFunction.register("string-join#2", StringJoin.class, 0, 2, 2, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 57344, StringValue.EMPTY_STRING);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("string-to-codepoints", StringToCodepoints.class, 0, 1, 1, BuiltInAtomicType.INTEGER, 57344, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, EMPTY);
        e = StandardFunction.register("subsequence", Subsequence.class, 0, 2, 3, SAME_AS_FIRST_ARGUMENT, 57344, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.NUMERIC, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.NUMERIC, 16384, null);
        e = StandardFunction.register("substring", Substring.class, 0, 2, 3, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        StandardFunction.arg(e, 1, BuiltInAtomicType.NUMERIC, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.NUMERIC, 16384, null);
        e = StandardFunction.register("substring-after", SubstringAfter.class, 0, 2, 3, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("substring-before", SubstringBefore.class, 0, 2, 3, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("sum", Sum.class, 0, 1, 2, BuiltInAtomicType.ANY_ATOMIC, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.ANY_ATOMIC, 57344, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.ANY_ATOMIC, 24576, null);
        e = StandardFunction.register("system-property", SystemProperty.class, 0, 1, 1, BuiltInAtomicType.STRING, 16384, 6);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("timezone-from-date", Component.class, 459273, 1, 1, BuiltInAtomicType.DAY_TIME_DURATION, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE, 24576, EMPTY);
        e = StandardFunction.register("timezone-from-dateTime", Component.class, 459271, 1, 1, BuiltInAtomicType.DAY_TIME_DURATION, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        e = StandardFunction.register("timezone-from-time", Component.class, 459272, 1, 1, BuiltInAtomicType.DAY_TIME_DURATION, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.TIME, 24576, EMPTY);
        e = StandardFunction.register("trace", Trace.class, 0, 2, 2, SAME_AS_FIRST_ARGUMENT, 57344, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("translate", Translate.class, 0, 3, 3, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("tokenize", Tokenize.class, 0, 2, 3, BuiltInAtomicType.STRING, 57344, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, EMPTY);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("type-available", TypeAvailable.class, 0, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 6);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("unordered", Unordered.class, 0, 1, 1, SAME_AS_FIRST_ARGUMENT, 57344, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 57344, EMPTY);
        e = StandardFunction.register("upper-case", ForceCase.class, 0, 1, 1, BuiltInAtomicType.STRING, 16384, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        e = StandardFunction.register("unparsed-entity-uri", UnparsedEntity.class, UnparsedEntity.URI, 1, 1, BuiltInAtomicType.ANY_URI, 16384, 2);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("unparsed-entity-uri_9999_", UnparsedEntity.class, UnparsedEntity.URI, 2, 2, BuiltInAtomicType.STRING, 16384, 32);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 1, Type.NODE_TYPE, 16384, null);
        e = StandardFunction.register("unparsed-entity-public-id", UnparsedEntity.class, UnparsedEntity.PUBLIC_ID, 1, 1, BuiltInAtomicType.STRING, 16384, 2);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("unparsed-entity-public-id_9999_", UnparsedEntity.class, UnparsedEntity.PUBLIC_ID, 2, 2, BuiltInAtomicType.STRING, 16384, 32);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 1, Type.NODE_TYPE, 16384, null);
        e = StandardFunction.register("unparsed-text", UnparsedText.class, 0, 1, 2, BuiltInAtomicType.STRING, 24576, 18);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("unparsed-text-available", UnparsedTextAvailable.class, 0, 1, 2, BuiltInAtomicType.BOOLEAN, 16384, 18);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("unparsed-text-lines", UnparsedTextLines.class, 0, 1, 2, BuiltInAtomicType.STRING, 57344, 64);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("year-from-date", Component.class, 66057, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE, 24576, EMPTY);
        e = StandardFunction.register("year-from-dateTime", Component.class, 66055, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        e = StandardFunction.register("years-from-duration", Component.class, 66054, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1);
        StandardFunction.arg(e, 0, BuiltInAtomicType.DURATION, 24576, EMPTY);
        e = StandardFunction.register("zero-or-one", TreatFn.class, 24576, 1, 1, SAME_AS_FIRST_ARGUMENT, 24576, 1);
        StandardFunction.arg(e, 0, Type.ITEM_TYPE, 24576, null);
    }

    public static class Entry
    implements Serializable {
        public String name;
        public Class implementationClass;
        public int opcode;
        public int minArguments;
        public int maxArguments;
        public ItemType itemType;
        public int cardinality;
        public int applicability;
        public SequenceType[] argumentTypes;
        public Value[] resultIfEmpty;
    }
}

