/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.arnx.jsonic.JSON;

public class GatewayFilter
implements Filter {
    public static final String GATEWAY_KEY = Config.class.getName();
    Map<Pattern, Config> locations = new LinkedHashMap<Pattern, Config>();
    ServletContext context;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        JSON jSON = new JSON();
        jSON.setContext(this);
        String string = filterConfig.getInitParameter("config");
        if (string == null) {
            string = "";
        }
        Map map = jSON.parse((CharSequence)string, Map.class);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Field field : Config.class.getFields()) {
            linkedHashMap.put(field.getName(), map.get(field.getName()));
        }
        Config config = (Config)jSON.convert(linkedHashMap, (Type)((Object)Config.class));
        for (Map.Entry entry : map.entrySet()) {
            if (linkedHashMap.containsKey(entry.getKey()) || !(entry.getValue() instanceof Map)) continue;
            Map map2 = (Map)entry.getValue();
            for (Map.Entry entry2 : linkedHashMap.entrySet()) {
                if (map2.get(entry2.getKey()) != null) continue;
                map2.put(entry2.getKey(), entry2.getValue());
            }
            Config config2 = (Config)jSON.convert(map2, (Type)((Object)Config.class));
            this.locations.put(Pattern.compile("^" + entry.getKey() + "$"), config2);
        }
        this.locations.put(Pattern.compile(".*"), config);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    protected void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object object;
        Map.Entry<Pattern, Config> entry22;
        if (httpServletRequest.getAttribute(GATEWAY_KEY) != null) {
            filterChain.doFilter(httpServletRequest, httpServletResponse);
            return;
        }
        String string = httpServletRequest.getContextPath().equals("/") ? httpServletRequest.getRequestURI() : httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
        Matcher matcher = null;
        Config config = null;
        for (Map.Entry<Pattern, Config> entry22 : this.locations.entrySet()) {
            object = entry22.getKey();
            Matcher object2 = ((Pattern)object).matcher(string);
            if (!object2.matches()) continue;
            matcher = object2;
            config = entry22.getValue();
            break;
        }
        Object object3 = null;
        if (config.access != null) {
            boolean bl = false;
            for (String string2 : config.access) {
                if (!httpServletRequest.isUserInRole(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                httpServletResponse.sendError(403, "Forbidden");
                return;
            }
        }
        if (config.encoding != null) {
            httpServletRequest.setCharacterEncoding(config.encoding);
            httpServletResponse.setCharacterEncoding(config.encoding);
        }
        if (config.locale != null) {
            httpServletResponse.setLocale(config.locale);
        }
        if (config.expire != null && config.expire.booleanValue()) {
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.setHeader("Expires", "Tue, 29 Feb 2000 12:00:00 GMT");
        }
        if (config.compression != null && config.compression.booleanValue()) {
            entry22 = httpServletRequest.getHeaders("Accept-Encoding");
            while (entry22.hasMoreElements()) {
                object = (String)entry22.nextElement();
                if (((String)object).indexOf("gzip") == -1) continue;
                httpServletResponse.setHeader("Content-Encoding", ((String)object).indexOf("x-gzip") != -1 ? "x-gzip" : "gzip");
                httpServletResponse = new GZIPResponse(httpServletResponse);
                break;
            }
        }
        if (config.forward != null) {
            try {
                object3 = new URI(matcher.replaceAll(config.forward));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ServletException(uRISyntaxException);
            }
        }
        httpServletRequest.setAttribute(GATEWAY_KEY, config);
        if (object3 != null) {
            entry22 = this.context.getRequestDispatcher(((URI)object3).toString());
            entry22.forward(httpServletRequest, httpServletResponse);
        } else {
            filterChain.doFilter(httpServletRequest, httpServletResponse);
        }
        if (httpServletResponse instanceof GZIPResponse) {
            ((GZIPResponse)httpServletResponse).close();
        }
    }

    public void destroy() {
        this.locations = null;
    }

    class GZIPResponse
    extends HttpServletResponseWrapper {
        ServletOutputStream out;
        PrintWriter writer;

        public GZIPResponse(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
            this.out = null;
            this.writer = null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.out == null) {
                this.out = new ServletOutputStream(){
                    GZIPOutputStream cout;
                    {
                        this.cout = new GZIPOutputStream(GZIPResponse.super.getOutputStream());
                    }

                    public void write(byte[] byArray, int n, int n2) throws IOException {
                        this.cout.write(byArray, n, n2);
                    }

                    public void write(byte[] byArray) throws IOException {
                        this.cout.write(byArray);
                    }

                    public void write(int n) throws IOException {
                        this.cout.write(n);
                    }

                    public void flush() throws IOException {
                        this.cout.flush();
                    }

                    public void close() throws IOException {
                        this.cout.close();
                    }
                };
            }
            return this.out;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding()));
            }
            return this.writer;
        }

        public void close() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
            } else if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
    }

    class Config {
        public String encoding = null;
        public Boolean compression = false;
        public Boolean expire = false;
        public String forward = null;
        public Set<String> access = null;
        public Locale locale = null;

        Config() {
        }
    }
}

